/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.sfc.opplugin.manuftech;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bd.mpdm.common.manuftech.ManuftechUtil;
import kd.bd.mpdm.common.manuftech.utils.ManuftechCreateBillUtil;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.mmc.sfc.common.dailyplan.utils.MydailyPlanUtil;
import kd.mmc.sfc.common.manuftech.utils.ChangeTechnicsBillEntryStatus;
import kd.mmc.sfc.common.manuftech.utils.MroManuftechUtil;
import kd.mmc.sfc.opplugin.manuftech.validator.MROManuftechValidator;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MROManuftechOp
extends AbstractOperationServicePlugIn {
    private static final Log logger = LogFactory.getLog(MROManuftechOp.class);

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator((AbstractValidator)new MROManuftechValidator());
    }

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        ManuftechUtil.setEntityColumn((PreparePropertysEventArgs)e);
        e.getFieldKeys().add("project");
        e.getFieldKeys().add("workcard");
        e.getFieldKeys().add("workhourunit");
        e.getFieldKeys().add("opractualbegintime");
        e.getFieldKeys().add("opractualendtime");
        e.getFieldKeys().add("oprassignor");
        e.getFieldKeys().add("oprfunctionlocation");
        e.getFieldKeys().add("oprmodifier");
        e.getFieldKeys().add("oprmodifytime");
        e.getFieldKeys().add("oprmulreceiver");
        e.getFieldKeys().add("oprprocessgroup");
        e.getFieldKeys().add("oprprofessiona");
        e.getFieldKeys().add("oprstudystatus");
        e.getFieldKeys().add("oprtask");
        e.getFieldKeys().add("oprwbs");
        e.getFieldKeys().add("oprworkgroup");
        e.getFieldKeys().add("oprworkhourunit");
        e.getFieldKeys().add("oprworkhours");
        e.getFieldKeys().add("oprcancelworkhours");
        e.getFieldKeys().add("abnormalstatus");
        e.getFieldKeys().add("groprocessgroup");
        e.getFieldKeys().add("grogroupstatus");
        e.getFieldKeys().add("gromodifier");
        e.getFieldKeys().add("gromodifytime");
        e.getFieldKeys().add("groremark");
        e.getFieldKeys().add("groentryentity.seq");
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        String operateKey = e.getOperationKey();
        DynamicObject[] bills = e.getDataEntities();
        HashMap<Object, BigDecimal> orderMap = new HashMap<Object, BigDecimal>(16);
        switch (operateKey) {
            case "save": {
                DynamicObject unit = BusinessDataServiceHelper.loadSingleFromCache((Object)10L, (String)"bd_measureunits");
                for (int i = 0; i < bills.length; ++i) {
                    ManuftechCreateBillUtil.setGroEntryEntityValue((DynamicObject)bills[i], (Date)new Date(), (long)RequestContext.get().getCurrUserId());
                    DynamicObjectCollection dynamicObjectCollection = bills[i].getDynamicObjectCollection("oprentryentity");
                    for (DynamicObject objects : dynamicObjectCollection) {
                        if (null == objects.get("headunit")) {
                            objects.set("headunit", (Object)unit);
                        }
                        if (null == objects.get("oprunit")) {
                            objects.set("oprunit", (Object)unit);
                        }
                        if (!"E".equals(objects.getString("oprsourcetype")) || bills[i].getDynamicObject("mftentryseq") == null) continue;
                        orderMap.put(bills[i].getDynamicObject("mftentryseq").getPkValue(), objects.getBigDecimal("oprworkhours"));
                    }
                }
                this.updateNRCHour(orderMap);
                break;
            }
            case "auditsave": {
                this.auditSave(bills);
                break;
            }
            case "submit": {
                HashSet processGroupIdList = new HashSet(16);
                for (int i = 0; i < bills.length; ++i) {
                    ManuftechCreateBillUtil.setGroEntryEntityValue((DynamicObject)bills[i], (Date)new Date(), (long)RequestContext.get().getCurrUserId());
                    processGroupIdList.addAll(bills[i].getDynamicObjectCollection("oprentryentity").stream().filter(x -> x.getDynamicObject("oprprocessgroup") != null).map(x -> x.getDynamicObject("oprprocessgroup").getLong("id")).collect(Collectors.toSet()));
                }
                Set projectIds = Arrays.stream(bills).filter(x -> x.getDynamicObject("project") != null).map(x -> x.getDynamicObject("project").getLong("id")).collect(Collectors.toSet());
                Map result = new HashMap(16);
                try {
                    result = (Map)DispatchServiceHelper.invokeBizService((String)"mmc", (String)"fmm", (String)"ProjectPhaseMilepostService", (String)"getProjectPhaseMilepost", (Object[])new Object[]{new ArrayList(projectIds), new ArrayList(processGroupIdList), null});
                }
                catch (Throwable ex) {
                    throw new KDException(ex, new ErrorCode("getProjectPhaseMilepost", ex.getMessage() != null ? ex.getMessage() : ex.toString()), new Object[0]);
                }
                for (int j = 0; j < bills.length; ++j) {
                    DynamicObjectCollection dynamicObjectCollection = bills[j].getDynamicObjectCollection("oprentryentity");
                    MroManuftechUtil.oprentryentitySort((DynamicObjectCollection)dynamicObjectCollection);
                    MroManuftechUtil.groentryentitySort((DynamicObjectCollection)bills[j].getDynamicObjectCollection("groentryentity"));
                    for (DynamicObject objects : dynamicObjectCollection) {
                        if ("E".equals(objects.getString("oprsourcetype")) && bills[j].getDynamicObject("mftentryseq") != null) {
                            orderMap.put(bills[j].getDynamicObject("mftentryseq").getPkValue(), objects.getBigDecimal("oprworkhours"));
                        }
                        DynamicObject project = bills[j].getDynamicObject("project");
                        DynamicObject processGroup = objects.getDynamicObject("oprprocessgroup");
                        if (processGroup == null || project == null || !result.containsKey(processGroup.getLong("id")) || result == null) continue;
                        Map map = (Map)result.get(processGroup.getLong("id"));
                        List premilepostnodes = (List)map.get("premilepostnodes");
                        List postmilepostnodes = (List)map.get("postmilepostnodes");
                        if (CollectionUtils.isNotEmpty((Collection)premilepostnodes) && premilepostnodes.get(0) != null) {
                            objects.set("oprplanbegintime", ((Map)premilepostnodes.get(0)).get("planstartdate"));
                        }
                        if (!CollectionUtils.isNotEmpty((Collection)postmilepostnodes) || postmilepostnodes.get(0) == null) continue;
                        objects.set("oprplanfinishtime", ((Map)postmilepostnodes.get(0)).get("planstartdate"));
                    }
                }
                this.updateNRCHour(orderMap);
                break;
            }
            case "donothing_cancel": {
                this.changeStatus("", true, "donothing_cancel", bills);
                break;
            }
            case "donothing_uncancel": {
                this.changeStatus("", false, "donothing_uncancel", bills);
                break;
            }
            case "donothing_confirm": {
                this.changeStatus("C", false, "donothing_confirm", bills);
                break;
            }
            case "donothing_release": {
                this.changeStatus("D", false, "donothing_release", bills);
                break;
            }
            case "donothing_start": {
                this.changeStatus("E", false, "donothing_start", bills);
                break;
            }
            case "donothing_finish": {
                this.changeStatus("F", false, "donothing_finish", bills);
                break;
            }
            case "donothing_closed": {
                this.changeStatus("G", false, "donothing_closed", bills);
                break;
            }
            case "donothing_repairfinish": {
                this.changeStatus("H", false, "donothing_closed", bills);
                break;
            }
            case "donothing_tocancel": {
                this.changeStatus("I", false, "donothing_closed", bills);
                break;
            }
            case "donothing_retain": {
                this.changeStatus("J", false, "donothing_closed", bills);
                break;
            }
            case "donothing_unconfirm": {
                this.changeStatus("C", false, "donothing_unconfirm", bills);
                break;
            }
            case "donothing_unrelease": {
                this.changeStatus("D", false, "donothing_unrelease", bills);
                break;
            }
            case "donothing_unstart": {
                this.changeStatus("E", false, "donothing_unstart", bills);
                break;
            }
            case "donothing_unfinish": {
                this.changeStatus("F", false, "donothing_unfinish", bills);
                break;
            }
            case "donothing_unplan": {
                this.changeStatus("B", false, "donothing_unplan", bills);
                break;
            }
            case "donothing_unrepairfinish": {
                this.changeStatus("H", false, "donothing_unplan", bills);
                break;
            }
            case "donothing_normal": {
                this.changeStatus("", false, "donothing_normal", bills);
                break;
            }
            case "donothing_abnormal": {
                this.changeStatus("", true, "donothing_abnormal", bills);
                break;
            }
            case "donothing_abandon": {
                this.changeStatus("K", false, "donothing_abandon", bills);
                break;
            }
            case "group_start": {
                this.changeGroupStatus("B", bills);
                break;
            }
            case "group_finish": {
                this.changeGroupStatus("C", bills);
                break;
            }
            case "group_cancel": {
                this.changeGroupStatus("D", bills);
                break;
            }
            case "group_retain": {
                this.changeGroupStatus("E", bills);
                break;
            }
            case "group_unrelease": {
                this.changeGroupStatus("A", bills);
                break;
            }
            case "group_unstart": {
                this.changeGroupStatus("B", bills);
                break;
            }
        }
        e.setDataEntities(bills);
    }

    private void changeStatus(String status, boolean cancel, String operateKey, DynamicObject[] bills) {
        String sb = this.getOption().getVariableValue("operateOption");
        if (sb == null || "".equals(sb) || bills == null) {
            return;
        }
        List message = JSON.parseArray((String)sb, Long.class);
        HashSet oprentryids = Sets.newHashSet((Iterable)message);
        ChangeTechnicsBillEntryStatus.changeEntryStatus2((String)status, (boolean)cancel, (String)operateKey, (Set)oprentryids, (DynamicObject[])bills);
        if (StringUtils.equals((CharSequence)"donothing_finish", (CharSequence)operateKey)) {
            MydailyPlanUtil.syncDailyPlan((String)status, (HashSet)oprentryids);
        }
    }

    private void changeGroupStatus(String status, DynamicObject[] bills) {
        String sb = this.getOption().getVariableValue("groupOperateOption");
        if (sb == null || "".equals(sb) || bills == null) {
            return;
        }
        List message = JSON.parseArray((String)sb, Long.class);
        ChangeTechnicsBillEntryStatus.changeGroupEntryStatus((String)status, (Set)Sets.newHashSet((Iterable)message), (DynamicObject[])bills);
    }

    private void auditSave(DynamicObject[] bills) {
        HashMap<Object, BigDecimal> orderMap = new HashMap<Object, BigDecimal>(16);
        DynamicObject user = BusinessDataServiceHelper.loadSingleFromCache((Object)RequestContext.get().getCurrUserId(), (String)"bos_user", (String)"id");
        HashMap<Long, BigDecimal> oprHourMap = new HashMap<Long, BigDecimal>(16);
        for (DynamicObject manuftechBill : bills) {
            DynamicObjectCollection groentryentityCol = manuftechBill.getDynamicObjectCollection("groentryentity");
            Set processGroupIdList = groentryentityCol.stream().filter(x -> x.getDynamicObject("groprocessgroup") != null).map(x -> x.getDynamicObject("groprocessgroup").getLong("id")).collect(Collectors.toSet());
            DynamicObjectCollection oprentryentityCol = manuftechBill.getDynamicObjectCollection("oprentryentity");
            for (int i = 0; i < oprentryentityCol.size(); ++i) {
                DynamicObject oprentryentity = (DynamicObject)oprentryentityCol.get(i);
                Long id = oprentryentity.getLong("id");
                oprHourMap.put(id, oprentryentity.getBigDecimal("oprworkhours"));
                if ("D".equals(oprentryentity.getString("oprsourcetype")) && "A".equals(oprentryentity.getString("oprstatus"))) {
                    oprentryentity.set("oprstatus", (Object)"D");
                    oprentryentity.set("oprmodifier", (Object)user);
                    oprentryentity.set("oprmodifytime", (Object)new Date());
                    DynamicObject oprprocessgroup = oprentryentity.getDynamicObject("oprprocessgroup");
                    if (null != oprprocessgroup) {
                        if (processGroupIdList.contains(oprprocessgroup.getLong("id"))) {
                            for (DynamicObject groentryentity : groentryentityCol) {
                                DynamicObject groprocessgroup = groentryentity.getDynamicObject("groprocessgroup");
                                Long groprocessgroupId = null == groprocessgroup ? 0L : groprocessgroup.getLong("id");
                                if (!groprocessgroupId.equals(oprprocessgroup.getLong("id")) || !groentryentity.getString("grogroupstatus").equals("C")) continue;
                                groentryentity.set("grogroupstatus", (Object)"A");
                                break;
                            }
                        } else {
                            DynamicObject newEntryObj = groentryentityCol.addNew();
                            newEntryObj.set("groprocessgroup", (Object)oprprocessgroup);
                            newEntryObj.set("grogroupstatus", (Object)"A");
                            newEntryObj.set("gromodifier", (Object)user);
                            newEntryObj.set("gromodifytime", (Object)new Date());
                            processGroupIdList.add(oprprocessgroup.getLong("id"));
                        }
                    }
                }
                if (!"E".equals(oprentryentity.getString("oprsourcetype")) || manuftechBill.getDynamicObject("mftentryseq") == null) continue;
                orderMap.put(manuftechBill.getDynamicObject("mftentryseq").getPkValue(), oprentryentity.getBigDecimal("oprworkhours"));
            }
            MroManuftechUtil.oprentryentitySort((DynamicObjectCollection)oprentryentityCol);
            MroManuftechUtil.groentryentitySort((DynamicObjectCollection)groentryentityCol);
        }
        this.updateDownBillHour(oprHourMap);
        this.updateNRCHour(orderMap);
    }

    private void updateDownBillHour(Map<Long, BigDecimal> oprHourMap) {
        if (!oprHourMap.isEmpty()) {
            DynamicObject[] processreports;
            DynamicObject[] dailyplans;
            Boolean dailyplanUpdate = Boolean.FALSE;
            QFilter filter = new QFilter("oprentryentity.srcbillentryid", "in", oprHourMap.keySet());
            for (DynamicObject dailyplan : dailyplans = BusinessDataServiceHelper.load((String)"sfc_dailyplan", (String)"id,oprentryentity.srcbillentryid,oprentryentity.workhour", (QFilter[])new QFilter[]{filter})) {
                DynamicObjectCollection dailyplanOprCol = dailyplan.getDynamicObjectCollection("oprentryentity");
                for (DynamicObject dailyplanOpr : dailyplanOprCol) {
                    long srcbillentryid = dailyplanOpr.getLong("srcbillentryid");
                    if (!oprHourMap.containsKey(srcbillentryid)) continue;
                    dailyplanOpr.set("workhour", (Object)oprHourMap.get(srcbillentryid));
                    dailyplanUpdate = Boolean.TRUE;
                }
            }
            if (dailyplanUpdate.booleanValue()) {
                SaveServiceHelper.update((DynamicObject[])dailyplans);
            }
            Boolean processreportUpdate = Boolean.FALSE;
            Set oprentryIdList = oprHourMap.keySet().stream().map(x -> x.toString()).collect(Collectors.toSet());
            QFilter filter1 = new QFilter("sumentry.oprentryid", "in", oprentryIdList);
            for (DynamicObject processreport : processreports = BusinessDataServiceHelper.load((String)"sfc_processreportbill", (String)"id,sumentry.oprentryid,sumentry.standardhours", (QFilter[])new QFilter[]{filter1})) {
                DynamicObjectCollection sumentryCol = processreport.getDynamicObjectCollection("sumentry");
                for (DynamicObject sumentry : sumentryCol) {
                    long oprentryid = Long.parseLong(sumentry.getString("oprentryid"));
                    if (!oprHourMap.containsKey(oprentryid)) continue;
                    sumentry.set("standardhours", (Object)oprHourMap.get(oprentryid));
                    processreportUpdate = Boolean.TRUE;
                }
            }
            if (processreportUpdate.booleanValue()) {
                SaveServiceHelper.update((DynamicObject[])processreports);
            }
        }
    }

    private void updateNRCHour(Map<Object, BigDecimal> orderHourMap) {
        if (MapUtils.isNotEmpty(orderHourMap)) {
            DynamicObject[] pom_mronrcs;
            QFilter filter = new QFilter("treeentryentity.id", "in", orderHourMap.keySet());
            for (DynamicObject pom_mronrc : pom_mronrcs = BusinessDataServiceHelper.load((String)"pom_mroorder", (String)"id,planhours", (QFilter[])new QFilter[]{filter})) {
                DynamicObjectCollection treeentryentity = pom_mronrc.getDynamicObjectCollection("treeentryentity");
                for (DynamicObject object : treeentryentity) {
                    if (!orderHourMap.containsKey(object.getPkValue())) continue;
                    object.set("planhours", (Object)orderHourMap.get(object.getPkValue()));
                }
            }
            SaveServiceHelper.save((DynamicObject[])pom_mronrcs);
        }
    }
}

