/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.sfc.opplugin.manuftech.backflush;

import com.alibaba.fastjson.JSONArray;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bd.mpdm.common.query.helper.TransactionTypeQueryHelper;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import org.apache.commons.lang3.StringUtils;

public class BeginWorkBackFlushOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("baseqty");
        fieldKeys.add("actualstarttime");
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        super.afterExecuteOperationTransaction(e);
        Map<Long, String> res = this.autoBackFlush(this.billEntityType.getName(), e.getDataEntities());
        for (Map.Entry<Long, String> entry : res.entrySet()) {
            long key = entry.getKey();
            String value = entry.getValue();
            if ("".equals(value)) continue;
            OperateErrorInfo errorInfo = new OperateErrorInfo("AutoBackFlushOp", ErrorLevel.Error, (Object)key);
            errorInfo.setMessage(StringUtils.strip((String)value, (String)"[]"));
            errorInfo.setTitle(ResManager.loadKDString((String)"\u81ea\u52a8\u5012\u51b2", (String)"BeginWorkBackFlushOp_0", (String)"mmc-sfc-opplugin", (Object[])new Object[0]));
            this.operationResult.addErrorInfo(errorInfo);
            if (res.size() <= 1) continue;
            this.operationResult.addSuccessPkId((Object)key);
        }
    }

    private Map<Long, String> autoBackFlush(String entityName, DynamicObject[] dataArray) {
        ArrayList bfParam = new ArrayList(10);
        String unBackFlushEntryPks = this.getOption().getVariableValue("operateOption", "");
        List mftOrderRptEntryPkValues = JSONArray.parseArray((String)unBackFlushEntryPks, Long.class);
        HashSet<Long> mftEntryIds = new HashSet<Long>(16);
        for (DynamicObject mftReptBill : dataArray) {
            DynamicObject mftentryseq = mftReptBill.getDynamicObject("mftentryseq");
            if (mftentryseq == null) continue;
            mftEntryIds.add((Long)mftentryseq.getPkValue());
        }
        HashMap<Long, DynamicObject> mftOrderIdAndTransactiontypeMap = new HashMap<Long, DynamicObject>(16);
        HashMap<Long, Long> mftOrderEntryIdAndMftOrderIdMap = new HashMap<Long, Long>(16);
        this.putTranMap(mftOrderIdAndTransactiontypeMap, mftOrderEntryIdAndMftOrderIdMap, mftEntryIds);
        if (mftOrderIdAndTransactiontypeMap.isEmpty()) {
            return null;
        }
        for (DynamicObject mftReptBill : dataArray) {
            BigDecimal baseqty = mftReptBill.getBigDecimal("baseqty");
            if (baseqty.compareTo(BigDecimal.ZERO) <= 0) continue;
            DynamicObject mftentryseq = mftReptBill.getDynamicObject("mftentryseq");
            Long mftentryId = 0L;
            if (mftentryseq != null) {
                mftentryId = (Long)mftentryseq.getPkValue();
            }
            DynamicObjectCollection oprentryentity = mftReptBill.getDynamicObjectCollection("oprentryentity");
            for (DynamicObject oprentry : oprentryentity) {
                boolean isbackflush;
                Long orderId = (Long)mftOrderEntryIdAndMftOrderIdMap.get(mftentryId);
                DynamicObject transactiontype = (DynamicObject)mftOrderIdAndTransactiontypeMap.get(orderId);
                if (null == transactiontype || !mftOrderRptEntryPkValues.contains(oprentry.getPkValue()) || !oprentry.getBoolean("beginworkbf") || !(isbackflush = transactiontype.getBoolean("isbackflush"))) continue;
                HashMap<String, Object> tempMap = new HashMap<String, Object>(12);
                tempMap.put("id", mftReptBill.getPkValue());
                tempMap.put("billentity", entityName);
                tempMap.put("billno", mftReptBill.getString("billno"));
                tempMap.put("operationkey", "audit");
                tempMap.put("bferr", false);
                tempMap.put("biztime", oprentry.getDate("actualstarttime"));
                tempMap.put("ordername", "pom_mftorder");
                tempMap.put("orderentry", "treeentryentity");
                tempMap.put("stockname", "pom_mftstock");
                tempMap.put("targetname", "im_mdc_mftproorder");
                tempMap.put("botpid", "932404158450050048");
                HashMap<String, Object> innerMap = new HashMap<String, Object>(5);
                innerMap.put("entryid", oprentry.getPkValue());
                innerMap.put("seq", oprentry.getInt("seq"));
                innerMap.put("orderid", orderId);
                innerMap.put("orderentryid", mftentryId);
                innerMap.put("baseqty", baseqty);
                HashMap<String, HashMap<String, Object>> billEntryMap = new HashMap<String, HashMap<String, Object>>(1);
                billEntryMap.put(oprentry.getPkValue().toString(), innerMap);
                tempMap.put("billentry", billEntryMap);
                tempMap.put("processseq", oprentry.getString("oprparent"));
                tempMap.put("oprno", oprentry.getString("oprno"));
                bfParam.add(tempMap);
            }
        }
        Map<Long, String> res = new HashMap<Long, String>(16);
        if (null != bfParam && !bfParam.isEmpty()) {
            try {
                res = (Map)DispatchServiceHelper.invokeBizService((String)"scmc", (String)"im", (String)"MdcCheckMftorderService", (String)"batchAutoBackFlush", (Object[])new Object[]{bfParam, false});
            }
            catch (KDBizException ex) {
                OperateErrorInfo errorInfo = new OperateErrorInfo();
                errorInfo.setLevel(ErrorLevel.Info);
                errorInfo.setMessage(ex.getMessage() != null ? ex.getMessage() : ex.toString());
                errorInfo.setTitle(ResManager.loadKDString((String)"\u81ea\u52a8\u5012\u51b2", (String)"BeginWorkBackFlushOp_0", (String)"mmc-sfc-opplugin", (Object[])new Object[0]));
                this.operationResult.addErrorInfo(errorInfo);
            }
        }
        return res;
    }

    private void putTranMap(Map<Long, DynamicObject> mftOrderIdAndTransactiontypeMap, Map<Long, Long> mftOrderEntryIdAndMftOrderIdMap, Set<Long> mftEntryIds) {
        if (!mftEntryIds.isEmpty()) {
            QFilter qFilter = new QFilter("treeentryentity.id", "in", mftEntryIds);
            HashMap<Long, DynamicObject> transCacheMap = new HashMap<Long, DynamicObject>(16);
            try (DataSet ds = QueryServiceHelper.queryDataSet((String)"mmc-BeginWorkBackFlushOp-autoBackFlush", (String)"pom_mftorder", (String)"treeentryentity.id mftEntryID ,id,transactiontype transactiontypeID", (QFilter[])new QFilter[]{qFilter}, (String)"");){
                while (ds.hasNext()) {
                    Row dsRow = ds.next();
                    Long mftEntryID = dsRow.getLong("mftEntryID");
                    Long transactiontypeID = dsRow.getLong("transactiontypeID");
                    Long orderID = dsRow.getLong("id");
                    mftOrderEntryIdAndMftOrderIdMap.put(mftEntryID, orderID);
                    DynamicObject transType = (DynamicObject)transCacheMap.get(transactiontypeID);
                    if (transType == null) {
                        transType = TransactionTypeQueryHelper.getDataCacheByID((Object)transactiontypeID);
                        transCacheMap.put(transactiontypeID, transType);
                    }
                    mftOrderIdAndTransactiontypeMap.put(orderID, transType);
                }
            }
        }
    }
}

