/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.sfc.opplugin.manuftech.backflush;

import com.alibaba.fastjson.JSONArray;
import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import org.apache.commons.lang.StringUtils;

public class UnBeginWorkBackFlush
extends AbstractOperationServicePlugIn {
    private static Log logger = LogFactory.getLog(UnBeginWorkBackFlush.class);

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("bookdate");
        fieldKeys.add("oprentryentity.seq");
        fieldKeys.add("oprentryentity.id");
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        String entityName = this.billEntityType.getName();
        String unBackFlushEntryPks = this.getOption().getVariableValue("operateOption", "");
        if ("".equals(unBackFlushEntryPks)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u201c\u5de5\u5e8f\u201d\u6570\u636e\u3002", (String)"UnBeginWorkBackFlush_4", (String)"mmc-sfc-opplugin", (Object[])new Object[0]));
        }
        if (StringUtils.isNotBlank((String)unBackFlushEntryPks)) {
            logger.info(String.format("UnBeginWorkBackFlush\uff1abeginOperationTransaction->start:[unBackFlushEntryPks:%s]", unBackFlushEntryPks));
            List mftOrderRptEntryPkValues = JSONArray.parseArray((String)unBackFlushEntryPks, Long.class);
            QFilter qfilter = new QFilter("billentry.srcbillentryid", "in", (Object)mftOrderRptEntryPkValues);
            DynamicObject[] mftProOrders = BusinessDataServiceHelper.load((String)"im_mdc_mftproorder", (String)"id,billno,billentry.srcbillid,billentry.srcbillentryid", (QFilter[])new QFilter[]{qfilter});
            if (null != mftProOrders && mftProOrders.length > 0) {
                this.delBackFlush(entityName, mftProOrders, e.getDataEntities());
            } else {
                throw new KDBizException(ResManager.loadKDString((String)"\u5f53\u524d\u6240\u9009\u6570\u636e\u884c\u90fd\u672a\u5012\u51b2\uff0c\u4e0d\u652f\u6301\u53cd\u5012\u51b2\u3002", (String)"UnBeginWorkBackFlush_0", (String)"mmc-sfc-opplugin", (Object[])new Object[0]));
            }
        }
    }

    private void delBackFlush(String entityName, DynamicObject[] mftProOrders, DynamicObject[] dataEntities) {
        for (DynamicObject mftProOrder : mftProOrders) {
            int seq = 0;
            String billNo = "";
            DynamicObjectCollection mftProOrderEntrys = mftProOrder.getDynamicObjectCollection("billentry");
            DynamicObject mftProOrderEntry = (DynamicObject)mftProOrderEntrys.get(0);
            Long mftOrderRptEntryIdInProOrder = mftProOrderEntry.getLong("srcbillentryid");
            block1: for (DynamicObject mftReptBill : dataEntities) {
                DynamicObjectCollection oprentryentity = mftReptBill.getDynamicObjectCollection("oprentryentity");
                for (DynamicObject oprentry : oprentryentity) {
                    Long mftOrderRptEntryIdTemp = Long.parseLong(oprentry.getPkValue().toString());
                    if (!mftOrderRptEntryIdTemp.toString().equals(mftOrderRptEntryIdInProOrder.toString())) continue;
                    seq = oprentry.getInt("seq");
                    billNo = mftReptBill.getString("billno");
                    continue block1;
                }
            }
            String errInfo = this.unBackFlush(mftProOrder.getLong("id"), mftProOrder.getString("billno"));
            if ("".equals(errInfo)) continue;
            throw new KDBizException(String.format(ResManager.loadKDString((String)"%1$s\uff1a\u7b2c%2$s\u884c\u5206\u5f55\u53cd\u5012\u51b2\u5931\u8d25\uff1a%3$s", (String)"UnBeginWorkBackFlush_1", (String)"mmc-sfc-opplugin", (Object[])new Object[0]), billNo, seq, errInfo));
        }
    }

    private String unBackFlush(Long id, String billno) {
        String result = "";
        ArrayList<Long> mftProOrderPKList = new ArrayList<Long>();
        mftProOrderPKList.add(id);
        OperateOption auditOption = OperateOption.create();
        auditOption.setVariableValue("ignorewarn", String.valueOf(true));
        auditOption.setVariableValue("ignoreinteraction", String.valueOf(true));
        auditOption.setVariableValue("strictvalidation", String.valueOf(true));
        logger.info(String.format("MftorderRptUnBackFlushOp\uff1aunBackFlush->unAudit->start:[mftProOrderPKList:%s;billno:%s]", id, billno));
        OperationResult unAuditResult = OperationServiceHelper.executeOperate((String)"unaudit", (String)"im_mdc_mftproorder", (Object[])mftProOrderPKList.toArray(), (OperateOption)auditOption);
        if (!unAuditResult.isSuccess()) {
            result = String.format(ResManager.loadKDString((String)"\u53cd\u5ba1\u6838\u5012\u51b2\u9886\u6599\u5355\uff08\u7f16\u53f7\uff1a%1$s\uff09\u5931\u8d25\uff1a%2$s", (String)"UnBeginWorkBackFlush_2", (String)"mmc-sfc-opplugin", (Object[])new Object[0]), billno, this.getErrDetail(unAuditResult));
        } else {
            logger.info(String.format("MftorderRptUnBackFlushOp\uff1aunBackFlush->delete->start:[mftProOrderPKList:%s]", id));
            OperationResult delResult = OperationServiceHelper.executeOperate((String)"delete", (String)"im_mdc_mftproorder", (Object[])mftProOrderPKList.toArray(), (OperateOption)OperateOption.create());
            if (delResult.getSuccessPkIds().size() < mftProOrderPKList.size()) {
                result = String.format(ResManager.loadKDString((String)"\u5220\u9664\u5012\u51b2\u9886\u6599\u5355\uff08\u7f16\u53f7\uff1a%1$s\uff09\u5931\u8d25\u3002", (String)"UnBeginWorkBackFlush_3", (String)"mmc-sfc-opplugin", (Object[])new Object[0]), billno);
            }
        }
        return result;
    }

    private String getErrDetail(OperationResult optResult) {
        StringBuilder errDetail = new StringBuilder();
        errDetail.append(optResult.getMessage());
        for (IOperateInfo errInfo : optResult.getAllErrorOrValidateInfo()) {
            errDetail.append(errInfo.getMessage());
        }
        return errDetail.toString();
    }
}

