/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.sfc.opplugin.manuftech.botp;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bd.mpdm.business.helper.DateChangeProHelper;
import kd.bd.mpdm.business.manuftech.OprUnitHelper;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.ExtendedDataEntitySet;
import kd.bos.entity.botp.plugin.AbstractConvertPlugIn;
import kd.bos.entity.botp.plugin.args.AfterBuildDrawFilterEventArgs;
import kd.bos.entity.botp.plugin.args.AfterBuildQueryParemeterEventArgs;
import kd.bos.entity.botp.plugin.args.AfterConvertEventArgs;
import kd.bos.entity.botp.plugin.args.AfterCreateLinkEventArgs;
import kd.bos.entity.botp.plugin.args.AfterCreateTargetEventArgs;
import kd.bos.entity.botp.plugin.args.AfterFieldMappingEventArgs;
import kd.bos.entity.botp.plugin.args.BeforeBuildGroupModeEventArgs;
import kd.bos.entity.botp.plugin.args.BeforeBuildRowConditionEventArgs;
import kd.bos.entity.botp.plugin.args.BeforeCreateLinkEventArgs;
import kd.bos.entity.botp.plugin.args.BeforeCreateTargetEventArgs;
import kd.bos.entity.botp.plugin.args.BeforeGetSourceDataEventArgs;
import kd.bos.entity.botp.plugin.args.InitVariableEventArgs;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.UnitConvertHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.mmc.sfc.business.manuftech.OrgHelper;
import kd.mmc.sfc.business.manuftech.WriteRepSubentryBOTPHelper;
import kd.mmc.sfc.common.utils.QueryOrderUtil;
import org.apache.commons.collections4.CollectionUtils;

public class MFTBillToMFTInBillOp
extends AbstractConvertPlugIn {
    public void initVariable(InitVariableEventArgs e) {
    }

    public void beforeBuildRowCondition(BeforeBuildRowConditionEventArgs e) {
    }

    public void beforeBuildGroupMode(BeforeBuildGroupModeEventArgs e) {
    }

    public void afterBuildQueryParemeter(AfterBuildQueryParemeterEventArgs e) {
    }

    public void beforeGetSourceData(BeforeGetSourceDataEventArgs e) {
    }

    public void beforeCreateTarget(BeforeCreateTargetEventArgs e) {
    }

    public void afterCreateTarget(AfterCreateTargetEventArgs e) {
    }

    public void afterFieldMapping(AfterFieldMappingEventArgs e) {
    }

    public void beforeCreateLink(BeforeCreateLinkEventArgs e) {
    }

    public void afterCreateLink(AfterCreateLinkEventArgs e) {
    }

    public void afterBuildDrawFilter(AfterBuildDrawFilterEventArgs e) {
        DynamicObject targetDataEntity = e.getTargetDataEntity();
        DynamicObject org = targetDataEntity.getDynamicObject("org");
        if (org != null) {
            QFilter qFilter = new QFilter("org", "=", org.getPkValue());
            e.setPlugFilter(qFilter);
        }
    }

    public void afterConvert(AfterConvertEventArgs e) {
        DynamicObject org;
        ExtendedDataEntity[] dataEntitys;
        ExtendedDataEntitySet set = e.getTargetExtDataEntitySet();
        HashSet<Long> orgIds = new HashSet<Long>(16);
        HashSet<Long> oprEntryIds = new HashSet<Long>(16);
        for (ExtendedDataEntity extendedDataEntity : dataEntitys = set.FindByEntityKey("sfc_processreportbill")) {
            Date reportDate = extendedDataEntity.getDataEntity().getDate("reportdate");
            org = extendedDataEntity.getDataEntity().getDynamicObject("org");
            orgIds.add(org.getLong("id"));
            Date bookDate = DateChangeProHelper.getBookDate((Date)reportDate, (Long)org.getLong("id"));
            extendedDataEntity.setValue("bookdate", (Object)bookDate);
            DynamicObjectCollection dynamicObjectCollection = extendedDataEntity.getDataEntity().getDynamicObjectCollection("sumentry");
            for (DynamicObject object : dynamicObjectCollection) {
                oprEntryIds.add(object.getLong("oprentryid"));
            }
        }
        Map manFtechMap = QueryOrderUtil.getManftechByEntryId(oprEntryIds);
        for (ExtendedDataEntity extendedDataEntity : dataEntitys) {
            org = extendedDataEntity.getDataEntity().getDynamicObject("org");
            DynamicObjectCollection dynamicObjectCollection = extendedDataEntity.getDataEntity().getDynamicObjectCollection("sumentry");
            for (DynamicObject object : dynamicObjectCollection) {
                if (object.getBoolean("firstinspection") || !"1011".equals(object.getString("inspectiontype"))) {
                    object.set("qualityorg", (Object)OrgHelper.getQcOrgByProduceOrg(orgIds, (DynamicObject)org));
                }
                Map map = (Map)manFtechMap.get(object.getLong("oprentryid"));
                object.set("completbaseqty", (Object)OprUnitHelper.getBaseQty((Map)map, (BigDecimal)object.getBigDecimal("completqty")));
                object.set("qualifybaseqty", (Object)OprUnitHelper.getBaseQty((Map)map, (BigDecimal)object.getBigDecimal("qualifyqty")));
                object.set("receivebaseqty", (Object)OprUnitHelper.getBaseQty((Map)map, (BigDecimal)object.getBigDecimal("receiveqty")));
                object.set("workwastebaseqty", (Object)OprUnitHelper.getBaseQty((Map)map, (BigDecimal)object.getBigDecimal("workwasteqty")));
                object.set("scrapbaseqty", (Object)OprUnitHelper.getBaseQty((Map)map, (BigDecimal)object.getBigDecimal("scrapqty")));
                object.set("junkbaseqty", (Object)OprUnitHelper.getBaseQty((Map)map, (BigDecimal)object.getBigDecimal("junkqty")));
                object.set("repairbaseqty", (Object)OprUnitHelper.getBaseQty((Map)map, (BigDecimal)object.getBigDecimal("repairqty")));
                object.set("checkreworkbaseqty", (Object)OprUnitHelper.getBaseQty((Map)map, (BigDecimal)object.getBigDecimal("checkreworkqty")));
            }
        }
        this.writeOtherProduct(dataEntitys);
        WriteRepSubentryBOTPHelper.writeRepSubentry((ExtendedDataEntity[])dataEntitys, (String)"sfc_manftech");
    }

    private void writeOtherProduct(ExtendedDataEntity[] dataEntitys) {
        HashSet<Long> orderIds = new HashSet<Long>(16);
        for (int i = 0; i < dataEntitys.length; ++i) {
            DynamicObject obj = dataEntitys[i].getDataEntity();
            DynamicObjectCollection sumEntrys = obj.getDynamicObjectCollection("sumentry");
            for (DynamicObject entry : sumEntrys) {
                orderIds.add(entry.getLong("manufactureid"));
            }
        }
        Map<Long, DynamicObject> orderById = this.getOrderById(orderIds);
        for (int i = 0; i < dataEntitys.length; ++i) {
            ExtendedDataEntity dataEntity = dataEntitys[i];
            DynamicObject obj = dataEntity.getDataEntity();
            DynamicObjectCollection sumEntrys = obj.getDynamicObjectCollection("sumentry");
            for (DynamicObject entry : sumEntrys) {
                ArrayList<DynamicObject> otherproductentrys = new ArrayList<DynamicObject>();
                DynamicObject mftorderentry = entry.getDynamicObject("manufactureentryid");
                if (mftorderentry == null) {
                    ErrorCode ec = new ErrorCode("manufactureentryid", ResManager.loadKDString((String)"\u5de5\u5355\u5206\u5f55\u884c\u4e3a\u7a7a\u3002", (String)"MFTBillToMFTInBillOp_0", (String)"mmc-sfc-opplugin", (Object[])new Object[0]));
                    throw new KDBizException(ec, new Object[0]);
                }
                DynamicObject id = orderById.get(entry.getLong("manufactureid"));
                for (DynamicObject mftOrderEntry : id.getDynamicObjectCollection("treeentryentity")) {
                    Object pid;
                    DynamicObject opra = entry.getDynamicObject("opra");
                    if (!"A".equals(mftOrderEntry.get("producttype")) && !"B".equals(mftOrderEntry.get("producttype")) || opra == null || !opra.equals(mftOrderEntry.getDynamicObject("outputoperation")) || (pid = mftOrderEntry.get("pid")) == null || !pid.equals(entry.getDynamicObject("manufactureentryid").getPkValue())) continue;
                    otherproductentrys.add(mftOrderEntry);
                }
                for (int k = 0; k < otherproductentrys.size(); ++k) {
                    DynamicObject orderObj = (DynamicObject)otherproductentrys.get(k);
                    DynamicObjectCollection otherproductEntry = entry.getDynamicObjectCollection("otherproductentity");
                    boolean ishaveorderObj = false;
                    for (int j = 0; j < otherproductEntry.size(); ++j) {
                        if (!orderObj.getPkValue().toString().equals(((DynamicObject)otherproductEntry.get(j)).getString("srcorderentryid2"))) continue;
                        ishaveorderObj = true;
                        break;
                    }
                    if (ishaveorderObj) continue;
                    DynamicObject dynamicObject = otherproductEntry.addNew();
                    dynamicObject.set("seq", (Object)(k + 1));
                    dynamicObject.set("outputtype2", orderObj.get("producttype"));
                    dynamicObject.set("material2", orderObj.get("material"));
                    dynamicObject.set("completqty2", orderObj.get("qty"));
                    dynamicObject.set("qualifyqty2", orderObj.get("qty"));
                    dynamicObject.set("batchno2", orderObj.get("batchno"));
                    dynamicObject.set("srcorderid2", (Object)id.getPkValue().toString());
                    dynamicObject.set("srcorderentryid2", (Object)orderObj.getPkValue().toString());
                    dynamicObject.set("inwarehouseorg2", orderObj.get("inwardept"));
                    dynamicObject.set("ownertype2", (Object)"bos_org");
                    dynamicObject.set("warehouse2", orderObj.get("warehouse"));
                    dynamicObject.set("position2", orderObj.get("location"));
                    dynamicObject.set("produceunit2", (Object)orderObj.getDynamicObject("unit"));
                    long unitId = orderObj.getDynamicObject("unit").getLong("id");
                    long material = orderObj.getDynamicObject("materielmasterid").getLong("id");
                    dynamicObject.set("receiveqty2", (Object)UnitConvertHelper.calculateNewQty((BigDecimal)entry.getBigDecimal("receiveqty"), (Long)unitId, (Long)entry.getDynamicObject("oprunit").getLong("id"), (Long)material, (StringBuilder)new StringBuilder()));
                    dynamicObject.set("workwasteqty2", (Object)UnitConvertHelper.calculateNewQty((BigDecimal)entry.getBigDecimal("workwasteqty"), (Long)unitId, (Long)entry.getDynamicObject("oprunit").getLong("id"), (Long)material, (StringBuilder)new StringBuilder()));
                    dynamicObject.set("scrapqty2", (Object)UnitConvertHelper.calculateNewQty((BigDecimal)entry.getBigDecimal("scrapqty"), (Long)unitId, (Long)entry.getDynamicObject("oprunit").getLong("id"), (Long)material, (StringBuilder)new StringBuilder()));
                    dynamicObject.set("junkqty2", (Object)UnitConvertHelper.calculateNewQty((BigDecimal)entry.getBigDecimal("junkqty"), (Long)unitId, (Long)entry.getDynamicObject("oprunit").getLong("id"), (Long)material, (StringBuilder)new StringBuilder()));
                    dynamicObject.set("repairqty2", (Object)UnitConvertHelper.calculateNewQty((BigDecimal)entry.getBigDecimal("repairqty"), (Long)unitId, (Long)entry.getDynamicObject("oprunit").getLong("id"), (Long)material, (StringBuilder)new StringBuilder()));
                    dynamicObject.set("reworkqty2", (Object)UnitConvertHelper.calculateNewQty((BigDecimal)entry.getBigDecimal("checkreworkqty"), (Long)unitId, (Long)entry.getDynamicObject("oprunit").getLong("id"), (Long)material, (StringBuilder)new StringBuilder()));
                    DynamicObject object = orderObj.getDynamicObject("inwardept");
                    if (object.getBoolean("fisaccounting")) {
                        dynamicObject.set("inwarconsigner2", (Object)object);
                        continue;
                    }
                    List list = OrgUnitServiceHelper.getFromOrgs((String)"05", (Long)((Long)object.getPkValue()), (String)"10");
                    if (!CollectionUtils.isNotEmpty((Collection)list)) continue;
                    dynamicObject.set("inwarconsigner2", (Object)BusinessDataServiceHelper.loadSingleFromCache(list.get(0), (String)"bos_org"));
                }
            }
        }
    }

    private Map<Long, DynamicObject> getOrderById(Set<Long> orderIds) {
        HashMap<Long, DynamicObject> result = new HashMap<Long, DynamicObject>(128);
        QFilter filter = new QFilter("id", "in", orderIds);
        String selectFields = "id,treeentryentity.id,treeentryentity.pid,treeentryentity.outputoperation,treeentryentity.producttype,treeentryentity.material,treeentryentity.materielmasterid,treeentryentity.unit,treeentryentity.qty,treeentryentity.inwardept,treeentryentity.warehouse,treeentryentity.location,treeentryentity.batchno";
        DynamicObject[] orders = BusinessDataServiceHelper.load((String)"pom_mftorder", (String)selectFields, (QFilter[])new QFilter[]{filter});
        for (int i = 0; i < orders.length; ++i) {
            result.put(orders[i].getLong("id"), orders[i]);
        }
        return result;
    }
}

