/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.sfc.opplugin.manuftech.botp;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.ExtendedDataEntitySet;
import kd.bos.entity.botp.plugin.AbstractConvertPlugIn;
import kd.bos.entity.botp.plugin.args.AfterFieldMappingEventArgs;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;

public class ManftechToEntrustedOrderOp
extends AbstractConvertPlugIn {
    public void afterFieldMapping(AfterFieldMappingEventArgs e) {
        ExtendedDataEntitySet targetExtDataEntitySet = e.getTargetExtDataEntitySet();
        ExtendedDataEntity[] entities = targetExtDataEntitySet.FindByEntityKey(this.getTgtMainType().getName());
        Set orgIds = Arrays.stream(entities).filter(x -> x.getDataEntity().getDynamicObject("org") != null).map(x -> x.getDataEntity().getDynamicObject("org").getLong("id")).collect(Collectors.toSet());
        HashSet<Long> materailSet = new HashSet<Long>(16);
        for (int i = 0; i < entities.length; ++i) {
            DynamicObject dataEntity = entities[i].getDataEntity();
            DynamicObjectCollection dynamicObjectCollection = dataEntity.getDynamicObjectCollection("treeentryentity");
            materailSet.addAll(dynamicObjectCollection.stream().filter(x -> x.getDynamicObject("materielmasterid") != null).map(x -> x.getDynamicObject("materielmasterid").getLong("id")).collect(Collectors.toSet()));
        }
        HashMap<Long, DynamicObject> materialInfo = new HashMap<Long, DynamicObject>(16);
        for (Long id : orgIds) {
            materialInfo.putAll(this.getMaterialInfo(materailSet, id));
        }
        for (int i = 0; i < entities.length; ++i) {
            DynamicObject dataEntity = entities[i].getDataEntity();
            DynamicObjectCollection dynamicObjectCollection = dataEntity.getDynamicObjectCollection("treeentryentity");
            for (DynamicObject object : dynamicObjectCollection) {
                DynamicObject mftMaterial = object.getDynamicObject("material");
                if (mftMaterial == null) continue;
                if (!"C".equals(mftMaterial.getString("status")) || "0".equals(mftMaterial.getString("enable"))) {
                    DynamicObject dynamicObject;
                    DynamicObject material = object.getDynamicObject("materielmasterid");
                    if (material == null || (dynamicObject = (DynamicObject)materialInfo.get(material.getLong("id"))) == null) continue;
                    object.set("material", (Object)dynamicObject);
                    object.set("unit", (Object)dynamicObject.getDynamicObject("mftunit"));
                    continue;
                }
                object.set("unit", (Object)mftMaterial.getDynamicObject("mftunit"));
            }
        }
    }

    private Map<Long, DynamicObject> getMaterialInfo(Set<Long> materailSet, Long id) {
        DynamicObject[] mftinfo;
        HashMap<Long, DynamicObject> resultMap = new HashMap<Long, DynamicObject>(20);
        QFilter qFilter2 = new QFilter("masterid.id", "in", materailSet);
        qFilter2.and(BaseDataServiceHelper.getBaseDataFilter((String)"bd_materialmftinfo", (Long)id));
        qFilter2.and(new QFilter("enable", "=", (Object)"1"));
        qFilter2.and(new QFilter("status", "=", (Object)"C"));
        String qmftsql = "id,masterid,mftunit";
        for (DynamicObject infodym : mftinfo = BusinessDataServiceHelper.load((String)"bd_materialmftinfo", (String)qmftsql, (QFilter[])new QFilter[]{qFilter2})) {
            DynamicObject masterid = infodym.getDynamicObject("masterid");
            resultMap.put((Long)masterid.getPkValue(), infodym);
        }
        return resultMap;
    }
}

