/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.sfc.opplugin.manuftech.botp;

import java.math.BigDecimal;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bd.mpdm.business.manuftech.OprUnitHelper;
import kd.bd.mpdm.common.consts.ProtransferBillConsts;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.ExtendedDataEntitySet;
import kd.bos.entity.botp.plugin.AbstractConvertPlugIn;
import kd.bos.entity.botp.plugin.args.AfterBuildDrawFilterEventArgs;
import kd.bos.entity.botp.plugin.args.AfterConvertEventArgs;
import kd.bos.entity.botp.plugin.args.BeforeBuildRowConditionEventArgs;
import kd.bos.orm.query.QFilter;
import kd.mmc.sfc.business.manuftech.OrgHelper;
import kd.mmc.sfc.common.utils.ProtransferBillUtil;

public class ManftechToProTransBillOp
extends AbstractConvertPlugIn {
    public void beforeBuildRowCondition(BeforeBuildRowConditionEventArgs e) {
        List selectedRows = e.getSelectedRows();
        if (!selectedRows.isEmpty()) {
            QFilter qFilter = new QFilter("oprentryentity.machiningtype", "in", (Object)new String[]{"1002", "1003"});
            qFilter.and(new QFilter("oprentryentity.oprtotalinqty", ">", (Object)"oprentryentity.oprtotaloutqty", true));
            QFilter qFilter1 = new QFilter("oprentryentity.machiningtype", "=", (Object)"1001");
            qFilter1.and(new QFilter("oprentryentity.oprtotaloutqty", "<", (Object)"oprentryentity.oprtotalqualifiedqty+oprentryentity.oprtotalreceiveqty", true));
            QFilter custQFilter = qFilter.or(qFilter1);
            List custQFilters = e.getCustQFilters();
            custQFilters.add(custQFilter);
            e.setCustFilterExpression(custQFilter.toString());
            e.setCustFilterDesc(ResManager.loadKDString((String)"\u53ef\u8f6c\u6570\u91cf\u5927\u4e8e0", (String)"ManftechToProTransBillOp_1", (String)"mmc-sfc-opplugin", (Object[])new Object[0]));
        }
    }

    public void afterBuildDrawFilter(AfterBuildDrawFilterEventArgs e) {
        if (this.getOption().containsVariable("billtype") && "outprotransfer".equals(this.getOption().getVariableValue("billtype"))) {
            QFilter plugFilter = new QFilter("oprentryentity.machiningtype", "in", (Object)new String[]{"1002", "1003"});
            e.setPlugFilter(plugFilter);
        } else if (this.getOption().containsVariable("billtype") && "protransfer".equals(this.getOption().getVariableValue("billtype"))) {
            QFilter plugFilter = new QFilter("oprentryentity.machiningtype", "=", (Object)"1001");
            e.setPlugFilter(plugFilter);
        }
    }

    public void afterConvert(AfterConvertEventArgs e) {
        ExtendedDataEntitySet set = e.getTargetExtDataEntitySet();
        ExtendedDataEntity[] transferSet = set.FindByEntityKey("sfc_protransferbill");
        int entryIdSize = 0;
        HashSet<Long> ids = new HashSet<Long>(16);
        HashSet<Long> orgIds = new HashSet<Long>(16);
        for (ExtendedDataEntity extendedDataEntity : transferSet) {
            DynamicObjectCollection outEntryInfoCollection = extendedDataEntity.getDataEntity().getDynamicObjectCollection("outentryentity");
            entryIdSize += outEntryInfoCollection.size();
            for (DynamicObject outentry : outEntryInfoCollection) {
                if (null == outentry.getDynamicObject("outprocessplan")) continue;
                ids.add((Long)outentry.getDynamicObject("outprocessplan").getPkValue());
                DynamicObject org = outentry.getDynamicObject("outprocessplan").getDynamicObject("org");
                orgIds.add(org.getLong("id"));
            }
        }
        List pkValues = ProtransferBillUtil.genPkValues((int)entryIdSize);
        Map map = ProtransferBillUtil.getManftechs(ids);
        int pknum = 0;
        for (int i = 0; i < transferSet.length; ++i) {
            DynamicObject transferBill = transferSet[i].getDataEntity();
            DynamicObjectCollection outEntryInfoCollection = transferBill.getDynamicObjectCollection("outentryentity");
            DynamicObjectCollection inEntryInfoCollection = transferBill.getDynamicObjectCollection("inentryentity");
            block3: for (DynamicObject outEntryInfo : outEntryInfoCollection) {
                DynamicObject inEntryInfo = null;
                DynamicObject outprocessplan = outEntryInfo.getDynamicObject("outprocessplan");
                DynamicObject outprocessid = outEntryInfo.getDynamicObject("outprocessid");
                if (null == outprocessplan || null == outprocessid || !map.containsKey(outprocessplan.getLong("id"))) {
                    return;
                }
                DynamicObject processInfo = (DynamicObject)map.get(outprocessplan.getLong("id"));
                DynamicObjectCollection oprentryentityInfo = processInfo.getDynamicObjectCollection("oprentryentity");
                Collections.sort(oprentryentityInfo, Comparator.comparingInt(o -> o.getInt("oprno")));
                for (DynamicObject dy : oprentryentityInfo) {
                    if (!outprocessid.getPkValue().toString().equals(dy.getPkValue().toString())) continue;
                    Map entrymap = OprUnitHelper.getManftechMap((DynamicObject)processInfo, (DynamicObject)dy);
                    this.setOutEntryInfo(outEntryInfo, dy, entrymap);
                    Long genLongId = (Long)pkValues.get(pknum);
                    outEntryInfo.set("id", (Object)genLongId);
                    ++pknum;
                    DynamicObject nextOpr = this.getNextOpr(oprentryentityInfo, outEntryInfo);
                    if (null != nextOpr) {
                        inEntryInfoCollection.addNew();
                        inEntryInfo = (DynamicObject)inEntryInfoCollection.get(inEntryInfoCollection.size() - 1);
                        inEntryInfo.set("outentryentityid", (Object)genLongId);
                        inEntryInfo.set("inprocessplan", (Object)outprocessplan);
                        inEntryInfo.set("icostcenter", dy.get("ecostcenter"));
                        Boolean oprinvalid = nextOpr.getBoolean("oprinvalid");
                        if (!oprinvalid.booleanValue()) {
                            inEntryInfo.set("inprocessid", (Object)nextOpr);
                            inEntryInfo.set("inprocess", (Object)nextOpr.getString("oprno"));
                            this.setInEntryInfo(inEntryInfo, nextOpr);
                        }
                    }
                    this.setTransferType(outEntryInfo, inEntryInfo);
                    if (ProtransferBillConsts.OUT_TRANSFERTYPE.contains(outEntryInfo.get("transfertype"))) {
                        DynamicObject org = outEntryInfo.getDynamicObject("outprocessplan").getDynamicObject("org");
                        outEntryInfo.set("qualityorg", (Object)OrgHelper.getQcOrgByProduceOrg(orgIds, (DynamicObject)org));
                        continue block3;
                    }
                    outEntryInfo.set("inspectiontype", (Object)"1011");
                    continue block3;
                }
            }
        }
    }

    private void setTransferType(DynamicObject outEntryInfo, DynamicObject inEntryInfo) {
        String out = "";
        DynamicObject outprocess = outEntryInfo.getDynamicObject("outprocessid");
        if (null != outprocess) {
            if (outprocess.get("machiningtype") != null && outprocess.get("machiningtype").toString().equals("1001")) {
                out = "1";
            } else if (outprocess.get("machiningtype") != null && outprocess.get("machiningtype").toString().equals("1003")) {
                out = "2";
            } else if (outprocess.get("machiningtype") != null && outprocess.get("machiningtype").toString().equals("1002")) {
                out = "3";
            }
        }
        String in = "";
        if (null != inEntryInfo) {
            DynamicObject inprocess = inEntryInfo.getDynamicObject("inprocessid");
            if (null != inprocess) {
                if (inprocess.get("machiningtype") != null && inprocess.get("machiningtype").toString().equals("1001")) {
                    in = "1";
                } else if (inprocess.get("machiningtype") != null && inprocess.get("machiningtype").toString().equals("1003")) {
                    in = "2";
                } else if (inprocess.get("machiningtype") != null && inprocess.get("machiningtype").toString().equals("1002")) {
                    in = "3";
                }
            }
        } else {
            in = "1";
        }
        if (StringUtils.isBlank((CharSequence)out) || StringUtils.isBlank((CharSequence)in)) {
            return;
        }
        outEntryInfo.set("transfertype", (Object)(out + in));
    }

    private void setOutEntryInfo(DynamicObject outEntryInfo, DynamicObject dy, Map<String, Object> entrymap) {
        if (dy.get("machiningtype") != null && dy.getString("machiningtype").equals("1002")) {
            outEntryInfo.set("outtype", (Object)"bd_supplier");
            outEntryInfo.set("transferredout", dy.get("supplier"));
        } else {
            outEntryInfo.set("outtype", (Object)"mpdm_workcentre");
            outEntryInfo.set("transferredout", dy.get("oprworkcenter"));
        }
        BigDecimal qty = outEntryInfo.getBigDecimal("transferqty");
        BigDecimal baseQty = OprUnitHelper.getBaseQty(entrymap, (BigDecimal)qty);
        outEntryInfo.set("availablebaseqty", (Object)baseQty);
        outEntryInfo.set("transferbaseqty", (Object)baseQty);
        outEntryInfo.set("reverseavailablebaseqty", (Object)baseQty);
        if (outEntryInfo.getBigDecimal("outqualifyqty").compareTo(BigDecimal.ZERO) > 0) {
            outEntryInfo.set("outqualifybaseqty", (Object)baseQty);
            outEntryInfo.set("reversequalifybaseqty", (Object)baseQty);
            Boolean warehousepoint = outEntryInfo.getBoolean("warehousepoint");
            if (warehousepoint.booleanValue()) {
                outEntryInfo.set("conformityqty", (Object)outEntryInfo.getBigDecimal("outqualifyqty"));
                outEntryInfo.set("conformitybaseqty", (Object)baseQty);
            }
        }
    }

    private void setInEntryInfo(DynamicObject inEntryInfo, DynamicObject dy) {
        inEntryInfo.set("inprocessid", (Object)dy);
        if (dy.get("machiningtype") != null && dy.getString("machiningtype").equals("1002")) {
            inEntryInfo.set("intype", (Object)"bd_supplier");
            inEntryInfo.set("transferredin", dy.get("supplier"));
        } else {
            inEntryInfo.set("intype", (Object)"mpdm_workcentre");
            inEntryInfo.set("transferredin", dy.get("oprworkcenter"));
        }
        inEntryInfo.set("inpurchaseorg", dy.get("purchaseorg"));
    }

    private DynamicObject getNextOpr(DynamicObjectCollection oprentryentityInfo, DynamicObject outEntryInfo) {
        DynamicObject outprocessplan = outEntryInfo.getDynamicObject("outprocessplan");
        DynamicObject outprocessid = outEntryInfo.getDynamicObject("outprocessid");
        String outprocess = outEntryInfo.getString("outprocess");
        String outsequence = outprocessid.getString("oprparent");
        if (null == outprocessplan || null == outprocessid) {
            return null;
        }
        int out = Integer.parseInt(outprocess);
        for (DynamicObject dy : oprentryentityInfo) {
            String oprparent = dy.getString("oprparent");
            String oprno = dy.getString("oprno");
            Boolean oprinvalid = dy.getBoolean("oprinvalid");
            DynamicObject oprctrlstrategy = dy.getDynamicObject("oprctrlstrategy");
            Boolean reportmethod = Boolean.TRUE;
            if (null != oprctrlstrategy && "1010".equals(oprctrlstrategy.getString("reportmethod"))) {
                reportmethod = Boolean.FALSE;
            }
            if (!oprparent.equals(outsequence) || !StringUtils.isNotBlank((CharSequence)oprno) || Integer.parseInt(oprno) <= out || oprinvalid.booleanValue() || !reportmethod.booleanValue()) continue;
            return dy;
        }
        return null;
    }
}

