/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.sfc.opplugin.manuftech.botp;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bd.mpdm.business.manuftech.OprUnitHelper;
import kd.bd.mpdm.common.consts.ProtransferBillConsts;
import kd.bd.mpdm.common.enums.ProtransferBiztypeEnum;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.ExtendedDataEntitySet;
import kd.bos.entity.botp.plugin.AbstractConvertPlugIn;
import kd.bos.entity.botp.plugin.args.AfterConvertEventArgs;
import kd.mmc.sfc.common.utils.ProtransferBillUtil;

public class ProtransferToProtransferOp
extends AbstractConvertPlugIn {
    public void afterConvert(AfterConvertEventArgs e) {
        ExtendedDataEntitySet set = e.getTargetExtDataEntitySet();
        ExtendedDataEntity[] transferSet = set.FindByEntityKey("sfc_protransferbill");
        HashSet<Long> ids = new HashSet<Long>(16);
        int entryIdSize = 0;
        for (ExtendedDataEntity extendedDataEntity : transferSet) {
            DynamicObjectCollection outEntryInfoCollection = extendedDataEntity.getDataEntity().getDynamicObjectCollection("outentryentity");
            entryIdSize += outEntryInfoCollection.size();
            for (DynamicObject outentry : outEntryInfoCollection) {
                ids.add(Long.valueOf(outentry.getString("srcbillentryid")));
            }
        }
        Map protransferMap = ProtransferBillUtil.getProtransfers(ids);
        Map inEntrys = ProtransferBillUtil.getInEntrys(new ArrayList(protransferMap.values()));
        Map outEntrys = ProtransferBillUtil.getOutEntrys(new ArrayList(protransferMap.values()));
        List pkValues = ProtransferBillUtil.genPkValues((int)entryIdSize);
        int pknum = 0;
        for (int s = 0; s < transferSet.length; ++s) {
            DynamicObject transferBill = transferSet[s].getDataEntity();
            DynamicObjectCollection outEntryInfoCollection = transferBill.getDynamicObjectCollection("outentryentity");
            DynamicObjectCollection inEntryInfoCollection = transferBill.getDynamicObjectCollection("inentryentity");
            for (int i = 0; i < outEntryInfoCollection.size(); ++i) {
                String transfertype;
                DynamicObject outEntryInfo = (DynamicObject)outEntryInfoCollection.get(i);
                if (!outEntrys.containsKey(outEntryInfo.getString("srcbillentryid"))) continue;
                DynamicObject outEntry = (DynamicObject)outEntrys.get(outEntryInfo.getString("srcbillentryid"));
                if (inEntrys.containsKey(outEntryInfo.getString("srcbillentryid"))) {
                    DynamicObject inEntry = (DynamicObject)inEntrys.get(outEntryInfo.getString("srcbillentryid"));
                    outEntryInfo.set("outprocessplan", inEntry.get("inprocessplan"));
                    outEntryInfo.set("outprocess", inEntry.get("inprocess"));
                    outEntryInfo.set("outprocessid", inEntry.get("inprocessid"));
                    outEntryInfo.set("outtype", inEntry.get("intype"));
                    outEntryInfo.set("transferredout", inEntry.get("transferredin"));
                    outEntryInfo.set("outpurchaseorg", inEntry.get("inpurchaseorg"));
                    outEntryInfo.set("ocostcenter", inEntry.get("icostcenter"));
                    DynamicObject inEntryInfo = inEntryInfoCollection.addNew();
                    inEntryInfo.set("inprocessplan", outEntry.get("outprocessplan"));
                    inEntryInfo.set("inprocess", outEntry.get("outprocess"));
                    inEntryInfo.set("inprocessid", outEntry.get("outprocessid"));
                    inEntryInfo.set("intype", outEntry.get("outtype"));
                    inEntryInfo.set("transferredin", outEntry.get("transferredout"));
                    inEntryInfo.set("inpurchaseorg", outEntry.get("outpurchaseorg"));
                    inEntryInfo.set("icostcenter", outEntry.get("ocostcenter"));
                    Long genLongId = (Long)pkValues.get(pknum);
                    outEntryInfo.set("id", (Object)genLongId);
                    ++pknum;
                    inEntryInfo.set("outentryentityid", (Object)genLongId);
                }
                outEntryInfo.set("warehousepoint", outEntryInfo.getDynamicObject("outprocessid").get("storagepoint"));
                String biztype = outEntryInfo.getString("biztype");
                if (ProtransferBiztypeEnum.SEQUENCE.getValue().equals(biztype)) {
                    outEntryInfo.set("biztype", (Object)ProtransferBiztypeEnum.REVERSESEQUENCE.getValue());
                } else if (ProtransferBiztypeEnum.SKIPSEQUENCE.getValue().equals(biztype)) {
                    outEntryInfo.set("biztype", (Object)ProtransferBiztypeEnum.REVERSESKIP.getValue());
                }
                if (null == outEntryInfo.getDynamicObject("outprocessplan") || null == outEntryInfo.getDynamicObject("outprocessid") || StringUtils.isBlank((CharSequence)(transfertype = outEntryInfo.getString("transfertype")))) continue;
                char[] charArray = transfertype.toCharArray();
                transfertype = String.valueOf(charArray[1]) + String.valueOf(charArray[0]);
                outEntryInfo.set("transfertype", (Object)transfertype);
                outEntryInfo.set("outoprunit", outEntryInfo.getDynamicObject("outprocessid").get("oprunit"));
                Map map = OprUnitHelper.getManftechMap((DynamicObject)outEntryInfo.getDynamicObject("outprocessplan"), (DynamicObject)outEntryInfo.getDynamicObject("outprocessid"));
                BigDecimal qty = OprUnitHelper.getOprQty((Map)map, (BigDecimal)outEntryInfo.getBigDecimal("transferbaseqty"));
                outEntryInfo.set("availableqty", (Object)qty);
                outEntryInfo.set("transferqty", (Object)qty);
                if (!ProtransferBillConsts.OUT_REVERSE_TRANSFERTYPE.contains(transfertype)) continue;
                outEntryInfo.set("outjunkbaseqty", (Object)outEntryInfo.getBigDecimal("outscrapbaseqty").add(outEntryInfo.getBigDecimal("outworkwastebaseqty")));
                outEntryInfo.set("outqualifyqty", (Object)OprUnitHelper.getOprQty((Map)map, (BigDecimal)outEntryInfo.getBigDecimal("outqualifybaseqty")));
                outEntryInfo.set("outreceiveqty", (Object)OprUnitHelper.getOprQty((Map)map, (BigDecimal)outEntryInfo.getBigDecimal("outreceivebaseqty")));
                outEntryInfo.set("outworkwasteqty", (Object)OprUnitHelper.getOprQty((Map)map, (BigDecimal)outEntryInfo.getBigDecimal("outworkwastebaseqty")));
                outEntryInfo.set("outscrapqty", (Object)OprUnitHelper.getOprQty((Map)map, (BigDecimal)outEntryInfo.getBigDecimal("outscrapbaseqty")));
                outEntryInfo.set("outjunkqty", (Object)OprUnitHelper.getOprQty((Map)map, (BigDecimal)outEntryInfo.getBigDecimal("outworkwastebaseqty")).add(OprUnitHelper.getOprQty((Map)map, (BigDecimal)outEntryInfo.getBigDecimal("outscrapbaseqty"))));
                outEntryInfo.set("outreworkqty", (Object)OprUnitHelper.getOprQty((Map)map, (BigDecimal)outEntryInfo.getBigDecimal("outreworkbaseqty")));
            }
        }
    }
}

