/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.sfc.opplugin.manuftech.validator;

import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bd.mpdm.common.manuftech.MROManuftechUtil;
import kd.bd.mpdm.opplugin.manutemplet.AtomServiceUtilsOp;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.mmc.sfc.common.manuftech.utils.CheckManuOrderUtil;
import kd.mmc.sfc.common.manuftech.utils.CheckUtil;
import kd.mmc.sfc.common.utils.QueryOrderUtil;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class MROManuftechValidator
extends AbstractValidator {
    public void validate() {
        String operate = this.getOperateKey();
        HashSet<Long> orderEntryIds = new HashSet<Long>(16);
        for (int i = 0; i < this.dataEntities.length; ++i) {
            DynamicObject obj = this.dataEntities[i].getDataEntity();
            if (obj.getDynamicObject("mftentryseq") == null) continue;
            orderEntryIds.add(obj.getDynamicObject("mftentryseq").getLong("id"));
        }
        Map ordermap = QueryOrderUtil.getMroOrderByEntryId(orderEntryIds);
        switch (operate) {
            case "submit": {
                this.submitCheck(operate, ordermap);
                break;
            }
            case "auditsave": {
                this.submitCheck(operate, ordermap);
                this.auditSaveCheck();
                break;
            }
            case "delete": {
                for (int i = 0; i < this.dataEntities.length; ++i) {
                    this.deleteCheck(i);
                }
                break;
            }
            case "processdispatch": {
                this.processDispatchCheck();
                break;
            }
            case "donothing_confirm": {
                this.row_operation("donothing_confirm", ordermap);
                break;
            }
            case "donothing_release": {
                this.row_operation("donothing_release", ordermap);
                break;
            }
            case "donothing_start": {
                this.row_operation("donothing_start", ordermap);
                break;
            }
            case "donothing_finish": {
                this.row_operation("donothing_finish", ordermap);
                break;
            }
            case "donothing_repairfinish": {
                this.row_operation("donothing_repairfinish", ordermap);
                break;
            }
            case "donothing_closed": {
                this.row_operation("donothing_closed", ordermap);
                break;
            }
            case "donothing_unplan": {
                this.row_operation("donothing_unplan", ordermap);
                break;
            }
            case "donothing_unconfirm": {
                this.row_operation("donothing_unconfirm", ordermap);
                break;
            }
            case "donothing_unrelease": {
                this.row_operation("donothing_unrelease", ordermap);
                break;
            }
            case "donothing_unstart": {
                this.row_operation("donothing_unstart", ordermap);
                break;
            }
            case "donothing_unfinish": {
                this.row_operation("donothing_unfinish", ordermap);
                break;
            }
            case "donothing_unrepairfinish": {
                this.row_operation("donothing_unrepairfinish", ordermap);
                break;
            }
            case "donothing_cancel": {
                this.row_operation("donothing_cancel", ordermap);
                break;
            }
            case "donothing_uncancel": {
                this.row_operation("donothing_uncancel", ordermap);
                break;
            }
            case "donothing_tocancel": {
                this.row_operation("donothing_tocancel", ordermap);
                break;
            }
            case "donothing_retain": {
                this.row_operation("donothing_retain", ordermap);
                break;
            }
            case "donothing_normal": {
                this.row_operation("donothing_normal", ordermap);
                break;
            }
            case "donothing_abnormal": {
                this.row_operation("donothing_abnormal", ordermap);
                break;
            }
            case "group_start": {
                this.validDonothingGroup("group_start");
                break;
            }
            case "group_finish": {
                this.validDonothingGroup("group_finish");
                break;
            }
            case "group_cancel": {
                this.validDonothingGroup("group_cancel");
                break;
            }
            case "group_retain": {
                this.validDonothingGroup("group_retain");
                break;
            }
            case "group_unrelease": {
                this.validDonothingGroup("group_unrelease");
                break;
            }
            case "group_unstart": {
                this.validDonothingGroup("group_unstart");
                break;
            }
        }
    }

    private void submitCheck(String operate, Map<Long, Map<String, Object>> ordermap) {
        for (int i = 0; i < this.dataEntities.length; ++i) {
            Map<String, Object> order;
            DynamicObject obj = this.dataEntities[i].getDataEntity();
            DynamicObjectCollection entryCol = obj.getDynamicObjectCollection("oprentryentity");
            if (entryCol.isEmpty()) {
                this.addErrorMessage(this.dataEntities[i], ResManager.loadKDString((String)"\u5de5\u5e8f\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"MROManuftechValidator_0", (String)"mmc-sfc-opplugin", (Object[])new Object[0]));
            }
            HashSet<String> keySet = new HashSet<String>(entryCol.size());
            for (int j = 0; j < entryCol.size(); ++j) {
                DynamicObject entryObj = (DynamicObject)entryCol.get(j);
                if (this.isNull(entryObj.getString("oprorg"))) {
                    this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u5de5\u5e8f[%s]\u201c\u751f\u4ea7\u7ec4\u7ec7\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"MROManuftechValidator_1", (String)"mmc-sfc-opplugin", (Object[])new Object[0]), entryObj.getString("oprno")));
                }
                if (this.isNull(entryObj.getString("oprno"))) {
                    this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u5de5\u5e8f[%s]\u201c\u5de5\u5e8f\u53f7\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"MROManuftechValidator_2", (String)"mmc-sfc-opplugin", (Object[])new Object[0]), entryObj.getString("oprno")));
                }
                if (this.isNull(entryObj.getString("oprstatus"))) {
                    this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u5de5\u5e8f[%s]\u201c\u72b6\u6001\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"MROManuftechValidator_3", (String)"mmc-sfc-opplugin", (Object[])new Object[0]), entryObj.getString("oprno")));
                }
                if (this.isNull(entryObj.get("oprplanbegintime"))) {
                    this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u5de5\u5e8f[%s]\u201c\u8ba1\u5212\u5f00\u59cb\u65f6\u95f4\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"MROManuftechValidator_4", (String)"mmc-sfc-opplugin", (Object[])new Object[0]), entryObj.getString("oprno")));
                }
                if (this.isNull(entryObj.get("oprplanfinishtime"))) {
                    this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u5de5\u5e8f[%s]\u201c\u8ba1\u5212\u5b8c\u6210\u65f6\u95f4\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"MROManuftechValidator_5", (String)"mmc-sfc-opplugin", (Object[])new Object[0]), entryObj.getString("oprno")));
                }
                if (this.isNull(entryObj.getString("oprprocessgroup"))) {
                    this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u5de5\u5e8f[%s]\u201c\u5de5\u5e8f\u7d44\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"MROManuftechValidator_6", (String)"mmc-sfc-opplugin", (Object[])new Object[0]), entryObj.getString("oprno")));
                }
                if (this.isNull(entryObj.getString("oprprofessiona"))) {
                    this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u5de5\u5e8f[%s]\u201c\u884c\u4e1a\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"MROManuftechValidator_7", (String)"mmc-sfc-opplugin", (Object[])new Object[0]), entryObj.getString("oprno")));
                }
                if (this.isNull(entryObj.getString("oprworkhourunit"))) {
                    this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u5de5\u5e8f[%s]\u201c\u5de5\u65f6\u5355\u4f4d\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"MROManuftechValidator_8", (String)"mmc-sfc-opplugin", (Object[])new Object[0]), entryObj.getString("oprno")));
                }
                if (entryObj.getDate("oprplanbegintime") != null && entryObj.getDate("oprplanfinishtime") != null && entryObj.getDate("oprplanbegintime").after(entryObj.getDate("oprplanfinishtime"))) {
                    this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u5de5\u5e8f[%s]\u201d\u8ba1\u5212\u5f00\u59cb\u65f6\u95f4\u201c\u4e0d\u80fd\u665a\u4e8e\u201d\u8ba1\u5212\u5b8c\u6210\u65f6\u95f4\u201c\u3002", (String)"MROManuftechValidator_10", (String)"mmc-sfc-opplugin", (Object[])new Object[0]), entryObj.getString("oprno")));
                }
                if (this.isNull(entryObj.getString("oprprocessgroup")) || this.isNull(entryObj.getString("oprprofessiona"))) continue;
                String key = entryObj.getString("oprprocessgroup") + "#" + entryObj.getString("oprprofessiona");
                if (keySet.contains(key)) {
                    this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u5de5\u5e8f[%s]\u5b58\u5728\u91cd\u590d\u7684\u5de5\u5e8f\u7ec4+\u884c\u4e1a\u3002", (String)"MROManuftechValidator_73", (String)"mmc-sfc-opplugin", (Object[])new Object[0]), entryObj.getString("oprno")));
                    continue;
                }
                keySet.add(key);
            }
            if (null == obj.getDynamicObject("mftentryseq") || (order = ordermap.get(obj.getDynamicObject("mftentryseq").getLong("id"))) == null || !"D".equals(order.get("billstatus"))) continue;
            this.addErrorMessage(this.dataEntities[i], ResManager.loadKDString((String)"\u4e0a\u6e38\u5de5\u5355\u5df2\u4f5c\u5e9f\uff0c\u63d0\u4ea4\u5931\u8d25", (String)"MROManuftechValidator_11", (String)"mmc-sfc-opplugin", (Object[])new Object[0]));
        }
    }

    private void deleteCheck(int i) {
        DynamicObject obj = this.dataEntities[i].getDataEntity();
        DynamicObjectCollection oprentrys = obj.getDynamicObjectCollection("oprentryentity");
        for (DynamicObject opr : oprentrys) {
            HashSet strs = Sets.newHashSet((Object[])new String[]{"A", "B", "C"});
            if (strs.contains(opr.getString("oprstatus"))) continue;
            String oprNo = opr.getString("oprno");
            this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u5de5\u5e8f[%s]\u5b58\u5728\u4e0b\u8fbe\u6216\u540e\u7eed\u64cd\u4f5c,\u4e0d\u5141\u8bb8\u5220\u9664\u3002", (String)"MROManuftechValidator_12", (String)"mmc-sfc-opplugin", (Object[])new Object[0]), oprNo));
        }
    }

    private void auditSaveCheck() {
        for (int i = 0; i < this.dataEntities.length; ++i) {
            DynamicObject obj = this.dataEntities[i].getDataEntity();
            DynamicObjectCollection groCols = obj.getDynamicObjectCollection("groentryentity");
            Map<Long, DynamicObject> groMap = groCols.stream().filter(x -> x.getDynamicObject("groprocessgroup") != null).collect(Collectors.toMap(x -> x.getLong("groprocessgroup.id"), r -> r));
            DynamicObjectCollection oprentryentityCol = obj.getDynamicObjectCollection("oprentryentity");
            for (DynamicObject oprentryentity : oprentryentityCol) {
                DynamicObject oprprocessgroup = oprentryentity.getDynamicObject("oprprocessgroup");
                if (!"D".equals(oprentryentity.getString("oprsourcetype")) || null == oprprocessgroup || !groMap.containsKey(oprprocessgroup.getLong("id")) || !"D".equals(groMap.get(oprprocessgroup.getLong("id")).getString("grogroupstatus"))) continue;
                this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\u7ec4%1$s\u72b6\u6001\u4e0d\u4e3a\u201c\u4e0b\u8fbe\u201d\u3001\u201c\u5f00\u5de5\u201d\u3001\u201c\u5b8c\u5de5\u201d\u3002", (String)"MROManuftechValidator_74", (String)"mmc-sfc-opplugin", (Object[])new Object[0]), oprprocessgroup.get("number")));
            }
        }
    }

    private void row_operation(String operateKey, Map<Long, Map<String, Object>> orderByEntryId) {
        Object orderTaskStatus;
        Set existsIDSet = CheckUtil.getExistsIDSet((ExtendedDataEntity[])this.dataEntities);
        HashSet list = new HashSet(16);
        HashSet operateKeySets = Sets.newHashSet((Object[])new String[]{"donothing_cancel", "donothing_uncancel", "donothing_abnormal", "donothing_normal"});
        List message = CheckUtil.getManftechEntryID((String)this.getOption().getVariableValue("operateOption", ""));
        if (CollectionUtils.isEmpty((Collection)message)) {
            for (int i = 0; i < this.dataEntities.length; ++i) {
                this.addErrorMessage(this.getDataEntities()[i], ResManager.loadKDString((String)"\u8bf7\u9009\u4e2d\u4e00\u884c\u201c\u5de5\u5e8f\u201d\u6570\u636e\u3002", (String)"MROManuftechValidator_15", (String)"mmc-sfc-opplugin", (Object[])new Object[0]));
            }
            return;
        }
        HashSet orderTaskStatusSets = Sets.newHashSet((Object[])new String[]{"C", "E", "F", "J"});
        for (int i = 0; i < this.dataEntities.length; ++i) {
            String pstatus;
            DynamicObject obj = this.dataEntities[i].getDataEntity();
            Object billPK = obj.getPkValue();
            ArrayList<String> errors = new ArrayList<String>();
            if (list.contains(billPK) || CheckUtil.getDynamicObjectTypeName((DynamicObject)obj) == null) continue;
            if (!CheckUtil.isDataChange(errors, (boolean)existsIDSet.contains(billPK))) {
                this.addErrorMessage(i, errors);
                continue;
            }
            if (!"C".equals(obj.get("billstatus")) && !operateKeySets.contains(operateKey)) {
                this.addErrorMessage(this.getDataEntities()[i], String.format(ResManager.loadKDString((String)"\u72b6\u6001\u4e0d\u4e3a\u5ba1\u6838,\u4e0d\u5141\u8bb8\u6267\u884c\u64cd\u4f5c\u3002", (String)"MROManuftechValidator_16", (String)"mmc-sfc-opplugin", (Object[])new Object[0]), new Object[0]));
                continue;
            }
            if (null != obj.getDynamicObject("project") && null != obj.getDynamicObject("project").getDynamicObject("prjstate") && "FINANCIALCLOSURE_S".equals(pstatus = obj.getDynamicObject("project").getDynamicObject("prjstate").getString("number"))) {
                this.addErrorMessage(this.getDataEntities()[i], String.format(ResManager.loadKDString((String)"\u9879\u76ee\u72b6\u6001\u4e3a \u201c\u8d22\u52a1\u5173\u95ed\u201d\u65f6\uff0c\u4e0d\u5141\u8bb8\u53d8\u66f4\u5de5\u5e8f\u72b6\u6001\u3002", (String)"MROManuftechValidator_68", (String)"mmc-sfc-opplugin", (Object[])new Object[0]), new Object[0]));
                continue;
            }
            if (null == obj.getDynamicObject("mftentryseq") || !orderTaskStatusSets.contains(orderTaskStatus = obj.getDynamicObject("mftentryseq").getString("taskstatus"))) continue;
            this.addErrorMessage(this.dataEntities[i], ResManager.loadKDString((String)"\u5de5\u5355\u4efb\u52a1\u72b6\u6001\u4e3a\u5b8c\u5de5\u3001\u4fdd\u7559\u3001\u53d6\u6d88\u3001\u5e9f\u5f03\u65f6\uff0c\u4e0d\u5141\u8bb8\u53d8\u66f4\u5de5\u5e8f\u72b6\u6001\u3002", (String)"MROManuftechValidator_69", (String)"mmc-sfc-opplugin", (Object[])new Object[0]));
        }
        HashSet checkDailyPlanKeySets = Sets.newHashSet((Object[])new String[]{"donothing_retain", "donothing_tocancel", "donothing_finish", "donothing_closed"});
        if (checkDailyPlanKeySets.contains(operateKey)) {
            HashMap<Object, String> errorMaps = new HashMap<Object, String>(16);
            SqlBuilder sql = new SqlBuilder();
            sql.append("select distinct h.fbillno,h.ftaskname,o.fentryid,o.fsrcbillid,t.foprno\r\n", new Object[0]);
            sql.append("from t_sfc_dpentry_opr o \r\n", new Object[0]);
            sql.append("inner join t_sfc_mromanftechentry t on t.fentryid = o.fsrcbillentryid ", new Object[0]);
            sql.append("inner join t_sfc_dpsubentry_rpt g on g.fentryid = o.fentryid\r\n", new Object[0]);
            sql.append("inner join t_sfc_dailyplan_new h on o.fid = h.fid where\r\n", new Object[0]);
            sql.appendIn("t.fentryid", message.toArray());
            sql.append("and g.freportbegintime is not null and g.freportendtime is null", new Object[0]);
            DataSet dataSet = DB.queryDataSet((String)AtomServiceUtilsOp.class.getName(), (DBRoute)DBRoute.of((String)"scm"), (SqlBuilder)sql);
            orderTaskStatus = null;
            try {
                StringBuilder info = new StringBuilder();
                for (Row row : dataSet) {
                    info.append(String.format(ResManager.loadKDString((String)"\u5de5\u5e8f%1$s\u5728\u65e5\u8ba1\u5212%2$s\u4efb\u52a1%3$s\u5b58\u5728\u672a\u6536\u5de5\u8bb0\u5f55\uff0c\u4e0d\u5141\u8bb8\u5c06\u4efb\u52a1\u72b6\u6001\u53d8\u6210\u201c\u4fdd\u7559\u201d\u3001\u201c\u53d6\u6d88\u201d\u3001\u201c\u68c0\u9a8c\u5b8c\u5de5\u201d\u3001\u201c\u5173\u95ed\u201d\u3002", (String)"MROManuftechValidator_72", (String)"mmc-sfc-opplugin", (Object[])new Object[0]), row.get("foprno"), row.get("fbillno"), row.get("ftaskname"))).append("\n");
                    errorMaps.put(row.get("fsrcbillid"), info.toString());
                }
            }
            catch (Throwable info) {
                orderTaskStatus = info;
                throw info;
            }
            finally {
                if (dataSet != null) {
                    if (orderTaskStatus != null) {
                        try {
                            dataSet.close();
                        }
                        catch (Throwable info) {
                            ((Throwable)orderTaskStatus).addSuppressed(info);
                        }
                    } else {
                        dataSet.close();
                    }
                }
            }
            for (int i = 0; i < this.dataEntities.length; ++i) {
                DynamicObject obj = this.dataEntities[i].getDataEntity();
                Object pkValue = obj.getPkValue();
                if (!errorMaps.containsKey(pkValue)) continue;
                this.addErrorMessage(this.dataEntities[i], (String)errorMaps.get(pkValue));
            }
        }
        switch (operateKey) {
            case "donothing_confirm": {
                this.validDonothingConfirm(orderByEntryId);
                break;
            }
            case "donothing_release": {
                this.validDonothingRelease(orderByEntryId);
                break;
            }
            case "donothing_start": {
                this.validDonothingStart(orderByEntryId);
                break;
            }
            case "donothing_finish": {
                this.validDonothingFinish(orderByEntryId);
                break;
            }
            case "donothing_repairfinish": {
                this.validDonothingRepairFinish(orderByEntryId);
                break;
            }
            case "donothing_tocancel": {
                this.validDonothingToCancel(orderByEntryId);
                break;
            }
            case "donothing_retain": {
                this.validDonothingRetain(orderByEntryId);
                break;
            }
            case "donothing_closed": {
                this.validDonothingClosed(orderByEntryId);
                break;
            }
            case "donothing_unplan": {
                this.validDonothingUnplan(orderByEntryId);
                break;
            }
            case "donothing_unconfirm": {
                this.validDonothingUnconfirm(orderByEntryId);
                break;
            }
            case "donothing_unrelease": {
                this.validDonothingUnrelase(orderByEntryId);
                break;
            }
            case "donothing_unstart": {
                this.validDonothingUnstart(orderByEntryId);
                break;
            }
            case "donothing_unfinish": {
                this.validDonothingUnfinish(orderByEntryId);
                break;
            }
            case "donothing_unrepairfinish": {
                this.validDonothingUnRepairfinish(orderByEntryId);
                break;
            }
            case "donothing_cancel": {
                this.validDonothingCancel(orderByEntryId);
                break;
            }
            case "donothing_uncancel": {
                this.validDonothingUnCancel(orderByEntryId);
                break;
            }
        }
    }

    private void validDonothingGroup(String key) {
        List message = CheckUtil.getManftechEntryID((String)this.getOption().getVariableValue("groupOperateOption", ""));
        if (CollectionUtils.isEmpty((Collection)message)) {
            for (int i = 0; i < this.dataEntities.length; ++i) {
                this.addErrorMessage(this.getDataEntities()[i], ResManager.loadKDString((String)"\u8bf7\u9009\u4e2d\u4e00\u884c\u201c\u5de5\u5e8f\u7ec4\u201d\u6570\u636e\u3002", (String)"MROManuftechValidator_17", (String)"mmc-sfc-opplugin", (Object[])new Object[0]));
            }
            return;
        }
        HashSet groupOpSet = Sets.newHashSet((Object[])new String[]{"group_unrelease", "group_unstart"});
        HashSet groupStatusSet1 = Sets.newHashSet((Object[])new String[]{"C", "D", "E"});
        HashSet operationKeys = Sets.newHashSet((Object[])new String[]{"group_finish", "group_cancel", "group_retain"});
        HashSet groupStatusSet2 = Sets.newHashSet((Object[])new String[]{"A", "B"});
        HashSet<Object> oprentryeids = new HashSet<Object>(16);
        HashSet<Object> oprprocessgroupids = new HashSet<Object>(16);
        HashSet orderTaskStatusSets = Sets.newHashSet((Object[])new String[]{"C", "E", "F", "J"});
        for (int i = 0; i < this.dataEntities.length; ++i) {
            String orderTaskStatus;
            String pstatus;
            DynamicObject obj = this.dataEntities[i].getDataEntity();
            if (null != obj.getDynamicObject("project") && null != obj.getDynamicObject("project").getDynamicObject("prjstate") && "FINANCIALCLOSURE_S".equals(pstatus = obj.getDynamicObject("project").getDynamicObject("prjstate").getString("number"))) {
                this.addErrorMessage(this.getDataEntities()[i], String.format(ResManager.loadKDString((String)"\u9879\u76ee\u72b6\u6001\u4e3a \u201c\u8d22\u52a1\u5173\u95ed\u201d\u65f6\uff0c\u4e0d\u5141\u8bb8\u53d8\u66f4\u5de5\u5e8f\u7ec4\u72b6\u6001\u3002", (String)"MROManuftechValidator_70", (String)"mmc-sfc-opplugin", (Object[])new Object[0]), new Object[0]));
                continue;
            }
            if (null != obj.getDynamicObject("mftentryseq") && orderTaskStatusSets.contains(orderTaskStatus = obj.getDynamicObject("mftentryseq").getString("taskstatus"))) {
                this.addErrorMessage(this.dataEntities[i], ResManager.loadKDString((String)"\u5de5\u5355\u4efb\u52a1\u72b6\u6001\u4e3a\u5b8c\u5de5\u3001\u4fdd\u7559\u3001\u53d6\u6d88\u3001\u5e9f\u5f03\u65f6\uff0c\u4e0d\u5141\u8bb8\u53d8\u66f4\u5de5\u5e8f\u7ec4\u72b6\u6001\u3002", (String)"MROManuftechValidator_71", (String)"mmc-sfc-opplugin", (Object[])new Object[0]));
                continue;
            }
            DynamicObjectCollection entryCol = obj.getDynamicObjectCollection("groentryentity");
            for (int j = 0; j < entryCol.size(); ++j) {
                DynamicObject entryObj = (DynamicObject)entryCol.get(j);
                if (!message.contains(entryObj.getPkValue())) continue;
                if (!groupOpSet.contains(key)) {
                    if (operationKeys.contains(key)) {
                        DynamicObject groprocessgroup = entryObj.getDynamicObject("groprocessgroup");
                        oprprocessgroupids.add(groprocessgroup.getPkValue());
                    }
                    if (groupStatusSet1.contains(entryObj.getString("grogroupstatus"))) {
                        this.addErrorMessage(this.dataEntities[i], ResManager.loadKDString((String)"\u5de5\u5e8f\u7ec4\u72b6\u6001\u4e3a[\u5b8c\u5de5][\u53d6\u6d88][\u4fdd\u7559]\u65f6\uff0c\u4e0d\u5141\u8bb8\u64cd\u4f5c\u201c\u884c\u6267\u884c\u201d\u3002", (String)"MROManuftechValidator_18", (String)"mmc-sfc-opplugin", (Object[])new Object[0]));
                        continue;
                    }
                    if ("group_start".equals(key) && !"A".equals(entryObj.getString("grogroupstatus"))) {
                        this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\u7ec4[%1$s]\u72b6\u6001\u4e0d\u4e3a[\u4e0b\u8fbe],\u4e0d\u5141\u8bb8\u6267\u884c\u81f3\u5f00\u5de5\u3002", (String)"MROManuftechValidator_19", (String)"mmc-sfc-opplugin", (Object[])new Object[0]), j + 1));
                    }
                    if (!"group_finish".equals(key) || groupStatusSet2.contains(entryObj.getString("grogroupstatus"))) continue;
                    this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\u7ec4[%1$s]\u72b6\u6001\u4e0d\u4e3a[\u5f00\u5de5][\u4e0b\u8fbe],\u4e0d\u5141\u8bb8\u6267\u884c\u81f3\u5b8c\u5de5\u3002", (String)"MROManuftechValidator_20", (String)"mmc-sfc-opplugin", (Object[])new Object[0]), j + 1));
                    continue;
                }
                if ("group_unstart".equals(key) && !groupStatusSet1.contains(entryObj.getString("grogroupstatus"))) {
                    this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\u7ec4[%1$s]\u72b6\u6001\u4e0d\u4e3a[\u5b8c\u5de5][\u53d6\u6d88][\u4fdd\u7559],\u4e0d\u5141\u8bb8\u53cd\u6267\u884c\u81f3\u5f00\u5de5\u3002", (String)"MROManuftechValidator_21", (String)"mmc-sfc-opplugin", (Object[])new Object[0]), j + 1));
                }
                if (!"group_unrelease".equals(key) || !"A".equals(entryObj.getString("grogroupstatus"))) continue;
                this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\u7ec4[%1$s]\u72b6\u6001\u4e3a[\u4e0b\u8fbe],\u4e0d\u5141\u8bb8\u53cd\u6267\u884c\u81f3\u4e0b\u8fbe\u3002", (String)"MROManuftechValidator_75", (String)"mmc-sfc-opplugin", (Object[])new Object[0]), j + 1));
            }
            if (oprprocessgroupids.size() <= 0) continue;
            DynamicObjectCollection oprentrys = obj.getDynamicObjectCollection("oprentryentity");
            for (DynamicObject oprentry : oprentrys) {
                Object pkValue = oprentry.getPkValue();
                DynamicObject oprprocessgroup = oprentry.getDynamicObject("oprprocessgroup");
                if (!oprprocessgroupids.contains(oprprocessgroup.getPkValue())) continue;
                oprentryeids.add(pkValue);
            }
        }
        if (!oprentryeids.isEmpty()) {
            HashMap<Object, String> errorMaps = new HashMap<Object, String>(16);
            SqlBuilder sql = new SqlBuilder();
            sql.append("select distinct o.fid,h.fbillno,o.fentryid,o.fsrcbillid,o.ftechno,go.fnumber gonum\r\n", new Object[0]);
            sql.append("from t_sfc_dpentry_opr o \r\n", new Object[0]);
            sql.append("inner join t_mpdm_progroup go on o.fprocessgroupid = go.fid \r\n", new Object[0]);
            sql.append("inner join t_sfc_dpsubentry_rpt g on g.fentryid = o.fentryid\r\n", new Object[0]);
            sql.append("inner join t_sfc_dailyplan_new h on o.fid = h.fid where\r\n", new Object[0]);
            sql.appendIn("o.fsrcbillentryid", oprentryeids.toArray());
            sql.append("and g.freportbegintime is not null and g.freportendtime is null", new Object[0]);
            try (DataSet dataSet = DB.queryDataSet((String)AtomServiceUtilsOp.class.getName(), (DBRoute)DBRoute.of((String)"scm"), (SqlBuilder)sql);){
                StringBuilder info = new StringBuilder();
                for (Row row : dataSet) {
                    info.append(String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\u7ec4%1$s\u5728\u65e5\u8ba1\u5212%2$s\uff0c\u5b58\u5728\u672a\u6536\u5de5\u8bb0\u5f55\uff0c\u4e0d\u5141\u8bb8\u5c06\u4efb\u52a1\u72b6\u6001\u53d8\u6210\u201c\u4fdd\u7559\u201d\u3001\u201c\u53d6\u6d88\u201d\u3001\u201c\u5b8c\u5de5\u201d\u3002", (String)"MROManuftechValidator_67", (String)"mmc-sfc-opplugin", (Object[])new Object[0]), row.get("gonum"), row.get("fbillno"))).append("\n");
                    errorMaps.put(row.get("fsrcbillid"), info.toString());
                }
            }
            for (int i = 0; i < this.dataEntities.length; ++i) {
                DynamicObject obj = this.dataEntities[i].getDataEntity();
                Object pkValue = obj.getPkValue();
                if (!errorMaps.containsKey(pkValue)) continue;
                this.addErrorMessage(this.dataEntities[i], (String)errorMaps.get(pkValue));
            }
        }
    }

    private void validDonothingConfirm(Map<Long, Map<String, Object>> orderByEntryId) {
        List message = CheckUtil.getManftechEntryID((String)this.getOption().getVariableValue("operateOption"));
        if (message == null) {
            return;
        }
        HashSet status = Sets.newHashSet((Object[])new String[]{"B", "A"});
        for (int i = 0; i < this.dataEntities.length; ++i) {
            DynamicObject obj = this.dataEntities[i].getDataEntity();
            Map<String, Object> map = orderByEntryId.get(obj.getDynamicObject("mftentryseq").getLong("id"));
            StringBuffer error = CheckManuOrderUtil.checkManuOrderEntryStatus((String)"checkTaskStatus", (String)obj.getString("billno"), (String)ResManager.loadKDString((String)"\u6267\u884c\u81f3\u786e\u8ba4", (String)"MROManuftechValidator_23", (String)"mmc-sfc-opplugin", (Object[])new Object[0]), map, (String)ResManager.loadKDString((String)"\u68c0\u4fee", (String)"MROManuftechValidator_63", (String)"mmc-sfc-opplugin", (Object[])new Object[0]));
            if (error.length() > 0) {
                this.addErrorMessage(this.dataEntities[i], error.toString());
            }
            DynamicObjectCollection entryCol = obj.getDynamicObjectCollection("oprentryentity");
            for (int j = 0; j < entryCol.size(); ++j) {
                DynamicObject entryObj = (DynamicObject)entryCol.get(j);
                if (!message.contains(entryObj.getPkValue())) continue;
                if (entryObj.getBoolean("oprinvalid")) {
                    this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\u5e8f\u5217[%1$s]\u4e0b\u5de5\u5e8f[%2$s]\u5df2\u4f5c\u5e9f,\u4e0d\u5141\u8bb8\u6267\u884c\u81f3\u786e\u8ba4\u3002", (String)"MROManuftechValidator_24", (String)"mmc-sfc-opplugin", (Object[])new Object[0]), entryObj.getString("oprparent"), entryObj.getString("oprno")));
                }
                if (status.contains(entryObj.getString("oprstatus"))) continue;
                this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\u5e8f\u5217[%1$s]\u4e0b\u5de5\u5e8f[%2$s]\u72b6\u6001\u4e0d\u4e3a[\u521b\u5efa][\u8ba1\u5212],\u4e0d\u5141\u8bb8\u6267\u884c\u81f3\u786e\u8ba4\u3002", (String)"MROManuftechValidator_25", (String)"mmc-sfc-opplugin", (Object[])new Object[0]), entryObj.getString("oprparent"), entryObj.getString("oprno")));
            }
        }
    }

    private void validDonothingRelease(Map<Long, Map<String, Object>> orderByEntryId) {
        List message = CheckUtil.getManftechEntryID((String)this.getOption().getVariableValue("operateOption"));
        if (message == null) {
            return;
        }
        HashSet status = Sets.newHashSet((Object[])new String[]{"E", "F"});
        for (int i = 0; i < this.dataEntities.length; ++i) {
            StringBuffer error1;
            DynamicObject obj = this.dataEntities[i].getDataEntity();
            Map<String, Object> map = orderByEntryId.get(obj.getDynamicObject("mftentryseq").getLong("id"));
            StringBuffer error = CheckManuOrderUtil.checkManuOrderEntryStatus((String)"checkTaskStatus", (String)obj.getString("billno"), (String)ResManager.loadKDString((String)"\u6267\u884c\u81f3\u4e0b\u8fbe", (String)"MROManuftechValidator_26", (String)"mmc-sfc-opplugin", (Object[])new Object[0]), map, (String)ResManager.loadKDString((String)"\u68c0\u4fee", (String)"MROManuftechValidator_63", (String)"mmc-sfc-opplugin", (Object[])new Object[0]));
            if (error.length() > 0) {
                this.addErrorMessage(this.dataEntities[i], error.toString());
            }
            if ((error1 = CheckManuOrderUtil.checkManuOrderEntryStatus((String)"checkBizStatus", (String)obj.getString("billno"), (String)ResManager.loadKDString((String)"\u6267\u884c\u81f3\u4e0b\u8fbe", (String)"MROManuftechValidator_26", (String)"mmc-sfc-opplugin", (Object[])new Object[0]), map, (String)ResManager.loadKDString((String)"\u68c0\u4fee", (String)"MROManuftechValidator_63", (String)"mmc-sfc-opplugin", (Object[])new Object[0]))).length() > 0) {
                this.addErrorMessage(this.dataEntities[i], error1.toString());
            }
            DynamicObjectCollection entryCol = obj.getDynamicObjectCollection("oprentryentity");
            for (int j = 0; j < entryCol.size(); ++j) {
                DynamicObject entryObj = (DynamicObject)entryCol.get(j);
                if (!message.contains(entryObj.getPkValue())) continue;
                if (entryObj.getBoolean("oprinvalid")) {
                    this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\u5e8f\u5217[%1$s]\u4e0b\u5de5\u5e8f[%2$s]\u5df2\u4f5c\u5e9f,\u4e0d\u5141\u8bb8\u6267\u884c\u81f3\u4e0b\u8fbe\u3002", (String)"MROManuftechValidator_27", (String)"mmc-sfc-opplugin", (Object[])new Object[0]), entryObj.getString("oprparent"), entryObj.getString("oprno")));
                }
                if (!status.contains(entryObj.getString("oprstatus"))) continue;
                this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\u5e8f\u5217[%1$s]\u4e0b\u5de5\u5e8f[%2$s]\u72b6\u6001\u4e3a[\u5f00\u5de5][\u68c0\u9a8c\u5b8c\u5de5],\u4e0d\u5141\u8bb8\u6267\u884c\u81f3\u4e0b\u8fbe\u3002", (String)"MROManuftechValidator_28", (String)"mmc-sfc-opplugin", (Object[])new Object[0]), entryObj.getString("oprparent"), entryObj.getString("oprno")));
            }
        }
    }

    private void validDonothingStart(Map<Long, Map<String, Object>> orderByEntryId) {
        List message = CheckUtil.getManftechEntryID((String)this.getOption().getVariableValue("operateOption"));
        if (message == null) {
            return;
        }
        HashSet status = Sets.newHashSet((Object[])new String[]{"F"});
        for (int i = 0; i < this.dataEntities.length; ++i) {
            StringBuffer error1;
            DynamicObject obj = this.dataEntities[i].getDataEntity();
            Map<String, Object> map = orderByEntryId.get(obj.getDynamicObject("mftentryseq").getLong("id"));
            StringBuffer error = CheckManuOrderUtil.checkManuOrderEntryStatus((String)"checkTaskStatus", (String)obj.getString("billno"), (String)ResManager.loadKDString((String)"\u6267\u884c\u81f3\u5f00\u5de5", (String)"MROManuftechValidator_29", (String)"mmc-sfc-opplugin", (Object[])new Object[0]), map, (String)ResManager.loadKDString((String)"\u68c0\u4fee", (String)"MROManuftechValidator_63", (String)"mmc-sfc-opplugin", (Object[])new Object[0]));
            if (error.length() > 0) {
                this.addErrorMessage(this.dataEntities[i], error.toString());
            }
            if ((error1 = CheckManuOrderUtil.checkManuOrderEntryStatus((String)"checkBizStatus", (String)obj.getString("billno"), (String)ResManager.loadKDString((String)"\u6267\u884c\u81f3\u5f00\u5de5", (String)"MROManuftechValidator_29", (String)"mmc-sfc-opplugin", (Object[])new Object[0]), map, (String)ResManager.loadKDString((String)"\u68c0\u4fee", (String)"MROManuftechValidator_63", (String)"mmc-sfc-opplugin", (Object[])new Object[0]))).length() > 0) {
                this.addErrorMessage(this.dataEntities[i], error1.toString());
            }
            DynamicObjectCollection entryCol = obj.getDynamicObjectCollection("oprentryentity");
            for (int j = 0; j < entryCol.size(); ++j) {
                DynamicObject entryObj = (DynamicObject)entryCol.get(j);
                if (!message.contains(entryObj.getPkValue())) continue;
                if (entryObj.getBoolean("oprinvalid")) {
                    this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\u5e8f\u5217[%1$s]\u4e0b\u5de5\u5e8f[%2$s]\u5df2\u4f5c\u5e9f,\u4e0d\u5141\u8bb8\u6267\u884c\u81f3\u5f00\u5de5\u3002", (String)"MROManuftechValidator_30", (String)"mmc-sfc-opplugin", (Object[])new Object[0]), entryObj.getString("oprparent"), entryObj.getString("oprno")));
                }
                if (!status.contains(entryObj.getString("oprstatus"))) continue;
                this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\u5e8f\u5217[%1$s]\u4e0b\u5de5\u5e8f[%2$s]\u72b6\u6001\u4e3a[\u68c0\u9a8c\u5b8c\u5de5],\u4e0d\u5141\u8bb8\u6267\u884c\u81f3\u5f00\u5de5\u3002", (String)"MROManuftechValidator_64", (String)"mmc-sfc-opplugin", (Object[])new Object[0]), entryObj.getString("oprparent"), entryObj.getString("oprno")));
            }
        }
    }

    private void validDonothingRepairFinish(Map<Long, Map<String, Object>> orderByEntryId) {
        List message = CheckUtil.getManftechEntryID((String)this.getOption().getVariableValue("operateOption"));
        if (message == null) {
            return;
        }
        HashSet status = Sets.newHashSet((Object[])new String[]{"F"});
        for (int i = 0; i < this.dataEntities.length; ++i) {
            StringBuffer error1;
            DynamicObject obj = this.dataEntities[i].getDataEntity();
            Map<String, Object> map = orderByEntryId.get(obj.getDynamicObject("mftentryseq").getLong("id"));
            StringBuffer error = CheckManuOrderUtil.checkManuOrderEntryStatus((String)"checkTaskStatus", (String)obj.getString("billno"), (String)ResManager.loadKDString((String)"\u6267\u884c\u81f3\u5b8c\u5de5", (String)"MROManuftechValidator_31", (String)"mmc-sfc-opplugin", (Object[])new Object[0]), map, (String)ResManager.loadKDString((String)"\u68c0\u4fee", (String)"MROManuftechValidator_63", (String)"mmc-sfc-opplugin", (Object[])new Object[0]));
            if (error.length() > 0) {
                this.addErrorMessage(this.dataEntities[i], error.toString());
            }
            if ((error1 = CheckManuOrderUtil.checkManuOrderEntryStatus((String)"checkBizStatus", (String)obj.getString("billno"), (String)ResManager.loadKDString((String)"\u6267\u884c\u81f3\u5b8c\u5de5", (String)"MROManuftechValidator_31", (String)"mmc-sfc-opplugin", (Object[])new Object[0]), map, (String)ResManager.loadKDString((String)"\u68c0\u4fee", (String)"MROManuftechValidator_63", (String)"mmc-sfc-opplugin", (Object[])new Object[0]))).length() > 0) {
                this.addErrorMessage(this.dataEntities[i], error1.toString());
            }
            DynamicObjectCollection entryCol = obj.getDynamicObjectCollection("oprentryentity");
            for (int j = 0; j < entryCol.size(); ++j) {
                DynamicObject entryObj = (DynamicObject)entryCol.get(j);
                if (!message.contains(entryObj.getPkValue())) continue;
                if (entryObj.getBoolean("oprinvalid")) {
                    this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\u5e8f\u5217[%1$s]\u4e0b\u5de5\u5e8f[%2$s]\u5df2\u4f5c\u5e9f,\u4e0d\u5141\u8bb8\u6267\u884c\u81f3\u7ef4\u4fee\u5b8c\u5de5\u3002", (String)"MROManuftechValidator_32", (String)"mmc-sfc-opplugin", (Object[])new Object[0]), entryObj.getString("oprparent"), entryObj.getString("oprno")));
                }
                if (!status.contains(entryObj.getString("oprstatus"))) continue;
                this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\u5e8f\u5217[%1$s]\u4e0b\u5de5\u5e8f[%2$s]\u72b6\u6001\u4e3a[\u68c0\u9a8c\u5b8c\u5de5],\u4e0d\u5141\u8bb8\u6267\u884c\u81f3\u7ef4\u4fee\u5b8c\u5de5\u3002", (String)"MROManuftechValidator_33", (String)"mmc-sfc-opplugin", (Object[])new Object[0]), entryObj.getString("oprparent"), entryObj.getString("oprno")));
            }
        }
    }

    private void validDonothingFinish(Map<Long, Map<String, Object>> orderByEntryId) {
        List message = CheckUtil.getManftechEntryID((String)this.getOption().getVariableValue("operateOption"));
        if (message == null) {
            return;
        }
        for (int i = 0; i < this.dataEntities.length; ++i) {
            StringBuffer error1;
            DynamicObject obj = this.dataEntities[i].getDataEntity();
            Map<String, Object> map = orderByEntryId.get(obj.getDynamicObject("mftentryseq").getLong("id"));
            StringBuffer error = CheckManuOrderUtil.checkManuOrderEntryStatus((String)"checkTaskStatus", (String)obj.getString("billno"), (String)ResManager.loadKDString((String)"\u6267\u884c\u81f3\u5b8c\u5de5", (String)"MROManuftechValidator_31", (String)"mmc-sfc-opplugin", (Object[])new Object[0]), map, (String)ResManager.loadKDString((String)"\u68c0\u4fee", (String)"MROManuftechValidator_63", (String)"mmc-sfc-opplugin", (Object[])new Object[0]));
            if (error.length() > 0) {
                this.addErrorMessage(this.dataEntities[i], error.toString());
            }
            if ((error1 = CheckManuOrderUtil.checkManuOrderEntryStatus((String)"checkBizStatus", (String)obj.getString("billno"), (String)ResManager.loadKDString((String)"\u6267\u884c\u81f3\u5b8c\u5de5", (String)"MROManuftechValidator_31", (String)"mmc-sfc-opplugin", (Object[])new Object[0]), map, (String)ResManager.loadKDString((String)"\u68c0\u4fee", (String)"MROManuftechValidator_63", (String)"mmc-sfc-opplugin", (Object[])new Object[0]))).length() > 0) {
                this.addErrorMessage(this.dataEntities[i], error1.toString());
            }
            DynamicObjectCollection entryCol = obj.getDynamicObjectCollection("oprentryentity");
            for (int j = 0; j < entryCol.size(); ++j) {
                DynamicObject entryObj = (DynamicObject)entryCol.get(j);
                if (!message.contains(entryObj.getPkValue()) || !entryObj.getBoolean("oprinvalid")) continue;
                this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\u5e8f\u5217[%1$s]\u4e0b\u5de5\u5e8f[%2$s]\u5df2\u4f5c\u5e9f,\u4e0d\u5141\u8bb8\u6267\u884c\u81f3\u5b8c\u5de5\u3002", (String)"MROManuftechValidator_65", (String)"mmc-sfc-opplugin", (Object[])new Object[0]), entryObj.getString("oprparent"), entryObj.getString("oprno")));
            }
        }
    }

    private void validDonothingToCancel(Map<Long, Map<String, Object>> orderByEntryId) {
        List message = CheckUtil.getManftechEntryID((String)this.getOption().getVariableValue("operateOption"));
        if (message == null) {
            return;
        }
        HashSet status = Sets.newHashSet((Object[])new String[]{"F"});
        for (int i = 0; i < this.dataEntities.length; ++i) {
            DynamicObject obj = this.dataEntities[i].getDataEntity();
            DynamicObjectCollection entryCol = obj.getDynamicObjectCollection("oprentryentity");
            for (int j = 0; j < entryCol.size(); ++j) {
                DynamicObject entryObj = (DynamicObject)entryCol.get(j);
                if (!message.contains(entryObj.getPkValue())) continue;
                if (entryObj.getBoolean("oprinvalid")) {
                    this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\u5e8f\u5217[%1$s]\u4e0b\u5de5\u5e8f[%2$s]\u5df2\u4f5c\u5e9f,\u4e0d\u5141\u8bb8\u6267\u884c\u81f3\u53d6\u6d88\u3002", (String)"MROManuftechValidator_34", (String)"mmc-sfc-opplugin", (Object[])new Object[0]), entryObj.getString("oprparent"), entryObj.getString("oprno")));
                }
                if (!status.contains(entryObj.getString("oprstatus"))) continue;
                this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\u5e8f\u5217[%1$s]\u4e0b\u5de5\u5e8f[%2$s]\u72b6\u6001\u4e3a[\u68c0\u9a8c\u5b8c\u5de5],\u4e0d\u5141\u8bb8\u6267\u884c\u81f3\u53d6\u6d88\u3002", (String)"MROManuftechValidator_35", (String)"mmc-sfc-opplugin", (Object[])new Object[0]), entryObj.getString("oprparent"), entryObj.getString("oprno")));
            }
        }
    }

    private void validDonothingRetain(Map<Long, Map<String, Object>> orderByEntryId) {
        List message = CheckUtil.getManftechEntryID((String)this.getOption().getVariableValue("operateOption"));
        if (message == null) {
            return;
        }
        HashSet status = Sets.newHashSet((Object[])new String[]{"F"});
        for (int i = 0; i < this.dataEntities.length; ++i) {
            DynamicObject obj = this.dataEntities[i].getDataEntity();
            DynamicObjectCollection entryCol = obj.getDynamicObjectCollection("oprentryentity");
            for (int j = 0; j < entryCol.size(); ++j) {
                DynamicObject entryObj = (DynamicObject)entryCol.get(j);
                if (!message.contains(entryObj.getPkValue())) continue;
                if (entryObj.getBoolean("oprinvalid")) {
                    this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\u5e8f\u5217[%1$s]\u4e0b\u5de5\u5e8f[%2$s]\u5df2\u4f5c\u5e9f,\u4e0d\u5141\u8bb8\u6267\u884c\u81f3\u4fdd\u7559\u3002", (String)"MROManuftechValidator_36", (String)"mmc-sfc-opplugin", (Object[])new Object[0]), entryObj.getString("oprparent"), entryObj.getString("oprno")));
                }
                if (!status.contains(entryObj.getString("oprstatus"))) continue;
                this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\u5e8f\u5217[%1$s]\u4e0b\u5de5\u5e8f[%2$s]\u72b6\u6001\u4e3a[\u68c0\u9a8c\u5b8c\u5de5],\u4e0d\u5141\u8bb8\u6267\u884c\u81f3\u4fdd\u7559\u3002", (String)"MROManuftechValidator_37", (String)"mmc-sfc-opplugin", (Object[])new Object[0]), entryObj.getString("oprparent"), entryObj.getString("oprno")));
            }
        }
    }

    private void validDonothingClosed(Map<Long, Map<String, Object>> orderByEntryId) {
        List message = CheckUtil.getManftechEntryID((String)this.getOption().getVariableValue("operateOption"));
        if (message == null) {
            return;
        }
        for (int i = 0; i < this.dataEntities.length; ++i) {
            StringBuffer error1;
            DynamicObject obj = this.dataEntities[i].getDataEntity();
            Map<String, Object> map = orderByEntryId.get(obj.getDynamicObject("mftentryseq").getLong("id"));
            StringBuffer error = CheckManuOrderUtil.checkManuOrderEntryStatus((String)"checkTaskStatus", (String)obj.getString("billno"), (String)ResManager.loadKDString((String)"\u6267\u884c\u81f3\u5173\u95ed", (String)"MROManuftechValidator_38", (String)"mmc-sfc-opplugin", (Object[])new Object[0]), map, (String)ResManager.loadKDString((String)"\u68c0\u4fee", (String)"MROManuftechValidator_63", (String)"mmc-sfc-opplugin", (Object[])new Object[0]));
            if (error.length() > 0) {
                this.addErrorMessage(this.dataEntities[i], error.toString());
            }
            if ((error1 = CheckManuOrderUtil.checkManuOrderEntryStatus((String)"checkBizStatus", (String)obj.getString("billno"), (String)ResManager.loadKDString((String)"\u6267\u884c\u81f3\u5173\u95ed", (String)"MROManuftechValidator_38", (String)"mmc-sfc-opplugin", (Object[])new Object[0]), map, (String)ResManager.loadKDString((String)"\u68c0\u4fee", (String)"MROManuftechValidator_63", (String)"mmc-sfc-opplugin", (Object[])new Object[0]))).length() > 0) {
                this.addErrorMessage(this.dataEntities[i], error1.toString());
            }
            DynamicObjectCollection entryCol = obj.getDynamicObjectCollection("oprentryentity");
            for (int j = 0; j < entryCol.size(); ++j) {
                DynamicObject entryObj = (DynamicObject)entryCol.get(j);
                if (!message.contains(entryObj.getPkValue())) continue;
                if (entryObj.getBoolean("oprinvalid")) {
                    this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\u5e8f\u5217[%1$s]\u4e0b\u5de5\u5e8f[%2$s]\u5df2\u4f5c\u5e9f,\u4e0d\u5141\u8bb8\u6267\u884c\u81f3\u5173\u95ed\u3002", (String)"MROManuftechValidator_39", (String)"mmc-sfc-opplugin", (Object[])new Object[0]), entryObj.getString("oprparent"), entryObj.getString("oprno")));
                }
                if ("F".contains(entryObj.getString("oprstatus"))) continue;
                this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\u5e8f\u5217[%1$s]\u4e0b\u5de5\u5e8f[%2$s]\u72b6\u6001\u4e0d\u4e3a[\u68c0\u9a8c\u5b8c\u5de5],\u4e0d\u5141\u8bb8\u6267\u884c\u81f3\u5173\u95ed\u3002", (String)"MROManuftechValidator_40", (String)"mmc-sfc-opplugin", (Object[])new Object[0]), entryObj.getString("oprparent"), entryObj.getString("oprno")));
            }
        }
    }

    private void validDonothingUnplan(Map<Long, Map<String, Object>> orderByEntryId) {
        List message = CheckUtil.getManftechEntryID((String)this.getOption().getVariableValue("operateOption"));
        if (message == null) {
            return;
        }
        HashSet status = Sets.newHashSet((Object[])new String[]{"I", "J"});
        for (int i = 0; i < this.dataEntities.length; ++i) {
            DynamicObject obj = this.dataEntities[i].getDataEntity();
            Map<String, Object> map = orderByEntryId.get(obj.getDynamicObject("mftentryseq").getLong("id"));
            StringBuffer error = CheckManuOrderUtil.checkManuOrderEntryStatus((String)"checkTaskStatus", (String)obj.getString("billno"), (String)ResManager.loadKDString((String)"\u53cd\u6267\u884c\u81f3\u8ba1\u5212", (String)"MROManuftechValidator_41", (String)"mmc-sfc-opplugin", (Object[])new Object[0]), map, (String)ResManager.loadKDString((String)"\u68c0\u4fee", (String)"MROManuftechValidator_63", (String)"mmc-sfc-opplugin", (Object[])new Object[0]));
            if (error.length() > 0) {
                this.addErrorMessage(this.dataEntities[i], error.toString());
            }
            DynamicObjectCollection entryCol = obj.getDynamicObjectCollection("oprentryentity");
            for (int j = 0; j < entryCol.size(); ++j) {
                DynamicObject entryObj = (DynamicObject)entryCol.get(j);
                if (!message.contains(entryObj.getPkValue())) continue;
                if (entryObj.getBoolean("oprinvalid")) {
                    this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\u5e8f\u5217[%1$s]\u4e0b\u5de5\u5e8f[%2$s]\u5df2\u4f5c\u5e9f,\u4e0d\u5141\u8bb8\u53cd\u6267\u884c\u81f3\u8ba1\u5212\u3002", (String)"MROManuftechValidator_42", (String)"mmc-sfc-opplugin", (Object[])new Object[0]), entryObj.getString("oprparent"), entryObj.getString("oprno")));
                }
                if (!status.contains(entryObj.getString("oprstatus"))) continue;
                this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\u5e8f\u5217[%1$s]\u4e0b\u5de5\u5e8f[%2$s]\u72b6\u6001\u4e3a[\u53d6\u6d88][\u4fdd\u7559],\u4e0d\u5141\u8bb8\u53cd\u6267\u884c\u81f3\u8ba1\u5212\u3002", (String)"MROManuftechValidator_76", (String)"mmc-sfc-opplugin", (Object[])new Object[0]), entryObj.getString("oprparent"), entryObj.getString("oprno")));
            }
        }
    }

    private void validDonothingUnconfirm(Map<Long, Map<String, Object>> orderByEntryId) {
        List message = CheckUtil.getManftechEntryID((String)this.getOption().getVariableValue("operateOption"));
        if (message == null) {
            return;
        }
        HashSet status = Sets.newHashSet((Object[])new String[]{"B", "I", "J"});
        for (int i = 0; i < this.dataEntities.length; ++i) {
            DynamicObject obj = this.dataEntities[i].getDataEntity();
            Map<String, Object> map = orderByEntryId.get(obj.getDynamicObject("mftentryseq").getLong("id"));
            StringBuffer error = CheckManuOrderUtil.checkManuOrderEntryStatus((String)"checkTaskStatus", (String)obj.getString("billno"), (String)ResManager.loadKDString((String)"\u53cd\u6267\u884c\u81f3\u786e\u8ba4", (String)"MROManuftechValidator_44", (String)"mmc-sfc-opplugin", (Object[])new Object[0]), map, (String)ResManager.loadKDString((String)"\u68c0\u4fee", (String)"MROManuftechValidator_63", (String)"mmc-sfc-opplugin", (Object[])new Object[0]));
            if (error.length() > 0) {
                this.addErrorMessage(this.dataEntities[i], error.toString());
            }
            DynamicObjectCollection entryCol = obj.getDynamicObjectCollection("oprentryentity");
            for (int j = 0; j < entryCol.size(); ++j) {
                DynamicObject entryObj = (DynamicObject)entryCol.get(j);
                if (!message.contains(entryObj.getPkValue())) continue;
                if (entryObj.getBoolean("oprinvalid")) {
                    this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\u5e8f\u5217[%1$s]\u4e0b\u5de5\u5e8f[%2$s]\u5df2\u4f5c\u5e9f,\u4e0d\u5141\u8bb8\u53cd\u6267\u884c\u81f3\u786e\u8ba4\u3002", (String)"MROManuftechValidator_45", (String)"mmc-sfc-opplugin", (Object[])new Object[0]), entryObj.getString("oprparent"), entryObj.getString("oprno")));
                }
                if (!status.contains(entryObj.getString("oprstatus"))) continue;
                this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\u5e8f\u5217[%1$s]\u4e0b\u5de5\u5e8f[%2$s]\u72b6\u6001\u4e3a[\u8ba1\u5212][\u53d6\u6d88][\u4fdd\u7559],\u4e0d\u5141\u8bb8\u53cd\u6267\u884c\u81f3\u786e\u8ba4\u3002", (String)"MROManuftechValidator_46", (String)"mmc-sfc-opplugin", (Object[])new Object[0]), entryObj.getString("oprparent"), entryObj.getString("oprno")));
            }
        }
    }

    private void validDonothingUnrelase(Map<Long, Map<String, Object>> orderByEntryId) {
        List message = CheckUtil.getManftechEntryID((String)this.getOption().getVariableValue("operateOption"));
        if (message == null) {
            return;
        }
        HashSet status = Sets.newHashSet((Object[])new String[]{"B", "C"});
        for (int i = 0; i < this.dataEntities.length; ++i) {
            DynamicObject obj = this.dataEntities[i].getDataEntity();
            Map<String, Object> map = orderByEntryId.get(obj.getDynamicObject("mftentryseq").getLong("id"));
            StringBuffer error = CheckManuOrderUtil.checkManuOrderEntryStatus((String)"checkTaskStatus", (String)obj.getString("billno"), (String)ResManager.loadKDString((String)"\u53cd\u6267\u884c\u81f3\u4e0b\u8fbe", (String)"MROManuftechValidator_47", (String)"mmc-sfc-opplugin", (Object[])new Object[0]), map, (String)ResManager.loadKDString((String)"\u68c0\u4fee", (String)"MROManuftechValidator_63", (String)"mmc-sfc-opplugin", (Object[])new Object[0]));
            if (error.length() > 0) {
                this.addErrorMessage(this.dataEntities[i], error.toString());
            }
            DynamicObjectCollection entryCol = obj.getDynamicObjectCollection("oprentryentity");
            for (int j = 0; j < entryCol.size(); ++j) {
                DynamicObject entryObj = (DynamicObject)entryCol.get(j);
                if (!message.contains(entryObj.getPkValue())) continue;
                if (entryObj.getBoolean("oprinvalid")) {
                    this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\u5e8f\u5217[%1$s]\u4e0b\u5de5\u5e8f[%2$s]\u5df2\u4f5c\u5e9f,\u4e0d\u5141\u8bb8\u53cd\u6267\u884c\u81f3\u4e0b\u8fbe\u3002", (String)"MROManuftechValidator_48", (String)"mmc-sfc-opplugin", (Object[])new Object[0]), entryObj.getString("oprparent"), entryObj.getString("oprno")));
                }
                if (!status.contains(entryObj.getString("oprstatus"))) continue;
                this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\u5e8f\u5217[%1$s]\u4e0b\u5de5\u5e8f[%2$s]\u72b6\u6001\u4e3a[\u8ba1\u5212][\u8ba1\u5212\u786e\u8ba4],\u4e0d\u5141\u8bb8\u53cd\u6267\u884c\u81f3\u4e0b\u8fbe\u3002", (String)"MROManuftechValidator_49", (String)"mmc-sfc-opplugin", (Object[])new Object[0]), entryObj.getString("oprparent"), entryObj.getString("oprno")));
            }
        }
    }

    private void validDonothingUnstart(Map<Long, Map<String, Object>> orderByEntryId) {
        List message = CheckUtil.getManftechEntryID((String)this.getOption().getVariableValue("operateOption"));
        if (message == null) {
            return;
        }
        HashSet status = Sets.newHashSet((Object[])new String[]{"B", "C", "D", "I", "J"});
        for (int i = 0; i < this.dataEntities.length; ++i) {
            DynamicObject obj = this.dataEntities[i].getDataEntity();
            Map<String, Object> map = orderByEntryId.get(obj.getDynamicObject("mftentryseq").getLong("id"));
            StringBuffer error = CheckManuOrderUtil.checkManuOrderEntryStatus((String)"checkTaskStatus", (String)obj.getString("billno"), (String)ResManager.loadKDString((String)"\u53cd\u6267\u884c\u81f3\u5f00\u5de5", (String)"MROManuftechValidator_50", (String)"mmc-sfc-opplugin", (Object[])new Object[0]), map, (String)ResManager.loadKDString((String)"\u68c0\u4fee", (String)"MROManuftechValidator_63", (String)"mmc-sfc-opplugin", (Object[])new Object[0]));
            if (error.length() > 0) {
                this.addErrorMessage(this.dataEntities[i], error.toString());
            }
            DynamicObjectCollection entryCol = obj.getDynamicObjectCollection("oprentryentity");
            for (int j = 0; j < entryCol.size(); ++j) {
                DynamicObject entryObj = (DynamicObject)entryCol.get(j);
                if (!message.contains(entryObj.getPkValue())) continue;
                if (entryObj.getBoolean("oprinvalid")) {
                    this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\u5e8f\u5217[%1$s]\u4e0b\u5de5\u5e8f[%2$s]\u5df2\u4f5c\u5e9f,\u4e0d\u5141\u8bb8\u53cd\u6267\u884c\u81f3\u5f00\u5de5\u3002", (String)"MROManuftechValidator_51", (String)"mmc-sfc-opplugin", (Object[])new Object[0]), entryObj.getString("oprparent"), entryObj.getString("oprno")));
                }
                if (!status.contains(entryObj.getString("oprstatus"))) continue;
                this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\u5e8f\u5217[%1$s]\u4e0b\u5de5\u5e8f[%2$s]\u72b6\u6001\u4e3a[\u8ba1\u5212][\u8ba1\u5212\u786e\u8ba4][\u4e0b\u8fbe][\u53d6\u6d88][\u4fdd\u7559],\u4e0d\u5141\u8bb8\u53cd\u6267\u884c\u81f3\u5f00\u5de5\u3002", (String)"MROManuftechValidator_52", (String)"mmc-sfc-opplugin", (Object[])new Object[0]), entryObj.getString("oprparent"), entryObj.getString("oprno")));
            }
        }
    }

    private void validDonothingUnfinish(Map<Long, Map<String, Object>> orderByEntryId) {
        List message = CheckUtil.getManftechEntryID((String)this.getOption().getVariableValue("operateOption"));
        if (message == null) {
            return;
        }
        HashSet status = Sets.newHashSet((Object[])new String[]{"B", "C", "D", "E", "H", "I", "J"});
        for (int i = 0; i < this.dataEntities.length; ++i) {
            DynamicObject obj = this.dataEntities[i].getDataEntity();
            Map<String, Object> map = orderByEntryId.get(obj.getDynamicObject("mftentryseq").getLong("id"));
            StringBuffer error = CheckManuOrderUtil.checkManuOrderEntryStatus((String)"checkTaskStatus", (String)obj.getString("billno"), (String)ResManager.loadKDString((String)"\u53cd\u6267\u884c\u81f3\u5b8c\u5de5", (String)"MROManuftechValidator_53", (String)"mmc-sfc-opplugin", (Object[])new Object[0]), map, (String)ResManager.loadKDString((String)"\u68c0\u4fee", (String)"MROManuftechValidator_63", (String)"mmc-sfc-opplugin", (Object[])new Object[0]));
            if (error.length() > 0) {
                this.addErrorMessage(this.dataEntities[i], error.toString());
            }
            DynamicObjectCollection entryCol = obj.getDynamicObjectCollection("oprentryentity");
            for (int j = 0; j < entryCol.size(); ++j) {
                DynamicObject entryObj = (DynamicObject)entryCol.get(j);
                if (!message.contains(entryObj.getPkValue())) continue;
                if (entryObj.getBoolean("oprinvalid")) {
                    this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\u5e8f\u5217[%1$s]\u4e0b\u5de5\u5e8f[%2$s]\u5df2\u4f5c\u5e9f,\u4e0d\u5141\u8bb8\u53cd\u6267\u884c\u81f3\u68c0\u9a8c\u5b8c\u5de5\u3002", (String)"MROManuftechValidator_54", (String)"mmc-sfc-opplugin", (Object[])new Object[0]), entryObj.getString("oprparent"), entryObj.getString("oprno")));
                }
                if (!status.contains(entryObj.getString("oprstatus"))) continue;
                this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\u5e8f\u5217[%1$s]\u4e0b\u5de5\u5e8f[%2$s]\u72b6\u6001\u4e3a[\u8ba1\u5212][\u8ba1\u5212\u786e\u8ba4][\u4e0b\u8fbe][\u5f00\u5de5][\u7ef4\u4fee\u5b8c\u5de5][\u53d6\u6d88][\u4fdd\u7559],\u4e0d\u5141\u8bb8\u53cd\u6267\u884c\u81f3\u68c0\u9a8c\u5b8c\u5de5\u3002", (String)"MROManuftechValidator_55", (String)"mmc-sfc-opplugin", (Object[])new Object[0]), entryObj.getString("oprparent"), entryObj.getString("oprno")));
            }
        }
    }

    private void validDonothingUnRepairfinish(Map<Long, Map<String, Object>> orderByEntryId) {
        List message = CheckUtil.getManftechEntryID((String)this.getOption().getVariableValue("operateOption"));
        if (message == null) {
            return;
        }
        HashSet status = Sets.newHashSet((Object[])new String[]{"B", "C", "D", "E", "I", "J"});
        for (int i = 0; i < this.dataEntities.length; ++i) {
            DynamicObject obj = this.dataEntities[i].getDataEntity();
            Map<String, Object> map = orderByEntryId.get(obj.getDynamicObject("mftentryseq").getLong("id"));
            StringBuffer error = CheckManuOrderUtil.checkManuOrderEntryStatus((String)"checkTaskStatus", (String)obj.getString("billno"), (String)ResManager.loadKDString((String)"\u53cd\u6267\u884c\u81f3\u5b8c\u5de5", (String)"MROManuftechValidator_53", (String)"mmc-sfc-opplugin", (Object[])new Object[0]), map, (String)ResManager.loadKDString((String)"\u68c0\u4fee", (String)"MROManuftechValidator_63", (String)"mmc-sfc-opplugin", (Object[])new Object[0]));
            if (error.length() > 0) {
                this.addErrorMessage(this.dataEntities[i], error.toString());
            }
            DynamicObjectCollection entryCol = obj.getDynamicObjectCollection("oprentryentity");
            for (int j = 0; j < entryCol.size(); ++j) {
                DynamicObject entryObj = (DynamicObject)entryCol.get(j);
                if (!message.contains(entryObj.getPkValue())) continue;
                if (entryObj.getBoolean("oprinvalid")) {
                    this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\u5e8f\u5217[%1$s]\u4e0b\u5de5\u5e8f[%2$s]\u5df2\u4f5c\u5e9f,\u4e0d\u5141\u8bb8\u53cd\u6267\u884c\u81f3\u7ef4\u4fee\u5b8c\u5de5\u3002", (String)"MROManuftechValidator_56", (String)"mmc-sfc-opplugin", (Object[])new Object[0]), entryObj.getString("oprparent"), entryObj.getString("oprno")));
                }
                if (!status.contains(entryObj.getString("oprstatus"))) continue;
                this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\u5e8f\u5217[%1$s]\u4e0b\u5de5\u5e8f[%2$s]\u72b6\u6001\u4e3a[\u8ba1\u5212][\u8ba1\u5212\u786e\u8ba4][\u4e0b\u8fbe][\u5f00\u5de5][\u53d6\u6d88][\u4fdd\u7559],\u4e0d\u5141\u8bb8\u53cd\u6267\u884c\u81f3\u7ef4\u4fee\u5b8c\u5de5\u3002", (String)"MROManuftechValidator_57", (String)"mmc-sfc-opplugin", (Object[])new Object[0]), entryObj.getString("oprparent"), entryObj.getString("oprno")));
            }
        }
    }

    private void validDonothingCancel(Map<Long, Map<String, Object>> orderByEntryId) {
        List message = CheckUtil.getManftechEntryID((String)this.getOption().getVariableValue("operateOption"));
        if (message == null) {
            return;
        }
        HashSet status = Sets.newHashSet((Object[])new String[]{"A", "B", "C"});
        for (int i = 0; i < this.dataEntities.length; ++i) {
            DynamicObject obj = this.dataEntities[i].getDataEntity();
            DynamicObjectCollection entryCol = obj.getDynamicObjectCollection("oprentryentity");
            for (int j = 0; j < entryCol.size(); ++j) {
                DynamicObject entryObj = (DynamicObject)entryCol.get(j);
                if (!message.contains(entryObj.getPkValue())) continue;
                if (!status.contains(entryObj.getString("oprstatus"))) {
                    this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\u5e8f\u5217[%1$s]\u4e0b\u5de5\u5e8f[%2$s]\u72b6\u6001\u4e0d\u4e3a[\u521b\u5efa][\u8ba1\u5212][\u786e\u8ba4],\u4e0d\u5141\u8bb8\u4f5c\u5e9f\u3002", (String)"MROManuftechValidator_58", (String)"mmc-sfc-opplugin", (Object[])new Object[0]), entryObj.getString("oprparent"), entryObj.getString("oprno")));
                }
                if (!entryObj.getBoolean("oprinvalid")) continue;
                this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\u5e8f\u5217[%1$s]\u4e0b\u5de5\u5e8f[%2$s]\u5df2\u4f5c\u5e9f,\u4e0d\u5141\u8bb8\u91cd\u590d\u4f5c\u5e9f\u3002", (String)"MROManuftechValidator_59", (String)"mmc-sfc-opplugin", (Object[])new Object[0]), entryObj.getString("oprparent"), entryObj.getString("oprno")));
            }
        }
    }

    private void validDonothingUnCancel(Map<Long, Map<String, Object>> orderByEntryId) {
        List message = CheckUtil.getManftechEntryID((String)this.getOption().getVariableValue("operateOption"));
        if (message == null) {
            return;
        }
        for (int i = 0; i < this.dataEntities.length; ++i) {
            DynamicObject obj = this.dataEntities[i].getDataEntity();
            DynamicObjectCollection entryCol = obj.getDynamicObjectCollection("oprentryentity");
            for (int j = 0; j < entryCol.size(); ++j) {
                DynamicObject entryObj = (DynamicObject)entryCol.get(j);
                if (!message.contains(entryObj.getPkValue())) continue;
                if (!entryObj.getBoolean("oprinvalid")) {
                    this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\u5e8f\u5217[%1$s]\u4e0b\u5de5\u5e8f[%2$s]\u672a\u4f5c\u5e9f,\u4e0d\u5141\u8bb8\u53cd\u4f5c\u5e9f\u3002", (String)"MROManuftechValidator_60", (String)"mmc-sfc-opplugin", (Object[])new Object[0]), entryObj.getString("oprparent"), entryObj.getString("oprno")));
                }
                if (entryObj.getBigDecimal("oprtotalsplitqty").compareTo(BigDecimal.ZERO) <= 0) continue;
                this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\u5e8f\u5217[%1$s]\u4e0b\u5de5\u5e8f[%2$s]\u53d1\u751f\u8fc7\u62c6\u5206,\u4e0d\u5141\u8bb8\u53cd\u4f5c\u5e9f\u3002", (String)"MROManuftechValidator_61", (String)"mmc-sfc-opplugin", (Object[])new Object[0]), entryObj.getString("oprparent"), entryObj.getString("oprno")));
            }
        }
    }

    private void processDispatchCheck() {
        List message = CheckUtil.getManftechEntryID((String)this.getOption().getVariableValue("operateOption", ""));
        if (CollectionUtils.isEmpty((Collection)message)) {
            for (int i = 0; i < this.dataEntities.length; ++i) {
                this.addErrorMessage(this.getDataEntities()[i], ResManager.loadKDString((String)"\u8bf7\u9009\u4e2d\u4e00\u884c\u201c\u5de5\u5e8f\u201d\u6570\u636e\u3002", (String)"MROManuftechValidator_15", (String)"mmc-sfc-opplugin", (Object[])new Object[0]));
            }
            return;
        }
        HashSet status = Sets.newHashSet((Object[])new String[]{"F", "G"});
        for (int i = 0; i < this.dataEntities.length; ++i) {
            DynamicObject obj = this.dataEntities[i].getDataEntity();
            DynamicObjectCollection groEntryCol = obj.getDynamicObjectCollection("groentryentity");
            DynamicObjectCollection entryCol = obj.getDynamicObjectCollection("oprentryentity");
            for (int j = 0; j < entryCol.size(); ++j) {
                String result;
                DynamicObject entryObj = (DynamicObject)entryCol.get(j);
                if (!message.contains(entryObj.getPkValue())) continue;
                if (status.contains(entryObj.getString("oprstatus"))) {
                    this.addErrorMessage(this.getDataEntities()[i], ResManager.loadKDString((String)"\u3010\u68c0\u9a8c\u5b8c\u5de5\u3011\u3001\u3010\u5173\u95ed\u3011\u72b6\u6001\u4e0b\u4e0d\u5141\u8bb8\u5de5\u5e8f\u6d3e\u5de5\u3002", (String)"MROManuftechValidator_62", (String)"mmc-sfc-opplugin", (Object[])new Object[0]));
                    continue;
                }
                DynamicObject processgroup = entryObj.getDynamicObject("oprprocessgroup");
                if (null == processgroup || !StringUtils.isNotBlank((CharSequence)(result = MROManuftechUtil.checkGroupStatus((DynamicObjectCollection)groEntryCol, (String)processgroup.getString("id"))))) continue;
                this.addErrorMessage(this.getDataEntities()[i], result);
            }
        }
    }

    private boolean isNull(Object obj) {
        if (obj instanceof String) {
            return obj == null || obj.toString().trim().length() == 0;
        }
        return obj == null;
    }

    private void addErrorMessage(int i, List<String> errors) {
        for (String error : errors) {
            this.addErrorMessage(this.getDataEntities()[i], error);
        }
    }
}

