/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.sfc.opplugin.manuftech.validator;

import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bd.mpdm.business.helper.MaterialMuConvHelper;
import kd.bd.mpdm.common.enums.OperateEnum;
import kd.bd.mpdm.common.query.helper.WorkcenterQueryHelper;
import kd.bd.mpdm.common.query.mservice.helper.MsProcessRouteQueryHelper;
import kd.bd.mpdm.common.utils.DynamicObjDataUtil;
import kd.bd.mpdm.common.utils.ReportUtil;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;
import kd.mmc.sfc.common.manuftech.utils.CheckManuOrderUtil;
import kd.mmc.sfc.common.manuftech.utils.CheckUtil;
import kd.mmc.sfc.common.manuftech.utils.ManuftechUtil;
import kd.mmc.sfc.common.utils.QueryOrderUtil;
import kd.mmc.sfc.common.utils.UnitRateConvertUtil;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;

public class SFCManuftechValidator
extends AbstractValidator {
    private static final Log logger = LogFactory.getLog(SFCManuftechValidator.class);

    public void validate() {
        String operate = this.getOption().getVariableValue("operatekey");
        HashSet<Long> ids = new HashSet<Long>(16);
        HashSet<Long> orderEntryIds = new HashSet<Long>(16);
        HashSet<String> parentPlanIds = new HashSet<String>(16);
        HashSet<Object> orgIds = new HashSet<Object>(16);
        HashSet<Object> processRouteIds = new HashSet<Object>(16);
        for (int i = 0; i < this.dataEntities.length; ++i) {
            DynamicObject obj = this.dataEntities[i].getDataEntity();
            ids.add(obj.getLong("id"));
            parentPlanIds.add(obj.getPkValue().toString());
            if (obj.getDynamicObject("mftentryseq") != null) {
                orderEntryIds.add(obj.getDynamicObject("mftentryseq").getLong("id"));
            }
            if (obj.getDynamicObject("org") != null) {
                orgIds.add(obj.getDynamicObject("org").getPkValue());
            }
            if (obj.getDynamicObject("processroute") == null) continue;
            processRouteIds.add(obj.getDynamicObject("processroute").getPkValue());
        }
        Map orderByEntryId = null;
        switch (operate) {
            case "audit": {
                orderByEntryId = QueryOrderUtil.getOrderByEntryId(orderEntryIds);
                QFilter filter = new QFilter("number", "=", (Object)"110");
                QFilter filter1 = new QFilter("createorg.id", "in", orgIds);
                Map map = BusinessDataServiceHelper.loadFromCache((String)"pdm_internalprocedure", (String)"id,createorg", (QFilter[])new QFilter[]{filter, filter1});
                for (int i = 0; i < this.dataEntities.length; ++i) {
                    this.auditCheck(i, orderByEntryId, map);
                }
                break;
            }
            case "delete": {
                Map<Long, Long> sfcManftech = this.getSfcManftech(parentPlanIds);
                for (int i = 0; i < this.dataEntities.length; ++i) {
                    this.deleteCheck(i, sfcManftech);
                }
                break;
            }
            case "unaudit": {
                Map<Long, Long> data = this.getSfcManftech(parentPlanIds);
                orderByEntryId = QueryOrderUtil.getOrderByEntryId(orderEntryIds);
                for (int i = 0; i < this.dataEntities.length; ++i) {
                    this.unauditCheck(i, data, orderByEntryId);
                }
                break;
            }
            case "save": {
                orderByEntryId = QueryOrderUtil.getOrderByEntryId(orderEntryIds);
                Map processRouteMap = MsProcessRouteQueryHelper.getDataCacheBySet(processRouteIds);
                Map<Long, Long> manftech = this.getSfcManftechByOrderEntryId(orderEntryIds, ids);
                this.setMaterialMuConvCacheLst(this.dataEntities, orderByEntryId, processRouteMap);
                for (int i = 0; i < this.dataEntities.length; ++i) {
                    this.saveCheck(operate, i, orderByEntryId, processRouteMap, manftech);
                }
                break;
            }
            case "submit": {
                orderByEntryId = QueryOrderUtil.getOrderByEntryId(orderEntryIds);
                Map routeMap = MsProcessRouteQueryHelper.getDataCacheBySet(processRouteIds);
                Map<Long, Long> mftech = this.getSfcManftechByOrderEntryId(orderEntryIds, ids);
                this.submitCheck(operate, orderByEntryId, routeMap, mftech);
                break;
            }
            case "row_confirm": {
                orderByEntryId = QueryOrderUtil.getOrderByEntryId(orderEntryIds);
                this.row_operation("row_confirm", orderByEntryId);
                break;
            }
            case "row_release": {
                orderByEntryId = QueryOrderUtil.getOrderByEntryId(orderEntryIds);
                this.row_operation("row_release", orderByEntryId);
                break;
            }
            case "row_start": {
                orderByEntryId = QueryOrderUtil.getOrderByEntryId(orderEntryIds);
                this.row_operation("row_start", orderByEntryId);
                break;
            }
            case "row_finish": {
                orderByEntryId = QueryOrderUtil.getOrderByEntryId(orderEntryIds);
                this.row_operation("row_finish", orderByEntryId);
                break;
            }
            case "row_closed": {
                orderByEntryId = QueryOrderUtil.getOrderByEntryId(orderEntryIds);
                this.row_operation("row_closed", orderByEntryId);
                break;
            }
            case "row_unplan": {
                orderByEntryId = QueryOrderUtil.getOrderByEntryId(orderEntryIds);
                this.row_operation("row_unplan", orderByEntryId);
                break;
            }
            case "row_unconfirm": {
                orderByEntryId = QueryOrderUtil.getOrderByEntryId(orderEntryIds);
                this.row_operation("row_unconfirm", orderByEntryId);
                break;
            }
            case "row_unrelease": {
                orderByEntryId = QueryOrderUtil.getOrderByEntryId(orderEntryIds);
                this.row_operation("row_unrelease", orderByEntryId);
                break;
            }
            case "row_unstart": {
                orderByEntryId = QueryOrderUtil.getOrderByEntryId(orderEntryIds);
                this.row_operation("row_unstart", orderByEntryId);
                break;
            }
            case "row_unfinish": {
                orderByEntryId = QueryOrderUtil.getOrderByEntryId(orderEntryIds);
                this.row_operation("row_unfinish", orderByEntryId);
                break;
            }
            case "row_cancel": {
                orderByEntryId = QueryOrderUtil.getOrderByEntryId(orderEntryIds);
                this.row_operation("row_cancel", orderByEntryId);
                break;
            }
            case "row_uncancel": {
                orderByEntryId = QueryOrderUtil.getOrderByEntryId(orderEntryIds);
                this.row_operation("row_uncancel", orderByEntryId);
                break;
            }
        }
    }

    private void row_operation(String operatekey, Map<Long, Map<String, Object>> orderByEntryId) {
        List message = CheckUtil.getManftechEntryID((String)this.getOption().getVariableValue("operateOption", ""));
        if (CollectionUtils.isEmpty((Collection)message)) {
            for (int i = 0; i < this.dataEntities.length; ++i) {
                this.addErrorMessage(this.getDataEntities()[i], ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u201c\u5de5\u5e8f\u201d\u6570\u636e\u3002", (String)"SFCManuftechValidator_144", (String)"mmc-sfc-opplugin", (Object[])new Object[0]));
            }
            return;
        }
        switch (operatekey) {
            case "row_confirm": {
                this.validDonothingConfirm(orderByEntryId);
                break;
            }
            case "row_release": {
                this.validDonothingRelease(orderByEntryId);
                break;
            }
            case "row_start": {
                this.validDonothingStart(orderByEntryId);
                break;
            }
            case "row_finish": {
                this.validDonothingFinish(orderByEntryId);
                break;
            }
            case "row_closed": {
                this.validDonothingClosed(orderByEntryId);
                break;
            }
            case "row_unplan": {
                this.validDonothingUnplan(orderByEntryId);
                break;
            }
            case "row_unconfirm": {
                this.validDonothingUnconfirm(orderByEntryId);
                break;
            }
            case "row_unrelease": {
                this.validDonothingUnrelase(orderByEntryId);
                break;
            }
            case "row_unstart": {
                this.validDonothingUnstart(orderByEntryId);
                break;
            }
            case "row_unfinish": {
                this.validDonothingUnfinish(orderByEntryId);
                break;
            }
            case "row_cancel": {
                this.validDonothingCancel(orderByEntryId);
                break;
            }
            case "row_uncancel": {
                this.validDonothingUnCancel(orderByEntryId);
                break;
            }
        }
    }

    private void validDonothingConfirm(Map<Long, Map<String, Object>> orderByEntryId) {
        LinkedHashSet<Object> list = new LinkedHashSet<Object>();
        List message = CheckUtil.getManftechEntryID((String)this.getOption().getVariableValue("operateOption"));
        if (message == null) {
            return;
        }
        HashSet status = Sets.newHashSet((Object[])new String[]{"B", "A"});
        Set existsIDSet = CheckUtil.getExistsIDSet((ExtendedDataEntity[])this.dataEntities);
        for (int i = 0; i < this.dataEntities.length; ++i) {
            DynamicObject obj = this.dataEntities[i].getDataEntity();
            Object billPK = obj.getPkValue();
            ArrayList<String> errors = new ArrayList<String>();
            if (list.contains(billPK) || CheckUtil.getDynamicObjectTypeName((DynamicObject)obj) == null) continue;
            if (!CheckUtil.isDataChange(errors, (boolean)existsIDSet.contains(billPK))) {
                this.addErrorMessage(i, errors);
                continue;
            }
            if (!"C".equals(obj.get("billstatus"))) {
                list.add(billPK);
                this.addErrorMessage(this.dataEntities[i], ResManager.loadKDString((String)"\u5de5\u5e8f\u8ba1\u5212\u672a\u5ba1\u6838\uff0c\u4e0d\u5141\u8bb8\u6267\u884c\u81f3\u786e\u8ba4\u3002", (String)"SFCManuftechValidator_0", (String)"mmc-sfc-opplugin", (Object[])new Object[0]));
                continue;
            }
            Map<String, Object> map = orderByEntryId.get(obj.getDynamicObject("mftentryseq").getLong("id"));
            StringBuffer error = CheckManuOrderUtil.checkManuOrderEntryStatus((String)"checkTaskStatus", (String)obj.getString("billno"), (String)ResManager.loadKDString((String)"\u6267\u884c\u81f3\u786e\u8ba4", (String)"SFCManuftechValidator_1", (String)"mmc-sfc-opplugin", (Object[])new Object[0]), map, (String)ResManager.loadKDString((String)"\u751f\u4ea7", (String)"SFCManuftechValidator_145", (String)"mmc-sfc-opplugin", (Object[])new Object[0]));
            if (error.length() > 0) {
                this.addErrorMessage(this.dataEntities[i], error.toString());
            }
            DynamicObjectCollection entryCol = obj.getDynamicObjectCollection("oprentryentity");
            for (int j = 0; j < entryCol.size(); ++j) {
                DynamicObject entryObj = (DynamicObject)entryCol.get(j);
                if (!message.contains(entryObj.getPkValue())) continue;
                if (entryObj.getBoolean("oprinvalid")) {
                    this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\u5df2\u4f5c\u5e9f\uff0c\u4e0d\u5141\u8bb8\u6267\u884c\u81f3\u786e\u8ba4\uff08\u5de5\u5e8f\u5e8f\u5217\uff1a%1$s\uff1b\u5de5\u5e8f\u53f7\uff1a%2$s\uff09\u3002", (String)"SFCManuftechValidator_2", (String)"mmc-sfc-opplugin", (Object[])new Object[0]), entryObj.getString("oprparent"), entryObj.getString("oprno")));
                    continue;
                }
                if (!"1002".equals(entryObj.getString("machiningtype")) || "sfc_manftech".equals(obj.getDataEntityType().getName())) {
                    // empty if block
                }
                if (status.contains(entryObj.getString("oprstatus"))) continue;
                this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\u72b6\u6001\u4e3a\u201c\u521b\u5efa\u201d\u6216\u8005\u201c\u8ba1\u5212\u201d\u65f6\uff0c\u624d\u53ef\u6267\u884c\u81f3\u786e\u8ba4\uff08\u5de5\u5e8f\u5e8f\u5217\uff1a%1$s\uff1b\u5de5\u5e8f\u53f7\uff1a%2$s\uff09\u3002", (String)"SFCManuftechValidator_4", (String)"mmc-sfc-opplugin", (Object[])new Object[0]), entryObj.getString("oprparent"), entryObj.getString("oprno")));
            }
        }
    }

    private void addErrorMessage(int i, List<String> errors) {
        for (String error : errors) {
            this.addErrorMessage(this.getDataEntities()[i], error);
        }
    }

    private void validDonothingRelease(Map<Long, Map<String, Object>> orderByEntryId) {
        LinkedHashSet<Object> list = new LinkedHashSet<Object>();
        List message = CheckUtil.getManftechEntryID((String)this.getOption().getVariableValue("operateOption"));
        if (message == null) {
            return;
        }
        Set existsIDSet = CheckUtil.getExistsIDSet((ExtendedDataEntity[])this.dataEntities);
        HashSet status = Sets.newHashSet((Object[])new String[]{"A", "B", "C"});
        for (int i = 0; i < this.dataEntities.length; ++i) {
            StringBuffer error1;
            DynamicObject obj = this.dataEntities[i].getDataEntity();
            Object billPK = obj.getPkValue();
            ArrayList<String> errors = new ArrayList<String>();
            if (list.contains(billPK) || CheckUtil.getDynamicObjectTypeName((DynamicObject)obj) == null) continue;
            if (!CheckUtil.isDataChange(errors, (boolean)existsIDSet.contains(billPK))) {
                this.addErrorMessage(i, errors);
                continue;
            }
            if (!"C".equals(obj.get("billstatus"))) {
                list.add(billPK);
                this.addErrorMessage(this.dataEntities[i], ResManager.loadKDString((String)"\u5de5\u5e8f\u8ba1\u5212\u672a\u5ba1\u6838\uff0c\u4e0d\u5141\u8bb8\u6267\u884c\u81f3\u4e0b\u8fbe\u3002", (String)"SFCManuftechValidator_5", (String)"mmc-sfc-opplugin", (Object[])new Object[0]));
                continue;
            }
            Map<String, Object> map = orderByEntryId.get(obj.getDynamicObject("mftentryseq").getLong("id"));
            StringBuffer error = CheckManuOrderUtil.checkManuOrderEntryStatus((String)"checkTaskStatus", (String)obj.getString("billno"), (String)ResManager.loadKDString((String)"\u6267\u884c\u81f3\u4e0b\u8fbe", (String)"SFCManuftechValidator_6", (String)"mmc-sfc-opplugin", (Object[])new Object[0]), map, (String)ResManager.loadKDString((String)"\u751f\u4ea7", (String)"SFCManuftechValidator_145", (String)"mmc-sfc-opplugin", (Object[])new Object[0]));
            if (error.length() > 0) {
                this.addErrorMessage(this.dataEntities[i], error.toString());
            }
            if ((error1 = CheckManuOrderUtil.checkManuOrderEntryStatus((String)"checkBizStatus", (String)obj.getString("billno"), (String)ResManager.loadKDString((String)"\u6267\u884c\u81f3\u4e0b\u8fbe", (String)"SFCManuftechValidator_6", (String)"mmc-sfc-opplugin", (Object[])new Object[0]), map, (String)ResManager.loadKDString((String)"\u751f\u4ea7", (String)"SFCManuftechValidator_145", (String)"mmc-sfc-opplugin", (Object[])new Object[0]))).length() > 0) {
                this.addErrorMessage(this.dataEntities[i], error1.toString());
            }
            DynamicObjectCollection entryCol = obj.getDynamicObjectCollection("oprentryentity");
            for (int j = 0; j < entryCol.size(); ++j) {
                DynamicObject entryObj = (DynamicObject)entryCol.get(j);
                if (!message.contains(entryObj.getPkValue())) continue;
                if (entryObj.getBoolean("oprinvalid")) {
                    this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\u5df2\u4f5c\u5e9f\uff0c\u4e0d\u5141\u8bb8\u6267\u884c\u81f3\u4e0b\u8fbe\uff08\u5de5\u5e8f\u5e8f\u5217\uff1a%1$s\uff1b\u5de5\u5e8f\u53f7\uff1a%2$s\uff09\u3002", (String)"SFCManuftechValidator_7", (String)"mmc-sfc-opplugin", (Object[])new Object[0]), entryObj.getString("oprparent"), entryObj.getString("oprno")));
                }
                if (!"1002".equals(entryObj.getString("machiningtype")) || "sfc_manftech".equals(obj.getDataEntityType().getName())) {
                    // empty if block
                }
                if (status.contains(entryObj.getString("oprstatus"))) continue;
                this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\u72b6\u6001\u4e3a\u201c\u8ba1\u5212\u201d\u6216\u8005\u201c\u8ba1\u5212\u786e\u8ba4\u201d\u65f6\uff0c\u624d\u53ef\u6267\u884c\u81f3\u4e0b\u8fbe\uff08\u5de5\u5e8f\u5e8f\u5217\uff1a%1$s\uff1b\u5de5\u5e8f\u53f7\uff1a%2$s\uff09\u3002", (String)"SFCManuftechValidator_9", (String)"mmc-sfc-opplugin", (Object[])new Object[0]), entryObj.getString("oprparent"), entryObj.getString("oprno")));
            }
        }
    }

    private void validDonothingStart(Map<Long, Map<String, Object>> orderByEntryId) {
        LinkedHashSet<Object> list = new LinkedHashSet<Object>();
        List message = CheckUtil.getManftechEntryID((String)this.getOption().getVariableValue("operateOption"));
        if (message == null) {
            return;
        }
        Set existsIDSet = CheckUtil.getExistsIDSet((ExtendedDataEntity[])this.dataEntities);
        for (int i = 0; i < this.dataEntities.length; ++i) {
            StringBuffer error1;
            DynamicObject obj = this.dataEntities[i].getDataEntity();
            Object billPK = obj.getPkValue();
            ArrayList<String> errors = new ArrayList<String>();
            if (list.contains(billPK) || CheckUtil.getDynamicObjectTypeName((DynamicObject)obj) == null) continue;
            if (!CheckUtil.isDataChange(errors, (boolean)existsIDSet.contains(billPK))) {
                this.addErrorMessage(i, errors);
                continue;
            }
            if (!"C".equals(obj.get("billstatus"))) {
                list.add(billPK);
                this.addErrorMessage(this.dataEntities[i], ResManager.loadKDString((String)"\u5de5\u5e8f\u8ba1\u5212\u672a\u5ba1\u6838\uff0c\u4e0d\u5141\u8bb8\u6267\u884c\u81f3\u5f00\u5de5\u3002", (String)"SFCManuftechValidator_11", (String)"mmc-sfc-opplugin", (Object[])new Object[0]));
                continue;
            }
            Map<String, Object> map = orderByEntryId.get(obj.getDynamicObject("mftentryseq").getLong("id"));
            StringBuffer error = CheckManuOrderUtil.checkManuOrderEntryStatus((String)"checkTaskStatus", (String)obj.getString("billno"), (String)ResManager.loadKDString((String)"\u6267\u884c\u81f3\u5f00\u5de5", (String)"SFCManuftechValidator_12", (String)"mmc-sfc-opplugin", (Object[])new Object[0]), map, (String)ResManager.loadKDString((String)"\u751f\u4ea7", (String)"SFCManuftechValidator_145", (String)"mmc-sfc-opplugin", (Object[])new Object[0]));
            if (error.length() > 0) {
                this.addErrorMessage(this.dataEntities[i], error.toString());
            }
            if ((error1 = CheckManuOrderUtil.checkManuOrderEntryStatus((String)"checkBizStatus", (String)obj.getString("billno"), (String)ResManager.loadKDString((String)"\u6267\u884c\u81f3\u5f00\u5de5", (String)"SFCManuftechValidator_12", (String)"mmc-sfc-opplugin", (Object[])new Object[0]), map, (String)ResManager.loadKDString((String)"\u751f\u4ea7", (String)"SFCManuftechValidator_145", (String)"mmc-sfc-opplugin", (Object[])new Object[0]))).length() > 0) {
                this.addErrorMessage(this.dataEntities[i], error1.toString());
            }
            DynamicObjectCollection entryCol = obj.getDynamicObjectCollection("oprentryentity");
            for (int j = 0; j < entryCol.size(); ++j) {
                DynamicObject entryObj = (DynamicObject)entryCol.get(j);
                if (!message.contains(entryObj.getPkValue())) continue;
                if (entryObj.getBoolean("oprinvalid")) {
                    this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\u5df2\u4f5c\u5e9f\uff0c\u4e0d\u5141\u8bb8\u6267\u884c\u81f3\u5f00\u5de5\uff08\u5de5\u5e8f\u5e8f\u5217\uff1a%1$s\uff1b\u5de5\u5e8f\u53f7\uff1a%2$s\uff09\u3002", (String)"SFCManuftechValidator_13", (String)"mmc-sfc-opplugin", (Object[])new Object[0]), entryObj.getString("oprparent"), entryObj.getString("oprno")));
                }
                if (!"1002".equals(entryObj.getString("machiningtype")) || "sfc_manftech".equals(obj.getDataEntityType().getName())) {
                    // empty if block
                }
                if ("D".contains(entryObj.getString("oprstatus"))) continue;
                this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\u72b6\u6001\u4e3a\u201c\u4e0b\u8fbe\u201d\u65f6\uff0c\u624d\u53ef\u6267\u884c\u81f3\u5f00\u5de5\uff08\u5de5\u5e8f\u5e8f\u5217\uff1a%1$s\uff1b\u5de5\u5e8f\u53f7\uff1a%2$s\uff09\u3002", (String)"SFCManuftechValidator_15", (String)"mmc-sfc-opplugin", (Object[])new Object[0]), entryObj.getString("oprparent"), entryObj.getString("oprno")));
            }
        }
    }

    private void validDonothingFinish(Map<Long, Map<String, Object>> orderByEntryId) {
        LinkedHashSet<Object> list = new LinkedHashSet<Object>();
        List message = CheckUtil.getManftechEntryID((String)this.getOption().getVariableValue("operateOption"));
        if (message == null) {
            return;
        }
        Set existsIDSet = CheckUtil.getExistsIDSet((ExtendedDataEntity[])this.dataEntities);
        HashSet status = Sets.newHashSet((Object[])new String[]{"D", "E"});
        for (int i = 0; i < this.dataEntities.length; ++i) {
            StringBuffer error1;
            DynamicObject obj = this.dataEntities[i].getDataEntity();
            Object billPK = obj.getPkValue();
            ArrayList<String> errors = new ArrayList<String>();
            if (list.contains(billPK) || CheckUtil.getDynamicObjectTypeName((DynamicObject)obj) == null) continue;
            if (!CheckUtil.isDataChange(errors, (boolean)existsIDSet.contains(billPK))) {
                this.addErrorMessage(i, errors);
                continue;
            }
            if (!"C".equals(obj.get("billstatus"))) {
                list.add(billPK);
                this.addErrorMessage(this.dataEntities[i], ResManager.loadKDString((String)"\u5de5\u5e8f\u8ba1\u5212\u672a\u5ba1\u6838\uff0c\u4e0d\u5141\u8bb8\u6267\u884c\u81f3\u5b8c\u5de5\u3002", (String)"SFCManuftechValidator_16", (String)"mmc-sfc-opplugin", (Object[])new Object[0]));
                continue;
            }
            Map<String, Object> map = orderByEntryId.get(obj.getDynamicObject("mftentryseq").getLong("id"));
            StringBuffer error = CheckManuOrderUtil.checkManuOrderEntryStatus((String)"checkTaskStatus", (String)obj.getString("billno"), (String)ResManager.loadKDString((String)"\u6267\u884c\u81f3\u5b8c\u5de5", (String)"SFCManuftechValidator_17", (String)"mmc-sfc-opplugin", (Object[])new Object[0]), map, (String)ResManager.loadKDString((String)"\u751f\u4ea7", (String)"SFCManuftechValidator_145", (String)"mmc-sfc-opplugin", (Object[])new Object[0]));
            if (error.length() > 0) {
                this.addErrorMessage(this.dataEntities[i], error.toString());
            }
            if ((error1 = CheckManuOrderUtil.checkManuOrderEntryStatus((String)"checkBizStatus", (String)obj.getString("billno"), (String)ResManager.loadKDString((String)"\u6267\u884c\u81f3\u5b8c\u5de5", (String)"SFCManuftechValidator_17", (String)"mmc-sfc-opplugin", (Object[])new Object[0]), map, (String)ResManager.loadKDString((String)"\u751f\u4ea7", (String)"SFCManuftechValidator_145", (String)"mmc-sfc-opplugin", (Object[])new Object[0]))).length() > 0) {
                this.addErrorMessage(this.dataEntities[i], error1.toString());
            }
            DynamicObjectCollection entryCol = obj.getDynamicObjectCollection("oprentryentity");
            for (int j = 0; j < entryCol.size(); ++j) {
                DynamicObject entryObj = (DynamicObject)entryCol.get(j);
                if (!message.contains(entryObj.getPkValue())) continue;
                if (entryObj.getBoolean("oprinvalid")) {
                    this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\u5df2\u4f5c\u5e9f\uff0c\u4e0d\u5141\u8bb8\u6267\u884c\u81f3\u5b8c\u5de5\uff08\u5de5\u5e8f\u5e8f\u5217\uff1a%1$s\uff1b\u5de5\u5e8f\u53f7\uff1a%2$s\uff09\u3002", (String)"SFCManuftechValidator_18", (String)"mmc-sfc-opplugin", (Object[])new Object[0]), entryObj.getString("oprparent"), entryObj.getString("oprno")));
                }
                if (!"1002".equals(entryObj.getString("machiningtype")) || "sfc_manftech".equals(obj.getDataEntityType().getName())) {
                    // empty if block
                }
                if (status.contains(entryObj.getString("oprstatus"))) continue;
                this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\u72b6\u6001\u4e3a\u201c\u4e0b\u8fbe\u201d\u6216\u8005\u201c\u5f00\u5de5\u201d\u65f6\uff0c\u624d\u53ef\u6267\u884c\u81f3\u5b8c\u5de5\uff08\u5de5\u5e8f\u5e8f\u5217\uff1a%1$s\uff1b\u5de5\u5e8f\u53f7\uff1a%2$s\uff09\u3002", (String)"SFCManuftechValidator_20", (String)"mmc-sfc-opplugin", (Object[])new Object[0]), entryObj.getString("oprparent"), entryObj.getString("oprno")));
            }
        }
    }

    private void validDonothingClosed(Map<Long, Map<String, Object>> orderByEntryId) {
        LinkedHashSet<Object> list = new LinkedHashSet<Object>();
        List message = CheckUtil.getManftechEntryID((String)this.getOption().getVariableValue("operateOption"));
        if (message == null) {
            return;
        }
        Set existsIDSet = CheckUtil.getExistsIDSet((ExtendedDataEntity[])this.dataEntities);
        for (int i = 0; i < this.dataEntities.length; ++i) {
            StringBuffer error1;
            DynamicObject obj = this.dataEntities[i].getDataEntity();
            Object billPK = obj.getPkValue();
            ArrayList<String> errors = new ArrayList<String>();
            if (list.contains(billPK) || CheckUtil.getDynamicObjectTypeName((DynamicObject)obj) == null) continue;
            if (!CheckUtil.isDataChange(errors, (boolean)existsIDSet.contains(billPK))) {
                this.addErrorMessage(i, errors);
                continue;
            }
            if (!"C".equals(obj.get("billstatus"))) {
                list.add(billPK);
                this.addErrorMessage(this.dataEntities[i], ResManager.loadKDString((String)"\u5de5\u5e8f\u8ba1\u5212\u672a\u5ba1\u6838\uff0c\u4e0d\u5141\u8bb8\u6267\u884c\u81f3\u5173\u95ed\u3002", (String)"SFCManuftechValidator_21", (String)"mmc-sfc-opplugin", (Object[])new Object[0]));
                continue;
            }
            Map<String, Object> map = orderByEntryId.get(obj.getDynamicObject("mftentryseq").getLong("id"));
            StringBuffer error = CheckManuOrderUtil.checkManuOrderEntryStatus((String)"checkTaskStatus", (String)obj.getString("billno"), (String)ResManager.loadKDString((String)"\u6267\u884c\u81f3\u5173\u95ed", (String)"SFCManuftechValidator_22", (String)"mmc-sfc-opplugin", (Object[])new Object[0]), map, (String)ResManager.loadKDString((String)"\u751f\u4ea7", (String)"SFCManuftechValidator_145", (String)"mmc-sfc-opplugin", (Object[])new Object[0]));
            if (error.length() > 0) {
                this.addErrorMessage(this.dataEntities[i], error.toString());
            }
            if ((error1 = CheckManuOrderUtil.checkManuOrderEntryStatus((String)"checkBizStatus", (String)obj.getString("billno"), (String)ResManager.loadKDString((String)"\u6267\u884c\u81f3\u5173\u95ed", (String)"SFCManuftechValidator_22", (String)"mmc-sfc-opplugin", (Object[])new Object[0]), map, (String)ResManager.loadKDString((String)"\u751f\u4ea7", (String)"SFCManuftechValidator_145", (String)"mmc-sfc-opplugin", (Object[])new Object[0]))).length() > 0) {
                this.addErrorMessage(this.dataEntities[i], error1.toString());
            }
            DynamicObjectCollection entryCol = obj.getDynamicObjectCollection("oprentryentity");
            for (int j = 0; j < entryCol.size(); ++j) {
                DynamicObject entryObj = (DynamicObject)entryCol.get(j);
                if (!message.contains(entryObj.getPkValue())) continue;
                if (entryObj.getBoolean("oprinvalid")) {
                    this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\u5df2\u4f5c\u5e9f\uff0c\u4e0d\u5141\u8bb8\u6267\u884c\u81f3\u5173\u95ed\uff08\u5de5\u5e8f\u5e8f\u5217\uff1a%1$s\uff1b\u5de5\u5e8f\u53f7\uff1a%2$s\uff09\u3002", (String)"SFCManuftechValidator_23", (String)"mmc-sfc-opplugin", (Object[])new Object[0]), entryObj.getString("oprparent"), entryObj.getString("oprno")));
                }
                if (!"1002".equals(entryObj.getString("machiningtype")) || "sfc_manftech".equals(obj.getDataEntityType().getName())) {
                    // empty if block
                }
                if ("F".contains(entryObj.getString("oprstatus"))) continue;
                this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\u72b6\u6001\u4e3a\u201c\u5b8c\u5de5\u201d\u65f6\uff0c\u624d\u53ef\u6267\u884c\u81f3\u5173\u95ed\uff08\u5de5\u5e8f\u5e8f\u5217\uff1a%1$s\uff1b\u5de5\u5e8f\u53f7\uff1a%2$s\uff09\u3002", (String)"SFCManuftechValidator_25", (String)"mmc-sfc-opplugin", (Object[])new Object[0]), entryObj.getString("oprparent"), entryObj.getString("oprno")));
            }
        }
    }

    private void validDonothingUnplan(Map<Long, Map<String, Object>> orderByEntryId) {
        LinkedHashSet<Object> list = new LinkedHashSet<Object>();
        List message = CheckUtil.getManftechEntryID((String)this.getOption().getVariableValue("operateOption"));
        if (message == null) {
            return;
        }
        Set existsIDSet = CheckUtil.getExistsIDSet((ExtendedDataEntity[])this.dataEntities);
        HashSet status = Sets.newHashSet((Object[])new String[]{"C", "D", "E", "F", "G"});
        HashSet oprEntryIds = new HashSet(16);
        for (int i = 0; i < this.dataEntities.length; ++i) {
            DynamicObject obj = this.dataEntities[i].getDataEntity();
            DynamicObjectCollection entryCol = obj.getDynamicObjectCollection("oprentryentity");
            oprEntryIds.addAll(entryCol.stream().map(x -> x.getLong("id")).collect(Collectors.toSet()));
        }
        Map entrustedOrderMap = ManuftechUtil.getEntrustedOrderByOprEntryId(oprEntryIds, (String)"pom_mftorder");
        Map proTransferBillMap = ManuftechUtil.getProTransferBillByOprEntryId(oprEntryIds, (String)"sfc_protransferbill");
        Set<Long> bfEntryIdSet = this.getBFEntryIds(message);
        for (int i = 0; i < this.dataEntities.length; ++i) {
            DynamicObject obj = this.dataEntities[i].getDataEntity();
            Object billPK = obj.getPkValue();
            ArrayList<String> errors = new ArrayList<String>();
            if (list.contains(billPK) || CheckUtil.getDynamicObjectTypeName((DynamicObject)obj) == null) continue;
            if (!CheckUtil.isDataChange(errors, (boolean)existsIDSet.contains(billPK))) {
                this.addErrorMessage(i, errors);
                continue;
            }
            if (!"C".equals(obj.get("billstatus"))) {
                list.add(billPK);
                this.addErrorMessage(this.dataEntities[i], ResManager.loadKDString((String)"\u5de5\u5e8f\u8ba1\u5212\u672a\u5ba1\u6838\uff0c\u4e0d\u5141\u8bb8\u53cd\u6267\u884c\u81f3\u8ba1\u5212\u3002", (String)"SFCManuftechValidator_26", (String)"mmc-sfc-opplugin", (Object[])new Object[0]));
                continue;
            }
            Map<String, Object> map = orderByEntryId.get(obj.getDynamicObject("mftentryseq").getLong("id"));
            StringBuffer error = CheckManuOrderUtil.checkManuOrderEntryStatus((String)"checkTaskStatus", (String)obj.getString("billno"), (String)ResManager.loadKDString((String)"\u53cd\u6267\u884c\u81f3\u8ba1\u5212", (String)"SFCManuftechValidator_27", (String)"mmc-sfc-opplugin", (Object[])new Object[0]), map, (String)ResManager.loadKDString((String)"\u751f\u4ea7", (String)"SFCManuftechValidator_145", (String)"mmc-sfc-opplugin", (Object[])new Object[0]));
            if (error.length() > 0) {
                this.addErrorMessage(this.dataEntities[i], error.toString());
            }
            DynamicObjectCollection entryCol = obj.getDynamicObjectCollection("oprentryentity");
            for (int j = 0; j < entryCol.size(); ++j) {
                boolean isPush;
                DynamicObject entryObj = (DynamicObject)entryCol.get(j);
                if (!message.contains(entryObj.getPkValue())) continue;
                if (entryObj.getBoolean("oprinvalid")) {
                    this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\u5df2\u4f5c\u5e9f\uff0c\u4e0d\u5141\u8bb8\u53cd\u6267\u884c\u81f3\u8ba1\u5212\uff08\u5de5\u5e8f\u5e8f\u5217\uff1a%1$s\uff1b\u5de5\u5e8f\u53f7\uff1a%2$s\uff09\u3002", (String)"SFCManuftechValidator_28", (String)"mmc-sfc-opplugin", (Object[])new Object[0]), entryObj.getString("oprparent"), entryObj.getString("oprno")));
                }
                if (!"1002".equals(entryObj.getString("machiningtype")) || "sfc_manftech".equals(obj.getDataEntityType().getName())) {
                    // empty if block
                }
                if (!status.contains(entryObj.getString("oprstatus"))) {
                    this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\u72b6\u6001\u4e3a\u201c\u8ba1\u5212\u786e\u8ba4\u201d\u3001\u201c\u4e0b\u8fbe\u201d\u3001\u201c\u5f00\u5de5\u201d\u3001\u201c\u5b8c\u5de5\u201d\u6216\u8005\u201c\u5173\u95ed\u201d\u65f6\uff0c\u624d\u53ef\u53cd\u6267\u884c\u81f3\u8ba1\u5212\uff08\u5de5\u5e8f\u5e8f\u5217\uff1a%1$s\uff1b\u5de5\u5e8f\u53f7\uff1a%2$s\uff09\u3002", (String)"SFCManuftechValidator_30", (String)"mmc-sfc-opplugin", (Object[])new Object[0]), entryObj.getString("oprparent"), entryObj.getString("oprno")));
                }
                if (isPush = BFTrackerServiceHelper.isPush((String)this.entityKey, (String)"oprentryentity", (Long)obj.getLong("id"), (Long)entryObj.getLong("id"))) {
                    this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\u5b58\u5728\u4e0b\u6e38\u5355\u636e,\u4e0d\u5141\u8bb8\u53cd\u6267\u884c\u81f3\u8ba1\u5212\uff08\u5de5\u5e8f\u5e8f\u5217\uff1a%1$s\uff1b\u5de5\u5e8f\u53f7\uff1a%2$s\uff09\u3002", (String)"SFCManuftechValidator_148", (String)"mmc-sfc-opplugin", (Object[])new Object[0]), entryObj.getString("oprparent"), entryObj.getString("oprno")));
                }
                if ("1003".equals(entryObj.getString("machiningtype"))) {
                    if (entrustedOrderMap.containsValue(entryObj.getLong("id"))) {
                        this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u5185\u534f\u52a0\u5de5\u7684\u5de5\u5e8f\uff08\u5de5\u5e8f\u5e8f\u5217\uff1a%1$s\uff1b\u5de5\u5e8f\u53f7\uff1a%2$s\uff09\uff0c\u5df2\u751f\u6210\u5185\u534f\u52a0\u5de5\u5de5\u5355\uff0c\u6267\u884c\u5931\u8d25\u3002", (String)"SFCManuftechValidator_149", (String)"mmc-sfc-opplugin", (Object[])new Object[0]), entryObj.getString("oprparent"), entryObj.getString("oprno")));
                    }
                    if (proTransferBillMap.containsValue(entryObj.getLong("id"))) {
                        this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\u5b58\u5728\u5df2\u5ba1\u6838\u7684\u4e0b\u6e38\u5de5\u5e8f\u8f6c\u79fb\u5355\uff0c\u4e0d\u5141\u8bb8\u53cd\u6267\u884c\u81f3\u8ba1\u5212\uff08\u5de5\u5e8f\u5e8f\u5217\uff1a%1$s\uff1b\u5de5\u5e8f\u53f7\uff1a%2$s\uff09\u3002", (String)"SFCManuftechValidator_150", (String)"mmc-sfc-opplugin", (Object[])new Object[0]), entryObj.getString("oprparent"), entryObj.getString("oprno")));
                    }
                }
                if (!bfEntryIdSet.contains((Long)entryObj.getPkValue())) continue;
                this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\u5df2\u7ecf\u5f00\u5de5\u5012\u51b2\uff08\u5de5\u5e8f\u5e8f\u5217\uff1a%1$s\uff1b\u5de5\u5e8f\u53f7\uff1a%2$s\uff09\uff0c\u64cd\u4f5c\u5931\u8d25\u3002", (String)"SFCManuftechValidator_157", (String)"mmc-sfc-opplugin", (Object[])new Object[0]), entryObj.getString("oprparent"), entryObj.getString("oprno")));
            }
        }
    }

    private void validDonothingUnconfirm(Map<Long, Map<String, Object>> orderByEntryId) {
        LinkedHashSet<Object> list = new LinkedHashSet<Object>();
        List message = CheckUtil.getManftechEntryID((String)this.getOption().getVariableValue("operateOption"));
        if (message == null) {
            return;
        }
        Set existsIDSet = CheckUtil.getExistsIDSet((ExtendedDataEntity[])this.dataEntities);
        HashSet status = Sets.newHashSet((Object[])new String[]{"D", "E", "F", "G"});
        HashSet oprEntryIds = new HashSet(16);
        for (int i = 0; i < this.dataEntities.length; ++i) {
            DynamicObject obj = this.dataEntities[i].getDataEntity();
            DynamicObjectCollection entryCol = obj.getDynamicObjectCollection("oprentryentity");
            oprEntryIds.addAll(entryCol.stream().map(x -> x.getLong("id")).collect(Collectors.toSet()));
        }
        Map entrustedOrderMap = ManuftechUtil.getEntrustedOrderByOprEntryId(oprEntryIds, (String)"pom_mftorder");
        Map proTransferBillMap = ManuftechUtil.getProTransferBillByOprEntryId(oprEntryIds, (String)"sfc_protransferbill");
        Set<Long> bfEntryIdSet = this.getBFEntryIds(message);
        for (int i = 0; i < this.dataEntities.length; ++i) {
            DynamicObject obj = this.dataEntities[i].getDataEntity();
            Object billPK = obj.getPkValue();
            ArrayList<String> errors = new ArrayList<String>();
            if (list.contains(billPK) || CheckUtil.getDynamicObjectTypeName((DynamicObject)obj) == null) continue;
            if (!CheckUtil.isDataChange(errors, (boolean)existsIDSet.contains(billPK))) {
                this.addErrorMessage(i, errors);
                continue;
            }
            if (!"C".equals(obj.get("billstatus"))) {
                list.add(billPK);
                this.addErrorMessage(this.dataEntities[i], ResManager.loadKDString((String)"\u5de5\u5e8f\u8ba1\u5212\u672a\u5ba1\u6838\uff0c\u4e0d\u5141\u8bb8\u53cd\u6267\u884c\u81f3\u786e\u8ba4\u3002", (String)"SFCManuftechValidator_31", (String)"mmc-sfc-opplugin", (Object[])new Object[0]));
                continue;
            }
            Map<String, Object> map = orderByEntryId.get(obj.getDynamicObject("mftentryseq").getLong("id"));
            StringBuffer error = CheckManuOrderUtil.checkManuOrderEntryStatus((String)"checkTaskStatus", (String)obj.getString("billno"), (String)ResManager.loadKDString((String)"\u53cd\u6267\u884c\u81f3\u786e\u8ba4", (String)"SFCManuftechValidator_32", (String)"mmc-sfc-opplugin", (Object[])new Object[0]), map, (String)ResManager.loadKDString((String)"\u751f\u4ea7", (String)"SFCManuftechValidator_145", (String)"mmc-sfc-opplugin", (Object[])new Object[0]));
            if (error.length() > 0) {
                this.addErrorMessage(this.dataEntities[i], error.toString());
            }
            DynamicObjectCollection entryCol = obj.getDynamicObjectCollection("oprentryentity");
            for (int j = 0; j < entryCol.size(); ++j) {
                boolean isPush;
                DynamicObject entryObj = (DynamicObject)entryCol.get(j);
                if (!message.contains(entryObj.getPkValue())) continue;
                if (entryObj.getBoolean("oprinvalid")) {
                    this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\u5df2\u4f5c\u5e9f\uff0c\u4e0d\u5141\u8bb8\u53cd\u6267\u884c\u81f3\u786e\u8ba4\uff08\u5de5\u5e8f\u5e8f\u5217\uff1a%1$s\uff1b\u5de5\u5e8f\u53f7\uff1a%2$s\uff09\u3002", (String)"SFCManuftechValidator_33", (String)"mmc-sfc-opplugin", (Object[])new Object[0]), entryObj.getString("oprparent"), entryObj.getString("oprno")));
                }
                if (!"1002".equals(entryObj.getString("machiningtype")) || "sfc_manftech".equals(obj.getDataEntityType().getName())) {
                    // empty if block
                }
                if (!status.contains(entryObj.getString("oprstatus"))) {
                    this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\u72b6\u6001\u4e3a\u201c\u4e0b\u8fbe\u201d\u3001\u201c\u5f00\u5de5\u201d\u3001\u201c\u5b8c\u5de5\u201d\u6216\u8005\u201c\u5173\u95ed\u201d\u65f6\uff0c\u624d\u53ef\u53cd\u6267\u884c\u81f3\u786e\u8ba4\uff08\u5de5\u5e8f\u5e8f\u5217\uff1a%1$s\uff1b\u5de5\u5e8f\u53f7\uff1a%2$s\uff09\u3002", (String)"SFCManuftechValidator_35", (String)"mmc-sfc-opplugin", (Object[])new Object[0]), entryObj.getString("oprparent"), entryObj.getString("oprno")));
                }
                if (isPush = BFTrackerServiceHelper.isPush((String)this.entityKey, (String)"oprentryentity", (Long)obj.getLong("id"), (Long)entryObj.getLong("id"))) {
                    this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\u5b58\u5728\u4e0b\u6e38\u5355\u636e,\u4e0d\u5141\u8bb8\u53cd\u6267\u884c\u81f3\u786e\u8ba4\uff08\u5de5\u5e8f\u5e8f\u5217\uff1a%1$s\uff1b\u5de5\u5e8f\u53f7\uff1a%2$s\uff09\u3002", (String)"SFCManuftechValidator_151", (String)"mmc-sfc-opplugin", (Object[])new Object[0]), entryObj.getString("oprparent"), entryObj.getString("oprno")));
                }
                if ("1003".equals(entryObj.getString("machiningtype"))) {
                    if (entrustedOrderMap.containsValue(entryObj.getLong("id"))) {
                        this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u5185\u534f\u52a0\u5de5\u7684\u5de5\u5e8f\uff08\u5de5\u5e8f\u5e8f\u5217\uff1a%1$s\uff1b\u5de5\u5e8f\u53f7\uff1a%2$s\uff09\uff0c\u5df2\u751f\u6210\u5185\u534f\u52a0\u5de5\u5de5\u5355\uff0c\u6267\u884c\u5931\u8d25\u3002", (String)"SFCManuftechValidator_149", (String)"mmc-sfc-opplugin", (Object[])new Object[0]), entryObj.getString("oprparent"), entryObj.getString("oprno")));
                    }
                    if (proTransferBillMap.containsValue(entryObj.getLong("id"))) {
                        this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\u5b58\u5728\u5df2\u5ba1\u6838\u7684\u4e0b\u6e38\u5de5\u5e8f\u8f6c\u79fb\u5355\uff0c\u4e0d\u5141\u8bb8\u53cd\u6267\u884c\u81f3\u786e\u8ba4\uff08\u5de5\u5e8f\u5e8f\u5217\uff1a%1$s\uff1b\u5de5\u5e8f\u53f7\uff1a%2$s\uff09\u3002", (String)"SFCManuftechValidator_152", (String)"mmc-sfc-opplugin", (Object[])new Object[0]), entryObj.getString("oprparent"), entryObj.getString("oprno")));
                    }
                }
                if (!bfEntryIdSet.contains((Long)entryObj.getPkValue())) continue;
                this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\u5df2\u7ecf\u5f00\u5de5\u5012\u51b2\uff08\u5de5\u5e8f\u5e8f\u5217\uff1a%1$s\uff1b\u5de5\u5e8f\u53f7\uff1a%2$s\uff09\uff0c\u64cd\u4f5c\u5931\u8d25\u3002", (String)"SFCManuftechValidator_157", (String)"mmc-sfc-opplugin", (Object[])new Object[0]), entryObj.getString("oprparent"), entryObj.getString("oprno")));
            }
        }
    }

    private void validDonothingUnrelase(Map<Long, Map<String, Object>> orderByEntryId) {
        LinkedHashSet<Object> list = new LinkedHashSet<Object>();
        List message = CheckUtil.getManftechEntryID((String)this.getOption().getVariableValue("operateOption"));
        if (message == null) {
            return;
        }
        Set existsIDSet = CheckUtil.getExistsIDSet((ExtendedDataEntity[])this.dataEntities);
        HashSet status = Sets.newHashSet((Object[])new String[]{"E", "F", "G"});
        HashSet oprEntryIds = new HashSet(16);
        for (int i = 0; i < this.dataEntities.length; ++i) {
            DynamicObject obj = this.dataEntities[i].getDataEntity();
            DynamicObjectCollection entryCol = obj.getDynamicObjectCollection("oprentryentity");
            oprEntryIds.addAll(entryCol.stream().map(x -> x.getString("id")).collect(Collectors.toSet()));
        }
        Map processReportMap = ReportUtil.getProcessReportByOprEntryId(oprEntryIds, (String)"sfc_processreportbill");
        Map proTransferBillMap = ManuftechUtil.getProTransferBillByOprEntryId(oprEntryIds.stream().map(x -> NumberUtils.toLong((String)x)).collect(Collectors.toSet()), (String)"sfc_protransferbill");
        Set<Long> bfEntryIdSet = this.getBFEntryIds(message);
        for (int i = 0; i < this.dataEntities.length; ++i) {
            DynamicObject obj = this.dataEntities[i].getDataEntity();
            Object billPK = obj.getPkValue();
            ArrayList<String> errors = new ArrayList<String>();
            if (list.contains(billPK) || CheckUtil.getDynamicObjectTypeName((DynamicObject)obj) == null) continue;
            if (!CheckUtil.isDataChange(errors, (boolean)existsIDSet.contains(billPK))) {
                this.addErrorMessage(i, errors);
                continue;
            }
            if (!"C".equals(obj.get("billstatus"))) {
                list.add(billPK);
                this.addErrorMessage(this.dataEntities[i], ResManager.loadKDString((String)"\u5de5\u5e8f\u8ba1\u5212\u672a\u5ba1\u6838\uff0c\u4e0d\u5141\u8bb8\u53cd\u6267\u884c\u81f3\u4e0b\u8fbe\u3002", (String)"SFCManuftechValidator_36", (String)"mmc-sfc-opplugin", (Object[])new Object[0]));
                continue;
            }
            Map<String, Object> map = orderByEntryId.get(obj.getDynamicObject("mftentryseq").getLong("id"));
            StringBuffer error = CheckManuOrderUtil.checkManuOrderEntryStatus((String)"checkTaskStatus", (String)obj.getString("billno"), (String)ResManager.loadKDString((String)"\u53cd\u6267\u884c\u81f3\u4e0b\u8fbe", (String)"SFCManuftechValidator_37", (String)"mmc-sfc-opplugin", (Object[])new Object[0]), map, (String)ResManager.loadKDString((String)"\u751f\u4ea7", (String)"SFCManuftechValidator_145", (String)"mmc-sfc-opplugin", (Object[])new Object[0]));
            if (error.length() > 0) {
                this.addErrorMessage(this.dataEntities[i], error.toString());
            }
            DynamicObjectCollection entryCol = obj.getDynamicObjectCollection("oprentryentity");
            for (int j = 0; j < entryCol.size(); ++j) {
                DynamicObject entryObj = (DynamicObject)entryCol.get(j);
                if (!message.contains(entryObj.getPkValue())) continue;
                if (entryObj.getBoolean("oprinvalid")) {
                    errors.add(String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\u5df2\u4f5c\u5e9f\uff0c\u4e0d\u5141\u8bb8\u53cd\u6267\u884c\u81f3\u4e0b\u8fbe\uff08\u5de5\u5e8f\u5e8f\u5217\uff1a%1$s\uff1b\u5de5\u5e8f\u53f7\uff1a%2$s\uff09\u3002", (String)"SFCManuftechValidator_38", (String)"mmc-sfc-opplugin", (Object[])new Object[0]), entryObj.getString("oprparent"), entryObj.getString("oprno")) + "\n");
                }
                if (!"1002".equals(entryObj.getString("machiningtype")) || "sfc_manftech".equals(obj.getDataEntityType().getName())) {
                    // empty if block
                }
                if (!status.contains(entryObj.getString("oprstatus"))) {
                    this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\u72b6\u6001\u4e3a\u201c\u5f00\u5de5\u201d\u3001\u201c\u5b8c\u5de5\u201d\u6216\u8005\u201c\u5173\u95ed\u201d\u65f6\uff0c\u624d\u53ef\u53cd\u6267\u884c\u81f3\u4e0b\u8fbe\uff08\u5de5\u5e8f\u5e8f\u5217\uff1a%1$s\uff1b\u5de5\u5e8f\u53f7\uff1a%2$s\uff09\u3002", (String)"SFCManuftechValidator_40", (String)"mmc-sfc-opplugin", (Object[])new Object[0]), entryObj.getString("oprparent"), entryObj.getString("oprno")));
                }
                if (processReportMap.containsValue(entryObj.getString("id"))) {
                    this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\u5df2\u6c47\u62a5\uff0c\u4e0d\u5141\u8bb8\u53cd\u6267\u884c\u81f3\u4e0b\u8fbe\uff08\u5de5\u5e8f\u5e8f\u5217\uff1a%1$s\uff1b\u5de5\u5e8f\u53f7\uff1a%2$s\uff09\u3002", (String)"SFCManuftechValidator_153", (String)"mmc-sfc-opplugin", (Object[])new Object[0]), entryObj.getString("oprparent"), entryObj.getString("oprno")));
                }
                if ("1003".equals(entryObj.getString("machiningtype")) && proTransferBillMap.containsValue(entryObj.getLong("id"))) {
                    this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\u5b58\u5728\u5df2\u5ba1\u6838\u7684\u4e0b\u6e38\u5de5\u5e8f\u8f6c\u79fb\u5355\uff0c\u4e0d\u5141\u8bb8\u53cd\u6267\u884c\u81f3\u4e0b\u8fbe\uff08\u5de5\u5e8f\u5e8f\u5217\uff1a%1$s\uff1b\u5de5\u5e8f\u53f7\uff1a%2$s\uff09\u3002", (String)"SFCManuftechValidator_154", (String)"mmc-sfc-opplugin", (Object[])new Object[0]), entryObj.getString("oprparent"), entryObj.getString("oprno")));
                }
                if (!bfEntryIdSet.contains((Long)entryObj.getPkValue())) continue;
                this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\u5df2\u7ecf\u5f00\u5de5\u5012\u51b2\uff08\u5de5\u5e8f\u5e8f\u5217\uff1a%1$s\uff1b\u5de5\u5e8f\u53f7\uff1a%2$s\uff09\uff0c\u64cd\u4f5c\u5931\u8d25\u3002", (String)"SFCManuftechValidator_157", (String)"mmc-sfc-opplugin", (Object[])new Object[0]), entryObj.getString("oprparent"), entryObj.getString("oprno")));
            }
        }
    }

    private Set<Long> getBFEntryIds(List<Object> message) {
        QFilter qfilter = new QFilter("billentry.srcbillentryid", "in", message);
        DynamicObject[] mftProOrders = BusinessDataServiceHelper.load((String)"im_mdc_mftproorder", (String)"id,billno,billentry.srcbillid,billentry.srcbillentryid", (QFilter[])new QFilter[]{qfilter});
        HashSet<Long> bfEntryIdSet = new HashSet<Long>(16);
        for (DynamicObject mftProOrder : mftProOrders) {
            DynamicObjectCollection billentrys = mftProOrder.getDynamicObjectCollection("billentry");
            for (DynamicObject billentry : billentrys) {
                bfEntryIdSet.add(billentry.getLong("srcbillentryid"));
            }
        }
        return bfEntryIdSet;
    }

    private void validDonothingUnstart(Map<Long, Map<String, Object>> orderByEntryId) {
        LinkedHashSet<Object> list = new LinkedHashSet<Object>();
        List message = CheckUtil.getManftechEntryID((String)this.getOption().getVariableValue("operateOption"));
        if (message == null) {
            return;
        }
        Set existsIDSet = CheckUtil.getExistsIDSet((ExtendedDataEntity[])this.dataEntities);
        HashSet status = Sets.newHashSet((Object[])new String[]{"F", "G"});
        for (int i = 0; i < this.dataEntities.length; ++i) {
            DynamicObject obj = this.dataEntities[i].getDataEntity();
            Object billPK = obj.getPkValue();
            ArrayList<String> errors = new ArrayList<String>();
            if (list.contains(billPK) || CheckUtil.getDynamicObjectTypeName((DynamicObject)obj) == null) continue;
            if (!CheckUtil.isDataChange(errors, (boolean)existsIDSet.contains(billPK))) {
                this.addErrorMessage(i, errors);
                continue;
            }
            if (!"C".equals(obj.get("billstatus"))) {
                list.add(billPK);
                this.addErrorMessage(this.dataEntities[i], ResManager.loadKDString((String)"\u5de5\u5e8f\u8ba1\u5212\u672a\u5ba1\u6838\uff0c\u4e0d\u5141\u8bb8\u53cd\u6267\u884c\u81f3\u5f00\u5de5\u3002", (String)"SFCManuftechValidator_41", (String)"mmc-sfc-opplugin", (Object[])new Object[0]));
                continue;
            }
            Map<String, Object> map = orderByEntryId.get(obj.getDynamicObject("mftentryseq").getLong("id"));
            StringBuffer error = CheckManuOrderUtil.checkManuOrderEntryStatus((String)"checkTaskStatus", (String)obj.getString("billno"), (String)ResManager.loadKDString((String)"\u53cd\u6267\u884c\u81f3\u5f00\u5de5", (String)"SFCManuftechValidator_42", (String)"mmc-sfc-opplugin", (Object[])new Object[0]), map, (String)ResManager.loadKDString((String)"\u751f\u4ea7", (String)"SFCManuftechValidator_145", (String)"mmc-sfc-opplugin", (Object[])new Object[0]));
            if (error.length() > 0) {
                this.addErrorMessage(this.dataEntities[i], error.toString());
            }
            DynamicObjectCollection entryCol = obj.getDynamicObjectCollection("oprentryentity");
            for (int j = 0; j < entryCol.size(); ++j) {
                DynamicObject entryObj = (DynamicObject)entryCol.get(j);
                if (!message.contains(entryObj.getPkValue())) continue;
                if (entryObj.getBoolean("oprinvalid")) {
                    this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\u5df2\u4f5c\u5e9f\uff0c\u4e0d\u5141\u8bb8\u53cd\u6267\u884c\u81f3\u5f00\u5de5\uff08\u5de5\u5e8f\u5e8f\u5217\uff1a%1$s\uff1b\u5de5\u5e8f\u53f7\uff1a%2$s\uff09\u3002", (String)"SFCManuftechValidator_43", (String)"mmc-sfc-opplugin", (Object[])new Object[0]), entryObj.getString("oprparent"), entryObj.getString("oprno")));
                }
                if (!"1002".equals(entryObj.getString("machiningtype")) || "sfc_manftech".equals(obj.getDataEntityType().getName())) {
                    // empty if block
                }
                if (status.contains(entryObj.getString("oprstatus"))) continue;
                this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\u72b6\u6001\u4e3a\u201c\u5b8c\u5de5\u201d\u6216\u8005\u201c\u5173\u95ed\u201d\u65f6\uff0c\u624d\u53ef\u53cd\u6267\u884c\u81f3\u5f00\u5de5\uff08\u5de5\u5e8f\u5e8f\u5217\uff1a%1$s\uff1b\u5de5\u5e8f\u53f7\uff1a%2$s\uff09\u3002", (String)"SFCManuftechValidator_45", (String)"mmc-sfc-opplugin", (Object[])new Object[0]), entryObj.getString("oprparent"), entryObj.getString("oprno")));
            }
        }
    }

    private void validDonothingUnfinish(Map<Long, Map<String, Object>> orderByEntryId) {
        LinkedHashSet<Object> list = new LinkedHashSet<Object>();
        List message = CheckUtil.getManftechEntryID((String)this.getOption().getVariableValue("operateOption"));
        if (message == null) {
            return;
        }
        Set existsIDSet = CheckUtil.getExistsIDSet((ExtendedDataEntity[])this.dataEntities);
        for (int i = 0; i < this.dataEntities.length; ++i) {
            DynamicObject obj = this.dataEntities[i].getDataEntity();
            Object billPK = obj.getPkValue();
            ArrayList<String> errors = new ArrayList<String>();
            if (list.contains(billPK) || CheckUtil.getDynamicObjectTypeName((DynamicObject)obj) == null) continue;
            if (!CheckUtil.isDataChange(errors, (boolean)existsIDSet.contains(billPK))) {
                this.addErrorMessage(i, errors);
                continue;
            }
            if (!"C".equals(obj.get("billstatus"))) {
                list.add(billPK);
                this.addErrorMessage(this.dataEntities[i], ResManager.loadKDString((String)"\u5de5\u5e8f\u8ba1\u5212\u672a\u5ba1\u6838\uff0c\u4e0d\u5141\u8bb8\u53cd\u6267\u884c\u81f3\u5b8c\u5de5\u3002", (String)"SFCManuftechValidator_46", (String)"mmc-sfc-opplugin", (Object[])new Object[0]));
                continue;
            }
            Map<String, Object> map = orderByEntryId.get(obj.getDynamicObject("mftentryseq").getLong("id"));
            StringBuffer error = CheckManuOrderUtil.checkManuOrderEntryStatus((String)"checkTaskStatus", (String)obj.getString("billno"), (String)ResManager.loadKDString((String)"\u53cd\u6267\u884c\u81f3\u5b8c\u5de5", (String)"SFCManuftechValidator_47", (String)"mmc-sfc-opplugin", (Object[])new Object[0]), map, (String)ResManager.loadKDString((String)"\u751f\u4ea7", (String)"SFCManuftechValidator_145", (String)"mmc-sfc-opplugin", (Object[])new Object[0]));
            if (error.length() > 0) {
                this.addErrorMessage(this.dataEntities[i], error.toString());
            }
            DynamicObjectCollection entryCol = obj.getDynamicObjectCollection("oprentryentity");
            for (int j = 0; j < entryCol.size(); ++j) {
                DynamicObject entryObj = (DynamicObject)entryCol.get(j);
                if (!message.contains(entryObj.getPkValue())) continue;
                if (entryObj.getBoolean("oprinvalid")) {
                    this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\u5df2\u4f5c\u5e9f\uff0c\u4e0d\u5141\u8bb8\u53cd\u6267\u884c\u81f3\u5b8c\u5de5\uff08\u5de5\u5e8f\u5e8f\u5217\uff1a%1$s\uff1b\u5de5\u5e8f\u53f7\uff1a%2$s\uff09\u3002", (String)"SFCManuftechValidator_48", (String)"mmc-sfc-opplugin", (Object[])new Object[0]), entryObj.getString("oprparent"), entryObj.getString("oprno")));
                }
                if (!"1002".equals(entryObj.getString("machiningtype")) || "sfc_manftech".equals(obj.getDataEntityType().getName())) {
                    // empty if block
                }
                if ("G".contains(entryObj.getString("oprstatus"))) continue;
                this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\u72b6\u6001\u4e3a\u201c\u5173\u95ed\u201d\u65f6\uff0c\u624d\u53ef\u53cd\u6267\u884c\u81f3\u5b8c\u5de5\uff08\u5de5\u5e8f\u5e8f\u5217\uff1a%1$s\uff1b\u5de5\u5e8f\u53f7\uff1a%2$s\uff09\u3002", (String)"SFCManuftechValidator_50", (String)"mmc-sfc-opplugin", (Object[])new Object[0]), entryObj.getString("oprparent"), entryObj.getString("oprno")));
            }
        }
    }

    private void validDonothingCancel(Map<Long, Map<String, Object>> orderByEntryId) {
        LinkedHashSet list = new LinkedHashSet();
        List message = CheckUtil.getManftechEntryID((String)this.getOption().getVariableValue("operateOption"));
        if (message == null) {
            return;
        }
        Set existsIDSet = CheckUtil.getExistsIDSet((ExtendedDataEntity[])this.dataEntities);
        HashSet status = Sets.newHashSet((Object[])new String[]{"A", "B", "C"});
        for (int i = 0; i < this.dataEntities.length; ++i) {
            DynamicObject obj = this.dataEntities[i].getDataEntity();
            Object billPK = obj.getPkValue();
            ArrayList<String> errors = new ArrayList<String>();
            if (list.contains(billPK) || CheckUtil.getDynamicObjectTypeName((DynamicObject)obj) == null) continue;
            if (!CheckUtil.isDataChange(errors, (boolean)existsIDSet.contains(billPK))) {
                this.addErrorMessage(i, errors);
                continue;
            }
            DynamicObjectCollection entryCol = obj.getDynamicObjectCollection("oprentryentity");
            for (int j = 0; j < entryCol.size(); ++j) {
                DynamicObject entryObj = (DynamicObject)entryCol.get(j);
                if (!message.contains(entryObj.getPkValue())) continue;
                if (!status.contains(entryObj.getString("oprstatus"))) {
                    this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\u72b6\u6001\u4e3a\u201c\u521b\u5efa\u201d\u3001\u201c\u8ba1\u5212\u201d\u6216\u8005\u201c\u8ba1\u5212\u786e\u8ba4\u201d\u65f6\uff0c\u624d\u53ef\u4f5c\u5e9f\uff08\u5de5\u5e8f\u5e8f\u5217\uff1a%1$s\uff1b\u5de5\u5e8f\u53f7\uff1a%2$s\uff09\u3002", (String)"SFCManuftechValidator_51", (String)"mmc-sfc-opplugin", (Object[])new Object[0]), entryObj.getString("oprparent"), entryObj.getString("oprno")));
                }
                if (!"1002".equals(entryObj.getString("machiningtype")) || "sfc_manftech".equals(obj.getDataEntityType().getName())) {
                    // empty if block
                }
                if (!entryObj.getBoolean("oprinvalid")) continue;
                this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\u5df2\u4f5c\u5e9f\uff0c\u4e0d\u5141\u8bb8\u91cd\u590d\u4f5c\u5e9f\uff08\u5de5\u5e8f\u5e8f\u5217\uff1a%1$s\uff1b\u5de5\u5e8f\u53f7\uff1a%2$s\uff09\u3002", (String)"SFCManuftechValidator_53", (String)"mmc-sfc-opplugin", (Object[])new Object[0]), entryObj.getString("oprparent"), entryObj.getString("oprno")));
            }
        }
    }

    private void validDonothingUnCancel(Map<Long, Map<String, Object>> orderByEntryId) {
        LinkedHashSet list = new LinkedHashSet();
        List message = CheckUtil.getManftechEntryID((String)this.getOption().getVariableValue("operateOption"));
        if (message == null) {
            return;
        }
        Set existsIDSet = CheckUtil.getExistsIDSet((ExtendedDataEntity[])this.dataEntities);
        for (int i = 0; i < this.dataEntities.length; ++i) {
            DynamicObject obj = this.dataEntities[i].getDataEntity();
            Object billPK = obj.getPkValue();
            ArrayList<String> errors = new ArrayList<String>();
            if (list.contains(billPK) || CheckUtil.getDynamicObjectTypeName((DynamicObject)obj) == null) continue;
            if (!CheckUtil.isDataChange(errors, (boolean)existsIDSet.contains(billPK))) {
                this.addErrorMessage(i, errors);
                continue;
            }
            DynamicObjectCollection entryCol = obj.getDynamicObjectCollection("oprentryentity");
            for (int j = 0; j < entryCol.size(); ++j) {
                DynamicObject entryObj = (DynamicObject)entryCol.get(j);
                if (!message.contains(entryObj.getPkValue())) continue;
                if (!entryObj.getBoolean("oprinvalid")) {
                    this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\u672a\u4f5c\u5e9f\uff0c\u4e0d\u5141\u8bb8\u53cd\u4f5c\u5e9f\uff08\u5de5\u5e8f\u5e8f\u5217\uff1a%1$s\uff1b\u5de5\u5e8f\u53f7\uff1a%2$s\uff09\u3002", (String)"SFCManuftechValidator_54", (String)"mmc-sfc-opplugin", (Object[])new Object[0]), entryObj.getString("oprparent"), entryObj.getString("oprno")));
                }
                if (!"1002".equals(entryObj.getString("machiningtype")) || "sfc_manftech".equals(obj.getDataEntityType().getName())) {
                    // empty if block
                }
                if (entryObj.getBigDecimal("oprtotalsplitqty").compareTo(BigDecimal.ZERO) <= 0) continue;
                this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\u53d1\u751f\u8fc7\u62c6\u5206\uff0c\u4e0d\u5141\u8bb8\u53cd\u4f5c\u5e9f\uff08\u5de5\u5e8f\u5e8f\u5217\uff1a%1$s\uff1b\u5de5\u5e8f\u53f7\uff1a%2$s\uff09\u3002", (String)"SFCManuftechValidator_138", (String)"mmc-sfc-opplugin", (Object[])new Object[0]), entryObj.getString("oprparent"), entryObj.getString("oprno")));
            }
        }
    }

    public Set<String> preparePropertys() {
        return super.preparePropertys();
    }

    private void saveCheck(String operate, int i, Map<Long, Map<String, Object>> map, Map<Object, DynamicObject> processRouteMap, Map<Long, Long> manftech) {
        DynamicObject obj = this.dataEntities[i].getDataEntity();
        this.checkHead(obj, operate, i, map, processRouteMap, manftech);
        DynamicObject material = obj.getDynamicObject("material");
        DynamicObject processroute = obj.getDynamicObject("processroute");
        DynamicObjectCollection entryCol = obj.getDynamicObjectCollection("oprentryentity");
        if (entryCol.size() > 0) {
            for (int j = 0; j < entryCol.size(); ++j) {
                DynamicObjectCollection subEntryCol;
                DynamicObject entryObj = (DynamicObject)entryCol.get(j);
                if (this.isNull(entryObj.get("headqty")) || entryObj.getBigDecimal("headqty").compareTo(BigDecimal.ZERO) == 0) {
                    this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u201c\u8868\u5934\u6570\u91cf\u201d\u4e0d\u80fd\u4e3a0\uff08\u5de5\u5e8f\u5e8f\u5217\uff1a%1$s\uff1b\u5de5\u5e8f\u53f7\uff1a%2$s\uff09\u3002", (String)"SFCManuftechValidator_56", (String)"mmc-sfc-opplugin", (Object[])new Object[0]), entryObj.getString("oprparent"), entryObj.getString("oprno")));
                }
                if (this.isNull(entryObj.get("operationqty")) || entryObj.getBigDecimal("operationqty").compareTo(BigDecimal.ZERO) == 0) {
                    this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u201c\u5de5\u5e8f\u6570\u91cf\u201d\u4e0d\u80fd\u4e3a0\uff08\u5de5\u5e8f\u5e8f\u5217\uff1a%1$s\uff1b\u5de5\u5e8f\u53f7\uff1a%2$s\uff09\u3002", (String)"SFCManuftechValidator_57", (String)"mmc-sfc-opplugin", (Object[])new Object[0]), entryObj.getString("oprparent"), entryObj.getString("oprno")));
                }
                if (this.isNull(entryObj.getDynamicObject("headunit"))) {
                    this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u201c\u8868\u5934\u5355\u4f4d\u201d\u4e0d\u80fd\u4e3a\u7a7a\uff08\u5de5\u5e8f\u5e8f\u5217\uff1a%1$s\uff1b\u5de5\u5e8f\u53f7\uff1a%2$s\uff09\u3002", (String)"SFCManuftechValidator_58", (String)"mmc-sfc-opplugin", (Object[])new Object[0]), entryObj.getString("oprparent"), entryObj.getString("oprno")));
                }
                if ((subEntryCol = entryObj.getDynamicObjectCollection("actsubentryentity")).size() == 0) {
                    this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u6839\u636e\u7269\u6599\uff08\u7f16\u7801\uff1a%1$s\uff09\u5de5\u827a\u8def\u7ebf\uff08\u7f16\u53f7\uff1a%2$s\uff09\u751f\u6210\u7684\u5de5\u5e8f\u8ba1\u5212\u4e2d\u5de5\u5e8f\u4fe1\u606f\u81f3\u5c11\u5f55\u5165\u4e00\u6761\u5de5\u5e8f\u6d3b\u52a8\uff08\u5de5\u5e8f\u5e8f\u5217\uff1a%3$s\uff1b\u5de5\u5e8f\u53f7\uff1a%4$s\uff09\u3002", (String)"SFCManuftechValidator_59", (String)"mmc-sfc-opplugin", (Object[])new Object[0]), material.getString("number"), processroute.get("number"), entryObj.getString("oprparent"), entryObj.getString("oprno")));
                }
                for (int k = 0; k < subEntryCol.size(); ++k) {
                    DynamicObject subEntryObj = (DynamicObject)subEntryCol.get(k);
                    if (this.isNull(subEntryObj.getString("processstage"))) {
                        this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\u6d3b\u52a8\u5206\u5f55\u7b2c%3$s\u884c\u201c\u5de5\u5e8f\u9636\u6bb5\u201d\u4e0d\u80fd\u4e3a\u7a7a\uff08\u5de5\u5e8f\u5e8f\u5217\uff1a%1$s\uff1b\u5de5\u5e8f\u53f7\uff1a%2$s\uff09\u3002", (String)"SFCManuftechValidator_60", (String)"mmc-sfc-opplugin", (Object[])new Object[0]), entryObj.getString("oprparent"), entryObj.getString("oprno"), k + 1));
                    }
                    if (this.isNull(subEntryObj.getDynamicObject("actstandardformula"))) {
                        this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\u6d3b\u52a8\u5206\u5f55\u7b2c%3$s\u884c\u201c\u6807\u51c6\u516c\u5f0f\u201d\u4e0d\u80fd\u4e3a\u7a7a\uff08\u5de5\u5e8f\u5e8f\u5217\uff1a%1$s\uff1b\u5de5\u5e8f\u53f7\uff1a%2$s\uff09\u3002", (String)"SFCManuftechValidator_61", (String)"mmc-sfc-opplugin", (Object[])new Object[0]), entryObj.getString("oprparent"), entryObj.getString("oprno"), k + 1));
                    }
                    if (!this.isNull(subEntryObj.getDynamicObject("actstandardformula1"))) continue;
                    this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\u6d3b\u52a8\u5206\u5f55\u7b2c%3$s\u884c\u201c\u6807\u51c6\u516c\u5f0f\u201d\u4e0d\u80fd\u4e3a\u7a7a\uff08\u5de5\u5e8f\u5e8f\u5217\uff1a%1$s\uff1b\u5de5\u5e8f\u53f7\uff1a%2$s\uff09\u3002", (String)"SFCManuftechValidator_61", (String)"mmc-sfc-opplugin", (Object[])new Object[0]), entryObj.getString("oprparent"), entryObj.getString("oprno"), k + 1));
                }
            }
        }
    }

    private void checkHead(DynamicObject obj, String operate, int i, Map<Long, Map<String, Object>> map, Map<Object, DynamicObject> processRouteMap, Map<Long, Long> manftech) {
        if (this.isNull(obj.getDynamicObject("org"))) {
            this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u201c\u751f\u4ea7\u7ec4\u7ec7\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"SFCManuftechValidator_62", (String)"mmc-sfc-opplugin", (Object[])new Object[0]), new Object[0]));
        }
        if (this.isNull(obj.getString("billno"))) {
            this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u5355\u636e\u7f16\u7801\u201d\u3002", (String)"SFCManuftechValidator_63", (String)"mmc-sfc-opplugin", (Object[])new Object[0]), new Object[0]));
        }
        if (this.isNull(obj.getDynamicObject("mftentryseq"))) {
            this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u201c\u751f\u4ea7\u5de5\u5355\u884c\u53f7\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"SFCManuftechValidator_64", (String)"mmc-sfc-opplugin", (Object[])new Object[0]), new Object[0]));
        }
        if (this.isNull(obj.getDynamicObject("billtype"))) {
            this.addErrorMessage(this.dataEntities[i], ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u5355\u636e\u7c7b\u578b\u201d\u3002", (String)"SFCManuftechValidator_65", (String)"mmc-sfc-opplugin", (Object[])new Object[0]));
        }
        if (!this.isNull(obj.getDynamicObject("mftentryseq")) && manftech != null && manftech.get(obj.getDynamicObject("mftentryseq").getLong("id")) != null) {
            this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u751f\u4ea7\u5de5\u5355\u5df2\u5b58\u5728\u5de5\u5e8f\u8ba1\u5212\uff08\u5de5\u5355\u7f16\u53f7\uff1a%1$s\uff1b\u5de5\u5355\u884c\u53f7\uff1a%2$s\uff1b\u5de5\u5e8f\u8ba1\u5212\u7f16\u53f7\uff1a%3$s\uff09\u3002", (String)"SFCManuftechValidator_66", (String)"mmc-sfc-opplugin", (Object[])new Object[0]), obj.getDynamicObject("mftentryseq").getString("headbillno"), obj.getDynamicObject("mftentryseq").getString("entryseq"), obj.getString("billno")));
        }
        this.checkUnit(obj, operate, i, map, processRouteMap);
    }

    private void checkUnit(DynamicObject obj, String operate, int i, Map<Long, Map<String, Object>> map, Map<Object, DynamicObject> processRouteMap) {
        logger.info(String.format("\u5de5\u5e8f\u8ba1\u5212\u4fdd\u5b58\u6821\u9a8c\uff1acheckUnit\uff1a%1$s", map));
        DynamicObject processRoute = obj.getDynamicObject("processroute");
        if (processRoute == null) {
            return;
        }
        processRoute = processRouteMap.get(processRoute.getPkValue());
        DynamicObject mftEntrySeq = obj.getDynamicObject("mftentryseq");
        if (mftEntrySeq == null) {
            return;
        }
        DynamicObject baseUnit = obj.getDynamicObject("baseunit");
        Map<String, Object> object = map.get(mftEntrySeq.getLong("id"));
        logger.info(String.format("\u5de5\u5e8f\u8ba1\u5212\u4fdd\u5b58\u6821\u9a8c\u5de5\u5355\u5206\u5f55object\uff1a%1$s", object));
        String baseUnitName = baseUnit == null || baseUnit.getString("name") == null ? " " : baseUnit.getString("name");
        DynamicObjectCollection processEntry = processRoute.getDynamicObjectCollection("processentry");
        for (DynamicObject process : processEntry) {
            DynamicObject headUnit = process.getDynamicObject("headunit");
            String headUnitName = headUnit != null && headUnit.getString("name") != null ? headUnit.getString("name") : " ";
            BigDecimal unitRateConvert = UnitRateConvertUtil.getUnitRateConvert((Long)(object == null ? null : (Long)object.get("treeentryentity.materielmasterid")), (Long)(baseUnit == null ? null : Long.valueOf(baseUnit.getLong("id"))), headUnit == null ? null : Long.valueOf(headUnit.getLong("id")));
            if (BigDecimal.ZERO.compareTo(unitRateConvert) != 0) continue;
            String value = OperateEnum.getValue((String)operate);
            this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u5de5\u827a\u8def\u7ebf\u8868\u5934\u5355\u4f4d\uff08\u540d\u79f0\uff1a%1$s\uff09\u548c\u7269\u6599\u57fa\u672c\u5355\u4f4d\uff08\u540d\u79f0\uff1a%2$s\uff09\u4e0d\u5b58\u5728\u5355\u4f4d\u6362\u7b97\u5173\u7cfb\uff0c%3$s\u5931\u8d25\u3002", (String)"SFCManuftechValidator_133", (String)"mmc-sfc-opplugin", (Object[])new Object[0]), headUnitName, baseUnitName, value));
        }
    }

    private void unauditCheck(int i, Map<Long, Long> data, Map<Long, Map<String, Object>> map) {
        Map<String, Object> order;
        DynamicObject obj = this.dataEntities[i].getDataEntity();
        if (data.containsKey(obj.getPkValue())) {
            this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u4e0b\u6e38\u5b58\u5728\u5de5\u5e8f\u8ba1\u5212\uff0c\u4e0d\u5141\u8bb8\u53cd\u5ba1\u6838\u3002", (String)"SFCManuftechValidator_68", (String)"mmc-sfc-opplugin", (Object[])new Object[0]), new Object[0]));
        }
        if (obj.getDynamicObject("mftentryseq") != null && (order = map.get(obj.getDynamicObject("mftentryseq").getLong("id"))) != null) {
            if (!"A".equals(order.get("treeentryentity.bizstatus"))) {
                this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u751f\u4ea7\u5de5\u5355\u4e1a\u52a1\u72b6\u6001\u4e3a\u201c\u6b63\u5e38\u201d\uff0c\u624d\u53ef%3$s\uff08\u5de5\u5355\u7f16\u53f7\uff1a%1$s\uff1b\u5de5\u5355\u884c\u53f7\uff1a%2$s\uff09\u3002", (String)"SFCManuftechValidator_130", (String)"mmc-sfc-opplugin", (Object[])new Object[0]), order.get("billno"), order.get("treeentryentity.seq"), OperateEnum.getValue((String)"unaudit")));
            }
            DynamicObject transactionType = obj.getDynamicObject("transactiontype");
            if ("C".equals(order.get("treeentryentity.planstatus")) && transactionType != null && transactionType.getBoolean("ismanufetchchange")) {
                this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u751f\u4ea7\u5de5\u5355\u7684\u201c\u8ba1\u5212\u72b6\u6001\u201d\u4e3a\u201c\u4e0b\u8fbe\u201d\u4e14\u751f\u4ea7\u4e8b\u52a1\u7c7b\u578b\u542f\u7528\u5de5\u5e8f\u8ba1\u5212\u53d8\u66f4\uff0c\u5de5\u5e8f\u8ba1\u5212\u53cd\u5ba1\u6838\u5931\u8d25\u3002", (String)"SFCManuftechValidator_158", (String)"mmc-sfc-opplugin", (Object[])new Object[0]), new Object[0]));
            }
        }
    }

    private void deleteCheck(int i, Map<Long, Long> sfcManftech) {
        DynamicObject obj = this.dataEntities[i].getDataEntity();
        DynamicObjectCollection oprentrys = obj.getDynamicObjectCollection("oprentryentity");
        HashSet strs = Sets.newHashSet((Object[])new String[]{"A", "B", "C"});
        for (DynamicObject opr : oprentrys) {
            if (strs.contains(opr.getString("oprstatus"))) continue;
            String oprParent = opr.getString("oprparent");
            String oprNo = opr.getString("oprno");
            this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u5b58\u5728\u4e0b\u8fbe\u6216\u540e\u7eed\u64cd\u4f5c\uff0c\u4e0d\u5141\u8bb8\u5220\u9664\uff08\u5de5\u5e8f\u8ba1\u5212\uff1a%1$s\uff1b\u5de5\u5e8f\u5e8f\u5217\uff1a%2$s\uff1b\u5de5\u5e8f\u53f7\uff1a%3$s\uff09\u3002", (String)"SFCManuftechValidator_71", (String)"mmc-sfc-opplugin", (Object[])new Object[0]), obj.getString("billno"), oprParent, oprNo));
        }
        if (sfcManftech.containsKey(obj.getPkValue())) {
            this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u4e0b\u6e38\u5b58\u5728\u5de5\u5e8f\u8ba1\u5212\uff0c\u4e0d\u5141\u8bb8\u5220\u9664\u3002", (String)"SFCManuftechValidator_72", (String)"mmc-sfc-opplugin", (Object[])new Object[0]), new Object[0]));
        }
    }

    private Map<Long, Long> getSfcManftech(Set<String> parentPlanIds) {
        HashMap<Long, Long> result = new HashMap<Long, Long>(16);
        QFilter filter = new QFilter("parentplanid", "in", parentPlanIds);
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"getSfcManftech", (String)"sfc_manftech", (String)"id", (QFilter[])new QFilter[]{filter}, (String)"");){
            while (dataSet.hasNext()) {
                Row next = dataSet.next();
                result.put(next.getLong("id"), next.getLong("id"));
            }
        }
        return result;
    }

    private Map<Long, Long> getSfcManftechByOrderEntryId(Set<Long> orderEntryId, Set<Long> ids) {
        HashMap<Long, Long> result = new HashMap<Long, Long>(16);
        QFilter filter = new QFilter("mftentryseq", "in", orderEntryId);
        QFilter filter1 = new QFilter("id", "not in", ids);
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"getSfcManftechByOrderEntryId", (String)"sfc_manftech", (String)"mftentryseq,id", (QFilter[])new QFilter[]{filter, filter1}, (String)"");){
            while (dataSet.hasNext()) {
                Row next = dataSet.next();
                result.put(next.getLong("mftentryseq"), next.getLong("id"));
            }
        }
        return result;
    }

    private void auditCheck(int i, Map<Long, Map<String, Object>> map, Map<Object, DynamicObject> orgMap) {
        DynamicObject obj = this.dataEntities[i].getDataEntity();
        Map<String, Object> order = map.get(obj.getDynamicObject("mftentryseq").getLong("id"));
        if (order != null && !"C".equals(order.get("billstatus")) && !this.getOption().containsVariable("autoAudit")) {
            this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u4e0a\u6e38\u5355\u636e\u751f\u4ea7\u5de5\u5355\uff08\u7f16\u53f7\uff1a%1$s\uff09\u672a\u5ba1\u6838\u3002", (String)"SFCManuftechValidator_73", (String)"mmc-sfc-opplugin", (Object[])new Object[0]), order.get("billno")));
        }
        if (order != null && !"A".equals(order.get("treeentryentity.bizstatus"))) {
            this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u751f\u4ea7\u5de5\u5355\u4e1a\u52a1\u72b6\u6001\u4e3a\u201c\u6b63\u5e38\u201d\uff0c\u624d\u53ef%3$s\uff08\u5de5\u5355\u7f16\u53f7\uff1a%1$s\uff1b\u5de5\u5355\u884c\u53f7\uff1a%2$s\uff09\u3002", (String)"SFCManuftechValidator_130", (String)"mmc-sfc-opplugin", (Object[])new Object[0]), order.get("billno"), order.get("treeentryentity.seq"), OperateEnum.getValue((String)"audit")));
        }
    }

    private void submitCheck(String operate, Map<Long, Map<String, Object>> map, Map<Object, DynamicObject> processRouteMap, Map<Long, Long> mftech) {
        HashSet workCenterIds = new HashSet(16);
        for (int i = 0; i < this.dataEntities.length; ++i) {
            DynamicObject obj = this.dataEntities[i].getDataEntity();
            DynamicObjectCollection collection = obj.getDynamicObjectCollection("oprentryentity");
            workCenterIds.addAll(collection.stream().filter(x -> x.getDynamicObject("oprworkcenter") != null).map(x -> x.getDynamicObject("oprworkcenter").getPkValue()).collect(Collectors.toSet()));
        }
        Map workCenter = WorkcenterQueryHelper.getDataCacheBySet(workCenterIds);
        for (int i = 0; i < this.dataEntities.length; ++i) {
            DynamicObjectCollection proEntry;
            DynamicObject obj = this.dataEntities[i].getDataEntity();
            this.checkHead(obj, operate, i, map, processRouteMap, mftech);
            if (this.isNull(obj.getBigDecimal("qty")) || obj.getBigDecimal("qty").compareTo(BigDecimal.ZERO) == 0) {
                this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u201c\u6570\u91cf\u201d\u4e0d\u80fd\u4e3a0\u3002", (String)"SFCManuftechValidator_75", (String)"mmc-sfc-opplugin", (Object[])new Object[0]), new Object[0]));
            }
            if (this.isNull(obj.getDynamicObject("transactiontype"))) {
                this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u201c\u4e8b\u52a1\u7c7b\u578b\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"SFCManuftechValidator_76", (String)"mmc-sfc-opplugin", (Object[])new Object[0]), new Object[0]));
            }
            if (this.isNull(obj.get("planstarttime"))) {
                this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u201c\u8ba1\u5212\u5f00\u5de5\u65f6\u95f4\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"SFCManuftechValidator_77", (String)"mmc-sfc-opplugin", (Object[])new Object[0]), new Object[0]));
            }
            if (this.isNull(obj.get("planfinishtime"))) {
                this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u201c\u8ba1\u5212\u5b8c\u5de5\u65f6\u95f4\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"SFCManuftechValidator_78", (String)"mmc-sfc-opplugin", (Object[])new Object[0]), new Object[0]));
            }
            if (this.isNull(obj.getString("plantype"))) {
                this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u201c\u8ba1\u5212\u7c7b\u578b\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"SFCManuftechValidator_79", (String)"mmc-sfc-opplugin", (Object[])new Object[0]), new Object[0]));
            }
            if ((proEntry = obj.getDynamicObjectCollection("proentryentity")).size() == 0) {
                this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\u5e8f\u5217\u4fe1\u606f\u4e0d\u5141\u8bb8\u4e3a\u7a7a\u3002", (String)"SFCManuftechValidator_80", (String)"mmc-sfc-opplugin", (Object[])new Object[0]), new Object[0]));
            }
            for (int j = 0; j < proEntry.size(); ++j) {
                Set collect;
                DynamicObject entryObj = (DynamicObject)proEntry.get(j);
                if (this.isNull(entryObj.getString("processseq"))) {
                    this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\u5e8f\u5217\u5217\u8868\u7b2c%1$s\u884c\u5206\u5f55\u7684\u201c\u5e8f\u5217\u53f7\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"SFCManuftechValidator_81", (String)"mmc-sfc-opplugin", (Object[])new Object[0]), j + 1));
                }
                if (this.isNull(entryObj.getString("processseqname"))) {
                    this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\u5e8f\u5217\uff08%s\uff09\u7684\u201c\u5e8f\u5217\u540d\u79f0\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"SFCManuftechValidator_82", (String)"mmc-sfc-opplugin", (Object[])new Object[0]), entryObj.getString("processseq")));
                }
                if (!"A".equals(entryObj.getString("processseqtype"))) {
                    if (this.isNull(entryObj.getString("processrelation"))) {
                        this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\u5e8f\u5217\uff08%s\uff09\u7684\u201c\u5e76\u884c\u5173\u7cfb\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"SFCManuftechValidator_83", (String)"mmc-sfc-opplugin", (Object[])new Object[0]), j + 1));
                    }
                    if (this.isNull(entryObj.getString("processoutput"))) {
                        this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\u5e8f\u5217\uff08%s\uff09\u7684\u201c\u8f6c\u51fa\u5de5\u5e8f\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"SFCManuftechValidator_84", (String)"mmc-sfc-opplugin", (Object[])new Object[0]), j + 1));
                    }
                    if (this.isNull(entryObj.getString("processinput"))) {
                        this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\u5e8f\u5217\uff08%s\uff09\u7684\u201c\u8f6c\u5165\u5de5\u5e8f\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"SFCManuftechValidator_85", (String)"mmc-sfc-opplugin", (Object[])new Object[0]), j + 1));
                    }
                    if (NumberUtils.toInt((String)entryObj.getString("processinput")) < NumberUtils.toInt((String)entryObj.getString("processoutput"))) {
                        this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\u5e8f\u5217\uff08%s\uff09\u7684\u201c\u8f6c\u5165\u5de5\u5e8f\u201d\u4e0d\u80fd\u5c0f\u4e8e\u201c\u8f6c\u51fa\u5de5\u5e8f\u201d\u3002", (String)"SFCManuftechValidator_86", (String)"mmc-sfc-opplugin", (Object[])new Object[0]), j + 1));
                    }
                }
                if ((collect = obj.getDynamicObjectCollection("oprentryentity").stream().filter(x -> StringUtils.isNotBlank((CharSequence)x.getString("oprparent"))).map(x -> x.getString("oprparent")).collect(Collectors.toSet())).contains(entryObj.getString("processseq"))) continue;
                this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\u5e8f\u5217\uff08%s\uff09\u81f3\u5c11\u5f55\u5165\u4e00\u6761\u5de5\u5e8f\u3002", (String)"SFCManuftechValidator_87", (String)"mmc-sfc-opplugin", (Object[])new Object[0]), entryObj.getString("processseq")));
            }
            DynamicObjectCollection oprEntry = obj.getDynamicObjectCollection("oprentryentity");
            if (oprEntry.size() == 0) {
                this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\u5217\u8868\u4fe1\u606f\u4e0d\u5141\u8bb8\u4e3a\u7a7a\u3002", (String)"SFCManuftechValidator_88", (String)"mmc-sfc-opplugin", (Object[])new Object[0]), new Object[0]));
            }
            DynamicObject orgObject = obj.getDynamicObject("org");
            for (int j = 0; j < oprEntry.size(); ++j) {
                BigDecimal qty;
                DynamicObject entryObj = (DynamicObject)oprEntry.get(j);
                if (entryObj.getInt("oprno") % 1 != 0) {
                    this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\u53f7\u4e0d\u5408\u6cd5\uff08\u5de5\u5e8f\u5e8f\u5217\uff1a%1$s\uff1b\u5de5\u5e8f\u53f7\uff1a%2$s\uff09\u3002", (String)"SFCManuftechValidator_89", (String)"mmc-sfc-opplugin", (Object[])new Object[0]), entryObj.getString("oprparent"), entryObj.getString("oprno")));
                }
                String oprparent = entryObj.getString("oprparent");
                String machiningtype = entryObj.getString("machiningtype");
                if (StringUtils.isBlank((CharSequence)machiningtype)) {
                    this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u201c\u52a0\u5de5\u7c7b\u578b\u201d\u4e0d\u80fd\u4e3a\u7a7a\uff08\u5de5\u5e8f\u5e8f\u5217\uff1a%1$s\uff1b\u5de5\u5e8f\u53f7\uff1a%2$s\uff09\u3002", (String)"SFCManuftechValidator_155", (String)"mmc-sfc-opplugin", (Object[])new Object[0]), oprparent, entryObj.getString("oprno")));
                }
                if (StringUtils.equals((CharSequence)"1004", (CharSequence)machiningtype)) {
                    this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\u7684\u201c\u52a0\u5de5\u7c7b\u578b\u201d\u4e0d\u80fd\u4e3a\u201c\u4e0d\u9650\u5236\u201d\uff08\u5de5\u5e8f\u5e8f\u5217\uff1a%1$s\uff1b\u5de5\u5e8f\u53f7\uff1a%2$s\uff09\uff0c\u8bf7\u4fee\u6539\u3002", (String)"SFCManuftechValidator_140", (String)"mmc-sfc-opplugin", (Object[])new Object[0]), oprparent, entryObj.getString("oprno")));
                }
                DynamicObject oprorg = entryObj.getDynamicObject("oprorg");
                if (StringUtils.equals((CharSequence)"1003", (CharSequence)machiningtype)) {
                    if (orgObject != null && oprorg != null && StringUtils.equals((CharSequence)oprorg.getPkValue().toString(), (CharSequence)orgObject.getPkValue().toString())) {
                        this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\u7684\u201c\u52a0\u5de5\u7c7b\u578b\u201d\u4e3a\u201c\u5185\u534f\u52a0\u5de5\u201d\uff08\u5de5\u5e8f\u5e8f\u5217\uff1a%1$s\uff1b\u5de5\u5e8f\u53f7\uff1a%2$s\uff09\uff0c\u201c\u52a0\u5de5\u7ec4\u7ec7\u201d\u4e0d\u80fd\u4e0e\u8868\u5934\u4e2d\u201c\u751f\u4ea7\u7ec4\u7ec7\u201d\u4e00\u81f4\uff0c\u8bf7\u4fee\u6539\u3002", (String)"SFCManuftechValidator_156", (String)"mmc-sfc-opplugin", (Object[])new Object[0]), oprparent, entryObj.getString("oprno")));
                    }
                } else if (orgObject != null && oprorg != null && !StringUtils.equals((CharSequence)oprorg.getPkValue().toString(), (CharSequence)orgObject.getPkValue().toString())) {
                    this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\u7684\u201c\u52a0\u5de5\u7c7b\u578b\u201d\u4e0d\u4e3a\u201c\u5185\u534f\u52a0\u5de5\u201d\uff08\u5de5\u5e8f\u5e8f\u5217\uff1a%1$s\uff1b\u5de5\u5e8f\u53f7\uff1a%2$s\uff09\uff0c\u201c\u52a0\u5de5\u7ec4\u7ec7\u201d\u987b\u4e0e\u8868\u5934\u4e2d\u201c\u751f\u4ea7\u7ec4\u7ec7\u201d\u4e00\u81f4\uff0c\u8bf7\u4fee\u6539\u3002", (String)"SFCManuftechValidator_143", (String)"mmc-sfc-opplugin", (Object[])new Object[0]), oprparent, entryObj.getString("oprno")));
                }
                if ("1002".equals(machiningtype) && this.isNull(entryObj.get("purchaseorg"))) {
                    this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u59d4\u5916\u52a0\u5de5\u7684\u5de5\u5e8f\uff0c\u201c\u91c7\u8d2d\u7ec4\u7ec7\u201d\u4e0d\u80fd\u4e3a\u7a7a\uff08\u5de5\u5e8f\u5e8f\u5217\uff1a%1$s\uff1b\u5de5\u5e8f\u53f7\uff1a%2$s\uff09\u3002", (String)"SFCManuftechValidator_90", (String)"mmc-sfc-opplugin", (Object[])new Object[0]), entryObj.getString("oprparent"), entryObj.getString("oprno")));
                }
                if (this.isNull(entryObj.get("oprparent"))) {
                    this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\uff08%s\uff09\u7684\u201c\u5de5\u5e8f\u5e8f\u5217\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"SFCManuftechValidator_94", (String)"mmc-sfc-opplugin", (Object[])new Object[0]), entryObj.getString("oprno")));
                } else {
                    Set collect = obj.getDynamicObjectCollection("proentryentity").stream().filter(x -> StringUtils.isNotBlank((CharSequence)x.getString("processseq"))).map(x -> x.getString("processseq")).collect(Collectors.toSet());
                    if (!collect.contains(entryObj.get("oprparent"))) {
                        this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\u5e8f\u5217\uff08%s\uff09\u4e0d\u5b58\u5728\u3002", (String)"SFCManuftechValidator_95", (String)"mmc-sfc-opplugin", (Object[])new Object[0]), entryObj.getString("oprparent")));
                    }
                }
                if (this.isNull(entryObj.getDynamicObject("oprorg"))) {
                    this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u201c\u52a0\u5de5\u7ec4\u7ec7\u201d\u4e0d\u80fd\u4e3a\u7a7a\uff08\u5de5\u5e8f\u5e8f\u5217\uff1a%1$s\uff1b\u5de5\u5e8f\u53f7\uff1a%2$s\uff09\u3002", (String)"SFCManuftechValidator_159", (String)"mmc-sfc-opplugin", (Object[])new Object[0]), entryObj.getString("oprparent"), entryObj.getString("oprno")));
                }
                if (this.isNull(entryObj.getDynamicObject("oprworkcenter"))) {
                    this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u201c\u5de5\u4f5c\u4e2d\u5fc3\u201d\u4e0d\u80fd\u4e3a\u7a7a\uff08\u5de5\u5e8f\u5e8f\u5217\uff1a%1$s\uff1b\u5de5\u5e8f\u53f7\uff1a%2$s\uff09\u3002", (String)"SFCManuftechValidator_97", (String)"mmc-sfc-opplugin", (Object[])new Object[0]), entryObj.getString("oprparent"), entryObj.getString("oprno")));
                }
                if (this.isNull(entryObj.getString("oprno"))) {
                    this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\u5e8f\u5217\uff08%1$s\uff09\u4e0b\u5de5\u5e8f\u5217\u8868\u7b2c%2$s\u884c\u5206\u5f55\u7684\u201c\u5de5\u5e8f\u53f7\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"SFCManuftechValidator_98", (String)"mmc-sfc-opplugin", (Object[])new Object[0]), entryObj.getString("oprparent"), entryObj.getString("oprno")));
                }
                if (this.isNull(entryObj.getString("oprdescription"))) {
                    this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u201c\u5de5\u5e8f\u8bf4\u660e\u201d\u4e0d\u80fd\u4e3a\u7a7a\uff08\u5de5\u5e8f\u5e8f\u5217\uff1a%1$s\uff1b\u5de5\u5e8f\u53f7\uff1a%2$s\uff09\u3002", (String)"SFCManuftechValidator_99", (String)"mmc-sfc-opplugin", (Object[])new Object[0]), entryObj.getString("oprparent"), entryObj.getString("oprno")));
                }
                if (this.isNull(entryObj.getDynamicObject("oprctrlstrategy"))) {
                    this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u201c\u5de5\u5e8f\u63a7\u5236\u7b56\u7565\u201d\u4e0d\u80fd\u4e3a\u7a7a\uff08\u5de5\u5e8f\u5e8f\u5217\uff1a%1$s\uff1b\u5de5\u5e8f\u53f7\uff1a%2$s\uff09\u3002", (String)"SFCManuftechValidator_100", (String)"mmc-sfc-opplugin", (Object[])new Object[0]), entryObj.getString("oprparent"), entryObj.getString("oprno")));
                }
                if (this.isNull(entryObj.getString("oprstatus"))) {
                    this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\u7684\u201c\u72b6\u6001\u201d\u4e0d\u80fd\u4e3a\u7a7a\uff08\u5de5\u5e8f\u5e8f\u5217\uff1a%1$s\uff1b\u5de5\u5e8f\u53f7\uff1a%2$s\uff09\u3002", (String)"SFCManuftechValidator_101", (String)"mmc-sfc-opplugin", (Object[])new Object[0]), entryObj.getString("oprparent"), entryObj.getString("oprno")));
                }
                if (this.isNull(entryObj.get("oprstandardqty")) || entryObj.getBigDecimal("oprstandardqty").compareTo(BigDecimal.ZERO) == 0) {
                    this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u201c\u5de5\u5e8f\u6807\u51c6\u6570\u91cf\u201d\u4e0d\u80fd\u4e3a0\uff08\u5de5\u5e8f\u5e8f\u5217\uff1a%1$s\uff1b\u5de5\u5e8f\u53f7\uff1a%2$s\uff09\u3002", (String)"SFCManuftechValidator_134", (String)"mmc-sfc-opplugin", (Object[])new Object[0]), entryObj.getString("oprparent"), entryObj.getString("oprno")));
                }
                if (this.isNull(entryObj.getDynamicObject("oprunit"))) {
                    this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u201c\u5de5\u5e8f\u5e8f\u5217\u201d[%1$s]\u4e0b\u5de5\u5e8f[%2$s]\u201c\u5de5\u5e8f\u5355\u4f4d\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"SFCManuftechValidator_103", (String)"mmc-sfc-opplugin", (Object[])new Object[0]), entryObj.getString("oprparent"), entryObj.getString("oprno")));
                }
                if (this.isNull(entryObj.get("oprplanbegintime"))) {
                    this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u201c\u8ba1\u5212\u5f00\u59cb\u65f6\u95f4\u201d\u4e0d\u80fd\u4e3a\u7a7a\uff08\u5de5\u5e8f\u5e8f\u5217\uff1a%1$s\uff1b\u5de5\u5e8f\u53f7\uff1a%2$s\uff09\u3002", (String)"SFCManuftechValidator_104", (String)"mmc-sfc-opplugin", (Object[])new Object[0]), entryObj.getString("oprparent"), entryObj.getString("oprno")));
                }
                if (this.isNull(entryObj.get("oprplanfinishtime"))) {
                    this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u201c\u8ba1\u5212\u5b8c\u6210\u65f6\u95f4\u201d\u4e0d\u80fd\u4e3a\u7a7a\uff08\u5de5\u5e8f\u5e8f\u5217\uff1a%1$s\uff1b\u5de5\u5e8f\u53f7\uff1a%2$s\uff09\u3002", (String)"SFCManuftechValidator_135", (String)"mmc-sfc-opplugin", (Object[])new Object[0]), entryObj.getString("oprparent"), entryObj.getString("oprno")));
                }
                if (this.isNull(entryObj.get("upperratio")) || entryObj.getBigDecimal("upperratio").compareTo(BigDecimal.ZERO) < 0) {
                    this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u201c\u6c47\u62a5\u4e0a\u9650\u6bd4\u4f8b\u201d\u987b\u5927\u4e8e\u7b49\u4e8e0\uff08\u5de5\u5e8f\u5e8f\u5217\uff1a%1$s\uff1b\u5de5\u5e8f\u53f7\uff1a%2$s\uff09\u3002", (String)"SFCManuftechValidator_106", (String)"mmc-sfc-opplugin", (Object[])new Object[0]), entryObj.getString("oprparent"), entryObj.getString("oprno")));
                }
                if (this.isNull(entryObj.get("floorratio")) || entryObj.getBigDecimal("floorratio").compareTo(BigDecimal.ZERO) < 0) {
                    this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u201c\u6c47\u62a5\u4e0b\u9650\u6bd4\u4f8b\u201d\u987b\u5927\u4e8e\u7b49\u4e8e0\uff08\u5de5\u5e8f\u5e8f\u5217\uff1a%1$s\uff1b\u5de5\u5e8f\u53f7\uff1a%2$s\uff09\u3002", (String)"SFCManuftechValidator_107", (String)"mmc-sfc-opplugin", (Object[])new Object[0]), entryObj.getString("oprparent"), entryObj.getString("oprno")));
                }
                if (this.isNull(entryObj.get("headqty")) || entryObj.getBigDecimal("headqty").compareTo(BigDecimal.ZERO) == 0) {
                    this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u201c\u8868\u5934\u6570\u91cf\u201d\u4e0d\u80fd\u4e3a0\uff08\u5de5\u5e8f\u5e8f\u5217\uff1a%1$s\uff1b\u5de5\u5e8f\u53f7\uff1a%2$s\uff09\u3002", (String)"SFCManuftechValidator_56", (String)"mmc-sfc-opplugin", (Object[])new Object[0]), entryObj.getString("oprparent"), entryObj.getString("oprno")));
                }
                if (this.isNull(entryObj.get("operationqty")) || entryObj.getBigDecimal("operationqty").compareTo(BigDecimal.ZERO) == 0) {
                    this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u201c\u5de5\u5e8f\u6570\u91cf\u201d\u4e0d\u80fd\u4e3a0\uff08\u5de5\u5e8f\u5e8f\u5217\uff1a%1$s\uff1b\u5de5\u5e8f\u53f7\uff1a%2$s\uff09\u3002", (String)"SFCManuftechValidator_57", (String)"mmc-sfc-opplugin", (Object[])new Object[0]), entryObj.getString("oprparent"), entryObj.getString("oprno")));
                }
                if (this.isNull(entryObj.get("basebatchqty")) || entryObj.getBigDecimal("basebatchqty").compareTo(BigDecimal.ZERO) == 0) {
                    this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u201c\u57fa\u672c\u6279\u91cf\u201d\u4e0d\u80fd\u4e3a\u7a7a\uff08\u5de5\u5e8f\u5e8f\u5217\uff1a%1$s\uff1b\u5de5\u5e8f\u53f7\uff1a%2$s\uff09\u3002", (String)"SFCManuftechValidator_108", (String)"mmc-sfc-opplugin", (Object[])new Object[0]), entryObj.getString("oprparent"), entryObj.getString("oprno")));
                }
                if (this.isNull(entryObj.getDynamicObject("headunit"))) {
                    this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u201c\u8868\u5934\u5355\u4f4d\u201d\u4e0d\u80fd\u4e3a\u7a7a\uff08\u5de5\u5e8f\u5e8f\u5217\uff1a%1$s\uff1b\u5de5\u5e8f\u53f7\uff1a%2$s\uff09\u3002", (String)"SFCManuftechValidator_109", (String)"mmc-sfc-opplugin", (Object[])new Object[0]), entryObj.getString("oprparent"), entryObj.getString("oprno")));
                }
                if (StringUtils.isBlank((CharSequence)entryObj.getString("inspectiontype"))) {
                    this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u201c\u68c0\u9a8c\u65b9\u5f0f\u201d\u4e0d\u80fd\u4e3a\u7a7a\uff08\u5de5\u5e8f\u5e8f\u5217\uff1a%1$s\uff1b\u5de5\u5e8f\u53f7\uff1a%2$s\uff09\u3002", (String)"SFCManuftechValidator_131", (String)"mmc-sfc-opplugin", (Object[])new Object[0]), entryObj.getString("oprparent"), entryObj.getString("oprno")));
                }
                if (entryObj.getBoolean("firstinspection") && StringUtils.isBlank((CharSequence)entryObj.getString("firstinspectioncontrol"))) {
                    this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\u542f\u7528\u9996\u68c0\uff0c\u201c\u68c0\u9a8c\u63a7\u5236\u65b9\u5f0f\u201d\u4e0d\u80fd\u4e3a\u7a7a\uff08\u5de5\u5e8f\u5e8f\u5217\uff1a%1$s\uff1b\u5de5\u5e8f\u53f7\uff1a%2$s\uff09\u3002", (String)"SFCManuftechValidator_132", (String)"mmc-sfc-opplugin", (Object[])new Object[0]), entryObj.getString("oprparent"), entryObj.getString("oprno")));
                }
                if (entryObj.getDate("oprearliestbegintime") != null && entryObj.getDate("oprlatestbegintime") != null && entryObj.getDate("oprearliestbegintime").after(entryObj.getDate("oprlatestbegintime"))) {
                    this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u201c\u5de5\u5e8f\u5e8f\u5217\u201d[%1$s]\u4e0b\u5de5\u5e8f[%2$s]\u201c\u6700\u65e9\u5f00\u59cb\u65f6\u95f4\u201d\u4e0d\u80fd\u665a\u4e8e\u201c\u6700\u665a\u5f00\u59cb\u65f6\u95f4\u201d\u3002", (String)"SFCManuftechValidator_110", (String)"mmc-sfc-opplugin", (Object[])new Object[0]), entryObj.getString("oprparent"), entryObj.getString("oprno")));
                }
                if (entryObj.getDate("oprearliestfinishtime") != null && entryObj.getDate("oprlatestfinishtime") != null && entryObj.getDate("oprearliestfinishtime").after(entryObj.getDate("oprlatestfinishtime"))) {
                    this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\u7684\u201c\u6700\u65e9\u5b8c\u5de5\u65f6\u95f4\u201d\u4e0d\u80fd\u665a\u4e8e\u201c\u6700\u665a\u5b8c\u5de5\u65f6\u95f4\u201d\uff08\u5de5\u5e8f\u5e8f\u5217\uff1a%1$s\uff1b\u5de5\u5e8f\u53f7\uff1a%2$s\uff09\u3002", (String)"SFCManuftechValidator_111", (String)"mmc-sfc-opplugin", (Object[])new Object[0]), entryObj.getString("oprparent"), entryObj.getString("oprno")));
                }
                if (entryObj.getDate("oprearliestbegintime") != null && entryObj.getDate("oprearliestfinishtime") != null && entryObj.getDate("oprearliestbegintime").after(entryObj.getDate("oprearliestfinishtime"))) {
                    this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u201c\u5de5\u5e8f\u5e8f\u5217\u201d[%1$s]\u4e0b\u5de5\u5e8f[%2$s]\u201c\u6700\u65e9\u5f00\u59cb\u65f6\u95f4\u201d\u4e0d\u80fd\u665a\u4e8e\u201c\u6700\u65e9\u5b8c\u5de5\u65f6\u95f4\u201d\u3002", (String)"SFCManuftechValidator_112", (String)"mmc-sfc-opplugin", (Object[])new Object[0]), entryObj.getString("oprparent"), entryObj.getString("oprno")));
                }
                if (entryObj.getDate("oprlatestbegintime") != null && entryObj.getDate("oprlatestfinishtime") != null && entryObj.getDate("oprlatestbegintime").after(entryObj.getDate("oprlatestfinishtime"))) {
                    this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u201c\u5de5\u5e8f\u5e8f\u5217\u201d[%1$s]\u4e0b\u5de5\u5e8f[%2$s]\u201c\u6700\u665a\u5f00\u59cb\u65f6\u95f4\u201d\u4e0d\u80fd\u665a\u4e8e\u201c\u6700\u665a\u5b8c\u5de5\u65f6\u95f4\u201d\u3002", (String)"SFCManuftechValidator_113", (String)"mmc-sfc-opplugin", (Object[])new Object[0]), entryObj.getString("oprparent"), entryObj.getString("oprno")));
                }
                if (entryObj.getBoolean("oprissplit")) {
                    qty = entryObj.getBigDecimal("oprsuggestsplitqty");
                    if (qty.compareTo(BigDecimal.ZERO) == 0) {
                        this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\u542f\u7528\u62c6\u5206\u6392\u7a0b\uff0c\u201c\u5efa\u8bae\u62c6\u5206\u6570\u91cf\u201d\u987b\u5927\u4e8e0\uff08\u5de5\u5e8f\u5e8f\u5217\uff1a%1$s\uff1b\u5de5\u5e8f\u53f7\uff1a%2$s\uff09\u3002", (String)"SFCManuftechValidator_136", (String)"mmc-sfc-opplugin", (Object[])new Object[0]), entryObj.getString("oprparent"), entryObj.getString("oprno")));
                    }
                    if ((qty = entryObj.getBigDecimal("oprminworktime")).compareTo(BigDecimal.ZERO) == 0) {
                        this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\u542f\u7528\u62c6\u5206\u6392\u7a0b\uff0c\u201c\u6700\u5c0f\u52a0\u5de5\u65f6\u95f4\u201d\u987b\u5927\u4e8e0\uff08\u5de5\u5e8f\u5e8f\u5217\uff1a%1$s\uff1b\u5de5\u5e8f\u53f7\uff1a%2$s\uff09\u3002", (String)"SFCManuftechValidator_115", (String)"mmc-sfc-opplugin", (Object[])new Object[0]), entryObj.getString("oprparent"), entryObj.getString("oprno")));
                    }
                } else {
                    qty = entryObj.getBigDecimal("oprsuggestsplitqty");
                    if (qty.compareTo(BigDecimal.ZERO) < 0) {
                        this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u201c\u5efa\u8bae\u62c6\u5206\u6570\u201d\u987b\u5927\u4e8e\u7b49\u4e8e0\uff08\u5de5\u5e8f\u5e8f\u5217\uff1a%1$s\uff1b\u5de5\u5e8f\u53f7\uff1a%2$s\uff09\u3002", (String)"SFCManuftechValidator_116", (String)"mmc-sfc-opplugin", (Object[])new Object[0]), entryObj.getString("oprparent"), entryObj.getString("oprno")));
                    }
                    if ((qty = entryObj.getBigDecimal("oprminworktime")).compareTo(BigDecimal.ZERO) < 0) {
                        this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u201c\u6700\u5c0f\u52a0\u5de5\u65f6\u95f4\u201d\u987b\u5927\u4e8e\u7b49\u4e8e0\uff08\u5de5\u5e8f\u5e8f\u5217\uff1a%1$s\uff1b\u5de5\u5e8f\u53f7\uff1a%2$s\uff09\u3002", (String)"SFCManuftechValidator_117", (String)"mmc-sfc-opplugin", (Object[])new Object[0]), entryObj.getString("oprparent"), entryObj.getString("oprno")));
                    }
                }
                if (entryObj.getBoolean("oprisprocessoverlap")) {
                    qty = entryObj.getBigDecimal("oprminoverlaptime");
                    if (qty.compareTo(BigDecimal.ZERO) == 0) {
                        this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u91cd\u53e0\u5de5\u5e8f\uff0c\u201c\u91cd\u53e0\u6700\u5c0f\u65f6\u95f4\u201d\u987b\u5927\u4e8e0\uff08\u5de5\u5e8f\u5e8f\u5217\uff1a%1$s\uff1b\u5de5\u5e8f\u53f7\uff1a%2$s\uff09\u3002", (String)"SFCManuftechValidator_118", (String)"mmc-sfc-opplugin", (Object[])new Object[0]), entryObj.getString("oprparent"), entryObj.getString("oprno")));
                    }
                    if ((qty = entryObj.getBigDecimal("oproverlapqty")).compareTo(BigDecimal.ZERO) == 0) {
                        this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u91cd\u53e0\u5de5\u5e8f\uff0c\u201c\u91cd\u53e0\u6279\u91cf\u201d\u987b\u5927\u4e8e0\uff08\u5de5\u5e8f\u5e8f\u5217\uff1a%1$s\uff1b\u5de5\u5e8f\u53f7\uff1a%2$s\uff09\u3002", (String)"SFCManuftechValidator_137", (String)"mmc-sfc-opplugin", (Object[])new Object[0]), entryObj.getString("oprparent"), entryObj.getString("oprno")));
                    }
                } else {
                    qty = entryObj.getBigDecimal("oprminoverlaptime");
                    if (qty.compareTo(BigDecimal.ZERO) < 0) {
                        this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u201c\u91cd\u53e0\u6700\u5c0f\u65f6\u95f4\u201d\u4e0d\u80fd\u5c0f\u4e8e0\uff08\u5de5\u5e8f\u5e8f\u5217\uff1a%1$s\uff1b\u5de5\u5e8f\u53f7\uff1a%2$s\uff09\u3002", (String)"SFCManuftechValidator_120", (String)"mmc-sfc-opplugin", (Object[])new Object[0]), entryObj.getString("oprparent"), entryObj.getString("oprno")));
                    }
                    if ((qty = entryObj.getBigDecimal("oproverlapqty")).compareTo(BigDecimal.ZERO) < 0) {
                        this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u201c\u91cd\u53e0\u6279\u91cf\u201d\u987b\u5927\u4e8e\u7b49\u4e8e0\uff08\u5de5\u5e8f\u5e8f\u5217\uff1a%1$s\uff1b\u5de5\u5e8f\u53f7\uff1a%2$s\uff09\u3002", (String)"SFCManuftechValidator_121", (String)"mmc-sfc-opplugin", (Object[])new Object[0]), entryObj.getString("oprparent"), entryObj.getString("oprno")));
                    }
                }
                DynamicObjectCollection resEntry = entryObj.getDynamicObjectCollection("ressubentryentity");
                for (int k = 0; k < resEntry.size(); ++k) {
                    DynamicObject subEntryObj = (DynamicObject)resEntry.get(k);
                    if (!this.isNull(subEntryObj.getDynamicObject("schresource"))) continue;
                    this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\u6392\u7a0b\u5206\u5f55\u4e2d\uff0c\u201c\u8d44\u6e90\u7f16\u7801\u201d\u4e0d\u80fd\u4e3a\u7a7a\uff08\u5de5\u5e8f\u5e8f\u5217\uff1a%1$s\uff1b\u5de5\u5e8f\u53f7\uff1a%2$s\uff09\u3002", (String)"SFCManuftechValidator_122", (String)"mmc-sfc-opplugin", (Object[])new Object[0]), entryObj.getString("oprparent"), entryObj.getString("oprno")));
                }
                DynamicObjectCollection actEntry = entryObj.getDynamicObjectCollection("actsubentryentity");
                if (actEntry.size() == 0) {
                    this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\u81f3\u5c11\u5f55\u5165\u4e00\u6761\u5de5\u5e8f\u6d3b\u52a8\uff08\u5de5\u5e8f\u5e8f\u5217\uff1a%1$s\uff1b\u5de5\u5e8f\u53f7\uff1a%2$s\uff09\u3002", (String)"SFCManuftechValidator_123", (String)"mmc-sfc-opplugin", (Object[])new Object[0]), entryObj.getString("oprparent"), entryObj.getString("oprno")));
                }
                Map queryWorkCenter = QueryOrderUtil.queryWorkCenter((DynamicObject)entryObj, (Map)workCenter);
                for (int k = 0; k < actEntry.size(); ++k) {
                    DynamicObject subEntryObj = (DynamicObject)actEntry.get(k);
                    if (this.isNull(subEntryObj.getString("processstage"))) {
                        this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\u6d3b\u52a8\u5206\u5f55\u7b2c%3$s\u884c\u201c\u5de5\u5e8f\u9636\u6bb5\u201d\u4e0d\u80fd\u4e3a\u7a7a\uff08\u5de5\u5e8f\u5e8f\u5217\uff1a%1$s\uff1b\u5de5\u5e8f\u53f7\uff1a%2$s\uff09\u3002", (String)"SFCManuftechValidator_124", (String)"mmc-sfc-opplugin", (Object[])new Object[0]), entryObj.getString("oprparent"), entryObj.getString("oprno"), k + 1));
                    }
                    if (this.isNull(subEntryObj.getDynamicObject("actactivity"))) {
                        this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\u6d3b\u52a8\u5206\u5f55\u7b2c%3$s\u884c\u201c\u6d3b\u52a8\u7f16\u7801\u201d\u4e0d\u80fd\u4e3a\u7a7a\uff08\u5de5\u5e8f\u5e8f\u5217\uff1a%1$s\uff1b\u5de5\u5e8f\u53f7\uff1a%2$s\uff09\u3002", (String)"SFCManuftechValidator_125", (String)"mmc-sfc-opplugin", (Object[])new Object[0]), entryObj.getString("oprparent"), entryObj.getString("oprno"), k + 1));
                    } else if (queryWorkCenter.containsKey(subEntryObj.getDynamicObject("actactivity").getPkValue()) && ((Boolean)queryWorkCenter.get(subEntryObj.getDynamicObject("actactivity").getPkValue())).booleanValue() && BigDecimal.ZERO.compareTo(subEntryObj.getBigDecimal("actqty")) >= 0) {
                        this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\u6d3b\u52a8\u5206\u5f55\u7b2c%3$s\u884c\u201c\u57fa\u672c\u6570\u91cf\u201d\u987b\u5927\u4e8e0\uff08\u5de5\u5e8f\u5e8f\u5217\uff1a%1$s\uff1b\u5de5\u5e8f\u53f7\uff1a%2$s\uff09\u3002", (String)"SFCManuftechValidator_126", (String)"mmc-sfc-opplugin", (Object[])new Object[0]), entryObj.getString("oprparent"), entryObj.getString("oprno"), k + 1));
                    }
                    if (this.isNull(subEntryObj.getDynamicObject("actunit"))) {
                        this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\u6d3b\u52a8\u5206\u5f55\u7b2c%3$s\u884c\u201c\u8ba1\u91cf\u5355\u4f4d\u201d\u4e0d\u80fd\u4e3a\u7a7a\uff08\u5de5\u5e8f\u5e8f\u5217\uff1a%1$s\uff1b\u5de5\u5e8f\u53f7\uff1a%2$s\uff09\u3002", (String)"SFCManuftechValidator_127", (String)"mmc-sfc-opplugin", (Object[])new Object[0]), entryObj.getString("oprparent"), entryObj.getString("oprno"), k + 1));
                    }
                    if (this.isNull(subEntryObj.getDynamicObject("actstandardformula"))) {
                        this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\u6d3b\u52a8\u5206\u5f55\u7b2c%3$s\u884c\u201c\u6807\u51c6\u516c\u5f0f\u201d\u4e0d\u80fd\u4e3a\u7a7a\uff08\u5de5\u5e8f\u5e8f\u5217\uff1a%1$s\uff1b\u5de5\u5e8f\u53f7\uff1a%2$s\uff09\u3002", (String)"SFCManuftechValidator_128", (String)"mmc-sfc-opplugin", (Object[])new Object[0]), entryObj.getString("oprparent"), entryObj.getString("oprno"), k + 1));
                    }
                    if (this.isNull(subEntryObj.getDynamicObject("actstandardformula1"))) {
                        this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\u6d3b\u52a8\u5206\u5f55\u7b2c%3$s\u884c\u201c\u6807\u51c6\u516c\u5f0f\u201d\u4e0d\u80fd\u4e3a\u7a7a\uff08\u5de5\u5e8f\u5e8f\u5217\uff1a%1$s\uff1b\u5de5\u5e8f\u53f7\uff1a%2$s\uff09\u3002", (String)"SFCManuftechValidator_128", (String)"mmc-sfc-opplugin", (Object[])new Object[0]), entryObj.getString("oprparent"), entryObj.getString("oprno"), k + 1));
                    }
                    if (subEntryObj.getDate("actplanbegintime") == null || subEntryObj.getDate("actplanfinishtime") == null || !subEntryObj.getDate("actplanbegintime").after(subEntryObj.getDate("actplanfinishtime"))) continue;
                    this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u201c\u5de5\u5e8f\u5e8f\u5217\u201d[%1$s]\u4e0b\u5de5\u5e8f[%2$s]\u5de5\u5e8f\u6d3b\u52a8-\u8ba1\u5212\u5b50\u5206\u5f55\u201c\u8ba1\u5212\u5f00\u59cb\u65f6\u95f4\u201d\u4e0d\u80fd\u665a\u4e8e\u201c\u8ba1\u5212\u5b8c\u6210\u65f6\u95f4\u201d\u3002", (String)"SFCManuftechValidator_129", (String)"mmc-sfc-opplugin", (Object[])new Object[0]), entryObj.getString("oprparent"), entryObj.getString("oprno")));
                }
            }
        }
    }

    private boolean isNull(Object obj) {
        if (obj instanceof String) {
            return obj == null || obj.toString().trim().length() == 0;
        }
        return obj == null;
    }

    private void setMaterialMuConvCacheLst(ExtendedDataEntity[] dataEntities, Map<Long, Map<String, Object>> orderByEntryMap, Map<Object, DynamicObject> processRouteMap) {
        HashSet<Long> materialIDs = new HashSet<Long>(16);
        for (ExtendedDataEntity dataEntitie : dataEntities) {
            Boolean isDiffUnitFlag;
            DynamicObject orderBill = dataEntitie.getDataEntity();
            DynamicObject processRoute = orderBill.getDynamicObject("processroute");
            DynamicObject mftEntrySeq = orderBill.getDynamicObject("mftentryseq");
            if (processRoute == null || mftEntrySeq == null || (processRoute = processRouteMap.get(processRoute.getPkValue())) == null) continue;
            Map<String, Object> object = orderByEntryMap.get(mftEntrySeq.getLong("id"));
            Object materialObj = object.get("treeentryentity.materielmasterid");
            Long materialID = 0L;
            if (materialObj != null) {
                materialID = (Long)materialObj;
            }
            if (!(isDiffUnitFlag = this.getDiffUnitFlag(orderBill, processRoute)).booleanValue()) continue;
            materialIDs.add(materialID);
        }
        MaterialMuConvHelper.setMaterialCacheLst(materialIDs);
    }

    private Boolean getDiffUnitFlag(DynamicObject orderBill, DynamicObject processRoute) {
        DynamicObject baseUnit = orderBill.getDynamicObject("baseunit");
        Long baseUnitId = DynamicObjDataUtil.getDynamicObjectPK((DynamicObject)baseUnit);
        DynamicObjectCollection processEntry = processRoute.getDynamicObjectCollection("processentry");
        Boolean isDiffUnit = Boolean.FALSE;
        for (DynamicObject process : processEntry) {
            DynamicObject headUnit = process.getDynamicObject("headunit");
            Long headUnitId = DynamicObjDataUtil.getDynamicObjectPK((DynamicObject)headUnit);
            if (baseUnitId.equals(headUnitId) || baseUnitId <= 0L) continue;
            isDiffUnit = Boolean.TRUE;
            break;
        }
        return isDiffUnit;
    }
}

