/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.sfc.opplugin.processreport;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bd.mpdm.common.utils.DateUtils;
import kd.bd.mpdm.common.utils.MmcLockHelper;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import org.apache.commons.lang3.StringUtils;

public class ProcessReportAuditOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        e.getFieldKeys().add("bookdate");
        e.getFieldKeys().add("manufactureid");
        e.getFieldKeys().add("manufactureentryid");
        e.getFieldKeys().add("matertype");
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        super.afterExecuteOperationTransaction(e);
        String operateKey = e.getOperationKey();
        DynamicObject[] bills = e.getDataEntities();
        switch (operateKey) {
            case "audit": {
                this.audit(bills);
                break;
            }
        }
    }

    private void audit(DynamicObject[] bills) {
        HashSet<Long> orderEntryids = new HashSet<Long>(16);
        for (DynamicObject reportbill : bills) {
            DynamicObjectCollection sumentitys = reportbill.getDynamicObjectCollection("sumentry");
            for (DynamicObject obj : sumentitys) {
                String matertype = obj.getString("matertype");
                if (!StringUtils.equals((CharSequence)"C", (CharSequence)matertype) || obj.getDynamicObject("manufactureentryid") == null) continue;
                orderEntryids.add(obj.getDynamicObject("manufactureentryid").getLong("id"));
            }
        }
        this.updateOrderBeginBookDate(bills, orderEntryids);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateOrderBeginBookDate(DynamicObject[] bills, Set<Long> orderEntryids) {
        if (bills == null || bills.length < 1 || orderEntryids.size() < 1) {
            return;
        }
        HashSet<String> lockKeys = new HashSet<String>(orderEntryids.size());
        for (Long orderentryid : orderEntryids) {
            lockKeys.add("updateorderdbookdate/" + orderentryid);
        }
        Map dLocks = MmcLockHelper.createDLocks(lockKeys, (boolean)false);
        try {
            Map successdLocks = MmcLockHelper.tryDLocks((Map)dLocks, (Long)100L);
            if (successdLocks == null || successdLocks.isEmpty()) {
                return;
            }
            HashSet<Long> updateorderEntryids = new HashSet<Long>(successdLocks.size());
            for (String successdLock : successdLocks.keySet()) {
                String[] split = successdLock.split("/");
                updateorderEntryids.add(Long.parseLong(split[1]));
            }
            HashMap<Long, DynamicObject> orderBills = new HashMap<Long, DynamicObject>(16);
            if (orderEntryids.size() > 0) {
                DynamicObject[] orders;
                QFilter filters = new QFilter("treeentryentity.id", "in", updateorderEntryids);
                for (DynamicObject order : orders = BusinessDataServiceHelper.load((String)"pom_mftorder", (String)this.getOrderSelecors(), (QFilter[])filters.toArray())) {
                    orderBills.put(order.getLong("id"), order);
                }
            }
            if (orderBills.size() > 0) {
                HashSet<DynamicObject> updateData = new HashSet<DynamicObject>(bills.length);
                HashSet<Long> updateEntryids = new HashSet<Long>(bills.length);
                HashSet<Long> updateOrderids = new HashSet<Long>(bills.length);
                HashSet<Long> updateSplitEntryids = new HashSet<Long>(bills.length);
                HashSet<Long> updateSplitOrderids = new HashSet<Long>(bills.length);
                for (DynamicObject reportBill : bills) {
                    Date bookdate = reportBill.getDate("bookdate");
                    DynamicObjectCollection sumentrys = reportBill.getDynamicObjectCollection("sumentry");
                    for (DynamicObject sumentry : sumentrys) {
                        Long orderbillId = sumentry.getLong("manufactureid");
                        DynamicObject orderBill = (DynamicObject)orderBills.get(orderbillId);
                        DynamicObjectCollection treeentryentitys = orderBill.getDynamicObjectCollection("treeentryentity");
                        for (DynamicObject treeentryentity : treeentryentitys) {
                            Date beginbookdate;
                            Long entryid = treeentryentity.getLong("id");
                            Long pid = treeentryentity.getLong("pid");
                            if (!updateorderEntryids.contains(entryid) && !updateorderEntryids.contains(pid) || (beginbookdate = treeentryentity.getDate("beginbookdate")) != null && !beginbookdate.after(bookdate)) continue;
                            treeentryentity.set("beginbookdate", (Object)(bookdate != null ? DateUtils.getShortDate((Date)bookdate) : null));
                            updateData.add(orderBill);
                            updateEntryids.add(entryid);
                            updateOrderids.add(orderbillId);
                            if (orderEntryids.contains(pid)) continue;
                            updateSplitEntryids.add(entryid);
                            updateSplitOrderids.add(orderbillId);
                        }
                    }
                }
                if (updateData.size() > 0) {
                    SaveServiceHelper.update((DynamicObject[])updateData.toArray(new DynamicObject[updateData.size()]));
                    this.updateSplitLog(orderBills, updateSplitEntryids, updateSplitOrderids);
                    this.updateChangeLog(orderBills, updateEntryids, updateOrderids);
                }
            }
        }
        finally {
            if (dLocks != null && dLocks.size() > 0) {
                MmcLockHelper.unDLocks(new ArrayList(dLocks.values()));
            }
        }
    }

    private void updateSplitLog(Map<Long, DynamicObject> orderBills, Set<Long> updateEntryids, Set<Long> updateOrderids) {
        DynamicObject[] splitlogs;
        if (updateEntryids == null || updateOrderids == null || updateEntryids.size() < 1 || updateOrderids.size() < 1) {
            return;
        }
        HashSet<DynamicObject> splitlogUpdateData = new HashSet<DynamicObject>(updateOrderids.size());
        QFilter qf = new QFilter("orderid", "in", updateOrderids);
        qf.and(new QFilter("orderentryid", "in", updateEntryids));
        for (DynamicObject splitlog : splitlogs = BusinessDataServiceHelper.load((String)"pom_mftorder_splitlog", (String)"orderid,orderno,orderentryid,billentry,billentry.beginbookdate", (QFilter[])qf.toArray())) {
            Date beginbookdate;
            long orderid = splitlog.getLong("orderid");
            DynamicObject orderBill = orderBills.get(orderid);
            if (orderBill == null) continue;
            Long odentryid = 0L;
            DynamicObject orderentryid = splitlog.getDynamicObject("orderentryid");
            if (orderentryid != null) {
                odentryid = Long.parseLong(orderentryid.getPkValue().toString());
            }
            if ((beginbookdate = this.getOrderBeginBookDate(orderBill, odentryid)) == null) continue;
            DynamicObjectCollection billentrys = splitlog.getDynamicObjectCollection("billentry");
            for (DynamicObject billentry : billentrys) {
                Object beginbookdate1 = billentry.get("beginbookdate");
                if (beginbookdate1 != null) continue;
                billentry.set("beginbookdate", (Object)(beginbookdate != null ? DateUtils.getShortDate((Date)beginbookdate) : null));
                splitlogUpdateData.add(splitlog);
            }
        }
        if (splitlogUpdateData.size() > 0) {
            SaveServiceHelper.update((DynamicObject[])splitlogUpdateData.toArray(new DynamicObject[splitlogUpdateData.size()]));
        }
    }

    private void updateChangeLog(Map<Long, DynamicObject> orderBills, Set<Long> updateEntryids, Set<Long> updateOrderids) {
        DynamicObject[] changelogs;
        if (updateEntryids == null || updateOrderids == null || updateEntryids.size() < 1 || updateOrderids.size() < 1) {
            return;
        }
        HashSet<DynamicObject> changelogUpdateData = new HashSet<DynamicObject>(updateOrderids.size());
        QFilter qf = new QFilter("srcbillid", "in", updateOrderids);
        qf.and(new QFilter("srcbillentryid", "in", updateEntryids));
        for (DynamicObject changelog : changelogs = BusinessDataServiceHelper.load((String)"pom_xmftorderlog", (String)"srcbillid,srcbillentryid,beginbookdate", (QFilter[])qf.toArray())) {
            Object beginbookdateObj;
            Long odentryid;
            Date beginbookdate;
            long orderid = changelog.getLong("srcbillid");
            DynamicObject orderBill = orderBills.get(orderid);
            if (orderBill == null || (beginbookdate = this.getOrderBeginBookDate(orderBill, odentryid = Long.valueOf(changelog.getLong("srcbillentryid")))) == null || (beginbookdateObj = changelog.get("beginbookdate")) != null) continue;
            changelog.set("beginbookdate", (Object)beginbookdate);
            changelogUpdateData.add(changelog);
        }
        if (changelogUpdateData.size() > 0) {
            SaveServiceHelper.update((DynamicObject[])changelogUpdateData.toArray(new DynamicObject[changelogUpdateData.size()]));
        }
    }

    private Date getOrderBeginBookDate(DynamicObject orderBill, Long odentryid) {
        if (orderBill == null || odentryid == null) {
            return null;
        }
        Date beginbookdate = null;
        DynamicObjectCollection treeentryentitys = orderBill.getDynamicObjectCollection("treeentryentity");
        for (DynamicObject treeentryentity : treeentryentitys) {
            Long entryid = treeentryentity.getLong("id");
            if (!odentryid.equals(entryid)) continue;
            beginbookdate = treeentryentity.getDate("beginbookdate");
        }
        return beginbookdate;
    }

    private String getOrderSelecors() {
        StringBuilder fileds = new StringBuilder(200);
        fileds.append("billno");
        fileds.append(",treeentryentity");
        fileds.append(",treeentryentity.pid");
        fileds.append(",treeentryentity.beginbookdate");
        fileds.append(",treeentryentity.closebookdate");
        return fileds.toString();
    }
}

