/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.sfc.opplugin.processreport;

import java.util.HashSet;
import kd.bd.mpdm.business.helper.InvBillHelper;
import kd.bd.mpdm.business.mftorder.SerialNumberHelper;
import kd.bd.mpdm.opplugin.sn.val.SerialNumberSaveValidator;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;
import kd.mmc.sfc.common.processreport.ProcessReportUtils;

public class ProcessReportSaveOp
extends AbstractOperationServicePlugIn {
    private static Log logger = LogFactory.getLog(ProcessReportSaveOp.class);
    private boolean isFromDataBase = true;

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        ProcessReportUtils.setEntityColumn((PreparePropertysEventArgs)e);
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        DynamicObject[] dataEntities = e.getDataEntities();
        if (dataEntities != null && dataEntities.length != 0) {
            this.isFromDataBase = dataEntities[0].getDataEntityState().getFromDatabase();
            if (this.isFromDataBase) {
                e.addValidator((AbstractValidator)new SerialNumberSaveValidator());
            }
        }
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        try (TraceSpan span = Tracer.create((String)"BillTplSaveOp", (String)"afterExecuteOperationTransaction");){
            DynamicObject[] entities = e.getDataEntities();
            if (entities == null || entities.length == 0) {
                return;
            }
            HashSet<String> ids = new HashSet<String>(16);
            HashSet<String> entryIds = new HashSet<String>(16);
            for (DynamicObject entity : entities) {
                if (InvBillHelper.isVirtualBill((DynamicObject)entity)) continue;
                ids.add(entity.getPkValue().toString());
                DynamicObjectCollection billentries = entity.getDynamicObjectCollection("sumentry");
                for (DynamicObject billentry : billentries) {
                    DynamicObject material = billentry.getDynamicObject("materielinv");
                    if (material == null || !material.getBoolean("enableserial")) continue;
                    entryIds.add(billentry.getPkValue().toString());
                }
            }
            if (this.isFromDataBase) {
                String billtype = entities[0].getDynamicObjectType().getName();
                DispatchServiceHelper.invokeBizService((String)"scmc", (String)"sbs", (String)"BillSNRelationService", (String)"deleteSurplusRelation", (Object[])new Object[]{billtype, ids, entryIds});
            } else {
                if (entryIds.size() == 0) {
                    return;
                }
                DispatchServiceHelper.invokeBizService((String)"scmc", (String)"sbs", (String)"BillSNRelationService", (String)"generateSNByBotpPush", (Object[])new Object[]{entities});
            }
            if (entryIds.size() > 0) {
                SerialNumberHelper.copySerialnumToRel((DynamicObject[])entities, (String)"sumentry");
            }
        }
    }
}

