/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.sfc.opplugin.processreport.event;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bd.mpdm.common.mftorder.utils.MPDMMftGenStocksUtils;
import kd.bos.bec.api.IEventServicePlugin;
import kd.bos.bec.model.EntityEvent;
import kd.bos.bec.model.KDBizEvent;
import kd.bos.data.BusinessDataReader;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.runtime.ConvertOperationResult;
import kd.bos.entity.botp.runtime.PushArgs;
import kd.bos.entity.botp.runtime.SourceBillReport;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.botp.ConvertServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.mmc.sfc.business.manuftech.WriteRepSubentryBOTPHelper;
import kd.mmc.sfc.opplugin.processreport.event.ProcessReportData;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;

public class MilestoneRptAuditAutoReportEventService
implements IEventServicePlugin {
    private static final Log logger = LogFactory.getLog(MilestoneRptAuditAutoReportEventService.class);

    public Object handleEvent(KDBizEvent evt) {
        if (evt instanceof EntityEvent) {
            EntityEvent e = (EntityEvent)evt;
            List businessKeys = e.getBusinesskeys();
            String operation = e.getOperation();
            if ("audit".equals(operation)) {
                long start = System.currentTimeMillis();
                Set billIds = businessKeys.stream().map(NumberUtils::toLong).collect(Collectors.toSet());
                QFilter[] idQf = new QFilter[]{new QFilter("id", "in", billIds)};
                String selects = "id,transactiontype,ischargeoff,sumentry.id,ismilestoneprocess,mfttechnics,processseq,oprno,oprentryid,completbaseqty";
                DynamicObject[] rptBills = BusinessDataServiceHelper.load((String)"sfc_processreportbill", (String)selects, (QFilter[])idQf);
                this.handle(rptBills);
                logger.info("\u91cc\u7a0b\u7891\u5de5\u5e8f\u6c47\u62a5\u5ba1\u6838\u603b\u8017\u65f6\uff1a" + (System.currentTimeMillis() - start));
            }
        }
        return evt.getEventId();
    }

    private void handle(DynamicObject[] rptBills) {
        HashMap<String, String> manufetchInfoMap;
        Map<Long, Set<Long>> idEntryIdMap;
        HashMap<String, List<ProcessReportData>> processInfoMap = new HashMap<String, List<ProcessReportData>>(16);
        HashMap<String, Set<String>> oprEntryMap = new HashMap<String, Set<String>>(16);
        HashSet<Long> oprEntryIds = new HashSet<Long>(16);
        for (DynamicObject processReport : rptBills) {
            DynamicObject transactionType = processReport.getDynamicObject("transactiontype");
            if (null == transactionType || !transactionType.getBoolean("isprecedingprocess") || processReport.getBoolean("ischargeoff")) continue;
            DynamicObjectCollection sumentrys = processReport.getDynamicObjectCollection("sumentry");
            for (DynamicObject sumentry : sumentrys) {
                if (!sumentry.getBoolean("ismilestoneprocess")) continue;
                String mfttechnicsNo = sumentry.getString("mfttechnics");
                String processseq = sumentry.getString("processseq");
                String oprno = sumentry.getString("oprno");
                String keyInfo = this.getKeyInfo(mfttechnicsNo, processseq, oprno);
                ProcessReportData md = new ProcessReportData(processReport.getLong("id"), sumentry.getLong("id"), sumentry.getBigDecimal("completbaseqty"));
                if (oprEntryMap.containsKey(mfttechnicsNo)) {
                    ((Set)oprEntryMap.get(mfttechnicsNo)).add(processseq + "#" + oprno);
                } else {
                    oprEntryMap.put(mfttechnicsNo, Sets.newHashSet((Object[])new String[]{processseq + "#" + oprno}));
                }
                if (processInfoMap.containsKey(keyInfo)) {
                    ((List)processInfoMap.get(keyInfo)).add(md);
                } else {
                    processInfoMap.put(keyInfo, Lists.newArrayList((Object[])new ProcessReportData[]{md}));
                }
                oprEntryIds.add(Long.parseLong(sumentry.getString("oprentryid")));
            }
        }
        if (!oprEntryIds.isEmpty() && (idEntryIdMap = this.queryMilestoneOpr(oprEntryIds, oprEntryMap, manufetchInfoMap = new HashMap<String, String>(16))).size() > 0) {
            long pushStart = System.currentTimeMillis();
            this.milestoneOprAutoPush(idEntryIdMap, processInfoMap, manufetchInfoMap);
            logger.info("\u91cc\u7a0b\u7891\u5de5\u5e8f\u6c47\u62a5\u4e0b\u63a8\u603b\u8017\u65f6\uff1a" + (System.currentTimeMillis() - pushStart));
        }
    }

    private String getKeyInfo(String mfttechnicsNo, String processseq, String oprno) {
        return mfttechnicsNo + processseq + "#" + oprno;
    }

    private Map<Long, Set<Long>> queryMilestoneOpr(Set<Long> oprEntryIds, Map<String, Set<String>> oprEntryMap, Map<String, String> manufetchInfoMap) {
        DynamicObject[] manftechs;
        HashMap<Long, Set<Long>> idEntryIdMap = new HashMap<Long, Set<Long>>(16);
        for (DynamicObject manftech : manftechs = BusinessDataServiceHelper.load((String)"sfc_manftech", (String)"id,billno,oprentryentity.id,oprentryentity.oprparent,oprentryentity.oprno,oprentryentity.ismilestoneprocess", (QFilter[])new QFilter[]{new QFilter("oprentryentity.id", "in", oprEntryIds)})) {
            String billno = manftech.getString("billno");
            if (!oprEntryMap.containsKey(billno)) continue;
            Set<String> entryInfos = oprEntryMap.get(billno);
            block1: for (String entryInfo : entryInfos) {
                String rptOprparent = entryInfo.split("#")[0];
                int rptOprno = Integer.parseInt(entryInfo.split("#")[1]);
                DynamicObjectCollection oprEntryCols = manftech.getDynamicObjectCollection("oprentryentity");
                Collections.sort(oprEntryCols, Comparator.comparing(o -> o.getInt("oprno")).reversed());
                for (DynamicObject oprEntry : oprEntryCols) {
                    String oprparentStr = oprEntry.getString("oprparent");
                    String oprnoStr = oprEntry.getString("oprno");
                    int oprno = Integer.parseInt(oprnoStr);
                    if (!oprparentStr.equals(rptOprparent) || oprno >= rptOprno) continue;
                    if (oprEntry.getBoolean("ismilestoneprocess")) continue block1;
                    if (idEntryIdMap.containsKey(manftech.getLong("id"))) {
                        ((Set)idEntryIdMap.get(manftech.getLong("id"))).add(oprEntry.getLong("id"));
                    } else {
                        idEntryIdMap.put(manftech.getLong("id"), Sets.newHashSet((Object[])new Long[]{oprEntry.getLong("id")}));
                    }
                    manufetchInfoMap.put(this.getKeyInfo(billno, oprparentStr, oprnoStr), this.getKeyInfo(billno, rptOprparent, entryInfo.split("#")[1]));
                }
            }
        }
        return idEntryIdMap;
    }

    private void milestoneOprAutoPush(Map<Long, Set<Long>> idEntryIdMap, Map<String, List<ProcessReportData>> processInfoMap, Map<String, String> manufetchInfoMap) {
        PushArgs pushArgs = new PushArgs();
        pushArgs.setSourceEntityNumber("sfc_manftech");
        pushArgs.setTargetEntityNumber("sfc_processreportbill");
        pushArgs.setHasRight(true);
        pushArgs.setRuleId("961510294473985024");
        pushArgs.setBuildConvReport(true);
        ArrayList<ListSelectedRow> needPushRows = new ArrayList<ListSelectedRow>(16);
        for (Map.Entry<Long, Set<Long>> entry : idEntryIdMap.entrySet()) {
            for (Long entryId : entry.getValue()) {
                ListSelectedRow srcBill = new ListSelectedRow((Object)entry.getKey());
                srcBill.setEntryEntityKey("oprentryentity");
                srcBill.setEntryPrimaryKeyValue((Object)entryId);
                needPushRows.add(srcBill);
            }
        }
        pushArgs.setSelectedRows(needPushRows);
        ConvertOperationResult pushResult = ConvertServiceHelper.push((PushArgs)pushArgs);
        StringBuilder errMessage = new StringBuilder();
        if (!pushResult.isSuccess()) {
            if (StringUtils.isNotBlank((CharSequence)pushResult.getMessage())) {
                errMessage.append(ResManager.loadKDString((String)"\u91cc\u7a0b\u7891\u5de5\u5e8f\u6c47\u62a5\u65f6\uff0c\u81ea\u52a8\u6c47\u62a5\u5355\u636e\u5173\u8054\u751f\u6210\u5931\u8d25\uff1a%s", (String)"MilestoneRptAuditAutoReportEventService_0", (String)"mmc-sfc-opplugin", (Object[])new Object[0])).append(pushResult.getMessage()).append("\n");
            }
        } else {
            MainEntityType targetMainType;
            List targetBillObjs;
            for (SourceBillReport billReport : pushResult.getBillReports()) {
                if (!StringUtils.isNotBlank((CharSequence)billReport.getFailMessage())) continue;
                errMessage.append(billReport.getBillNo()).append(billReport.getFailMessage()).append("\n");
            }
            if (errMessage.length() > 0) {
                errMessage.insert(0, ResManager.loadKDString((String)"\u91cc\u7a0b\u7891\u5de5\u5e8f\u81ea\u52a8\u6c47\u62a5\u4e0b\u63a8\u6210\u529f\u4f46\u662f\u5b58\u5728\u4e0d\u6ee1\u8db3\u6761\u4ef6\u7684\u5206\u5f55\u5df2\u8fc7\u6ee4\uff0c\u539f\u56e0:", (String)"MilestoneRptAuditAutoReportEventService_12", (String)"mmc-sfc-opplugin", (Object[])new Object[0]));
            }
            if (!(targetBillObjs = pushResult.loadTargetDataObjects(BusinessDataReader::loadRefence, targetMainType = EntityMetadataCache.getDataEntityType((String)"sfc_processreportbill"))).isEmpty()) {
                this.handleObjs(targetBillObjs, processInfoMap, manufetchInfoMap);
                OperateOption option = this.createOperateOption();
                long submitStart = System.currentTimeMillis();
                OperationResult submitResult = OperationServiceHelper.executeOperate((String)"submit", (String)"sfc_processreportbill", (DynamicObject[])targetBillObjs.toArray(new DynamicObject[0]), (OperateOption)option);
                logger.info("\u91cc\u7a0b\u7891\u5de5\u5e8f\u81ea\u52a8\u6c47\u62a5\u63d0\u4ea4\u8017\u65f6\uff1a" + (System.currentTimeMillis() - submitStart));
                if (!submitResult.isSuccess()) {
                    errMessage.append(String.format(ResManager.loadKDString((String)"\u91cc\u7a0b\u7891\u5de5\u5e8f\u6c47\u62a5\u65f6\uff0c\u81ea\u52a8\u6c47\u62a5\u5355\u636e\u63d0\u4ea4\u5931\u8d25\uff1a%s", (String)"MilestoneRptAuditAutoReportEventService_2", (String)"mmc-sfc-opplugin", (Object[])new Object[0]), this.getErrDetail(submitResult)));
                }
                if (submitResult.getSuccessPkIds().size() > 0) {
                    long auditStart = System.currentTimeMillis();
                    OperationResult auditResult = OperationServiceHelper.executeOperate((String)"audit", (String)"sfc_processreportbill", (Object[])submitResult.getSuccessPkIds().toArray(), (OperateOption)option);
                    logger.info("\u91cc\u7a0b\u7891\u5de5\u5e8f\u81ea\u52a8\u6c47\u62a5\u5ba1\u6838\u8017\u65f6\uff1a" + (System.currentTimeMillis() - auditStart));
                    if (!auditResult.isSuccess()) {
                        errMessage.append(String.format(ResManager.loadKDString((String)"\u91cc\u7a0b\u7891\u5de5\u5e8f\u6c47\u62a5\u65f6\uff0c\u81ea\u52a8\u6c47\u62a5\u5355\u636e\u5ba1\u6838\u5931\u8d25\uff1a%s", (String)"MilestoneRptAuditAutoReportEventService_3", (String)"mmc-sfc-opplugin", (Object[])new Object[0]), this.getErrDetail(auditResult)));
                    }
                }
            }
        }
        if (null != errMessage && !"null".equals(errMessage.toString()) && !"".equals(errMessage.toString())) {
            throw new KDBizException(errMessage.toString());
        }
    }

    private void handleObjs(List<DynamicObject> targetBillObjs, Map<String, List<ProcessReportData>> processInfoMap, Map<String, String> manufetchInfoMap) {
        ArrayList copyDyms = new ArrayList(16);
        ArrayList<DynamicObject> deleteDyms = new ArrayList<DynamicObject>(16);
        block2: for (DynamicObject processReport : targetBillObjs) {
            DynamicObject transactionType = processReport.getDynamicObject("transactiontype");
            if (null == transactionType || !transactionType.getBoolean("isprecedingprocess")) continue;
            DynamicObjectCollection sumentrys = processReport.getDynamicObjectCollection("sumentry");
            for (DynamicObject sumentry : sumentrys) {
                if (sumentry.getBoolean("ismilestoneprocess")) continue;
                String mfttechnicsNo = sumentry.getString("mfttechnics");
                String processseq = sumentry.getString("processseq");
                String oprno = sumentry.getString("oprno");
                String keyInfo = this.getKeyInfo(mfttechnicsNo, processseq, oprno);
                List<ProcessReportData> processReportDataSet = processInfoMap.get(manufetchInfoMap.get(keyInfo));
                String completbaseqtyStr = sumentry.getBigDecimal("completbaseqty").toString();
                String completqtyStr = sumentry.getBigDecimal("completqty").toString();
                ProcessReportData collInfo = processReportDataSet.get(0);
                BigDecimal allQty = new BigDecimal(completbaseqtyStr);
                if (allQty.compareTo(BigDecimal.ZERO) == 0) {
                    deleteDyms.add(processReport);
                    continue block2;
                }
                if (allQty.compareTo(collInfo.getBaseqty()) >= 0) {
                    this.setSumentry(sumentry, collInfo, collInfo.getBaseqty(), completbaseqtyStr, completqtyStr);
                    continue;
                }
                this.setSumentry(sumentry, collInfo, allQty, completbaseqtyStr, completqtyStr);
            }
        }
        if (!copyDyms.isEmpty()) {
            targetBillObjs.addAll(copyDyms);
        }
        if (!deleteDyms.isEmpty()) {
            targetBillObjs.removeAll(deleteDyms);
        }
        for (DynamicObject targetBillObj : targetBillObjs) {
            DynamicObjectCollection sumEntrys = targetBillObj.getDynamicObjectCollection("sumentry");
            for (DynamicObject entry : sumEntrys) {
                DynamicObjectCollection repSubentrys = entry.getDynamicObjectCollection("repsubentryentity");
                for (DynamicObject repSubentry : repSubentrys) {
                    try {
                        repSubentry.set("repactualqty", WriteRepSubentryBOTPHelper.runFormula((DynamicObject)repSubentry));
                    }
                    catch (Exception exception) {}
                }
            }
        }
    }

    private void setSumentry(DynamicObject sumentry, ProcessReportData collInfo, BigDecimal baseQtyInfo, String completbaseqtyStr, String completqtyStr) {
        sumentry.set("qualifybaseqty", (Object)baseQtyInfo);
        sumentry.set("completbaseqty", (Object)baseQtyInfo);
        DynamicObject oprunit = sumentry.getDynamicObject("oprunit");
        int precision = oprunit.getInt("precision");
        int roundType = MPDMMftGenStocksUtils.getRoundType((DynamicObject)oprunit);
        BigDecimal desQtyConv = baseQtyInfo.multiply(new BigDecimal(completqtyStr)).divide(new BigDecimal(completbaseqtyStr), precision, roundType);
        sumentry.set("qualifyqty", (Object)desQtyConv);
        sumentry.set("completqty", (Object)desQtyConv);
        sumentry.set("autosrcbilltype", (Object)"sfc_processreportbill");
        sumentry.set("processid", (Object)collInfo.getProcessId());
        sumentry.set("processentryid", (Object)collInfo.getProcessEntryId());
    }

    private String getErrDetail(OperationResult optResult) {
        StringBuilder errDetail = new StringBuilder();
        errDetail.append(optResult.getMessage()).append('\n');
        for (IOperateInfo errInfo : optResult.getAllErrorOrValidateInfo()) {
            errDetail.append(errInfo.getMessage()).append('\n');
        }
        return errDetail.toString();
    }

    private OperateOption createOperateOption() {
        OperateOption operateOption = OperateOption.create();
        operateOption.setVariableValue("ignorewarn", String.valueOf(true));
        operateOption.setVariableValue("ignoreinteraction", String.valueOf(true));
        operateOption.setVariableValue("strictvalidation", String.valueOf(false));
        operateOption.setVariableValue("ishasright", String.valueOf(true));
        operateOption.setVariableValue("ignoreValidation", String.valueOf(true));
        return operateOption;
    }
}

