/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.sfc.opplugin.processreport.validator;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bd.mpdm.common.enums.OperateEnum;
import kd.bd.mpdm.common.utils.AcctOrgCloseDateUtil;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.validate.AbstractValidator;
import kd.mmc.sfc.common.manuftech.utils.CheckManuOrderUtil;
import kd.mmc.sfc.common.utils.QueryOrderUtil;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;

public class ProcessReportValidator
extends AbstractValidator {
    public void validate() {
        String operate = this.getOption().getVariableValue("operatekey");
        HashSet<Long> oprEntryIds = new HashSet<Long>(16);
        HashSet<Long> orderEntryIds = new HashSet<Long>(16);
        HashSet<Long> morOrderEntryIds = new HashSet<Long>(16);
        for (int i = 0; i < this.dataEntities.length; ++i) {
            DynamicObject dataEntity = this.dataEntities[i].getDataEntity();
            DynamicObjectCollection sumentitys = dataEntity.getDynamicObjectCollection("sumentry");
            for (DynamicObject obj : sumentitys) {
                oprEntryIds.add(obj.getLong("oprentryid"));
                if (obj.getDynamicObject("manufactureentryid") != null) {
                    orderEntryIds.add(obj.getDynamicObject("manufactureentryid").getLong("id"));
                }
                if (obj.getDynamicObject("mroorderentryid") == null) continue;
                morOrderEntryIds.add(obj.getDynamicObject("mroorderentryid").getLong("id"));
            }
        }
        HashMap<Long, Map<String, Object>> manftechByEntryId = new HashMap(16);
        if (CollectionUtils.isNotEmpty(orderEntryIds)) {
            manftechByEntryId = QueryOrderUtil.getManftechByEntryId(oprEntryIds);
        } else if (CollectionUtils.isNotEmpty(morOrderEntryIds)) {
            manftechByEntryId = QueryOrderUtil.getMroManftechByEntryId(oprEntryIds);
        }
        HashMap<Long, Map<String, Object>> orderByEntryId = new HashMap(16);
        switch (operate) {
            case "submit": {
                for (int i = 0; i < this.dataEntities.length; ++i) {
                    this.submitCheck(i, operate, manftechByEntryId);
                }
                break;
            }
            case "audit": {
                if (CollectionUtils.isNotEmpty(orderEntryIds)) {
                    orderByEntryId = QueryOrderUtil.getOrderByEntryId(orderEntryIds);
                } else if (CollectionUtils.isNotEmpty(morOrderEntryIds)) {
                    orderByEntryId = QueryOrderUtil.getMroOrderByEntryId(morOrderEntryIds);
                }
                for (int i = 0; i < this.dataEntities.length; ++i) {
                    this.auditCheck(i, manftechByEntryId, orderByEntryId);
                }
                break;
            }
            case "unaudit": {
                for (int i = 0; i < this.dataEntities.length; ++i) {
                    this.checkAcctOrgCloseDate(i, operate);
                    this.unauditCheck(i, manftechByEntryId);
                }
                break;
            }
        }
    }

    private void auditCheck(int i, Map<Long, Map<String, Object>> manftechByEntryId, Map<Long, Map<String, Object>> orderByEntryId) {
        DynamicObject obj = this.dataEntities[i].getDataEntity();
        for (DynamicObject sumentry : obj.getDynamicObjectCollection("sumentry")) {
            List<String> error;
            String entryPkvalue = sumentry.getString("oprentryid");
            if (!org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)entryPkvalue)) continue;
            Map<String, Object> manftechEntry = manftechByEntryId.get(Long.valueOf(entryPkvalue));
            if (StringUtils.equals((CharSequence)"10070", (CharSequence)sumentry.getString("confirmoprstatus")) && MapUtils.isNotEmpty(manftechEntry)) {
                if (((BigDecimal)manftechEntry.get("oprentryentity.oprqty")).compareTo((BigDecimal)manftechEntry.get("oprentryentity.oprtotalqualifiedqty")) <= 0) {
                    error = ProcessReportValidator.checkEntryStatus("row_finish", manftechEntry, orderByEntryId);
                    for (String err : error) {
                        this.addWarningMessage(this.dataEntities[i], err);
                    }
                } else {
                    error = ProcessReportValidator.checkEntryStatus("row_start", manftechEntry, orderByEntryId);
                    for (String err : error) {
                        this.addWarningMessage(this.dataEntities[i], err);
                    }
                }
            } else if (StringUtils.equals((CharSequence)"10080", (CharSequence)sumentry.getString("confirmoprstatus")) && MapUtils.isNotEmpty(manftechEntry)) {
                error = ProcessReportValidator.checkEntryStatus("donothing_finish", manftechEntry, orderByEntryId);
                for (String err : error) {
                    this.addWarningMessage(this.dataEntities[i], err);
                }
            }
            DynamicObject mroOrderEntry = sumentry.getDynamicObject("mroorderentryid");
            DynamicObject orderEntry = sumentry.getDynamicObject("manufactureentryid");
            if (mroOrderEntry != null && !"A".equals(mroOrderEntry.getString("bizstatus"))) {
                this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u68c0\u4fee\u5de5\u5355[%1$s]\u7b2c[%2$s]\u884c\u7684\u4e1a\u52a1\u72b6\u6001\u4e0d\u4e3a\u6b63\u5e38\uff0c\u4e0d\u5141\u8bb8%3$s\u3002", (String)"ProcessReportValidator_14", (String)"mmc-sfc-opplugin", (Object[])new Object[0]), mroOrderEntry.getString("headbillno"), mroOrderEntry.get("entryseq"), OperateEnum.getValue((String)"audit")));
            }
            if (orderEntry == null) continue;
            if (!"A".equals(orderEntry.getString("bizstatus"))) {
                this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u751f\u4ea7\u5de5\u5355\u4e1a\u52a1\u72b6\u6001\u4e3a\u201c\u6b63\u5e38\u201d\uff08\u5de5\u5355\u7f16\u53f7\uff1a%1$s\uff1b\u5de5\u5355\u884c\u53f7\uff1a%2$s\uff09\uff0c\u624d\u53ef%3$s\u3002", (String)"ProcessReportValidator_10", (String)"mmc-sfc-opplugin", (Object[])new Object[0]), orderEntry.getString("headbillno"), orderEntry.get("entryseq"), OperateEnum.getValue((String)"audit")));
                continue;
            }
            if (orderEntry.getDate("startworktime") == null || manftechEntry == null || manftechEntry.get("oprentryentity.actualstarttime") == null || !((Date)manftechEntry.get("oprentryentity.actualstarttime")).before(orderEntry.getDate("startworktime"))) continue;
            this.addWarningMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\u7684\u5f00\u5de5\u65f6\u95f4\u65e9\u4e8e\u5de5\u5355\u5f00\u5de5\u65f6\u95f4\uff08\u5de5\u5e8f\u5e8f\u5217\uff1a%1$s\uff1b\u5de5\u5e8f\u53f7\uff1a%2$s\uff09\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"ProcessReportValidator_15", (String)"mmc-sfc-opplugin", (Object[])new Object[0]), manftechEntry.get("oprentryentity.oprparent"), manftechEntry.get("oprentryentity.oprno")));
        }
    }

    private void submitCheck(int i, String operate, Map<Long, Map<String, Object>> manftechByEntryId) {
        DynamicObject obj = this.dataEntities[i].getDataEntity();
        DynamicObjectCollection sumentrys = obj.getDynamicObjectCollection("sumentry");
        if (!obj.getBoolean("checkcoopation")) {
            BigDecimal sumQty;
            DynamicObjectCollection reportentrys;
            if ("qty".equals(obj.getString("staffreport"))) {
                for (DynamicObject sumentry : sumentrys) {
                    reportentrys = sumentry.getDynamicObjectCollection("childreportentity");
                    if (reportentrys == null || reportentrys.size() == 0 || (sumQty = reportentrys.stream().map(x -> x.getBigDecimal("qtyfield")).reduce(BigDecimal.ZERO, BigDecimal::add)).compareTo(sumentry.getBigDecimal("completqty")) == 0) continue;
                    this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u7b2c%d\u884c\u5206\u5f55\u7684\u201c\u6c47\u62a5\u6570\u91cf\u201d\u987b\u7b49\u4e8e\u6c47\u62a5\u4eba\u5458\u5217\u8868\u7684\u6570\u91cf\u5408\u8ba1\u3002", (String)"ProcessReportValidator_0", (String)"mmc-sfc-opplugin", (Object[])new Object[0]), sumentry.getInt("seq")));
                }
            } else if ("cooportion".equals(obj.getString("staffreport"))) {
                for (DynamicObject sumentry : sumentrys) {
                    reportentrys = sumentry.getDynamicObjectCollection("childreportentity");
                    if (reportentrys == null || reportentrys.size() == 0 || (sumQty = reportentrys.stream().map(x -> x.getBigDecimal("proportion")).reduce(BigDecimal.ZERO, BigDecimal::add)).compareTo(new BigDecimal(100)) == 0) continue;
                    this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u5206\u5f55\u7684\u6c47\u62a5\u4eba\u5458\u5217\u8868\uff0c\u201c\u6bd4\u4f8b(%2$s)\u201d\u4e4b\u548c\u5e94\u4e3a100\u3002", (String)"ProcessReportValidator_1", (String)"mmc-sfc-opplugin", (Object[])new Object[0]), sumentry.getString("seq"), "%"));
                }
            }
        }
        for (DynamicObject sumentry : sumentrys) {
            if ((sumentry.getBoolean("firstinspection") || !"1011".equals(sumentry.getString("inspectiontype"))) && sumentry.get("qualityorg") == null) {
                this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\u542f\u7528\u9996\u68c0\u6216\u8005\u68c0\u9a8c\u65b9\u5f0f\u4e0d\u4e3a\u514d\u68c0\u65f6\uff0c\u8d28\u68c0\u7ec4\u7ec7\u5fc5\u5f55\uff08\u5de5\u5e8f\u5e8f\u5217\uff1a%1$s\uff1b\u5de5\u5e8f\u53f7\uff1a%2$s\uff09\u3002", (String)"ProcessReportValidator_9", (String)"mmc-sfc-opplugin", (Object[])new Object[0]), sumentry.getString("processseq"), sumentry.getString("oprno")));
            }
            if (sumentry.getDynamicObject("mroorderentryid") != null) {
                DynamicObjectCollection collection = sumentry.getDynamicObjectCollection("childreportentity");
                BigDecimal reduce1 = collection.stream().filter(x -> "A".equals(x.getString("opactivity"))).map(x -> x.getBigDecimal("actconsumedhours")).reduce(BigDecimal.ZERO, BigDecimal::add);
                BigDecimal reduce2 = collection.stream().filter(x -> "B".equals(x.getString("opactivity"))).map(x -> x.getBigDecimal("actconsumedhours")).reduce(BigDecimal.ZERO, BigDecimal::add);
                if (sumentry.getBigDecimal("totalconsumedhours").compareTo(reduce1) != 0) {
                    this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u6c47\u62a5\u4eba\u5458\uff1a\u4e1a\u52a1\u6d3b\u52a8\u4e3a\u7ef4\u4fee\u201c\u5b9e\u9645\u6d88\u8017\u5de5\u65f6\u603b\u548c\u201d\u9700\u7b49\u4e8e\u6c47\u603b\u201d\u7ef4\u4fee\u6d88\u8017\u5de5\u65f6\u201c\u3002", (String)"ProcessReportValidator_11", (String)"mmc-sfc-opplugin", (Object[])new Object[0]), new Object[0]));
                }
                if (sumentry.getBigDecimal("totalinspectionhours").compareTo(reduce2) != 0) {
                    this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u6c47\u62a5\u4eba\u5458\uff1a\u4e1a\u52a1\u6d3b\u52a8\u4e3a\u68c0\u9a8c\u201c\u5b9e\u9645\u6d88\u8017\u5de5\u65f6\u603b\u548c\u201d\u9700\u7b49\u4e8e\u6c47\u603b\u9875\u7b7e\u201c\u68c0\u9a8c\u6d88\u8017\u5de5\u65f6\u201d\u3002", (String)"ProcessReportValidator_12", (String)"mmc-sfc-opplugin", (Object[])new Object[0]), new Object[0]));
                }
            }
            if (sumentry.getDynamicObject("manufactureentryid") == null) continue;
            DynamicObject dynamicObject = sumentry.getDynamicObject("manufactureentryid");
            Map<String, Object> map = manftechByEntryId.get(sumentry.getLong("oprentryid"));
            if (dynamicObject.getDate("startworktime") == null || map == null || map.get("oprentryentity.actualstarttime") == null || !((Date)map.get("oprentryentity.actualstarttime")).before(dynamicObject.getDate("startworktime"))) continue;
            this.addWarningMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\u7684\u5f00\u5de5\u65f6\u95f4\u65e9\u4e8e\u5de5\u5355\u5f00\u5de5\u65f6\u95f4\uff08\u5de5\u5e8f\u5e8f\u5217\uff1a%1$s\uff1b\u5de5\u5e8f\u53f7\uff1a%2$s\uff09\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"ProcessReportValidator_15", (String)"mmc-sfc-opplugin", (Object[])new Object[0]), map.get("oprentryentity.oprparent"), map.get("oprentryentity.oprno")));
        }
    }

    private void checkAcctOrgCloseDate(int i, String operate) {
        DynamicObject obj = this.dataEntities[i].getDataEntity();
        Date date = AcctOrgCloseDateUtil.getAcctOrgCloseDate((Long)obj.getDynamicObject("org").getLong("id"));
        Date reportDate = obj.getDate("bookdate");
        if (date != null && reportDate != null && date.compareTo(reportDate) >= 0) {
            String acctOrgName = AcctOrgCloseDateUtil.getAcctOrgName((Long)obj.getDynamicObject("org").getLong("id"));
            String operateKey = OperateEnum.getValue((String)operate);
            String format = ResManager.loadKDString((String)"\u5f53\u524d\u8ba1\u7b97\u540e\u8bb0\u8d26\u65e5\u671f\uff08%1$s\uff09\u5c0f\u4e8e\u7b49\u4e8e\u5b58\u8d27\u6838\u7b97\u6210\u672c\u8d26\u7c3f\u7684\u6700\u5927\u5173\u8d26\u65e5\u671f\uff08%2$s\uff09\uff0c\u4e0d\u5141\u8bb8%3$s\u3002", (String)"ProcessReportValidator_2", (String)"mmc-sfc-opplugin", (Object[])new Object[0]);
            this.addErrorMessage(this.dataEntities[i], String.format(format, reportDate, date, operateKey));
        }
    }

    public static List<String> checkEntryStatus(String operateKey, Map<String, Object> manftechEntry, Map<Long, Map<String, Object>> orderByEntryId) {
        ArrayList<String> errors = new ArrayList<String>();
        if (!"C".equals(manftechEntry.get("billstatus"))) {
            errors.add(String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\u8ba1\u5212\uff08%s\uff09\u672a\u5ba1\u6838\u3002", (String)"ProcessReportValidator_3", (String)"mmc-sfc-opplugin", (Object[])new Object[0]), manftechEntry.get("billno")));
            return errors;
        }
        Map<String, Object> orderMap = orderByEntryId.get(manftechEntry.get("mftentryseq"));
        StringBuffer error = new StringBuffer();
        if (((Boolean)manftechEntry.get("oprentryentity.oprinvalid")).booleanValue()) {
            String format = String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\u5df2\u4f5c\u5e9f\uff08\u5de5\u5e8f\u8ba1\u5212\uff1a%1$s\uff1b\u5de5\u5e8f\u5e8f\u5217\uff1a%2$s\uff1b\u5de5\u5e8f\u53f7\uff1a%3$s\uff09\u3002", (String)"ProcessReportValidator_4", (String)"mmc-sfc-opplugin", (Object[])new Object[0]), manftechEntry.get("billno"), manftechEntry.get("oprentryentity.oprparent"), manftechEntry.get("oprentryentity.oprno"));
            errors.add(format);
        }
        switch (operateKey) {
            case "row_start": {
                error = CheckManuOrderUtil.checkManuOrderEntryStatus((String)"checkBizStatus", (String)((String)manftechEntry.get("billno")), (String)ResManager.loadKDString((String)"\u6267\u884c\u81f3\u5f00\u5de5", (String)"ProcessReportValidator_5", (String)"mmc-sfc-opplugin", (Object[])new Object[0]), orderMap, (String)ResManager.loadKDString((String)"\u751f\u4ea7", (String)"ProcessReportValidator_13", (String)"mmc-sfc-opplugin", (Object[])new Object[0]));
                break;
            }
            case "row_finish": {
                error = CheckManuOrderUtil.checkManuOrderEntryStatus((String)"checkBizStatus", (String)((String)manftechEntry.get("billno")), (String)ResManager.loadKDString((String)"\u6267\u884c\u81f3\u5b8c\u5de5", (String)"ProcessReportValidator_6", (String)"mmc-sfc-opplugin", (Object[])new Object[0]), orderMap, (String)ResManager.loadKDString((String)"\u751f\u4ea7", (String)"ProcessReportValidator_13", (String)"mmc-sfc-opplugin", (Object[])new Object[0]));
                break;
            }
        }
        if (error.length() > 0) {
            errors.add(error.toString());
        }
        return errors;
    }

    private void unauditCheck(int i, Map<Long, Map<String, Object>> manftechByEntryId) {
        DynamicObject obj = this.dataEntities[i].getDataEntity();
        for (DynamicObject sumentry : obj.getDynamicObjectCollection("sumentry")) {
            BigDecimal qty;
            String entryPkvalue = sumentry.getString("oprentryid");
            if (!org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)entryPkvalue)) continue;
            Map<String, Object> manftechEntry = manftechByEntryId.get(Long.valueOf(entryPkvalue));
            if (MapUtils.isNotEmpty(manftechByEntryId) && (qty = ((BigDecimal)manftechEntry.get("oprentryentity.oprtotalreworkqty")).subtract((BigDecimal)manftechEntry.get("oprentryentity.pushreworkreportqty"))).compareTo(sumentry.getBigDecimal("checkreworkqty")) < 0) {
                this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u53cd\u5ba1\u6838\u5931\u8d25\uff0c\u7b2c%d\u884c\u5206\u5f55\u7684\u201c\u8fd4\u5de5\u6570\u91cf\u201d\u987b\u6ee1\u8db3\u5927\u4e8e\u5de5\u5e8f\u8ba1\u5212\u4e2d\u5bf9\u5e94\u5de5\u5e8f\u7684\u8fd4\u5de5\u6570\u91cf\u51cf\u4e0b\u63a8\u8fd4\u5de5\u6c47\u62a5\u6570\u91cf\u3002", (String)"ProcessReportValidator_7", (String)"mmc-sfc-opplugin", (Object[])new Object[0]), sumentry.getInt("seq")));
            }
            DynamicObject mroOrderEntry = sumentry.getDynamicObject("mroorderentryid");
            DynamicObject orderEntry = sumentry.getDynamicObject("manufactureentryid");
            if (mroOrderEntry != null && !"A".equals(mroOrderEntry.getString("bizstatus"))) {
                this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u68c0\u4fee\u5de5\u5355[%1$s]\u7b2c[%2$s]\u884c\u7684\u4e1a\u52a1\u72b6\u6001\u4e0d\u4e3a\u6b63\u5e38\uff0c\u4e0d\u5141\u8bb8%3$s\u3002", (String)"ProcessReportValidator_14", (String)"mmc-sfc-opplugin", (Object[])new Object[0]), mroOrderEntry.getString("headbillno"), mroOrderEntry.get("entryseq"), OperateEnum.getValue((String)"unaudit")));
            }
            if (orderEntry == null || "A".equals(orderEntry.getString("bizstatus"))) continue;
            this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u751f\u4ea7\u5de5\u5355\u4e1a\u52a1\u72b6\u6001\u4e3a\u201c\u6b63\u5e38\u201d\uff08\u5de5\u5355\u7f16\u53f7\uff1a%1$s\uff1b\u5de5\u5355\u884c\u53f7\uff1a%2$s\uff09\uff0c\u624d\u53ef%3$s\u3002", (String)"ProcessReportValidator_10", (String)"mmc-sfc-opplugin", (Object[])new Object[0]), orderEntry.getString("headbillno"), orderEntry.get("entryseq"), OperateEnum.getValue((String)"unaudit")));
        }
    }
}

