/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.sfc.opplugin.protransfer;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bd.mpdm.business.manuftech.OprUnitHelper;
import kd.bd.mpdm.common.consts.ProtransferBillConsts;
import kd.bd.mpdm.common.enums.ProtransferBiztypeEnum;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.botp.runtime.ConvertOperationResult;
import kd.bos.entity.botp.runtime.PushArgs;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.botp.ConvertServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.mmc.sfc.business.manuftech.PushMftManuInBillUtils;
import kd.mmc.sfc.common.manuftech.utils.CheckManuOrderUtil;
import kd.mmc.sfc.common.manuftech.utils.ManuftechUtil;
import kd.mmc.sfc.common.utils.ProtransferBillUtil;
import org.apache.commons.collections4.CollectionUtils;

public class ProtransferBillAuditOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        List fieldkeys = e.getFieldKeys();
        fieldkeys.add("bizdate");
        fieldkeys.add("outentryentity");
        fieldkeys.add("outentryentity.outprocessplan");
        fieldkeys.add("outentryentity.outprocess");
        fieldkeys.add("outentryentity.outprocessid");
        fieldkeys.add("outentryentity.biztype");
        fieldkeys.add("outentryentity.transferqty");
        fieldkeys.add("outentryentity.transferbaseqty");
        fieldkeys.add("outentryentity.outqualifybaseqty");
        fieldkeys.add("outentryentity.outreceivebaseqty");
        fieldkeys.add("outentryentity.outworkwastebaseqty");
        fieldkeys.add("outentryentity.outscrapbaseqty");
        fieldkeys.add("outentryentity.outjunkbaseqty");
        fieldkeys.add("outentryentity.outreworkbaseqty");
        fieldkeys.add("outentryentity.inspectiontype");
        fieldkeys.add("outentryentity.warehousepoint");
        fieldkeys.add("inentryentity");
        fieldkeys.add("inentryentity.inprocessplan");
        fieldkeys.add("inentryentity.inprocess");
        fieldkeys.add("inentryentity.inprocessid");
        fieldkeys.add("inentryentity.outentryentityid");
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        if ("audit".equals(e.getOperationKey())) {
            DynamicObject[] dynamicObjects;
            HashSet<Object> ids = new HashSet<Object>(16);
            HashSet<Object> orderEntryIds = new HashSet<Object>();
            HashMap<String, DynamicObject> inEntryMap = new HashMap<String, DynamicObject>(16);
            for (DynamicObject protransInfo : dynamicObjects = e.getDataEntities()) {
                Object outenrty2;
                DynamicObjectCollection outentrys = protransInfo.getDynamicObjectCollection("outentryentity");
                for (Object outenrty2 : outentrys) {
                    ids.add(outenrty2.getDynamicObject("outprocessplan").getPkValue());
                }
                DynamicObjectCollection inentrys = protransInfo.getDynamicObjectCollection("inentryentity");
                outenrty2 = inentrys.iterator();
                while (outenrty2.hasNext()) {
                    DynamicObject inentry = (DynamicObject)outenrty2.next();
                    inEntryMap.put(inentry.getString("outentryentityid"), inentry);
                }
            }
            Map manftechs = ProtransferBillUtil.getManftechs(ids);
            for (DynamicObject protransInfo : dynamicObjects) {
                DynamicObjectCollection outentrys = protransInfo.getDynamicObjectCollection("outentryentity");
                DynamicObjectCollection inentrys = protransInfo.getDynamicObjectCollection("inentryentity");
                for (int j = 0; j < outentrys.size(); ++j) {
                    DynamicObject inentry = null;
                    DynamicObject outentry = (DynamicObject)outentrys.get(j);
                    if (inentrys.size() > 0 && inEntryMap.containsKey(outentry.getString("id"))) {
                        inentry = (DynamicObject)inEntryMap.get(outentry.getString("id"));
                    }
                    this.reserveTechnics(protransInfo, (DynamicObject)manftechs.get(outentry.getDynamicObject("outprocessplan").getPkValue()), outentry, inentry, orderEntryIds);
                }
            }
            ArrayList updateTechnics = new ArrayList(manftechs.values());
            SaveServiceHelper.update((DynamicObject[])updateTechnics.toArray(new DynamicObject[0]));
            CheckManuOrderUtil.updateManuOrderEntryStatus2((String)"pom_mftorder", (String)"sfc_manftech", (String)"E", (String)"start", orderEntryIds, (DynamicObject[])updateTechnics.toArray(new DynamicObject[0]));
            this.autoPushManftech(dynamicObjects);
            this.autoPushMftManuInBill(dynamicObjects, manftechs);
        }
    }

    private void autoPushManftech(DynamicObject[] dynamicObjects) {
        HashSet<Object> inIds = new HashSet<Object>(16);
        HashSet<Object> entryInIds = new HashSet<Object>(16);
        for (DynamicObject protransInfo : dynamicObjects) {
            boolean isSequnece = false;
            DynamicObjectCollection outentrys = protransInfo.getDynamicObjectCollection("outentryentity");
            for (DynamicObject outenrty : outentrys) {
                if (!ProtransferBiztypeEnum.SEQUENCE.getValue().equals(outenrty.getString("biztype"))) continue;
                isSequnece = true;
            }
            if (!isSequnece) continue;
            DynamicObjectCollection inentrys = protransInfo.getDynamicObjectCollection("inentryentity");
            for (DynamicObject inentry : inentrys) {
                String machingType = inentry.getDynamicObject("inprocessid").getString("machiningtype");
                if (!StringUtils.equals((CharSequence)"1002", (CharSequence)machingType)) continue;
                inIds.add(inentry.getDynamicObject("inprocessplan").getPkValue());
                entryInIds.add(inentry.getDynamicObject("inprocessid").getPkValue());
            }
        }
        if (CollectionUtils.isEmpty(inIds)) {
            return;
        }
        DynamicObject[] bills = BusinessDataServiceHelper.load((Object[])inIds.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"sfc_manftech"));
        ManuftechUtil.autoPushOmApply((DynamicObject[])bills, (String)"C", (String)"oprentryentity", entryInIds);
    }

    private void reserveTechnics(DynamicObject protransInfo, DynamicObject manTechicsInfo, DynamicObject outentry, DynamicObject ininentry, Set<Object> orderEntryIds) {
        block8: {
            BigDecimal transferbaseqty;
            BigDecimal transferqty;
            String biztype;
            DynamicObjectCollection manTechEntryInfos;
            DynamicObject inprocessid;
            DynamicObject outprocessid;
            block7: {
                outprocessid = outentry.getDynamicObject("outprocessid");
                inprocessid = null;
                if (null != ininentry) {
                    inprocessid = ininentry.getDynamicObject("inprocessid");
                }
                manTechEntryInfos = manTechicsInfo.getDynamicObjectCollection("oprentryentity");
                biztype = outentry.getString("biztype");
                transferqty = outentry.getBigDecimal("transferqty");
                transferbaseqty = outentry.getBigDecimal("transferbaseqty");
                if (!biztype.equals(ProtransferBiztypeEnum.SEQUENCE.getValue())) break block7;
                for (DynamicObject techisInfo : manTechEntryInfos) {
                    if (null != inprocessid && techisInfo.getPkValue().toString().equals(inprocessid.getPkValue().toString())) {
                        Map map = OprUnitHelper.getManftechMap((DynamicObject)manTechicsInfo, (DynamicObject)techisInfo);
                        techisInfo.set("oprtotalinqty", (Object)techisInfo.getBigDecimal("oprtotalinqty").add(OprUnitHelper.getOprQty((Map)map, (BigDecimal)transferbaseqty)));
                        techisInfo.set("oprtotalinbaseqty", (Object)techisInfo.getBigDecimal("oprtotalinbaseqty").add(transferbaseqty));
                    }
                    if (!techisInfo.getPkValue().toString().equals(outprocessid.getPkValue().toString())) continue;
                    techisInfo.set("oprtotaloutqty", (Object)techisInfo.getBigDecimal("oprtotaloutqty").add(transferqty));
                    techisInfo.set("oprtotaloutbaseqty", (Object)techisInfo.getBigDecimal("oprtotaloutbaseqty").add(transferbaseqty));
                    this.changeTechnicsStatus(protransInfo, manTechicsInfo, techisInfo, orderEntryIds);
                }
                break block8;
            }
            if (!biztype.equals(ProtransferBiztypeEnum.REVERSESEQUENCE.getValue())) break block8;
            for (DynamicObject techisInfo : manTechEntryInfos) {
                Map map = OprUnitHelper.getManftechMap((DynamicObject)manTechicsInfo, (DynamicObject)techisInfo);
                if (techisInfo.getPkValue().toString().equals(outprocessid.getPkValue().toString())) {
                    if (null == inprocessid) {
                        techisInfo.set("oprtotaloutqty", (Object)techisInfo.getBigDecimal("oprtotaloutqty").subtract(transferqty));
                        techisInfo.set("oprtotaloutbaseqty", (Object)techisInfo.getBigDecimal("oprtotaloutbaseqty").subtract(transferbaseqty));
                        this.rewriteReportQty(techisInfo, outentry, map);
                    } else {
                        techisInfo.set("oprtotalinbaseqty", (Object)techisInfo.getBigDecimal("oprtotalinbaseqty").subtract(transferbaseqty));
                        techisInfo.set("oprtotalinqty", (Object)techisInfo.getBigDecimal("oprtotalinqty").subtract(transferqty));
                    }
                }
                if (null == inprocessid || !techisInfo.getPkValue().toString().equals(inprocessid.getPkValue().toString())) continue;
                techisInfo.set("oprtotaloutqty", (Object)techisInfo.getBigDecimal("oprtotaloutqty").subtract(OprUnitHelper.getOprQty((Map)map, (BigDecimal)transferbaseqty)));
                techisInfo.set("oprtotaloutbaseqty", (Object)techisInfo.getBigDecimal("oprtotaloutbaseqty").subtract(transferbaseqty));
                this.rewriteReportQty(techisInfo, outentry, map);
                this.changeTechnicsStatus(protransInfo, manTechicsInfo, techisInfo, orderEntryIds);
            }
        }
    }

    private void rewriteReportQty(DynamicObject techisInfo, DynamicObject outentry, Map<String, Object> map) {
        String transfertype = outentry.getString("transfertype");
        String inspectiontype = outentry.getString("inspectiontype");
        if (ProtransferBillConsts.OUT_REVERSE_TRANSFERTYPE.contains(transfertype) && "1011".equals(inspectiontype) && "B".equals(techisInfo.getString("reportqtysource"))) {
            if (outentry.getBigDecimal("outqualifybaseqty").compareTo(BigDecimal.ZERO) != 0) {
                techisInfo.set("oprtotalqualifiedbaseqty", (Object)techisInfo.getBigDecimal("oprtotalqualifiedbaseqty").subtract(outentry.getBigDecimal("outqualifybaseqty")));
                techisInfo.set("oprtotalqualifiedqty", (Object)techisInfo.getBigDecimal("oprtotalqualifiedqty").subtract(OprUnitHelper.getOprQty(map, (BigDecimal)outentry.getBigDecimal("outqualifybaseqty"))));
            }
            if (outentry.getBigDecimal("outreceivebaseqty").compareTo(BigDecimal.ZERO) != 0) {
                techisInfo.set("oprtotalreceivebaseqty", (Object)techisInfo.getBigDecimal("oprtotalreceivebaseqty").subtract(outentry.getBigDecimal("outreceivebaseqty")));
                techisInfo.set("oprtotalreceiveqty", (Object)techisInfo.getBigDecimal("oprtotalreceiveqty").subtract(OprUnitHelper.getOprQty(map, (BigDecimal)outentry.getBigDecimal("outreceivebaseqty"))));
            }
            if (outentry.getBigDecimal("outworkwastebaseqty").compareTo(BigDecimal.ZERO) != 0) {
                techisInfo.set("oprtotalwastebaseqty", (Object)techisInfo.getBigDecimal("oprtotalwastebaseqty").subtract(outentry.getBigDecimal("outworkwastebaseqty")));
                techisInfo.set("oprtotalwasteqty", (Object)techisInfo.getBigDecimal("oprtotalwasteqty").subtract(OprUnitHelper.getOprQty(map, (BigDecimal)outentry.getBigDecimal("outworkwastebaseqty"))));
            }
            if (outentry.getBigDecimal("outscrapbaseqty").compareTo(BigDecimal.ZERO) != 0) {
                techisInfo.set("oprtotalmaterialbaseqty", (Object)techisInfo.getBigDecimal("oprtotalmaterialbaseqty").subtract(outentry.getBigDecimal("outscrapbaseqty")));
                techisInfo.set("oprtotalmaterialqty", (Object)techisInfo.getBigDecimal("oprtotalmaterialqty").subtract(OprUnitHelper.getOprQty(map, (BigDecimal)outentry.getBigDecimal("outscrapbaseqty"))));
            }
            if (outentry.getBigDecimal("outjunkbaseqty").compareTo(BigDecimal.ZERO) != 0) {
                techisInfo.set("oprtotaljunkbaseqty", (Object)techisInfo.getBigDecimal("oprtotaljunkbaseqty").subtract(outentry.getBigDecimal("outjunkbaseqty")));
                techisInfo.set("oprtotaljunkqty", (Object)techisInfo.getBigDecimal("oprtotaljunkqty").subtract(OprUnitHelper.getOprQty(map, (BigDecimal)outentry.getBigDecimal("outjunkbaseqty"))));
            }
            if (outentry.getBigDecimal("outreworkbaseqty").compareTo(BigDecimal.ZERO) != 0) {
                techisInfo.set("oprtotalreworkbaseqty", (Object)techisInfo.getBigDecimal("oprtotalreworkbaseqty").subtract(outentry.getBigDecimal("outreworkbaseqty")));
                techisInfo.set("oprtotalreworkqty", (Object)techisInfo.getBigDecimal("oprtotalreworkqty").subtract(OprUnitHelper.getOprQty(map, (BigDecimal)outentry.getBigDecimal("outreworkbaseqty"))));
            }
        }
    }

    private void changeTechnicsStatus(DynamicObject protransInfo, DynamicObject manTechicsInfo, DynamicObject techisInfo, Set<Object> orderEntryIds) {
        if (("1002".equals(techisInfo.getString("machiningtype")) || "1003".equals(techisInfo.getString("machiningtype"))) && !"G".equals(techisInfo.getString("oprstatus"))) {
            if (techisInfo.getBigDecimal("floorqty").compareTo(techisInfo.getBigDecimal("oprtotalqualifiedqty").add(techisInfo.getBigDecimal("oprtotalreceiveqty"))) <= 0) {
                if ("D".equals(techisInfo.getString("oprstatus"))) {
                    techisInfo.set("actualstarttime", (Object)protransInfo.getDate("bizdate"));
                    techisInfo.set("actualcompletiontime", (Object)protransInfo.getDate("bizdate"));
                } else if ("E".equals(techisInfo.getString("oprstatus"))) {
                    techisInfo.set("actualcompletiontime", (Object)protransInfo.getDate("bizdate"));
                }
                techisInfo.set("oprstatus", (Object)"F");
            } else {
                if ("D".equals(techisInfo.getString("oprstatus"))) {
                    techisInfo.set("actualstarttime", (Object)protransInfo.getDate("bizdate"));
                } else if ("F".equals(techisInfo.getString("oprstatus"))) {
                    techisInfo.set("actualcompletiontime", null);
                }
                techisInfo.set("oprstatus", (Object)"E");
            }
            DynamicObject transaction = manTechicsInfo.getDynamicObject("transactiontype").getDynamicObject("transactiontype");
            DynamicObject bizType = BusinessDataServiceHelper.loadSingleFromCache((Object)transaction.getPkValue(), (String)"bd_biztype", (String)"id,number");
            Boolean isoutbill = Boolean.FALSE;
            if ("408".equals(bizType.getString("number")) && manTechicsInfo.getDynamicObject("transactiontype").getBoolean("isprocedure")) {
                isoutbill = Boolean.TRUE;
            }
            if (!isoutbill.booleanValue()) {
                orderEntryIds.add(manTechicsInfo.getDynamicObject("mftentryseq").getPkValue());
            }
        }
    }

    public void autoPushMftManuInBill(DynamicObject[] bills, Map<Object, DynamicObject> manftechs) {
        PushArgs pushArgs = PushMftManuInBillUtils.buildPushArgs((String)"sfc_protransferbill");
        ArrayList<ListSelectedRow> needPushRows = new ArrayList<ListSelectedRow>();
        for (DynamicObject dynamicObject : bills) {
            DynamicObjectCollection outEntryEntity = dynamicObject.getDynamicObjectCollection("outentryentity");
            for (DynamicObject entry : outEntryEntity) {
                DynamicObject object;
                DynamicObject transactionType;
                if (entry.getDynamicObject("outprocessplan") == null || (transactionType = (object = manftechs.get(entry.getDynamicObject("outprocessplan").getPkValue())).getDynamicObject("transactiontype")) == null || !transactionType.getBoolean("isautowarehouse") || !entry.getBoolean("warehousepoint") || !"1".equals(entry.getString("biztype")) || !ProtransferBillConsts.OUT_TRANSFERTYPE.contains(entry.getString("transfertype"))) continue;
                ListSelectedRow srcBill = new ListSelectedRow(dynamicObject.getPkValue());
                srcBill.setEntryEntityKey("outentryentity");
                srcBill.setEntryPrimaryKeyValue(entry.getPkValue());
                needPushRows.add(srcBill);
            }
        }
        if (CollectionUtils.isNotEmpty(needPushRows)) {
            pushArgs.setSelectedRows(needPushRows);
            ConvertOperationResult pushResult = ConvertServiceHelper.push((PushArgs)pushArgs);
            if (!pushResult.isSuccess()) {
                return;
            }
            PushMftManuInBillUtils.saveMftManuInBill((ConvertOperationResult)pushResult);
        }
    }
}

