/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.sfc.opplugin.protransfer;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bd.mpdm.common.consts.ProtransferBillConsts;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.mmc.sfc.opplugin.protransfer.validator.ProtransferBillAutoBackFlushAuditValidator;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;

public class ProtransferBillAutoBackFlushAuditOp
extends AbstractOperationServicePlugIn {
    private static final Log logger = LogFactory.getLog(ProtransferBillAutoBackFlushAuditOp.class);

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List fieldkeys = e.getFieldKeys();
        fieldkeys.add("bizdate");
        fieldkeys.add("outentryentity");
        fieldkeys.add("outentryentity.seq");
        fieldkeys.add("outentryentity.manufacturenun");
        fieldkeys.add("outentryentity.manufactureentryid");
        fieldkeys.add("outentryentity.outprocessid.oprparent");
        fieldkeys.add("outentryentity.outprocessid.oprno");
        fieldkeys.add("outentryentity.transfertype");
        fieldkeys.add("outentryentity.outprocessplan");
        fieldkeys.add("outentryentity.outprocess");
        fieldkeys.add("outentryentity.outprocessid");
        fieldkeys.add("outentryentity.biztype");
        fieldkeys.add("outentryentity.transferqty");
        fieldkeys.add("outentryentity.transferbaseqty");
        fieldkeys.add("outentryentity.outqualifybaseqty");
        fieldkeys.add("outentryentity.outreceivebaseqty");
        fieldkeys.add("outentryentity.outworkwastebaseqty");
        fieldkeys.add("outentryentity.outscrapbaseqty");
        fieldkeys.add("outentryentity.outjunkbaseqty");
        fieldkeys.add("outentryentity.outreworkbaseqty");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.getValidators().add(new ProtransferBillAutoBackFlushAuditValidator());
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        super.beforeExecuteOperationTransaction(e);
        String operationKey = e.getOperationKey();
        String entityName = this.billEntityType.getName();
        if (StringUtils.equals((CharSequence)"audit", (CharSequence)operationKey)) {
            ArrayList passedDataEntitys = new ArrayList(16);
            List validExtDataEntities = e.getValidExtDataEntities();
            ArrayList<ExtendedDataEntity> successDataEntitys = new ArrayList<ExtendedDataEntity>(16);
            HashMap<Object, ExtendedDataEntity> dataEntityMap = new HashMap<Object, ExtendedDataEntity>(16);
            for (ExtendedDataEntity dataEntity : e.getValidExtDataEntities()) {
                DynamicObject obj = dataEntity.getDataEntity();
                dataEntityMap.put(obj.getPkValue(), dataEntity);
            }
            Map<Long, String> res = this.autoBackFlush(entityName, e.getDataEntities(), true, true);
            for (Map.Entry<Long, String> entry : res.entrySet()) {
                Long key = entry.getKey();
                String value = entry.getValue();
                if (value.indexOf(ResManager.loadKDString((String)"\u5012\u51b2\u5931\u8d25", (String)"ProtransferBillAutoBackFlushAuditOp_1", (String)"mmc-sfc-opplugin", (Object[])new Object[0])) == -1) continue;
                passedDataEntitys.add(dataEntityMap.get(key));
                OperateErrorInfo errorInfo = new OperateErrorInfo("AutoBackFlushOp", ErrorLevel.Error, (Object)key);
                errorInfo.setMessage(StringUtils.strip((String)value, (String)"[]"));
                errorInfo.setTitle(ResManager.loadKDString((String)"\u5012\u51b2", (String)"ProtransferBillAutoBackFlushAuditOp_2", (String)"mmc-sfc-opplugin", (Object[])new Object[0]));
                this.getOperationResult().getAllErrorInfo().add(errorInfo);
            }
            validExtDataEntities.removeAll(passedDataEntitys);
            for (ExtendedDataEntity validExtDataEntitie : validExtDataEntities) {
                successDataEntitys.add(validExtDataEntitie);
            }
            if (validExtDataEntities.isEmpty()) {
                e.cancel = true;
            } else {
                e.getValidExtDataEntities().clear();
                e.getValidExtDataEntities().addAll(successDataEntitys);
            }
        }
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        super.afterExecuteOperationTransaction(e);
        String entityName = this.billEntityType.getName();
        if (StringUtils.equals((CharSequence)"audit", (CharSequence)e.getOperationKey())) {
            Map<Long, String> res = this.autoBackFlush(entityName, e.getDataEntities(), false, false);
            for (Map.Entry<Long, String> entry : res.entrySet()) {
                long key = entry.getKey();
                String value = entry.getValue();
                if ("".equals(value)) continue;
                OperateErrorInfo errorInfo = new OperateErrorInfo("AutoBackFlushOp", ErrorLevel.Error, (Object)key);
                errorInfo.setMessage(StringUtils.strip((String)value, (String)"[]"));
                errorInfo.setTitle(ResManager.loadKDString((String)"\u81ea\u52a8\u5012\u51b2", (String)"ProtransferBillAutoBackFlushAuditOp_3", (String)"mmc-sfc-opplugin", (Object[])new Object[0]));
                this.operationResult.addErrorInfo(errorInfo);
                if (res.size() <= 1) continue;
                this.operationResult.addSuccessPkId((Object)key);
            }
        }
    }

    private Map<Long, String> autoBackFlush(String entityName, DynamicObject[] dataArray, boolean bferrFlag, boolean transa) {
        ArrayList bfParam = new ArrayList(16);
        HashSet<Long> mftEntryIds = new HashSet<Long>(16);
        for (DynamicObject proBill : dataArray) {
            DynamicObject[] outEntryColl = proBill.getDynamicObjectCollection("outentryentity");
            for (DynamicObject outEntry : outEntryColl) {
                mftEntryIds.add(outEntry.getLong("manufactureentryid.id"));
            }
        }
        HashMap<Long, DynamicObject> mftOrderId_transtypeMap = new HashMap<Long, DynamicObject>(16);
        HashMap<Long, Long> mftOrderEntryId_mftOrderIdMap = new HashMap<Long, Long>(16);
        if (mftEntryIds.size() > 0) {
            DynamicObject[] mftorderDyns;
            QFilter qFilter = new QFilter("treeentryentity.id", "in", mftEntryIds);
            for (DynamicObject mftorderDyn : mftorderDyns = BusinessDataServiceHelper.load((String)"pom_mftorder", (String)"id,treeentryentity.id,transactiontype", (QFilter[])new QFilter[]{qFilter})) {
                DynamicObject transactiontype = mftorderDyn.getDynamicObject("transactiontype");
                long mftorderPk = Long.parseLong(mftorderDyn.getPkValue().toString());
                mftOrderId_transtypeMap.put(mftorderPk, transactiontype);
                DynamicObjectCollection mftorderEntrys = mftorderDyn.getDynamicObjectCollection("treeentryentity");
                for (DynamicObject mftorderEntry : mftorderEntrys) {
                    long mftOrderEntryId = Long.parseLong(mftorderEntry.getPkValue().toString());
                    mftOrderEntryId_mftOrderIdMap.put(mftOrderEntryId, mftorderPk);
                }
            }
        }
        for (DynamicObject proBill : dataArray) {
            DynamicObjectCollection outEntryColl = proBill.getDynamicObjectCollection("outentryentity");
            for (DynamicObject outEntry : outEntryColl) {
                long orderId;
                DynamicObject transactiontype;
                String bizType = outEntry.getString("biztype");
                String transferType = outEntry.getString("transfertype");
                if (!"1".equals(bizType) || !ProtransferBillConsts.OUT_TRANSFERTYPE.contains(transferType)) continue;
                long outEntryMftEntryId = outEntry.getLong("manufactureentryid.id");
                if (!MapUtils.isNotEmpty(mftOrderEntryId_mftOrderIdMap) || null == (transactiontype = (DynamicObject)mftOrderId_transtypeMap.get(orderId = ((Long)mftOrderEntryId_mftOrderIdMap.get(outEntryMftEntryId)).longValue()))) continue;
                boolean isbackflush = transactiontype.getBoolean("isbackflush");
                boolean bferr = transactiontype.getBoolean("backflusherr");
                if (!isbackflush || Boolean.compare(bferrFlag, bferr) != 0) continue;
                HashMap<String, Object> tempMap = new HashMap<String, Object>(12);
                tempMap.put("id", proBill.getPkValue());
                tempMap.put("billentity", entityName);
                tempMap.put("billno", proBill.getString("billno"));
                tempMap.put("operationkey", "audit");
                tempMap.put("bferr", bferr);
                tempMap.put("biztime", proBill.getDate("bizdate"));
                tempMap.put("ordername", "pom_mftorder");
                tempMap.put("orderentry", "treeentryentity");
                tempMap.put("stockname", "pom_mftstock");
                tempMap.put("targetname", "im_mdc_mftproorder");
                tempMap.put("botpid", "932404158450050048");
                HashMap<String, Object> innerMap = new HashMap<String, Object>(5);
                innerMap.put("entryid", outEntry.getPkValue());
                innerMap.put("seq", outEntry.getInt("seq"));
                innerMap.put("orderid", orderId);
                innerMap.put("orderentryid", outEntryMftEntryId);
                innerMap.put("baseqty", outEntry.getBigDecimal("transferbaseqty"));
                tempMap.put("processseq", outEntry.getString("outprocessid.oprparent"));
                tempMap.put("oprno", outEntry.getString("outprocessid.oprno"));
                HashMap<String, HashMap<String, Object>> billEntryMap = new HashMap<String, HashMap<String, Object>>(1);
                billEntryMap.put(outEntry.getPkValue().toString(), innerMap);
                tempMap.put("billentry", billEntryMap);
                bfParam.add(tempMap);
            }
        }
        Map<Long, String> res = new HashMap<Long, String>(16);
        if (null != bfParam && bfParam.size() > 0) {
            try {
                res = (Map)DispatchServiceHelper.invokeBizService((String)"scmc", (String)"im", (String)"MdcCheckMftorderService", (String)"batchAutoBackFlush", (Object[])new Object[]{bfParam, transa});
            }
            catch (KDBizException ex) {
                if (bferrFlag) {
                    throw new KDBizException(new ErrorCode("MdcCheckMftorderService", ex.getMessage() != null ? ex.getMessage() : ex.toString()), new Object[]{ex});
                }
                OperateErrorInfo errorInfo = new OperateErrorInfo();
                errorInfo.setLevel(ErrorLevel.Info);
                errorInfo.setMessage(ex.getMessage() != null ? ex.getMessage() : ex.toString());
                errorInfo.setTitle(ResManager.loadKDString((String)"\u81ea\u52a8\u5012\u51b2", (String)"ProtransferBillAutoBackFlushAuditOp_3", (String)"mmc-sfc-opplugin", (Object[])new Object[0]));
                this.operationResult.addErrorInfo(errorInfo);
            }
        }
        return res;
    }
}

