/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.sfc.opplugin.protransfer;

import com.alibaba.fastjson.JSONArray;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import kd.bd.mpdm.common.mftorder.utils.OrderOpUtils;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import org.apache.commons.lang.StringUtils;

public class ProtransferBillUnBackFlushOp
extends AbstractOperationServicePlugIn {
    private static Log logger = LogFactory.getLog(ProtransferBillUnBackFlushOp.class);

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        e.getFieldKeys().add("billno");
        e.getFieldKeys().add("outentryentity.manufactureentryid");
        e.getFieldKeys().add("outentryentity.manufactureentryid.id");
        e.getFieldKeys().add("outentryentity.seq");
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        String entityName = this.billEntityType.getName();
        String unBackFlushEntryPks = this.getOption().getVariableValue("unBackFlushEntryPks");
        if (StringUtils.isNotBlank((String)unBackFlushEntryPks)) {
            String selects = "id,billno,billentry.srcbillid,billentry.srcbillentryid";
            List entryPkValues = JSONArray.parseArray((String)unBackFlushEntryPks, Long.class);
            QFilter[] qfilter = new QFilter[]{new QFilter("billentry.srcbillentryid", "in", (Object)entryPkValues)};
            DynamicObject[] mftProOrders = BusinessDataServiceHelper.load((String)"im_mdc_mftproorder", (String)selects, (QFilter[])qfilter);
            if (null != mftProOrders && mftProOrders.length > 0) {
                this.delBackFlush(entityName, mftProOrders, e.getDataEntities());
            } else {
                throw new KDBizException(ResManager.loadKDString((String)"\u5f53\u524d\u6240\u9009\u6570\u636e\u884c\u90fd\u672a\u5012\u51b2\uff0c\u4e0d\u652f\u6301\u53cd\u5012\u51b2\u3002", (String)"ProtransferBillUnBackFlushOp_0", (String)"mmc-sfc-opplugin", (Object[])new Object[0]));
            }
        }
    }

    private void delBackFlush(String entityName, DynamicObject[] mftProOrders, DynamicObject[] protransferBills) {
        HashMap<Long, Long> bfParam = new HashMap<Long, Long>(16);
        for (DynamicObject mftProOrder : mftProOrders) {
            String errInfo;
            long mftOrderEntryId = 0L;
            int seq = 0;
            String billNo = "";
            long proOutEntryIdInProOrder = 0L;
            DynamicObjectCollection mftProOrderEntrys = mftProOrder.getDynamicObjectCollection("billentry");
            if (null != mftProOrderEntrys && mftProOrderEntrys.size() > 0) {
                DynamicObject mftProOrderEntry = (DynamicObject)mftProOrderEntrys.get(0);
                proOutEntryIdInProOrder = mftProOrderEntry.getLong("srcbillentryid");
                block3: for (DynamicObject protransferBill : protransferBills) {
                    DynamicObjectCollection outEntryColl = protransferBill.getDynamicObjectCollection("outentryentity");
                    for (DynamicObject outEntry : outEntryColl) {
                        long outEntryId = Long.parseLong(outEntry.getPkValue().toString());
                        if (!Long.valueOf(outEntryId).equals(proOutEntryIdInProOrder)) continue;
                        mftOrderEntryId = outEntry.getLong("manufactureentryid.id");
                        seq = outEntry.getInt("seq");
                        billNo = protransferBill.getString("billno");
                        continue block3;
                    }
                }
            }
            if (!"".equals(errInfo = this.unBackFlush(mftProOrder.getLong("id"), mftProOrder.getString("billno")))) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"%1$s\uff1a\u7b2c%2$s\u884c\u5206\u5f55\u53cd\u5012\u51b2\u5931\u8d25\uff1a%3$s", (String)"ProtransferBillUnBackFlushOp_1", (String)"mmc-sfc-opplugin", (Object[])new Object[0]), billNo, seq, errInfo));
            }
            bfParam.put(proOutEntryIdInProOrder, mftOrderEntryId);
        }
        if (bfParam.size() > 0) {
            try {
                DispatchServiceHelper.invokeBizService((String)"scmc", (String)"im", (String)"MdcCheckMftorderService", (String)"batchBackFlushClose", (Object[])new Object[]{bfParam, "D"});
            }
            catch (Exception ex) {
                throw new KDBizException(new ErrorCode("ProtransferBillUnBackFlushOp", String.format(ResManager.loadKDString((String)"\u8c03\u7528\u5e93\u5b58\u751f\u6210\u5012\u51b2\u5173\u95ed\u65b9\u6cd5\u63a5\u53e3\uff08scmc.im.MdcCheckMftorderService->batchBackFlushClose\uff09\u5931\u8d25\uff1a%1$s", (String)"ProtransferBillUnBackFlushOp_2", (String)"mmc-sfc-opplugin", (Object[])new Object[0]), ex.getMessage() != null ? ex.getMessage() : ex.toString())), new Object[]{ex});
            }
        }
    }

    private String unBackFlush(Long id, String billno) {
        String result = "";
        ArrayList<Long> mftProOrderPKList = new ArrayList<Long>();
        mftProOrderPKList.add(id);
        OperateOption auditOption = OperateOption.create();
        auditOption.setVariableValue("ignorewarn", String.valueOf(true));
        auditOption.setVariableValue("ignoreinteraction", String.valueOf(true));
        auditOption.setVariableValue("strictvalidation", String.valueOf(true));
        OperationResult unAuditResult = OperationServiceHelper.executeOperate((String)"unaudit", (String)"im_mdc_mftproorder", (Object[])mftProOrderPKList.toArray(), (OperateOption)auditOption);
        if (!unAuditResult.isSuccess()) {
            result = String.format(ResManager.loadKDString((String)"\u53cd\u5ba1\u6838\u5012\u51b2\u9886\u6599\u5355\uff08\u7f16\u53f7\uff1a%1$s\uff09\u5931\u8d25\uff1a%2$s", (String)"ProtransferBillUnBackFlushOp_3", (String)"mmc-sfc-opplugin", (Object[])new Object[0]), billno, OrderOpUtils.getErrDetail((OperationResult)unAuditResult));
        } else {
            OperationResult delResult = OperationServiceHelper.executeOperate((String)"delete", (String)"im_mdc_mftproorder", (Object[])mftProOrderPKList.toArray(), (OperateOption)OperateOption.create());
            if (delResult.getSuccessPkIds().size() < mftProOrderPKList.size()) {
                result = String.format(ResManager.loadKDString((String)"\u5220\u9664\u5012\u51b2\u9886\u6599\u5355\uff08\u7f16\u53f7\uff1a%1$s\uff09\u5931\u8d25\u3002", (String)"ProtransferBillUnBackFlushOp_4", (String)"mmc-sfc-opplugin", (Object[])new Object[0]), billno);
            }
        }
        return result;
    }
}

