/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.sfc.opplugin.protransfer.validator;

import java.math.BigDecimal;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bd.mpdm.common.enums.ProtransferBiztypeEnum;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.mmc.sfc.common.utils.ProtransferBillUtil;

public class ProtransferBillAuditValidator
extends AbstractValidator {
    public void validate() {
        HashSet<Object> ids = new HashSet<Object>(10);
        for (ExtendedDataEntity extendedDataEntity : this.getDataEntities()) {
            DynamicObject obj = extendedDataEntity.getDataEntity();
            if (!"B".equals(obj.getString("billstatus"))) continue;
            DynamicObjectCollection outEntryInfoCollection = obj.getDynamicObjectCollection("outentryentity");
            for (DynamicObject outEntryInfo : outEntryInfoCollection) {
                ids.add(outEntryInfo.getDynamicObject("outprocessplan").getPkValue());
            }
        }
        this.auditCheckManftechBill(ids);
    }

    private void auditCheckManftechBill(Set<Object> ids) {
        Map map = ProtransferBillUtil.queryManftechEntrys(ids);
        for (ExtendedDataEntity extendedDataEntity : this.getDataEntities()) {
            DynamicObject obj = extendedDataEntity.getDataEntity();
            if (!"B".equals(obj.getString("billstatus"))) continue;
            DynamicObjectCollection outEntryInfoCollection = obj.getDynamicObjectCollection("outentryentity");
            block1: for (DynamicObject outEntryInfo : outEntryInfoCollection) {
                String biztype = outEntryInfo.getString("biztype");
                BigDecimal transferqty = (BigDecimal)outEntryInfo.get("transferqty");
                List outprocessids = (List)map.get(outEntryInfo.getDynamicObject("outprocessplan").getPkValue());
                for (Map outprocess : outprocessids) {
                    BigDecimal qty;
                    String entryid = String.valueOf(outprocess.get("entryid"));
                    String qtysource = (String)outprocess.get("qtysource");
                    BigDecimal oprtotalqualifiedqty = (BigDecimal)outprocess.get("oprtotalqualifiedqty");
                    BigDecimal oprtotalreceiveqty = (BigDecimal)outprocess.get("oprtotalreceiveqty");
                    BigDecimal oprtotaloutqty = (BigDecimal)outprocess.get("oprtotaloutqty");
                    BigDecimal oprtotalinqty = (BigDecimal)outprocess.get("oprtotalinqty");
                    if (!outEntryInfo.getDynamicObject("outprocessid").getPkValue().toString().equals(entryid)) continue;
                    if (outprocess.get("machiningtype") != null && (outprocess.get("machiningtype").toString().equals("1002") || outprocess.get("machiningtype").toString().equals("1003"))) {
                        qty = oprtotalinqty.subtract(oprtotaloutqty);
                        if (ProtransferBiztypeEnum.SEQUENCE.getValue().equals(biztype) && transferqty.compareTo(qty) > 0) {
                            this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u8f6c\u79fb\u6570\u91cf\u5927\u4e8e\uff08\u5df2\u8f6c\u5165\u6570\u91cf-\u5df2\u8f6c\u51fa\u6570\u91cf\uff09\uff0c\u4e0d\u5141\u8bb8\u5ba1\u6838\u3002", (String)"ProtransferBillAuditValidator_1", (String)"mmc-sfc-opplugin", (Object[])new Object[0]));
                        }
                        if (!StringUtils.equals((CharSequence)"A", (CharSequence)qtysource) || !ProtransferBiztypeEnum.REVERSESEQUENCE.getValue().equals(biztype)) continue block1;
                        BigDecimal oprtotalinbaseqty = (BigDecimal)outprocess.get("oprtotalinbaseqty");
                        BigDecimal pushoproutorderbaseqty = (BigDecimal)outprocess.get("pushoproutorderbaseqty");
                        BigDecimal transferbaseqty = outEntryInfo.getBigDecimal("transferbaseqty");
                        if (oprtotalinbaseqty.subtract(transferbaseqty).compareTo(pushoproutorderbaseqty) >= 0) continue block1;
                        this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u6b64\u5de5\u5e8f\u5df2\u8f6c\u5165\u6570\u91cf\u5fc5\u987b\u5927\u4e8e\u7b49\u4e8e\u5de5\u5e8f\u59d4\u5916\u91c7\u8d2d\u6570\u91cf\u3002", (String)"ProtransferBillAuditValidator_2", (String)"mmc-sfc-opplugin", (Object[])new Object[0]));
                        continue block1;
                    }
                    qty = oprtotalqualifiedqty.add(oprtotalreceiveqty).subtract(oprtotaloutqty);
                    if (!ProtransferBiztypeEnum.SEQUENCE.getValue().equals(biztype) || transferqty.compareTo(qty) <= 0) continue block1;
                    this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u5ba1\u6838\u5931\u8d25\uff0c\u201c\u8f6c\u79fb\u6570\u91cf\u201d\u987b\u6ee1\u8db3\u6761\u4ef6\uff1a\u8f6c\u79fb\u6570\u91cf\u2264\u5df2\u5408\u683c\u6570\u91cf+\u5df2\u8ba9\u6b65\u63a5\u6536\u6570\u91cf-\u5df2\u8f6c\u51fa\u6570\u91cf\u3002", (String)"ProtransferBillAuditValidator_0", (String)"mmc-sfc-opplugin", (Object[])new Object[0]));
                    continue block1;
                }
            }
        }
    }
}

