/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.sfc.opplugin.protransfer.validator;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;

public class ProtransferBillAutoBackFlushAuditValidator
extends AbstractValidator {
    public void validate() {
        HashSet<String> mftBillNos = new HashSet<String>(16);
        for (ExtendedDataEntity dataEntity : this.getDataEntities()) {
            DynamicObject billDyObj = dataEntity.getDataEntity();
            DynamicObjectCollection outEntryColl = billDyObj.getDynamicObjectCollection("outentryentity");
            for (DynamicObject outEntry : outEntryColl) {
                mftBillNos.add(outEntry.getString("manufacturenun"));
            }
        }
        String algoKey = "queryPOM_mftorder";
        String selects = "billno,transactiontype.id";
        QFilter[] qf = new QFilter[]{new QFilter("billno", "in", mftBillNos)};
        HashMap mftOrderNo_transObjMap = new HashMap(16);
        HashMap<Long, String> traTypeId_billnoMap = new HashMap<Long, String>(16);
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)algoKey, (String)"pom_mftorder", (String)selects, (QFilter[])qf, null);
        Iterator iterator = null;
        try {
            while (dataSet.hasNext()) {
                Row next = dataSet.next();
                Long traTypeId = next.getLong("transactiontype.id");
                String billno = next.getString("billno");
                traTypeId_billnoMap.put(traTypeId, billno);
            }
        }
        catch (Throwable next) {
            iterator = next;
            throw next;
        }
        finally {
            if (dataSet != null) {
                if (iterator != null) {
                    try {
                        dataSet.close();
                    }
                    catch (Throwable next) {
                        ((Throwable)((Object)iterator)).addSuppressed(next);
                    }
                } else {
                    dataSet.close();
                }
            }
        }
        if (!traTypeId_billnoMap.isEmpty()) {
            Map trasObjMap = BusinessDataServiceHelper.loadFromCache((Object[])traTypeId_billnoMap.keySet().toArray(), (String)"mpdm_transactproduct");
            for (Map.Entry entry : trasObjMap.entrySet()) {
                Object key = entry.getKey();
                DynamicObject transObj = (DynamicObject)entry.getValue();
                mftOrderNo_transObjMap.put(traTypeId_billnoMap.get(Long.valueOf(key.toString())), transObj);
            }
        }
        for (ExtendedDataEntity dataEntity : this.getDataEntities()) {
            DynamicObject billDyObj = dataEntity.getDataEntity();
            DynamicObjectCollection outEntryColl = billDyObj.getDynamicObjectCollection("outentryentity");
            Boolean backflusherr = null;
            for (DynamicObject outEntry : outEntryColl) {
                String billNo = outEntry.getString("manufacturenun");
                DynamicObject transObj = (DynamicObject)mftOrderNo_transObjMap.get(billNo);
                if (transObj == null) continue;
                if (backflusherr != null && backflusherr.booleanValue() != transObj.getBoolean("backflusherr")) {
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5206\u5f55\u5bf9\u5e94\u7684\u5de5\u5355\u751f\u4ea7\u4e8b\u52a1\u7c7b\u578b\u4e2d\u201c\u5012\u51b2\u5931\u8d25\u7ec8\u6b62\u5ba1\u6838\u201d\u4e0d\u4e00\u81f4\u3002", (String)"ProtransferBillAutoBackFlushAuditValidator_0", (String)"mmc-sfc-opplugin", (Object[])new Object[0]));
                    continue;
                }
                backflusherr = transObj.getBoolean("backflusherr");
            }
        }
    }
}

