/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.sfc.opplugin.resourcesadjust;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class ResourcesAdjustAuditOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        e.getFieldKeys().add("manftechentry");
        e.getFieldKeys().add("adjustdate");
        e.getFieldKeys().add("bookdate");
        e.getFieldKeys().add("reportactentity");
        e.getFieldKeys().add("repactualqty");
        e.getFieldKeys().add("oprno");
        e.getFieldKeys().add("oprparent");
        e.getFieldKeys().add("manftechno");
        e.getFieldKeys().add("productworkshop");
        e.getFieldKeys().add("sumentry.ecostcenter");
        e.getFieldKeys().add("repsubentryentity.adjustactualqty");
        e.getFieldKeys().add("repsubentryentity.repactivity");
        e.getFieldKeys().add("repsubentryentity.represources");
        e.getFieldKeys().add("repsubentryentity.repbaseqty");
        e.getFieldKeys().add("repsubentryentity.repactualbegintime");
        e.getFieldKeys().add("repsubentryentity.repactualfinishtime");
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        String operationKey = e.getOperationKey();
        DynamicObject[] dataEntities = e.getDataEntities();
        HashSet oprEntryIds = new HashSet(16);
        ArrayList repsubentryentity = new ArrayList(10);
        for (int i = 0; i < dataEntities.length; ++i) {
            oprEntryIds.addAll(dataEntities[i].getDynamicObjectCollection("sumentry").stream().filter(x -> x.getLong("manftechentry") > 0L).map(x -> x.getLong("manftechentry")).collect(Collectors.toSet()));
            DynamicObjectCollection sumEntry = dataEntities[i].getDynamicObjectCollection("sumentry");
            for (DynamicObject object : sumEntry) {
                DynamicObjectCollection repSubEntryEntity = object.getDynamicObjectCollection("repsubentryentity");
                if (!CollectionUtils.isNotEmpty((Collection)repSubEntryEntity)) continue;
                repsubentryentity.addAll(repSubEntryEntity);
            }
        }
        Map<Long, List<DynamicObject>> reportactentity = repsubentryentity.stream().collect(Collectors.groupingBy(x -> x.getLong("reportactentity")));
        HashMap<Long, BigDecimal> data = new HashMap<Long, BigDecimal>(16);
        reportactentity.forEach((k, v) -> {
            BigDecimal bigDecimal = v.stream().map(x -> x.getBigDecimal("adjustactualqty")).reduce(BigDecimal::add).get();
            data.put((Long)k, bigDecimal);
        });
        DynamicObject[] sfcManftech = BusinessDataServiceHelper.load((String)"sfc_manftech", (String)this.selectProperties(), (QFilter[])new QFilter[]{new QFilter("oprentryentity.id", "in", oprEntryIds)});
        switch (operationKey) {
            case "audit": {
                this.writeBackReportEntity(operationKey, sfcManftech, dataEntities, data);
                break;
            }
        }
        SaveServiceHelper.save((DynamicObject[])sfcManftech);
    }

    private void writeBackReportEntity(String operationKey, DynamicObject[] sfcManftech, DynamicObject[] dataEntities, Map<Long, BigDecimal> data) {
        for (int i = 0; i < dataEntities.length; ++i) {
            DynamicObjectCollection sumEntry = dataEntities[i].getDynamicObjectCollection("sumentry");
            for (DynamicObject object : sumEntry) {
                for (int j = 0; j < sfcManftech.length; ++j) {
                    DynamicObjectCollection oprEntryEntity = sfcManftech[j].getDynamicObjectCollection("oprentryentity");
                    for (DynamicObject oprObject : oprEntryEntity) {
                        if (!Objects.equals(object.getLong("manftechentry"), oprObject.getPkValue())) continue;
                        DynamicObjectCollection repSubEntryEntity = object.getDynamicObjectCollection("repsubentryentity");
                        DynamicObjectCollection entryEntity = oprObject.getDynamicObjectCollection("repsubentryentity");
                        if (entryEntity == null || entryEntity.isEmpty()) {
                            return;
                        }
                        int seq = ((DynamicObject)entryEntity.get(entryEntity.size() - 1)).getInt("seq") + 1;
                        for (DynamicObject subEntryObject : repSubEntryEntity) {
                            for (int k = 0; k < entryEntity.size(); ++k) {
                                DynamicObject subEntry = (DynamicObject)entryEntity.get(k);
                                if (!Objects.equals(subEntryObject.getLong("reportactentity"), subEntry.getPkValue())) continue;
                                BigDecimal repActualQty = subEntryObject.getBigDecimal("repactualqty");
                                BigDecimal adjustActualQty = data.get(subEntryObject.getLong("reportactentity"));
                                if ("audit".equals(operationKey)) {
                                    subEntry.set("repactualqty", (Object)repActualQty.add(adjustActualQty));
                                    continue;
                                }
                                if (!"unaudit".equals(operationKey)) continue;
                            }
                            if (StringUtils.isBlank((CharSequence)subEntryObject.getString("reportactentity")) && "audit".equals(operationKey)) {
                                DynamicObject addNew = entryEntity.addNew();
                                addNew.set("seq", (Object)seq);
                                addNew.set("repactualqty", subEntryObject.get("adjustactualqty"));
                                addNew.set("repactivity", subEntryObject.get("repactivity"));
                                addNew.set("represources", subEntryObject.get("represources"));
                                addNew.set("repbaseqty", subEntryObject.get("repbaseqty"));
                                addNew.set("repactualbegintime", subEntryObject.get("repactualbegintime"));
                                addNew.set("repactualfinishtime", subEntryObject.get("repactualfinishtime"));
                            }
                            ++seq;
                        }
                    }
                }
            }
        }
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
    }

    private String selectProperties() {
        StringBuilder strBuilder = new StringBuilder();
        strBuilder.append("id,");
        strBuilder.append("qty").append(',');
        strBuilder.append("processroute").append(',');
        strBuilder.append("planstarttime").append(',');
        strBuilder.append("planfinishtime").append(',');
        strBuilder.append("baseqty").append(',');
        strBuilder.append("mftentryseq").append(',');
        strBuilder.append("billno").append(',');
        strBuilder.append("billstatus").append(',');
        strBuilder.append("modifytime").append(',');
        strBuilder.append("modifier").append(',');
        strBuilder.append("manufactureorderseq").append(',');
        strBuilder.append("proentryentity").append('.').append("processseqqty").append(',');
        strBuilder.append("proentryentity").append('.').append("processseq").append(',');
        strBuilder.append("proentryentity").append('.').append("processplanbegintime").append(',');
        strBuilder.append("proentryentity").append('.').append("processplanendtime").append(',');
        strBuilder.append("oprentryentity").append('.').append("oprplanbegintime").append(',');
        strBuilder.append("oprentryentity").append('.').append("oprno").append(',');
        strBuilder.append("oprentryentity").append('.').append("oprplanfinishtime").append(',');
        strBuilder.append("oprentryentity").append('.').append("headqty").append(',');
        strBuilder.append("oprentryentity").append('.').append("operationqty").append(',');
        strBuilder.append("oprentryentity").append('.').append("operationunit").append(',');
        strBuilder.append("oprentryentity").append('.').append("oprstandardqty").append(',');
        strBuilder.append("oprentryentity").append('.').append("oprqty").append(',');
        strBuilder.append("oprentryentity").append('.').append("oprproductionqty").append(',');
        strBuilder.append("oprentryentity").append('.').append("oprstatus").append(',');
        strBuilder.append("oprentryentity").append('.').append("oproperation").append(',');
        strBuilder.append("oprentryentity").append('.').append("oprtotalqualifiedqty").append(',');
        strBuilder.append("oprentryentity").append('.').append("oprparent").append(',');
        strBuilder.append("oprentryentity").append('.').append("oprinvalid").append(",");
        strBuilder.append("oprentryentity").append('.').append("repsubentryentity").append(",");
        strBuilder.append("repsubentryentity").append('.').append("repactivity").append(",");
        strBuilder.append("repsubentryentity").append('.').append("repbaseqty").append(",");
        strBuilder.append("repsubentryentity").append('.').append("repactualqty").append(",");
        strBuilder.append("repsubentryentity").append('.').append("repactualbegintime").append(",");
        strBuilder.append("repsubentryentity").append('.').append("repactualfinishtime").append(",");
        strBuilder.append("repsubentryentity").append('.').append("represources").append(",");
        strBuilder.append("repsubentryentity").append('.').append("seq");
        return strBuilder.toString();
    }
}

