/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.sfc.opplugin.xmanuftech;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bd.mpdm.common.manuftech.utils.ManuftechCreateBillUtil;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.botp.runtime.TableDefine;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.mmc.sfc.business.manuftech.SFCXManfteLogHelper;
import kd.mmc.sfc.common.manuftech.utils.ManuftechUtil;
import kd.mmc.sfc.common.utils.QueryOrderUtil;
import kd.mmc.sfc.opplugin.xmanuftech.bean.SortBean;
import kd.mmc.sfc.opplugin.xmanuftech.validator.XManuFtechDataValidator;
import kd.mmc.sfc.opplugin.xmanuftech.validator.XManuFtechDeleteValidator;
import kd.mmc.sfc.opplugin.xmanuftech.validator.XManuFtechOprNoValidator;
import org.apache.commons.collections4.CollectionUtils;

public class XManuFtechOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        kd.bd.mpdm.common.manuftech.ManuftechUtil.setEntityColumn((PreparePropertysEventArgs)e);
        e.getFieldKeys().add("reason");
        e.getFieldKeys().add("changedate");
        e.getFieldKeys().add("proentryentity.prochangetype");
        e.getFieldKeys().add("proentryentity.proentryid");
        e.getFieldKeys().add("proentryentity.promanftechid");
        e.getFieldKeys().add("oprentryentity.oprentryid");
        e.getFieldKeys().add("oprentryentity.oprorderentryid");
        e.getFieldKeys().add("oprentryentity.oprmanftechid");
        e.getFieldKeys().add("oprentryentity.oprchangetype");
        e.getFieldKeys().add("actsubentryentity.srcactsubentryid");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator((AbstractValidator)new XManuFtechDataValidator());
        e.addValidator((AbstractValidator)new XManuFtechOprNoValidator());
        e.addValidator((AbstractValidator)new XManuFtechDeleteValidator());
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        QFilter filter;
        super.beginOperationTransaction(e);
        String isFromAudit = this.getOption().getVariableValue("isFromAudit", "false");
        boolean isFromChangeService = Boolean.parseBoolean(this.getOption().getVariableValue("isFromChangeService", "false"));
        if ("true".equals(isFromAudit)) {
            return;
        }
        DynamicObject[] bills = e.getDataEntities();
        String operationKey = e.getOperationKey();
        HashSet oprEntryIds = new HashSet(16);
        HashSet<Object> oprEntry = new HashSet<Object>(16);
        HashSet proManIds = new HashSet(16);
        ArrayList addOprEntry = new ArrayList(10);
        ArrayList addProEntry = new ArrayList(10);
        for (int i = 0; i < bills.length; ++i) {
            DynamicObjectCollection oprEntryEntity = bills[i].getDynamicObjectCollection("oprentryentity");
            oprEntryIds.addAll(oprEntryEntity.stream().filter(x -> x.getDynamicObject("oprentryid") != null).map(x -> x.getDynamicObject("oprentryid").getLong("id")).collect(Collectors.toSet()));
            addOprEntry.addAll(oprEntryEntity.stream().filter(x -> "A".equals(x.getString("oprchangetype"))).collect(Collectors.toList()));
            DynamicObjectCollection proEntryEntity = bills[i].getDynamicObjectCollection("proentryentity");
            addProEntry.addAll(proEntryEntity.stream().filter(x -> "A".equals(x.getString("prochangetype"))).collect(Collectors.toList()));
            proManIds.addAll(proEntryEntity.stream().filter(x -> x.getDynamicObject("promanftechid") != null).map(x -> x.getDynamicObject("promanftechid").getLong("id")).collect(Collectors.toSet()));
        }
        DynamicObject[] manuFetch = new DynamicObject[]{};
        if (CollectionUtils.isNotEmpty(oprEntryIds)) {
            filter = new QFilter("oprentryentity.id", "in", oprEntryIds);
            manuFetch = BusinessDataServiceHelper.load((String)"sfc_manftech", (String)QueryOrderUtil.selectProperties((String)"sfc_manftech"), (QFilter[])new QFilter[]{filter});
        } else if (CollectionUtils.isNotEmpty(proManIds)) {
            filter = new QFilter("id", "in", proManIds);
            manuFetch = BusinessDataServiceHelper.load((String)"sfc_manftech", (String)QueryOrderUtil.selectProperties((String)"sfc_manftech"), (QFilter[])new QFilter[]{filter});
        }
        if ("submit".equals(operationKey) || isFromChangeService) {
            for (int i = 0; i < bills.length; ++i) {
                DynamicObjectCollection oprEntryEntity = bills[i].getDynamicObjectCollection("oprentryentity");
                DynamicObjectCollection proEntryEntity = bills[i].getDynamicObjectCollection("proentryentity");
                for (DynamicObject object : proEntryEntity) {
                    for (DynamicObject load : manuFetch) {
                        DynamicObject dynamicObject = object.getDynamicObject("promanftechid");
                        if (!Objects.equals(load.getPkValue(), dynamicObject.getPkValue())) continue;
                        Optional<DynamicObject> xmin = oprEntryEntity.stream().filter(var -> object.getString("processseq").equals(var.get("oprparent"))).collect(Collectors.toList()).stream().min(Comparator.comparing(var -> var.getInt("oprno")));
                        Optional<DynamicObject> min = load.getDynamicObjectCollection("oprentryentity").stream().filter(var -> object.getString("processseq").equals(var.get("oprparent"))).collect(Collectors.toList()).stream().min(Comparator.comparing(var -> var.getInt("oprno")));
                        if (!xmin.isPresent() || !min.isPresent()) continue;
                        int xoprNo = xmin.get().getInt("oprno");
                        int oprNo = ((DynamicObject)min.get()).getInt("oprno");
                        object.set("processseqqty", oprNo > xoprNo ? xmin.get().get("oprqty") : ((DynamicObject)min.get()).get("oprqty"));
                    }
                }
            }
        }
        if ("audit".equals(operationKey) || isFromChangeService) {
            DynamicObjectCollection oprEntryEntity;
            if (isFromChangeService) {
                SFCXManfteLogHelper.recordLog((DynamicObject[])bills);
            }
            ORM orm = ORM.create();
            int indexPro = 0;
            long[] proIds = new long[]{};
            if (CollectionUtils.isNotEmpty(addProEntry)) {
                proIds = orm.genLongIds("sfc_manftech.proentryentity", addProEntry.size());
            }
            int indexOpr = 0;
            long[] oprIds = new long[]{};
            if (CollectionUtils.isNotEmpty(addOprEntry)) {
                oprIds = orm.genLongIds("sfc_manftech.oprentryentity", addOprEntry.size());
            }
            for (int i = 0; i < bills.length; ++i) {
                DynamicObjectCollection xProEntryEntity = bills[i].getDynamicObjectCollection("proentryentity");
                for (DynamicObject xpro : xProEntryEntity) {
                    for (int j = 0; j < manuFetch.length; ++j) {
                        DynamicObjectCollection proEntryEntity = manuFetch[j].getDynamicObjectCollection("proentryentity");
                        for (DynamicObject pro : proEntryEntity) {
                            if (!"B".equals(xpro.getString("prochangetype")) || !Objects.equals(pro.getPkValue(), xpro.get("proentryid"))) continue;
                            ManuftechCreateBillUtil.setProEntryEntityValue((DynamicObject)xpro, (DynamicObject)pro);
                        }
                        if (!"A".equals(xpro.getString("prochangetype"))) continue;
                        DynamicObject pro = proEntryEntity.addNew();
                        long proId = proIds[indexPro];
                        pro.set("id", pro.getPkValue());
                        xpro.set("proentryid", (Object)proId);
                        ++indexPro;
                        ManuftechCreateBillUtil.setProEntryEntityValue((DynamicObject)xpro, (DynamicObject)pro);
                    }
                }
                DynamicObjectCollection xOprEntryEntity = bills[i].getDynamicObjectCollection("oprentryentity");
                for (DynamicObject xopr : xOprEntryEntity) {
                    for (int j = 0; j < manuFetch.length; ++j) {
                        oprEntryEntity = manuFetch[j].getDynamicObjectCollection("oprentryentity");
                        Iterator iterator = oprEntryEntity.iterator();
                        while (iterator.hasNext()) {
                            DynamicObject next = (DynamicObject)iterator.next();
                            DynamicObject dynamicObject = xopr.getDynamicObject("oprentryid");
                            if (dynamicObject == null || !Objects.equals(next.getPkValue(), dynamicObject.getPkValue())) continue;
                            if ("C".equals(xopr.getString("oprchangetype"))) {
                                iterator.remove();
                            }
                            if (!"B".equals(xopr.getString("oprchangetype"))) continue;
                            ManuftechCreateBillUtil.setOprEntryValue((DynamicObject)xopr, (DynamicObject)next);
                            String xOprSourceEntryId = xopr.getString("oprsourceentryid");
                            if (StringUtils.isNotEmpty((CharSequence)xOprSourceEntryId)) {
                                next.set("oprsourceentryid", (Object)xOprSourceEntryId);
                            }
                            if (xopr.getBoolean("storagepoint")) {
                                oprEntry.add(next.getPkValue());
                            }
                            DynamicObjectCollection collection = xopr.getDynamicObjectCollection("actsubentryentity");
                            DynamicObjectCollection dynamicObjectCollection = next.getDynamicObjectCollection("actsubentryentity");
                            dynamicObjectCollection.removeAll((Collection)dynamicObjectCollection);
                            for (DynamicObject o1 : collection) {
                                ManuftechCreateBillUtil.setActSubEntryEntityValue((DynamicObject)o1, (DynamicObject)dynamicObjectCollection.addNew());
                            }
                        }
                        if (!"A".equals(xopr.getString("oprchangetype")) || Long.compare(manuFetch[j].getLong("id"), ((DynamicObject)xProEntryEntity.get(0)).getLong("promanftechid.id")) != 0) continue;
                        DynamicObjectCollection xSubEntryCol = xopr.getDynamicObjectCollection("actsubentryentity");
                        DynamicObject opr = oprEntryEntity.addNew();
                        long oprId = oprIds[indexOpr];
                        opr.set("id", (Object)oprId);
                        xopr.set("oprentryid", (Object)opr);
                        if (xopr.getBoolean("storagepoint")) {
                            oprEntry.add(opr.getPkValue());
                        }
                        ++indexOpr;
                        ManuftechCreateBillUtil.setOprEntryValue((DynamicObject)xopr, (DynamicObject)opr);
                        if (StringUtils.isNotEmpty((CharSequence)xopr.getString("oprsourceentryid"))) {
                            opr.set("oprsourceentryid", xopr.get("oprsourceentryid"));
                            opr.set("oprsourcetype", (Object)"A");
                        }
                        for (DynamicObject object : xSubEntryCol) {
                            ManuftechCreateBillUtil.setActSubEntryEntityValue((DynamicObject)object, (DynamicObject)opr.getDynamicObjectCollection("actsubentryentity").addNew());
                        }
                    }
                }
            }
            HashSet<Long> orgIds = new HashSet<Long>(16);
            for (DynamicObject load : manuFetch) {
                if (load.getDynamicObject("org") != null) {
                    orgIds.add(load.getDynamicObject("org").getLong("id"));
                }
                load.set("changestatus", (Object)"C");
                DynamicObjectCollection proEntryEntity = load.getDynamicObjectCollection("proentryentity");
                oprEntryEntity = load.getDynamicObjectCollection("oprentryentity");
                List proCollect = proEntryEntity.stream().sorted(Comparator.comparing(x -> x.getInt("processseq"))).collect(Collectors.toList());
                for (int i = 0; i < proCollect.size(); ++i) {
                    DynamicObject object = (DynamicObject)proCollect.get(i);
                    object.set("seq", (Object)(1 + i));
                }
                for (DynamicObject object : proEntryEntity) {
                    for (DynamicObject pro : proCollect) {
                        if (!Objects.equals(object.getPkValue(), pro.getPkValue())) continue;
                        object.set("seq", pro.get("seq"));
                    }
                }
                List simpleOpr = oprEntryEntity.stream().map(x -> new SortBean(x.getLong("id"), x.getInt("oprparent"), x.getInt("oprno"))).collect(Collectors.toList());
                List<SortBean> sortOpr = simpleOpr.stream().sorted(Comparator.comparing(SortBean::getOprparent).thenComparing(SortBean::getOprno)).collect(Collectors.toList());
                for (int i = 0; i < sortOpr.size(); ++i) {
                    ((SortBean)sortOpr.get(i)).setSeq(i + 1);
                }
                for (DynamicObject object : oprEntryEntity) {
                    sortOpr.forEach(x -> {
                        if (Objects.equals(x.getId(), object.getLong("id"))) {
                            object.set("seq", (Object)x.getSeq());
                        }
                    });
                    if (oprEntry.contains(object.getPkValue()) || !object.getBoolean("storagepoint")) continue;
                    object.set("storagepoint", (Object)false);
                }
            }
            Map data = kd.bd.mpdm.common.manuftech.ManuftechUtil.getAccountingOrgIdByMftOrgId(orgIds);
            for (DynamicObject load : manuFetch) {
                if (load.getDynamicObject("org") == null) continue;
                load.set("accountingorg", data.get(load.getDynamicObject("org").getLong("id")));
            }
            SaveServiceHelper.save((DynamicObject[])manuFetch);
            for (DynamicObject load : manuFetch) {
                Object pkvalue = ((DynamicObject)load.get("mftentryseq")).getPkValue();
                if (pkvalue == null) continue;
                ManuftechUtil.updateMftStock((DynamicObject)load, (Object)pkvalue);
            }
        }
        e.setDataEntities(bills);
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        super.afterExecuteOperationTransaction(e);
        String operationKey = e.getOperationKey();
        DynamicObject[] bills = e.getDataEntities();
        boolean isFromChangeService = Boolean.parseBoolean(this.getOption().getVariableValue("isFromChangeService", "false"));
        if ("audit".equals(operationKey) || isFromChangeService) {
            TableDefine targetTableDefine = EntityMetadataCache.loadTableDefine((String)this.billEntityType.getName(), (String)"oprentryentity");
            TableDefine srcTableDefine = EntityMetadataCache.loadTableDefine((String)"sfc_manftech", (String)"oprentryentity");
            for (int i = 0; i < bills.length; ++i) {
                DynamicObjectCollection targetRows = bills[i].getDynamicObjectCollection(targetTableDefine.getEntityKey());
                for (DynamicObject targetRow : targetRows) {
                    Long srcTableId = srcTableDefine.getTableId();
                    String lkEntryKey = targetTableDefine.getEntityKey() + "_lk";
                    DynamicObjectCollection linkRows = targetRow.getDynamicObjectCollection(lkEntryKey);
                    if (!CollectionUtils.isEmpty((Collection)linkRows)) continue;
                    DynamicObject linkRow = new DynamicObject(linkRows.getDynamicObjectType());
                    linkRow.set(lkEntryKey + "_stableid", (Object)srcTableId);
                    linkRow.set(lkEntryKey + "_sbillid", targetRow.getDynamicObject("oprmanftechid").getPkValue());
                    linkRow.set(lkEntryKey + "_sid", targetRow.get("oprentryid"));
                    linkRows.add((Object)linkRow);
                }
            }
            OperateOption option = OperateOption.create();
            option.setVariableValue("isFromAudit", "true");
            SaveServiceHelper.saveOperate((String)this.billEntityType.getName(), (DynamicObject[])bills, (OperateOption)option);
        }
    }
}

