/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.sfc.opplugin.xmanuftech.validator;

import com.google.common.base.Joiner;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bd.mpdm.common.enums.OperateEnum;
import kd.bd.mpdm.common.utils.BotpUtils;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.param.AppParam;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class XManuFtechIsPushValidator
extends AbstractValidator {
    private static final String CHECKSTOCKDOWN = "checkstockdown";

    public void validate() {
        int i;
        String isFromAudit = this.getOption().getVariableValue("isFromAudit", "false");
        if ("true".equals(isFromAudit)) {
            return;
        }
        String operate = this.getOperateKey();
        HashSet oprEntryIds = new HashSet(16);
        HashSet manFetchIds = new HashSet(16);
        HashSet orderEntryIds = new HashSet(16);
        HashSet mftStockEntryIds = new HashSet(16);
        HashSet oprNums = new HashSet(16);
        HashMap<String, String> entityMap = new HashMap<String, String>(16);
        entityMap.put("sfc_processreportbill", ResManager.loadKDString((String)"\u5de5\u5e8f\u6c47\u62a5\u5355", (String)"XManuFtechIsPushValidator_0", (String)"mmc-sfc-opplugin", (Object[])new Object[0]));
        entityMap.put("pom_mftorder", ResManager.loadKDString((String)"\u53d7\u6258\u5de5\u5355", (String)"XManuFtechIsPushValidator_1", (String)"mmc-sfc-opplugin", (Object[])new Object[0]));
        entityMap.put("sfc_protransferbill", ResManager.loadKDString((String)"\u5de5\u5e8f\u8f6c\u79fb\u5355", (String)"XManuFtechIsPushValidator_2", (String)"mmc-sfc-opplugin", (Object[])new Object[0]));
        entityMap.put("pm_om_purorderbill", ResManager.loadKDString((String)"\u59d4\u5916\u8ba2\u5355", (String)"XManuFtechIsPushValidator_3", (String)"mmc-sfc-opplugin", (Object[])new Object[0]));
        entityMap.put("im_mdc_mftproorder", ResManager.loadKDString((String)"\u751f\u4ea7\u9886\u6599\u5355", (String)"XManuFtechIsPushValidator_4", (String)"mmc-sfc-opplugin", (Object[])new Object[0]));
        entityMap.put("im_mdc_mftreturnorder", ResManager.loadKDString((String)"\u751f\u4ea7\u9000\u6599\u5355", (String)"XManuFtechIsPushValidator_5", (String)"mmc-sfc-opplugin", (Object[])new Object[0]));
        entityMap.put("im_mdc_mftfeedorder", ResManager.loadKDString((String)"\u751f\u4ea7\u8865\u6599\u5355", (String)"XManuFtechIsPushValidator_6", (String)"mmc-sfc-opplugin", (Object[])new Object[0]));
        OperateOption operateOption = OperateOption.create();
        long orgId = 0L;
        for (int i2 = 0; i2 < this.dataEntities.length; ++i2) {
            DynamicObject dataEntity = this.dataEntities[i2].getDataEntity();
            DynamicObject org = dataEntity.getDynamicObject("org");
            orgId = org == null ? Long.valueOf("0") : (Long)org.getPkValue();
            DynamicObjectCollection dynamicObjectCollection = dataEntity.getDynamicObjectCollection("oprentryentity");
            oprEntryIds.addAll(dynamicObjectCollection.stream().filter(x -> x.getDynamicObject("oprentryid") != null).map(x -> x.getDynamicObject("oprentryid").getLong("id")).collect(Collectors.toSet()));
            manFetchIds.addAll(dynamicObjectCollection.stream().filter(x -> x.getDynamicObject("oprmanftechid") != null).map(x -> x.getDynamicObject("oprmanftechid").getLong("id")).collect(Collectors.toSet()));
            orderEntryIds.addAll(dynamicObjectCollection.stream().filter(x -> x.getDynamicObject("oprorderentryid") != null).map(x -> x.getDynamicObject("oprorderentryid").getLong("id")).collect(Collectors.toSet()));
            oprNums.addAll(dynamicObjectCollection.stream().map(x -> (x.getDynamicObject("oprorderentryid") != null ? Long.valueOf(x.getDynamicObject("oprorderentryid").getLong("id")) : "") + "-" + x.getString("oprparent") + "-" + x.getString("oprno")).collect(Collectors.toSet()));
        }
        DynamicObject[] load = BusinessDataServiceHelper.load((String)"pom_mftstock", (String)"id,orderentryid,stockentry.id,stockentry.processseq,stockentry.oprno", (QFilter[])new QFilter[]{new QFilter("orderentryid", "in", orderEntryIds)});
        Long[] mftStockIds = (Long[])Arrays.stream(load).map(x -> x.getLong("id")).toArray(Long[]::new);
        for (int i3 = 0; i3 < load.length; ++i3) {
            mftStockEntryIds.addAll(load[i3].getDynamicObjectCollection("stockentry").stream().map(x -> x.getLong("id")).collect(Collectors.toSet()));
        }
        Map targetBill = BotpUtils.findTargetBill((String)"sfc_manftech", (String)"oprentryentity", (Long[])manFetchIds.toArray(new Long[manFetchIds.size()]), (Long[])oprEntryIds.toArray(new Long[oprEntryIds.size()]), (OperateOption)operateOption);
        Map imTargetBill = BotpUtils.findTargetBill((String)"pom_mftstock", (String)"stockentry", (Long[])mftStockIds, (Long[])mftStockEntryIds.toArray(new Long[mftStockEntryIds.size()]), (OperateOption)operateOption);
        HashMap<String, Set> stockRs = new HashMap<String, Set>(16);
        if (this.isCheck(orgId)) {
            for (i = 0; i < load.length; ++i) {
                DynamicObjectCollection stockEntry = load[i].getDynamicObjectCollection("stockentry");
                for (DynamicObject object : stockEntry) {
                    String oprNum = load[i].getDynamicObject("orderentryid").getLong("id") + "-" + object.getString("processseq") + "-" + object.getString("oprno");
                    if (!oprNums.contains(oprNum) || !CollectionUtils.isNotEmpty((Collection)((Collection)imTargetBill.get(object.getLong("id"))))) continue;
                    Set set = stockRs.computeIfAbsent(oprNum, k -> new HashSet(16));
                    set.addAll((Collection)imTargetBill.get(object.getLong("id")));
                }
            }
        }
        for (i = 0; i < this.dataEntities.length; ++i) {
            DynamicObject dataEntity = this.dataEntities[i].getDataEntity();
            DynamicObjectCollection oprEntry = dataEntity.getDynamicObjectCollection("oprentryentity");
            for (DynamicObject dynamicObject : oprEntry) {
                String join;
                String oprNumKey;
                Set id;
                Set id2;
                HashSet entitys = new HashSet(16);
                if (dynamicObject.getDynamicObject("oprentryid") != null && CollectionUtils.isNotEmpty((Collection)(id2 = (Set)targetBill.get(dynamicObject.getDynamicObject("oprentryid").getLong("id"))))) {
                    entitys.addAll(id2);
                }
                if (dynamicObject.getDynamicObject("oprorderentryid") != null && CollectionUtils.isNotEmpty((Collection)(id = (Set)stockRs.get(oprNumKey = dynamicObject.getDynamicObject("oprorderentryid").getLong("id") + "-" + dynamicObject.getString("oprparent") + "-" + dynamicObject.getString("oprno"))))) {
                    entitys.addAll(id);
                }
                if (!CollectionUtils.isNotEmpty(entitys) || !StringUtils.isNotBlank((CharSequence)(join = Joiner.on((String)"\uff0c").skipNulls().join((Iterable)entitys.stream().map(x -> (String)entityMap.get(x)).collect(Collectors.toSet()))))) continue;
                this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\u8ba1\u5212\u53d8\u66f4\u5355%1$s\uff0c\u7b2c%2$s\u884c\u5de5\u5e8f\u5b58\u5728\u4e0b\u6e38\u5355\u636e%3$s\uff0c\u4e0d\u5141\u8bb8%4$s\u3002", (String)"XManuFtechIsPushValidator_7", (String)"mmc-sfc-opplugin", (Object[])new Object[0]), dataEntity.getString("billno"), dynamicObject.getString("seq"), join, OperateEnum.getValue((String)operate)));
            }
        }
    }

    private boolean isCheck(long orgId) {
        Object isPush;
        Map<String, Object> param = this.getParam(orgId);
        return param != null && (isPush = param.get(CHECKSTOCKDOWN)) != null && "true".equals(isPush.toString());
    }

    private Map<String, Object> getParam(long org) {
        AppParam appParam = new AppParam("0MBBHXN52LR4", Long.valueOf(org), Long.valueOf(0L));
        return SystemParamServiceHelper.loadAppParameterFromCache((AppParam)appParam);
    }
}

