/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.sfc.business.dailyplan;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.mmc.sfc.common.dailyplan.bean.DailyPlanBean;
import kd.mmc.sfc.common.dailyplan.bean.DailyPlanEntryOfOprBean;
import kd.mmc.sfc.common.dailyplan.bean.DailyPlanEntryOfPlanBean;
import kd.mmc.sfc.common.dailyplan.bean.DailyPlanSubEntryOfAllocBean;
import kd.mmc.sfc.common.dailyplan.bean.DailyPlanSubEntryOfPostTaskBean;
import kd.mmc.sfc.common.dailyplan.bean.DailyPlanSubEntryOfPreTaskBean;
import kd.mmc.sfc.common.dailyplan.bean.DailyPlanSubEntryOfRptBean;

public class DailyPlanBeanConvertHelper {
    public DailyPlanBean[] getDailyPlan(Set<QFilter> filters) {
        DynamicObject[] dataFromDB = this.getDataFromDB(filters);
        DailyPlanBean[] convertToBean = this.convertToBean(dataFromDB);
        return convertToBean;
    }

    public DynamicObject[] getDataFromDB(Set<QFilter> filters) {
        DynamicObject[] load = BusinessDataServiceHelper.load((String)"sfc_dailyplan", (String)this.buildFields(), (QFilter[])filters.toArray(new QFilter[0]), (String)"oprentryentity.defaultworksort asc");
        return load;
    }

    private String buildFields() {
        StringBuilder sb = new StringBuilder();
        sb.append("id,billno,org,billstatus,creator,taskno,taskname,taskstatus,dispatchstatus,allocationstatus,isexception,createtime,begintime,endtime,bizstatus,istaskchange,modifytime,modifier,auditor,auditdate");
        sb.append(",plantimedym,plantimedym_tag,planuserdym,planuserdym_tag,isfilltask,jobsrctype");
        sb.append(",tasktype,billtype,isimportant");
        sb.append(",");
        sb.append("srcbillid,srcbillentryid,srctype,orderno,workcard,processgroup,profession,zone,area,planarea,project,materialmtc,taskbegintime,taskendtime,status,isoprexception,oprworkhourunit,workhour,repairhours,checkhours,srctime,srcbiztype,workcardtitle,pmtstask");
        sb.append(",stage,defaultworksort,techno,mroorderentryid,completionrate,note");
        sb.append(",");
        sb.append("person,reportbegintime,reportendtime,workhourunit,actualhour,worktype");
        sb.append(",");
        sb.append("pretask,pretaskrelation,predelay");
        sb.append(",");
        sb.append("posttask,posttaskrelation,postdelay");
        sb.append(",");
        sb.append("planstarttime,planendtime,planbizstatus,timeslotproid");
        sb.append(",");
        sb.append("userincharge,rolenumber,studystatus,classgroup,userprofession");
        return sb.toString();
    }

    private DailyPlanBean[] convertToBean(DynamicObject[] datas) {
        DailyPlanBean[] beans = new DailyPlanBean[datas.length];
        for (int i = 0; i < datas.length; ++i) {
            beans[i] = this.singleConvertToBean(datas[i]);
        }
        return beans;
    }

    private DailyPlanBean singleConvertToBean(DynamicObject billData) {
        DailyPlanBean bean = new DailyPlanBean();
        bean.setPkValue(billData.getPkValue());
        bean.setBillno(billData.getString("billno"));
        bean.setOrg(billData.getDynamicObject("org"));
        bean.setBillStatus(billData.getString("billstatus"));
        bean.setCreator(billData.getDynamicObject("creator"));
        bean.setTaskNo(billData.getString("taskno"));
        bean.setTaskName(billData.getString("taskname"));
        bean.setTaskType(billData.getString("tasktype"));
        bean.setBillType(billData.getDynamicObject("billtype"));
        bean.setTaskStatus(billData.getString("taskstatus"));
        bean.setDispatchStatus(billData.getString("dispatchstatus"));
        bean.setAllocationStatus(billData.getString("allocationstatus"));
        bean.setException(billData.getBoolean("isexception"));
        bean.setCreateTime(billData.getDate("createtime"));
        bean.setBeginTime(billData.getDate("begintime"));
        bean.setEndTime(billData.getDate("endtime"));
        bean.setBizStatus(billData.getString("bizstatus"));
        bean.setTaskChange(billData.getBoolean("istaskchange"));
        bean.setModifier(billData.getDynamicObject("modifier"));
        bean.setModifytime(billData.getDate("modifytime"));
        bean.setImportant(billData.getBoolean("isimportant"));
        DynamicObjectCollection oprEntry = billData.getDynamicObjectCollection("oprentryentity");
        bean.setOprEntry(this.convertOprEntry(oprEntry));
        DynamicObjectCollection planEntry = billData.getDynamicObjectCollection("planentryentity");
        bean.setPlanEntry(this.convertPlanEntry(planEntry));
        return bean;
    }

    public DailyPlanBean updateDailyPlanBeanByForm(DailyPlanBean bean, DynamicObject formData) {
        bean.setTaskName(formData.getString("taskname"));
        bean.setAllocationStatus(formData.getString("allocationstatus"));
        return bean;
    }

    private DailyPlanEntryOfOprBean[] convertOprEntry(DynamicObjectCollection oprEntry) {
        DailyPlanEntryOfOprBean[] entryBean = new DailyPlanEntryOfOprBean[oprEntry.size()];
        for (int i = 0; i < oprEntry.size(); ++i) {
            DynamicObject entryRow = (DynamicObject)oprEntry.get(i);
            entryBean[i] = this.singleConvertOprEntry(entryRow);
        }
        return entryBean;
    }

    private DailyPlanEntryOfOprBean singleConvertOprEntry(DynamicObject oprEntryRow) {
        DailyPlanEntryOfOprBean bean = new DailyPlanEntryOfOprBean();
        bean.setPkValue(oprEntryRow.getPkValue());
        bean.setSrcBillID(oprEntryRow.getLong("srcbillid"));
        bean.setSrcBillEntryID(oprEntryRow.getLong("srcbillentryid"));
        bean.setSrcType(oprEntryRow.getString("srctype"));
        bean.setOrderNo(oprEntryRow.getString("orderno"));
        bean.setWorkCard(oprEntryRow.getDynamicObject("workcard"));
        bean.setProcessGroup(oprEntryRow.getDynamicObject("processgroup"));
        bean.setProfession(oprEntryRow.getDynamicObject("profession"));
        bean.setZone(oprEntryRow.getDynamicObject("zone"));
        bean.setArea(oprEntryRow.getDynamicObject("area"));
        bean.setPlanArea(oprEntryRow.getDynamicObject("planarea"));
        bean.setProject(oprEntryRow.getDynamicObject("project"));
        bean.setMaterialMTC(oprEntryRow.getDynamicObject("materialmtc"));
        bean.setTaskBeginTime(oprEntryRow.getDate("taskbegintime"));
        bean.setTaskEndTime(oprEntryRow.getDate("taskendtime"));
        bean.setStatus(oprEntryRow.getString("status"));
        bean.setOprException(oprEntryRow.getBoolean("isoprexception"));
        bean.setOprWorkHourUnit(oprEntryRow.getDynamicObject("oprworkhourunit"));
        bean.setWorkHour(oprEntryRow.getBigDecimal("workhour"));
        bean.setRepairHours(oprEntryRow.getBigDecimal("repairhours"));
        bean.setCheckHours(oprEntryRow.getBigDecimal("checkhours"));
        bean.setSrcTime(oprEntryRow.getDate("srctime"));
        bean.setSrcBizType(oprEntryRow.getDynamicObject("srcbiztype"));
        bean.setWorkCardTitle(oprEntryRow.getString("workcardtitle"));
        bean.setPmtsTask(oprEntryRow.getDynamicObject("pmtstask"));
        bean.setMroOrderEntryID(oprEntryRow.getDynamicObject("mroorderentryid"));
        bean.setTechNo(oprEntryRow.getString("techno"));
        bean.setDefaultWorkSort(oprEntryRow.getLong("defaultworksort"));
        bean.setStage(oprEntryRow.getDynamicObject("stage"));
        bean.setCompletionRate(oprEntryRow.getBigDecimal("completionrate"));
        bean.setNote(oprEntryRow.getString("note"));
        DynamicObjectCollection subRptEntry = oprEntryRow.getDynamicObjectCollection("repsubentryentity");
        bean.setSubEntryRpt(this.convertRptSubEntry(subRptEntry));
        DynamicObjectCollection subPreTaskEntry = oprEntryRow.getDynamicObjectCollection("prepositiontaskentry");
        bean.setSubEntryPreTask(this.convertPreTaskEntry(subPreTaskEntry));
        DynamicObjectCollection subPostTaskEntry = oprEntryRow.getDynamicObjectCollection("postpositiontaskentry");
        bean.setSubEntryPostTask(this.convertPostTaskEntry(subPostTaskEntry));
        return bean;
    }

    private DailyPlanSubEntryOfPreTaskBean[] convertPreTaskEntry(DynamicObjectCollection subPreTaskEntry) {
        DailyPlanSubEntryOfPreTaskBean[] preTaskBeans = new DailyPlanSubEntryOfPreTaskBean[subPreTaskEntry.size()];
        for (int i = 0; i < subPreTaskEntry.size(); ++i) {
            preTaskBeans[i] = this.singleConvertPreTaskEntry((DynamicObject)subPreTaskEntry.get(i));
        }
        return preTaskBeans;
    }

    private DailyPlanSubEntryOfPreTaskBean singleConvertPreTaskEntry(DynamicObject subPreTaskEntryRow) {
        DailyPlanSubEntryOfPreTaskBean bean = new DailyPlanSubEntryOfPreTaskBean();
        bean.setPkValue(subPreTaskEntryRow.getPkValue());
        bean.setPreTask(subPreTaskEntryRow.getDynamicObject("pretask"));
        bean.setPreTaskRelation(subPreTaskEntryRow.getString("pretaskrelation"));
        bean.setPreDelay(subPreTaskEntryRow.getBigDecimal("predelay"));
        return bean;
    }

    private DailyPlanSubEntryOfPostTaskBean[] convertPostTaskEntry(DynamicObjectCollection subPostTaskEntry) {
        DailyPlanSubEntryOfPostTaskBean[] postTaskBeans = new DailyPlanSubEntryOfPostTaskBean[subPostTaskEntry.size()];
        for (int i = 0; i < subPostTaskEntry.size(); ++i) {
            postTaskBeans[i] = this.singleConvertPostTaskEntry((DynamicObject)subPostTaskEntry.get(i));
        }
        return postTaskBeans;
    }

    private DailyPlanSubEntryOfPostTaskBean singleConvertPostTaskEntry(DynamicObject subPostTaskEntryRow) {
        DailyPlanSubEntryOfPostTaskBean bean = new DailyPlanSubEntryOfPostTaskBean();
        bean.setPkValue(subPostTaskEntryRow.getPkValue());
        bean.setPostTask(subPostTaskEntryRow.getDynamicObject("posttask"));
        bean.setPostTaskRelation(subPostTaskEntryRow.getString("posttaskrelation"));
        bean.setPostDelay(subPostTaskEntryRow.getBigDecimal("postdelay"));
        return bean;
    }

    private DailyPlanSubEntryOfRptBean[] convertRptSubEntry(DynamicObjectCollection subRptEntry) {
        DailyPlanSubEntryOfRptBean[] subBean = new DailyPlanSubEntryOfRptBean[subRptEntry.size()];
        for (int i = 0; i < subRptEntry.size(); ++i) {
            DynamicObject subRptRow = (DynamicObject)subRptEntry.get(i);
            subBean[i] = this.singleConvertRptSubEntry(subRptRow);
        }
        return subBean;
    }

    private DailyPlanSubEntryOfRptBean singleConvertRptSubEntry(DynamicObject subRptEntryRow) {
        DailyPlanSubEntryOfRptBean bean = new DailyPlanSubEntryOfRptBean();
        bean.setPkValue(subRptEntryRow.getPkValue());
        bean.setPerson(subRptEntryRow.getDynamicObject("person"));
        bean.setReportBeginTime(subRptEntryRow.getDate("reportbegintime"));
        bean.setReportEndTime(subRptEntryRow.getDate("reportendtime"));
        bean.setWorkHourUnit(subRptEntryRow.getDynamicObject("workhourunit"));
        bean.setActualHour(subRptEntryRow.getBigDecimal("actualhour"));
        bean.setWorkType(subRptEntryRow.getString("worktype"));
        return bean;
    }

    private DailyPlanEntryOfPlanBean[] convertPlanEntry(DynamicObjectCollection planEntry) {
        DailyPlanEntryOfPlanBean[] beans = new DailyPlanEntryOfPlanBean[planEntry.size()];
        for (int i = 0; i < planEntry.size(); ++i) {
            beans[i] = this.singleConvertPlanEntry((DynamicObject)planEntry.get(i));
        }
        return beans;
    }

    private DailyPlanEntryOfPlanBean singleConvertPlanEntry(DynamicObject planEntryRow) {
        DailyPlanEntryOfPlanBean bean = new DailyPlanEntryOfPlanBean();
        bean.setPkValue(planEntryRow.getPkValue());
        bean.setPlanStartTime(planEntryRow.getDate("planstarttime"));
        bean.setPlanEndTime(planEntryRow.getDate("planendtime"));
        bean.setPlanBizStatus(planEntryRow.getString("planbizstatus"));
        bean.setTimeSlotId(Long.valueOf(planEntryRow.getLong("timeslotproid")));
        DynamicObjectCollection allocSubEntry = planEntryRow.getDynamicObjectCollection("allocsubentryentity");
        bean.setSubEntryAllocation(this.convertAllocSubEntry(allocSubEntry));
        return bean;
    }

    private DailyPlanSubEntryOfAllocBean[] convertAllocSubEntry(DynamicObjectCollection allocSubEntry) {
        DailyPlanSubEntryOfAllocBean[] beans = new DailyPlanSubEntryOfAllocBean[allocSubEntry.size()];
        for (int i = 0; i < allocSubEntry.size(); ++i) {
            beans[i] = this.singleConvertAllocSubEntry((DynamicObject)allocSubEntry.get(i));
        }
        return beans;
    }

    private DailyPlanSubEntryOfAllocBean singleConvertAllocSubEntry(DynamicObject allocSubEntryRow) {
        DailyPlanSubEntryOfAllocBean bean = new DailyPlanSubEntryOfAllocBean();
        bean.setPkValue(allocSubEntryRow.getPkValue());
        bean.setUserIncharge(allocSubEntryRow.getDynamicObject("userincharge"));
        bean.setRoleNumber(allocSubEntryRow.getDynamicObject("rolenumber"));
        bean.setStudyStatus(allocSubEntryRow.getString("studystatus"));
        bean.setClassGroup(allocSubEntryRow.getDynamicObject("classgroup"));
        bean.setUserProfession(allocSubEntryRow.getDynamicObject("userprofession"));
        return bean;
    }

    public DynamicObject[] updateDynamicObjectByBean(DailyPlanBean[] beans) {
        ArrayList<DynamicObject> dyList = new ArrayList<DynamicObject>(8);
        HashSet<Object> ids = new HashSet<Object>(8);
        for (int i = 0; i < beans.length; ++i) {
            DailyPlanBean dailyPlanBean = beans[i];
            Object pkValue = dailyPlanBean.getPkValue();
            ids.add(pkValue);
        }
        HashSet<QFilter> filters = new HashSet<QFilter>(8);
        filters.add(new QFilter("id", "in", ids));
        DynamicObject[] dys = this.getDataFromDB(filters);
        HashMap<Object, DynamicObject> mapDailyPlan = new HashMap<Object, DynamicObject>(8);
        for (DynamicObject bill : dys) {
            mapDailyPlan.put(bill.getPkValue(), bill);
        }
        for (int i = 0; i < beans.length; ++i) {
            DailyPlanBean dailyBean = beans[i];
            DynamicObject headDy = (DynamicObject)mapDailyPlan.get(dailyBean.getPkValue());
            if (headDy == null) {
                headDy = BusinessDataServiceHelper.newDynamicObject((String)"sfc_dailyplan");
            }
            this.convertBeanToDynamicObject(headDy, dailyBean);
            dyList.add(headDy);
        }
        return dyList.toArray(new DynamicObject[0]);
    }

    private void convertBeanToDynamicObject(DynamicObject headDy, DailyPlanBean bean) {
        DailyPlanEntryOfOprBean[] oprEntryBeans = bean.getOprEntry();
        DynamicObjectCollection oprEntryDy = headDy.getDynamicObjectCollection("oprentryentity");
        oprEntryDy = this.convertOprEntryBeans(oprEntryDy, oprEntryBeans);
        this.updateHeadDynamicObject(headDy, bean);
    }

    private void updateHeadDynamicObject(DynamicObject headDy, DailyPlanBean bean) {
        headDy.set("billno", (Object)bean.getBillno());
        headDy.set("org", (Object)bean.getOrg());
        headDy.set("billstatus", (Object)bean.getBillStatus());
        headDy.set("creator", (Object)bean.getCreator());
        headDy.set("taskno", (Object)bean.getTaskNo());
        headDy.set("taskname", (Object)bean.getTaskName());
        headDy.set("taskstatus", (Object)bean.getTaskStatus());
        headDy.set("dispatchstatus", (Object)bean.getDispatchStatus());
        headDy.set("allocationstatus", (Object)bean.getAllocationStatus());
        headDy.set("isexception", (Object)bean.isException());
        headDy.set("createtime", (Object)bean.getCreateTime());
        headDy.set("begintime", (Object)bean.getBeginTime());
        headDy.set("endtime", (Object)bean.getEndTime());
        headDy.set("bizstatus", (Object)bean.getBizStatus());
        headDy.set("istaskchange", (Object)bean.isTaskChange());
        headDy.set("modifier", (Object)bean.getModifier());
        headDy.set("modifytime", (Object)bean.getModifytime());
        headDy.set("plantimedym", (Object)bean.getPlanTimedym());
        headDy.set("plantimedym_tag", (Object)bean.getPlanTimedym_tag());
        headDy.set("planuserdym", (Object)bean.getPlanUserdym());
        headDy.set("planuserdym_tag", (Object)bean.getPlanUserdym_tag());
        headDy.set("billtype", (Object)bean.getBillType());
    }

    private DynamicObjectCollection convertOprEntryBeans(DynamicObjectCollection oprEntryDy, DailyPlanEntryOfOprBean[] oprEntryBeans) {
        DynamicObjectCollection oprEntryDyNew = (DynamicObjectCollection)oprEntryDy.clone();
        oprEntryDyNew.clear();
        for (DynamicObject oprEntryRow : oprEntryDy) {
            Long oprEntryRowPk = (Long)oprEntryRow.getPkValue();
            for (DailyPlanEntryOfOprBean dailyPlanEntryOfOprBean : oprEntryBeans) {
                Long beanPk = (Long)dailyPlanEntryOfOprBean.getPkValue();
                if (!oprEntryRowPk.equals(beanPk)) continue;
                this.updateOprEntryDynamicObject(oprEntryRow, dailyPlanEntryOfOprBean);
                oprEntryDyNew.add((Object)oprEntryRow);
            }
        }
        for (int i = 0; i < oprEntryBeans.length; ++i) {
            int dataIndex = this.findDataIndexByPk(oprEntryDy, oprEntryBeans[i].getPkValue());
            if (dataIndex >= 0) continue;
            DynamicObject row = oprEntryDy.addNew();
            this.updateOprEntryDynamicObject(row, oprEntryBeans[i]);
            oprEntryDyNew.add((Object)row);
        }
        return oprEntryDyNew;
    }

    private void updateOprEntryDynamicObject(DynamicObject oprRow, DailyPlanEntryOfOprBean bean) {
        DailyPlanSubEntryOfPostTaskBean[] subEntryPostBeans;
        DailyPlanSubEntryOfPreTaskBean[] subEntryPreBeans;
        oprRow.set("srcbillid", (Object)bean.getSrcBillID());
        oprRow.set("srcbillentryid", (Object)bean.getSrcBillEntryID());
        oprRow.set("srctype", (Object)bean.getSrcType());
        oprRow.set("orderno", (Object)bean.getOrderNo());
        oprRow.set("workcard", (Object)bean.getWorkCard());
        oprRow.set("workcardtitle", (Object)bean.getWorkCardTitle());
        oprRow.set("processgroup", (Object)bean.getProcessGroup());
        oprRow.set("profession", (Object)bean.getProfession());
        oprRow.set("zone", (Object)bean.getZone());
        oprRow.set("area", (Object)bean.getArea());
        oprRow.set("planarea", (Object)bean.getPlanArea());
        oprRow.set("project", (Object)bean.getProject());
        oprRow.set("materialmtc", (Object)bean.getMaterialMTC());
        oprRow.set("taskbegintime", (Object)bean.getTaskBeginTime());
        oprRow.set("taskendtime", (Object)bean.getTaskEndTime());
        oprRow.set("status", (Object)bean.getStatus());
        oprRow.set("isoprexception", (Object)bean.isOprException());
        oprRow.set("oprworkhourunit", (Object)bean.getOprWorkHourUnit());
        oprRow.set("workhour", (Object)bean.getWorkHour());
        oprRow.set("repairhours", (Object)bean.getRepairHours());
        oprRow.set("checkhours", (Object)bean.getCheckHours());
        oprRow.set("srctime", (Object)bean.getSrcTime());
        oprRow.set("srcbiztype", (Object)bean.getSrcBizType());
        oprRow.set("pmtstask", (Object)bean.getPmtsTask());
        oprRow.set("mroorderentryid", (Object)bean.getMroOrderEntryID());
        oprRow.set("techno", (Object)bean.getTechNo());
        oprRow.set("defaultworksort", (Object)bean.getDefaultWorkSort());
        oprRow.set("stage", (Object)bean.getStage());
        oprRow.set("completionrate", (Object)bean.getCompletionRate());
        oprRow.set("note", (Object)bean.getNote());
        DailyPlanSubEntryOfRptBean[] subEntryRptBeans = bean.getSubEntryRpt();
        if (subEntryRptBeans != null) {
            DynamicObjectCollection subRptEntryDy = oprRow.getDynamicObjectCollection("repsubentryentity");
            for (int i = 0; i < subEntryRptBeans.length; ++i) {
                DynamicObject row;
                int dataIndex = this.findDataIndexByPk(subRptEntryDy, subEntryRptBeans[i].getPkValue());
                if (dataIndex >= 0) {
                    row = (DynamicObject)subRptEntryDy.get(dataIndex);
                    this.updateSubRptEntryDynamicObject(row, subEntryRptBeans[i]);
                    continue;
                }
                row = subRptEntryDy.addNew();
                this.updateSubRptEntryDynamicObject(row, subEntryRptBeans[i]);
            }
        }
        if ((subEntryPreBeans = bean.getSubEntryPreTask()) != null) {
            DynamicObjectCollection subPreEntryDy = oprRow.getDynamicObjectCollection("prepositiontaskentry");
            for (int i = 0; i < subEntryPreBeans.length; ++i) {
                DynamicObject row;
                int dataIndex = this.findDataIndexByPk(subPreEntryDy, subEntryPreBeans[i].getPkValue());
                if (dataIndex >= 0) {
                    row = (DynamicObject)subPreEntryDy.get(dataIndex);
                    this.updateSubPreEntryDynamicObject(row, subEntryPreBeans[i]);
                    continue;
                }
                row = subPreEntryDy.addNew();
                this.updateSubPreEntryDynamicObject(row, subEntryPreBeans[i]);
            }
        }
        if ((subEntryPostBeans = bean.getSubEntryPostTask()) != null) {
            DynamicObjectCollection subPostEntryDy = oprRow.getDynamicObjectCollection("postpositiontaskentry");
            for (int i = 0; i < subEntryPostBeans.length; ++i) {
                DynamicObject row;
                int dataIndex = this.findDataIndexByPk(subPostEntryDy, subEntryPostBeans[i].getPkValue());
                if (dataIndex >= 0) {
                    row = (DynamicObject)subPostEntryDy.get(dataIndex);
                    this.updateSubPostEntryDynamicObject(row, subEntryPostBeans[i]);
                    continue;
                }
                row = subPostEntryDy.addNew();
                this.updateSubPostEntryDynamicObject(row, subEntryPostBeans[i]);
            }
        }
    }

    private void updateSubRptEntryDynamicObject(DynamicObject rptRow, DailyPlanSubEntryOfRptBean bean) {
        rptRow.set("person", (Object)bean.getPerson());
        rptRow.set("reportbegintime", (Object)bean.getReportBeginTime());
        rptRow.set("reportendtime", (Object)bean.getReportEndTime());
        rptRow.set("workhourunit", (Object)bean.getWorkHourUnit());
        rptRow.set("actualhour", (Object)bean.getActualHour());
        rptRow.set("worktype", (Object)bean.getWorkType());
    }

    private void updateSubPreEntryDynamicObject(DynamicObject preRow, DailyPlanSubEntryOfPreTaskBean bean) {
        preRow.set("pretask", (Object)bean.getPreTask());
        preRow.set("pretaskrelation", (Object)bean.getPreTaskRelation());
        preRow.set("predelay", (Object)bean.getPreDelay());
    }

    private void updateSubPostEntryDynamicObject(DynamicObject postRow, DailyPlanSubEntryOfPostTaskBean bean) {
        postRow.set("posttask", (Object)bean.getPostTask());
        postRow.set("posttaskrelation", (Object)bean.getPostTaskRelation());
        postRow.set("postdelay", (Object)bean.getPostDelay());
    }

    private int findDataIndexByPk(DynamicObjectCollection collection, Object pkValue) {
        int index = -1;
        for (int i = 0; i < collection.size(); ++i) {
            DynamicObject data = (DynamicObject)collection.get(i);
            Object dataPk = data.getPkValue();
            if (!dataPk.equals(pkValue)) continue;
            index = i;
            break;
        }
        return index;
    }

    public DailyPlanBean copyNewBean(DailyPlanBean originBean) {
        DailyPlanBean newBean = new DailyPlanBean();
        Long splitNo = this.getSplitBillNo(originBean.getBillno());
        newBean.setBillno(String.format("%1$s-%2$s", originBean.getBillno(), splitNo));
        newBean.setOrg(originBean.getOrg());
        newBean.setBillStatus(originBean.getBillStatus());
        newBean.setCreator(originBean.getCreator());
        newBean.setTaskNo(originBean.getTaskNo());
        newBean.setTaskName(String.format("%1$s-%2$s", originBean.getTaskName(), splitNo));
        newBean.setTaskStatus(originBean.getTaskStatus());
        newBean.setDispatchStatus(originBean.getDispatchStatus());
        newBean.setAllocationStatus(originBean.getAllocationStatus());
        newBean.setException(originBean.isException());
        newBean.setCreateTime(originBean.getCreateTime());
        newBean.setBeginTime(originBean.getBeginTime());
        newBean.setEndTime(originBean.getEndTime());
        newBean.setBizStatus(originBean.getBizStatus());
        newBean.setTaskChange(originBean.isTaskChange());
        newBean.setBillStatus(originBean.getBillStatus());
        newBean.setModifier(originBean.getModifier());
        newBean.setModifytime(originBean.getModifytime());
        newBean.setPlanTimedym(originBean.getPlanTimedym());
        newBean.setPlanUserdym(originBean.getPlanUserdym());
        newBean.setBillType(originBean.getBillType());
        newBean.setOprEntry(this.copyNewOprEntryBean(originBean.getOprEntry()));
        return newBean;
    }

    private DailyPlanEntryOfOprBean[] copyNewOprEntryBean(DailyPlanEntryOfOprBean[] originOprBean) {
        DailyPlanEntryOfOprBean[] newOprBean = new DailyPlanEntryOfOprBean[originOprBean.length];
        for (int i = 0; i < originOprBean.length; ++i) {
            DailyPlanEntryOfOprBean newBean = new DailyPlanEntryOfOprBean();
            newBean.setSrcBillID(originOprBean[i].getSrcBillID());
            newBean.setSrcBillEntryID(originOprBean[i].getSrcBillEntryID());
            newBean.setSrcType(originOprBean[i].getSrcType());
            newBean.setOrderNo(originOprBean[i].getOrderNo());
            newBean.setWorkCard(originOprBean[i].getWorkCard());
            newBean.setProcessGroup(originOprBean[i].getProcessGroup());
            newBean.setProfession(originOprBean[i].getProfession());
            newBean.setZone(originOprBean[i].getZone());
            newBean.setArea(originOprBean[i].getArea());
            newBean.setPlanArea(originOprBean[i].getPlanArea());
            newBean.setProject(originOprBean[i].getProject());
            newBean.setMaterialMTC(originOprBean[i].getMaterialMTC());
            newBean.setTaskBeginTime(originOprBean[i].getTaskBeginTime());
            newBean.setTaskEndTime(originOprBean[i].getTaskEndTime());
            newBean.setStatus(originOprBean[i].getStatus());
            newBean.setOprException(originOprBean[i].isOprException());
            newBean.setOprWorkHourUnit(originOprBean[i].getOprWorkHourUnit());
            newBean.setWorkHour(originOprBean[i].getWorkHour());
            newBean.setRepairHours(originOprBean[i].getRepairHours());
            newBean.setCheckHours(originOprBean[i].getCheckHours());
            newBean.setSrcTime(originOprBean[i].getSrcTime());
            newBean.setSrcBizType(originOprBean[i].getSrcBizType());
            newBean.setWorkCardTitle(originOprBean[i].getWorkCardTitle());
            newBean.setPmtsTask(originOprBean[i].getPmtsTask());
            newBean.setMroOrderEntryID(originOprBean[i].getMroOrderEntryID());
            newBean.setTechNo(originOprBean[i].getTechNo());
            newBean.setDefaultWorkSort(originOprBean[i].getDefaultWorkSort());
            newBean.setStage(originOprBean[i].getStage());
            newBean.setCompletionRate(originOprBean[i].getCompletionRate());
            newBean.setNote(originOprBean[i].getNote());
            newOprBean[i] = newBean;
        }
        return newOprBean;
    }

    public List<DailyPlanBean> splitDailyPlanBean(DailyPlanBean originBean, Set<Long> splitEntry) {
        ArrayList<DailyPlanBean> newBeans = new ArrayList<DailyPlanBean>(8);
        DailyPlanEntryOfOprBean[] originOprBeans = originBean.getOprEntry();
        ArrayList<DailyPlanEntryOfOprBean> split2 = new ArrayList<DailyPlanEntryOfOprBean>(8);
        for (DailyPlanEntryOfOprBean originOprEntryBean : originOprBeans) {
            Long oprEntryPk = (Long)originOprEntryBean.getPkValue();
            if (!splitEntry.contains(oprEntryPk)) continue;
            split2.add(originOprEntryBean);
        }
        DailyPlanBean splitNewBean = this.copyNewBean(originBean);
        splitNewBean.setOprEntry(split2.toArray(new DailyPlanEntryOfOprBean[0]));
        newBeans.add(splitNewBean);
        return newBeans;
    }

    private Long getSplitBillNo(String originNo) {
        QFilter filter = new QFilter("billno", "=", (Object)originNo);
        DynamicObject bill = BusinessDataServiceHelper.loadSingle((String)"sfc_dailyplansplitno", (String)"billno,currentno", (QFilter[])filter.toArray());
        Long maxIndex = 1L;
        if (bill != null) {
            Long currentNo = bill.getLong("currentno");
            maxIndex = currentNo + 1L;
            bill.set("currentno", (Object)maxIndex);
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{bill});
        } else {
            DynamicObject newDynamicObject = BusinessDataServiceHelper.newDynamicObject((String)"sfc_dailyplansplitno");
            newDynamicObject.set("billno", (Object)originNo);
            newDynamicObject.set("currentno", (Object)maxIndex);
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{newDynamicObject});
        }
        return maxIndex;
    }
}

