/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.sfc.business.dailyplan;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.mmc.sfc.business.dailyplan.DailyPlanHelper;
import kd.mmc.sfc.common.dailyplan.bean.DailyPlanBean;
import kd.mmc.sfc.common.dailyplan.bean.DailyPlanEntryOfOprBean;
import kd.mmc.sfc.common.dailyplan.bean.DailyPlanEntryOfPlanBean;
import kd.mmc.sfc.common.dailyplan.bean.DailyPlanFilterBean;
import kd.mmc.sfc.common.dailyplan.bean.DailyPlanSubEntryOfAllocBean;

public class DailyPlanCustomControlHelper {
    private static final Log logger = LogFactory.getLog(DailyPlanCustomControlHelper.class);
    private int maxDays;

    public void setMaxDays(int maxDays) {
        this.maxDays = maxDays;
    }

    public JSONObject initCalendar(JSONObject param) {
        JSONObject data = new JSONObject();
        Date startDate = param.getDate("startDate");
        JSONObject topJson = this.buildTop(startDate);
        data.put("top", (Object)topJson);
        JSONArray columns = this.buildColumn(startDate, this.maxDays);
        data.put("columns", (Object)columns);
        JSONArray rowData = this.assembleTableData(startDate);
        data.put("tableData", (Object)rowData);
        return data;
    }

    public JSONObject initHisCalendar(JSONObject param, int autoNum) {
        JSONObject data = new JSONObject();
        Date startDate = param.getDate("startDate");
        JSONObject topJson = this.buildTop(startDate);
        data.put("top", (Object)topJson);
        JSONArray columns = this.buildOtherHisColumn(startDate, this.maxDays, autoNum);
        data.put("columns", (Object)columns);
        JSONArray rowData = this.assembleTableData(startDate);
        data.put("tableData", (Object)rowData);
        return data;
    }

    private JSONArray assembleTableData(Date startDate) {
        JSONArray rowData = new JSONArray();
        JSONObject row = new JSONObject();
        JSONObject row0 = new JSONObject();
        row.put("row_0", (Object)row0);
        row0.put("timeSlot", (Object)"00:00:00~24:00:00");
        for (int i = 0; i < this.maxDays; ++i) {
            Calendar c = Calendar.getInstance();
            c.setTime(startDate);
            c.add(5, i);
            String rowTag = String.format("row_%1$s", i + 1);
            JSONObject rowTagData = new JSONObject();
            rowTagData.put("rowTime", (Object)c.getTimeInMillis());
            JSONArray tasks = new JSONArray();
            rowTagData.put("tasks", (Object)tasks);
            row.put(rowTag, (Object)rowTagData);
        }
        rowData.add((Object)row);
        return rowData;
    }

    public JSONObject buildTop(Date startDate) {
        SimpleDateFormat format = new SimpleDateFormat(ResManager.loadKDString((String)"MM\u6708dd\u65e5", (String)"DailyPlanCustomControlHelper_0", (String)"mmc-sfc-business", (Object[])new Object[0]));
        Calendar calEnd = Calendar.getInstance();
        calEnd.setTime(startDate);
        calEnd.add(5, this.maxDays - 1);
        Date endDate = calEnd.getTime();
        String topStart = format.format(startDate);
        String topEnd = format.format(endDate);
        JSONObject topJson = new JSONObject();
        topJson.put("startDate", (Object)topStart);
        topJson.put("endDate", (Object)topEnd);
        return topJson;
    }

    public JSONArray buildColumn(Date startDate, int maxDays) {
        SimpleDateFormat format = new SimpleDateFormat(ResManager.loadKDString((String)"MM\u6708dd\u65e5", (String)"DailyPlanCustomControlHelper_0", (String)"mmc-sfc-business", (Object[])new Object[0]));
        JSONArray columns = new JSONArray();
        JSONObject column1 = new JSONObject();
        column1.put("title", (Object)ResManager.loadKDString((String)"\u65f6\u95f4\u6bb5", (String)"DailyPlanCustomControlHelper_1", (String)"mmc-sfc-business", (Object[])new Object[0]));
        column1.put("dataIndex", (Object)"timeSlot");
        columns.add((Object)column1);
        for (int i = 0; i < maxDays; ++i) {
            Calendar c = Calendar.getInstance();
            c.setTime(startDate);
            c.add(5, i);
            JSONObject column = new JSONObject();
            column.put("title", (Object)format.format(c.getTime()));
            column.put("dataIndex", (Object)c.getTimeInMillis());
            columns.add((Object)column);
        }
        return columns;
    }

    public JSONArray buildOtherHisColumn(Date startDate, int maxDays, int autoNum) {
        JSONArray columns = new JSONArray();
        JSONObject column1 = new JSONObject();
        column1.put("title", (Object)ResManager.loadKDString((String)"\u65f6\u95f4\u6bb5", (String)"DailyPlanCustomControlHelper_1", (String)"mmc-sfc-business", (Object[])new Object[0]));
        column1.put("dataIndex", (Object)"timeSlot");
        columns.add((Object)column1);
        for (int i = 0; i < maxDays; ++i) {
            Calendar c = Calendar.getInstance();
            c.setTime(startDate);
            c.add(5, i);
            JSONObject column = new JSONObject();
            column.put("title", (Object)String.format("day%s", autoNum++));
            column.put("dataIndex", (Object)c.getTimeInMillis());
            columns.add((Object)column);
        }
        return columns;
    }

    public String convertDailyPlanBeanToCustom(DailyPlanBean[] dailyplans, JSONObject data) {
        DailyPlanHelper helper = new DailyPlanHelper();
        DailyPlanFilterBean filterBean = helper.buildFilterBean();
        Map<Long, JSONArray> dataMapFromDailyPlan = this.getDataMapFromDailyPlan(dailyplans);
        List<Map<String, Object>> timeSlotList = this.getTimeSlotPro(filterBean);
        if (timeSlotList.size() == 0) {
            return null;
        }
        ArrayList<Map> timeSlotNameOptionsList = new ArrayList<Map>(16);
        for (Map<String, Object> timeSlot : timeSlotList) {
            Map timeSlotNameOptions = (Map)timeSlot.get("timeSlotNameOptions");
            timeSlotNameOptionsList.add(timeSlotNameOptions);
        }
        Map top = (Map)data.get((Object)"top");
        top.put("timeSlotNameOptions", timeSlotNameOptionsList);
        Map timeSlotOne = (Map)timeSlotNameOptionsList.get(0);
        top.put("timeSlotName", timeSlotOne.get("label"));
        String timeSlotId = (String)timeSlotOne.get("timeSlotId");
        Map<String, Object> slotMap = timeSlotList.get(0);
        List timeSlot = (List)slotMap.get(timeSlotId);
        JSONArray columns = data.getJSONArray("columns");
        JSONArray genTableData = this.genTableData(timeSlot, columns, dataMapFromDailyPlan);
        data.put("tableData", (Object)genTableData);
        return timeSlotId;
    }

    public JSONObject convertDailyPlanBeanToCustom(DailyPlanBean[] dailyplans, JSONObject data, String slotId) {
        DailyPlanHelper helper = new DailyPlanHelper();
        DailyPlanFilterBean filterBean = helper.buildFilterBean();
        Map<Long, JSONArray> dataMapFromDailyPlan = this.getDataMapFromDailyPlan(dailyplans);
        List<Map<String, Object>> timeSlotList = this.getTimeSlotPro(filterBean);
        ArrayList<Map<String, Object>> timeSlotNameOptionsList = new ArrayList<Map<String, Object>>(16);
        for (Map<String, Object> timeSlot : timeSlotList) {
            Map timeSlotNameOptions = (Map)timeSlot.get("timeSlotNameOptions");
            timeSlotNameOptionsList.add(timeSlotNameOptions);
        }
        List<String> resTimeSlot = this.assembleTopData(data, timeSlotNameOptionsList, timeSlotList, slotId);
        JSONArray columns = data.getJSONArray("columns");
        JSONArray genTableData = this.genTableData(resTimeSlot, columns, dataMapFromDailyPlan);
        data.put("tableData", (Object)genTableData);
        return data;
    }

    public JSONObject convertDailyPlanHisBeanToCustom(DailyPlanBean[] dailyplans, JSONObject data, String slotId) {
        DailyPlanHelper helper = new DailyPlanHelper();
        DailyPlanFilterBean filterBean = helper.buildFilterBean();
        Map<Long, JSONArray> dataMapFromDailyPlan = this.getDataMapFromDailyPlan(dailyplans);
        List<Map<String, Object>> timeSlotList = this.getTimeSlotPro(filterBean);
        ArrayList<Map<String, Object>> timeSlotNameOptionsList = new ArrayList<Map<String, Object>>(16);
        for (Map<String, Object> timeSlot : timeSlotList) {
            Map timeSlotNameOptions = (Map)timeSlot.get("timeSlotNameOptions");
            timeSlotNameOptionsList.add(timeSlotNameOptions);
        }
        List<String> resTimeSlot = this.assembleTopData(data, timeSlotNameOptionsList, timeSlotList, slotId);
        JSONArray columns = data.getJSONArray("columns");
        JSONArray genTableData = this.genTableData(resTimeSlot, columns, dataMapFromDailyPlan);
        data.put("tableData", (Object)genTableData);
        return data;
    }

    private List<String> assembleTopData(JSONObject data, List<Map<String, Object>> timeSlotNameOptionsList, List<Map<String, Object>> timeSlotList, String slotId) {
        Map top = (Map)data.get((Object)"top");
        top.put("timeSlotNameOptions", timeSlotNameOptionsList);
        List<String> resTimeSlot = new ArrayList<String>(16);
        for (Map<String, Object> timeSlot : timeSlotList) {
            if (timeSlot.get(slotId) == null) continue;
            resTimeSlot = (List)timeSlot.get(slotId);
            Map timeSlotNameOptions = (Map)timeSlot.get("timeSlotNameOptions");
            String label = (String)timeSlotNameOptions.get("label");
            top.put("timeSlotName", label);
        }
        return resTimeSlot;
    }

    private Map<Long, JSONArray> getDataMapFromDailyPlan(DailyPlanBean[] dailyplans) {
        JSONArray jsonArray;
        long timeInMillis;
        Calendar c;
        String color;
        String showStatus;
        boolean isOutRange;
        Date headEndTime;
        Date headBeginTime;
        JSONArray personJSON;
        DailyPlanSubEntryOfAllocBean[] subEntryAllocation;
        Date planStartTime;
        JSONArray tasks;
        HashMap<Long, JSONArray> dataMap = new HashMap<Long, JSONArray>(8);
        ArrayList<DailyPlanBean> dailyPlanFromMro = new ArrayList<DailyPlanBean>(16);
        ArrayList<DailyPlanBean> dailyPlanList = new ArrayList<DailyPlanBean>(16);
        DailyPlanBean[] dailyPlanBeanArray = dailyplans;
        int n = dailyPlanBeanArray.length;
        for (int i = 0; i < n; ++i) {
            int n2 = 0;
            DailyPlanBean dailyplan = dailyPlanBeanArray[i];
            DailyPlanEntryOfOprBean[] oprEntry = dailyplan.getOprEntry();
            DailyPlanEntryOfOprBean[] dailyPlanEntryOfOprBeanArray = oprEntry;
            int n3 = dailyPlanEntryOfOprBeanArray.length;
            if (n2 >= n3) continue;
            DailyPlanEntryOfOprBean dailyPlanEntryOfOprBean = dailyPlanEntryOfOprBeanArray[n2];
            if ("pom_mroorder".equals(dailyPlanEntryOfOprBean.getSrcType())) {
                dailyPlanFromMro.add(dailyplan);
                continue;
            }
            dailyPlanList.add(dailyplan);
        }
        for (DailyPlanBean dailyPlanBean : dailyPlanFromMro) {
            DailyPlanEntryOfPlanBean[] planEntry;
            for (DailyPlanEntryOfPlanBean planEntryBean : planEntry = dailyPlanBean.getPlanEntry()) {
                JSONObject dailyJson = new JSONObject(true);
                dailyJson.put("text", (Object)dailyPlanBean.getTaskName());
                dailyJson.put("taskId", (Object)dailyPlanBean.getPkValue().toString());
                tasks = new JSONArray();
                planStartTime = planEntryBean.getPlanStartTime();
                subEntryAllocation = planEntryBean.getSubEntryAllocation();
                if (subEntryAllocation != null) {
                    personJSON = this.getPersonJSON(subEntryAllocation);
                    dailyJson.put("persons", (Object)personJSON);
                }
                headBeginTime = dailyPlanBean.getBeginTime();
                headEndTime = dailyPlanBean.getEndTime();
                isOutRange = false;
                if (headBeginTime != null && headEndTime != null && (planStartTime.compareTo(headBeginTime) < 0 || planStartTime.compareTo(headEndTime) > 0)) {
                    isOutRange = true;
                }
                showStatus = dailyPlanBean.getShowStatus();
                color = this.getColorByShowStatus(showStatus);
                dailyJson.put("backgroundColor", (Object)color);
                tasks.add((Object)dailyJson);
                c = Calendar.getInstance();
                c.setTime(planStartTime);
                timeInMillis = c.getTimeInMillis();
                dailyJson.put("taskTime", (Object)timeInMillis);
                jsonArray = (JSONArray)dataMap.get(timeInMillis);
                if (jsonArray == null) {
                    dataMap.put(timeInMillis, tasks);
                    continue;
                }
                jsonArray.add((Object)dailyJson);
            }
        }
        for (DailyPlanBean dailyPlanBean : dailyPlanList) {
            DailyPlanEntryOfPlanBean[] planEntry;
            for (DailyPlanEntryOfPlanBean planEntryBean : planEntry = dailyPlanBean.getPlanEntry()) {
                JSONObject dailyJson = new JSONObject(true);
                dailyJson.put("text", (Object)dailyPlanBean.getTaskName());
                dailyJson.put("taskId", (Object)dailyPlanBean.getPkValue().toString());
                tasks = new JSONArray();
                planStartTime = planEntryBean.getPlanStartTime();
                subEntryAllocation = planEntryBean.getSubEntryAllocation();
                if (subEntryAllocation != null) {
                    personJSON = this.getPersonJSON(subEntryAllocation);
                    dailyJson.put("persons", (Object)personJSON);
                }
                headBeginTime = dailyPlanBean.getBeginTime();
                headEndTime = dailyPlanBean.getEndTime();
                isOutRange = false;
                if (headBeginTime != null && headEndTime != null && (planStartTime.compareTo(headBeginTime) < 0 || planStartTime.compareTo(headEndTime) > 0)) {
                    isOutRange = true;
                }
                if (isOutRange && dailyPlanBean.isImportant()) {
                    dailyJson.put("type", (Object)"both");
                } else if (isOutRange) {
                    dailyJson.put("type", (Object)"error");
                } else if (dailyPlanBean.isImportant()) {
                    dailyJson.put("type", (Object)"important");
                }
                showStatus = dailyPlanBean.getShowStatus();
                color = this.getColorByShowStatus(showStatus);
                dailyJson.put("backgroundColor", (Object)color);
                tasks.add((Object)dailyJson);
                c = Calendar.getInstance();
                c.setTime(planStartTime);
                timeInMillis = c.getTimeInMillis();
                dailyJson.put("taskTime", (Object)timeInMillis);
                jsonArray = (JSONArray)dataMap.get(timeInMillis);
                if (jsonArray == null) {
                    dataMap.put(timeInMillis, tasks);
                    continue;
                }
                jsonArray.add((Object)dailyJson);
            }
        }
        return dataMap;
    }

    private JSONArray getPersonJSON(DailyPlanSubEntryOfAllocBean[] subEntryAllocation) {
        JSONArray data = new JSONArray();
        for (DailyPlanSubEntryOfAllocBean allocation : subEntryAllocation) {
            JSONObject row = new JSONObject(true);
            DynamicObject userIncharge = allocation.getUserIncharge();
            if (userIncharge == null) continue;
            row.put("personId", (Object)userIncharge.getPkValue().toString());
            row.put("name", (Object)userIncharge.getString("name"));
            row.put("personType", (Object)"test");
            data.add((Object)row);
        }
        return data;
    }

    private List<Map<String, Object>> getTimeSlotPro(DailyPlanFilterBean filterBean) {
        QFilter filter = new QFilter("professiona", "=", filterBean.getProfession().getPkValue());
        filter.and(new QFilter("status", "=", (Object)"C"));
        filter.and(new QFilter("enable", "=", (Object)"1"));
        ArrayList<Map<String, Object>> resList = new ArrayList<Map<String, Object>>(16);
        String selectProperties = "schemeentry.id,schemeentry.subentry,schemeentry.schemename,subentry.workstarttime,subentry.workendtime";
        DynamicObject timeProRows = BusinessDataServiceHelper.loadSingleFromCache((String)"fmm_industrytimerel", (String)selectProperties, (QFilter[])filter.toArray());
        if (timeProRows != null) {
            DynamicObjectCollection timeProRange = timeProRows.getDynamicObjectCollection("schemeentry");
            for (DynamicObject timeProRow : timeProRange) {
                HashMap<String, Cloneable> timeDataProMap = new HashMap<String, Cloneable>(8);
                ArrayList<String> timeList = new ArrayList<String>(8);
                HashMap<String, String> timeSlotNameOptionsMap = new HashMap<String, String>(16);
                String id = timeProRow.get("id").toString();
                String schemeName = timeProRow.get("schemename").toString();
                timeSlotNameOptionsMap.put("timeSlotId", id);
                timeSlotNameOptionsMap.put("label", schemeName);
                timeDataProMap.put("timeSlotNameOptions", timeSlotNameOptionsMap);
                DynamicObjectCollection subentry = timeProRow.getDynamicObjectCollection("subentry");
                for (DynamicObject timeData : subentry) {
                    int start = timeData.getInt("workstarttime");
                    int end = timeData.getInt("workendtime");
                    String strStart = DailyPlanHelper.secToTime(start);
                    String strEnd = DailyPlanHelper.secToTime(end);
                    String format = String.format("%1$s~%2$s", strStart, strEnd);
                    timeList.add(format);
                }
                timeDataProMap.put(id, timeList);
                resList.add(timeDataProMap);
            }
        }
        return resList;
    }

    private void getTimeProData(Row timeProRow, List<String> timeList, Map<String, Object> timeProMap, Long id, String schemeName) {
        int start = timeProRow.getInteger("schemeentry.subentry.workstarttime");
        int end = timeProRow.getInteger("schemeentry.subentry.workendtime");
        String strStart = DailyPlanHelper.secToTime(start);
        String strEnd = DailyPlanHelper.secToTime(end);
        String format = String.format("%1$s~%2$s", strStart, strEnd);
        timeList.add(format);
        timeProMap.put(schemeName, timeList);
    }

    private JSONArray genTableData(List<String> timeSlot, JSONArray columns, Map<Long, JSONArray> dataMapFromDailyPlan) {
        JSONArray tableData = new JSONArray(timeSlot.size());
        for (int i = 0; i < timeSlot.size(); ++i) {
            JSONObject rowData = new JSONObject(true);
            String strTime = timeSlot.get(i);
            String[] split = strTime.split("~");
            String startTime = split[0];
            SimpleDateFormat sdf = new SimpleDateFormat("HH:mm:ss");
            Date startDate = null;
            try {
                startDate = sdf.parse(startTime);
            }
            catch (ParseException e) {
                logger.info(e.getMessage());
                throw new KDBizException(String.format(ResManager.loadKDString((String)"%1$s\u65f6\u95f4\u8f6c\u6362\u9519\u8bef", (String)"DailyPlanCustomControlHelper_2", (String)"mmc-sfc-business", (Object[])new Object[0]), startTime));
            }
            Calendar c = Calendar.getInstance();
            c.setTime(startDate);
            int hour = c.get(11);
            int minute = c.get(12);
            int second = c.get(13);
            int timeToSeconds = DailyPlanHelper.timeToSeconds(hour, minute, second);
            for (int j = 0; j < columns.size(); ++j) {
                String rowTag = String.format("row_%1$s", j);
                if (j == 0) {
                    JSONObject row0 = new JSONObject();
                    row0.put("timeSlot", (Object)strTime);
                    rowData.put(rowTag, (Object)row0);
                    continue;
                }
                JSONObject colInfo = columns.getJSONObject(j);
                Long dataIndex = colInfo.getLong("dataIndex");
                String modalTitle = String.format("%1$s %2$s", colInfo.get((Object)"title"), strTime);
                Long index = dataIndex + (long)timeToSeconds;
                JSONArray jsonArray = dataMapFromDailyPlan.get(index) == null ? new JSONArray() : dataMapFromDailyPlan.get(index);
                JSONObject rowj = new JSONObject();
                rowj.put("rowTime", (Object)index);
                rowj.put("modalTitle", (Object)modalTitle);
                rowj.put("tasks", (Object)jsonArray);
                rowData.put(rowTag, (Object)rowj);
            }
            tableData.add((Object)rowData);
        }
        return tableData;
    }

    private JSONArray genTableProData(List<Map<String, Object>> timeSlotProList, JSONArray columns, Map<Long, JSONArray> dataMapFromDailyPlan) {
        JSONArray tableData = new JSONArray(timeSlotProList.size());
        for (int i = 0; i < timeSlotProList.size(); ++i) {
            Map<String, Object> timeSlotPros = timeSlotProList.get(i);
            Map timeSlotNameOptions = (Map)timeSlotPros.get("timeSlotNameOptions");
            String label = (String)timeSlotNameOptions.get("label");
            List timeSlotPro = (List)timeSlotPros.get(timeSlotNameOptions.get("timeSlotId"));
            for (int j = 0; j < timeSlotPro.size(); ++j) {
                JSONObject rowData = new JSONObject(true);
                String strTime = (String)timeSlotPro.get(j);
                String[] split = strTime.split("~");
                String startTime = split[0];
                SimpleDateFormat sdf = new SimpleDateFormat("HH:mm:ss");
                Date startDate = null;
                try {
                    startDate = sdf.parse(startTime);
                }
                catch (ParseException e) {
                    logger.info(e.getMessage());
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"%1$s\u65f6\u95f4\u8f6c\u6362\u9519\u8bef", (String)"DailyPlanCustomControlHelper_2", (String)"mmc-sfc-business", (Object[])new Object[0]), startTime));
                }
                Calendar c = Calendar.getInstance();
                c.setTime(startDate);
                int hour = c.get(11);
                int minute = c.get(12);
                int second = c.get(13);
                int timeToSeconds = DailyPlanHelper.timeToSeconds(hour, minute, second);
                for (int k = 0; k < columns.size(); ++k) {
                    String rowTag = String.format("row_%1$s", k);
                    if (k == 0) {
                        JSONObject row0 = new JSONObject();
                        row0.put("timeSlot", (Object)strTime);
                        rowData.put(rowTag, (Object)row0);
                        continue;
                    }
                    JSONObject colInfo = columns.getJSONObject(k);
                    Long dataIndex = colInfo.getLong("dataIndex");
                    String modalTitle = String.format("%1$s %2$s", colInfo.get((Object)"title"), strTime);
                    Long index = dataIndex + (long)timeToSeconds;
                    JSONArray jsonArray = dataMapFromDailyPlan.get(index) == null ? new JSONArray() : dataMapFromDailyPlan.get(index);
                    JSONObject rowj = new JSONObject();
                    rowj.put("rowTime", (Object)index);
                    rowj.put("modalTitle", (Object)modalTitle);
                    rowj.put("tasks", (Object)jsonArray);
                    rowData.put(rowTag, (Object)rowj);
                }
                tableData.add((Object)rowData);
            }
        }
        return tableData;
    }

    public String getColorByShowStatus(String showStatus) {
        String colorValue = "";
        switch (showStatus) {
            case "B": {
                colorValue = "orange";
                break;
            }
            case "C": {
                colorValue = "green";
                break;
            }
            default: {
                colorValue = "blue";
            }
        }
        return colorValue;
    }
}

