/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.sfc.business.dailyplan;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.mmc.sfc.business.dailyplan.DailyPlanBeanConvertHelper;
import kd.mmc.sfc.common.mydailyplan.MydailyPlanUtils;
import kd.mmc.sfc.common.utils.SFCUtils;

public class DailyPlanDataHelper {
    public Object[] saveDailyPlanData(String json) {
        ArrayList<List<JSONObject>> tableDataModels = new ArrayList<List<JSONObject>>(16);
        JSONObject data = JSONObject.parseObject((String)json);
        Long timeCurlotId = null;
        ArrayList<String> tasksIds = new ArrayList<String>(16);
        if (data.containsKey((Object)"top") && data.get((Object)"top") != null) {
            String topData = String.valueOf(data.get((Object)"top"));
            JSONObject topDataJson = JSON.parseObject((String)topData);
            JSONArray timeSlotNameOptions = (JSONArray)topDataJson.get((Object)"timeSlotNameOptions");
            if (timeSlotNameOptions == null) {
                return new Object[]{1};
            }
            String timeSlotName = (String)topDataJson.get((Object)"timeSlotName");
            for (Object timeSlotOption : timeSlotNameOptions) {
                JSONObject timeSlotJson = JSONObject.parseObject((String)String.valueOf(timeSlotOption));
                String label = (String)timeSlotJson.get((Object)"label");
                if (!label.equals(timeSlotName)) continue;
                timeCurlotId = Long.valueOf((String)timeSlotJson.get((Object)"timeSlotId"));
                break;
            }
        }
        if (data.containsKey((Object)"tableData") && data.get((Object)"tableData") != null) {
            String tableData = String.valueOf(data.get((Object)"tableData"));
            JSONArray tableDataArray = JSON.parseArray((String)tableData);
            for (Object tableDataObj : tableDataArray) {
                ArrayList<JSONObject> rowModels = new ArrayList<JSONObject>(16);
                JSONObject tableDataObjJson = JSONObject.parseObject((String)String.valueOf(tableDataObj));
                Set tableDataKeySet = tableDataObjJson.keySet();
                for (String rowKey : tableDataKeySet) {
                    JSONObject rowObject = new JSONObject();
                    String rowData = tableDataObjJson.get((Object)rowKey).toString();
                    JSONObject rowDataJson = JSONObject.parseObject((String)rowData);
                    rowObject.put("rowKey", (Object)rowKey);
                    String modalTitle = "";
                    if (rowDataJson.containsKey((Object)"modalTitle")) {
                        modalTitle = String.valueOf(rowDataJson.get((Object)"modalTitle"));
                        rowObject.put("modalTitle", (Object)modalTitle);
                    }
                    if (rowDataJson.containsKey((Object)"rowTime")) {
                        long rowTime = Long.parseLong(String.valueOf(rowDataJson.get((Object)"rowTime")));
                        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                        rowObject.put("startTime", (Object)sdf.format(rowTime));
                        this.assembleEndTime(rowObject, modalTitle, rowTime);
                    }
                    if (rowDataJson.containsKey((Object)"tasks")) {
                        String tasksStr = String.valueOf(rowDataJson.get((Object)"tasks"));
                        JSONArray tasksDataArray = JSON.parseArray((String)tasksStr);
                        List taskIds = tasksDataArray.stream().map(taskId -> ((JSONObject)taskId).getString("taskId")).collect(Collectors.toList());
                        tasksIds.addAll(taskIds.stream().distinct().collect(Collectors.toList()));
                        for (Object tasksDataObj : tasksDataArray) {
                            JSONObject tasksJson = JSONObject.parseObject((String)String.valueOf(tasksDataObj));
                            Set tasksKeySet = tasksJson.keySet();
                            for (String tasksDataKey : tasksKeySet) {
                                if (!"persons".equals(tasksDataKey)) continue;
                                String personsData = String.valueOf(tasksJson.get((Object)tasksDataKey));
                                JSONArray personsDataArray = JSONArray.parseArray((String)personsData);
                                List personsDataArrayIds = personsDataArray.stream().map(personId -> ((JSONObject)personId).getString("personId")).collect(Collectors.toList());
                                rowObject.put(tasksJson.getString("taskId"), personsDataArrayIds);
                            }
                        }
                    }
                    rowModels.add(rowObject);
                }
                tableDataModels.add(rowModels);
            }
        }
        Object[] savedData = this.save(tableDataModels, tasksIds, timeCurlotId);
        return savedData;
    }

    public Boolean isHistoryTime(String tableData) {
        Date todayTime;
        long newTime;
        Long olderTimeTmp = Long.parseLong(tableData);
        long olderTime = olderTimeTmp;
        return olderTime < (newTime = (todayTime = this.getTodayTime()).getTime());
    }

    public Object[] clearData() {
        DynamicObject[] dayPlanObjects;
        Date date = this.getTodayTime();
        QFilter qFilter = new QFilter("planentryentity.planstarttime", ">=", (Object)date);
        String selectProperties = "planentryentity,planentryentity.planstarttime";
        for (DynamicObject dayPlanObject : dayPlanObjects = BusinessDataServiceHelper.load((String)"sfc_dailyplan", (String)selectProperties, (QFilter[])new QFilter[]{qFilter})) {
            DynamicObjectCollection planEntryEntity = dayPlanObject.getDynamicObjectCollection("planentryentity");
            planEntryEntity.clear();
        }
        Object[] saveObject = SaveServiceHelper.save((DynamicObject[])dayPlanObjects);
        return saveObject;
    }

    public Date getTodayTime() {
        Calendar todayStart = Calendar.getInstance();
        todayStart.set(11, 0);
        todayStart.set(12, 0);
        todayStart.set(13, 0);
        todayStart.set(14, 0);
        return todayStart.getTime();
    }

    public boolean deleteDailyPlanData(String taskId, String time, boolean flag) {
        DynamicObject[] dayPlanObjects;
        Long task = Long.valueOf(taskId);
        long rowTime = Long.parseLong(time);
        boolean resFlag = false;
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String formatTime = sdf.format(rowTime);
        Date startTime = null;
        try {
            startTime = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(formatTime);
        }
        catch (ParseException e) {
            throw new KDBizException(new ErrorCode("DailyPlanDataHelper", String.format("Date format conversion exception\uff1a%1$s", formatTime)), new Object[0]);
        }
        Object[] saveObject = null;
        ArrayList<DynamicObject> resData = new ArrayList<DynamicObject>(16);
        QFilter taskQfilter = new QFilter("id", "=", (Object)task);
        String selectFields = "id,planentryentity.planstarttime,planentryentity.planendtime,allocsubentryentity.userincharge";
        for (DynamicObject dayPlanObject : dayPlanObjects = BusinessDataServiceHelper.load((String)"sfc_dailyplan", (String)selectFields, (QFilter[])new QFilter[]{taskQfilter})) {
            DynamicObjectCollection planEntryEntity = dayPlanObject.getDynamicObjectCollection("planentryentity");
            for (int i = 0; i < planEntryEntity.size(); ++i) {
                DynamicObject planRow = (DynamicObject)planEntryEntity.get(i);
                Date planStartTime = (Date)planRow.get("planstarttime");
                if (!startTime.equals(planStartTime)) continue;
                planEntryEntity.remove((Object)planRow);
                break;
            }
            resData.add(dayPlanObject);
        }
        DynamicObject[] res = (DynamicObject[])resData.stream().toArray(DynamicObject[]::new);
        DynamicObjectCollection resPlanEntity = res[0].getDynamicObjectCollection("planentryentity");
        if (flag && resPlanEntity.size() == 0) {
            Long id = res[0].getLong("id");
            QFilter qFilter = new QFilter("id", "=", (Object)id);
            DeleteServiceHelper.delete((String)"sfc_dailyplan", (QFilter[])new QFilter[]{qFilter});
            resFlag = true;
        } else {
            saveObject = SaveServiceHelper.save((DynamicObject[])res);
        }
        return resFlag;
    }

    private Object[] save(List<List<JSONObject>> dataModel, List<String> tasksIds, Long slotId) {
        Object[] saveObject = null;
        DailyPlanBeanConvertHelper helper = new DailyPlanBeanConvertHelper();
        if (!SFCUtils.isEmptyList(tasksIds)) {
            DynamicObject[] dayPlanObjects;
            List taskIds = tasksIds.stream().map(taskId -> Long.parseLong(taskId)).collect(Collectors.toList());
            ArrayList<DynamicObject> resData = new ArrayList<DynamicObject>(16);
            HashSet<QFilter> filters = new HashSet<QFilter>(16);
            QFilter qFilter = new QFilter("id", "in", taskIds);
            filters.add(qFilter);
            helper.getDataFromDB(filters);
            for (DynamicObject dayPlanObject : dayPlanObjects = helper.getDataFromDB(filters)) {
                HashMap<String, DynamicObject> planMap = new HashMap<String, DynamicObject>();
                DynamicObjectCollection planEntryEntity = dayPlanObject.getDynamicObjectCollection("planentryentity");
                for (DynamicObject planRow : planEntryEntity) {
                    Date planStartTime = (Date)planRow.get("planstarttime");
                    long time = planStartTime.getTime();
                    String startTimeKey = String.valueOf(time);
                    planMap.put(startTimeKey, planRow);
                }
                Set startTimeKeySet = planMap.keySet();
                for (List<JSONObject> taskList : dataModel) {
                    for (JSONObject task : taskList) {
                        Object taskId2;
                        String startTime = "";
                        if (task.get((Object)"startTime") == null) continue;
                        String date = String.valueOf(task.get((Object)"startTime"));
                        try {
                            long time = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(date).getTime();
                            startTime = String.valueOf(time);
                        }
                        catch (ParseException e) {
                            throw new KDBizException(new ErrorCode("DailyPlanDataHelper", String.format("Date format conversion exception\uff1a%1$s", date)), new Object[0]);
                        }
                        if (startTimeKeySet.contains(startTime)) {
                            taskId2 = dayPlanObject.get("id");
                            if (task.get(taskId2) == null) continue;
                            DynamicObject dayPlanData = (DynamicObject)planMap.get(startTime);
                            this.setPlanEntryPro(dayPlanData, task, slotId, taskId2);
                            continue;
                        }
                        taskId2 = dayPlanObject.get("id");
                        if (task.get(taskId2) == null) continue;
                        this.addPlanDetail(dataModel, dayPlanObject, planEntryEntity, slotId, date);
                    }
                }
                resData.add(dayPlanObject);
                MydailyPlanUtils.updatePlanTimeAndUser((DynamicObject)dayPlanObject);
            }
            DynamicObject[] res = (DynamicObject[])resData.stream().toArray(DynamicObject[]::new);
            saveObject = SaveServiceHelper.save((DynamicObject[])res);
        }
        return saveObject;
    }

    private void setPlanEntryPro(DynamicObject dayPlanData, JSONObject task, Long slotId, Object taskId) {
        this.setDate(dayPlanData, task, "startTime", "planstarttime");
        this.setDate(dayPlanData, task, "endTime", "planendtime");
        dayPlanData.set("planbizstatus", (Object)"A");
        dayPlanData.set("timeslotproid", (Object)slotId);
        this.setPerson(dayPlanData, taskId, task);
    }

    private void addPlanDetail(List<List<JSONObject>> dataModel, DynamicObject dayPlanObject, DynamicObjectCollection planEntryEntity, Long slotId, String addStartTime) {
        Object taskId = dayPlanObject.get("id");
        for (List<JSONObject> taskList : dataModel) {
            for (JSONObject task : taskList) {
                if (task.get(taskId) == null || !addStartTime.equals(task.get((Object)"startTime"))) continue;
                DynamicObject planDetailRow = planEntryEntity.addNew();
                this.setPlanEntryPro(planDetailRow, task, slotId, taskId);
            }
        }
    }

    private void setPerson(DynamicObject planDetailRow, Object taskId, JSONObject task) {
        DynamicObjectCollection allocSubEntryEntity = planDetailRow.getDynamicObjectCollection("allocsubentryentity");
        allocSubEntryEntity.clear();
        JSONArray personJsonIds = null;
        List personIds = null;
        if (task.containsKey((Object)String.valueOf(taskId))) {
            personJsonIds = task.getJSONArray(String.valueOf(taskId));
            personIds = JSON.parseArray((String)personJsonIds.toJSONString(), Long.class);
        }
        if (personIds != null && personIds.size() > 0) {
            for (int i = 0; i < personIds.size(); ++i) {
                DynamicObject row = allocSubEntryEntity.addNew();
                DynamicObject persondy = BusinessDataServiceHelper.loadSingleFromCache(personIds.get(i), (String)"mpdm_manuperson", (String)"id,professiona");
                row.set("userincharge", (Object)persondy);
            }
        }
    }

    private void setDate(DynamicObject planDetailRow, JSONObject task, String key, String field) {
        if (task.containsKey((Object)key)) {
            try {
                Date date = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(String.valueOf(task.get((Object)key)));
                planDetailRow.set(field, (Object)date);
            }
            catch (ParseException e) {
                throw new KDBizException(new ErrorCode("DailyPlanDataHelper", String.format("Date format conversion exception\uff1a%1$s", String.valueOf(task.get((Object)"endTime")))), new Object[0]);
            }
        }
    }

    private void assembleEndTime(JSONObject rowObject, String modalTitle, long rowTime) {
        if (StringUtils.isNotBlank((CharSequence)modalTitle)) {
            String substring = modalTitle.substring(modalTitle.lastIndexOf(126) + 1, modalTitle.length());
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd " + substring);
            String rowEndTime = simpleDateFormat.format(rowTime);
            rowObject.put("endTime", (Object)rowEndTime);
        }
    }
}

