/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.sfc.business.dailyplan;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bd.mpdm.common.utils.MulBaseDataUtils;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.IDataEntityBase;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.entity.botp.runtime.ConvertOperationResult;
import kd.bos.entity.botp.runtime.PushArgs;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.botp.ConvertServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.mmc.sfc.business.dailyplan.DailyPlanBeanConvertHelper;
import kd.mmc.sfc.business.dailyplan.DailyPlanBeanOperateHelper;
import kd.mmc.sfc.common.dailyplan.bean.DailyPlanBean;
import kd.mmc.sfc.common.dailyplan.bean.DailyPlanEntryOfOprBean;
import kd.mmc.sfc.common.dailyplan.bean.DailyPlanEntryOfPlanBean;
import kd.mmc.sfc.common.dailyplan.bean.DailyPlanFilterBean;

public class DailyPlanHelper {
    private static final Log logger = LogFactory.getLog(DailyPlanHelper.class);
    private IFormView platView;
    private Set<Object> techEntryPKs;
    private Set<String> strtechEntryPKs;
    private Set<Object> mroEntryPKs;
    private Set<String> strMROEntryPKs;
    private int maxDays;
    private Date startDate;
    private Map<Long, Long> mapMRO = new HashMap<Long, Long>(8);

    public IFormView getPlatView() {
        return this.platView;
    }

    public void setPlatView(IFormView platView) {
        this.platView = platView;
    }

    public Set<Object> getTechEntryPKs() {
        return this.techEntryPKs;
    }

    public void setTechEntryPKs(Set<Object> techEntryPKs) {
        this.techEntryPKs = techEntryPKs;
    }

    public Set<String> getStrtechEntryPKs() {
        return this.strtechEntryPKs;
    }

    public void setStrtechEntryPKs(Set<String> strtechEntryPKs) {
        this.strtechEntryPKs = strtechEntryPKs;
    }

    public Set<Object> getMROEntryPKs() {
        return this.mroEntryPKs;
    }

    public void setMROEntryPKs(Set<Object> mroEntryPKs) {
        this.mroEntryPKs = mroEntryPKs;
    }

    public Set<String> getStrMROEntryPKs() {
        return this.strMROEntryPKs;
    }

    public void setStrMROEntryPKs(Set<String> stMROEntryPKs) {
        this.strMROEntryPKs = stMROEntryPKs;
    }

    public int getMaxDays() {
        return this.maxDays;
    }

    public void setMaxDays(int maxDays) {
        this.maxDays = maxDays;
    }

    public Date getStartDate() {
        return this.startDate;
    }

    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }

    public Map<Long, Long> getMapMRO() {
        return this.mapMRO;
    }

    public void createDailyPlan() {
        DailyPlanFilterBean filterBean = this.buildFilterBean();
        if (filterBean == null) {
            this.platView.showTipNotification(ResManager.loadKDString((String)"\u672a\u627e\u5230\u67e5\u8be2\u6761\u4ef6\uff0c\u8bf7\u5f55\u5165\u67e5\u8be2\u6761\u4ef6", (String)"DailyPlanHelper_1", (String)"mmc-sfc-business", (Object[])new Object[0]));
            return;
        }
        this.createDailyPlanFromMROTech(filterBean);
    }

    public DailyPlanBean[] query() {
        DailyPlanFilterBean filterBean = this.buildFilterBean();
        if (filterBean == null) {
            this.platView.showTipNotification(ResManager.loadKDString((String)"\u672a\u627e\u5230\u67e5\u8be2\u6761\u4ef6\uff0c\u8bf7\u5f55\u5165\u67e5\u8be2\u6761\u4ef6", (String)"DailyPlanHelper_1", (String)"mmc-sfc-business", (Object[])new Object[0]));
            return new DailyPlanBean[0];
        }
        Set<QFilter> dailyPlanFilter = this.createDailyPlanFilter(filterBean);
        DailyPlanBeanConvertHelper convert = new DailyPlanBeanConvertHelper();
        DailyPlanBean[] dailyPlan = convert.getDailyPlan(dailyPlanFilter);
        return dailyPlan;
    }

    public DailyPlanBean[] query(Set<QFilter> filters) {
        if (filters == null) {
            this.platView.showTipNotification(ResManager.loadKDString((String)"\u672a\u627e\u5230\u67e5\u8be2\u6761\u4ef6\uff0c\u8bf7\u5f55\u5165\u67e5\u8be2\u6761\u4ef6", (String)"DailyPlanHelper_1", (String)"mmc-sfc-business", (Object[])new Object[0]));
            return new DailyPlanBean[0];
        }
        DailyPlanBeanConvertHelper convert = new DailyPlanBeanConvertHelper();
        DailyPlanBean[] dailyPlan = convert.getDailyPlan(filters);
        return dailyPlan;
    }

    private void createDailyPlanFromMROTech(DailyPlanFilterBean filterBean) {
        Set<QFilter> createMROTechFilter = this.createMROTechFilter(filterBean);
        Set<QFilter> createMROTechOrderFilter = this.createMROTechOrderFilter(filterBean);
        HashSet<Long> orderEntryID = new HashSet<Long>(8);
        try (DataSet orderDS = QueryServiceHelper.queryDataSet((String)"DailyPlanHelper_queryMROTechOrder", (String)"pom_mroorder", (String)"treeentryentity.id", (QFilter[])createMROTechOrderFilter.toArray(new QFilter[0]), null);){
            for (Row row : orderDS) {
                orderEntryID.add(row.getLong("treeentryentity.id"));
            }
        }
        QFilter techFilter = new QFilter("billstatus", "=", (Object)"C");
        HashSet<String> taskStatus = new HashSet<String>(3);
        taskStatus.add("A");
        taskStatus.add("B");
        taskStatus.add("D");
        techFilter.and("mftentryseq.taskstatus", "in", taskStatus);
        techFilter.and("mftentryseq.bizstatus", "=", (Object)"A");
        if (!orderEntryID.isEmpty()) {
            techFilter.and("mftentryseq.id", "in", orderEntryID);
        }
        HashSet<String> oprStatus = new HashSet<String>(6);
        oprStatus.add("A");
        oprStatus.add("B");
        oprStatus.add("C");
        oprStatus.add("D");
        oprStatus.add("E");
        oprStatus.add("H");
        techFilter.and("oprentryentity.oprstatus", "in", oprStatus);
        techFilter.and("oprentryentity.oprinvalid", "=", (Object)false);
        createMROTechFilter.add(techFilter);
        HashMap<Long, Long> mapTech = new HashMap<Long, Long>(8);
        try (DataSet techDS = QueryServiceHelper.queryDataSet((String)"DailyPlanHelper_queryMROTech", (String)"sfc_mromanuftech", (String)"id,oprentryentity.id", (QFilter[])createMROTechFilter.toArray(new QFilter[0]), null);){
            for (Row row : techDS) {
                Object entryID = row.get("oprentryentity.id");
                Object object = row.get("id");
                if (this.strtechEntryPKs == null) {
                    this.strtechEntryPKs = new HashSet<String>(8);
                }
                if (this.techEntryPKs == null) {
                    this.techEntryPKs = new HashSet<Object>(8);
                }
                this.strtechEntryPKs.add(entryID.toString());
                this.techEntryPKs.add(entryID);
                mapTech.put((Long)entryID, (Long)object);
            }
        }
        Map<Long, Set<Long>> dailyPlanOprData = this.getDailyPlanOprData();
        HashMap newMapTech = new HashMap(16);
        for (Map.Entry keyLong : mapTech.entrySet()) {
            if (dailyPlanOprData.get(keyLong.getKey()) != null) {
                Set<Long> taskids = dailyPlanOprData.get(keyLong.getKey());
                if (taskids.isEmpty()) continue;
                newMapTech.put(keyLong.getKey(), keyLong.getValue());
                continue;
            }
            newMapTech.put(keyLong.getKey(), keyLong.getValue());
        }
        if (newMapTech.isEmpty()) {
            return;
        }
        PushArgs pushArgs = new PushArgs();
        pushArgs.setSourceEntityNumber("sfc_mromanuftech");
        pushArgs.setTargetEntityNumber("sfc_dailyplan");
        pushArgs.setBuildConvReport(true);
        ArrayList<ListSelectedRow> needPushRows = new ArrayList<ListSelectedRow>(10);
        for (Map.Entry entry : newMapTech.entrySet()) {
            ListSelectedRow srcBill = new ListSelectedRow(entry.getValue());
            srcBill.setEntryEntityKey("oprentryentity");
            srcBill.setEntryPrimaryKeyValue(entry.getKey());
            needPushRows.add(srcBill);
        }
        if (needPushRows.isEmpty()) {
            logger.info("\u5bf9\u5e94\u7684\u5de5\u5e8f\u8ba1\u5212\u6ca1\u6709\u9700\u8981\u4e0b\u63a8\u7684\u6570\u636e\u3002");
        }
        pushArgs.setSelectedRows(needPushRows);
        ConvertOperationResult pushResult = ConvertServiceHelper.pushAndSave((PushArgs)pushArgs);
        if (!pushResult.isSuccess()) {
            this.platView.showTipNotification(ResManager.loadKDString((String)"\u68c0\u4fee\u5de5\u5e8f\u8ba1\u5212\u751f\u6210\u65e5\u8ba1\u5212\u5931\u8d25,\u539f\u56e0\u8bf7\u67e5\u770b\u76d1\u63a7\u65e5\u5fd7", (String)"DailyPlanHelper_3", (String)"mmc-sfc-business", (Object[])new Object[0]));
        } else {
            this.cloneDailyPlanByTaskSet(pushResult);
        }
    }

    public ConvertOperationResult createDailyPlanFromMROOrder(Map<Long, Long> mapMRO) {
        Map<Long, Set<Long>> dailyPlanOprData = this.getDailyPlanOprData();
        HashMap<Long, Long> newMapMRO = new HashMap<Long, Long>(16);
        for (Map.Entry<Long, Long> keyLong : mapMRO.entrySet()) {
            if (dailyPlanOprData.get(keyLong.getKey()) != null) {
                Set<Long> taskids = dailyPlanOprData.get(keyLong.getKey());
                if (taskids.isEmpty()) continue;
                newMapMRO.put(keyLong.getKey(), keyLong.getValue());
                continue;
            }
            newMapMRO.put(keyLong.getKey(), keyLong.getValue());
        }
        if (newMapMRO.isEmpty()) {
            return null;
        }
        PushArgs pushArgs = new PushArgs();
        pushArgs.setSourceEntityNumber("pom_mroorder");
        pushArgs.setTargetEntityNumber("sfc_dailyplan");
        pushArgs.setBuildConvReport(true);
        ArrayList<ListSelectedRow> needPushRows = new ArrayList<ListSelectedRow>(10);
        for (Map.Entry entry : newMapMRO.entrySet()) {
            ListSelectedRow srcBill = new ListSelectedRow(entry.getValue());
            srcBill.setEntryEntityKey("oprentryentity");
            srcBill.setEntryPrimaryKeyValue(entry.getKey());
            needPushRows.add(srcBill);
        }
        if (needPushRows.isEmpty()) {
            logger.info("\u5bf9\u5e94\u7684\u5de5\u5e8f\u8ba1\u5212\u6ca1\u6709\u9700\u8981\u4e0b\u63a8\u7684\u6570\u636e\u3002");
        }
        pushArgs.setSelectedRows(needPushRows);
        ConvertOperationResult pushResult = ConvertServiceHelper.pushAndSave((PushArgs)pushArgs);
        if (!pushResult.isSuccess()) {
            this.platView.showTipNotification(ResManager.loadKDString((String)"\u68c0\u4fee\u5de5\u5355\u751f\u6210\u65e5\u8ba1\u5212\u5931\u8d25,\u539f\u56e0\u8bf7\u67e5\u770b\u76d1\u63a7\u65e5\u5fd7", (String)"DailyPlanHelper_9", (String)"mmc-sfc-business", (Object[])new Object[0]));
        }
        return pushResult;
    }

    public Map<String, Object> queryMROOrder() {
        HashMap<String, Object> resMap = new HashMap<String, Object>(16);
        DailyPlanFilterBean filterBean = this.buildFilterBean();
        if (filterBean == null) {
            this.platView.showTipNotification(ResManager.loadKDString((String)"\u672a\u627e\u5230\u67e5\u8be2\u6761\u4ef6\uff0c\u8bf7\u5f55\u5165\u67e5\u8be2\u6761\u4ef6", (String)"DailyPlanHelper_1", (String)"mmc-sfc-business", (Object[])new Object[0]));
            return resMap;
        }
        Set<QFilter> createMROOrderFilter = this.createMROOrderFilter(filterBean);
        QFilter orderFilter = new QFilter("billstatus", "=", (Object)"C");
        HashSet<String> taskStatus = new HashSet<String>(2);
        taskStatus.add("A");
        taskStatus.add("D");
        orderFilter.and("treeentryentity.taskstatus", "in", taskStatus);
        orderFilter.and("treeentryentity.bizstatus", "=", (Object)"A");
        createMROOrderFilter.add(orderFilter);
        String selectFields = "id,billno,dailyexptype,treeentryentity.id,treeentryentity.materielmtc,treeentryentity.project";
        DynamicObjectCollection mroOrderEntity = QueryServiceHelper.query((String)"pom_mroorder", (String)selectFields, (QFilter[])createMROOrderFilter.toArray(new QFilter[0]));
        resMap.put("profession", filterBean.getProfession().getPkValue() + "");
        resMap.put("mroOrderEntity", mroOrderEntity);
        return resMap;
    }

    private void cloneDailyPlanByTaskSet(ConvertOperationResult pushResult) {
        DynamicObject[] sfcDailyPlan;
        ArrayList<DynamicObject> copyDataEntitys = new ArrayList<DynamicObject>(8);
        Map<Long, Set<Long>> dailyPlanOprDataForBOTP = this.getDailyPlanOprDataForBOTP();
        if (dailyPlanOprDataForBOTP.isEmpty()) {
            return;
        }
        Set targetBillIds = pushResult.getTargetBillIds();
        HashSet<QFilter> filters = new HashSet<QFilter>(8);
        QFilter filter = new QFilter("id", "in", (Object)targetBillIds);
        filters.add(filter);
        DailyPlanBeanConvertHelper fieldHelper = new DailyPlanBeanConvertHelper();
        for (DynamicObject dailyplan : sfcDailyPlan = fieldHelper.getDataFromDB(filters)) {
            DynamicObjectCollection oprentryentity = dailyplan.getDynamicObjectCollection("oprentryentity");
            Long sourcebillentryid = ((DynamicObject)oprentryentity.get(0)).getLong("srcbillentryid");
            Set<Long> setTaskId = dailyPlanOprDataForBOTP.get(sourcebillentryid);
            if (setTaskId == null || setTaskId.isEmpty()) continue;
            int i = 0;
            for (Long taskid : setTaskId) {
                DynamicObject task = BusinessDataServiceHelper.loadSingleFromCache((Object)taskid, (String)"pmts_task", (String)"id");
                if (i == 0) {
                    ((DynamicObject)oprentryentity.get(0)).set("pmtstask", (Object)task);
                    copyDataEntitys.add(dailyplan);
                } else {
                    DynamicObject copyObj = (DynamicObject)OrmUtils.clone((IDataEntityBase)dailyplan, (boolean)false, (boolean)true);
                    DynamicObject org = copyObj.getDynamicObject("org");
                    String newCode = CodeRuleServiceHelper.getNumber((String)"sfc_dailyplan", (DynamicObject)copyObj, (String)org.getPkValue().toString());
                    copyObj.set("billno", (Object)newCode);
                    DynamicObjectCollection copyoprentryentity = copyObj.getDynamicObjectCollection("oprentryentity");
                    ((DynamicObject)copyoprentryentity.get(0)).set("pmtstask", (Object)task);
                    copyDataEntitys.add(copyObj);
                }
                ++i;
            }
        }
        this.completeDailyPlan(copyDataEntitys.toArray(new DynamicObject[0]));
        SaveServiceHelper.save((DynamicObject[])copyDataEntitys.toArray(new DynamicObject[0]), (OperateOption)OperateOption.create());
    }

    private Set<QFilter> createDailyPlanFilter(DailyPlanFilterBean filterBean) {
        DynamicObject workstage;
        DynamicObject processgroup;
        DynamicObject planArea;
        DynamicObject area;
        Date plantime;
        DynamicObjectCollection mulProjects;
        HashSet<QFilter> filters = new HashSet<QFilter>(8);
        DynamicObject profession = filterBean.getProfession();
        if (profession != null) {
            filters.add(new QFilter("oprentryentity.profession", "=", profession.getPkValue()));
        }
        if ((mulProjects = filterBean.getMulProjects()) != null && !mulProjects.isEmpty()) {
            List projects = MulBaseDataUtils.getPkValuesByMulData((DynamicObjectCollection)mulProjects);
            filters.add(new QFilter("oprentryentity.project", "in", (Object)projects));
        }
        if ((plantime = filterBean.getPlantime()) != null) {
            filters.add(new QFilter("begintime", "<=", (Object)plantime));
        }
        if ((area = filterBean.getArea()) != null) {
            filters.add(new QFilter("oprentryentity.area", "=", area.getPkValue()));
        }
        if ((planArea = filterBean.getPlanArea()) != null) {
            filters.add(new QFilter("oprentryentity.planarea", "=", planArea.getPkValue()));
        }
        if ((processgroup = filterBean.getProcessgroup()) != null) {
            filters.add(new QFilter("oprentryentity.processgroup", "=", processgroup.getPkValue()));
        }
        if ((workstage = filterBean.getWorkstage()) != null) {
            filters.add(new QFilter("oprentryentity.stage", "=", workstage.getPkValue()));
        }
        long orgId = filterBean.getOrgId();
        filters.add(new QFilter("org", "=", (Object)orgId));
        return filters;
    }

    private Set<QFilter> createMROTechFilter(DailyPlanFilterBean filterBean) {
        String orderTaskStatus;
        DynamicObject processgroup;
        DynamicObjectCollection mulProjects;
        HashSet<QFilter> filters = new HashSet<QFilter>(8);
        DynamicObject profession = filterBean.getProfession();
        if (profession != null) {
            filters.add(new QFilter("oprentryentity.oprprofessiona", "=", profession.getPkValue()));
        }
        if ((mulProjects = filterBean.getMulProjects()) != null && !mulProjects.isEmpty()) {
            List projects = MulBaseDataUtils.getPkValuesByMulData((DynamicObjectCollection)mulProjects);
            filters.add(new QFilter("project", "in", (Object)projects));
        }
        if ((processgroup = filterBean.getProcessgroup()) != null) {
            filters.add(new QFilter("oprentryentity.processgroup", "=", processgroup.getPkValue()));
        }
        if (!(orderTaskStatus = filterBean.getOrderTaskStatus()).isEmpty()) {
            filters.add(new QFilter("mftentryseq.taskstatus", "=", (Object)orderTaskStatus));
        }
        return filters;
    }

    private Set<QFilter> createMROTechOrderFilter(DailyPlanFilterBean filterBean) {
        HashSet<QFilter> filters = new HashSet<QFilter>(8);
        HashSet<String> taskStatus = new HashSet<String>(3);
        taskStatus.add("A");
        taskStatus.add("B");
        taskStatus.add("D");
        filters.add(new QFilter("treeentryentity.taskstatus", "in", taskStatus));
        filters.add(new QFilter("treeentryentity.bizstatus", "=", (Object)"A"));
        QFilter qFilter = new QFilter("dailyexptype", "=", (Object)0L);
        filters.add(qFilter);
        DynamicObjectCollection mulProjects = filterBean.getMulProjects();
        if (mulProjects != null && !mulProjects.isEmpty()) {
            List projects = MulBaseDataUtils.getPkValuesByMulData((DynamicObjectCollection)mulProjects);
            filters.add(new QFilter("treeentryentity.project", "in", (Object)projects));
        }
        return filters;
    }

    private Set<QFilter> createMROOrderFilter(DailyPlanFilterBean filterBean) {
        HashSet<QFilter> filters = new HashSet<QFilter>(8);
        QFilter qFilter = new QFilter("dailyexptype", ">", (Object)0L);
        filters.add(qFilter);
        DynamicObjectCollection mulProjects = filterBean.getMulProjects();
        if (mulProjects != null && !mulProjects.isEmpty()) {
            List projects = MulBaseDataUtils.getPkValuesByMulData((DynamicObjectCollection)mulProjects);
            filters.add(new QFilter("treeentryentity.project", "in", (Object)projects));
        }
        long orgId = filterBean.getOrgId();
        filters.add(new QFilter("org", "=", (Object)orgId));
        return filters;
    }

    public void completeDailyPlan(DynamicObject[] dailyPlan) {
        HashSet<Long> taskIDs = new HashSet<Long>(8);
        for (DynamicObject bill : dailyPlan) {
            DynamicObjectCollection oprEntry = bill.getDynamicObjectCollection("oprentryentity");
            for (DynamicObject oprRow : oprEntry) {
                DynamicObject task = oprRow.getDynamicObject("pmtstask");
                if (task == null) continue;
                taskIDs.add((Long)task.getPkValue());
            }
        }
        if (!taskIDs.isEmpty()) {
            this.fillTaskData(dailyPlan, taskIDs);
        }
    }

    private void fillTaskData(DynamicObject[] dailyPlan, Set<Long> taskIDs) {
        QFilter filter = new QFilter("id", "in", taskIDs);
        Map taskMap = BusinessDataServiceHelper.loadFromCache((String)"pmts_task", (String)this.buildTaskSelectFields(), (QFilter[])filter.toArray());
        for (DynamicObject bill : dailyPlan) {
            boolean filled = bill.getBoolean("isfilltask");
            if (filled) continue;
            DynamicObjectCollection oprEntry = bill.getDynamicObjectCollection("oprentryentity");
            this.fillOprEntry(bill, oprEntry, taskMap);
            bill.set("isfilltask", (Object)true);
        }
    }

    private String buildTaskSelectFields() {
        StringBuilder sb = new StringBuilder();
        sb.append("number,name,planstartdate,planenddate,");
        sb.append("prepositiontaskentry.prepositiontask,prepositiontaskentry.taskrelation,prepositiontaskentry.predelayed,");
        sb.append("postpositiontaskentry.postpositiontask,postpositiontaskentry.taskrelationtwo,postpositiontaskentry.postdelayed");
        return sb.toString();
    }

    private void fillOprEntry(DynamicObject bill, DynamicObjectCollection oprEntry, Map<Object, DynamicObject> taskMap) {
        for (DynamicObject row : oprEntry) {
            DynamicObject task = row.getDynamicObject("pmtstask");
            if (task == null) continue;
            DynamicObject taskDy = taskMap.get(task.getPkValue());
            bill.set("taskno", taskDy.get("number"));
            bill.set("taskname", taskDy.get("name"));
            if (taskDy.get("planstartdate") != null) {
                bill.set("begintime", taskDy.get("planstartdate"));
                row.set("taskbegintime", taskDy.get("planstartdate"));
            }
            if (taskDy.get("planenddate") != null) {
                bill.set("endtime", taskDy.get("planenddate"));
                row.set("taskendtime", taskDy.get("planenddate"));
            }
            DynamicObjectCollection pretask = taskDy.getDynamicObjectCollection("prepositiontaskentry");
            this.fillPreTaskEntry(row.getDynamicObjectCollection("prepositiontaskentry"), pretask);
            DynamicObjectCollection posttask = taskDy.getDynamicObjectCollection("postpositiontaskentry");
            this.fillPostTaskEntry(row.getDynamicObjectCollection("postpositiontaskentry"), posttask);
        }
    }

    private void fillPreTaskEntry(DynamicObjectCollection pretaskEntry, DynamicObjectCollection pretask) {
        for (DynamicObject taskInfo : pretask) {
            DynamicObject newRow = pretaskEntry.addNew();
            newRow.set("pretask", taskInfo.get("prepositiontask"));
            newRow.set("pretaskrelation", taskInfo.get("taskrelation"));
            newRow.set("predelay", taskInfo.get("predelayed"));
        }
    }

    private void fillPostTaskEntry(DynamicObjectCollection posttaskEntry, DynamicObjectCollection posttask) {
        for (DynamicObject taskInfo : posttask) {
            DynamicObject newRow = posttaskEntry.addNew();
            newRow.set("posttask", taskInfo.get("postpositiontask"));
            newRow.set("posttaskrelation", taskInfo.get("taskrelationtwo"));
            newRow.set("postdelay", taskInfo.get("postdelayed"));
        }
    }

    public DailyPlanFilterBean buildFilterBean() {
        long currentUserId = UserServiceHelper.getCurrentUserId();
        long userDefaultOrgID = RequestContext.get().getOrgId();
        QFilter filter = new QFilter("user", "=", (Object)currentUserId);
        DynamicObject loadSingle = BusinessDataServiceHelper.loadSingle((String)"sfc_dailyplan_filter", (String)"profession,project,plantime,createtime,isallocation,processgroup,srctype,workstage,workarea,zone,planarea,ordertaskstatus,mulproject,multipro", (QFilter[])filter.toArray());
        if (loadSingle != null) {
            DailyPlanFilterBean bean = new DailyPlanFilterBean();
            bean.setOrgId(userDefaultOrgID);
            DynamicObject profession = loadSingle.getDynamicObject("profession");
            bean.setProfession(profession);
            Date plantime = loadSingle.getDate("plantime");
            bean.setPlantime(plantime);
            Date createtime = loadSingle.getDate("createtime");
            bean.setCreatetime(createtime);
            boolean isallocation = loadSingle.getBoolean("isallocation");
            bean.setIsallocation(isallocation);
            DynamicObject processgroup = loadSingle.getDynamicObject("processgroup");
            bean.setProcessgroup(processgroup);
            String srctype = loadSingle.getString("srctype");
            bean.setSrctype(srctype);
            DynamicObject workstage = loadSingle.getDynamicObject("workstage");
            bean.setWorkstage(workstage);
            DynamicObject workarea = loadSingle.getDynamicObject("workarea");
            bean.setArea(workarea);
            DynamicObject zone = loadSingle.getDynamicObject("zone");
            bean.setZone(zone);
            DynamicObject planarea = loadSingle.getDynamicObject("planarea");
            bean.setPlanArea(planarea);
            bean.setOrderTaskStatus(loadSingle.getString("ordertaskstatus"));
            bean.setMulProjects(loadSingle.getDynamicObjectCollection("mulproject"));
            DynamicObjectCollection multiPro = loadSingle.getDynamicObjectCollection("multipro");
            bean.setMultiPro(multiPro);
            return bean;
        }
        return null;
    }

    public DailyPlanFilterBean buildHisFilterBean(Map<String, Object> filterMap) {
        if (filterMap != null) {
            Long newProfession = (Long)filterMap.get("newProfession");
            QFilter professionFilter = new QFilter("id", "=", (Object)newProfession);
            List newMulProjectIds = (List)filterMap.get("newMulProjectIds");
            QFilter mulProjectIdsFilter = new QFilter("id", "in", (Object)newMulProjectIds);
            DynamicObject profession = BusinessDataServiceHelper.loadSingle((String)"mpdm_professiona", (String)"id,name", (QFilter[])new QFilter[]{professionFilter});
            DynamicObjectCollection mulProject = QueryServiceHelper.query((String)"pmpd_project", (String)"id,name", (QFilter[])new QFilter[]{mulProjectIdsFilter});
            DailyPlanFilterBean bean = new DailyPlanFilterBean();
            bean.setProfession(profession);
            bean.setMulProjects(mulProject);
            return bean;
        }
        return null;
    }

    public Map<Long, Set<Long>> getDailyPlanOprData() {
        Map<Long, Set<Long>> planData = this.getDailyPlanExists();
        Map<Long, Set<Long>> planDataTask = this.getDailyPlanRelationExists();
        Map<Long, Set<Long>> excludePlan = this.excludePlan(planData, planDataTask);
        excludePlan = this.getDailyPlanOprDataExcludeExists(excludePlan);
        return excludePlan;
    }

    public Map<Long, Set<Long>> getDailyPlanOprDataForBOTP() {
        Map<Object, Object> result = new HashMap(8);
        Map<Long, Set<Long>> planData = this.getDailyPlanExists();
        if (!planData.isEmpty()) {
            Map<Long, Set<Long>> planDataTask = this.getDailyPlanRelationExists();
            Map<Long, Set<Long>> excludePlan = this.excludePlan(planData, planDataTask);
            result = this.getDailyPlanOprDataExcludeExists(excludePlan);
        } else {
            result = this.getDailyPlanRelationExists();
        }
        return result;
    }

    private Map<Long, Set<Long>> getDailyPlanExists() {
        HashMap<Long, Set<Long>> planData = new HashMap<Long, Set<Long>>(8);
        QFilter filter = new QFilter("oprentryentity.srcbillentryid", "in", this.techEntryPKs);
        try (DataSet dsDaily = QueryServiceHelper.queryDataSet((String)"MroTechToDailyPlan_alldaily", (String)"sfc_dailyplan", (String)"oprentryentity.srcbillentryid,oprentryentity.pmtstask", (QFilter[])filter.toArray(), null);){
            for (Row row : dsDaily) {
                Long srcbillentryid = row.getLong("oprentryentity.srcbillentryid");
                Long pmtstask = row.getLong("oprentryentity.pmtstask");
                if (!planData.containsKey(srcbillentryid)) {
                    HashSet<Long> pmtstaskSet = new HashSet<Long>(2);
                    pmtstaskSet.add(pmtstask);
                    planData.put(srcbillentryid, pmtstaskSet);
                    continue;
                }
                Set taskids = (Set)planData.get(srcbillentryid);
                taskids.add(pmtstask);
            }
        }
        return planData;
    }

    private Map<Long, Set<Long>> getDailyPlanRelationExists() {
        QFilter filter = new QFilter("sourcebilltype", "=", (Object)"sfc_mromanuftech");
        filter.and(new QFilter("sourcebillentryid", "in", this.strtechEntryPKs));
        HashMap<Long, Set<Long>> planDataTask = new HashMap<Long, Set<Long>>(8);
        try (DataSet dsRelation = QueryServiceHelper.queryDataSet((String)"MroTechToDailyPlan_fmmrelation", (String)"fmm_task_relations", (String)"sourcebillentryid,targetbillid", (QFilter[])filter.toArray(), null);){
            for (Row row : dsRelation) {
                Long sourcebillentryid = row.getLong("sourcebillentryid");
                Long targetbillid = row.getLong("targetbillid");
                if (planDataTask.containsKey(sourcebillentryid)) {
                    Set taskids = (Set)planDataTask.get(sourcebillentryid);
                    taskids.add(targetbillid);
                    continue;
                }
                HashSet<Long> target = new HashSet<Long>(2);
                target.add(targetbillid);
                planDataTask.put(sourcebillentryid, target);
            }
        }
        return planDataTask;
    }

    private Map<Long, Set<Long>> excludePlan(Map<Long, Set<Long>> planData, Map<Long, Set<Long>> planDataTask) {
        for (Map.Entry<Long, Set<Long>> keyEntry : planData.entrySet()) {
            Set<Long> originIDs = keyEntry.getValue();
            if (planDataTask.get(keyEntry.getKey()) != null) {
                Set<Long> taskids = planDataTask.get(keyEntry.getKey());
                for (Long originID : originIDs) {
                    taskids.removeIf(e -> e.compareTo(originID) == 0);
                }
                originIDs.removeIf(e -> e.compareTo(0L) > 0);
                originIDs.addAll(taskids);
                continue;
            }
            originIDs.removeIf(e -> e.compareTo(0L) > 0);
        }
        return planData;
    }

    private Map<Long, Set<Long>> getDailyPlanOprDataExcludeExists(Map<Long, Set<Long>> planData) {
        for (Map.Entry<Long, Set<Long>> keyEntry : planData.entrySet()) {
            Set<Long> ids = keyEntry.getValue();
            ids.removeIf(e -> e.compareTo(0L) == 0);
        }
        return planData;
    }

    public static String secToTime(int seconds) {
        int hour = seconds / 3600;
        int minute = (seconds - hour * 3600) / 60;
        int second = seconds - hour * 3600 - minute * 60;
        StringBuilder str = new StringBuilder();
        if (hour >= 10) {
            str.append(String.format("%s:", hour));
        } else {
            str.append(String.format("0%s:", hour));
        }
        if (minute >= 10) {
            str.append(String.format("%s:", minute));
        } else {
            str.append(String.format("0%s:", minute));
        }
        if (second >= 10) {
            str.append(String.format("%s", second));
        } else {
            str.append(String.format("0%s", second));
        }
        return str.toString();
    }

    public static int timeToSeconds(int hour, int minute, int second) {
        int result = 0;
        result += hour * 60 * 60;
        result += minute * 60;
        return (result += second) * 1000;
    }

    public void combineDailyPlan(Set<Long> dailyPlanIDs) {
        HashSet<QFilter> filters = new HashSet<QFilter>(8);
        filters.add(new QFilter("id", "in", dailyPlanIDs));
        DailyPlanBeanConvertHelper convert = new DailyPlanBeanConvertHelper();
        DailyPlanBean[] dailyPlan = convert.getDailyPlan(filters);
        String validate = this.validateCombineData(dailyPlan);
        if (!validate.isEmpty()) {
            this.platView.showTipNotification(validate);
            return;
        }
        DailyPlanBeanOperateHelper opHelper = new DailyPlanBeanOperateHelper();
        DailyPlanBean combineToBean = dailyPlan[0];
        Date beginTime = combineToBean.getBeginTime();
        Date endTime = combineToBean.getEndTime();
        HashSet<DailyPlanBean> deleteBean = new HashSet<DailyPlanBean>(8);
        HashSet<Long> deletePks = new HashSet<Long>(8);
        for (int i = 1; i < dailyPlan.length; ++i) {
            DailyPlanBean bean = dailyPlan[i];
            Date beginTime2 = bean.getBeginTime();
            Date endTime2 = bean.getEndTime();
            if (beginTime2.compareTo(beginTime) < 0) {
                deleteBean.add(combineToBean);
                deletePks.add((Long)combineToBean.getPkValue());
                combineToBean = bean;
                beginTime = beginTime2;
            } else {
                deletePks.add((Long)bean.getPkValue());
                deleteBean.add(bean);
            }
            if (endTime2.compareTo(endTime) <= 0) continue;
            endTime = endTime2;
            combineToBean.setEndTime(endTime2);
        }
        DailyPlanBean combineBean = opHelper.combineBean(deleteBean.toArray(new DailyPlanBean[0]), combineToBean);
        DailyPlanBean[] saveBean = new DailyPlanBean[]{combineBean};
        opHelper.deleteDailyPlan(deletePks);
        opHelper.saveDailyPlan(saveBean);
    }

    private String validateCombineData(DailyPlanBean[] dailyPlan) {
        StringBuilder sb = new StringBuilder();
        HashSet<String> errorAllocSet = new HashSet<String>(8);
        for (DailyPlanBean bean : dailyPlan) {
            DailyPlanEntryOfPlanBean[] planEntry = bean.getPlanEntry();
            if (planEntry == null || planEntry.length <= 0) continue;
            errorAllocSet.add(bean.getTaskName());
        }
        if (errorAllocSet.size() > 0) {
            sb.append(String.format(ResManager.loadKDString((String)"%1$s\u4efb\u52a1\u5df2\u6392\u8ba1\u5212\uff0c\u4e0d\u5141\u8bb8\u7ec4\u5408\u64cd\u4f5c", (String)"DailyPlanHelper_5", (String)"mmc-sfc-business", (Object[])new Object[0]), errorAllocSet));
        }
        return sb.toString();
    }

    public void splitDailyPlan(Set<Long> oprEntryIDs) {
        HashSet<QFilter> filters = new HashSet<QFilter>(8);
        filters.add(new QFilter("oprentryentity.id", "in", oprEntryIDs));
        DailyPlanBeanConvertHelper convert = new DailyPlanBeanConvertHelper();
        DailyPlanBean[] dailyPlan = convert.getDailyPlan(filters);
        String validate = this.validateSplitData(dailyPlan);
        if (!validate.isEmpty()) {
            this.platView.showTipNotification(validate);
            return;
        }
        HashMap<Long, Set<Long>> mapForClone = new HashMap<Long, Set<Long>>(8);
        HashMap<Long, Set<Long>> mapForSplit = new HashMap<Long, Set<Long>>(8);
        for (DailyPlanBean bean : dailyPlan) {
            DailyPlanEntryOfOprBean[] oprEntry = bean.getOprEntry();
            HashSet<Long> oprEntryIDsFromFilter = new HashSet<Long>(8);
            HashSet<Long> oprEntryIDsFromDB = new HashSet<Long>(8);
            for (DailyPlanEntryOfOprBean oprRow : oprEntry) {
                Long pkValue = (Long)oprRow.getPkValue();
                if (oprEntryIDs.contains(pkValue)) {
                    oprEntryIDsFromFilter.add(pkValue);
                }
                oprEntryIDsFromDB.add(pkValue);
            }
            Long headPk = (Long)bean.getPkValue();
            if (oprEntryIDsFromFilter.size() == oprEntryIDsFromDB.size()) {
                mapForClone.put(headPk, oprEntryIDsFromFilter);
            }
            if (oprEntryIDsFromFilter.size() >= oprEntryIDsFromDB.size()) continue;
            mapForSplit.put(headPk, oprEntryIDsFromFilter);
        }
        if (!mapForClone.isEmpty()) {
            this.splitDailyPlanForClone(dailyPlan, mapForClone);
        }
        if (!mapForSplit.isEmpty()) {
            this.splitDailyPlanForSplit(dailyPlan, mapForSplit);
        }
    }

    private String validateSplitData(DailyPlanBean[] dailyPlan) {
        StringBuilder sb = new StringBuilder();
        HashSet<String> errorAllocSet = new HashSet<String>(8);
        for (DailyPlanBean bean : dailyPlan) {
            DailyPlanEntryOfPlanBean[] planEntry = bean.getPlanEntry();
            if (planEntry == null || planEntry.length <= 0) continue;
            errorAllocSet.add(bean.getTaskName());
        }
        if (errorAllocSet.size() > 0) {
            sb.append(String.format(ResManager.loadKDString((String)"%1$s\u4efb\u52a1\u5df2\u6392\u8ba1\u5212\uff0c\u4e0d\u5141\u8bb8\u62c6\u5206\u64cd\u4f5c", (String)"DailyPlanHelper_6", (String)"mmc-sfc-business", (Object[])new Object[0]), errorAllocSet));
        }
        return sb.toString();
    }

    private void splitDailyPlanForClone(DailyPlanBean[] dailyPlan, Map<Long, Set<Long>> mapForClone) {
        ArrayList<DailyPlanBean> newBeans = new ArrayList<DailyPlanBean>(8);
        DailyPlanBeanConvertHelper convert = new DailyPlanBeanConvertHelper();
        DailyPlanBeanOperateHelper opHelper = new DailyPlanBeanOperateHelper();
        for (DailyPlanBean bean : dailyPlan) {
            Long pkValue = (Long)bean.getPkValue();
            if (!mapForClone.containsKey(pkValue)) continue;
            DailyPlanBean copyNewBean = convert.copyNewBean(bean);
            newBeans.add(copyNewBean);
        }
        if (!newBeans.isEmpty()) {
            opHelper.saveDailyPlan(newBeans.toArray(new DailyPlanBean[0]));
        }
    }

    private void splitDailyPlanForSplit(DailyPlanBean[] dailyPlan, Map<Long, Set<Long>> mapForSplit) {
        ArrayList<DailyPlanBean> newBeans = new ArrayList<DailyPlanBean>(8);
        DailyPlanBeanConvertHelper convert = new DailyPlanBeanConvertHelper();
        DailyPlanBeanOperateHelper opHelper = new DailyPlanBeanOperateHelper();
        for (DailyPlanBean bean : dailyPlan) {
            Long pkValue = (Long)bean.getPkValue();
            if (!mapForSplit.containsKey(pkValue)) continue;
            newBeans.addAll(convert.splitDailyPlanBean(bean, mapForSplit.get(pkValue)));
        }
        if (!newBeans.isEmpty()) {
            this.deleteDailyPlanOprEntry(mapForSplit);
            opHelper.saveDailyPlan(newBeans.toArray(new DailyPlanBean[0]));
        }
    }

    private void deleteDailyPlanOprEntry(Map<Long, Set<Long>> mapForSplit) {
        DynamicObject[] dataFromDB;
        DailyPlanBeanConvertHelper convert = new DailyPlanBeanConvertHelper();
        HashSet queryOprIDs = new HashSet(8);
        for (Map.Entry<Long, Set<Long>> delete : mapForSplit.entrySet()) {
            queryOprIDs.addAll(delete.getValue());
        }
        HashSet<QFilter> filters = new HashSet<QFilter>(8);
        filters.add(new QFilter("oprentryentity.id", "in", queryOprIDs));
        for (DynamicObject dailyplan : dataFromDB = convert.getDataFromDB(filters)) {
            DynamicObjectCollection oprEntry = dailyplan.getDynamicObjectCollection("oprentryentity");
            oprEntry.removeIf(e -> queryOprIDs.contains((Long)e.getPkValue()));
        }
        SaveServiceHelper.save((DynamicObject[])dataFromDB);
    }

    public void transmitDailyPlan(Set<Long> dailyPlanIDs) {
        OperateOption option = OperateOption.create();
        OperationResult transmitResult = OperationServiceHelper.executeOperate((String)"transmit", (String)"sfc_dailyplan", (Object[])dailyPlanIDs.toArray(), (OperateOption)option);
        if (transmitResult.isSuccess()) {
            this.platView.showSuccessNotification(ResManager.loadKDString((String)"\u4e0b\u8fbe\u6210\u529f", (String)"DailyPlanHelper_7", (String)"mmc-sfc-business", (Object[])new Object[0]));
        } else {
            StringBuilder sb = new StringBuilder();
            Map billNos = transmitResult.getBillNos();
            List allErrorOrValidateInfo = transmitResult.getAllErrorOrValidateInfo();
            for (IOperateInfo errorInfo : allErrorOrValidateInfo) {
                String pkValue = errorInfo.getPkValue().toString();
                sb.append(String.format(ResManager.loadKDString((String)"\u65e5\u8ba1\u5212\u5355%1$s\uff1a%2$s", (String)"DailyPlanHelper_8", (String)"mmc-sfc-business", (Object[])new Object[0]), billNos.get(pkValue), errorInfo.getMessage()));
                sb.append("\n");
            }
            this.platView.showTipNotification(sb.toString());
        }
    }

    public boolean validateTransmitStatus(Long dailyPlanID) {
        boolean result = false;
        QFilter filter = new QFilter("id", "=", (Object)dailyPlanID);
        try (DataSet queryDataSet = QueryServiceHelper.queryDataSet((String)"dpHelper.validateTransmit", (String)"sfc_dailyplan", (String)"bizstatus,taskstatus", (QFilter[])filter.toArray(), null);){
            for (Row row : queryDataSet) {
                String bizstatus = row.getString("bizstatus");
                String taskstatus = row.getString("taskstatus");
                if (!"B".equals(bizstatus) || !"B".equals(taskstatus)) continue;
                result = true;
            }
        }
        return result;
    }

    public Long getTaskId(String eventArgs) {
        JSONObject req = JSON.parseObject((String)eventArgs);
        Long taskId = req.getLong("taskId");
        return taskId;
    }

    public PushArgs workAppointBill(Long taskId) {
        ArrayList<ListSelectedRow> appointRows = new ArrayList<ListSelectedRow>(16);
        ListSelectedRow selectedRow = new ListSelectedRow((Object)taskId);
        appointRows.add(selectedRow);
        PushArgs pushAppoint = new PushArgs();
        pushAppoint.setSourceEntityNumber("sfc_dailyplan");
        pushAppoint.setTargetEntityNumber("pmtm_workappointment");
        pushAppoint.setBuildConvReport(true);
        pushAppoint.setSelectedRows(appointRows);
        return pushAppoint;
    }

    public PushArgs otherNeedBill(Long taskId) {
        ArrayList<ListSelectedRow> needRows = new ArrayList<ListSelectedRow>(16);
        ListSelectedRow selectedRow = new ListSelectedRow((Object)taskId);
        needRows.add(selectedRow);
        PushArgs pushNeed = new PushArgs();
        pushNeed.setSourceEntityNumber("sfc_dailyplan");
        pushNeed.setTargetEntityNumber("msplan_otherneedplan");
        pushNeed.setBuildConvReport(true);
        pushNeed.setSelectedRows(needRows);
        return pushNeed;
    }

    public PushArgs staffBill(Long taskId) {
        ArrayList<ListSelectedRow> staffRows = new ArrayList<ListSelectedRow>(16);
        ListSelectedRow selectedRow = new ListSelectedRow((Object)taskId);
        staffRows.add(selectedRow);
        PushArgs pushStaff = new PushArgs();
        pushStaff.setSourceEntityNumber("sfc_dailyplan");
        pushStaff.setTargetEntityNumber("sfc_staffneeds");
        pushStaff.setBuildConvReport(true);
        pushStaff.setSelectedRows(staffRows);
        return pushStaff;
    }

    public PushArgs coorBillApply(Long taskId) {
        ArrayList<ListSelectedRow> coorRows = new ArrayList<ListSelectedRow>(16);
        QFilter filwork = new QFilter("id", "=", (Object)taskId);
        DynamicObjectCollection workNo = QueryServiceHelper.query((String)"sfc_dailyplan", (String)"oprentryentity.orderno", (QFilter[])new QFilter[]{filwork});
        ArrayList<String> checkRepeat = new ArrayList<String>(16);
        for (DynamicObject wno : workNo) {
            String orderNo = wno.getString("oprentryentity.orderno");
            if (checkRepeat.size() == 0) {
                checkRepeat.add(orderNo);
                continue;
            }
            if (checkRepeat.contains(orderNo)) continue;
            checkRepeat.add(orderNo);
        }
        for (int i = 0; i < checkRepeat.size(); ++i) {
            String orderno = (String)checkRepeat.get(i);
            QFilter qFilter = new QFilter("billno", "=", (Object)orderno);
            DynamicObjectCollection mroId = QueryServiceHelper.query((String)"pom_mroorder", (String)"id", (QFilter[])new QFilter[]{qFilter});
            Long pkid = (Long)((DynamicObject)mroId.get(0)).get("id");
            ListSelectedRow selectedRow = new ListSelectedRow((Object)pkid);
            coorRows.add(selectedRow);
        }
        PushArgs pushCoor = new PushArgs();
        pushCoor.setSourceEntityNumber("pom_mroorder");
        pushCoor.setTargetEntityNumber("pom_coordination");
        pushCoor.setBuildConvReport(true);
        pushCoor.setSelectedRows(coorRows);
        return pushCoor;
    }

    public PushArgs reqBillApply(Long taskId) {
        ArrayList<ListSelectedRow> reqRows = new ArrayList<ListSelectedRow>(16);
        ListSelectedRow selectedRow = new ListSelectedRow((Object)taskId);
        reqRows.add(selectedRow);
        PushArgs pushReq = new PushArgs();
        pushReq.setSourceEntityNumber("sfc_dailyplan");
        pushReq.setTargetEntityNumber("im_mdc_mftreqbill");
        pushReq.setBuildConvReport(true);
        pushReq.setSelectedRows(reqRows);
        return pushReq;
    }

    public PushArgs swsBillApply(Long taskId) {
        ArrayList<ListSelectedRow> swsRows = new ArrayList<ListSelectedRow>(16);
        QFilter filwork = new QFilter("id", "=", (Object)taskId);
        DynamicObjectCollection workNo = QueryServiceHelper.query((String)"sfc_dailyplan", (String)"oprentryentity.orderno", (QFilter[])new QFilter[]{filwork});
        for (int i = 0; i < workNo.size(); ++i) {
            String orderno = ((DynamicObject)workNo.get(0)).getString("oprentryentity.orderno");
            QFilter qFilter = new QFilter("billno", "=", (Object)orderno);
            DynamicObjectCollection mroId = QueryServiceHelper.query((String)"pom_mroorder", (String)"id", (QFilter[])new QFilter[]{qFilter});
            Long pkid = (Long)((DynamicObject)mroId.get(0)).get("id");
            ListSelectedRow selectedRow = new ListSelectedRow((Object)pkid);
            swsRows.add(selectedRow);
        }
        PushArgs pushSws = new PushArgs();
        pushSws.setSourceEntityNumber("pom_mroorder");
        pushSws.setTargetEntityNumber("pom_mrosws");
        pushSws.setBuildConvReport(true);
        pushSws.setSelectedRows(swsRows);
        return pushSws;
    }

    public PushArgs nrcBillApply(Long taskId) {
        ArrayList<ListSelectedRow> nrcRows = new ArrayList<ListSelectedRow>(16);
        QFilter filwork = new QFilter("id", "=", (Object)taskId);
        DynamicObjectCollection workNo = QueryServiceHelper.query((String)"sfc_dailyplan", (String)"oprentryentity.orderno", (QFilter[])new QFilter[]{filwork});
        for (int i = 0; i < workNo.size(); ++i) {
            String orderno = ((DynamicObject)workNo.get(0)).getString("oprentryentity.orderno");
            QFilter qFilter = new QFilter("billno", "=", (Object)orderno);
            DynamicObjectCollection mroId = QueryServiceHelper.query((String)"pom_mroorder", (String)"id", (QFilter[])new QFilter[]{qFilter});
            Long pkid = (Long)((DynamicObject)mroId.get(0)).get("id");
            ListSelectedRow selectedRow = new ListSelectedRow((Object)pkid);
            nrcRows.add(selectedRow);
        }
        PushArgs pushNrc = new PushArgs();
        pushNrc.setSourceEntityNumber("pom_mroorder");
        pushNrc.setTargetEntityNumber("pom_mronrc");
        pushNrc.setBuildConvReport(true);
        pushNrc.setSelectedRows(nrcRows);
        return pushNrc;
    }

    public void normalCheck(String operationKey, DynamicObjectCollection entity, int[] selectRows) {
        Long dailyId;
        ArrayList<Long> ids;
        if (entity == null || entity.size() < 1) {
            return;
        }
        if (operationKey.equals("abnormal")) {
            ids = new ArrayList<Long>(16);
            for (int s : selectRows) {
                if (s < 0 || entity.size() < s) continue;
                dailyId = ((DynamicObject)entity.get(s)).getLong("dailyplanid");
                ids.add(dailyId);
            }
            String string = "1";
            this.updateTaskExp(ids, string);
        }
        if (operationKey.equals("normal")) {
            ids = new ArrayList(16);
            for (int s : selectRows) {
                if (s < 0 || entity.size() < s) continue;
                dailyId = ((DynamicObject)entity.get(s)).getLong("dailyplanidab");
                ids.add(dailyId);
            }
            String string = "0";
            this.updateTaskExp(ids, string);
        }
    }

    private void updateTaskExp(List<Long> dailyplanid, String exception) {
        if (dailyplanid == null || dailyplanid.size() < 1) {
            return;
        }
        SqlBuilder sql = new SqlBuilder();
        sql.append("update t_sfc_dailyplan_new set fisexception= ? where ", new Object[]{exception});
        sql.appendIn("fid", dailyplanid.toArray());
        DB.execute((DBRoute)new DBRoute("scm"), (SqlBuilder)sql);
    }

    public void updateTaskName(Long dailyplanid, String taskName) {
        if (dailyplanid == null || dailyplanid.equals(0L)) {
            return;
        }
        SqlBuilder sql = new SqlBuilder();
        sql.append("update t_sfc_dailyplan_new set ftaskname= ? where fid= ?", new Object[]{taskName, dailyplanid});
        DB.execute((DBRoute)new DBRoute("scm"), (SqlBuilder)sql);
    }

    public void updateTaskNote(Long oprEntryid, String note) {
        if (oprEntryid == null || oprEntryid.equals(0L)) {
            return;
        }
        SqlBuilder sql = new SqlBuilder();
        sql.append("update t_sfc_dpentry_opr set fnote= ? where fentryid = ? ", new Object[]{note, oprEntryid});
        DB.execute((DBRoute)new DBRoute("scm"), (SqlBuilder)sql);
    }

    public void openDpForm(IFormPlugin edit, String text) {
        FormShowParameter dpForm = new FormShowParameter();
        Long userId = RequestContext.get().getCurrUserId();
        HashMap<String, Object> cusParam = new HashMap<String, Object>(8);
        cusParam.put("infotext", text);
        cusParam.put("user", userId);
        dpForm.setFormId("sfc_dailyplaninform");
        dpForm.getOpenStyle().setShowType(ShowType.Modal);
        dpForm.setCustomParams(cusParam);
        dpForm.setCloseCallBack(new CloseCallBack(edit, "infotext_information"));
        this.getPlatView().showForm(dpForm);
    }

    public void tranParameter(Object returnData, String dailyId) {
        int i;
        Map listData = (Map)returnData;
        Object informUser = null;
        String infoText = "";
        String subText = "";
        infoText = listData.get("txt");
        informUser = listData.get("informer");
        Object user = listData.get("user");
        DynamicObject dailyBill = BusinessDataServiceHelper.loadSingle((Object)dailyId, (String)"sfc_dailyplan");
        DynamicObjectCollection dailyEntry = dailyBill.getDynamicObjectCollection("oprentryentity");
        DynamicObjectCollection mulDatas = (DynamicObjectCollection)listData.get("baseData");
        for (i = 0; i < dailyEntry.size(); ++i) {
            DynamicObjectCollection dailyMul = ((DynamicObject)dailyEntry.get(i)).getDynamicObjectCollection("multiprofession");
            if (dailyMul.size() == 0) continue;
            dailyMul.clear();
        }
        for (i = 0; i < dailyEntry.size(); ++i) {
            DynamicObjectCollection dailyMulti = ((DynamicObject)dailyEntry.get(i)).getDynamicObjectCollection("multiprofession");
            ((DynamicObject)dailyEntry.get(i)).set("notifier", informUser);
            ((DynamicObject)dailyEntry.get(i)).set("informer", user);
            if (infoText.toString().length() > 20) {
                subText = listData.get("txt").toString().substring(0, 15);
                ((DynamicObject)dailyEntry.get(i)).set("informcontext_tag", (Object)subText);
            } else {
                ((DynamicObject)dailyEntry.get(i)).set("informcontext", (Object)infoText);
            }
            ((DynamicObject)dailyEntry.get(i)).set("informcontext_tag", (Object)infoText);
            for (DynamicObject mulData : mulDatas) {
                DynamicObject baseDataId = mulData.getDynamicObject("fbasedataid");
                DynamicObject setMul = dailyMulti.addNew();
                setMul.set("fbasedataid_id", baseDataId.getPkValue());
            }
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dailyBill});
    }

    public List<Map<String, Object>> infoQuery() {
        DailyPlanFilterBean filterBean = this.buildInfoFilterBean();
        if (filterBean == null) {
            this.platView.showTipNotification(ResManager.loadKDString((String)"\u901a\u77e5\u5176\u4ed6\u884c\u4e1a\u672a\u627e\u5230\u67e5\u8be2\u6761\u4ef6", (String)"DailyPlanHelper_10", (String)"mmc-sfc-business", (Object[])new Object[0]));
            return null;
        }
        DynamicObject infoProfession = filterBean.getInfoProfession();
        Object profes = null;
        if (infoProfession != null) {
            profes = infoProfession.getPkValue();
        }
        DynamicObjectCollection multiPro = filterBean.getMultiPro();
        List infoPro = new ArrayList(16);
        if (multiPro != null && multiPro.size() != 0) {
            infoPro = MulBaseDataUtils.getPkValuesByMulData((DynamicObjectCollection)multiPro);
        }
        DynamicObject informer = filterBean.getInformer();
        DynamicObject receiveUser = filterBean.getReceiveUser();
        Object recu = null;
        Object inf = null;
        if (informer != null) {
            inf = informer.getPkValue();
        }
        if (receiveUser != null) {
            recu = receiveUser.getPkValue();
        }
        boolean switchAnd = filterBean.isIsSwitchToAnd();
        SqlBuilder sql = new SqlBuilder();
        if (switchAnd) {
            if (profes != null && !"0".equals(profes.toString())) {
                sql.append("select tsdn.fid,tsdo.fid,tsdo.fprofessionid,tsdo.fprojectid,tsdo.fmaterialmtcid,tsdo.finformcontext_tag,tsm.fbasedataid,tsdo.fhandlestatus,tsdo.fentryid,tsdn.ftaskname ", new Object[0]);
                sql.append("from t_sfc_dailyplan_new tsdn ", new Object[0]);
                sql.append("inner join t_sfc_dpentry_opr tsdo on tsdn.fid = tsdo.fid ", new Object[0]);
                sql.append("inner join t_sfc_multiprofession tsm on tsm.fentryid =tsdo.fentryid ", new Object[0]);
                sql.append("where tsdo.fprofessionid = ? ", new Object[]{profes});
                if (infoPro.size() != 0) {
                    sql.append("and ", new Object[0]);
                    sql.appendIn("tsm.fbasedataid", infoPro.toArray());
                }
                sql.append("group by tsdn.fid,tsdo.fid,tsdo.fprofessionid,tsdo.fprojectid,tsdo.fmaterialmtcid,tsdo.finformcontext_tag,tsdo.fentryid,tsm.fbasedataid,tsdo.fhandlestatus,tsdn.ftaskname ", new Object[0]);
                sql.append("order by fentryid desc", new Object[0]);
            } else if (infoPro.size() != 0) {
                sql.append("select tsdn.fid,tsdo.fid,tsdo.fprofessionid,tsdo.fprojectid,tsdo.fmaterialmtcid,tsdo.finformcontext_tag,tsm.fbasedataid,tsdo.fhandlestatus,tsdo.fentryid,tsdn.ftaskname ", new Object[0]);
                sql.append("from t_sfc_dailyplan_new tsdn ", new Object[0]);
                sql.append("inner join t_sfc_dpentry_opr tsdo on tsdn.fid = tsdo.fid ", new Object[0]);
                sql.append("inner join t_sfc_multiprofession tsm on tsm.fentryid =tsdo.fentryid where ", new Object[0]);
                sql.appendIn("tsm.fbasedataid", infoPro.toArray());
                sql.append("group by tsdn.fid,tsdo.fid,tsdo.fprofessionid,tsdo.fprojectid,tsdo.fmaterialmtcid,tsdo.finformcontext_tag,tsdo.fentryid,tsm.fbasedataid,tsdo.fhandlestatus,tsdn.ftaskname ", new Object[0]);
                sql.append("order by fentryid desc", new Object[0]);
            } else {
                sql.append("select tsdn.fid,tsdo.fid,tsdo.fprofessionid,tsdo.fprojectid,tsdo.fmaterialmtcid,tsdo.finformcontext_tag,tsm.fbasedataid,tsdo.fhandlestatus,tsdo.fentryid,tsdn.ftaskname ", new Object[0]);
                sql.append("from t_sfc_dailyplan_new tsdn ", new Object[0]);
                sql.append("inner join t_sfc_dpentry_opr tsdo on tsdn.fid = tsdo.fid ", new Object[0]);
                sql.append("inner join t_sfc_multiprofession tsm on tsm.fentryid =tsdo.fentryid ", new Object[0]);
                sql.append("group by tsdn.fid,tsdo.fid,tsdo.fprofessionid,tsdo.fprojectid,tsdo.fmaterialmtcid,tsdo.finformcontext_tag,tsdo.fentryid,tsm.fbasedataid,tsdo.fhandlestatus,tsdn.ftaskname ", new Object[0]);
                sql.append("order by fentryid desc", new Object[0]);
            }
            try (DataSet dailyPlanData = DB.queryDataSet((String)"info_dailyplan_find", (DBRoute)new DBRoute("scm"), (SqlBuilder)sql);){
                ArrayList<Map<String, Object>> ids;
                ArrayList rows = new ArrayList(16);
                for (Row row2 : dailyPlanData) {
                    HashMap<String, Object> oneRow = new HashMap<String, Object>(16);
                    oneRow.put("fid", row2.get("fid"));
                    oneRow.put("fprofessionid", row2.get("fprofessionid"));
                    oneRow.put("fprojectid", row2.get("fprojectid"));
                    oneRow.put("fmaterialmtcid", row2.get("fmaterialmtcid"));
                    oneRow.put("finformcontext_tag", row2.get("finformcontext_tag"));
                    oneRow.put("fhandlestatus", row2.get("fhandlestatus"));
                    oneRow.put("fbasedataid", row2.get("fbasedataid"));
                    oneRow.put("fentryid", row2.get("fentryid"));
                    oneRow.put("ftaskname", row2.get("ftaskname"));
                    rows.add(oneRow);
                }
                if (rows.size() > 1) {
                    int i = 0;
                    int k = 0;
                    int j = 0;
                    while (i + 1 < rows.size()) {
                        if (((Map)rows.get(k)).get("fentryid").equals(((Map)rows.get(i + 1)).get("fentryid"))) {
                            List ids2;
                            if (j == k) {
                                ids2 = new ArrayList(16);
                                ids2.add(((Map)rows.get(k)).get("fbasedataid"));
                                ids2.add(((Map)rows.get(i + 1)).get("fbasedataid"));
                                ((Map)rows.get(k)).put("fbasedataid", ids2);
                                rows.remove(i + 1);
                                ++j;
                                continue;
                            }
                            ids2 = (List)((Map)rows.get(k)).get("fbasedataid");
                            ids2.add(((Map)rows.get(i + 1)).get("fbasedataid"));
                            ((Map)rows.get(k)).put("fbasedataid", ids2);
                            rows.remove(i + 1);
                            ++j;
                            continue;
                        }
                        ++i;
                        j = ++k;
                    }
                } else if (rows.size() == 1) {
                    ids = new ArrayList<Map<String, Object>>(16);
                    ids.add((Map<String, Object>)((Map)rows.get(0)).get("fbasedataid"));
                    ((Map)rows.get(0)).put("fbasedataid", ids);
                } else {
                    ids = null;
                    return ids;
                }
                for (int ins = 0; ins < rows.size(); ++ins) {
                    if (((Map)rows.get(ins)).get("fbasedataid") instanceof List) continue;
                    ArrayList ids3 = new ArrayList(16);
                    ids3.add(((Map)rows.get(ins)).get("fbasedataid"));
                    ((Map)rows.get(ins)).put("fbasedataid", ids3);
                }
                ArrayList<Map<String, Object>> newRows = new ArrayList<Map<String, Object>>(16);
                String properties = "oprentryentity.id AS fentryid";
                ArrayList<QFilter> qfList = new ArrayList<QFilter>(8);
                QFilter filInf = new QFilter("oprentryentity.informer", "=", inf);
                QFilter filRecu = new QFilter("oprentryentity.notifier", "=", recu);
                if (inf != null) {
                    qfList.add(filInf);
                }
                if (recu != null) {
                    qfList.add(filRecu);
                }
                QFilter[] fils = qfList.toArray(new QFilter[0]);
                DataSet userDataSet = QueryServiceHelper.queryDataSet((String)"query_daily_user", (String)"sfc_dailyplan", (String)properties, (QFilter[])fils, null);
                ArrayList oprIds = new ArrayList(16);
                userDataSet.copy().forEach(row -> oprIds.add(row.getLong("fentryid")));
                for (int k = 0; k < rows.size(); ++k) {
                    Object enId = ((Map)rows.get(k)).get("fentryid");
                    if (!oprIds.contains(enId)) continue;
                    newRows.add((Map<String, Object>)rows.get(k));
                }
                ArrayList<Map<String, Object>> k = newRows;
                return k;
            }
        }
        Object profesor = -1L;
        if (infoProfession != null) {
            profesor = infoProfession.getPkValue();
        }
        Object recuor = -1L;
        Object infor = -1L;
        if (informer != null) {
            infor = informer.getPkValue();
        }
        if (receiveUser != null) {
            recuor = receiveUser.getPkValue();
        }
        sql.append("select * from ", new Object[0]);
        sql.append("(select tsdn.fid,tsdo.fid enfid,tsdo.fprofessionid,tsdo.fprojectid,tsdo.fmaterialmtcid,tsdo.finformcontext_tag,tsm.fbasedataid,tsdo.fhandlestatus,tsdo.fentryid,tsdn.ftaskname ", new Object[0]);
        sql.append("from t_sfc_dailyplan_new tsdn ", new Object[0]);
        sql.append("inner join t_sfc_dpentry_opr tsdo on tsdn.fid = tsdo.fid ", new Object[0]);
        sql.append("inner join t_sfc_multiprofession tsm on tsm.fentryid =tsdo.fentryid ", new Object[0]);
        sql.append("where tsdo.fprofessionid = ? ", new Object[]{profesor});
        sql.append("group by tsdn.fid,tsdo.fid,tsdo.fprofessionid,tsdo.fprojectid,tsdo.fmaterialmtcid,tsdo.finformcontext_tag,tsdo.fentryid,tsm.fbasedataid,tsdo.fhandlestatus,tsdn.ftaskname ", new Object[0]);
        if (infoPro.size() != 0) {
            sql.append("union ", new Object[0]);
            sql.append("select tsdn.fid,tsdo.fid enfid,tsdo.fprofessionid,tsdo.fprojectid,tsdo.fmaterialmtcid,tsdo.finformcontext_tag,tsm.fbasedataid,tsdo.fhandlestatus,tsdo.fentryid,tsdn.ftaskname ", new Object[0]);
            sql.append("from t_sfc_dailyplan_new tsdn ", new Object[0]);
            sql.append("inner join t_sfc_dpentry_opr tsdo on tsdn.fid = tsdo.fid ", new Object[0]);
            sql.append("inner join t_sfc_multiprofession tsm on tsm.fentryid =tsdo.fentryid where ", new Object[0]);
            sql.appendIn("tsm.fbasedataid", infoPro.toArray());
            sql.append("group by tsdn.fid,tsdo.fid,tsdo.fprofessionid,tsdo.fprojectid,tsdo.fmaterialmtcid,tsdo.finformcontext_tag,tsdo.fentryid,tsm.fbasedataid,tsdo.fhandlestatus,tsdn.ftaskname ", new Object[0]);
        }
        sql.append(") as a order by fentryid desc", new Object[0]);
        String properties = "oprentryentity.id AS fentryid";
        QFilter filInf = new QFilter("oprentryentity.informer", "=", infor);
        QFilter filRecu = new QFilter("oprentryentity.notifier", "=", recuor);
        QFilter fil = filInf.or(filRecu);
        DataSet userDataSet = QueryServiceHelper.queryDataSet((String)"query_daily_user", (String)"sfc_dailyplan", (String)properties, (QFilter[])new QFilter[]{fil}, null);
        ArrayList<Long> oprIds = new ArrayList<Long>(16);
        userDataSet.copy().forEach(row -> oprIds.add(row.getLong("fentryid")));
        if (oprIds.size() == 0) {
            oprIds.add(-1L);
        }
        SqlBuilder sqlUser = new SqlBuilder();
        sqlUser.append("select tsdn.fid,tsdo.fid enfid,tsdo.fprofessionid,tsdo.fprojectid,tsdo.fmaterialmtcid,tsdo.finformcontext_tag,tsm.fbasedataid,tsdo.fhandlestatus,tsdo.fentryid,tsdn.ftaskname ", new Object[0]);
        sqlUser.append("from t_sfc_dailyplan_new tsdn ", new Object[0]);
        sqlUser.append("inner join t_sfc_dpentry_opr tsdo on tsdn.fid = tsdo.fid ", new Object[0]);
        sqlUser.append("inner join t_sfc_multiprofession tsm on tsm.fentryid = tsdo.fentryid where ", new Object[0]);
        sqlUser.appendIn("tsdo.fentryid", oprIds.toArray());
        sqlUser.append("group by tsdn.fid,tsdo.fid,tsdo.fprofessionid,tsdo.fprojectid,tsdo.fmaterialmtcid,tsdo.finformcontext_tag,tsdo.fentryid,tsm.fbasedataid,tsdo.fhandlestatus,tsdn.ftaskname", new Object[0]);
        DataSet userData = DB.queryDataSet((String)"info_dailyuser_find", (DBRoute)new DBRoute("scm"), (SqlBuilder)sqlUser);
        DataSet planData = DB.queryDataSet((String)"info_dailyplan_find", (DBRoute)new DBRoute("scm"), (SqlBuilder)sql);
        DataSet allData = planData.union(userData);
        ArrayList<Map<String, Object>> rows = new ArrayList<Map<String, Object>>(16);
        for (Row row3 : allData) {
            HashMap<String, Object> oneRow = new HashMap<String, Object>(16);
            oneRow.put("fid", row3.get("fid"));
            oneRow.put("fprofessionid", row3.get("fprofessionid"));
            oneRow.put("fprojectid", row3.get("fprojectid"));
            oneRow.put("fmaterialmtcid", row3.get("fmaterialmtcid"));
            oneRow.put("finformcontext_tag", row3.get("finformcontext_tag"));
            oneRow.put("fhandlestatus", row3.get("fhandlestatus"));
            oneRow.put("fbasedataid", row3.get("fbasedataid"));
            oneRow.put("fentryid", row3.get("fentryid"));
            oneRow.put("ftaskname", row3.get("ftaskname"));
            rows.add(oneRow);
        }
        if (rows.size() > 1) {
            int i = 0;
            int k = 0;
            int j = 0;
            while (i + 1 < rows.size()) {
                if (((Map)rows.get(k)).get("fentryid").equals(((Map)rows.get(i + 1)).get("fentryid"))) {
                    List ids;
                    if (j == k) {
                        ids = new ArrayList(16);
                        ids.add(((Map)rows.get(k)).get("fbasedataid"));
                        ids.add(((Map)rows.get(i + 1)).get("fbasedataid"));
                        ((Map)rows.get(k)).put("fbasedataid", ids);
                        rows.remove(i + 1);
                        ++j;
                        continue;
                    }
                    ids = (List)((Map)rows.get(k)).get("fbasedataid");
                    ids.add(((Map)rows.get(i + 1)).get("fbasedataid"));
                    ((Map)rows.get(k)).put("fbasedataid", ids);
                    rows.remove(i + 1);
                    ++j;
                    continue;
                }
                ++i;
                j = ++k;
            }
        } else if (rows.size() == 1) {
            ArrayList ids = new ArrayList(16);
            ids.add(((Map)rows.get(0)).get("fbasedataid"));
            ((Map)rows.get(0)).put("fbasedataid", ids);
        } else {
            return null;
        }
        for (int ins = 0; ins < rows.size(); ++ins) {
            if (((Map)rows.get(ins)).get("fbasedataid") instanceof List) continue;
            ArrayList ids = new ArrayList(16);
            ids.add(((Map)rows.get(ins)).get("fbasedataid"));
            ((Map)rows.get(ins)).put("fbasedataid", ids);
        }
        return rows;
    }

    public List<Map<String, Object>> infoQueryForTab() {
        Long recuor = RequestContext.get().getCurrUserId();
        Long infor = RequestContext.get().getCurrUserId();
        String properties = "oprentryentity.id AS fentryid";
        QFilter filInf = new QFilter("oprentryentity.informer", "=", (Object)infor);
        QFilter filRecu = new QFilter("oprentryentity.notifier", "=", (Object)recuor);
        QFilter fil = filInf.or(filRecu);
        DataSet userDataSet = QueryServiceHelper.queryDataSet((String)"query_daily_user", (String)"sfc_dailyplan", (String)properties, (QFilter[])new QFilter[]{fil}, null);
        ArrayList<Long> oprIds = new ArrayList<Long>(16);
        userDataSet.copy().forEach(row -> oprIds.add(row.getLong("fentryid")));
        if (oprIds.size() == 0) {
            oprIds.add(-1L);
        }
        SqlBuilder sqlUser = new SqlBuilder();
        sqlUser.append("select tsdn.fid,tsdo.fid enfid,tsdo.fprofessionid,tsdo.fprojectid,tsdo.fmaterialmtcid,tsdo.finformcontext_tag,tsm.fbasedataid,tsdo.fhandlestatus,tsdo.fentryid,tsdn.ftaskname ", new Object[0]);
        sqlUser.append("from t_sfc_dailyplan_new tsdn ", new Object[0]);
        sqlUser.append("inner join t_sfc_dpentry_opr tsdo on tsdn.fid = tsdo.fid ", new Object[0]);
        sqlUser.append("inner join t_sfc_multiprofession tsm on tsm.fentryid = tsdo.fentryid where ", new Object[0]);
        sqlUser.appendIn("tsdo.fentryid", oprIds.toArray());
        sqlUser.append("group by tsdn.fid,tsdo.fid,tsdo.fprofessionid,tsdo.fprojectid,tsdo.fmaterialmtcid,tsdo.finformcontext_tag,tsdo.fentryid,tsm.fbasedataid,tsdo.fhandlestatus,tsdn.ftaskname", new Object[0]);
        DataSet userData = DB.queryDataSet((String)"info_dailyuser_find", (DBRoute)new DBRoute("scm"), (SqlBuilder)sqlUser);
        ArrayList<Map<String, Object>> rows = new ArrayList<Map<String, Object>>(16);
        for (Row row2 : userData) {
            HashMap<String, Object> oneRow = new HashMap<String, Object>(16);
            oneRow.put("fid", row2.get("fid"));
            oneRow.put("fprofessionid", row2.get("fprofessionid"));
            oneRow.put("fprojectid", row2.get("fprojectid"));
            oneRow.put("fmaterialmtcid", row2.get("fmaterialmtcid"));
            oneRow.put("finformcontext_tag", row2.get("finformcontext_tag"));
            oneRow.put("fhandlestatus", row2.get("fhandlestatus"));
            oneRow.put("fbasedataid", row2.get("fbasedataid"));
            oneRow.put("fentryid", row2.get("fentryid"));
            oneRow.put("ftaskname", row2.get("ftaskname"));
            rows.add(oneRow);
        }
        if (rows.size() > 1) {
            int i = 0;
            int k = 0;
            int j = 0;
            while (i + 1 < rows.size()) {
                if (((Map)rows.get(k)).get("fentryid").equals(((Map)rows.get(i + 1)).get("fentryid"))) {
                    List ids;
                    if (j == k) {
                        ids = new ArrayList(16);
                        ids.add(((Map)rows.get(k)).get("fbasedataid"));
                        ids.add(((Map)rows.get(i + 1)).get("fbasedataid"));
                        ((Map)rows.get(k)).put("fbasedataid", ids);
                        rows.remove(i + 1);
                        ++j;
                        continue;
                    }
                    ids = (List)((Map)rows.get(k)).get("fbasedataid");
                    ids.add(((Map)rows.get(i + 1)).get("fbasedataid"));
                    ((Map)rows.get(k)).put("fbasedataid", ids);
                    rows.remove(i + 1);
                    ++j;
                    continue;
                }
                ++i;
                j = ++k;
            }
        } else if (rows.size() == 1) {
            ArrayList ids = new ArrayList(16);
            ids.add(((Map)rows.get(0)).get("fbasedataid"));
            ((Map)rows.get(0)).put("fbasedataid", ids);
        } else {
            return null;
        }
        for (int ins = 0; ins < rows.size(); ++ins) {
            if (((Map)rows.get(ins)).get("fbasedataid") instanceof List) continue;
            ArrayList ids = new ArrayList(16);
            ids.add(((Map)rows.get(ins)).get("fbasedataid"));
            ((Map)rows.get(ins)).put("fbasedataid", ids);
        }
        return rows;
    }

    public DailyPlanFilterBean buildInfoFilterBean() {
        long currentUserId = UserServiceHelper.getCurrentUserId();
        QFilter filter = new QFilter("user", "=", (Object)currentUserId);
        DynamicObject loadSingle = BusinessDataServiceHelper.loadSingle((String)"sfc_dailyplan_filter", (String)"infoprofession,multipro,informer,receiveuser,isswitchtoand", (QFilter[])filter.toArray());
        if (loadSingle != null) {
            DailyPlanFilterBean bean = new DailyPlanFilterBean();
            DynamicObject infoProfession = loadSingle.getDynamicObject("infoprofession");
            bean.setInfoProfession(infoProfession);
            DynamicObjectCollection multiPro = loadSingle.getDynamicObjectCollection("multipro");
            bean.setMultiPro(multiPro);
            DynamicObject informer = loadSingle.getDynamicObject("informer");
            bean.setInformer(informer);
            DynamicObject receiveUser = loadSingle.getDynamicObject("receiveuser");
            bean.setReceiveUser(receiveUser);
            boolean isSwitchToAnd = loadSingle.getBoolean("isswitchtoand");
            bean.setSwitchToAnd(isSwitchToAnd);
            return bean;
        }
        return null;
    }

    public static String getTaskType(String taskID, Long dataIndex) {
        QFilter filter = new QFilter("id", "=", (Object)Long.valueOf(taskID));
        Date beginTime = null;
        Date endTime = null;
        Calendar c = Calendar.getInstance();
        c.setTimeInMillis(dataIndex);
        Date indexTime = c.getTime();
        Boolean isImportant = Boolean.FALSE;
        try (DataSet queryDataSet = QueryServiceHelper.queryDataSet((String)"DailyPlanHelper_QueryTaskStatus", (String)"sfc_dailyplan", (String)"isimportant,begintime,endtime", (QFilter[])filter.toArray(), null);){
            for (Row row : queryDataSet) {
                isImportant = row.getBoolean("isimportant");
                beginTime = row.getDate("begintime");
                endTime = row.getDate("endtime");
            }
        }
        Boolean isOutRange = Boolean.FALSE;
        if (beginTime != null && endTime != null && (indexTime.compareTo(beginTime) < 0 || indexTime.compareTo(endTime) > 0)) {
            isOutRange = Boolean.TRUE;
        }
        if (isImportant.booleanValue() && isOutRange.booleanValue()) {
            return "both";
        }
        if (isImportant.booleanValue()) {
            return "important";
        }
        if (isOutRange.booleanValue()) {
            return "error";
        }
        return null;
    }
}

