/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.sfc.business.dailyplan;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bd.mpdm.common.utils.MulBaseDataUtils;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.entity.botp.runtime.ConvertOperationResult;
import kd.bos.entity.botp.runtime.PushArgs;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.botp.ConvertServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.mmc.sfc.common.dailyplan.bean.DailyPlanCoorFilterBean;

public class DailyPlanToCoorHelper {
    private static final Log logger = LogFactory.getLog(DailyPlanToCoorHelper.class);
    private IFormView platView;
    private int maxDays;
    private Date startDate;
    private Set<Object> coorPKs;

    public IFormView getPlatView() {
        return this.platView;
    }

    public void setPlatView(IFormView platView) {
        this.platView = platView;
    }

    public int getMaxDays() {
        return this.maxDays;
    }

    public void setMaxDays(int maxDays) {
        this.maxDays = maxDays;
    }

    public Date getStartDate() {
        return this.startDate;
    }

    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }

    public Set<Object> getCoorPKs() {
        return this.coorPKs;
    }

    public void setCoorPKs(Set<Object> coorPKs) {
        this.coorPKs = coorPKs;
    }

    public void createCoorDailyPlan() {
        DailyPlanCoorFilterBean filterBean = this.buildCoorFilterBean();
        if (filterBean == null) {
            this.platView.showTipNotification(ResManager.loadKDString((String)"\u672a\u627e\u5230\u67e5\u8be2\u6761\u4ef6\uff0c\u8bf7\u5f55\u5165\u67e5\u8be2\u6761\u4ef6", (String)"DailyPlanToCoorHelper_0", (String)"mmc-sfc-business", (Object[])new Object[0]));
            return;
        }
        this.createDailyPlanFromCoor(filterBean);
    }

    private void createDailyPlanFromCoor(DailyPlanCoorFilterBean filterBean) {
        Set<QFilter> createCoorFilter = this.createCoorFilter(filterBean);
        ArrayList<Long> listCoor = new ArrayList<Long>(8);
        int i = 0;
        try (DataSet coorDS = QueryServiceHelper.queryDataSet((String)"DailyPlanHelper_queryCoordination_co", (String)"pom_coordination", (String)"id", (QFilter[])createCoorFilter.toArray(new QFilter[0]), null);){
            for (Row row : coorDS) {
                Object id = row.get("id");
                listCoor.add(i, (Long)id);
                ++i;
            }
        }
        List<Long> dailyPlanCoorData = this.getDailyPlanCoorData();
        ArrayList newListCoor = new ArrayList(16);
        int nlc = 0;
        for (int k = 0; k < listCoor.size(); ++k) {
            if (dailyPlanCoorData.contains(listCoor.get(k))) continue;
            newListCoor.add(nlc, listCoor.get(k));
            ++nlc;
        }
        if (newListCoor.isEmpty()) {
            return;
        }
        ArrayList<Long> ridList = new ArrayList<Long>(16);
        QFilter coFil = new QFilter("id", "in", newListCoor);
        DynamicObjectCollection newLC = QueryServiceHelper.query((String)"pom_coordination", (String)"id,billtype,isairproject,businessstatus", (QFilter[])new QFilter[]{coFil});
        for (DynamicObject data : newLC) {
            boolean c = false;
            DynamicObjectCollection task = null;
            Long idLC = data.getLong("id");
            Object srcBillType = data.get("billtype");
            Object srcIsAir = data.get("isairproject");
            String srcStatus = data.get("businessstatus").toString();
            QFilter qFilter = new QFilter("crossindustrycoordtype", "=", srcBillType);
            if (Boolean.parseBoolean(srcIsAir.toString())) {
                task = QueryServiceHelper.query((String)"fmm_croindustrycotype", (String)"prodailytasks", (QFilter[])new QFilter[]{qFilter});
                if (task != null && task.size() != 0) {
                    for (DynamicObject checkTask : task) {
                        if (checkTask.getLong("prodailytasks") == 0L) continue;
                        c = true;
                        break;
                    }
                }
            } else {
                task = QueryServiceHelper.query((String)"fmm_croindustrycotype", (String)"campadailytasks", (QFilter[])new QFilter[]{qFilter});
                if (task != null && task.size() != 0) {
                    for (DynamicObject checkTask : task) {
                        if (checkTask.getLong("campadailytasks") == 0L) continue;
                        c = true;
                        break;
                    }
                }
            }
            if (srcStatus == null || !srcStatus.equals("B") || task == null || task.size() == 0 || !c) continue;
            ridList.add(idLC);
        }
        if (ridList.isEmpty()) {
            return;
        }
        PushArgs pushArgs = new PushArgs();
        pushArgs.setSourceEntityNumber("pom_coordination");
        pushArgs.setTargetEntityNumber("sfc_dailyplan");
        pushArgs.setBuildConvReport(true);
        ArrayList<ListSelectedRow> needPushRows = new ArrayList<ListSelectedRow>(10);
        for (int k = 0; k < ridList.size(); ++k) {
            ListSelectedRow srcBill = new ListSelectedRow(ridList.get(k));
            needPushRows.add(srcBill);
        }
        if (needPushRows.isEmpty()) {
            logger.info("\u5bf9\u5e94\u7684\u5de5\u5e8f\u8ba1\u5212\u6ca1\u6709\u9700\u8981\u4e0b\u63a8\u7684\u6570\u636e\u3002");
        }
        pushArgs.setSelectedRows(needPushRows);
        ConvertOperationResult pushResult = ConvertServiceHelper.pushAndSave((PushArgs)pushArgs);
        if (!pushResult.isSuccess()) {
            this.platView.showTipNotification(ResManager.loadKDString((String)"\u8de8\u884c\u4e1a\u534f\u8c03\u5355\u4e0b\u63a8\u65e5\u8ba1\u5212\u5931\u8d25,\u539f\u56e0\u8bf7\u67e5\u770b\u76d1\u63a7\u65e5\u5fd7", (String)"DailyPlanToCoorHelper_1", (String)"mmc-sfc-business", (Object[])new Object[0]));
        }
    }

    public List<Long> getDailyPlanCoorData() {
        List<Long> planData = this.getDailyPlanCoorExists();
        return planData;
    }

    private List<Long> getDailyPlanCoorExists() {
        ArrayList<Long> planData = new ArrayList<Long>(8);
        QFilter filter = new QFilter("oprentryentity.srcbillid", ">", (Object)0);
        try (DataSet dsDaily = QueryServiceHelper.queryDataSet((String)"CoorToDailyPlan_alldaily_co", (String)"sfc_dailyplan", (String)"oprentryentity.srcbillid", (QFilter[])filter.toArray(), null);){
            int j = 0;
            for (Row row : dsDaily) {
                Long srcbillid = row.getLong("oprentryentity.srcbillid");
                planData.add(j, srcbillid);
                ++j;
            }
        }
        return planData;
    }

    private Set<QFilter> createCoorFilter(DailyPlanCoorFilterBean filterBean) {
        Date hopeTime;
        Date provideTime;
        DynamicObject cotype;
        DynamicObjectCollection coproject;
        DynamicObject coprofession;
        HashSet<QFilter> filters = new HashSet<QFilter>(8);
        boolean isPlaneProject = filterBean.getIsPlaneProject();
        if (isPlaneProject) {
            filters.add(new QFilter("projectno", ">", (Object)0));
        }
        if ((coprofession = filterBean.getCoprofession()) != null) {
            filters.add(new QFilter("recipitrade", "=", coprofession.getPkValue()));
        }
        if ((coproject = filterBean.getCoproject()) != null && !coproject.isEmpty()) {
            List projects = MulBaseDataUtils.getPkValuesByMulData((DynamicObjectCollection)coproject);
            if (!isPlaneProject) {
                QFilter fil = new QFilter("projectno", "in", (Object)projects);
                filters.add(fil.or(new QFilter("projectno", "=", (Object)0)));
            } else {
                filters.add(new QFilter("projectno", "in", (Object)projects));
            }
        }
        if ((cotype = filterBean.getCotype()) != null) {
            filters.add(new QFilter("billtype", "=", cotype.getPkValue()));
        }
        if ((provideTime = filterBean.getProvideTime()) != null) {
            filters.add(new QFilter("providdate", ">=", (Object)provideTime));
        }
        if ((hopeTime = filterBean.getHopeTime()) != null) {
            filters.add(new QFilter("expenddate", ">=", (Object)hopeTime));
        }
        if (filters.size() == 0) {
            filters.add(new QFilter("projectno", "=", (Object)0));
        }
        return filters;
    }

    public DailyPlanCoorFilterBean buildCoorFilterBean() {
        long currentUserId = UserServiceHelper.getCurrentUserId();
        QFilter filter = new QFilter("couser", "=", (Object)currentUserId);
        DynamicObject loadSingle = BusinessDataServiceHelper.loadSingle((String)"sfc_dailycoor_filter", (String)"isplaneproject,coproject,coprofession,cotype,providetime,hopetime", (QFilter[])filter.toArray());
        if (loadSingle != null) {
            DailyPlanCoorFilterBean bean = new DailyPlanCoorFilterBean();
            boolean isPlaneProject = loadSingle.getBoolean("isplaneproject");
            bean.setIsPlaneProject(isPlaneProject);
            bean.setCoproject(loadSingle.getDynamicObjectCollection("coproject"));
            DynamicObject coprofession = loadSingle.getDynamicObject("coprofession");
            bean.setCoprofession(coprofession);
            DynamicObject cotype = loadSingle.getDynamicObject("cotype");
            bean.setCotype(cotype);
            Date provideTime = loadSingle.getDate("providetime");
            bean.setProvideTime(provideTime);
            Date hopeTime = loadSingle.getDate("hopetime");
            bean.setHopeTime(hopeTime);
            return bean;
        }
        return null;
    }

    public List<Map<String, Object>> coorQuery() {
        String time;
        Long typeid;
        List coPro;
        Long cofid;
        DailyPlanCoorFilterBean filterBean = this.buildCoorFilterBean();
        if (filterBean == null) {
            this.platView.showTipNotification(ResManager.loadKDString((String)"\u8de8\u884c\u4e1a\u534f\u8c03\u672a\u627e\u5230\u67e5\u8be2\u6761\u4ef6", (String)"DailyPlanToCoorHelper_2", (String)"mmc-sfc-business", (Object[])new Object[0]));
            List<Map<String, Object>> check = null;
            return check;
        }
        boolean isPlaneProject = filterBean.getIsPlaneProject();
        DynamicObject coprofession = filterBean.getCoprofession();
        DynamicObjectCollection coproject = filterBean.getCoproject();
        DynamicObject cotype = filterBean.getCotype();
        Date provideTime = filterBean.getProvideTime();
        Date hopeTime = filterBean.getHopeTime();
        SqlBuilder sql = new SqlBuilder();
        sql.append("select tsdn.ftasktype,tsdn.ftaskname,tsdn.fallocationstatus,tsdn.fid,tpc.fbillno ", new Object[0]);
        sql.append("from t_sfc_dailyplan_new tsdn ", new Object[0]);
        sql.append("inner join t_sfc_dpentry_opr tsdo on tsdo.fid = tsdn.fid ", new Object[0]);
        sql.append("inner join t_pom_coordination tpc on tsdo.fsrcbillid = tpc.fid ", new Object[0]);
        sql.append("where ", new Object[0]);
        if (isPlaneProject) {
            sql.append("tpc.fprojectno > 0 ", new Object[0]);
            if (coprofession != null) {
                cofid = Long.parseLong(coprofession.getPkValue().toString());
                sql.append("and ", new Object[0]);
                sql.append(String.format("tpc.frecipitrade = %1$d ", cofid), new Object[0]);
            }
            if (coproject != null && !coproject.isEmpty()) {
                coPro = MulBaseDataUtils.getPkValuesByMulData((DynamicObjectCollection)coproject);
                sql.append("and ", new Object[0]);
                sql.appendIn("tpc.fprojectno", coPro.toArray());
            }
            if (cotype != null) {
                typeid = Long.parseLong(cotype.getPkValue().toString());
                sql.append(" and ", new Object[0]);
                sql.append(String.format("tpc.fbilltype = %1$d ", typeid), new Object[0]);
            }
            if (provideTime != null) {
                time = provideTime.toString();
                sql.append("and ", new Object[0]);
                sql.append(String.format("tpc.fproviddate > '%1$s' ", time), new Object[0]);
            }
            if (hopeTime != null) {
                time = hopeTime.toString();
                sql.append("and ", new Object[0]);
                sql.append(String.format("tpc.fenddate > '%1$s' ", time), new Object[0]);
            }
        } else {
            if (coproject != null && !coproject.isEmpty()) {
                coPro = MulBaseDataUtils.getPkValuesByMulData((DynamicObjectCollection)coproject);
                sql.appendIn("tpc.fprojectno", coPro.toArray());
            } else {
                sql.append("tpc.fid > 0 ", new Object[0]);
            }
            if (coprofession != null) {
                cofid = Long.parseLong(coprofession.getPkValue().toString());
                sql.append("and ", new Object[0]);
                sql.append(String.format("tpc.frecipitrade = %1$d ", cofid), new Object[0]);
            }
            if (cotype != null) {
                typeid = Long.parseLong(cotype.getPkValue().toString());
                sql.append("and ", new Object[0]);
                sql.append(String.format("tpc.fbilltype = %1$d ", typeid), new Object[0]);
            }
            if (provideTime != null) {
                time = provideTime.toString();
                sql.append("and ", new Object[0]);
                sql.append(String.format("tpc.fproviddate > '%1$s' ", time), new Object[0]);
            }
            if (hopeTime != null) {
                time = hopeTime.toString();
                sql.append("and ", new Object[0]);
                sql.append(String.format("tpc.fenddate > '%1$s' ", time), new Object[0]);
            }
            sql.append("union ", new Object[0]);
            sql.append("select tsdn.ftasktype,tsdn.ftaskname,tsdn.fallocationstatus,tsdn.fid,tpc.fbillno ", new Object[0]);
            sql.append("from t_sfc_dailyplan_new tsdn ", new Object[0]);
            sql.append("inner join t_sfc_dpentry_opr tsdo on tsdo.fid = tsdn.fid ", new Object[0]);
            sql.append("inner join t_pom_coordination tpc on tsdo.fsrcbillid = tpc.fid ", new Object[0]);
            sql.append("where ", new Object[0]);
            sql.append("tpc.fprojectno = 0 ", new Object[0]);
        }
        try (DataSet dataSet = DB.queryDataSet((String)"coor_dailyplan_find", (DBRoute)new DBRoute("scm"), (SqlBuilder)sql);){
            ArrayList rows = new ArrayList(16);
            for (Row row : dataSet) {
                HashMap<String, Object> oneRow = new HashMap<String, Object>(16);
                oneRow.put("fid", row.get("fid"));
                oneRow.put("fbillno", row.get("fbillno"));
                oneRow.put("ftasktype", row.get("ftasktype"));
                oneRow.put("ftaskname", row.get("ftaskname"));
                oneRow.put("fallocationstatus", row.get("fallocationstatus"));
                rows.add(oneRow);
            }
            ArrayList arrayList = rows;
            return arrayList;
        }
    }
}

