/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.sfc.business.manuftech;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bd.mpdm.common.utils.AuxQtyAndUnitHelper;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.ExtendedDataEntitySet;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.plugin.args.AfterConvertEventArgs;
import kd.bos.org.model.OrgRelationParam;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.mmc.sfc.business.manuftech.OrgHelper;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;

public class ManftechToOmPurOrderBillHelp {
    public static void handlePurOrder(AfterConvertEventArgs e, String tgtEntity) {
        ExtendedDataEntitySet entitySet = e.getTargetExtDataEntitySet();
        ExtendedDataEntity[] entitys = entitySet.FindByEntityKey(tgtEntity);
        List bills = Arrays.stream(entitys).map(ExtendedDataEntity::getDataEntity).collect(Collectors.toList());
        if (!bills.isEmpty()) {
            List dynamicObjects = (List)DispatchServiceHelper.invokeBizService((String)"scmc", (String)"pm", (String)"PurOrderService", (String)"batchSetPODefValue", (Object[])new Object[]{bills});
            MainEntityType mainType = (MainEntityType)((DynamicObject)bills.get(0)).getDataEntityType();
            entitySet.Parse(dynamicObjects.toArray(new DynamicObject[0]), mainType);
            e.setTargetExtDataEntitySet(entitySet);
            ManftechToOmPurOrderBillHelp.setEntryPayOrg(e.getTargetExtDataEntitySet().FindByEntityKey(tgtEntity));
            ManftechToOmPurOrderBillHelp.setToSettleOrg(e.getTargetExtDataEntitySet().FindByEntityKey(tgtEntity));
        }
    }

    public static void setEntryPayOrg(ExtendedDataEntity[] entitys) {
        Set orgIds = Arrays.stream(entitys).filter(x -> x.getDataEntity().getDynamicObject("org") != null).map(x -> x.getDataEntity().getDynamicObject("org").getLong("id")).collect(Collectors.toSet());
        QFilter filter = new QFilter("fromorg", "in", orgIds);
        filter.and(new QFilter("isdefaulttoorg", "=", (Object)"1"));
        Map dept = BusinessDataServiceHelper.loadFromCache((String)"bos_org_orgrelation_dept", (String)"id,fromorg,toorg", (QFilter[])new QFilter[]{filter});
        for (ExtendedDataEntity dataEntity : entitys) {
            DynamicObject obj = dataEntity.getDataEntity();
            if (obj.getDynamicObject("org") == null) {
                List allOrg = OrgUnitServiceHelper.getAllOrg((String)"02");
                obj.set("org", (Object)BusinessDataServiceHelper.loadSingleFromCache(allOrg.get(0), (String)"bos_org", (String)"id"));
            }
            DynamicObject org = obj.getDynamicObject("org");
            List fromOrg = dept.values().stream().filter(x -> Objects.equals(org.getPkValue(), x.getDynamicObject("fromorg").getPkValue())).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(fromOrg)) {
                obj.set("dept", (Object)((DynamicObject)fromOrg.get(0)).getDynamicObject("toorg"));
            }
            DynamicObjectCollection dynamicObjectCollection = dataEntity.getDataEntity().getDynamicObjectCollection("billentry");
            for (DynamicObject object : dynamicObjectCollection) {
                AuxQtyAndUnitHelper.changeUntAndQty((DynamicObject)object, (DynamicObject)object.getDynamicObject("materialmasterid"), (DynamicObject)object.getDynamicObject("auxunit"), (String)"baseqty", (String)"baseunit", (String)"auxqty");
                if (object.getDynamicObject("entrysettleorg") == null) continue;
                if (object.getDynamicObject("entrysettleorg").getBoolean("fisbankroll")) {
                    object.set("entrypayorg", (Object)object.getDynamicObject("entrysettleorg"));
                    continue;
                }
                OrgRelationParam param = OrgHelper.buildOrgRelationParam(object.getDynamicObject("entrysettleorg").getLong("id"), "10", "08", "toorg");
                param.setIncludeSelf(true);
                List allToOrg = OrgUnitServiceHelper.getBizRelationOrgIds((OrgRelationParam)param);
                if (!CollectionUtils.isNotEmpty((Collection)allToOrg)) continue;
                object.set("entrypayorg", (Object)BusinessDataServiceHelper.loadSingleFromCache(allToOrg.get(0), (String)"bos_org", (String)"id"));
            }
        }
    }

    public static void setToSettleOrg(ExtendedDataEntity[] entitys) {
        Set internalCompanyIds = Arrays.stream(entitys).filter(x -> x.getDataEntity().getDynamicObject("internal_company") != null).map(x -> x.getDataEntity().getDynamicObject("internal_company").getLong("id")).collect(Collectors.toSet());
        HashMap<Long, Integer> data = new HashMap<Long, Integer>(16);
        Iterator iterator = internalCompanyIds.iterator();
        while (iterator.hasNext()) {
            Long id;
            Map map = OrgUnitServiceHelper.getCompanyByOrg((Long)(id = (Long)iterator.next()), (Boolean)Boolean.FALSE, (Boolean)Boolean.TRUE);
            data.put(id, MapUtils.isEmpty((Map)map) ? Integer.valueOf(0) : map.get("id"));
        }
        Map objectDynamicObjectMap = BusinessDataServiceHelper.loadFromCache((String)"bos_org", (String)"id", (QFilter[])new QFilter[]{new QFilter("id", "in", data.values())});
        for (ExtendedDataEntity dataEntity : entitys) {
            DynamicObject obj = dataEntity.getDataEntity();
            if (obj.getDynamicObject("internal_company") == null) continue;
            obj.set("tosettleorg", objectDynamicObjectMap.get(data.get(obj.getDynamicObject("internal_company").getLong("id"))));
        }
    }
}

