/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.sfc.business.manuftech;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.servicehelper.TimeServiceHelper;

public class ManuftecMergeChecker {
    public static void checkManuftech(DynamicObject[] manuftechs, Map<Object, String> idNoMapping) {
        if (manuftechs == null || manuftechs.length < 1) {
            return;
        }
        HashSet<Object> orgSet = new HashSet<Object>(manuftechs.length);
        HashSet<Object> billTypeSet = new HashSet<Object>(manuftechs.length);
        HashSet<String> planTypeSet = new HashSet<String>(manuftechs.length);
        HashSet<String> billStatusSet = new HashSet<String>(manuftechs.length);
        HashSet<Object> transacationSet = new HashSet<Object>(manuftechs.length);
        HashSet<Object> productSet = new HashSet<Object>(manuftechs.length);
        HashSet<Object> configCodeSet = new HashSet<Object>(manuftechs.length);
        HashSet<Object> trackNumberCodeSet = new HashSet<Object>(manuftechs.length);
        HashSet<Object> baseUnitSet = new HashSet<Object>(manuftechs.length);
        HashSet<Object> bomSet = new HashSet<Object>(manuftechs.length);
        HashSet<Object> processRouteSet = new HashSet<Object>(manuftechs.length);
        int proentrySize = manuftechs[0].getDynamicObjectCollection("proentryentity").size();
        HashSet<String> processseqClassify = new HashSet<String>(16);
        HashMap<String, List<DynamicObject>> proentryMap = new HashMap<String, List<DynamicObject>>(16);
        HashSet<String> oprnoClassify = new HashSet<String>(16);
        HashMap<String, List<DynamicObject>> entryMap = new HashMap<String, List<DynamicObject>>(16);
        int oprentrySize = manuftechs[0].getDynamicObjectCollection("oprentryentity").size();
        for (int i = 0; i < manuftechs.length; ++i) {
            DynamicObject manuftech = manuftechs[i];
            String billNo = manuftech.get("billno") == null ? "" : manuftech.getString("billno");
            idNoMapping.remove(manuftech.get("manufactureorderid"));
            ManuftecMergeChecker.checkManuftechHead(orgSet, billTypeSet, planTypeSet, billStatusSet, transacationSet, productSet, configCodeSet, trackNumberCodeSet, baseUnitSet, bomSet, processRouteSet, manuftech, billNo);
            DynamicObjectCollection proentrys = manuftech.getDynamicObjectCollection("proentryentity");
            if (i != 0 && proentrys.size() != proentrySize) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\u8ba1\u5212\u5408\u5e76\u5931\u8d25\uff0c\u5de5\u5e8f\u5e8f\u5217\u5217\u8868\u7684\u884c\u6570\u4e0d\u4e00\u81f4\u3002", (String)"ManuftecMergeChecker_0", (String)"mmc-sfc-business", (Object[])new Object[0]), new Object[0]));
            }
            for (DynamicObject proentry : proentrys) {
                String processseq = proentry.getString("processseq");
                proentryMap.computeIfAbsent(processseq, k -> new ArrayList(10)).add(proentry);
                if (i == 0) {
                    processseqClassify.add(processseq);
                    continue;
                }
                if (processseqClassify.contains(processseq)) continue;
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\u8ba1\u5212\u5408\u5e76\u5931\u8d25\uff0c\u5de5\u5e8f\u5e8f\u5217\u5217\u8868\u4e0d\u5305\u542b\u5e8f\u5217\u53f7\uff08%1$s\uff09\u3002", (String)"ManuftecMergeChecker_1", (String)"mmc-sfc-business", (Object[])new Object[0]), processseq));
            }
            DynamicObjectCollection oprEntrys = manuftech.getDynamicObjectCollection("oprentryentity");
            if (i != 0 && oprEntrys.size() != oprentrySize) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\u8ba1\u5212\u5408\u5e76\u5931\u8d25\uff0c\u5de5\u5e8f\u5217\u8868\u7684\u884c\u6570\u4e0d\u4e00\u81f4\u3002", (String)"ManuftecMergeChecker_2", (String)"mmc-sfc-business", (Object[])new Object[0]), new Object[0]));
            }
            for (DynamicObject oprEntry : oprEntrys) {
                String oprno = oprEntry.getString("oprno");
                String oprparent = oprEntry.getString("oprparent");
                List entryObjects = entryMap.computeIfAbsent(oprparent + oprno, k -> new ArrayList(10));
                entryObjects.add(oprEntry);
                if (i == 0) {
                    oprnoClassify.add(oprno);
                    continue;
                }
                if (oprnoClassify.contains(oprno)) continue;
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\u8ba1\u5212\u5408\u5e76\u5931\u8d25\uff0c\u5de5\u5e8f\u5217\u8868\u4e0d\u5305\u542b\u5de5\u5e8f\u53f7\uff08%1$s\uff09\u3002", (String)"ManuftecMergeChecker_3", (String)"mmc-sfc-business", (Object[])new Object[0]), oprno));
            }
        }
        if (idNoMapping.size() > 0) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u751f\u4ea7\u5de5\u5355\u4e0d\u5b58\u5728\u5de5\u5e8f\u8ba1\u5212\uff08\u5de5\u5355\u7f16\u53f7\uff1a%1$s\uff09\u3002", (String)"ManuftecMergeChecker_4", (String)"mmc-sfc-business", (Object[])new Object[0]), idNoMapping.values()));
        }
        ManuftecMergeChecker.checkProcessSeqEntry(proentryMap);
        ManuftecMergeChecker.checkManutechEntry(entryMap);
    }

    private static void checkProcessSeqEntry(Map<String, List<DynamicObject>> proentryMap) {
        for (List<DynamicObject> proentrys : proentryMap.values()) {
            Date date = TimeServiceHelper.now();
            HashSet<String> processseqnameSet = new HashSet<String>(2);
            HashSet<String> processseqtypeSet = new HashSet<String>(2);
            HashSet<String> processreferenceSet = new HashSet<String>(2);
            HashSet<String> processrelationSet = new HashSet<String>(2);
            HashSet<String> processplanbegintimeSet = new HashSet<String>(2);
            HashSet<String> planendtimeSet = new HashSet<String>(2);
            HashSet<String> processoutputSet = new HashSet<String>(2);
            HashSet<String> processoutputdescSet = new HashSet<String>(2);
            HashSet<String> processinputSet = new HashSet<String>(2);
            HashSet<String> processinputdescSet = new HashSet<String>(2);
            HashSet<String> processplanouttimeSet = new HashSet<String>(2);
            HashSet<String> processplanintimeSet = new HashSet<String>(2);
            for (DynamicObject proentry : proentrys) {
                DynamicObject parent = (DynamicObject)proentry.getParent();
                String billNo = parent.get("billno") == null ? "" : parent.getString("billno");
                int seq = proentry.getInt("seq");
                String processseqname = proentry.get("processseqname") == null ? "" : proentry.getString("processseqname");
                processseqnameSet.add(processseqname);
                if (processseqnameSet.size() > 1) {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\u8ba1\u5212\u5408\u5e76\u5931\u8d25\uff0c\u5de5\u5e8f\u5e8f\u5217\u5206\u5f55\u7b2c%1$s\u884c\u5de5\u5e8f\u5e8f\u5217\u7684\u201c\u5e8f\u5217\u540d\u79f0\u201d\u4e0d\u4e00\u81f4\u3002", (String)"ManuftecMergeChecker_5", (String)"mmc-sfc-business", (Object[])new Object[0]), seq));
                }
                String processseqtype = proentry.get("processseqtype") == null ? "" : proentry.getString("processseqtype");
                processseqtypeSet.add(processseqtype);
                if (processseqtypeSet.size() > 1) {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\u8ba1\u5212\u5408\u5e76\u5931\u8d25\uff0c\u5de5\u5e8f\u5e8f\u5217\u5206\u5f55\u7b2c%1$s\u884c\u5de5\u5e8f\u5e8f\u5217\u7684\u201c\u5e8f\u5217\u7c7b\u578b\u201d\u4e0d\u4e00\u81f4\u3002", (String)"ManuftecMergeChecker_6", (String)"mmc-sfc-business", (Object[])new Object[0]), seq));
                }
                String processreference = proentry.get("processreference") == null ? "" : proentry.getString("processreference");
                processreferenceSet.add(processreference);
                if (processreferenceSet.size() > 1) {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\u8ba1\u5212\u5408\u5e76\u5931\u8d25\uff0c\u5de5\u5e8f\u5e8f\u5217\u5206\u5f55\u7b2c%1$s\u884c\u5de5\u5e8f\u5e8f\u5217\u7684\u201c\u53c2\u7167\u5e8f\u5217\u201d\u4e0d\u4e00\u81f4\u3002", (String)"ManuftecMergeChecker_7", (String)"mmc-sfc-business", (Object[])new Object[0]), seq));
                }
                String processrelation = proentry.get("processrelation") == null ? "" : proentry.getString("processrelation");
                processrelationSet.add(processrelation);
                if (processrelationSet.size() > 1) {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\u8ba1\u5212\u5408\u5e76\u5931\u8d25\uff0c\u5de5\u5e8f\u5e8f\u5217\u5206\u5f55\u7b2c%1$s\u884c\u5de5\u5e8f\u5e8f\u5217\u7684\u201c\u5e76\u884c\u5173\u7cfb\u201d\u4e0d\u4e00\u81f4\u3002", (String)"ManuftecMergeChecker_8", (String)"mmc-sfc-business", (Object[])new Object[0]), seq));
                }
                Date processplanbegintime = proentry.get("processplanbegintime") == null ? date : proentry.getDate("processplanbegintime");
                String dateStr = TimeServiceHelper.formatDate((Date)processplanbegintime);
                processplanbegintimeSet.add(dateStr);
                if (processplanbegintimeSet.size() > 1) {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\u8ba1\u5212\u5408\u5e76\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a\u5de5\u5e8f\u5e8f\u5217\uff08%1$s\uff09\u7684\u201c\u8ba1\u5212\u5f00\u59cb\u65f6\u95f4\u201d\u4e0d\u4e00\u81f4\u3002", (String)"ManuftecMergeChecker_9", (String)"mmc-sfc-business", (Object[])new Object[0]), seq));
                }
                Date processplanendtime = proentry.get("processplanendtime") == null ? date : proentry.getDate("processplanendtime");
                String processplanendtimeStr = TimeServiceHelper.formatDate((Date)processplanendtime);
                planendtimeSet.add(processplanendtimeStr);
                if (planendtimeSet.size() > 1) {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\u8ba1\u5212\u5408\u5e76\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a\u5de5\u5e8f\u5e8f\u5217\uff08%1$s\uff09\u7684\u201c\u8ba1\u5212\u7ed3\u675f\u65f6\u95f4\u201d\u4e0d\u4e00\u81f4\u3002", (String)"ManuftecMergeChecker_10", (String)"mmc-sfc-business", (Object[])new Object[0]), seq));
                }
                String processoutput = proentry.get("processoutput") == null ? "" : proentry.getString("processoutput");
                processoutputSet.add(processoutput);
                if (processoutputSet.size() > 1) {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\u8ba1\u5212\u5408\u5e76\u5931\u8d25\uff0c\u5de5\u5e8f\u5e8f\u5217\u5206\u5f55\u7b2c%1$s\u884c\u5de5\u5e8f\u5e8f\u5217\u7684\u201c\u8f6c\u51fa\u5de5\u5e8f\u201d\u4e0d\u4e00\u81f4\u3002", (String)"ManuftecMergeChecker_11", (String)"mmc-sfc-business", (Object[])new Object[0]), seq));
                }
                String processoutputdesc = proentry.get("processoutputdesc") == null ? "" : proentry.getString("processoutputdesc");
                processoutputdescSet.add(processoutputdesc);
                if (processoutputdescSet.size() > 1) {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\u8ba1\u5212\u5408\u5e76\u5931\u8d25\uff0c\u5de5\u5e8f\u5e8f\u5217\u5206\u5f55\u7b2c%1$s\u884c\u5de5\u5e8f\u5e8f\u5217\u7684\u201c\u8f6c\u51fa\u5de5\u5e8f\u8bf4\u660e\u201d\u4e0d\u4e00\u81f4\u3002", (String)"ManuftecMergeChecker_12", (String)"mmc-sfc-business", (Object[])new Object[0]), seq));
                }
                String processinput = proentry.get("processinput") == null ? "" : proentry.getString("processinput");
                processinputSet.add(processinput);
                if (processinputSet.size() > 1) {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\u8ba1\u5212\u5408\u5e76\u5931\u8d25\uff0c\u5de5\u5e8f\u5e8f\u5217\u5206\u5f55\u7b2c%1$s\u884c\u5de5\u5e8f\u5e8f\u5217\u7684\u201c\u8f6c\u5165\u5de5\u5e8f\u201d\u4e0d\u4e00\u81f4\u3002", (String)"ManuftecMergeChecker_13", (String)"mmc-sfc-business", (Object[])new Object[0]), seq));
                }
                String processinputdesc = proentry.get("processinputdesc") == null ? "" : proentry.getString("processinputdesc");
                processinputdescSet.add(processinputdesc);
                if (processinputdescSet.size() > 1) {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\u8ba1\u5212\u5408\u5e76\u5931\u8d25\uff0c\u5de5\u5e8f\u5e8f\u5217\u5206\u5f55\u7b2c%1$s\u884c\u5de5\u5e8f\u5e8f\u5217\u7684\u201c\u8f6c\u5165\u5de5\u5e8f\u8bf4\u660e\u201d\u4e0d\u4e00\u81f4\u3002", (String)"ManuftecMergeChecker_14", (String)"mmc-sfc-business", (Object[])new Object[0]), seq));
                }
                Date processplanouttime = proentry.get("processplanouttime") == null ? date : proentry.getDate("processplanouttime");
                String processplanouttimeStr = TimeServiceHelper.formatDate((Date)processplanouttime);
                processplanouttimeSet.add(processplanouttimeStr);
                if (processplanouttimeSet.size() > 1) {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\u8ba1\u5212[%1$s]\u5408\u5e76\u5355\u5931\u8d25:\u5de5\u5e8f\u5e8f\u5217\u5206\u5f55\u7b2c[%2$s]\u884c\u8ba1\u5212\u8f6c\u51fa\u65f6\u95f4\u4e0d\u4e00\u81f4\u3002", (String)"ManuftecMergeChecker_15", (String)"mmc-sfc-business", (Object[])new Object[0]), billNo, seq));
                }
                Date processplanintime = proentry.get("processplanintime") == null ? date : proentry.getDate("processplanintime");
                String processplanintimeStr = TimeServiceHelper.formatDate((Date)processplanintime);
                processplanintimeSet.add(processplanintimeStr);
                if (processplanintimeSet.size() <= 1) continue;
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\u8ba1\u5212[%1$s]\u5408\u5e76\u5355\u5931\u8d25:\u5de5\u5e8f\u5e8f\u5217\u5206\u5f55\u7b2c[%2$s]\u884c\u8ba1\u5212\u8f6c\u5165\u65f6\u95f4\u4e0d\u4e00\u81f4\u3002", (String)"ManuftecMergeChecker_16", (String)"mmc-sfc-business", (Object[])new Object[0]), billNo, seq));
            }
        }
    }

    private static void checkManutechEntry(Map<String, List<DynamicObject>> entryMap) {
        for (List<DynamicObject> entrys : entryMap.values()) {
            HashSet<String> oprnoSet = new HashSet<String>(2);
            HashSet<Object> oporgSet = new HashSet<Object>(2);
            HashSet<Object> oprworkcenterSet = new HashSet<Object>(2);
            HashSet<Object> oprworkshopSet = new HashSet<Object>(2);
            HashSet<Object> oproperationSet = new HashSet<Object>(2);
            HashSet<String> oprdescriptionSet = new HashSet<String>(2);
            HashSet<Object> oprctrlstrategySet = new HashSet<Object>(2);
            HashSet<String> machiningtypeSet = new HashSet<String>(2);
            HashSet<Object> workstationSet = new HashSet<Object>(2);
            HashSet<String> inspectiontypeSet = new HashSet<String>(2);
            HashSet<Object> opunitSet = new HashSet<Object>(2);
            HashSet<String> oprstatusSet = new HashSet<String>(2);
            HashSet<String> oprsourcetypeSet = new HashSet<String>(2);
            HashSet<Boolean> collaborativeSet = new HashSet<Boolean>(2);
            HashSet<Boolean> oprinvalidSet = new HashSet<Boolean>(2);
            HashSet<Boolean> firstinspectionSet = new HashSet<Boolean>(2);
            HashSet<Boolean> storagepointSet = new HashSet<Boolean>(2);
            HashSet<BigDecimal> upperratioSet = new HashSet<BigDecimal>(2);
            HashSet<BigDecimal> floorratioSet = new HashSet<BigDecimal>(2);
            HashSet<Object> purchaseorgSet = new HashSet<Object>(2);
            HashSet<Object> purchasegroupSet = new HashSet<Object>(2);
            HashSet<Object> purchaserSet = new HashSet<Object>(2);
            HashSet<Object> supplierSet = new HashSet<Object>(2);
            if (entrys == null || entrys.size() < 1) continue;
            int actsubentrySize = entrys.get(0).getDynamicObjectCollection("actsubentryentity").size();
            for (int i = 0; i < entrys.size(); ++i) {
                DynamicObject oprunit;
                DynamicObject workstation;
                DynamicObject oprctrlstrategy;
                DynamicObject oproperation;
                DynamicObject oprworkshop;
                DynamicObject oprworkcenter;
                DynamicObject oporg;
                DynamicObject entry = entrys.get(i);
                DynamicObject parent = (DynamicObject)entry.getParent();
                String billNo = parent.get("billno") == null ? "" : parent.getString("billno");
                int seq = entry.getInt("seq");
                String oprno = entry.get("oprno") == null ? "" : entry.getString("oprno");
                oprnoSet.add(oprno);
                if (oprnoSet.size() > 1) {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\u8ba1\u5212\u5408\u5e76\u5931\u8d25\uff0c\u5de5\u5e8f\u5206\u5f55\u7b2c%1$s\u884c\u5de5\u5e8f\u7684\u201c\u5de5\u5e8f\u53f7\u201d\u5b58\u5728\u4e0d\u4e00\u81f4\u3002", (String)"ManuftecMergeChecker_17", (String)"mmc-sfc-business", (Object[])new Object[0]), seq));
                }
                DynamicObject dynamicObject = oporg = entry.get("oprorg") == null ? null : entry.getDynamicObject("oprorg");
                if (oporg != null) {
                    oporgSet.add(oporg.getPkValue());
                } else {
                    oporgSet.add(0L);
                }
                if (oporgSet.size() > 1) {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\u8ba1\u5212\u5408\u5e76\u5931\u8d25\uff0c\u5de5\u5e8f\u5206\u5f55\u7b2c%1$s\u884c\u5de5\u5e8f\u7684\u201c\u52a0\u5de5\u7ec4\u7ec7\u201d\u4e0d\u4e00\u81f4\u3002", (String)"ManuftecMergeChecker_18", (String)"mmc-sfc-business", (Object[])new Object[0]), seq));
                }
                DynamicObject dynamicObject2 = oprworkcenter = entry.get("oprworkcenter") == null ? null : entry.getDynamicObject("oprworkcenter");
                if (oprworkcenter != null) {
                    oprworkcenterSet.add(oprworkcenter.getPkValue());
                } else {
                    oprworkcenterSet.add(0L);
                }
                if (oprworkcenterSet.size() > 1) {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\u8ba1\u5212\u5408\u5e76\u5931\u8d25\uff0c\u5de5\u5e8f\u5206\u5f55\u7b2c%1$s\u884c\u5de5\u5e8f\u7684\u201c\u5de5\u4f5c\u4e2d\u5fc3\u201d\u4e0d\u4e00\u81f4\u3002", (String)"ManuftecMergeChecker_19", (String)"mmc-sfc-business", (Object[])new Object[0]), seq));
                }
                DynamicObject dynamicObject3 = oprworkshop = entry.get("oprworkshop") == null ? null : entry.getDynamicObject("oprworkshop");
                if (oprworkshop != null) {
                    oprworkshopSet.add(oprworkshop.getPkValue());
                } else {
                    oprworkshopSet.add(0L);
                }
                if (oprworkshopSet.size() > 1) {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\u8ba1\u5212\u5408\u5e76\u5931\u8d25\uff0c\u5de5\u5e8f\u5206\u5f55\u7b2c%1$s\u884c\u5de5\u5e8f\u7684\u201c\u751f\u4ea7\u8f66\u95f4\u201d\u4e0d\u4e00\u81f4\u3002", (String)"ManuftecMergeChecker_20", (String)"mmc-sfc-business", (Object[])new Object[0]), seq));
                }
                DynamicObject dynamicObject4 = oproperation = entry.get("oproperation") == null ? null : entry.getDynamicObject("oproperation");
                if (oproperation != null) {
                    oproperationSet.add(oproperation.getPkValue());
                } else {
                    oproperationSet.add(0L);
                }
                if (oproperationSet.size() > 1) {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\u8ba1\u5212\u5408\u5e76\u5931\u8d25\uff0c\u5de5\u5e8f\u5206\u5f55\u7b2c%1$s\u884c\u5de5\u5e8f\u7684\u201c\u5de5\u5e8f\u7f16\u7801\u201d\u4e0d\u4e00\u81f4\u3002", (String)"ManuftecMergeChecker_21", (String)"mmc-sfc-business", (Object[])new Object[0]), seq));
                }
                String oprdescription = entry.get("oprdescription") == null ? "" : entry.getString("oprdescription");
                oprdescriptionSet.add(oprdescription);
                if (oprdescriptionSet.size() > 1) {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\u8ba1\u5212\u5408\u5e76\u5931\u8d25\uff0c\u5de5\u5e8f\u5206\u5f55\u7b2c%1$s\u884c\u5de5\u5e8f\u7684\u201c\u5de5\u5e8f\u8bf4\u660e\u201d\u4e0d\u4e00\u81f4\u3002", (String)"ManuftecMergeChecker_22", (String)"mmc-sfc-business", (Object[])new Object[0]), seq));
                }
                DynamicObject dynamicObject5 = oprctrlstrategy = entry.get("oprctrlstrategy") == null ? null : entry.getDynamicObject("oprctrlstrategy");
                if (oprctrlstrategy != null) {
                    oprctrlstrategySet.add(oprctrlstrategy.getPkValue());
                } else {
                    oprctrlstrategySet.add(0L);
                }
                if (oprctrlstrategySet.size() > 1) {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\u8ba1\u5212\u5408\u5e76\u5931\u8d25\uff0c\u5de5\u5e8f\u5206\u5f55\u7b2c%1$s\u884c\u5de5\u5e8f\u7684\u201c\u5de5\u5e8f\u63a7\u5236\u7b56\u7565\u201d\u4e0d\u4e00\u81f4\u3002", (String)"ManuftecMergeChecker_23", (String)"mmc-sfc-business", (Object[])new Object[0]), seq));
                }
                String machiningtype = entry.get("machiningtype") == null ? "" : entry.getString("machiningtype");
                machiningtypeSet.add(machiningtype);
                if (machiningtypeSet.size() > 1) {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\u8ba1\u5212\u5408\u5e76\u5931\u8d25\uff0c\u5de5\u5e8f\u5206\u5f55\u7b2c%1$s\u884c\u5de5\u5e8f\u7684\u201c\u52a0\u5de5\u7c7b\u578b\u201d\u4e0d\u4e00\u81f4\u3002", (String)"ManuftecMergeChecker_24", (String)"mmc-sfc-business", (Object[])new Object[0]), seq));
                }
                DynamicObject dynamicObject6 = workstation = entry.get("workstation") == null ? null : entry.getDynamicObject("workstation");
                if (workstation != null) {
                    workstationSet.add(workstation.getPkValue());
                } else {
                    workstationSet.add(0L);
                }
                if (workstationSet.size() > 1) {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\u8ba1\u5212\u5408\u5e76\u5931\u8d25\uff0c\u5de5\u5e8f\u5206\u5f55\u7b2c%1$s\u884c\u5de5\u5e8f\u7684\u201c\u5de5\u4f4d\u201d\u4e0d\u4e00\u81f4\u3002", (String)"ManuftecMergeChecker_25", (String)"mmc-sfc-business", (Object[])new Object[0]), seq));
                }
                String inspectiontype = entry.get("inspectiontype") == null ? "" : entry.getString("inspectiontype");
                inspectiontypeSet.add(inspectiontype);
                if (inspectiontypeSet.size() > 1) {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\u8ba1\u5212\u5408\u5e76\u5931\u8d25\uff0c\u5de5\u5e8f\u5206\u5f55\u7b2c%1$s\u884c\u5de5\u5e8f\u7684\u201c\u68c0\u9a8c\u65b9\u5f0f\u201d\u4e0d\u4e00\u81f4\u3002", (String)"ManuftecMergeChecker_26", (String)"mmc-sfc-business", (Object[])new Object[0]), seq));
                }
                DynamicObject dynamicObject7 = oprunit = entry.get("oprunit") == null ? null : entry.getDynamicObject("oprunit");
                if (oprunit != null) {
                    opunitSet.add(oprunit.getPkValue());
                } else {
                    opunitSet.add(0L);
                }
                if (opunitSet.size() > 1) {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\u8ba1\u5212\u5408\u5e76\u5931\u8d25\uff0c\u5de5\u5e8f\u5206\u5f55\u7b2c%1$s\u884c\u5de5\u5e8f\u7684\u201c\u5de5\u5e8f\u5355\u4f4d\u201d\u4e0d\u4e00\u81f4\u3002", (String)"ManuftecMergeChecker_27", (String)"mmc-sfc-business", (Object[])new Object[0]), seq));
                }
                String oprstatus = entry.get("oprstatus") == null ? "" : entry.getString("oprstatus");
                oprstatusSet.add(oprstatus);
                if (oprstatusSet.size() > 1) {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\u8ba1\u5212\u5408\u5e76\u5931\u8d25\uff0c\u5de5\u5e8f\u5206\u5f55\u7b2c%1$s\u884c\u5de5\u5e8f\u7684\u201c\u72b6\u6001\u201d\u4e0d\u4e00\u81f4\u3002", (String)"ManuftecMergeChecker_28", (String)"mmc-sfc-business", (Object[])new Object[0]), seq));
                }
                String oprsourcetype = entry.get("oprsourcetype") == null ? "" : entry.getString("oprsourcetype");
                oprsourcetypeSet.add(oprsourcetype);
                if (oprsourcetypeSet.size() > 1) {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\u8ba1\u5212\u5408\u5e76\u5931\u8d25\uff0c\u5de5\u5e8f\u5206\u5f55\u7b2c%1$s\u884c\u5de5\u5e8f\u7684\u201c\u5de5\u5e8f\u6765\u6e90\u7c7b\u578b\u201d\u4e0d\u4e00\u81f4\u3002", (String)"ManuftecMergeChecker_29", (String)"mmc-sfc-business", (Object[])new Object[0]), seq));
                }
                boolean collaborative = entry.get("collaborative") == null ? false : entry.getBoolean("collaborative");
                collaborativeSet.add(collaborative);
                if (collaborativeSet.size() > 1) {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\u8ba1\u5212\u5408\u5e76\u5931\u8d25\uff0c\u5de5\u5e8f\u5206\u5f55\u7b2c%1$s\u884c\u5de5\u5e8f\u7684\u201c\u534f\u4f5c\u5de5\u5e8f\u201d\u4e0d\u4e00\u81f4\u3002", (String)"ManuftecMergeChecker_30", (String)"mmc-sfc-business", (Object[])new Object[0]), seq));
                }
                boolean oprinvalid = entry.get("oprinvalid") == null ? false : entry.getBoolean("oprinvalid");
                oprinvalidSet.add(oprinvalid);
                if (oprinvalidSet.size() > 1) {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\u8ba1\u5212\u5408\u5e76\u5931\u8d25\uff0c\u5de5\u5e8f\u5206\u5f55\u7b2c%1$s\u884c\u5de5\u5e8f\u7684\u201c\u4f5c\u5e9f\u201d\u4e0d\u4e00\u81f4\u3002", (String)"ManuftecMergeChecker_31", (String)"mmc-sfc-business", (Object[])new Object[0]), seq));
                }
                boolean firstinspection = entry.get("firstinspection") == null ? false : entry.getBoolean("firstinspection");
                firstinspectionSet.add(firstinspection);
                if (firstinspectionSet.size() > 1) {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\u8ba1\u5212\u5408\u5e76\u5931\u8d25\uff0c\u5de5\u5e8f\u5206\u5f55\u7b2c%1$s\u884c\u5de5\u5e8f\u7684\u201c\u9996\u68c0\u201d\u4e0d\u4e00\u81f4\u3002", (String)"ManuftecMergeChecker_32", (String)"mmc-sfc-business", (Object[])new Object[0]), seq));
                }
                boolean storagepoint = entry.get("storagepoint") == null ? false : entry.getBoolean("storagepoint");
                storagepointSet.add(storagepoint);
                if (storagepointSet.size() > 1) {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\u8ba1\u5212\u5408\u5e76\u5931\u8d25\uff0c\u5de5\u5e8f\u5206\u5f55\u7b2c%1$s\u884c\u5de5\u5e8f\u7684\u201c\u5165\u5e93\u70b9\u201d\u4e0d\u4e00\u81f4\u3002", (String)"ManuftecMergeChecker_33", (String)"mmc-sfc-business", (Object[])new Object[0]), seq));
                }
                BigDecimal upperratio = entry.get("upperratio") == null ? BigDecimal.ZERO : entry.getBigDecimal("upperratio");
                upperratioSet.add(upperratio);
                if (upperratioSet.size() > 1) {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\u8ba1\u5212\u5408\u5e76\u5931\u8d25\uff0c\u5de5\u5e8f\u5206\u5f55\u7b2c%1$s\u884c\u5de5\u5e8f\u7684\u201c\u6c47\u62a5\u4e0a\u9650\u6bd4\u4f8b\u201d\u4e0d\u4e00\u81f4\u3002", (String)"ManuftecMergeChecker_34", (String)"mmc-sfc-business", (Object[])new Object[0]), seq));
                }
                BigDecimal floorratio = entry.get("floorratio") == null ? BigDecimal.ZERO : entry.getBigDecimal("floorratio");
                floorratioSet.add(floorratio);
                if (floorratioSet.size() > 1) {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\u8ba1\u5212\u5408\u5e76\u5931\u8d25\uff0c\u5de5\u5e8f\u5206\u5f55\u7b2c%1$s\u884c\u5de5\u5e8f\u7684\u201c\u6c47\u62a5\u4e0b\u9650\u6bd4\u4f8b\u201d\u4e0d\u4e00\u81f4\u3002", (String)"ManuftecMergeChecker_35", (String)"mmc-sfc-business", (Object[])new Object[0]), seq));
                }
                if (StringUtils.equals((CharSequence)"1002", (CharSequence)machiningtype)) {
                    DynamicObject supplier;
                    DynamicObject purchaser;
                    DynamicObject purchasegroup;
                    DynamicObject purchaseorg;
                    DynamicObject dynamicObject8 = purchaseorg = entry.get("purchaseorg") == null ? null : entry.getDynamicObject("purchaseorg");
                    if (purchaseorg != null) {
                        purchaseorgSet.add(purchaseorg.getPkValue());
                    } else {
                        purchaseorgSet.add(0L);
                    }
                    if (purchaseorgSet.size() > 1) {
                        throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\u8ba1\u5212\u5408\u5e76\u5931\u8d25\uff0c\u5de5\u5e8f\u5206\u5f55\u7b2c%1$s\u884c\u5de5\u5e8f\u7684\u201c\u91c7\u8d2d\u7ec4\u7ec7\u201d\u4e0d\u4e00\u81f4\u3002", (String)"ManuftecMergeChecker_36", (String)"mmc-sfc-business", (Object[])new Object[0]), seq));
                    }
                    DynamicObject dynamicObject9 = purchasegroup = entry.get("purchasegroup") == null ? null : entry.getDynamicObject("purchasegroup");
                    if (purchasegroup != null) {
                        purchasegroupSet.add(purchasegroup.getPkValue());
                    } else {
                        purchasegroupSet.add(0L);
                    }
                    if (purchasegroupSet.size() > 1) {
                        throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\u8ba1\u5212\u5408\u5e76\u5931\u8d25\uff0c\u5de5\u5e8f\u5206\u5f55\u7b2c%1$s\u884c\u5de5\u5e8f\u7684\u201c\u91c7\u8d2d\u7ec4\u201d\u4e0d\u4e00\u81f4\u3002", (String)"ManuftecMergeChecker_37", (String)"mmc-sfc-business", (Object[])new Object[0]), seq));
                    }
                    DynamicObject dynamicObject10 = purchaser = entry.get("purchaser") == null ? null : entry.getDynamicObject("purchaser");
                    if (purchaser != null) {
                        purchaserSet.add(purchaser.getPkValue());
                    } else {
                        purchaserSet.add(0L);
                    }
                    if (purchaserSet.size() > 1) {
                        throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\u8ba1\u5212\u5408\u5e76\u5931\u8d25\uff0c\u5de5\u5e8f\u5206\u5f55\u7b2c%1$s\u884c\u5de5\u5e8f\u7684\u201c\u91c7\u8d2d\u5458\u201d\u4e0d\u4e00\u81f4\u3002", (String)"ManuftecMergeChecker_38", (String)"mmc-sfc-business", (Object[])new Object[0]), seq));
                    }
                    DynamicObject dynamicObject11 = supplier = entry.get("supplier") == null ? null : entry.getDynamicObject("supplier");
                    if (supplier != null) {
                        supplierSet.add(supplier.getPkValue());
                    } else {
                        supplierSet.add(0L);
                    }
                    if (supplierSet.size() > 1) {
                        throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\u8ba1\u5212\u5408\u5e76\u5931\u8d25\uff0c\u5de5\u5e8f\u5206\u5f55\u7b2c%1$s\u884c\u5de5\u5e8f\u7684\u201c\u5efa\u8bae\u4f9b\u5e94\u5546\u201d\u4e0d\u4e00\u81f4\u3002", (String)"ManuftecMergeChecker_39", (String)"mmc-sfc-business", (Object[])new Object[0]), seq));
                    }
                }
                DynamicObjectCollection actsubentrys = entry.getDynamicObjectCollection("actsubentryentity");
                if (i == 0 || actsubentrySize == actsubentrys.size()) continue;
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\u8ba1\u5212\u5408\u5e76\u5931\u8d25\uff0c\u5de5\u5e8f\u5206\u5f55\u7b2c%1$s\u884c\u5de5\u5e8f\u7684\u5de5\u5e8f\u6d3b\u52a8\u5217\u8868\u7684\u884c\u6570\u4e0d\u4e00\u81f4\u3002", (String)"ManuftecMergeChecker_40", (String)"mmc-sfc-business", (Object[])new Object[0]), seq));
            }
        }
    }

    private static void checkManuftechHead(Set<Object> orgSet, Set<Object> billTypeSet, Set<String> planTypeSet, Set<String> billStatusSet, Set<Object> transacationSet, Set<Object> productSet, Set<Object> configCodeSet, Set<Object> trackNumberCodeSet, Set<Object> baseUnitSet, Set<Object> bomSet, Set<Object> processRouteSet, DynamicObject manuftech, String billNo) {
        DynamicObject baseunit;
        DynamicObject transaction;
        DynamicObject processroute;
        DynamicObject tracknumber;
        DynamicObject configuredcode;
        DynamicObject material;
        DynamicObject billType;
        DynamicObject orgObject;
        DynamicObject dynamicObject = orgObject = manuftech.get("org") == null ? null : manuftech.getDynamicObject("org");
        if (orgObject != null) {
            orgSet.add(orgObject.getPkValue());
        } else {
            orgSet.add(0L);
        }
        if (orgSet.size() > 1) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\u8ba1\u5212\u5408\u5e76\u5931\u8d25\uff0c\u201c\u751f\u4ea7\u7ec4\u7ec7\u201d\u4e0d\u4e00\u81f4\u3002", (String)"ManuftecMergeChecker_41", (String)"mmc-sfc-business", (Object[])new Object[0]), new Object[0]));
        }
        DynamicObject dynamicObject2 = billType = manuftech.get("billtype") == null ? null : manuftech.getDynamicObject("billtype");
        if (billType != null) {
            billTypeSet.add(billType.getPkValue());
        } else {
            billTypeSet.add(0L);
        }
        if (billTypeSet.size() > 1) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\u8ba1\u5212\u5408\u5e76\u5931\u8d25\uff0c\u201c\u5355\u636e\u7c7b\u578b\u201d\u4e0d\u4e00\u81f4\u3002", (String)"ManuftecMergeChecker_42", (String)"mmc-sfc-business", (Object[])new Object[0]), new Object[0]));
        }
        DynamicObject dynamicObject3 = material = manuftech.get("material") == null ? null : manuftech.getDynamicObject("material");
        if (material != null) {
            productSet.add(material.getPkValue());
        } else {
            productSet.add(0L);
        }
        if (productSet.size() > 1) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\u8ba1\u5212\u5408\u5e76\u5931\u8d25\uff0c\u201c\u4ea7\u54c1\u7f16\u7801\u201d\u4e0d\u4e00\u81f4\u3002", (String)"ManuftecMergeChecker_43", (String)"mmc-sfc-business", (Object[])new Object[0]), new Object[0]));
        }
        DynamicObject dynamicObject4 = configuredcode = manuftech.get("configuredcode") == null ? null : manuftech.getDynamicObject("configuredcode");
        if (configuredcode != null) {
            configCodeSet.add(configuredcode.getPkValue());
        } else {
            configCodeSet.add(0L);
        }
        if (configCodeSet.size() > 1) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\u8ba1\u5212\u5408\u5e76\u5931\u8d25\uff0c\u201c\u914d\u7f6e\u53f7\u201d\u4e0d\u4e00\u81f4\u3002", (String)"ManuftecMergeChecker_44", (String)"mmc-sfc-business", (Object[])new Object[0]), new Object[0]));
        }
        DynamicObject dynamicObject5 = tracknumber = manuftech.get("tracknumber") == null ? null : manuftech.getDynamicObject("tracknumber");
        if (tracknumber != null) {
            trackNumberCodeSet.add(tracknumber.getPkValue());
        } else {
            trackNumberCodeSet.add(0L);
        }
        if (trackNumberCodeSet.size() > 1) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\u8ba1\u5212\u5408\u5e76\u5931\u8d25\uff0c\u201c\u8ddf\u8e2a\u53f7\u201d\u4e0d\u4e00\u81f4\u3002", (String)"ManuftecMergeChecker_45", (String)"mmc-sfc-business", (Object[])new Object[0]), new Object[0]));
        }
        String plantype = manuftech.get("plantype") == null ? "" : manuftech.getString("plantype");
        planTypeSet.add(plantype);
        if (planTypeSet.size() > 1) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\u8ba1\u5212\u5408\u5e76\u5931\u8d25\uff0c\u201c\u8ba1\u5212\u7c7b\u578b\u201d\u4e0d\u4e00\u81f4\u3002", (String)"ManuftecMergeChecker_46", (String)"mmc-sfc-business", (Object[])new Object[0]), new Object[0]));
        }
        String billStatus = manuftech.get("billstatus") == null ? "" : manuftech.getString("billstatus");
        billStatusSet.add(billStatus);
        if (billStatusSet.size() > 1) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\u8ba1\u5212\u5408\u5e76\u5931\u8d25\uff0c\u201c\u5355\u636e\u72b6\u6001\u201d\u4e0d\u4e00\u81f4\u3002", (String)"ManuftecMergeChecker_47", (String)"mmc-sfc-business", (Object[])new Object[0]), new Object[0]));
        }
        DynamicObject dynamicObject6 = processroute = manuftech.get("processroute") == null ? null : manuftech.getDynamicObject("processroute");
        if (processroute != null) {
            processRouteSet.add(processroute.getPkValue());
        } else {
            processRouteSet.add(0L);
        }
        if (processRouteSet.size() > 1) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\u8ba1\u5212\u5408\u5e76\u5931\u8d25\uff0c\u201c\u5de5\u827a\u8def\u7ebf\u201d\u4e0d\u4e00\u81f4\u3002", (String)"ManuftecMergeChecker_48", (String)"mmc-sfc-business", (Object[])new Object[0]), new Object[0]));
        }
        DynamicObject dynamicObject7 = transaction = manuftech.get("transactiontype") == null ? null : manuftech.getDynamicObject("transactiontype");
        if (transaction != null) {
            transacationSet.add(transaction.getPkValue());
        } else {
            transacationSet.add(0L);
        }
        if (transacationSet.size() > 1) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\u8ba1\u5212\u5408\u5e76\u5931\u8d25\uff0c\u201c\u4e8b\u52a1\u7c7b\u578b\u201d\u4e0d\u4e00\u81f4\u3002", (String)"ManuftecMergeChecker_49", (String)"mmc-sfc-business", (Object[])new Object[0]), new Object[0]));
        }
        String bomversion = manuftech.get("bomversion") == null ? "" : manuftech.getString("bomversion");
        bomSet.add(bomversion);
        if (bomSet.size() > 1) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\u8ba1\u5212\u5408\u5e76\u5931\u8d25\uff0c\u201cBOM\u7248\u672c\u201d\u4e0d\u4e00\u81f4\u3002", (String)"ManuftecMergeChecker_50", (String)"mmc-sfc-business", (Object[])new Object[0]), new Object[0]));
        }
        DynamicObject dynamicObject8 = baseunit = manuftech.get("baseunit") == null ? null : manuftech.getDynamicObject("baseunit");
        if (baseunit != null) {
            baseUnitSet.add(baseunit.getPkValue());
        } else {
            baseUnitSet.add(0L);
        }
        if (baseUnitSet.size() > 1) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\u8ba1\u5212\u5408\u5e76\u5931\u8d25\uff0c\u201c\u57fa\u672c\u5355\u4f4d\u201d\u4e0d\u4e00\u81f4\u3002", (String)"ManuftecMergeChecker_51", (String)"mmc-sfc-business", (Object[])new Object[0]), new Object[0]));
        }
    }
}

