/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.sfc.business.manuftech;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bd.mpdm.business.mftcommon.impl.MftCommonBusinessImpl;
import kd.bd.mpdm.common.mftorder.utils.OrderOpUtils;
import kd.bos.data.BusinessDataReader;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.runtime.ConvertOperationResult;
import kd.bos.entity.botp.runtime.PushArgs;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.UnitConvertHelper;
import kd.bos.servicehelper.botp.ConvertServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;

public class ProcessReportCreateManuInBusiness
extends MftCommonBusinessImpl {
    private static final Log logger = LogFactory.getLog(ProcessReportCreateManuInBusiness.class);

    public Map<String, Object> createManuInBill(String reportNumber, List<Map<String, Object>> paramList, String botpID) {
        String errorString;
        if (StringUtils.isEmpty((String)reportNumber)) {
            String errorString2 = ResManager.loadKDString((String)"\u4f20\u5165\u7684\u5de5\u5e8f\u6c47\u62a5\u5355\uff0c\u5355\u636e\u7f16\u53f7\u4e3a\u7a7a\u3002", (String)"ProcessReportCreateManuInBusiness_01", (String)"mmc-sfc-business", (Object[])new Object[0]);
            String errorCode = "sfc.100001";
            return this.genReturnMap(errorString2, Boolean.FALSE, errorCode);
        }
        Set orderIDSet = this.getProcessReportID(reportNumber);
        if (orderIDSet.isEmpty()) {
            String errorString3 = String.format(ResManager.loadKDString((String)"\u4f20\u5165\u7684\u5de5\u5e8f\u6c47\u62a5\u5355\uff08\u7f16\u53f7\uff1a%1$s\uff09\u5728\u7cfb\u7edf\u4e2d\u65e0\u6cd5\u627e\u5230\u5bf9\u5e94\u7684\u5355\u636e\u3002", (String)"ProcessReportCreateManuInBusiness_02", (String)"mmc-sfc-business", (Object[])new Object[0]), reportNumber);
            String errorCode = "sfc.100002";
            return this.genReturnMap(errorString3, Boolean.FALSE, errorCode);
        }
        if (orderIDSet.size() > 1) {
            String errorString4 = String.format(ResManager.loadKDString((String)"\u4f20\u5165\u7684\u5de5\u5e8f\u6c47\u62a5\u5355\uff08\u7f16\u53f7\uff1a%1$s\uff09\u5728\u7cfb\u7edf\u4e2d\u5b58\u5728\u591a\u5f20\u5de5\u5355\u4fe1\u606f\u3002", (String)"ProcessReportCreateManuInBusiness_13", (String)"mmc-sfc-business", (Object[])new Object[0]), reportNumber);
            String errorCode = "sfc.100003";
            return this.genReturnMap(errorString4, Boolean.FALSE, errorCode);
        }
        logger.info("\u5de5\u5e8f\u6c47\u62a5\u5355\u751f\u6210\u5b8c\u5de5\u5165\u5e93\u5355:" + reportNumber + "-" + botpID);
        Long orderID = (Long)orderIDSet.iterator().next();
        ArrayList<ListSelectedRow> needPushRows = new ArrayList<ListSelectedRow>(16);
        Map materialMap = new HashMap(16);
        if (!this.isEmptyList(paramList)) {
            Map orderEntryMap = this.getSfcReportEntryData(orderID);
            HashSet<String> materialNumberSet = new HashSet<String>(paramList.size());
            for (int i = 0; i < paramList.size(); ++i) {
                Map<String, Object> listMap = paramList.get(i);
                String materialNumber = this.getMaterialNumber(listMap);
                if ("".equals(materialNumber)) {
                    errorString = String.format(ResManager.loadKDString((String)"\u4f20\u5165\u7684\u7269\u6599\uff08%1$s\uff09\u4e3a\u7a7a\u3002", (String)"ProcessReportCreateManuInBusiness_04", (String)"mmc-sfc-business", (Object[])new Object[0]), materialNumber);
                    String errorCode = "sfc.100004";
                    return this.genReturnMap(errorString, Boolean.FALSE, errorCode);
                }
                BigDecimal compQty = this.getInQty(listMap);
                if (compQty.compareTo(ZERO) <= 0) {
                    String errorString5 = String.format(ResManager.loadKDString((String)"\u4f20\u5165\u7269\u6599\uff08%1$s\uff09\u7684\u5b8c\u5de5\u5165\u5e93\u6570\u91cf\uff08%2$s\uff09\u5c0f\u4e8e\u7b49\u4e8e0\u3002", (String)"ProcessReportCreateManuInBusiness_05", (String)"mmc-sfc-business", (Object[])new Object[0]), materialNumber, compQty);
                    String errorCode = "sfc.100005";
                    return this.genReturnMap(errorString5, Boolean.FALSE, errorCode);
                }
                materialNumberSet.add(materialNumber);
            }
            if (materialNumberSet.size() != paramList.size()) {
                String errorString6 = ResManager.loadKDString((String)"\u8bf7\u68c0\u67e5\u4f20\u5165\u7684\u7269\u6599\u662f\u5426\u5b58\u5728\u91cd\u590d\u3002", (String)"ProcessReportCreateManuInBusiness_06", (String)"mmc-sfc-business", (Object[])new Object[0]);
                String errorCode = "sfc.100006";
                return this.genReturnMap(errorString6, Boolean.FALSE, errorCode);
            }
            materialMap = this.getMaterialID(materialNumberSet);
            for (String materialNumber : materialNumberSet) {
                Long materalID = (Long)materialMap.get(materialNumber);
                if (materalID == null || materalID.equals(0L)) {
                    errorString = String.format(ResManager.loadKDString((String)"\u4f20\u5165\u7684\u7269\u6599\u7f16\u7801\uff08%1$s\uff09\u5728\u7cfb\u7edf\u4e2d\u65e0\u6cd5\u627e\u5230\u3002", (String)"ProcessReportCreateManuInBusiness_07", (String)"mmc-sfc-business", (Object[])new Object[0]), materialNumber);
                    String errorCode = "sfc.100007";
                    return this.genReturnMap(errorString, Boolean.FALSE, errorCode);
                }
                Map orderdataMap = (Map)orderEntryMap.get(materalID);
                if (orderdataMap == null) {
                    String errorString7 = String.format(ResManager.loadKDString((String)"\u4f20\u5165\u7684\u7269\u6599\u7f16\u7801\uff08%1$s\uff09\u5728\u5de5\u5355\u6c47\u62a5\u5355\uff08%2$s\uff09\u4e2d\u4e0d\u5b58\u5728\u3002", (String)"ProcessReportCreateManuInBusiness_14", (String)"mmc-sfc-business", (Object[])new Object[0]), materialNumber, reportNumber);
                    String errorCode = "sfc.100008";
                    return this.genReturnMap(errorString7, Boolean.FALSE, errorCode);
                }
                Long entryID = Long.parseLong(orderdataMap.get("entryid").toString());
                ListSelectedRow srcBil = new ListSelectedRow((Object)orderID);
                srcBil.setEntryEntityKey("treeentryentity");
                srcBil.setEntryPrimaryKeyValue((Object)entryID);
                needPushRows.add(srcBil);
            }
        } else {
            ListSelectedRow srcBil = new ListSelectedRow((Object)orderID);
            needPushRows.add(srcBil);
        }
        if (needPushRows.isEmpty()) {
            return this.genReturnMap("no push datas", Boolean.TRUE, "0");
        }
        PushArgs pushArgs = this.genPushArgs("sfc_processreportbill", "im_mdc_mftmanuinbill", botpID);
        pushArgs.setSelectedRows(needPushRows);
        ConvertOperationResult pushResult = ConvertServiceHelper.push((PushArgs)pushArgs);
        MainEntityType targetMainType = EntityMetadataCache.getDataEntityType((String)"im_mdc_mftmanuinbill");
        String targetBillNoStr = "";
        if (!pushResult.isSuccess()) {
            logger.info("\u5de5\u5e8f\u6c47\u62a5\u5355\u751f\u6210\u5b8c\u5de5\u5165\u5e93\u5355\u5931\u8d25:" + this.getErrByRes(pushResult));
            throw new KDBizException(new ErrorCode("createManuInBill", this.getErrByRes(pushResult)), new Object[0]);
        }
        List targetBillObjs = pushResult.loadTargetDataObjects(BusinessDataReader::loadRefence, targetMainType);
        if (targetBillObjs.isEmpty()) {
            errorString = String.format(ResManager.loadKDString((String)"\u5b8c\u5de5\u5165\u5e93\u5355\u672a\u751f\u6210\uff0c\u8bf7\u68c0\u67e5\u5de5\u5e8f\u6c47\u62a5\u5355\u751f\u6210\u5b8c\u5de5\u5165\u5e93\u5355\u7684\u8f6c\u6362\u89c4\u5219\uff08%1$s\uff09\u3002", (String)"ProcessReportCreateManuInBusiness_15", (String)"mmc-sfc-business", (Object[])new Object[0]), reportNumber);
            throw new KDBizException(new ErrorCode("createManuInBill", errorString), new Object[0]);
        }
        if (!this.isEmptyList(paramList)) {
            for (int i = 0; i < paramList.size(); ++i) {
                DynamicObject location;
                DynamicObject warehouse;
                Map<String, Object> listMap = paramList.get(i);
                String materialNumber = this.getMaterialNumber(listMap);
                Long materalID = (Long)materialMap.get(materialNumber);
                DynamicObject manuInEntryDy = this.getManuInEntry(targetBillObjs, materalID);
                if (manuInEntryDy == null) {
                    String errorString8 = String.format(ResManager.loadKDString((String)"\u751f\u6210\u7684\u5b8c\u5de5\u5165\u5e93\u5355\uff0c\u7269\u6599\uff08%1$s\uff09\u4e0d\u5b58\u5728\u3002", (String)"ProcessReportCreateManuInBusiness_10", (String)"mmc-sfc-business", (Object[])new Object[0]), materialNumber);
                    throw new KDBizException(new ErrorCode("createManuInBill", errorString8), new Object[0]);
                }
                BigDecimal compQty = this.getInQty(listMap);
                BigDecimal inQty = manuInEntryDy.getBigDecimal("qty");
                if (inQty.compareTo(compQty) < 0) {
                    String errorString9 = String.format(ResManager.loadKDString((String)"\u751f\u6210\u7684\u5b8c\u5de5\u5165\u5e93\u5355\u5206\u5f55\uff08\u7269\u6599\uff1a%1$s\uff09\uff0c\u53ef\u5165\u5e93\u6570\u91cf\uff08%2$s\uff09\u5c0f\u4e8e\u5f85\u5165\u5e93\u6570\u91cf\uff08%3$s\uff09\u3002", (String)"ProcessReportCreateManuInBusiness_11", (String)"mmc-sfc-business", (Object[])new Object[0]), materialNumber, inQty, compQty);
                    throw new KDBizException(new ErrorCode("createManuInBill", errorString9), new Object[0]);
                }
                if (inQty.compareTo(compQty) > 0) {
                    manuInEntryDy.set("qty", (Object)compQty);
                    manuInEntryDy.set("baseqty", (Object)compQty);
                    manuInEntryDy.set("receivalqty", (Object)compQty);
                    DynamicObject baseunit = manuInEntryDy.getDynamicObject("baseunit");
                    DynamicObject material = manuInEntryDy.getDynamicObject("material");
                    DynamicObject unit = manuInEntryDy.getDynamicObject("unit");
                    if (unit != null && baseunit != null && material != null) {
                        DynamicObject masterid = material.getDynamicObject("masterid");
                        StringBuilder errMsg = new StringBuilder();
                        BigDecimal baseqty = UnitConvertHelper.calculateNewQty((BigDecimal)compQty, (Long)((Long)baseunit.getPkValue()), (Long)((Long)unit.getPkValue()), (Long)((Long)masterid.getPkValue()), (StringBuilder)errMsg);
                        manuInEntryDy.set("baseqty", (Object)baseqty);
                        manuInEntryDy.set("receivalqty", (Object)baseqty);
                    }
                }
                if ((warehouse = this.getWarehouse(listMap)) != null) {
                    manuInEntryDy.set("warehouse", (Object)warehouse);
                    manuInEntryDy.set("location", null);
                }
                if ((location = this.getLocation(listMap)) == null) continue;
                manuInEntryDy.set("location", (Object)location);
            }
        }
        OperateOption create = OperateOption.create();
        create.setVariableValue("ignorewarn", "true");
        create.setVariableValue("ignoreinteraction", "true");
        OperationResult saveOperate = SaveServiceHelper.saveOperate((String)"im_mdc_mftmanuinbill", (DynamicObject[])targetBillObjs.toArray(new DynamicObject[targetBillObjs.size()]), (OperateOption)create);
        if (!saveOperate.isSuccess()) {
            throw new KDBizException(new ErrorCode("createManuInBill", String.format(ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25\uff0c\u4fdd\u5b58\u5b8c\u5de5\u5165\u5e93\u5355\u51fa\u73b0\u5f02\u5e38\uff1a%1$s\u3002", (String)"ProcessReportCreateManuInBusiness_12", (String)"mmc-sfc-business", (Object[])new Object[0]), OrderOpUtils.getErrDetail((OperationResult)saveOperate))), new Object[0]);
        }
        targetBillNoStr = this.getTargetBillNoString(targetBillObjs);
        return this.genReturnMap(targetBillNoStr, Boolean.TRUE, "0");
    }

    private DynamicObject getManuInEntry(List<DynamicObject> targetBillObjs, Long materalID) {
        for (DynamicObject targetBillObj : targetBillObjs) {
            DynamicObjectCollection coll = targetBillObj.getDynamicObjectCollection("billentry");
            for (int i = 0; i < coll.size(); ++i) {
                DynamicObject dy = (DynamicObject)coll.get(i);
                Long entryMaterialID = dy.getDynamicObject("material").getDynamicObject("masterid").getLong("id");
                if (!entryMaterialID.equals(materalID)) continue;
                return dy;
            }
        }
        return null;
    }
}

