/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.sfc.business.manuftech;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.servicehelper.UnitConvertHelper;

public class SfcTechnicsHelper {
    public static BigDecimal getBaseQty(Map<String, Object> oprEntry, BigDecimal oprQty) {
        if (oprEntry == null || oprQty == null || BigDecimal.ZERO.compareTo(oprQty) == 0) {
            return BigDecimal.ZERO;
        }
        BigDecimal operationQty = (BigDecimal)oprEntry.get("oprentryentity.operationqty");
        BigDecimal headQty = (BigDecimal)oprEntry.get("oprentryentity.headqty");
        headQty = oprQty.multiply(headQty);
        BigDecimal bigDecimal = UnitConvertHelper.calculateNewQty((BigDecimal)headQty, (Long)((Long)oprEntry.get("baseunit")), (Long)((Long)oprEntry.get("oprentryentity.headunit")), (Long)((Long)oprEntry.get("material")), (StringBuilder)new StringBuilder());
        BigDecimal decimal = bigDecimal.divide(operationQty, (int)((Integer)oprEntry.get("baseunit.precision")), SfcTechnicsHelper.getPrecisionDeal((String)oprEntry.get("baseunit.precisionaccount")));
        return decimal;
    }

    public static BigDecimal getOprQty(Map<String, Object> oprEntry, BigDecimal baseQty) {
        if (oprEntry == null || baseQty == null || BigDecimal.ZERO.compareTo(baseQty) == 0) {
            return BigDecimal.ZERO;
        }
        BigDecimal bigDecimal = UnitConvertHelper.calculateNewQty((BigDecimal)baseQty, (Long)((Long)oprEntry.get("oprentryentity.headunit")), (Long)((Long)oprEntry.get("baseunit")), (Long)((Long)oprEntry.get("material")), (StringBuilder)new StringBuilder());
        BigDecimal operationQty = (BigDecimal)oprEntry.get("oprentryentity.operationqty");
        operationQty = bigDecimal.multiply(operationQty);
        BigDecimal headQty = (BigDecimal)oprEntry.get("oprentryentity.headqty");
        BigDecimal decimal = operationQty.divide(headQty, (int)((Integer)oprEntry.get("oprentryentity.oprunit.precision")), SfcTechnicsHelper.getPrecisionDeal((String)oprEntry.get("oprentryentity.oprunit.precisionaccount")));
        return decimal;
    }

    public static Map<String, Object> getManftechMap(DynamicObject manTechicsInfo, DynamicObject techisInfo) {
        HashMap<String, Object> map = new HashMap<String, Object>(16);
        map.put("baseunit", manTechicsInfo.getDynamicObject("baseunit").getPkValue());
        map.put("baseunit.precision", manTechicsInfo.getDynamicObject("baseunit").getInt("precision"));
        map.put("baseunit.precisionaccount", manTechicsInfo.getDynamicObject("baseunit").getString("precisionaccount"));
        map.put("material", manTechicsInfo.getDynamicObject("material") == null ? null : manTechicsInfo.getDynamicObject("material").getPkValue());
        map.put("oprentryentity.operationqty", techisInfo.getBigDecimal("operationqty"));
        map.put("oprentryentity.headqty", techisInfo.getBigDecimal("headqty"));
        map.put("oprentryentity.headunit", techisInfo.getDynamicObject("headunit").getPkValue());
        map.put("oprentryentity.oprunit.precision", techisInfo.getDynamicObject("oprunit").getInt("precision"));
        map.put("oprentryentity.oprunit.precisionaccount", techisInfo.getDynamicObject("oprunit").getString("precisionaccount"));
        return map;
    }

    public static int getPrecisionDeal(String precisionaccount) {
        int deal = 4;
        switch (precisionaccount) {
            case "1": {
                deal = 4;
                break;
            }
            case "2": {
                deal = 1;
                break;
            }
            case "3": {
                deal = 0;
                break;
            }
        }
        return deal;
    }
}

