/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.sfc.common.dailyplan.utils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.mmc.sfc.common.dailyplan.bean.DailyPlanStatusEntity;
import kd.mmc.sfc.common.dailyplan.bean.DailyPlanStatusEntryEntity;

public class DailyPlanStatusUtils {
    public static Map<Object, DailyPlanStatusEntity> getDailyPlanStatus(Set<Object> dailyPlanIdSet) {
        HashMap<Object, DailyPlanStatusEntity> dailyPlanStatus = new HashMap<Object, DailyPlanStatusEntity>(16);
        if (dailyPlanIdSet == null || dailyPlanIdSet.size() < 1) {
            return dailyPlanStatus;
        }
        SqlBuilder sql = new SqlBuilder();
        sql.append("select distinct h.fid,h.fbillno,h.fbilltype,h.ftaskno,h.ftaskname,o.fentryid,o.fstatus,ode.ftaskstatus,tc.foprstatus,og.fgrogroupstatus,co.fbusinessstatus\r\n", new Object[0]);
        sql.append("from t_sfc_dailyplan_new h\r\n", new Object[0]);
        sql.append("left join t_sfc_dpentry_opr o on o.fid = h.fid \r\n", new Object[0]);
        sql.append("left join t_sfc_mromanftechentry tc on o.fsrcbillentryid = tc.fentryid \r\n", new Object[0]);
        sql.append("left join t_sfc_mrogroupentry og on og.fid = tc.fid and og.fgroprocessgroupid = tc.foprprocessgroupid\r\n", new Object[0]);
        sql.append("left join t_pom_mroorderentry ode on ode.fentryid = o.fmroorderentryid \r\n", new Object[0]);
        sql.append("left join t_pom_coordination co on co.fid = o.fsrcbillid \r\n", new Object[0]);
        sql.append("where\r\n", new Object[0]);
        sql.appendIn("h.fid ", dailyPlanIdSet.toArray());
        try (DataSet dataSet = DB.queryDataSet((String)DailyPlanStatusUtils.class.getName(), (DBRoute)DBRoute.of((String)"scm"), (SqlBuilder)sql);){
            String billTypeNo = "";
            for (Row row : dataSet) {
                DynamicObject billtype;
                Object dailyplanId = row.get("fid");
                Object entryid = row.get("fentryid");
                String billno = row.get("fbillno") == null ? "" : row.getString("fbillno");
                String taskno = row.get("ftaskno") == null ? "" : row.getString("ftaskno");
                String taskname = row.get("ftaskname") == null ? "" : row.getString("ftaskname");
                String status = row.get("fstatus") == null ? "" : row.getString("fstatus");
                String taskstatus = row.get("ftaskstatus") == null ? "" : row.getString("ftaskstatus");
                String oprstatus = row.get("foprstatus") == null ? "" : row.getString("foprstatus");
                String grogroupstatus = row.get("fgrogroupstatus") == null ? "" : row.getString("fgrogroupstatus");
                String businessstatus = row.get("fbusinessstatus") == null ? "" : row.getString("fbusinessstatus");
                Object billtypeObj = row.get("fbilltype");
                if (billtypeObj != null && (billtype = BusinessDataServiceHelper.loadSingleFromCache((Object)row.get("fbilltype"), (String)"bos_billtype", (String)"id,number")) != null) {
                    billTypeNo = billtype.getString("number");
                }
                String finalBillTypeNo = billTypeNo;
                DailyPlanStatusEntity dailyPlanStatusEntity = dailyPlanStatus.computeIfAbsent(dailyplanId, k -> new DailyPlanStatusEntity(dailyplanId, billno, finalBillTypeNo, taskno, taskname));
                DailyPlanStatusEntryEntity dailyPlanStatusEntry = new DailyPlanStatusEntryEntity(entryid, status, taskstatus, oprstatus, grogroupstatus, businessstatus);
                dailyPlanStatusEntity.addEntryStatsus(dailyPlanStatusEntry);
            }
        }
        return dailyPlanStatus;
    }

    public static List<Object> filterAllSrcStatus(Set<Object> dailyPlanIdSet) {
        ArrayList<Object> showList = new ArrayList<Object>(dailyPlanIdSet.size());
        if (dailyPlanIdSet == null || dailyPlanIdSet.size() < 1) {
            return showList;
        }
        SqlBuilder sql = new SqlBuilder();
        sql.append("select distinct h.fid,h.fbillno,o.fentryid,ode.ftaskstatus,tc.foprstatus\r\n", new Object[0]);
        sql.append("from t_sfc_dailyplan_new h\r\n", new Object[0]);
        sql.append("left join t_sfc_dpentry_opr o on o.fid = h.fid \r\n", new Object[0]);
        sql.append("left join t_sfc_mromanftechentry tc on o.fsrcbillentryid = tc.fentryid \r\n", new Object[0]);
        sql.append("left join t_pom_mroorderentry ode on ode.fentryid = o.fmroorderentryid \r\n", new Object[0]);
        sql.append("where\r\n", new Object[0]);
        sql.appendIn("h.fid ", dailyPlanIdSet.toArray());
        sql.append("and isnull(ode.ftaskstatus,'*') not in ('J','C','E','F')", new Object[0]);
        sql.append("and isnull(tc.foprstatus,'*') not in ('F','I','J')", new Object[0]);
        try (DataSet dataSet = DB.queryDataSet((String)DailyPlanStatusUtils.class.getName(), (DBRoute)DBRoute.of((String)"scm"), (SqlBuilder)sql);){
            for (Row row : dataSet) {
                showList.add(row.get("fentryid"));
            }
        }
        return showList;
    }

    public static List<Object> filterSrcStatus(Set<Object> dailyPlanIdSet) {
        ArrayList<Object> showList = new ArrayList<Object>(16);
        if (dailyPlanIdSet == null || dailyPlanIdSet.size() < 1) {
            return showList;
        }
        SqlBuilder sql = new SqlBuilder();
        sql.append("select distinct h.fid,o.fentryid\r\n", new Object[0]);
        sql.append("from t_sfc_dailyplan_new h\r\n", new Object[0]);
        sql.append("left join t_sfc_dpentry_opr o on o.fid = h.fid \r\n", new Object[0]);
        sql.append("left join t_sfc_mromanftechentry tc on o.fsrcbillentryid = tc.fentryid \r\n", new Object[0]);
        sql.append("where\r\n", new Object[0]);
        sql.appendIn("h.fid ", dailyPlanIdSet.toArray());
        sql.append(" and tc.foprstatus = 'F'", new Object[0]);
        try (DataSet dataSet = DB.queryDataSet((String)DailyPlanStatusUtils.class.getName(), (DBRoute)DBRoute.of((String)"scm"), (SqlBuilder)sql);){
            for (Row row : dataSet) {
                showList.add(row.get("fentryid"));
            }
        }
        return showList;
    }

    public static void updateSrcStatusByDailyPlan(List<DynamicObject> needSaveDym, Set<Object> needupdateEntryid) {
        SqlBuilder sql;
        if (needSaveDym == null || needSaveDym.size() < 1 || needupdateEntryid == null || needupdateEntryid.size() < 1) {
            return;
        }
        HashSet<Long> statusFOpEntryids = new HashSet<Long>(16);
        HashSet<Long> statusHOpEntryids = new HashSet<Long>(16);
        HashSet<Long> statusFOpCobillids = new HashSet<Long>(16);
        DailyPlanStatusUtils.classifyStatus(needSaveDym, needupdateEntryid, statusFOpEntryids, statusHOpEntryids, statusFOpCobillids);
        if (statusFOpEntryids.size() > 0) {
            sql = new SqlBuilder();
            sql.append("update t_sfc_mromanftechentry set foprstatus = 'F' where \r\n", new Object[0]);
            sql.appendIn("fentryid", statusFOpEntryids.toArray());
            sql.append("and foprstatus in ('A','B','C','D','E')", new Object[0]);
            DB.execute((DBRoute)DBRoute.of((String)"scm"), (SqlBuilder)sql);
        }
        if (statusHOpEntryids.size() > 0) {
            sql = new SqlBuilder();
            sql.append("update t_sfc_mromanftechentry set foprstatus = 'H' where \r\n", new Object[0]);
            sql.appendIn("fentryid", statusHOpEntryids.toArray());
            sql.append("and foprstatus in ('A','B','C','D','E','F')", new Object[0]);
            DB.execute((DBRoute)DBRoute.of((String)"scm"), (SqlBuilder)sql);
        }
        if (statusFOpCobillids.size() > 0) {
            sql = new SqlBuilder();
            sql.append("update t_pom_coordination set fbusinessstatus = 'C' where \r\n", new Object[0]);
            sql.appendIn("fid", statusFOpCobillids.toArray());
            sql.append("and fbusinessstatus in ('A','B','Z')", new Object[0]);
            DB.execute((DBRoute)DBRoute.of((String)"scm"), (SqlBuilder)sql);
        }
    }

    private static void classifyStatus(List<DynamicObject> needSaveDym, Set<Object> needupdateEntryid, Set<Long> statusFOpEntryids, Set<Long> statusHOpEntryids, Set<Long> statusFOpCobillids) {
        for (DynamicObject dailyPlan : needSaveDym) {
            String status;
            DynamicObject billtype = dailyPlan.getDynamicObject("billtype");
            if (billtype == null) {
                return;
            }
            String billTypeNumber = billtype.getString("number");
            DynamicObjectCollection oprentryentitys = dailyPlan.getDynamicObjectCollection("oprentryentity");
            if (StringUtils.equals((CharSequence)"sfc_dailyplan_tech_BT_S", (CharSequence)billTypeNumber)) {
                for (DynamicObject oprentryentity : oprentryentitys) {
                    long srcbillentryid;
                    if (!needupdateEntryid.contains(oprentryentity.getPkValue()) || 0L == (srcbillentryid = oprentryentity.get("srcbillentryid") == null ? 0L : oprentryentity.getLong("srcbillentryid"))) continue;
                    status = oprentryentity.getString("status");
                    if (StringUtils.equals((CharSequence)"F", (CharSequence)status)) {
                        statusFOpEntryids.add(srcbillentryid);
                        continue;
                    }
                    if (!StringUtils.equals((CharSequence)"H", (CharSequence)status)) continue;
                    statusHOpEntryids.add(srcbillentryid);
                }
                continue;
            }
            if (!StringUtils.equals((CharSequence)"sfc_dailyplan_coordinate_BT_S", (CharSequence)billTypeNumber)) continue;
            for (DynamicObject oprentryentity : oprentryentitys) {
                long srcbillid;
                if (!needupdateEntryid.contains(oprentryentity.getPkValue()) || 0L == (srcbillid = oprentryentity.get("srcbillid") == null ? 0L : oprentryentity.getLong("srcbillid")) || !StringUtils.equals((CharSequence)"F", (CharSequence)(status = oprentryentity.getString("status")))) continue;
                statusFOpCobillids.add(srcbillid);
            }
        }
    }

    public static void updateStatus(Set<Object> dailyPlanIdSet) {
        if (dailyPlanIdSet == null || dailyPlanIdSet.size() < 1) {
            return;
        }
        SqlBuilder sql = new SqlBuilder();
        sql.append("update t_sfc_dpentry_opr set fstatus = 'E' where \r\n", new Object[0]);
        sql.appendIn("fid", dailyPlanIdSet.toArray());
        sql.append("and fstatus = 'A'", new Object[0]);
        DB.execute((DBRoute)DBRoute.of((String)"scm"), (SqlBuilder)sql);
    }

    public static void updateOrderStatus(Set<Object> dailyPlanIdSet) {
        if (dailyPlanIdSet == null || dailyPlanIdSet.size() < 1) {
            return;
        }
        SqlBuilder sql = new SqlBuilder();
        sql.append("update t_pom_mroorderentry set ftaskstatus = 'B' \r\n", new Object[0]);
        sql.append("where fentryid in (select fmroorderentryid from t_sfc_dpentry_opr where", new Object[0]);
        sql.appendIn("fid", dailyPlanIdSet.toArray());
        sql.append("and fstatus = 'E')", new Object[0]);
        sql.append("and ftaskstatus = 'A'", new Object[0]);
        DB.execute((DBRoute)DBRoute.of((String)"scm"), (SqlBuilder)sql);
    }
}

