/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.sfc.common.dailyplan.utils;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import kd.bd.mpdm.common.mftorder.enums.PrecisionAccountEnum;
import kd.bd.mpdm.common.mftorder.utils.OrderOpUtils;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.data.BusinessDataReader;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.runtime.ConvertOperationResult;
import kd.bos.entity.botp.runtime.PushArgs;
import kd.bos.entity.botp.runtime.SourceBillReport;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.botp.ConvertServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class DailyPlanToReportUtils {
    public static Map<String, Object> dailyPlanToReport(DynamicObject[] dailyplanUserBills, Date now) {
        HashMap<String, Object> reportMap = new HashMap<String, Object>(16);
        if (dailyplanUserBills == null || dailyplanUserBills.length < 1) {
            return reportMap;
        }
        if (now == null) {
            now = new Date();
        }
        HashSet<DynamicObject> successEntrys = new HashSet<DynamicObject>(16);
        StringBuilder errors = new StringBuilder(200);
        ArrayList<DynamicObject> maintenanceStandardTasks = new ArrayList<DynamicObject>(10);
        ArrayList<DynamicObject> dailyProjectTasks = new ArrayList<DynamicObject>(10);
        ArrayList<DynamicObject> companyDailyTasks = new ArrayList<DynamicObject>(10);
        block10: for (DynamicObject dailyplanUser : dailyplanUserBills) {
            String taskSrcType;
            switch (taskSrcType = dailyplanUser.getString("tasksrctype")) {
                case "A": {
                    maintenanceStandardTasks.add(dailyplanUser);
                    continue block10;
                }
                case "B": {
                    dailyProjectTasks.add(dailyplanUser);
                    continue block10;
                }
                case "C": {
                    companyDailyTasks.add(dailyplanUser);
                    continue block10;
                }
            }
        }
        DynamicObject unitwork = BusinessDataServiceHelper.loadSingleFromCache((Object)10L, (String)"bd_measureunits");
        DailyPlanToReportUtils.mroTechPlanToMroTechReport(maintenanceStandardTasks, errors, successEntrys, now, unitwork);
        DailyPlanToReportUtils.mroOrderToMroOrderReport(dailyProjectTasks, errors, successEntrys, now, unitwork);
        DailyPlanToReportUtils.dailyPlanToMroOrderReport(companyDailyTasks, errors, successEntrys, now);
        reportMap.put("errorInfo", errors.toString());
        reportMap.put("successEntrys", successEntrys);
        return reportMap;
    }

    private static void mroTechPlanToMroTechReport(List<DynamicObject> maintenanceStandardTasks, StringBuilder errors, Set<DynamicObject> successEntrys, Date now, DynamicObject unitwork) {
        if (CollectionUtils.isNotEmpty(maintenanceStandardTasks)) {
            List mroManftechToReportbills;
            Map<String, Object> pushResult = DailyPlanToReportUtils.pushDailyMroTechToMroManufTech(maintenanceStandardTasks);
            String pushErrorInfo = null == pushResult.get("errorInfo") ? "" : (String)pushResult.get("errorInfo");
            errors.append(pushErrorInfo);
            List list = mroManftechToReportbills = null == pushResult.get("targetBillObjs") ? null : (List)pushResult.get("targetBillObjs");
            if (mroManftechToReportbills != null && !mroManftechToReportbills.isEmpty()) {
                List saveSuccessPkIds;
                for (DynamicObject mroManftechToReportbill : mroManftechToReportbills) {
                    String billno = mroManftechToReportbill.getString("billno");
                    if (kd.bos.util.StringUtils.isBlank((String)billno)) {
                        billno = UUID.randomUUID().toString().substring(0, 30);
                        mroManftechToReportbill.set("billno", (Object)billno);
                    }
                    DailyPlanToReportUtils.packageTechReportBill(mroManftechToReportbill, maintenanceStandardTasks, now, unitwork);
                }
                OperateOption option = OperateOption.create();
                option.setVariableValue("ishasright", "true");
                option.setVariableValue("ignorewarn", "true");
                option.setVariableValue("ignoreinteraction", "true");
                OperationResult saveResult = OperationServiceHelper.executeOperate((String)"save", (String)"sfc_processreportbill", (DynamicObject[])mroManftechToReportbills.toArray(new DynamicObject[mroManftechToReportbills.size()]), (OperateOption)option);
                if (!saveResult.isSuccess()) {
                    String errorInfo = String.format(ResManager.loadKDString((String)"\u8c03\u7528\u68c0\u4fee\u5de5\u5e8f\u6c47\u62a5\u5355\u4fdd\u5b58\u64cd\u4f5c\u5931\u8d25\uff1a%1$s", (String)"DailyPlanToReportUtils_0", (String)"mmc-sfc-common", (Object[])new Object[0]), OrderOpUtils.getErrDetail((OperationResult)saveResult));
                    errors.append(errorInfo);
                }
                if (CollectionUtils.isNotEmpty((Collection)(saveSuccessPkIds = saveResult.getSuccessPkIds()))) {
                    OperationResult auditResult;
                    List submitSuccessPkIds;
                    String entityKey = "sfc_processreportbill";
                    String selectFields = "sumentry.oprentryid";
                    DailyPlanToReportUtils.getSuccessDailyEntrys(saveSuccessPkIds, entityKey, selectFields, maintenanceStandardTasks, successEntrys);
                    OperationResult submitResult = OperationServiceHelper.executeOperate((String)"submit", (String)"sfc_processreportbill", (Object[])saveSuccessPkIds.toArray(), (OperateOption)option);
                    if (!submitResult.isSuccess()) {
                        String errorInfo = String.format(ResManager.loadKDString((String)"\u8c03\u7528\u68c0\u4fee\u5de5\u5e8f\u6c47\u62a5\u5355\u63d0\u4ea4\u64cd\u4f5c\u5931\u8d25\uff1a%1$s", (String)"DailyPlanToReportUtils_1", (String)"mmc-sfc-common", (Object[])new Object[0]), OrderOpUtils.getErrDetail((OperationResult)submitResult));
                        errors.append(errorInfo);
                    }
                    if (CollectionUtils.isNotEmpty((Collection)(submitSuccessPkIds = submitResult.getSuccessPkIds())) && !(auditResult = OperationServiceHelper.executeOperate((String)"audit", (String)"sfc_processreportbill", (Object[])submitSuccessPkIds.toArray(), (OperateOption)option)).isSuccess()) {
                        String errorInfo = String.format(ResManager.loadKDString((String)"\u8c03\u7528\u68c0\u4fee\u5de5\u5e8f\u6c47\u62a5\u5355\u5ba1\u6838\u64cd\u4f5c\u5931\u8d25\uff1a%1$s", (String)"DailyPlanToReportUtils_2", (String)"mmc-sfc-common", (Object[])new Object[0]), OrderOpUtils.getErrDetail((OperationResult)auditResult));
                        errors.append(errorInfo);
                    }
                }
            }
        }
    }

    private static void mroOrderToMroOrderReport(List<DynamicObject> dailyProjectTasks, StringBuilder errors, Set<DynamicObject> successEntrys, Date now, DynamicObject unitwork) {
        if (CollectionUtils.isNotEmpty(dailyProjectTasks)) {
            List toReportBills;
            Map<String, Object> pushResult = DailyPlanToReportUtils.pushDailyMroOrderToMroReport(dailyProjectTasks);
            String pushErrorInfo = null == pushResult.get("errorInfo") ? "" : (String)pushResult.get("errorInfo");
            errors.append(pushErrorInfo);
            List list = toReportBills = null == pushResult.get("targetBillObjs") ? null : (List)pushResult.get("targetBillObjs");
            if (toReportBills != null && !toReportBills.isEmpty()) {
                for (DynamicObject mroOrderToReportBill : toReportBills) {
                    String billNo = mroOrderToReportBill.getString("billno");
                    if (kd.bos.util.StringUtils.isBlank((String)billNo)) {
                        billNo = UUID.randomUUID().toString().substring(0, 30);
                        mroOrderToReportBill.set("billno", (Object)billNo);
                    }
                    DailyPlanToReportUtils.packageMroOrderToOrderReportBill(mroOrderToReportBill, dailyProjectTasks, now, unitwork);
                }
                OperateOption option = OperateOption.create();
                option.setVariableValue("ishasright", "true");
                option.setVariableValue("ignorewarn", "true");
                option.setVariableValue("ignoreinteraction", "true");
                OperationResult saveResult = OperationServiceHelper.executeOperate((String)"save", (String)"pom_mftorderreport", (DynamicObject[])toReportBills.toArray(new DynamicObject[toReportBills.size()]), (OperateOption)option);
                if (!saveResult.isSuccess()) {
                    throw new KDBizException(new ErrorCode("submitMftOrderReportbill", String.format(ResManager.loadKDString((String)"\u8c03\u7528\u68c0\u4fee\u5de5\u5355\u6c47\u62a5\u5355\u63d0\u4ea4\u64cd\u4f5c\u5931\u8d25\uff1a%1$s", (String)"DailyPlanToReportUtils_3", (String)"mmc-sfc-common", (Object[])new Object[0]), OrderOpUtils.getErrDetail((OperationResult)saveResult))), new Object[0]);
                }
                List saveSuccessPkIds = saveResult.getSuccessPkIds();
                if (CollectionUtils.isNotEmpty((Collection)saveSuccessPkIds)) {
                    OperationResult auditResult;
                    List submitSuccessPkIds;
                    String entityKey = "pom_mftorderreport";
                    String selectFields = "sumentry.mftentryid";
                    DailyPlanToReportUtils.getSuccessDailyEntrys(saveSuccessPkIds, entityKey, selectFields, dailyProjectTasks, successEntrys);
                    OperationResult submitResult = OperationServiceHelper.executeOperate((String)"submit", (String)"pom_mftorderreport", (Object[])saveSuccessPkIds.toArray(), (OperateOption)option);
                    if (!submitResult.isSuccess()) {
                        String errorInfo = String.format(ResManager.loadKDString((String)"\u8c03\u7528\u68c0\u4fee\u5de5\u5355\u6c47\u62a5\u5355\u63d0\u4ea4\u64cd\u4f5c\u5931\u8d25\uff1a%1$s", (String)"DailyPlanToReportUtils_3", (String)"mmc-sfc-common", (Object[])new Object[0]), OrderOpUtils.getErrDetail((OperationResult)submitResult));
                        errors.append(errorInfo);
                    }
                    if (CollectionUtils.isNotEmpty((Collection)(submitSuccessPkIds = submitResult.getSuccessPkIds())) && !(auditResult = OperationServiceHelper.executeOperate((String)"audit", (String)"pom_mftorderreport", (Object[])submitSuccessPkIds.toArray(), (OperateOption)option)).isSuccess()) {
                        String errorInfo = String.format(ResManager.loadKDString((String)"\u8c03\u7528\u68c0\u4fee\u5de5\u5355\u6c47\u62a5\u5355\u5ba1\u6838\u64cd\u4f5c\u5931\u8d25\uff1a%1$s", (String)"DailyPlanToReportUtils_4", (String)"mmc-sfc-common", (Object[])new Object[0]), OrderOpUtils.getErrDetail((OperationResult)auditResult));
                        errors.append(errorInfo);
                    }
                }
            }
        }
    }

    private static void dailyPlanToMroOrderReport(List<DynamicObject> companyDailyTasks, StringBuilder errors, Set<DynamicObject> successEntrys, Date now) {
        if (CollectionUtils.isNotEmpty(companyDailyTasks)) {
            for (DynamicObject companyDailyTask : companyDailyTasks) {
                DynamicObjectCollection dailyEntrys = companyDailyTask.getDynamicObjectCollection("oprentryentity");
                for (DynamicObject dailyEntry : dailyEntrys) {
                    successEntrys.add(dailyEntry);
                }
            }
        }
    }

    private static Map<String, Object> pushDailyMroTechToMroManufTech(List<DynamicObject> dailyBills) {
        HashMap<String, Object> result = new HashMap<String, Object>(16);
        StringBuilder errorInfo = new StringBuilder(200);
        List targetBillObjs = null;
        if (CollectionUtils.isNotEmpty(dailyBills)) {
            PushArgs pushArgs = new PushArgs();
            pushArgs.setSourceEntityNumber("sfc_mromanuftech");
            pushArgs.setTargetEntityNumber("sfc_processreportbill");
            pushArgs.setHasRight(false);
            pushArgs.setRuleId("1403679803030113280");
            pushArgs.setBuildConvReport(true);
            HashSet<Long> set = new HashSet<Long>(16);
            ArrayList<ListSelectedRow> needPushRows = new ArrayList<ListSelectedRow>(10);
            for (DynamicObject dailyBill : dailyBills) {
                if (null == dailyBill) continue;
                DynamicObjectCollection dailyEntrys = dailyBill.getDynamicObjectCollection("oprentryentity");
                Iterator iterator = dailyEntrys.iterator();
                while (iterator.hasNext()) {
                    DynamicObject dailyEntry = (DynamicObject)iterator.next();
                    Long srcbillentryid = dailyEntry.getLong("srcbillentryid");
                    if (!set.add(srcbillentryid)) continue;
                    ListSelectedRow srcBill = new ListSelectedRow((Object)dailyEntry.getLong("srcbillid"));
                    srcBill.setEntryEntityKey("oprentryentity");
                    srcBill.setEntryPrimaryKeyValue((Object)srcbillentryid);
                    needPushRows.add(srcBill);
                }
            }
            if (needPushRows.isEmpty()) {
                errorInfo.append(ResManager.loadKDString((String)"\u5bf9\u5e94\u7684\u68c0\u4fee\u5de5\u5e8f\u8ba1\u5212\u6ca1\u6709\u9700\u8981\u4e0b\u63a8\u7684\u6570\u636e\u3002", (String)"DailyPlanToReportUtils_5", (String)"mmc-sfc-common", (Object[])new Object[0]));
            }
            pushArgs.setSelectedRows(needPushRows);
            ConvertOperationResult pushResult = ConvertServiceHelper.push((PushArgs)pushArgs);
            StringBuilder errMessage = new StringBuilder().append(null == pushResult.getMessage() || kd.bos.util.StringUtils.isBlank((String)pushResult.getMessage()) || "null".equals(pushResult.getMessage()) ? "" : pushResult.getMessage());
            for (SourceBillReport billReport : pushResult.getBillReports()) {
                if (kd.bos.util.StringUtils.isBlank((String)billReport.getFailMessage())) continue;
                String billNo = billReport.getBillNo();
                String info = "";
                if (!StringUtils.isBlank((CharSequence)billNo)) {
                    info = String.format("[%1$s]%2$s\u3002", billReport.getBillNo(), billReport.getFailMessage());
                }
                errMessage.append(info);
            }
            if (!"null".equals(errMessage.toString()) && !"".equals(errMessage.toString())) {
                String info = String.format(ResManager.loadKDString((String)"\u4e0b\u63a8\u5931\u8d25:%1$s", (String)"DailyPlanToReportUtils_6", (String)"mmc-sfc-common", (Object[])new Object[0]), errMessage);
                errorInfo.append(info);
            }
            MainEntityType targetMainType = EntityMetadataCache.getDataEntityType((String)"sfc_processreportbill");
            targetBillObjs = pushResult.loadTargetDataObjects(BusinessDataReader::loadRefence, targetMainType);
            result.put("errorInfo", errorInfo.toString());
            result.put("targetBillObjs", targetBillObjs);
        }
        return result;
    }

    private static void packageTechReportBill(DynamicObject techReportBill, List<DynamicObject> maintenanceStandardTasks, Date now, DynamicObject unitWork) {
        if (null != techReportBill && CollectionUtils.isNotEmpty(maintenanceStandardTasks)) {
            DynamicObjectCollection sumentrys = techReportBill.getDynamicObjectCollection("sumentry");
            HashMap<Long, ArrayList<DynamicObject>> techEntryIdAndRepSubEntrysMap = new HashMap<Long, ArrayList<DynamicObject>>(16);
            int precision = 2;
            String precisionAccount = "1";
            for (DynamicObject sumentry : sumentrys) {
                DynamicObjectCollection childReportEntrys = sumentry.getDynamicObjectCollection("childreportentity");
                DynamicObjectCollection repSubEntrys = sumentry.getDynamicObjectCollection("repsubentryentity");
                Long oprentryid = sumentry.getLong("oprentryid");
                DynamicObject dailyPlanOprentry = DailyPlanToReportUtils.matchDailyPlanOprentry(oprentryid, maintenanceStandardTasks);
                if (dailyPlanOprentry != null) {
                    sumentry.set("planconsumedhours", dailyPlanOprentry.get("workhour"));
                }
                sumentry.set("workunit", (Object)unitWork);
                List<DynamicObject> repSubEntrysInDailyPlan = DailyPlanToReportUtils.matchDailyPlanRepSubEntrys(oprentryid, maintenanceStandardTasks);
                if (CollectionUtils.isNotEmpty(repSubEntrysInDailyPlan)) {
                    for (DynamicObject repSubEntry : repSubEntrysInDailyPlan) {
                        if (repSubEntry.getBoolean("isreported")) continue;
                        DynamicObject childReportEntry = childReportEntrys.addNew();
                        childReportEntry.set("operator", repSubEntry.get("person"));
                        childReportEntry.set("personnelindustry", repSubEntry.getDynamicObject("person").get("professiona"));
                        childReportEntry.set("starttime", repSubEntry.get("reportbegintime"));
                        childReportEntry.set("closetime", (Object)now);
                        childReportEntry.set("repworkunit", (Object)unitWork);
                        Date reportbegintime = repSubEntry.getDate("reportbegintime");
                        BigDecimal beginTime = new BigDecimal(reportbegintime.getTime());
                        BigDecimal end = new BigDecimal(now.getTime());
                        BigDecimal subtract = end.subtract(beginTime);
                        if (null != unitWork) {
                            precision = unitWork.getInt("precision");
                            precisionAccount = unitWork.getString("precisionaccount");
                        }
                        childReportEntry.set("actconsumedhours", (Object)subtract.divide(new BigDecimal("3600000"), precision, PrecisionAccountEnum.getEnumByVal((int)Integer.parseInt(precisionAccount))));
                        childReportEntry.set("opactivity", repSubEntry.get("worktype"));
                    }
                    ArrayList<DynamicObject> repSubEntrysInDailyPlanTemp = (ArrayList<DynamicObject>)techEntryIdAndRepSubEntrysMap.get(oprentryid);
                    if (null == repSubEntrysInDailyPlanTemp) {
                        repSubEntrysInDailyPlanTemp = new ArrayList<DynamicObject>(10);
                    }
                    repSubEntrysInDailyPlanTemp.addAll(repSubEntrysInDailyPlan);
                    techEntryIdAndRepSubEntrysMap.put(oprentryid, repSubEntrysInDailyPlanTemp);
                }
                BigDecimal maintainHours = BigDecimal.ZERO;
                BigDecimal checkHours = BigDecimal.ZERO;
                List repSubEntrysInDailyPlanTemps = (List)techEntryIdAndRepSubEntrysMap.get(oprentryid);
                if (CollectionUtils.isNotEmpty((Collection)repSubEntrysInDailyPlanTemps)) {
                    for (DynamicObject repSubEntrysInDailyPlanTemp : repSubEntrysInDailyPlanTemps) {
                        String worktype = repSubEntrysInDailyPlanTemp.getString("worktype");
                        BigDecimal actualhour = repSubEntrysInDailyPlanTemp.getBigDecimal("actualhour");
                        if ("A".equals(worktype)) {
                            maintainHours = maintainHours.add(actualhour);
                            continue;
                        }
                        if (!"B".equals(worktype)) continue;
                        checkHours = checkHours.add(actualhour);
                    }
                }
                for (DynamicObject repSubEntry : repSubEntrys) {
                    repSubEntry.set("actchours", (Object)maintainHours);
                    repSubEntry.set("actihours", (Object)checkHours);
                }
            }
        }
    }

    private static void getSuccessDailyEntrys(List<Object> saveSuccessPkIds, String entityKey, String selectFields, List<DynamicObject> maintenanceStandardTasks, Set<DynamicObject> successEntrys) {
        HashSet<Long> successSrcEntryIds = new HashSet<Long>(16);
        QFilter qFilter = new QFilter("id", "in", saveSuccessPkIds);
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"querySaveSuccessReport", (String)entityKey, (String)selectFields, (QFilter[])new QFilter[]{qFilter}, (String)"");){
            while (ds.hasNext()) {
                Row dsRow = ds.next();
                successSrcEntryIds.add(dsRow.getLong(selectFields));
            }
        }
        for (DynamicObject maintenanceStandardTask : maintenanceStandardTasks) {
            DynamicObjectCollection dailyEntrys = maintenanceStandardTask.getDynamicObjectCollection("oprentryentity");
            for (DynamicObject dailyEntry : dailyEntrys) {
                if (!successSrcEntryIds.contains(dailyEntry.getLong("srcbillentryid"))) continue;
                successEntrys.add(dailyEntry);
            }
        }
    }

    private static Map<String, Object> pushDailyMroOrderToMroReport(List<DynamicObject> dailyBills) {
        HashMap<String, Object> result = new HashMap<String, Object>(16);
        return result;
    }

    private static void packageMroOrderToOrderReportBill(DynamicObject orderReportBill, List<DynamicObject> maintenanceStandardTasks, Date now, DynamicObject unitwork) {
        if (null != orderReportBill && maintenanceStandardTasks != null && !maintenanceStandardTasks.isEmpty()) {
            DynamicObjectCollection sumentrys = orderReportBill.getDynamicObjectCollection("sumentry");
            int precision = 2;
            String precisionAccount = "1";
            for (DynamicObject sumentry : sumentrys) {
                DynamicObjectCollection childReportEntrys = sumentry.getDynamicObjectCollection("childreportentity");
                Long mroOrderEntryId = sumentry.getLong("mftentryid");
                DynamicObject dailyPlanOprentry = DailyPlanToReportUtils.matchDailyPlanOprentry(mroOrderEntryId, maintenanceStandardTasks);
                if (dailyPlanOprentry != null) {
                    sumentry.set("planconsumedhours", dailyPlanOprentry.get("workhour"));
                    sumentry.set("profession", dailyPlanOprentry.get("profession"));
                    sumentry.set("dailyexptype", dailyPlanOprentry.get("dailyexptype"));
                }
                sumentry.set("workunit", (Object)unitwork);
                List<DynamicObject> repSubEntrysInDailyPlan = DailyPlanToReportUtils.matchDailyPlanRepSubEntrys(mroOrderEntryId, maintenanceStandardTasks);
                if (!CollectionUtils.isNotEmpty(repSubEntrysInDailyPlan)) continue;
                for (DynamicObject repSubEntry : repSubEntrysInDailyPlan) {
                    if (repSubEntry.getBoolean("isreported")) continue;
                    DynamicObject childReportEntry = childReportEntrys.addNew();
                    childReportEntry.set("userno", repSubEntry.get("person"));
                    childReportEntry.set("professiona", repSubEntry.getDynamicObject("person").get("professiona"));
                    childReportEntry.set("starttime", repSubEntry.get("reportbegintime"));
                    childReportEntry.set("closetime", (Object)now);
                    childReportEntry.set("repworkunit", (Object)unitwork);
                    Date reportbegintime = repSubEntry.getDate("reportbegintime");
                    BigDecimal beginTime = new BigDecimal(reportbegintime.getTime());
                    BigDecimal end = new BigDecimal(now.getTime());
                    BigDecimal subtract = end.subtract(beginTime);
                    if (null != unitwork) {
                        precision = unitwork.getInt("precision");
                        precisionAccount = unitwork.getString("precisionaccount");
                    }
                    childReportEntry.set("actconsumedhours", (Object)subtract.divide(new BigDecimal("3600000"), precision, PrecisionAccountEnum.getEnumByVal((int)Integer.parseInt(precisionAccount))));
                    childReportEntry.set("opactivity", repSubEntry.get("worktype"));
                }
            }
        }
    }

    private static DynamicObject matchDailyPlanOprentry(Long srcEntryId, List<DynamicObject> dailyPlanBills) {
        DynamicObject result = null;
        if (null != srcEntryId && dailyPlanBills != null && !dailyPlanBills.isEmpty()) {
            block0: for (DynamicObject dailyPlanBill : dailyPlanBills) {
                DynamicObjectCollection oprEntryEntitys = dailyPlanBill.getDynamicObjectCollection("oprentryentity");
                for (DynamicObject oprEntryEntity : oprEntryEntitys) {
                    Long srcBillEntryId = oprEntryEntity.getLong("srcbillentryid");
                    if (!srcEntryId.equals(srcBillEntryId)) continue;
                    result = oprEntryEntity;
                    continue block0;
                }
            }
        }
        return result;
    }

    private static List<DynamicObject> matchDailyPlanRepSubEntrys(Long srcEntryId, List<DynamicObject> dailyPlanBills) {
        ArrayList<DynamicObject> result = new ArrayList<DynamicObject>(10);
        if (null != srcEntryId && CollectionUtils.isNotEmpty(dailyPlanBills)) {
            for (DynamicObject dailyPlanBill : dailyPlanBills) {
                DynamicObjectCollection oprEntryEntitys = dailyPlanBill.getDynamicObjectCollection("oprentryentity");
                for (DynamicObject oprEntryEntity : oprEntryEntitys) {
                    Long srcBillEntryId = oprEntryEntity.getLong("srcbillentryid");
                    if (!srcEntryId.equals(srcBillEntryId)) continue;
                    DynamicObjectCollection repSubEntrys = oprEntryEntity.getDynamicObjectCollection("repsubentryentity");
                    for (DynamicObject repSubEntry : repSubEntrys) {
                        result.add(repSubEntry);
                    }
                }
            }
        }
        return result;
    }
}

