/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.sfc.common.dailyplan.utils;

import java.math.BigDecimal;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.mmc.sfc.common.dailyplan.utils.DailyPlanToReportUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MydailyPlanUtil {
    private static final Log logger = LogFactory.getLog(MydailyPlanUtil.class);

    public static DynamicObject getMydailyPlanGroup(long userId) {
        DynamicObject classgroup = null;
        QFilter qf = new QFilter("user", "=", (Object)userId);
        qf.and(new QFilter("enable", "=", (Object)"1"));
        qf.and(new QFilter("status", "=", (Object)"C"));
        DynamicObject manuperson = BusinessDataServiceHelper.loadSingleFromCache((String)"mpdm_manuperson", (String)"id,user", (QFilter[])new QFilter[]{qf});
        if (manuperson != null) {
            QFilter qf2 = new QFilter("entryentity.manuperson", "=", manuperson.getPkValue());
            qf2.and(new QFilter("enable", "=", (Object)"1"));
            qf2.and(new QFilter("status", "=", (Object)"C"));
            classgroup = BusinessDataServiceHelper.loadSingleFromCache((String)"mpdm_classgroup", (String)"id,entryentity.manuperson", (QFilter[])new QFilter[]{qf2});
        }
        return classgroup;
    }

    public static Set<Long> getMydailyPlanManupersonByGroup(String groupid) {
        HashSet<Long> resultSet = new HashSet<Long>(16);
        QFilter qf = new QFilter("id", "=", (Object)NumberUtils.toLong((String)groupid));
        qf.and(new QFilter("enable", "=", (Object)"1"));
        qf.and(new QFilter("status", "=", (Object)"C"));
        DynamicObject classgroup = BusinessDataServiceHelper.loadSingleFromCache((String)"mpdm_classgroup", (String)"id,entryentity.manuperson", (QFilter[])new QFilter[]{qf});
        if (classgroup != null) {
            DynamicObjectCollection entryentity = classgroup.getDynamicObjectCollection("entryentity");
            for (DynamicObject row : entryentity) {
                DynamicObject manuperson = row.getDynamicObject("manuperson");
                if (manuperson == null) continue;
                resultSet.add((Long)manuperson.getPkValue());
            }
        }
        return resultSet;
    }

    public static void syncDailyPlan(String status, HashSet<Long> oprentryids) {
        if (StringUtils.isBlank((CharSequence)status) || CollectionUtils.isEmpty(oprentryids)) {
            return;
        }
        Date now = TimeServiceHelper.now();
        DynamicObject hourUnit = BusinessDataServiceHelper.loadSingleFromCache((Object)10L, (String)"bd_measureunits");
        QFilter filter = new QFilter("oprentryentity.srcbillentryid", "in", oprentryids);
        StringBuilder selectors = new StringBuilder(420);
        selectors.append("id,billno,taskstatus,tasksrctype,");
        selectors.append("oprentryentity,oprentryentity.srcbillid,oprentryentity.srcbillentryid,oprentryentity.workhour,oprentryentity.profession,oprentryentity.dailyexptype,");
        selectors.append("repsubentryentity.id,repsubentryentity.person,repsubentryentity.reportbegintime,status,");
        selectors.append("repsubentryentity.reportendtime,repsubentryentity.workhourunit,repsubentryentity.actualhour,");
        selectors.append("repsubentryentity.worktype,repsubentryentity.isreported");
        DynamicObject[] dailyplans = BusinessDataServiceHelper.load((String)"sfc_dailyplan", (String)selectors.toString(), (QFilter[])new QFilter[]{filter});
        if (dailyplans == null || dailyplans.length < 1) {
            return;
        }
        Map<String, Object> reportMap = DailyPlanToReportUtils.dailyPlanToReport(dailyplans, now);
        String errorInfo = (String)reportMap.get("errorInfo");
        if (StringUtils.isNotBlank((CharSequence)errorInfo)) {
            logger.error((Object)("\u751f\u6210\u6c47\u62a5\u5355\u5931\u8d25\uff1a" + errorInfo));
        }
        HashSet<DynamicObject> saveObjects = new HashSet<DynamicObject>(oprentryids.size());
        for (DynamicObject dailyplan : dailyplans) {
            DynamicObjectCollection oprentryentitys = dailyplan.getDynamicObjectCollection("oprentryentity");
            for (DynamicObject oprentryentity : oprentryentitys) {
                long srcbillentryid = oprentryentity.getLong("srcbillentryid");
                if (!oprentryids.contains(srcbillentryid)) continue;
                saveObjects.add(dailyplan);
                oprentryentity.set("status", (Object)status);
                DynamicObjectCollection repsubentryentitys = oprentryentity.getDynamicObjectCollection("repsubentryentity");
                for (DynamicObject repsubentryentity : repsubentryentitys) {
                    if (repsubentryentity.get("reportbegintime") == null || repsubentryentity.get("reportendtime") != null) continue;
                    Date reportbegintime = repsubentryentity.getDate("reportbegintime");
                    BigDecimal beginTime = new BigDecimal(reportbegintime.getTime());
                    BigDecimal end = new BigDecimal(now.getTime());
                    BigDecimal subtract = end.subtract(beginTime);
                    repsubentryentity.set("reportendtime", (Object)now);
                    repsubentryentity.set("workhourunit", (Object)hourUnit);
                    repsubentryentity.set("actualhour", (Object)subtract.divide(new BigDecimal("3600000"), 2, 4));
                    repsubentryentity.set("isreported", (Object)Boolean.TRUE);
                }
            }
            boolean isAllFinishflag = true;
            for (DynamicObject oprentry : oprentryentitys) {
                if ("F".equals(oprentry.getString("status"))) continue;
                isAllFinishflag = false;
            }
            if (!isAllFinishflag) continue;
            dailyplan.set("taskstatus", (Object)"C");
        }
        if (saveObjects.size() > 0) {
            SaveServiceHelper.update((DynamicObject[])saveObjects.toArray(new DynamicObject[saveObjects.size()]));
        }
    }
}

