/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.sfc.common.manuftech.utils;

import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bd.mpdm.common.mftorder.entity.OrderManuftechTypeInfo;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.mmc.sfc.common.manuftech.utils.CheckManuOrderUtil;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ChangeTechnicsBillEntryStatus {
    private static final Log logger = LogFactory.getLog(ChangeTechnicsBillEntryStatus.class);

    public static void changeEntryStatus2(String status, boolean cancel, String operateKey, Set<Long> objects, DynamicObject[] technicsBills) {
        long startTime = System.currentTimeMillis();
        Date date = new Date();
        long userId = RequestContext.get().getCurrUserId();
        String orderType = "pom_mftorder";
        if (null != technicsBills[0]) {
            orderType = new OrderManuftechTypeInfo(technicsBills[0].getDataEntityType().getName()).getTarname();
        }
        HashSet<Object> orderEntryIds = new HashSet<Object>(16);
        HashSet<Object> bizTypIds = new HashSet<Object>(16);
        for (int i = 0; i < technicsBills.length; ++i) {
            DynamicObject transaction = technicsBills[i].getDynamicObject("transactiontype").getDynamicObject("transactiontype");
            bizTypIds.add(transaction.getPkValue());
        }
        Map bizTypeMap = BusinessDataServiceHelper.loadFromCache((String)"bd_biztype", (String)"id,number", (QFilter[])new QFilter[]{new QFilter("id", "in", bizTypIds)});
        for (int i = 0; i < technicsBills.length; ++i) {
            DynamicObject transaction = technicsBills[i].getDynamicObject("transactiontype").getDynamicObject("transactiontype");
            DynamicObject bizType = (DynamicObject)bizTypeMap.get(transaction.getPkValue());
            Boolean isoutbill = Boolean.FALSE;
            if ("408".equals(bizType.getString("number")) && technicsBills[i].getDynamicObject("transactiontype").getBoolean("isprocedure")) {
                isoutbill = Boolean.TRUE;
            }
            DynamicObjectCollection entryCol = technicsBills[i].getDynamicObjectCollection("oprentryentity");
            for (int j = 0; j < entryCol.size(); ++j) {
                if (!objects.contains(((DynamicObject)entryCol.get(j)).getPkValue())) continue;
                if (!"sfc_manftech".equals(technicsBills[i].getDataEntityType().getName()) || "1002".equals(((DynamicObject)entryCol.get(j)).getString("machiningtype"))) {
                    // empty if block
                }
                if (StringUtils.isNotBlank((CharSequence)status)) {
                    technicsBills[i].set("modifier", (Object)userId);
                    technicsBills[i].set("modifytime", (Object)date);
                    ((DynamicObject)entryCol.get(j)).set("oprstatus", (Object)status);
                    if ("pom_mroorder".equals(orderType)) {
                        ((DynamicObject)entryCol.get(j)).set("oprmodifytime", (Object)date);
                        ((DynamicObject)entryCol.get(j)).set("oprmodifier", (Object)userId);
                    }
                    if (isoutbill.booleanValue()) continue;
                    orderEntryIds.add(technicsBills[i].getDynamicObject("mftentryseq").getPkValue());
                    continue;
                }
                HashSet operateKeySet = Sets.newHashSet((Object[])new String[]{"donothing_cancel", "donothing_uncancel", "row_cancel", "row_uncancel"});
                if (operateKeySet.contains(operateKey)) {
                    ((DynamicObject)entryCol.get(j)).set("oprinvalid", (Object)cancel);
                }
                if (!"donothing_normal".equals(operateKey) && !"donothing_abnormal".equals(operateKey)) continue;
                ((DynamicObject)entryCol.get(j)).set("abnormalstatus", (Object)cancel);
            }
        }
        if ("pom_mroorder".equals(orderType)) {
            ChangeTechnicsBillEntryStatus.changeGroEntryEntityStatusByOprEntryEntity(technicsBills, date, userId);
        }
        SaveServiceHelper.save((DynamicObject[])technicsBills);
        CheckManuOrderUtil.updateManuOrderEntryStatus2(orderType, technicsBills[0].getDataEntityType().getName(), status, operateKey, orderEntryIds, technicsBills);
        long endTime = System.currentTimeMillis() - startTime;
        logger.warn((Object)("\u8c03\u7528ChangeTechnicsBillEntryStatus#changeEntryStatus\u65b9\u6cd5------------------------\u82b1\u8d39\u65f6\u95f4:" + endTime));
    }

    public static void changeGroupEntryStatus(String status, Set<Long> objects, DynamicObject[] technicsBills) {
        Date date = new Date();
        long userId = RequestContext.get().getCurrUserId();
        for (int i = 0; i < technicsBills.length; ++i) {
            DynamicObjectCollection entryCol = technicsBills[i].getDynamicObjectCollection("groentryentity");
            for (Long o : objects) {
                for (int j = 0; j < entryCol.size(); ++j) {
                    if (!((Object)o).toString().equals(((DynamicObject)entryCol.get(j)).getPkValue().toString()) || !StringUtils.isNotBlank((CharSequence)status)) continue;
                    technicsBills[i].set("modifier", (Object)userId);
                    technicsBills[i].set("modifytime", (Object)date);
                    ((DynamicObject)entryCol.get(j)).set("grogroupstatus", (Object)status);
                    ((DynamicObject)entryCol.get(j)).set("gromodifier", (Object)userId);
                    ((DynamicObject)entryCol.get(j)).set("gromodifytime", (Object)date);
                }
            }
        }
        SaveServiceHelper.save((DynamicObject[])technicsBills);
    }

    public static void changeGroEntryEntityStatusByOprEntryEntity(DynamicObject[] technicsBills, Date date, long userId) {
        HashSet status = Sets.newHashSet((Object[])new String[]{"C", "D", "E"});
        for (int i = 0; i < technicsBills.length; ++i) {
            DynamicObjectCollection oprEntryEntity = technicsBills[i].getDynamicObjectCollection("oprentryentity");
            Map<DynamicObject, List<DynamicObject>> map = oprEntryEntity.stream().filter(x -> x.getDynamicObject("oprprocessgroup") != null).collect(Collectors.groupingBy(x -> x.getDynamicObject("oprprocessgroup")));
            HashMap result = new HashMap(16);
            map.forEach((k, v) -> result.put(k, v.stream().map(x -> x.getString("oprstatus")).collect(Collectors.toList())));
            DynamicObjectCollection groEntryEntity = technicsBills[i].getDynamicObjectCollection("groentryentity");
            for (DynamicObject object : groEntryEntity) {
                List list = (List)result.get(object.getDynamicObject("groprocessgroup"));
                if (!CollectionUtils.isNotEmpty((Collection)list)) continue;
                Map statusMap = list.stream().collect(Collectors.groupingBy(Function.identity(), Collectors.counting()));
                if (statusMap.get("E") != null && statusMap.get("E") > 0L && !status.contains(object.getString("grogroupstatus"))) {
                    object.set("grogroupstatus", (Object)"B");
                    object.set("gromodifier", (Object)userId);
                    object.set("gromodifytime", (Object)date);
                }
                if (statusMap.get("F") != null && statusMap.get("F") == (long)list.size() && !status.contains(object.getString("grogroupstatus"))) {
                    object.set("grogroupstatus", (Object)"C");
                    object.set("gromodifier", (Object)userId);
                    object.set("gromodifytime", (Object)date);
                }
                if (statusMap.get("D") == null || statusMap.get("D") <= 0L || !"C".equals(object.getString("grogroupstatus"))) continue;
                object.set("grogroupstatus", (Object)"A");
                object.set("gromodifier", (Object)userId);
                object.set("gromodifytime", (Object)date);
            }
        }
    }
}

