/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.sfc.common.manuftech.utils;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bd.mpdm.common.mftorder.enums.ManuBillTaskStatusEnum;
import kd.bd.mpdm.common.utils.DateUtils;
import kd.bd.mpdm.common.utils.MPDMListUtils;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.mmc.sfc.common.utils.SfcDyObjUtils;

public class CheckManuOrderUtil {
    public static StringBuffer checkManuOrderEntryStatus(String checkType, String billno, String operationName, Map<String, Object> orderMap, String type) {
        StringBuffer errors = new StringBuffer();
        if (orderMap == null) {
            errors.append(String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\u8ba1\u5212\u5bf9\u5e94%s\u5de5\u5355\u5206\u5f55\u5df2\u88ab\u5220\u9664\u3002", (String)"CheckManuOrderUtil_5", (String)"mmc-sfc-common", (Object[])new Object[0]), type)).append("\n");
            return errors;
        }
        if ("checkTaskStatus".equals(checkType)) {
            if ("B".equals(orderMap.get("treeentryentity.bizstatus"))) {
                errors.append(String.format(ResManager.loadKDString((String)"%1$s\u5de5\u5355\u4e1a\u52a1\u72b6\u6001\u4e3a\u6302\u8d77\uff08\u5de5\u5355\u7f16\u53f7\uff1a%2$s\uff1b\u5de5\u5355\u884c\u53f7\uff1a%3$s\uff09\uff0c\u4e0d\u5141\u8bb8\u6539\u53d8\u5de5\u5e8f\u72b6\u6001\u3002", (String)"CheckManuOrderUtil_6", (String)"mmc-sfc-common", (Object[])new Object[0]), type, orderMap.get("billno"), orderMap.get("treeentryentity.seq"))).append("\n");
            } else if ("C".equals(orderMap.get("treeentryentity.bizstatus"))) {
                errors.append(String.format(ResManager.loadKDString((String)"%1$s\u5de5\u5355\uff08%2$s\uff09\u884c\u4e1a\u52a1\u72b6\u6001\u4e3a\u5173\u95ed\uff0c\u4e0d\u5141\u8bb8\u6539\u53d8\u5de5\u5e8f\u72b6\u6001\u3002", (String)"CheckManuOrderUtil_7", (String)"mmc-sfc-common", (Object[])new Object[0]), type, orderMap.get("billno"))).append("\n");
            }
        } else if ("checkBizStatus".equals(checkType) && !"C".equals(orderMap.get("treeentryentity.planstatus"))) {
            errors.append(String.format(ResManager.loadKDString((String)"%1$s\u5de5\u5355\uff08%2$s\uff09\u884c\u8ba1\u5212\u72b6\u6001\u4e0d\u4e3a\u4e0b\u8fbe\uff0c\u4e0d\u5141\u8bb8", (String)"CheckManuOrderUtil_8", (String)"mmc-sfc-common", (Object[])new Object[0]), type, orderMap.get("billno"))).append(operationName).append("\u3002\n");
        }
        return errors;
    }

    public static void updateManuOrderEntryStatus2(String orderType, String manftechType, String status, String operateKey, Set<Object> entryPks, DynamicObject[] technicsBills) {
        QFilter filter = new QFilter("treeentryentity.id", "in", entryPks);
        Date date = new Date();
        DynamicObject[] mftOrders = BusinessDataServiceHelper.load((String)orderType, (String)"org,isinitbill,id,pid,taskstatus,producttype,startworktime,quainwaqty,unquainwaqty,scrinwaqty,baseqty", (QFilter[])new QFilter[]{filter});
        Map<Long, Date> costSubOneDateMap = CheckManuOrderUtil.getCostSubOneDateMap(mftOrders);
        for (int i = 0; i < mftOrders.length; ++i) {
            boolean isinitbill = mftOrders[i].containsProperty("isinitbill") && mftOrders[i].getBoolean("isinitbill");
            Long orgID = SfcDyObjUtils.getDyObjId(mftOrders[i].get("org"));
            for (int j = 0; j < mftOrders[i].getDynamicObjectCollection("treeentryentity").size(); ++j) {
                DynamicObject entryObj = (DynamicObject)mftOrders[i].getDynamicObjectCollection("treeentryentity").get(j);
                String taskstatus = entryObj.getString("taskstatus");
                if ("C".equals(taskstatus) || "D".equals(taskstatus)) continue;
                ArrayList<DynamicObject> subEntryObjs = new ArrayList<DynamicObject>();
                for (int k = 0; k < mftOrders[i].getDynamicObjectCollection("treeentryentity").size(); ++k) {
                    if (!entryObj.getPkValue().toString().equals(((DynamicObject)mftOrders[i].getDynamicObjectCollection("treeentryentity").get(k)).get("pid").toString())) continue;
                    subEntryObjs.add((DynamicObject)mftOrders[i].getDynamicObjectCollection("treeentryentity").get(k));
                }
                for (Object o : entryPks) {
                    boolean finish;
                    if (!o.equals(entryObj.getPkValue())) continue;
                    boolean start = operateKey.contains("start") && "E".equals(status) && "A".equals(entryObj.getString("taskstatus"));
                    boolean bl = finish = operateKey.contains("finish") && "F".equals(status) && "A".equals(entryObj.getString("taskstatus"));
                    if (start || finish) {
                        String taskStatus = "B";
                        if (isinitbill) {
                            date = costSubOneDateMap.get(orgID);
                            if (date == null) {
                                date = new Date();
                            }
                            taskStatus = CheckManuOrderUtil.getTaskStatus(entryObj);
                        }
                        entryObj.set("taskstatus", (Object)taskStatus);
                        if (entryObj.getDate("startworktime") == null) {
                            entryObj.set("startworktime", (Object)date);
                        }
                        CheckManuOrderUtil.updateSubEntryObjs(subEntryObjs, taskStatus, date);
                    }
                    if (!operateKey.contains("unrelease") && !operateKey.contains("unplan") && !operateKey.contains("unconfirm")) continue;
                    for (int k = 0; k < technicsBills.length; ++k) {
                        DynamicObjectCollection dynamicObjectCollection;
                        List collect;
                        if (!entryObj.getPkValue().equals(technicsBills[k].getDynamicObject("mftentryseq").getPkValue()) || (collect = (dynamicObjectCollection = technicsBills[k].getDynamicObjectCollection("oprentryentity")).stream().map(x -> x.getString("oprstatus")).collect(Collectors.toList())).contains("E") || collect.contains("F") || collect.contains("G")) continue;
                        entryObj.set("taskstatus", (Object)"A");
                        entryObj.set("startworktime", null);
                        CheckManuOrderUtil.updateSubEntryObjs(subEntryObjs, "A", null);
                    }
                }
            }
        }
        SaveServiceHelper.save((DynamicObject[])mftOrders);
    }

    private static void updateSubEntryObjs(List<DynamicObject> subEntryObjs, String value, Date date) {
        if (subEntryObjs == null || subEntryObjs.size() < 1) {
            return;
        }
        for (DynamicObject obj : subEntryObjs) {
            obj.set("taskstatus", (Object)value);
            if (obj.getDate("startworktime") != null) continue;
            obj.set("startworktime", (Object)date);
        }
    }

    private static List<Map<String, Object>> cadQueryStartCostAccountInfo(List<Long> orgIds, String orgViewType) {
        if (orgIds == null) {
            ErrorCode errorCode = new ErrorCode("paramError", "paramError");
            throw new KDBizException(errorCode, new Object[]{"orgIds is null"});
        }
        List subList = MPDMListUtils.getSubList((int)500, orgIds);
        ArrayList<Map<String, Object>> returnMapList = new ArrayList<Map<String, Object>>(16);
        for (List orgLs : subList) {
            List mapList = (List)DispatchServiceHelper.invokeBizService((String)"macc", (String)"cad", (String)"StartCostAccountService", (String)"queryStartCostAccountInfoList", (Object[])new Object[]{orgLs, orgViewType});
            returnMapList.addAll(mapList);
        }
        return returnMapList;
    }

    private static Map<Long, Date> getCostSubOneDateMap(Set<Long> orgIds) {
        HashMap<Long, Date> orgId_earliestBeginDate = new HashMap<Long, Date>(16);
        if (orgIds == null) {
            return orgId_earliestBeginDate;
        }
        if (orgIds.isEmpty()) {
            return orgId_earliestBeginDate;
        }
        List<Map<String, Object>> dataList = CheckManuOrderUtil.cadQueryStartCostAccountInfo(new ArrayList<Long>(orgIds), "04");
        for (Map<String, Object> dataMap : dataList) {
            Object earliestBeginDate;
            Object orgId = dataMap.get("orgId");
            if (orgId == null || !((earliestBeginDate = dataMap.get("earliestBeginDate")) instanceof Date)) continue;
            Date date = (Date)earliestBeginDate;
            orgId_earliestBeginDate.put(Long.valueOf(orgId.toString()), DateUtils.addDay((Date)date, (int)-1));
        }
        return orgId_earliestBeginDate;
    }

    private static Map<Long, Date> getCostSubOneDateMap(DynamicObject[] manuObjs) {
        HashSet<Long> orgIds = new HashSet<Long>(16);
        for (DynamicObject mftOrder : manuObjs) {
            Long orgID;
            boolean isinitbill;
            boolean bl = isinitbill = mftOrder.containsProperty("isinitbill") && mftOrder.getBoolean("isinitbill");
            if (!isinitbill || !SfcDyObjUtils.isNotEmptyId(orgID = SfcDyObjUtils.getDyObjId(mftOrder.get("org")))) continue;
            orgIds.add(orgID);
        }
        return CheckManuOrderUtil.getCostSubOneDateMap(orgIds);
    }

    private static String getTaskStatus(DynamicObject entry) {
        String taskStatus = "B";
        BigDecimal quainwaqty = entry.getBigDecimal("quainwaqty");
        BigDecimal unquainwaqty = entry.getBigDecimal("unquainwaqty");
        BigDecimal scrinwaqty = entry.getBigDecimal("scrinwaqty");
        BigDecimal baseqty = entry.getBigDecimal("baseqty");
        BigDecimal sum = quainwaqty.add(unquainwaqty).add(scrinwaqty);
        if (sum.compareTo(BigDecimal.ZERO) > 0 && sum.compareTo(baseqty) < 0) {
            taskStatus = ManuBillTaskStatusEnum.SOMEENDWORK.getValue();
        } else if (sum.compareTo(baseqty) >= 0) {
            taskStatus = ManuBillTaskStatusEnum.ENDWORK.getValue();
        }
        return taskStatus;
    }
}

