/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.sfc.common.manuftech.utils;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;

public class MroManuftechUtil {
    public static void opDispatchPage(IFormPlugin form, IFormView view, String entryids, String formId, DynamicObject oprassignor, DynamicObjectCollection oprmulreceiver) {
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId(formId);
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setCustomParam("entryids", (Object)entryids);
        if (null != oprassignor) {
            parameter.setCustomParam("oprassignor", oprassignor.getPkValue());
        }
        if (null != oprmulreceiver && oprmulreceiver.size() > 0) {
            parameter.setCustomParam("oprmulreceiver", (Object)oprmulreceiver);
        }
        parameter.setCloseCallBack(new CloseCallBack(form, "dispatchCallback"));
        view.showForm(parameter);
    }

    public static void showLogForm(IFormView view, String entryid) {
        DynamicObject xmromanuftechlog = BusinessDataServiceHelper.loadSingle((String)"sfc_mromanuftechlog", (String)"id", (QFilter[])new QFilter[]{new QFilter("manbillentryid", "=", (Object)entryid)});
        if (null != xmromanuftechlog) {
            BillShowParameter billShowParameter = new BillShowParameter();
            billShowParameter.setPkId(xmromanuftechlog.getPkValue());
            billShowParameter.setFormId("sfc_mromanuftechlog");
            billShowParameter.getOpenStyle().setShowType(ShowType.Modal);
            billShowParameter.setStatus(OperationStatus.VIEW);
            view.showForm((FormShowParameter)billShowParameter);
        } else {
            view.showTipNotification(ResManager.loadKDString((String)"\u4e0d\u5b58\u5728\u6d3e\u5de5\u8bb0\u5f55", (String)"MroManuftechUtil_0", (String)"mmc-sfc-common", (Object[])new Object[0]));
        }
    }

    public static DynamicObject[] dodisptachprocess(DynamicObject[] mroBills, Map<String, Object> map) {
        for (DynamicObject mroBill : mroBills) {
            DynamicObjectCollection oprentryentitys = mroBill.getDynamicObjectCollection("oprentryentity");
            for (DynamicObject obj : oprentryentitys) {
                DynamicObjectCollection receivers;
                if (!map.get("entryids").toString().contains(obj.getString("id"))) continue;
                obj.set("oprmodifier", (Object)UserServiceHelper.getCurrentUserId());
                if (null != map.get("assignor")) {
                    obj.set("oprassignor", map.get("assignor"));
                }
                if (null != map.get("receiver") && (receivers = (DynamicObjectCollection)map.get("receiver")).size() > 0) {
                    DynamicObjectCollection oprmulreceiver = obj.getDynamicObjectCollection("oprmulreceiver");
                    oprmulreceiver.clear();
                    for (DynamicObject receiver : receivers) {
                        DynamicObject mulBasedataDy = new DynamicObject(oprmulreceiver.getDynamicObjectType());
                        mulBasedataDy.set("fbasedataid", (Object)receiver.getDynamicObject("fbasedataid"));
                        oprmulreceiver.add((Object)mulBasedataDy);
                    }
                }
                if (null != map.get("planbegintime")) {
                    obj.set("oprplanbegintime", map.get("planbegintime"));
                }
                if (null == map.get("planendtime")) continue;
                obj.set("oprplanfinishtime", map.get("planendtime"));
            }
            mroBill.set("modifier", (Object)UserServiceHelper.getCurrentUserId());
            mroBill.set("modifytime", (Object)new Date());
        }
        return mroBills;
    }

    public static Map<String, List<DynamicObject>> doMromanuftechlog(Map<String, Object> map, Map<String, Map<String, Object>> srcmap) {
        List entryIds = (List)map.get("entryids");
        DynamicObject[] logbills = BusinessDataServiceHelper.load((String)"sfc_mromanuftechlog", (String)"id,manbillno,manoprno,manbillid,manbillentryid,entryentity.seq,entryentity.planbegintime,entryentity.planendtime,entryentity.changer,entryentity.changetime,entryentity.receiver,entryentity.assignor,entryentity.assignor_tag,entryentity.receiver_tag", (QFilter[])new QFilter[]{new QFilter("manbillentryid", "in", entryIds.stream().map(String::valueOf).collect(Collectors.toList()))});
        HashMap<String, List<DynamicObject>> resultMap = new HashMap<String, List<DynamicObject>>(10);
        HashMap<String, DynamicObject> logMap = new HashMap<String, DynamicObject>(10);
        for (DynamicObject logBill : logbills) {
            logMap.put(logBill.getString("manbillentryid"), logBill);
        }
        ArrayList<DynamicObject> saveLogs = new ArrayList<DynamicObject>(10);
        ArrayList<DynamicObject> updateLogs = new ArrayList<DynamicObject>(10);
        for (int i = 0; i < entryIds.size(); ++i) {
            Map<String, Object> entrymap = srcmap.get(entryIds.get(i).toString());
            DynamicObject xmromanuftechlog = (DynamicObject)logMap.get(entryIds.get(i).toString());
            DynamicObject newSubEntryObj = null;
            if (null == xmromanuftechlog) {
                xmromanuftechlog = MroManuftechUtil.getNewDynamicObject("sfc_mromanuftechlog");
                xmromanuftechlog.set("manbillid", entrymap.get("id"));
                xmromanuftechlog.set("manbillentryid", entryIds.get(i));
                xmromanuftechlog.set("manbillno", entrymap.get("billno"));
                xmromanuftechlog.set("manoprno", entrymap.get("oprno"));
                newSubEntryObj = MroManuftechUtil.getNewDynamicObject("sfc_mromanuftechlog.entryentity");
                MroManuftechUtil.setLogEntryinfo(newSubEntryObj, map, entrymap);
                xmromanuftechlog.getDynamicObjectCollection("entryentity").add((Object)newSubEntryObj);
                saveLogs.add(xmromanuftechlog);
            } else {
                newSubEntryObj = xmromanuftechlog.getDynamicObjectCollection("entryentity").addNew();
                MroManuftechUtil.setLogEntryinfo(newSubEntryObj, map, entrymap);
                updateLogs.add(xmromanuftechlog);
            }
            newSubEntryObj.set("seq", (Object)xmromanuftechlog.getDynamicObjectCollection("entryentity").size());
        }
        resultMap.put("saveLogs", saveLogs);
        resultMap.put("updateLogs", updateLogs);
        return resultMap;
    }

    private static DynamicObject getNewDynamicObject(String key) {
        ORM orm = ORM.create();
        return orm.newDynamicObject(key);
    }

    public static DynamicObject setLogEntryinfo(DynamicObject newSubEntryObj, Map<String, Object> map, Map<String, Object> entrymap) {
        newSubEntryObj.set("changer", (Object)UserServiceHelper.getCurrentUserId());
        newSubEntryObj.set("changetime", (Object)new Date());
        if (null != map.get("assignor")) {
            DynamicObject assignor = (DynamicObject)map.get("assignor");
            String assignorLog = assignor.getString("name");
            if (entrymap.containsKey("oprassignor")) {
                assignorLog = entrymap.get("oprassignor") + " -> " + assignor.getString("name");
            }
            newSubEntryObj.set("assignor_tag", (Object)assignorLog);
        }
        if (null != map.get("receiver")) {
            DynamicObjectCollection receiver = (DynamicObjectCollection)map.get("receiver");
            StringBuilder srcreceiverinfo = (StringBuilder)entrymap.get("oprmulreceiver");
            StringBuilder receiverinfo = new StringBuilder();
            for (DynamicObject obj : receiver) {
                receiverinfo.append(obj.getDynamicObject("fbasedataid").getString("name")).append(" ");
            }
            String receiverLog = receiverinfo.toString();
            if (srcreceiverinfo.length() > 0 && receiverinfo.length() > 0) {
                receiverLog = srcreceiverinfo + " -> " + receiverinfo;
            }
            newSubEntryObj.set("receiver_tag", (Object)receiverLog);
        }
        if (null != map.get("planbegintime")) {
            Date planbegintime = (Date)map.get("planbegintime");
            if (entrymap.containsKey("oprplanbegintime")) {
                newSubEntryObj.set("planbegintime", (Object)(entrymap.get("oprplanbegintime") + " -> " + MroManuftechUtil.transDate(planbegintime)));
            } else {
                newSubEntryObj.set("planbegintime", (Object)MroManuftechUtil.transDate(planbegintime));
            }
        }
        if (null != map.get("planendtime")) {
            Date planendtime = (Date)map.get("planendtime");
            if (entrymap.containsKey("oprplanfinishtime")) {
                newSubEntryObj.set("planendtime", (Object)(entrymap.get("oprplanfinishtime") + " -> " + MroManuftechUtil.transDate(planendtime)));
            } else {
                newSubEntryObj.set("planendtime", (Object)MroManuftechUtil.transDate(planendtime));
            }
        }
        return newSubEntryObj;
    }

    public static String transDate(Object value) {
        return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format((Date)value);
    }

    public static Map<String, Map<String, Object>> getSrcBillInfo(DynamicObject[] mrobills, Map<String, Object> map) {
        HashMap<String, Map<String, Object>> srcmap = new HashMap<String, Map<String, Object>>(10);
        for (DynamicObject mroBill : mrobills) {
            DynamicObjectCollection oprentryentitys = mroBill.getDynamicObjectCollection("oprentryentity");
            for (DynamicObject obj : oprentryentitys) {
                Date srcplanendtime;
                if (!map.get("entryids").toString().contains(obj.getString("id"))) continue;
                HashMap<String, Object> entrymap = new HashMap<String, Object>(10);
                entrymap.put("id", mroBill.getPkValue());
                entrymap.put("billno", mroBill.get("billno"));
                entrymap.put("oprno", obj.get("oprno"));
                DynamicObject assignor = (DynamicObject)obj.get("oprassignor");
                if (null != assignor) {
                    entrymap.put("oprassignor", assignor.getString("name"));
                }
                DynamicObjectCollection receivers = (DynamicObjectCollection)obj.get("oprmulreceiver");
                StringBuilder receiverinfo = new StringBuilder();
                for (DynamicObject receiver : receivers) {
                    receiverinfo.append(receiver.getDynamicObject("fbasedataid").getString("name")).append(" ");
                }
                entrymap.put("oprmulreceiver", receiverinfo);
                Date srcplanbegintime = (Date)obj.get("oprplanbegintime");
                if (null != srcplanbegintime) {
                    entrymap.put("oprplanbegintime", MroManuftechUtil.transDate(srcplanbegintime));
                }
                if (null != (srcplanendtime = (Date)obj.get("oprplanfinishtime"))) {
                    entrymap.put("oprplanfinishtime", MroManuftechUtil.transDate(srcplanendtime));
                }
                srcmap.put(obj.getString("id"), entrymap);
            }
        }
        return srcmap;
    }

    public static void oprentryentitySort(DynamicObjectCollection dynamicObjectCollection) {
        if (!dynamicObjectCollection.isEmpty()) {
            dynamicObjectCollection.sort((arg0, arg1) -> {
                int seqnum2;
                DynamicObject oprprocessgroup1 = arg0.getDynamicObject("oprprocessgroup");
                DynamicObject oprprocessgroup2 = arg1.getDynamicObject("oprprocessgroup");
                int defaultworksort1 = null == oprprocessgroup1 ? 0 : oprprocessgroup1.getInt("defaultworksort");
                int defaultworksort2 = null == oprprocessgroup2 ? 0 : oprprocessgroup2.getInt("defaultworksort");
                DynamicObject oprprofessiona1 = arg0.getDynamicObject("oprprofessiona");
                DynamicObject oprprofessiona2 = arg1.getDynamicObject("oprprofessiona");
                int seqnum1 = null == oprprofessiona1 ? 0 : oprprofessiona1.getInt("seqnum");
                int n = seqnum2 = null == oprprofessiona2 ? 0 : oprprofessiona2.getInt("seqnum");
                if (defaultworksort1 > defaultworksort2) {
                    return 1;
                }
                if (defaultworksort1 == defaultworksort2 && seqnum1 > seqnum2) {
                    return 1;
                }
                return -1;
            });
            for (int i = 0; i < dynamicObjectCollection.size(); ++i) {
                DynamicObject entryObj = (DynamicObject)dynamicObjectCollection.get(i);
                entryObj.set("seq", (Object)(i + 1));
                entryObj.set("oprno", (Object)((i + 1) * 10 + ""));
            }
        }
    }

    public static void groentryentitySort(DynamicObjectCollection dynamicObjectCollection) {
        if (!dynamicObjectCollection.isEmpty()) {
            dynamicObjectCollection.sort((arg0, arg1) -> {
                int defaultworksort2;
                DynamicObject processgroup1 = arg0.getDynamicObject("groprocessgroup");
                DynamicObject processgroup2 = arg1.getDynamicObject("groprocessgroup");
                int defaultworksort1 = null == processgroup1 ? 0 : processgroup1.getInt("defaultworksort");
                int n = defaultworksort2 = null == processgroup2 ? 0 : processgroup2.getInt("defaultworksort");
                if (defaultworksort1 > defaultworksort2) {
                    return 1;
                }
                return -1;
            });
            for (int i = 0; i < dynamicObjectCollection.size(); ++i) {
                DynamicObject entryObj = (DynamicObject)dynamicObjectCollection.get(i);
                entryObj.set("seq", (Object)(i + 1));
            }
        }
    }
}

