/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.sfc.common.mydailyplan;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import kd.bd.mpdm.common.mftorder.utils.ManuFactureTraceUtils;
import kd.bd.mpdm.common.mftorder.utils.OrderOpUtils;
import kd.bos.bill.BillShowParameter;
import kd.bos.context.RequestContext;
import kd.bos.data.BusinessDataReader;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.runtime.AbstractConvertServiceArgs;
import kd.bos.entity.botp.runtime.ConvertOperationResult;
import kd.bos.entity.botp.runtime.PushArgs;
import kd.bos.entity.botp.runtime.SourceBillReport;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.operate.botp.Push;
import kd.bos.list.BillList;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.report.ReportShowParameter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.botp.ConvertServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.bos.servicehelper.workflow.MessageCenterServiceHelper;
import kd.bos.url.UrlService;
import kd.bos.workflow.engine.msg.info.MessageInfo;
import kd.mmc.sfc.common.worklog.DailyWorkLogUtils;

public class MydailyPlanUtils {
    private static final Log logger = LogFactory.getLog(MydailyPlanUtils.class);
    private static String[] keyStrs = new String[]{"materialstatussum", "equipmentstatussum", "toolstatussum", "filestatussum", "technicalstatussum", "workcardstatussum"};

    private MydailyPlanUtils() {
    }

    public static Map<Object, DynamicObject> queryMydailyPlan(Set<Object> dailyPlanIdSet, String fields) {
        DynamicObject[] loads;
        HashMap<Object, DynamicObject> dailyPlanMap = new HashMap<Object, DynamicObject>(16);
        QFilter q = new QFilter("id", "in", dailyPlanIdSet);
        for (DynamicObject load : loads = BusinessDataServiceHelper.load((String)"sfc_dailyplan", (String)fields, (QFilter[])new QFilter[]{q})) {
            dailyPlanMap.put(load.getPkValue(), load);
        }
        return dailyPlanMap;
    }

    public static DynamicObject getCurrentUser() {
        Long currentUserId = UserServiceHelper.getCurrentUserId();
        DynamicObject loadSingle = BusinessDataServiceHelper.loadSingle((String)"mpdm_manuperson", (String)"user,currentsection,professiona", (QFilter[])new QFilter[]{new QFilter("user", "=", (Object)currentUserId)});
        if (loadSingle == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5f53\u524d\u5236\u9020\u4eba\u5458\u4e3a\u7a7a\u3002", (String)"MydailyPlanUtils_0", (String)"mmc-sfc-common", (Object[])new Object[0]));
        }
        return loadSingle;
    }

    public static DynamicObject getClassgroup(DynamicObject currentUser) {
        QFilter q = new QFilter("entryentity.manuperson", "=", currentUser.getPkValue());
        return BusinessDataServiceHelper.loadSingle((String)"mpdm_classgroup", (String)"number,manuperson", (QFilter[])new QFilter[]{q});
    }

    public static DynamicObject getIndustry(DynamicObject currentUser) {
        DynamicObject industry;
        DynamicObject dynamicObject = industry = currentUser == null ? null : currentUser.getDynamicObject("professiona");
        if (industry == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5f53\u524d\u5236\u9020\u4eba\u5458\u884c\u4e1a\u4e3a\u7a7a\u3002", (String)"MydailyPlanUtils_30", (String)"mmc-sfc-common", (Object[])new Object[0]));
        }
        return industry;
    }

    public static void setFinishTime(DynamicObject dailyPlan, Date now, DynamicObject currentUser, String finishlog) {
        DynamicObjectCollection oprentryentity = dailyPlan.getDynamicObjectCollection("oprentryentity");
        for (DynamicObject oprentry : oprentryentity) {
            DynamicObjectCollection repsubentryentity = oprentry.getDynamicObjectCollection("repsubentryentity");
            for (DynamicObject repsubentry : repsubentryentity) {
                DynamicObject person = repsubentry.getDynamicObject("person");
                Date reportbegintime = repsubentry.getDate("reportbegintime");
                Date reportendtime = repsubentry.getDate("reportendtime");
                boolean isexistuser = person != null && currentUser != null;
                if (!isexistuser || reportbegintime == null || reportendtime != null || !person.getPkValue().toString().equals(currentUser.getPkValue().toString())) continue;
                MydailyPlanUtils.finishWorkTime(repsubentry, now, reportbegintime, finishlog);
            }
        }
    }

    public static void setFinishStatus(DynamicObject dailyPlan, Object billentryid, String statusValue, Date now, Boolean isrecheck) {
        DynamicObject currentUser = MydailyPlanUtils.getCurrentUser();
        DynamicObjectCollection oprentryentity = dailyPlan.getDynamicObjectCollection("oprentryentity");
        for (DynamicObject oprentry : oprentryentity) {
            if (!oprentry.getPkValue().toString().equals(billentryid.toString())) continue;
            oprentry.set("status", (Object)statusValue);
            if ("F".equals(statusValue) && isrecheck.booleanValue()) {
                oprentry.set("recheckworktime", (Object)now);
                oprentry.set("recheckworkuser", (Object)currentUser);
                continue;
            }
            if ("F".equals(statusValue)) {
                oprentry.set("checkworktime", (Object)now);
                oprentry.set("checkworkuser", (Object)currentUser);
                continue;
            }
            if ("H".equals(statusValue) && isrecheck.booleanValue()) {
                oprentry.set("checkworktime", (Object)now);
                oprentry.set("checkworkuser", (Object)currentUser);
                continue;
            }
            if (!"H".equals(statusValue)) continue;
            oprentry.set("finishworktime", (Object)now);
            oprentry.set("finishworkuser", (Object)currentUser);
        }
        boolean label = false;
        for (DynamicObject oprentry : oprentryentity) {
            if ("F".equals(oprentry.getString("status"))) continue;
            label = true;
        }
        if (!label) {
            dailyPlan.set("taskstatus", (Object)"C");
        }
    }

    public static boolean isNeedReCheck(DynamicObject stage) {
        if (stage != null) {
            String name = stage.getString("name");
            String alias = stage.getString("alias");
            String lowernameCase = name.toLowerCase();
            String loweraliasCase = alias.toLowerCase();
            boolean col1 = lowernameCase.contains("rii");
            boolean col2 = lowernameCase.contains("di");
            boolean col3 = loweraliasCase.contains("rii");
            boolean col4 = loweraliasCase.contains("di");
            return col1 || col2 || col3 || col4;
        }
        return false;
    }

    public static boolean isNeedIPI(DynamicObject stage) {
        if (stage != null) {
            String name = stage.getString("name");
            String alias = stage.getString("alias");
            String lowernameCase = name.toLowerCase();
            String loweraliasCase = alias.toLowerCase();
            boolean col1 = lowernameCase.contains("ipi");
            boolean col2 = loweraliasCase.contains("ipi");
            return col1 || col2;
        }
        return false;
    }

    public static void showForm(String formId, IFormView view, CloseCallBack closeCallBack) {
        HashMap<String, String> para = new HashMap<String, String>();
        para.put("formId", formId);
        FormShowParameter showParameter = FormShowParameter.createFormShowParameter(para);
        showParameter.setCloseCallBack(closeCallBack);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        view.showForm(showParameter);
    }

    /*
     * WARNING - void declaration
     */
    public static String beginWork(DynamicObject[] objs, DynamicObject manuperson, Date now) {
        DynamicObject[] loads;
        ArrayList errInfoList = new ArrayList(16);
        HashMap<String, String> tastNameMap = new HashMap<String, String>(16);
        HashSet<String> beginWMIdSet = new HashSet<String>();
        QFilter qFilter = new QFilter("oprentryentity.repsubentryentity.person", "=", manuperson != null ? manuperson.getPkValue() : Long.valueOf(0L));
        qFilter.and(new QFilter("taskstatus", "in", (Object)new String[]{"A", "B"}));
        qFilter.and(new QFilter("bizstatus", "=", (Object)"B"));
        for (DynamicObject query : loads = BusinessDataServiceHelper.load((String)"sfc_dailyplan", (String)"taskname,status,srcbillid,person,reportbegintime,reportendtime,mroorderentryid,project", (QFilter[])new QFilter[]{qFilter})) {
            DynamicObject[] oprentryentity = query.getDynamicObjectCollection("oprentryentity");
            for (DynamicObject oprentry : oprentryentity) {
                String status = oprentry.getString("status");
                DynamicObject dynamicObject = oprentry.getDynamicObject("mroorderentryid");
                if (dynamicObject != null && MydailyPlanUtils.isTaskStatus(dynamicObject)) {
                    beginWMIdSet.add(oprentry.get("srcbillid").toString());
                }
                if (beginWMIdSet.contains(oprentry.get("srcbillid").toString())) continue;
                Iterator repsubentryentity = oprentry.getDynamicObjectCollection("repsubentryentity");
                if ("F".equals(status) || !MydailyPlanUtils.isUnExistUser((DynamicObjectCollection)repsubentryentity, manuperson)) continue;
                beginWMIdSet.add(oprentry.get("srcbillid").toString());
                tastNameMap.put(oprentry.get("srcbillid").toString(), query.getString("taskname"));
            }
        }
        Boolean dpskillerbegin = Boolean.FALSE;
        Boolean dpworkkerbegin = Boolean.FALSE;
        HashSet<Long> engineequipmodelSet = new HashSet<Long>(16);
        HashSet<Long> professionSet = new HashSet<Long>(16);
        for (DynamicObject obj : objs) {
            DynamicObjectCollection dynamicObjectCollection = obj.getDynamicObjectCollection("oprentryentity");
            for (Object oprentry : dynamicObjectCollection) {
                DynamicObject project;
                DynamicObject profession = oprentry.getDynamicObject("profession");
                if (profession != null) {
                    professionSet.add((Long)profession.getPkValue());
                }
                if ((project = oprentry.getDynamicObject("project")) == null) continue;
                if (project.getBoolean("dpskillerbegin")) {
                    dpskillerbegin = Boolean.TRUE;
                }
                DynamicObject engineequipmodel = project.getDynamicObject("engineequipmodel");
                if (!project.getBoolean("dpworkkerbegin") || engineequipmodel == null) continue;
                engineequipmodelSet.add((Long)engineequipmodel.getPkValue());
                dpworkkerbegin = Boolean.TRUE;
            }
        }
        HashMap<Long, String> journeyManMap = new HashMap<Long, String>(16);
        logger.info("\u65e5\u8ba1\u5212\u67e5\u8be2\u5408\u683c\u6280\u5de5\u5f00\u59cb" + dpskillerbegin);
        if (dpskillerbegin.booleanValue() && !professionSet.isEmpty()) {
            void var16_31;
            JSONArray jsonArray = new JSONArray();
            for (Long profession : professionSet) {
                JSONObject jSONObject = new JSONObject();
                jSONObject.put("userid", manuperson.getDynamicObject("user").getPkValue());
                jSONObject.put("industryid", (Object)profession);
                jSONObject.put("uniqueid", (Object)profession.toString());
                jsonArray.add((Object)jSONObject);
            }
            JSONObject resObject = (JSONObject)DispatchServiceHelper.invokeBizService((String)"mmc", (String)"fmm", (String)"CraftsOrForemanService", (String)"getInformation", (Object[])new Object[]{jsonArray});
            JSONArray res = (JSONArray)resObject.get((Object)"data");
            logger.info("\u65e5\u8ba1\u5212\u67e5\u8be2\u5408\u683c\u6280\u5de5\u7ed3\u679c" + res);
            boolean bl = false;
            while (var16_31 < res.size()) {
                JSONObject resObj = res.getJSONObject((int)var16_31);
                journeyManMap.put(Long.parseLong(resObj.get((Object)"uniqueid").toString()), resObj.get((Object)"journeyMan").toString());
                ++var16_31;
            }
            logger.info("\u65e5\u8ba1\u5212\u67e5\u8be2\u5408\u683c\u6280\u5de5\u7ed3\u679c" + journeyManMap);
        }
        HashMap<String, String> equipmodelMap = new HashMap<String, String>(16);
        logger.info("\u65e5\u8ba1\u5212\u67e5\u8be2\u72ec\u7acb\u5de5\u4f5c\u8005\u5f00\u59cb" + dpworkkerbegin);
        if (dpworkkerbegin.booleanValue() && !engineequipmodelSet.isEmpty() && !professionSet.isEmpty()) {
            Long userid = (Long)manuperson.getDynamicObject("user").getPkValue();
            JSONArray jsonArray = new JSONArray();
            for (Long profession : professionSet) {
                for (Long engineequipmodel : engineequipmodelSet) {
                    JSONObject jsonObject = new JSONObject();
                    jsonObject.put("userid", (Object)userid);
                    jsonObject.put("industryid", (Object)profession);
                    jsonObject.put("authorizemodelid", (Object)engineequipmodel);
                    jsonObject.put("uniqueid", (Object)(profession.toString() + engineequipmodel.toString()));
                    jsonArray.add((Object)jsonObject);
                    equipmodelMap.put(profession.toString() + engineequipmodel.toString(), "false");
                }
            }
            JSONObject jSONObject = (JSONObject)DispatchServiceHelper.invokeBizService((String)"mmc", (String)"fmm", (String)"IndependentWokerService", (String)"getInformation", (Object[])new Object[]{jsonArray});
            JSONArray res = (JSONArray)jSONObject.get((Object)"data");
            logger.info("\u65e5\u8ba1\u5212\u67e5\u8be2\u72ec\u7acb\u5de5\u4f5c\u8005\u7ed3\u679c" + res);
            for (int i = 0; i < res.size(); ++i) {
                JSONObject resObj = res.getJSONObject(i);
                equipmodelMap.put(resObj.get((Object)"uniqueid").toString(), resObj.get((Object)"result").toString());
            }
            logger.info("\u65e5\u8ba1\u5212\u67e5\u8be2\u72ec\u7acb\u5de5\u4f5c\u8005\u7ed3\u679c" + equipmodelMap);
        }
        StringBuilder sb = new StringBuilder();
        for (DynamicObject obj : objs) {
            DynamicObjectCollection oprentryentity = obj.getDynamicObjectCollection("oprentryentity");
            for (DynamicObject oprentry : oprentryentity) {
                DynamicObject project = oprentry.getDynamicObject("project");
                DynamicObject profession = oprentry.getDynamicObject("profession");
                String status = oprentry.getString("status");
                oprentry.set("isoprexception", (Object)Boolean.FALSE);
                String srcbillid = oprentry.get("srcbillid").toString();
                if (beginWMIdSet.add(srcbillid)) {
                    DynamicObjectCollection repsubentryentity = oprentry.getDynamicObjectCollection("repsubentryentity");
                    if ("F".equals(status) || MydailyPlanUtils.isUnExistUser(repsubentryentity, manuperson)) continue;
                    boolean label = false;
                    if (project != null && profession != null) {
                        String isequipmodel;
                        Long professionId = (Long)profession.getPkValue();
                        if (project.getBoolean("dpskillerbegin") && "false".equals(journeyManMap.get(professionId))) {
                            label = true;
                            sb.append(String.format(ResManager.loadKDString((String)"\u4efb\u52a1%1$s\u4e2d\uff0c%2$s\u7528\u6237\u4e0d\u662f\u5408\u683c\u6280\u5de5\uff1b", (String)"MydailyPlanUtils_31", (String)"mmc-sfc-common", (Object[])new Object[0]), obj.getString("taskname"), manuperson != null ? manuperson.getString("name") : ""));
                        }
                        dpworkkerbegin = project.getBoolean("dpworkkerbegin");
                        DynamicObject engineequipmodel = project.getDynamicObject("engineequipmodel");
                        if (project.getBoolean("dpworkkerbegin") && engineequipmodel != null && ((isequipmodel = (String)equipmodelMap.get(professionId.toString() + engineequipmodel.getPkValue().toString())) == null || "false".equals(isequipmodel))) {
                            label = true;
                            sb.append(String.format(ResManager.loadKDString((String)"\u4efb\u52a1%1$s\u4e2d\uff0c%2$s\u7528\u6237\u4e0d\u662f\u72ec\u7acb\u5de5\u4f5c\u8005\uff1b", (String)"MydailyPlanUtils_32", (String)"mmc-sfc-common", (Object[])new Object[0]), obj.getString("taskname"), manuperson != null ? manuperson.getString("name") : ""));
                        }
                    }
                    if (label) continue;
                    DynamicObject addNew = repsubentryentity.addNew();
                    addNew.set("person", (Object)manuperson);
                    addNew.set("reportbegintime", (Object)now);
                    tastNameMap.put(srcbillid, obj.getString("taskname"));
                    continue;
                }
                if (obj.getString("taskname").equals(tastNameMap.get(srcbillid)) || tastNameMap.get(srcbillid) == null) continue;
                ArrayList<String> errInfo1 = new ArrayList<String>(2);
                errInfo1.add(obj.getString("taskname"));
                errInfo1.add((String)tastNameMap.get(srcbillid));
                errInfoList.add(errInfo1);
            }
            obj.set("isexception", (Object)Boolean.FALSE);
            obj.set("taskstatus", (Object)"B");
        }
        if (!errInfoList.isEmpty()) {
            for (List list : errInfoList) {
                sb.append(String.format(ResManager.loadKDString((String)"\u5f53\u524d\u7528\u6237\u6240\u9009\u7684\u4efb\u52a1\u3010%1$s\u3011\u5728\u4efb\u52a1\u3010%2$s\u3011\u4e2d\u5b58\u5728\u5f00\u5de5\u8bb0\u5f55;", (String)"MydailyPlanUtils_33", (String)"mmc-sfc-common", (Object[])new Object[0]), list.get(0), list.get(1)));
            }
        }
        return sb.toString();
    }

    private static boolean isUnExistUser(DynamicObjectCollection repsubentryentity, DynamicObject currentUser) {
        for (DynamicObject repsubentry : repsubentryentity) {
            DynamicObject person = repsubentry.getDynamicObject("person");
            Date reportbegintime = repsubentry.getDate("reportbegintime");
            Date reportendtime = repsubentry.getDate("reportendtime");
            boolean userIsNull = person != null && currentUser != null;
            if (!userIsNull || reportbegintime == null || reportendtime != null || !person.getPkValue().toString().equals(currentUser.getPkValue().toString())) continue;
            return true;
        }
        return false;
    }

    public static DynamicObjectCollection getMulBaseDataDyColl(String entityName, Set<Object> fieldValueIds, String fieldName, String mulBasedataEntity) {
        DynamicObject paySchDy = BusinessDataServiceHelper.newDynamicObject((String)entityName);
        DynamicObjectCollection dyColl = paySchDy.getDynamicObjectCollection(fieldName);
        DynamicObjectType dynamicObjectType = dyColl.getDynamicObjectType();
        for (Object fieldValueId : fieldValueIds) {
            DynamicObject mulBasedataDy = new DynamicObject(dynamicObjectType);
            DynamicObject payBizActDy = BusinessDataServiceHelper.newDynamicObject((String)mulBasedataEntity);
            payBizActDy.set("id", fieldValueId);
            mulBasedataDy.set("fbasedataid", (Object)payBizActDy);
            dyColl.add((Object)mulBasedataDy);
        }
        return dyColl;
    }

    public static boolean isBeginWork(DynamicObject dailyPlan, DynamicObject currentUser) {
        DynamicObjectCollection oprentryentity = dailyPlan.getDynamicObjectCollection("oprentryentity");
        for (DynamicObject oprentry : oprentryentity) {
            DynamicObjectCollection repsubentryentity = oprentry.getDynamicObjectCollection("repsubentryentity");
            if (!MydailyPlanUtils.isUnExistUser(repsubentryentity, currentUser)) continue;
            return true;
        }
        return false;
    }

    public static void deleteWork(DynamicObject[] objs, DynamicObject currentUser) {
        HashSet<String> taskName = new HashSet<String>(16);
        for (DynamicObject obj : objs) {
            if (!MydailyPlanUtils.isBeginWork(obj, currentUser)) {
                MydailyPlanUtils.deleteUserWork(obj, currentUser);
                MydailyPlanUtils.updatePlanTimeAndUser(obj);
                continue;
            }
            taskName.add(obj.getString("taskname"));
        }
        if (!taskName.isEmpty()) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u4efb\u52a1%1$s\u5df2\u5f00\u5de5,\u4e0d\u5141\u8bb8\u5220\u9664\u3002", (String)"MydailyPlanUtils_28", (String)"mmc-sfc-common", (Object[])new Object[0]), ((Object)taskName).toString()));
        }
    }

    private static void deleteUserWork(DynamicObject obj, DynamicObject currentUser) {
        DynamicObjectCollection mulcheckuser = obj.getDynamicObjectCollection("mulcheckuser");
        MydailyPlanUtils.deleteCheckUser(mulcheckuser, currentUser);
        DynamicObjectCollection planentryentity = obj.getDynamicObjectCollection("planentryentity");
        for (DynamicObject planentry : planentryentity) {
            DynamicObjectCollection allocsubentryentity = planentry.getDynamicObjectCollection("allocsubentryentity");
            ArrayList<DynamicObject> needDelList = new ArrayList<DynamicObject>(16);
            for (DynamicObject allocsubentry : allocsubentryentity) {
                DynamicObject userincharge = allocsubentry.getDynamicObject("userincharge");
                DynamicObject handoveruser = allocsubentry.getDynamicObject("handoveruser");
                String jobsrctype = allocsubentry.getString("jobsrctype");
                if (userincharge == null || currentUser == null || userincharge.getPkValue().toString().equals(currentUser.getPkValue().toString())) {
                    if ("B".equals(jobsrctype)) {
                        allocsubentry.set("userincharge", (Object)handoveruser);
                        allocsubentry.set("jobsrctype", (Object)"A");
                        continue;
                    }
                    needDelList.add(allocsubentry);
                    continue;
                }
                if (handoveruser != null && currentUser != null && !handoveruser.getPkValue().toString().equals(currentUser.getPkValue().toString())) continue;
                needDelList.add(allocsubentry);
            }
            allocsubentryentity.removeAll(needDelList);
        }
    }

    public static void refreshList(IFormView view) {
        BillList billList = (BillList)view.getControl("billlistap");
        billList.refresh();
    }

    public static void updatePlanTimeAndUser(DynamicObject obj) {
        DynamicObjectCollection planentryentity = obj.getDynamicObjectCollection("planentryentity");
        StringBuilder sb = new StringBuilder();
        HashSet<String> userNameSet = new HashSet<String>(16);
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
        SimpleDateFormat timeateFormat = new SimpleDateFormat("HH:mm");
        TreeSet<Long> planstarttimeSet = new TreeSet<Long>();
        HashMap<Long, Long> timeMap = new HashMap<Long, Long>(16);
        for (DynamicObject planentry : planentryentity) {
            Date planstarttime = planentry.getDate("planstarttime");
            Date planendtime = planentry.getDate("planendtime");
            if (planstarttime != null && planendtime != null) {
                planstarttimeSet.add(planstarttime.getTime());
                timeMap.put(planstarttime.getTime(), planendtime.getTime());
            }
            DynamicObjectCollection allocsubentryentity = planentry.getDynamicObjectCollection("allocsubentryentity");
            for (DynamicObject allocsubentry : allocsubentryentity) {
                DynamicObject userincharge = allocsubentry.getDynamicObject("userincharge");
                if (userincharge == null) continue;
                MydailyPlanUtils.setUserInfo(allocsubentry, userincharge);
                if ("E".equals(allocsubentry.getString("jobsrctype"))) continue;
                userNameSet.add(userincharge.getString("name"));
            }
        }
        for (Long planstarttime : planstarttimeSet) {
            sb.append(simpleDateFormat.format(planstarttime));
            sb.append("  ");
            sb.append(timeateFormat.format(planstarttime));
            sb.append('-');
            sb.append(timeateFormat.format(timeMap.get(planstarttime)));
            sb.append("\r\n");
        }
        StringBuilder sbName = new StringBuilder();
        int i = 1;
        for (String userName : userNameSet) {
            sbName.append(userName);
            if (i < userNameSet.size()) {
                sbName.append('\u3001');
            }
            ++i;
        }
        if (sb.length() > 255) {
            obj.set("plantimedym", (Object)sb.substring(0, 255));
        } else {
            obj.set("plantimedym", (Object)sb.toString());
        }
        obj.set("plantimedym_tag", (Object)sb.toString());
        if (sbName.length() > 255) {
            obj.set("planuserdym", (Object)sbName.substring(0, 255));
        } else {
            obj.set("planuserdym", (Object)sbName.toString());
        }
        obj.set("planuserdym_tag", (Object)sbName.toString());
    }

    public static void updateCheckUser(DynamicObject[] objs) {
        HashSet<Long> userIdSet = new HashSet<Long>(16);
        for (DynamicObject obj : objs) {
            DynamicObjectCollection planentryentity = obj.getDynamicObjectCollection("planentryentity");
            for (DynamicObject planentry : planentryentity) {
                DynamicObjectCollection allocsubentryentity = planentry.getDynamicObjectCollection("allocsubentryentity");
                for (DynamicObject allocsubentry : allocsubentryentity) {
                    Object user;
                    DynamicObject userincharge = allocsubentry.getDynamicObject("userincharge");
                    if (userincharge == null || "E".equals(allocsubentry.getString("jobsrctype")) || (user = userincharge.getDynamicObject("user")) == null) continue;
                    userIdSet.add((Long)user.getPkValue());
                }
            }
        }
        List<Long> checkuserIdList = MydailyPlanUtils.getCheckuserIdList(new QFilter("user", "in", userIdSet));
        for (DynamicObject obj : objs) {
            DynamicObjectCollection mulcheckuser = obj.getDynamicObjectCollection("mulcheckuser");
            HashMap<Long, DynamicObject> muserIdMap = new HashMap<Long, DynamicObject>(16);
            DynamicObjectCollection planentryentity = obj.getDynamicObjectCollection("planentryentity");
            for (DynamicObject planentry : planentryentity) {
                DynamicObjectCollection allocsubentryentity = planentry.getDynamicObjectCollection("allocsubentryentity");
                for (DynamicObject allocsubentry : allocsubentryentity) {
                    DynamicObject user;
                    DynamicObject userincharge = allocsubentry.getDynamicObject("userincharge");
                    if (userincharge == null || "E".equals(allocsubentry.getString("jobsrctype")) || (user = userincharge.getDynamicObject("user")) == null || !checkuserIdList.contains((Long)user.getPkValue())) continue;
                    muserIdMap.put((Long)userincharge.getPkValue(), userincharge);
                }
            }
            if (muserIdMap.isEmpty()) continue;
            DynamicObjectType type = mulcheckuser.getDynamicObjectType();
            for (DynamicObject checkUser : muserIdMap.values()) {
                if (MydailyPlanUtils.isExistCheckUser(mulcheckuser, checkUser)) continue;
                DynamicObject userIDDy = new DynamicObject(type);
                userIDDy.set("fbasedataid", (Object)checkUser);
                mulcheckuser.add((Object)userIDDy);
            }
        }
    }

    public static void handoverWork(DynamicObject dailyPlan, DynamicObject currentUser, DynamicObject handuser) {
        DynamicObjectCollection planentryentity = dailyPlan.getDynamicObjectCollection("planentryentity");
        for (DynamicObject planentry : planentryentity) {
            DynamicObjectCollection allocsubentryentity = planentry.getDynamicObjectCollection("allocsubentryentity");
            for (DynamicObject allocsubentry : allocsubentryentity) {
                DynamicObject userincharge = allocsubentry.getDynamicObject("userincharge");
                if (userincharge == null || currentUser == null || !userincharge.getPkValue().toString().equals(currentUser.getPkValue().toString())) continue;
                MydailyPlanUtils.setHandOverValue(allocsubentry, handuser);
            }
        }
    }

    private static void setHandOverValue(DynamicObject addNew, DynamicObject handuser) {
        addNew.set("jobsrctype", (Object)"C");
        addNew.set("issure", (Object)"A");
        addNew.set("handoveruser", (Object)handuser);
    }

    public static String getWorkSrctype(DynamicObject dailyPlan, DynamicObject currentUser) {
        DynamicObjectCollection planentryentity = dailyPlan.getDynamicObjectCollection("planentryentity");
        String jobsrctype = "A";
        for (DynamicObject planentry : planentryentity) {
            DynamicObjectCollection allocsubentryentity = planentry.getDynamicObjectCollection("allocsubentryentity");
            for (DynamicObject allocsubentry : allocsubentryentity) {
                DynamicObject userincharge = allocsubentry.getDynamicObject("userincharge");
                DynamicObject handoveruser = allocsubentry.getDynamicObject("handoveruser");
                if (userincharge != null && currentUser != null && userincharge.getPkValue().toString().equals(currentUser.getPkValue().toString())) {
                    if (handoveruser == null) {
                        jobsrctype = allocsubentry.getString("jobsrctype");
                    }
                    if (handoveruser == null || !"B".equals(allocsubentry.getString("issure"))) continue;
                    jobsrctype = allocsubentry.getString("jobsrctype");
                    continue;
                }
                if (handoveruser == null || currentUser == null || !handoveruser.getPkValue().toString().equals(currentUser.getPkValue().toString()) || !"B".equals(jobsrctype = allocsubentry.getString("jobsrctype"))) continue;
                jobsrctype = "A";
            }
        }
        if ("".equals(jobsrctype)) {
            jobsrctype = "A";
        }
        return jobsrctype;
    }

    public static void rejectWork(DynamicObject dailyPlan, DynamicObject currentUser, String operateKey) {
        DynamicObjectCollection planentryentity = dailyPlan.getDynamicObjectCollection("planentryentity");
        for (DynamicObject planentry : planentryentity) {
            DynamicObjectCollection allocsubentryentity = planentry.getDynamicObjectCollection("allocsubentryentity");
            for (DynamicObject allocsubentry : allocsubentryentity) {
                DynamicObject handoveruser = allocsubentry.getDynamicObject("handoveruser");
                DynamicObject userincharge = allocsubentry.getDynamicObject("userincharge");
                if (handoveruser != null && currentUser != null && "reject".equals(operateKey) && handoveruser.getPkValue().toString().equals(currentUser.getPkValue().toString())) {
                    MydailyPlanUtils.setRejectValue(allocsubentry);
                    continue;
                }
                if (userincharge != null && currentUser != null && "returnwork".equals(operateKey) && userincharge.getPkValue().toString().equals(currentUser.getPkValue().toString())) {
                    MydailyPlanUtils.setReturnworkValue(allocsubentry);
                    continue;
                }
                if (handoveruser == null || currentUser == null || !"makesure".equals(operateKey) || !handoveruser.getPkValue().toString().equals(currentUser.getPkValue().toString())) continue;
                MydailyPlanUtils.setMakesureValue(allocsubentry);
            }
        }
    }

    private static void setMakesureValue(DynamicObject allocsubentry) {
        if ("C".equals(allocsubentry.getString("jobsrctype")) || "F".equals(allocsubentry.getString("jobsrctype"))) {
            allocsubentry.set("issure", (Object)"B");
            DynamicObject handoveruser = allocsubentry.getDynamicObject("handoveruser");
            allocsubentry.set("handoveruser", (Object)allocsubentry.getDynamicObject("userincharge"));
            MydailyPlanUtils.setUserInfo(allocsubentry, handoveruser);
        }
    }

    public static void setUserInfo(DynamicObject allocsubentry, DynamicObject userincharge) {
        allocsubentry.set("userincharge", (Object)userincharge);
        allocsubentry.set("classgroup", (Object)MydailyPlanUtils.getClassgroup(userincharge));
        allocsubentry.set("userprofession", (Object)MydailyPlanUtils.getIndustry(userincharge));
    }

    private static void setReturnworkValue(DynamicObject allocsubentry) {
        if ("B".equals(allocsubentry.getString("jobsrctype"))) {
            MydailyPlanUtils.setUserInfo(allocsubentry, allocsubentry.getDynamicObject("handoveruser"));
            allocsubentry.set("jobsrctype", (Object)"D");
            allocsubentry.set("issure", (Object)"A");
            allocsubentry.set("handoveruser", null);
        }
    }

    private static void setRejectValue(DynamicObject allocsubentry) {
        if ("C".equals(allocsubentry.getString("jobsrctype")) || "F".equals(allocsubentry.getString("jobsrctype"))) {
            allocsubentry.set("jobsrctype", (Object)"D");
            allocsubentry.set("issure", (Object)"A");
            allocsubentry.set("handoveruser", null);
        }
    }

    public static Set<Object> getOrderEntryIdbyList(BillList billList) {
        ListSelectedRowCollection selects = billList.getSelectedRows();
        HashSet<Object> dailyPlanEntryIdSet = new HashSet<Object>(16);
        for (ListSelectedRow listSelectedRow : selects) {
            if (listSelectedRow.getEntryPrimaryKeyValue() == null) continue;
            dailyPlanEntryIdSet.add(listSelectedRow.getEntryPrimaryKeyValue());
        }
        HashSet<Object> orderEntryId = new HashSet<Object>(16);
        DynamicObjectCollection querys = QueryServiceHelper.query((String)"sfc_dailyplan", (String)"oprentryentity.id,oprentryentity.mroorderentryid", (QFilter[])new QFilter[]{new QFilter("oprentryentity.id", "in", dailyPlanEntryIdSet)});
        for (DynamicObject query : querys) {
            orderEntryId.add(query.get("oprentryentity.mroorderentryid"));
        }
        return orderEntryId;
    }

    public static void showBillView(String filterFields, String billformid, BillList billList, IFormView view) {
        Set<Object> orderEntryId = MydailyPlanUtils.getOrderEntryIdbyList(billList);
        Set<Object> projectId = MydailyPlanUtils.getProjectIdbyList(billList);
        if (!orderEntryId.isEmpty()) {
            if ("pom_coordination".equals(billformid) || "pom_mronrc".equals(billformid) || "im_mdc_mftreqbill".equals(billformid) || "sfc_dailyplanlog".equals(billformid)) {
                Set<String> orderNoSet = MydailyPlanUtils.getOrderNoSet(orderEntryId);
                ArrayList<QFilter> qfilterList = new ArrayList<QFilter>();
                QFilter orderidqfilter = new QFilter(filterFields, "in", orderNoSet);
                qfilterList.add(orderidqfilter);
                ListShowParameter showParameter = ManuFactureTraceUtils.createShowParam((String)billformid, qfilterList);
                view.showForm((FormShowParameter)showParameter);
            } else if ("pom_mroeleccontrol".equals(billformid) || "pom_partreplacerecord".equals(billformid) || "pom_mrolockcontrol".equals(billformid)) {
                QFilter projectIdqfilter;
                if ("pom_partreplacerecord".equals(billformid)) {
                    Set<String> orderNoSet = MydailyPlanUtils.getOrderNoSet(orderEntryId);
                    projectIdqfilter = new QFilter(filterFields, "in", orderNoSet);
                } else {
                    projectIdqfilter = new QFilter("project", "in", projectId);
                }
                DynamicObject[] load = BusinessDataServiceHelper.load((String)billformid, (String)"id", (QFilter[])new QFilter[]{projectIdqfilter});
                if (load.length == 0) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u5728\u9650\u5b9a\u7684\u4e0b\u67e5\u5355\u636e\u8303\u56f4\u5185\uff0c\u6ca1\u6709\u627e\u5230\u5173\u8054\u6570\u636e\u3002", (String)"MydailyPlanUtils_34", (String)"mmc-sfc-common", (Object[])new Object[0]));
                }
                if (load.length == 1) {
                    ArrayList<QFilter> qfilterList = new ArrayList<QFilter>();
                    qfilterList.add(projectIdqfilter);
                    BillShowParameter showParameter = ManuFactureTraceUtils.createBillShowParam((String)billformid, (Object)load[0].getPkValue());
                    view.showForm((FormShowParameter)showParameter);
                } else {
                    ArrayList<QFilter> qfilterList = new ArrayList<QFilter>();
                    qfilterList.add(projectIdqfilter);
                    ListShowParameter showParameter = ManuFactureTraceUtils.createShowParam((String)billformid, qfilterList);
                    view.showForm((FormShowParameter)showParameter);
                }
            } else {
                ArrayList<QFilter> qfilterList = new ArrayList<QFilter>();
                QFilter orderidqfilter = new QFilter(filterFields, "in", orderEntryId);
                qfilterList.add(orderidqfilter);
                ListShowParameter showParameter = ManuFactureTraceUtils.createShowParam((String)billformid, qfilterList);
                view.showForm((FormShowParameter)showParameter);
            }
        }
    }

    private static Set<Object> getProjectIdbyList(BillList billList) {
        ListSelectedRowCollection selects = billList.getSelectedRows();
        HashSet<Object> dailyPlanEntryIdSet = new HashSet<Object>(16);
        for (ListSelectedRow listSelectedRow : selects) {
            if (listSelectedRow.getEntryPrimaryKeyValue() == null) continue;
            dailyPlanEntryIdSet.add(listSelectedRow.getEntryPrimaryKeyValue());
        }
        HashSet<Object> projectId = new HashSet<Object>(16);
        DynamicObjectCollection querys = QueryServiceHelper.query((String)"sfc_dailyplan", (String)"oprentryentity.id,oprentryentity.mroorderentryid,oprentryentity.project", (QFilter[])new QFilter[]{new QFilter("oprentryentity.id", "in", dailyPlanEntryIdSet)});
        for (DynamicObject query : querys) {
            projectId.add(query.get("oprentryentity.project"));
        }
        return projectId;
    }

    public static Set<String> getOrderNoSet(Set<Object> orderEntryId) {
        HashSet<String> orderNoSet = new HashSet<String>(16);
        DynamicObjectCollection querys = QueryServiceHelper.query((String)"pom_mroorder", (String)"id,billno", (QFilter[])new QFilter[]{new QFilter("treeentryentity.id", "in", orderEntryId)});
        for (DynamicObject query : querys) {
            orderNoSet.add(query.getString("billno"));
        }
        return orderNoSet;
    }

    public static Map<Object, Set<Object>> getOrderEntryIdMap(Set<Object> orderEntryId) {
        HashMap<Object, Set<Object>> orderEntryMap = new HashMap<Object, Set<Object>>(16);
        if (!orderEntryId.isEmpty()) {
            DynamicObjectCollection querys = QueryServiceHelper.query((String)"pom_mroorder", (String)"id,billno,treeentryentity.id", (QFilter[])new QFilter[]{new QFilter("treeentryentity.id", "in", orderEntryId)});
            for (DynamicObject query : querys) {
                HashSet<Object> set = (HashSet<Object>)orderEntryMap.get(query.get("id"));
                if (set == null) {
                    set = new HashSet<Object>(16);
                }
                set.add(query.get("treeentryentity.id"));
                orderEntryMap.put(query.get("id"), set);
            }
        }
        return orderEntryMap;
    }

    public static void pushBillByOrder(String operateKey, IFormView view, String botpid) {
        BillList billList = (BillList)view.getControl("billlistap");
        Set<Object> orderEntryId = MydailyPlanUtils.getOrderEntryIdbyList(billList);
        Map<Object, Set<Object>> orderEntryMap = MydailyPlanUtils.getOrderEntryIdMap(orderEntryId);
        if (!orderEntryMap.isEmpty()) {
            PushArgs pushArgs = new PushArgs();
            pushArgs.setTargetEntityNumber(operateKey);
            pushArgs.setHasRight(true);
            pushArgs.setRuleId(botpid);
            pushArgs.setBuildConvReport(true);
            ArrayList<ListSelectedRow> needPushRows = new ArrayList<ListSelectedRow>(16);
            if ("im_mdc_mftreqbill".equals(operateKey) || "msplan_otherneedplan".equals(operateKey) || "pmtm_workappointment".equals(operateKey)) {
                Set<Object> mydailyPlanIdSet = MydailyPlanUtils.getMydailyPlanIdSet(view, true, true);
                pushArgs.setSourceEntityNumber("sfc_dailyplan");
                Iterator<Object> iterator = mydailyPlanIdSet.iterator();
                while (iterator.hasNext()) {
                    Object mydailyPlanId = iterator.next();
                    ListSelectedRow srcBill = new ListSelectedRow(mydailyPlanId);
                    needPushRows.add(srcBill);
                }
                pushArgs.setSelectedRows(needPushRows);
            } else {
                pushArgs.setSourceEntityNumber("pom_mroorder");
                for (Map.Entry entry : orderEntryMap.entrySet()) {
                    Set value = (Set)entry.getValue();
                    for (Object entryid : value) {
                        ListSelectedRow srcBill = new ListSelectedRow(entry.getKey());
                        srcBill.setEntryEntityKey("treeentryentity");
                        srcBill.setEntryPrimaryKeyValue(entryid);
                        needPushRows.add(srcBill);
                    }
                }
                pushArgs.setSelectedRows(needPushRows);
            }
            ConvertOperationResult result = ConvertServiceHelper.push((PushArgs)pushArgs);
            if (result.isSuccess() && !result.getCachePageIds().isEmpty()) {
                MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)operateKey);
                List targetBillObjs = result.loadTargetDataObjects(BusinessDataReader::loadRefence, mainEntityType);
                if (targetBillObjs.size() > 1) {
                    Push.showMultiTargetBills((IFormView)view, (PushArgs)pushArgs, (ConvertOperationResult)result, (boolean)false);
                } else {
                    Push.showTargetBill((IFormView)view, (PushArgs)pushArgs, (ConvertOperationResult)result, (boolean)false);
                }
            } else {
                Push.showReport((IFormView)view, (AbstractConvertServiceArgs)pushArgs, (ConvertOperationResult)result);
            }
        } else {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u542b\u6709\u68c0\u4fee\u5de5\u5355\u53f7\u7684\u6570\u636e\u3002", (String)"MydailyPlanUtils_27", (String)"mmc-sfc-common", (Object[])new Object[0]));
        }
    }

    public static String getPersons(DynamicObjectCollection repsubentryentity) {
        HashSet<String> userNameSet = new HashSet<String>(16);
        for (DynamicObject repsubentry : repsubentryentity) {
            DynamicObject person = repsubentry.getDynamicObject("person");
            if (person == null) continue;
            userNameSet.add(person.getString("name"));
        }
        StringBuilder sbName = new StringBuilder();
        int i = 1;
        for (String userName : userNameSet) {
            sbName.append(userName);
            if (i < userNameSet.size()) {
                sbName.append('\u3001');
            }
            ++i;
        }
        return sbName.toString();
    }

    public static void setFinishTime(DynamicObject dailyPlan, Date now, String finishlog) {
        DynamicObjectCollection oprentryentity = dailyPlan.getDynamicObjectCollection("oprentryentity");
        for (DynamicObject oprentry : oprentryentity) {
            DynamicObjectCollection repsubentryentity = oprentry.getDynamicObjectCollection("repsubentryentity");
            for (DynamicObject repsubentry : repsubentryentity) {
                Date reportbegintime = repsubentry.getDate("reportbegintime");
                Date reportendtime = repsubentry.getDate("reportendtime");
                if (reportbegintime == null || reportendtime != null) continue;
                MydailyPlanUtils.finishWorkTime(repsubentry, now, reportbegintime, finishlog);
            }
        }
    }

    private static void finishWorkTime(DynamicObject repsubentry, Date now, Date reportbegintime, String finishlog) {
        repsubentry.set("reportendtime", (Object)now);
        BigDecimal beginTime = new BigDecimal(reportbegintime.getTime());
        BigDecimal end = new BigDecimal(now.getTime());
        BigDecimal subtract = end.subtract(beginTime);
        repsubentry.set("actualhour", (Object)subtract.divide(new BigDecimal("3600000"), 2, 4));
        repsubentry.set("workhourunit", (Object)10L);
        repsubentry.set("finishlog", (Object)finishlog);
        repsubentry.set("isreported", (Object)Boolean.TRUE);
    }

    public static Object getIsSure(DynamicObject dailyPlan, DynamicObject currentUser) {
        DynamicObjectCollection planentryentity = dailyPlan.getDynamicObjectCollection("planentryentity");
        String issuredym = "B";
        for (DynamicObject planentry : planentryentity) {
            DynamicObjectCollection allocsubentryentity = planentry.getDynamicObjectCollection("allocsubentryentity");
            for (DynamicObject allocsubentry : allocsubentryentity) {
                DynamicObject handoveruser = allocsubentry.getDynamicObject("handoveruser");
                if (!MydailyPlanUtils.isHandOverOrTransfer(allocsubentry) || handoveruser == null || currentUser == null || !handoveruser.getPkValue().toString().equals(currentUser.getPkValue().toString())) continue;
                issuredym = allocsubentry.getString("issure");
            }
        }
        if ("".equals(issuredym)) {
            issuredym = "B";
        }
        return issuredym;
    }

    public static String getSelectPro() {
        return "billtype,srcbillentryid,workcardtitle,processgroup,profession,finishlog,actualhour,taskname,orderno,mroorderentryid,isoprexception,isexception,srcbillid,person,workhourunit,finishworktime,checkworktime,recheckworktime,finishworkuser,checkworkuser,recheckworkuser,isreported,reportbegintime,reportendtime,status,taskstatus,tasksrctype,planstarttime,planendtime,userprofession,classgroup,jobsrctype,userincharge,plantimedym,planuserdym,plantimedym_tag,planuserdym_tag,mulcheckuser,issure,handoveruser,project";
    }

    public static String getSelectProRes() {
        return "org,mroorderentryid,taskname,taskstatus,isexception,isoprexception,orderno,project,profession,resreadys,tasksrctype,res_material,res_device,res_tool,res_file,res_support,res_workcard,planstarttime,planendtime";
    }

    public static void notifyWork(DynamicObject queryMydaily, DynamicObject notifyuser, String notifynifo, DynamicObject currentUser) {
        DynamicObjectCollection planentryentity = queryMydaily.getDynamicObjectCollection("planentryentity");
        boolean label = false;
        for (DynamicObject planentry : planentryentity) {
            DynamicObjectCollection allocsubentryentity = planentry.getDynamicObjectCollection("allocsubentryentity");
            for (DynamicObject allocsubentry : allocsubentryentity) {
                DynamicObject userincharge = allocsubentry.getDynamicObject("userincharge");
                if (userincharge == null || notifyuser == null || !userincharge.getPkValue().toString().equals(notifyuser.getPkValue().toString())) continue;
                label = true;
            }
        }
        if (!label && !planentryentity.isEmpty()) {
            DynamicObject planentry = (DynamicObject)planentryentity.get(0);
            DynamicObject addNew = planentry.getDynamicObjectCollection("allocsubentryentity").addNew();
            MydailyPlanUtils.setUserInfo(addNew, notifyuser);
            addNew.set("jobsrctype", (Object)"E");
            addNew.set("handoveruser", (Object)currentUser);
            addNew.set("noticeinfo", (Object)notifynifo);
        }
    }

    public static void updateEmergentStatus(DynamicObject[] objs, Boolean b) {
        for (DynamicObject bill : objs) {
            DynamicObjectCollection oprentryentity = bill.getDynamicObjectCollection("oprentryentity");
            for (DynamicObject oprentry : oprentryentity) {
                oprentry.set("isemergent", (Object)b);
            }
        }
        SaveServiceHelper.save((DynamicObject[])objs);
    }

    public static String getNoticeInfo(DynamicObject queryMydaily, DynamicObject currentUser, String key) {
        String res = "";
        DynamicObjectCollection planentryentity = queryMydaily.getDynamicObjectCollection("planentryentity");
        for (DynamicObject planentry : planentryentity) {
            DynamicObjectCollection allocsubentryentity = planentry.getDynamicObjectCollection("allocsubentryentity");
            for (DynamicObject allocsubentry : allocsubentryentity) {
                DynamicObject userincharge = allocsubentry.getDynamicObject("userincharge");
                String jobsrctype = allocsubentry.getString("jobsrctype");
                if (userincharge == null || currentUser == null || !"E".equals(jobsrctype) || !userincharge.getPkValue().toString().equals(currentUser.getPkValue().toString())) continue;
                if ("handoveruser".equals(key)) {
                    DynamicObject handoveruser = allocsubentry.getDynamicObject("handoveruser");
                    if (handoveruser == null) continue;
                    return MydailyPlanUtils.getUserInfoStr(handoveruser);
                }
                if (!"noticeinfo".equals(key)) continue;
                return allocsubentry.getString(key);
            }
        }
        return res;
    }

    private static String getUserInfoStr(DynamicObject handoveruser) {
        DynamicObject user = handoveruser.getDynamicObject("user");
        DynamicObject industry = MydailyPlanUtils.getIndustry(handoveruser);
        StringBuilder sb = new StringBuilder();
        sb.append(user.getString("number"));
        sb.append('/');
        sb.append(user.getString("name"));
        if (industry != null) {
            sb.append('/');
            sb.append(industry.getString("name"));
        }
        return sb.toString();
    }

    public static void unusualInfo(IFormView view, IDataModel model) {
        DynamicObject entry;
        Map<Object, DynamicObject> queryMydailyPlan = MydailyPlanUtils.getMydailyPlans(view, false);
        HashSet<Object> mroorderNoSet = new HashSet<Object>(16);
        Boolean exceptionStatus = (Boolean)model.getValue("isusual");
        DynamicObjectCollection entryEntity = model.getEntryEntity("entryentity");
        DynamicObject dynamicObject = entry = entryEntity == null ? null : (DynamicObject)entryEntity.get(0);
        if (entry != null) {
            DynamicObject unusualreason = entry.getDynamicObject("unusualreason");
            String excepreson = unusualreason == null ? ResManager.loadKDString((String)"\u65e0", (String)"MydailyPlanUtils_7", (String)"mmc-sfc-common", (Object[])new Object[0]) : unusualreason.getString("name");
            String unusualinfo = entry.getString("unusualinfo");
            String excepinfo = "".equals(unusualinfo) ? ResManager.loadKDString((String)"\u65e0", (String)"MydailyPlanUtils_7", (String)"mmc-sfc-common", (Object[])new Object[0]) : unusualinfo;
            for (DynamicObject bill : queryMydailyPlan.values()) {
                DynamicObjectCollection users = entry.getDynamicObjectCollection("users");
                bill.set("isexception", (Object)exceptionStatus);
                DynamicObjectCollection oprentryentity = bill.getDynamicObjectCollection("oprentryentity");
                MydailyPlanUtils.setMessage(users, oprentryentity, bill.getString("taskname"), excepreson, excepinfo);
                for (DynamicObject oprentry : oprentryentity) {
                    oprentry.set("isoprexception", (Object)exceptionStatus);
                    mroorderNoSet.add(oprentry.get("orderno"));
                }
            }
            SaveServiceHelper.save((DynamicObject[])queryMydailyPlan.values().toArray(new DynamicObject[0]));
            if (exceptionStatus.booleanValue() && !mroorderNoSet.isEmpty()) {
                Date currentDate = TimeServiceHelper.now();
                DynamicObject currentUser = MydailyPlanUtils.getCurrentUser();
                Map<Object, DynamicObject> dailyLogMap = DailyWorkLogUtils.queryDailyWorkLog(mroorderNoSet, DailyWorkLogUtils.getExceptEntrySelectors());
                if (dailyLogMap == null || dailyLogMap.size() < 1) {
                    return;
                }
                for (DynamicObject dailyLog : dailyLogMap.values()) {
                    DynamicObjectCollection exceptEntrys = dailyLog.getDynamicObjectCollection("exceptionentry");
                    DynamicObject newExceptEntrys = exceptEntrys.addNew();
                    newExceptEntrys.set("exceptiondate", (Object)currentDate);
                    newExceptEntrys.set("excepprofes", currentUser.get("professiona"));
                    newExceptEntrys.set("exceptioner", (Object)currentUser);
                    if (entryEntity == null || entryEntity.size() <= 0) continue;
                    DynamicObjectCollection attachment = entry.getDynamicObjectCollection("attachment1");
                    DynamicObjectCollection copyAttch = new DynamicObjectCollection();
                    newExceptEntrys.set("excepreson", entry.get("unusualreason"));
                    newExceptEntrys.set("excepcontent", entry.get("unusualinfo"));
                    for (DynamicObject dynamicObject2 : attachment) {
                        DynamicObject copyObj = new DynamicObject(dynamicObject2.getDynamicObjectType());
                        copyObj.set("fbasedataid", dynamicObject2.get("fbasedataid_id"));
                        copyAttch.add((Object)copyObj);
                    }
                    newExceptEntrys.set("excepattachment", (Object)copyAttch);
                }
                SaveServiceHelper.save((DynamicObject[])dailyLogMap.values().toArray(new DynamicObject[dailyLogMap.size()]));
            }
        }
    }

    public static Map<Object, DynamicObject> getMydailyPlans(IFormView view, boolean isParentView) {
        Set<Object> dailyPlanIdSet = MydailyPlanUtils.getMydailyPlanIdSet(view, isParentView, false);
        return MydailyPlanUtils.queryMydailyPlan(dailyPlanIdSet, MydailyPlanUtils.getSelectProRes());
    }

    public static DynamicObject getMydailyPlan(Object pkId) {
        return BusinessDataServiceHelper.loadSingle((Object)pkId, (String)"sfc_dailyplan", (String)MydailyPlanUtils.getSelectProRes());
    }

    public static Set<Object> getMydailyPlanIdSet(IFormView view, boolean isParentView, boolean isSelect) {
        BillList billList = null;
        billList = isParentView ? (BillList)view.getControl("billlistap") : (BillList)view.getParentView().getControl("billlistap");
        ListSelectedRowCollection selects = billList.getSelectedRows();
        HashSet<Object> dailyPlanIdSet = new HashSet<Object>(16);
        if (selects.isEmpty() && isSelect) {
            billList.selectAllRows();
        }
        selects = billList.getSelectedRows();
        for (ListSelectedRow listSelectedRow : selects) {
            dailyPlanIdSet.add(listSelectedRow.getPrimaryKeyValue());
        }
        if (dailyPlanIdSet.isEmpty() && isSelect) {
            DynamicObjectCollection query = QueryServiceHelper.query((String)"sfc_dailyplan", (String)"id", (QFilter[])new QFilter[]{new QFilter("org", "=", (Object)MydailyPlanUtils.getCurrentUserOrgId())});
            for (DynamicObject load : query) {
                dailyPlanIdSet.add(load.get("id"));
            }
        }
        return dailyPlanIdSet;
    }

    private static void setMessage(DynamicObjectCollection users, DynamicObjectCollection oprentryentity, String taskname, String excepreson, String excepinfo) {
        DynamicObject currentUser = MydailyPlanUtils.getCurrentUser();
        ArrayList<Long> receivers = new ArrayList<Long>(16);
        for (DynamicObject user : users) {
            DynamicObject manuser = user.getDynamicObject("fbasedataid");
            DynamicObject userInfo = manuser.getDynamicObject("user");
            receivers.add((Long)userInfo.getPkValue());
        }
        MessageInfo message = new MessageInfo();
        message.setType("warning");
        message.setNotifyType("");
        message.setTitle(ResManager.loadKDString((String)"\u5f02\u5e38\u4efb\u52a1", (String)"MydailyPlanUtils_8", (String)"mmc-sfc-common", (Object[])new Object[0]));
        message.setUserIds(receivers);
        message.setSenderName(currentUser.getString("name"));
        message.setTag(ResManager.loadKDString((String)"\u5de5\u4f5c\u6e05\u5355", (String)"MydailyPlanUtils_9", (String)"mmc-sfc-common", (Object[])new Object[0]));
        StringBuilder sb = new StringBuilder();
        for (DynamicObject oprentry : oprentryentity) {
            DynamicObject project = oprentry.getDynamicObject("project");
            DynamicObject profession = oprentry.getDynamicObject("profession");
            sb.append(String.format(ResManager.loadKDString((String)"\u9879\u76ee%1$s\u2014\u884c\u4e1a%2$s\u2014\u4efb\u52a1%3$s\u2014\u68c0\u4fee\u5de5\u5355%4$s\u5b58\u5728\u5f02\u5e38\uff0c\u5f02\u5e38\u539f\u56e0\u4e3a:%5$s,\u5f02\u5e38\u5185\u5bb9\u4e3a:%6$s\r\n", (String)"MydailyPlanUtils_10", (String)"mmc-sfc-common", (Object[])new Object[0]), project == null ? "" : project.get("number"), profession == null ? "" : profession.get("name"), taskname, oprentry.get("orderno"), excepreson, excepinfo));
        }
        message.setContent(sb.toString());
        MessageCenterServiceHelper.sendMessage((MessageInfo)message);
    }

    public static void transferWork(DynamicObject dailyPlan, DynamicObject currentUser, DynamicObject handuser) {
        DynamicObjectCollection planentryentity = dailyPlan.getDynamicObjectCollection("planentryentity");
        for (DynamicObject planentry : planentryentity) {
            DynamicObjectCollection allocsubentryentity = planentry.getDynamicObjectCollection("allocsubentryentity");
            for (DynamicObject allocsubentry : allocsubentryentity) {
                DynamicObject handoveruser = allocsubentry.getDynamicObject("handoveruser");
                if (handoveruser != null && currentUser != null && MydailyPlanUtils.isHandOverOrTransfer(allocsubentry) && "A".equals(allocsubentry.getString("issure")) && handoveruser.getPkValue().toString().equals(currentUser.getPkValue().toString())) {
                    MydailyPlanUtils.setTransferValue(allocsubentry, handuser);
                    continue;
                }
                if (!MydailyPlanUtils.isHandOverOrTransfer(allocsubentry) || !"B".equals(allocsubentry.getString("issure"))) continue;
                throw new KDBizException(ResManager.loadKDString((String)"\u5df2\u786e\u8ba4\u540e\uff0c\u4e0d\u80fd\u8f6c\u4ea4\u3002", (String)"MydailyPlanUtils_15", (String)"mmc-sfc-common", (Object[])new Object[0]));
            }
        }
    }

    private static void setTransferValue(DynamicObject allocsubentry, DynamicObject handuser) {
        allocsubentry.set("jobsrctype", (Object)"F");
        allocsubentry.set("issure", (Object)"A");
        allocsubentry.set("handoveruser", (Object)handuser);
    }

    public static boolean isHandOverOrTransfer(DynamicObject allocsubentry) {
        return "C".equals(allocsubentry.getString("jobsrctype")) || "F".equals(allocsubentry.getString("jobsrctype"));
    }

    public static void setNoyifyMessage(List<DynamicObject> notifyuserList, DynamicObject queryMydaily, String notifynifo, String isemergentStr) {
        DynamicObjectCollection oprentryentity = queryMydaily.getDynamicObjectCollection("oprentryentity");
        DynamicObject currentUser = MydailyPlanUtils.getCurrentUser();
        ArrayList<Long> receivers = new ArrayList<Long>(16);
        for (DynamicObject manuser : notifyuserList) {
            DynamicObject userInfo = manuser.getDynamicObject("user");
            receivers.add((Long)userInfo.getPkValue());
        }
        MessageInfo message = new MessageInfo();
        message.setType("warning");
        message.setNotifyType("");
        message.setTitle(ResManager.loadKDString((String)"\u901a\u77e5\u4fe1\u606f", (String)"MydailyPlanUtils_11", (String)"mmc-sfc-common", (Object[])new Object[0]));
        message.setUserIds(receivers);
        message.setSenderName(currentUser.getString("name"));
        message.setTag(ResManager.loadKDString((String)"\u5de5\u4f5c\u6e05\u5355", (String)"MydailyPlanUtils_9", (String)"mmc-sfc-common", (Object[])new Object[0]));
        StringBuilder sb = new StringBuilder();
        for (DynamicObject oprentry : oprentryentity) {
            DynamicObject project = oprentry.getDynamicObject("project");
            DynamicObject profession = oprentry.getDynamicObject("profession");
            sb.append(String.format(ResManager.loadKDString((String)"\u9879\u76ee%1$s\u2014\u884c\u4e1a%2$s\u2014\u4efb\u52a1%3$s\u2014\u68c0\u4fee\u5de5\u5355%4$s\u7684\u901a\u77e5\u5185\u5bb9\u4e3a:%5$s%6$s\r\n", (String)"MydailyPlanUtils_12", (String)"mmc-sfc-common", (Object[])new Object[0]), project == null ? "" : project.get("number"), profession == null ? "" : profession.get("name"), queryMydaily.get("taskname"), oprentry.get("orderno"), notifynifo, isemergentStr));
        }
        String clientUrl = UrlService.getDomainContextUrl();
        String url = clientUrl + "/index.html?formId=sfc_mydailyplan&operationStatus=view&param1=" + queryMydaily.get("id");
        message.setContentUrl(url);
        message.setContent(sb.toString());
        MessageCenterServiceHelper.sendMessage((MessageInfo)message);
    }

    public static void sendCheckMessage(Set<Long> professionSet, Set<Long> projectSet, Table<Object, Object, Set<Object>> table, Map<Object, String> professionNameMap, Map<Object, String> projectNumberMap) {
        logger.info("\u8c03\u5ea6\u4efb\u52a1\u5f85\u68c0\u901a\u77e5\u67e5\u8be2\u5f00\u59cb");
        logger.info("\u8c03\u5ea6\u4efb\u52a1\u5f85\u68c0\u901a\u77e5\u67e5\u8be2\u9879\u76eeid" + projectNumberMap);
        logger.info("\u8c03\u5ea6\u4efb\u52a1\u5f85\u68c0\u901a\u77e5\u67e5\u8be2\u884c\u4e1aid" + professionNameMap);
        HashBasedTable userTable = HashBasedTable.create();
        HashSet<Long> userMainSet = new HashSet<Long>(16);
        userMainSet.add(1500162892715480064L);
        userTable.put((Object)1515794381477511168L, (Object)1462327380549882880L, userMainSet);
        HashSet manuUserSet = new HashSet(16);
        for (Long professionId : professionSet) {
            for (Long projectId : projectSet) {
                Set userSet = (Set)userTable.get((Object)professionId, (Object)projectId);
                if (userSet == null) continue;
                manuUserSet.addAll(userSet);
            }
        }
        if (manuUserSet.isEmpty()) {
            return;
        }
        logger.info("\u8c03\u5ea6\u4efb\u52a1\u5f85\u68c0\u901a\u77e5\u67e5\u8be2\u4eba\u5458\u7ed3\u675f1" + manuUserSet);
        Map loadFromCache = BusinessDataServiceHelper.loadFromCache((String)"mpdm_manuperson", (String)"user,currentsection,professiona", (QFilter[])new QFilter[]{new QFilter("id", "in", manuUserSet)});
        logger.info("\u8c03\u5ea6\u4efb\u52a1\u5f85\u68c0\u901a\u77e5\u67e5\u8be2\u4eba\u5458\u7ed3\u675f2" + loadFromCache);
        for (Long professionId : professionSet) {
            for (Long projectId : projectSet) {
                Set taskSet = (Set)table.get((Object)professionId, (Object)projectId);
                Set userSet = (Set)userTable.get((Object)professionId, (Object)projectId);
                if (taskSet == null || userSet == null) continue;
                ArrayList<Long> receivers = new ArrayList<Long>(16);
                for (Long userId : userSet) {
                    DynamicObject manuperson = (DynamicObject)loadFromCache.get(userId);
                    if (manuperson == null) continue;
                    DynamicObject userInfo = manuperson.getDynamicObject("user");
                    receivers.add((Long)userInfo.getPkValue());
                }
                MessageInfo message = new MessageInfo();
                message.setType("warning");
                message.setNotifyType("");
                message.setTitle(ResManager.loadKDString((String)"\u5f85\u68c0\u63d0\u9192", (String)"MydailyPlanUtils_16", (String)"mmc-sfc-common", (Object[])new Object[0]));
                message.setUserIds(receivers);
                message.setSenderName(ResManager.loadKDString((String)"\u7ba1\u7406\u5458", (String)"MydailyPlanUtils_17", (String)"mmc-sfc-common", (Object[])new Object[0]));
                message.setTag(ResManager.loadKDString((String)"\u5de5\u4f5c\u6e05\u5355", (String)"MydailyPlanUtils_9", (String)"mmc-sfc-common", (Object[])new Object[0]));
                message.setContent(String.format(ResManager.loadKDString((String)"\u9879\u76ee%1$s\u2014\u884c\u4e1a%2$s\u2014\u5f53\u5929\u8fd8\u6709%3$s\u6761\u5de5\u4f5c\u6ca1\u6709\u68c0\u9a8c\u5b8c\u6210\u3002", (String)"MydailyPlanUtils_18", (String)"mmc-sfc-common", (Object[])new Object[0]), projectNumberMap.get(projectId), professionNameMap.get(professionId), taskSet.size()));
                MessageCenterServiceHelper.sendMessage((MessageInfo)message);
            }
        }
    }

    public static boolean valWorkStatus(Map<Object, DynamicObject> queryMydailyPlan, IFormView iFormView, String workType) {
        HashSet<String> tasksrctypeSet = new HashSet<String>(16);
        for (DynamicObject mydailyPlan : queryMydailyPlan.values()) {
            String tasksrctype = mydailyPlan.getString("tasksrctype");
            if ("".equals(tasksrctype)) {
                tasksrctype = "A";
            }
            tasksrctypeSet.add(tasksrctype);
        }
        if (tasksrctypeSet.size() > 1) {
            iFormView.showTipNotification(String.format(ResManager.loadKDString((String)"\u4e0d\u540c\u4efb\u52a1\u79cd\u7c7b\u4e0d\u5141\u8bb8\u540c\u65f6%1$s\u5de5\u3002", (String)"MydailyPlanUtils_23", (String)"mmc-sfc-common", (Object[])new Object[0]), workType));
            return false;
        }
        if (ResManager.loadKDString((String)"\u5f00", (String)"MydailyPlanUtils_20", (String)"mmc-sfc-common", (Object[])new Object[0]).equals(workType) && tasksrctypeSet.size() == 1) {
            for (String tasksrctypeStr : tasksrctypeSet) {
                if ("A".equals(tasksrctypeStr)) {
                    MydailyPlanUtils.autoFinish(new String[]{"B", "C"});
                    continue;
                }
                Set<String> taskBegin = MydailyPlanUtils.isTaskBegin(tasksrctypeStr);
                if (!taskBegin.isEmpty()) {
                    iFormView.showTipNotification(String.format(ResManager.loadKDString((String)"\u5b58\u5728\u5df2\u5f00\u5de5\u7684\u6807\u51c6\u68c0\u4fee\u4efb\u52a1\u6216\u8005\u65e5\u5e38\u4efb\u52a1:%s\u3002", (String)"MydailyPlanUtils_22", (String)"mmc-sfc-common", (Object[])new Object[0]), taskBegin));
                    return false;
                }
                if (!"B".equals(tasksrctypeStr)) continue;
                MydailyPlanUtils.autoFinish(new String[]{"C"});
            }
        }
        return true;
    }

    private static void autoFinish(String[] tasksrctypes) {
        List<DynamicObject> mydailyPlanList = MydailyPlanUtils.getBeginTaskList(tasksrctypes);
        Date now = TimeServiceHelper.now();
        MydailyPlanUtils.setFinishStatus(mydailyPlanList, "", "H", now, Boolean.FALSE);
        MydailyPlanUtils.setFinishTime(mydailyPlanList, now, "", ResManager.loadKDString((String)"\u5f00\u5de5\u65f6\u89e6\u53d1\u81ea\u52a8\u6536\u5de5\u3002", (String)"MydailyPlanUtils_26", (String)"mmc-sfc-common", (Object[])new Object[0]));
        SaveServiceHelper.save((DynamicObject[])mydailyPlanList.toArray(new DynamicObject[0]));
    }

    private static boolean isTaskStatus(DynamicObject mroorderentryid) {
        String taskstatus = mroorderentryid.getString("taskstatus");
        return "J".equals(taskstatus) || "E".equals(taskstatus) || "C".equals(taskstatus) || "H".equals(taskstatus) || "F".equals(taskstatus);
    }

    public static void updateResStatus(DynamicObject[] mydailyPlans) {
        Long orgId = 0L;
        ArrayList<Long> projectPKList = new ArrayList<Long>(16);
        ArrayList<String> mroOrderNumberList = new ArrayList<String>(16);
        for (DynamicObject bill : mydailyPlans) {
            DynamicObject org = bill.getDynamicObject("org");
            orgId = org == null ? Long.valueOf("0") : (Long)org.getPkValue();
            DynamicObjectCollection oprentryentity = bill.getDynamicObjectCollection("oprentryentity");
            for (DynamicObject oprentry : oprentryentity) {
                DynamicObject project = oprentry.getDynamicObject("project");
                projectPKList.add(project == null ? Long.valueOf("0") : (Long)project.getPkValue());
                mroOrderNumberList.add(oprentry.getString("orderno"));
            }
        }
        Map res = (Map)DispatchServiceHelper.invokeBizService((String)"mmc", (String)"pom", (String)"ResReadyDetaiService", (String)"queryResReadyDetailMroOrderNum", (Object[])new Object[]{orgId, projectPKList, mroOrderNumberList, "1"});
        List suminfoList = (List)res.get("suminfo");
        HashMap<String, Map> suminfoMap = new HashMap<String, Map>(16);
        for (Map map : suminfoList) {
            suminfoMap.put((String)map.get("checkebill"), map);
        }
        for (DynamicObject bill : mydailyPlans) {
            DynamicObject org = bill.getDynamicObject("org");
            orgId = org == null ? Long.valueOf("0") : (Long)org.getPkValue();
            DynamicObjectCollection oprentryentity = bill.getDynamicObjectCollection("oprentryentity");
            for (DynamicObject oprentry : oprentryentity) {
                String orderno = oprentry.getString("orderno");
                Map map = (Map)suminfoMap.get(orderno);
                if (map == null) continue;
                MydailyPlanUtils.setResStatus(map, oprentry);
            }
        }
        SaveServiceHelper.save((DynamicObject[])mydailyPlans);
    }

    private static void setResStatus(Map<String, Object> map, DynamicObject oprentry) {
        String resStr = "res_material,res_device,res_tool,res_file,res_support,res_workcard";
        String[] split = resStr.split(",");
        for (int i = 0; i < keyStrs.length; ++i) {
            if (map.get(keyStrs[i]) == null) continue;
            oprentry.set(split[i], (Object)((String)map.get(keyStrs[i])));
        }
    }

    public static void showResInfo(DynamicObject dailyPlan, String operateKey, Object entryPrimaryKeyValue, IFormView view) {
        String type = "";
        switch (operateKey) {
            case "res_material": {
                type = "0";
                break;
            }
            case "res_device": {
                type = "1";
                break;
            }
            case "res_tool": {
                type = "2";
                break;
            }
            case "res_file": {
                type = "3";
                break;
            }
            case "res_support": {
                type = "4";
                break;
            }
            case "res_workcard": {
                type = "5";
                break;
            }
            default: {
                type = "000";
            }
        }
        ArrayList<Long> projectPKList = new ArrayList<Long>(16);
        ArrayList<String> mroOrderNumberList = new ArrayList<String>(16);
        DynamicObjectCollection oprentryentity = dailyPlan.getDynamicObjectCollection("oprentryentity");
        for (DynamicObject oprentry : oprentryentity) {
            if (!entryPrimaryKeyValue.toString().equals(oprentry.getPkValue().toString())) continue;
            DynamicObject project = oprentry.getDynamicObject("project");
            projectPKList.add(project == null ? Long.valueOf("0") : (Long)project.getPkValue());
            mroOrderNumberList.add(oprentry.getString("orderno"));
        }
        ReportShowParameter report = new ReportShowParameter();
        report.setFormId("pom_resready_dailyplan");
        report.getOpenStyle().setShowType(ShowType.Modal);
        ReportQueryParam queryParam = new ReportQueryParam();
        FilterInfo filter = queryParam.getFilter();
        filter.addFilterItem("projectfilter", projectPKList);
        filter.addFilterItem("mroorderfilters", mroOrderNumberList);
        if (!"000".equals(type)) {
            filter.addFilterItem("restypefilter", (Object)type);
        }
        if (!type.equals("1")) {
            filter.addFilterItem("dimenradiogroup", (Object)"0");
        } else {
            filter.addFilterItem("dimenradiogroup", (Object)"1");
        }
        report.setQueryParam(queryParam);
        view.showForm((FormShowParameter)report);
    }

    public static Map<String, List<DynamicObject>> queryOrderMydailyPlan(Set<Object> mroorderNoSet, String fields) {
        DynamicObject[] loads;
        HashMap<String, List<DynamicObject>> dailyPlanMap = new HashMap<String, List<DynamicObject>>(16);
        QFilter q = new QFilter("oprentryentity.orderno", "in", mroorderNoSet);
        for (DynamicObject bill : loads = BusinessDataServiceHelper.load((String)"sfc_dailyplan", (String)fields, (QFilter[])new QFilter[]{q})) {
            DynamicObjectCollection oprentryentity = bill.getDynamicObjectCollection("oprentryentity");
            for (DynamicObject oprentry : oprentryentity) {
                String orderno = oprentry.getString("orderno");
                ArrayList<DynamicObject> list = (ArrayList<DynamicObject>)dailyPlanMap.get(orderno);
                if (list == null) {
                    list = new ArrayList<DynamicObject>(16);
                }
                list.add(bill);
                dailyPlanMap.put(orderno, list);
            }
        }
        return dailyPlanMap;
    }

    public static void setFinishTime(List<DynamicObject> orderMydailyPlanList, Date now, DynamicObject currentUser, String orderno, String finishlog, Set<Long> successEntryIdSet) {
        for (DynamicObject dailyPlan : orderMydailyPlanList) {
            if ("A".equals(dailyPlan.getString("taskstatus"))) continue;
            DynamicObjectCollection oprentryentity = dailyPlan.getDynamicObjectCollection("oprentryentity");
            for (DynamicObject oprentry : oprentryentity) {
                if (!successEntryIdSet.contains(oprentry.getLong("id")) || !orderno.equals(oprentry.getString("orderno"))) continue;
                DynamicObjectCollection repsubentryentity = oprentry.getDynamicObjectCollection("repsubentryentity");
                for (DynamicObject repsubentry : repsubentryentity) {
                    DynamicObject person = repsubentry.getDynamicObject("person");
                    Date reportbegintime = repsubentry.getDate("reportbegintime");
                    Date reportendtime = repsubentry.getDate("reportendtime");
                    boolean isexistuser = person != null && currentUser != null;
                    if (!isexistuser || reportbegintime == null || reportendtime != null || !person.getPkValue().toString().equals(currentUser.getPkValue().toString())) continue;
                    MydailyPlanUtils.finishWorkTime(repsubentry, now, reportbegintime, finishlog);
                }
            }
        }
    }

    public static void setFinishStatus(List<DynamicObject> orderMydailyPlanList, String orderno, String statusValue, Date now, Boolean isrecheck) {
        DynamicObject currentUser = MydailyPlanUtils.getCurrentUser();
        for (DynamicObject dailyPlan : orderMydailyPlanList) {
            DynamicObjectCollection oprentryentity = dailyPlan.getDynamicObjectCollection("oprentryentity");
            for (DynamicObject oprentry : oprentryentity) {
                if (!"".equals(orderno) && !orderno.equals(oprentry.getString("orderno"))) continue;
                oprentry.set("status", (Object)statusValue);
                if ("F".equals(statusValue) && isrecheck.booleanValue()) {
                    oprentry.set("recheckworktime", (Object)now);
                    oprentry.set("recheckworkuser", (Object)currentUser);
                    continue;
                }
                if ("F".equals(statusValue)) {
                    oprentry.set("checkworktime", (Object)now);
                    oprentry.set("checkworkuser", (Object)currentUser);
                    continue;
                }
                if ("H".equals(statusValue) && isrecheck.booleanValue()) {
                    oprentry.set("checkworktime", (Object)now);
                    oprentry.set("checkworkuser", (Object)currentUser);
                    continue;
                }
                if (!"H".equals(statusValue)) continue;
                oprentry.set("finishworktime", (Object)now);
                oprentry.set("finishworkuser", (Object)currentUser);
            }
            boolean label = false;
            for (DynamicObject oprentry : oprentryentity) {
                if ("F".equals(oprentry.getString("status"))) continue;
                label = true;
            }
            if (label) continue;
            dailyPlan.set("taskstatus", (Object)"C");
        }
    }

    public static void setFinishTime(List<DynamicObject> orderMydailyPlanList, Date now, String orderno, String finishlog) {
        for (DynamicObject dailyPlan : orderMydailyPlanList) {
            DynamicObjectCollection oprentryentity = dailyPlan.getDynamicObjectCollection("oprentryentity");
            for (DynamicObject oprentry : oprentryentity) {
                if (!"".equals(orderno) && !orderno.equals(oprentry.getString("orderno"))) continue;
                DynamicObjectCollection repsubentryentity = oprentry.getDynamicObjectCollection("repsubentryentity");
                for (DynamicObject repsubentry : repsubentryentity) {
                    Date reportbegintime = repsubentry.getDate("reportbegintime");
                    Date reportendtime = repsubentry.getDate("reportendtime");
                    if (reportbegintime == null || reportendtime != null) continue;
                    MydailyPlanUtils.finishWorkTime(repsubentry, now, reportbegintime, finishlog);
                }
            }
        }
    }

    public static void executeTask() {
        QFilter q = new QFilter("taskstatus", "in", (Object)new String[]{"A", "B"});
        q.and(new QFilter("oprentryentity.status", "=", (Object)"H"));
        DynamicObject[] loads = BusinessDataServiceHelper.load((String)"sfc_dailyplan", (String)"taskname,orderno,profession,project", (QFilter[])new QFilter[]{q});
        HashBasedTable table = HashBasedTable.create();
        HashSet<Long> professionSet = new HashSet<Long>(16);
        HashMap<Object, String> professionNameMap = new HashMap<Object, String>(16);
        HashSet<Long> projectSet = new HashSet<Long>(16);
        HashMap<Object, String> projectNumberMap = new HashMap<Object, String>(16);
        for (DynamicObject load : loads) {
            DynamicObjectCollection oprentryentity = load.getDynamicObjectCollection("oprentryentity");
            for (DynamicObject oprentry : oprentryentity) {
                DynamicObject profession = oprentry.getDynamicObject("profession");
                DynamicObject project = oprentry.getDynamicObject("project");
                if (profession == null || project == null) continue;
                professionSet.add((Long)profession.getPkValue());
                professionNameMap.put(profession.getPkValue(), profession.getString("name"));
                projectSet.add((Long)project.getPkValue());
                projectNumberMap.put(project.getPkValue(), project.getString("number"));
                HashSet<Object> taskSet = (HashSet<Object>)table.get(profession.getPkValue(), project.getPkValue());
                if (taskSet == null) {
                    taskSet = new HashSet<Object>(16);
                }
                taskSet.add(oprentry.getPkValue());
                table.put(profession.getPkValue(), project.getPkValue(), taskSet);
            }
        }
        if (!professionSet.isEmpty()) {
            MydailyPlanUtils.sendCheckMessage(professionSet, projectSet, (Table<Object, Object, Set<Object>>)table, professionNameMap, projectNumberMap);
        }
    }

    public static void checkPermission(String opKey, String entityId, Long pk) {
        OperateOption option = OperateOption.create();
        option.setVariableValue("ishasright", "false");
        OperationResult executeOperate = OperationServiceHelper.executeOperate((String)opKey, (String)entityId, (Object[])new Long[]{pk}, (OperateOption)option);
        if (!executeOperate.isSuccess()) {
            throw new KDBizException(OrderOpUtils.getErrDetail((OperationResult)executeOperate));
        }
    }

    public static QFilter getManuftechQFilter() {
        DynamicObject industry = MydailyPlanUtils.getIndustry(MydailyPlanUtils.getCurrentUser());
        Object professionaL1 = DispatchServiceHelper.invokeBizService((String)"bd", (String)"mpdm", (String)"IndustryDataService", (String)"getIndustryLOneParent", (Object[])new Object[]{industry.getPkValue()});
        QFilter orderQF = new QFilter("org", "=", (Object)MydailyPlanUtils.getCurrentUserOrgId());
        orderQF.and(new QFilter("dailyexptype", "=", (Object)0L));
        orderQF.and(new QFilter("treeentryentity.bizstatus", "=", (Object)"A"));
        orderQF.and(new QFilter("treeentryentity.taskstatus", "in", (Object)new String[]{"A", "B", "D", "G"}));
        DynamicObjectCollection query = QueryServiceHelper.query((String)"pom_mroorder", (String)"billno,treeentryentity.id", (QFilter[])new QFilter[]{orderQF});
        HashSet<Long> orderEntrySet = new HashSet<Long>(16);
        for (DynamicObject load : query) {
            orderEntrySet.add(load.getLong("treeentryentity.id"));
        }
        QFilter q = new QFilter("org", "=", (Object)MydailyPlanUtils.getCurrentUserOrgId());
        q.and(new QFilter("mftentryseq", "in", orderEntrySet));
        q.and(new QFilter("billstatus", "=", (Object)"C"));
        q.and(new QFilter("groentryentity.grogroupstatus", "in", (Object)new String[]{"A", "B"}));
        q.and(new QFilter("oprentryentity.oprstatus", "in", (Object)new String[]{"A", "B", "C", "D", "E", "H"}));
        q.and(new QFilter("oprentryentity.oprinvalid", "=", (Object)Boolean.FALSE));
        q.and(new QFilter("oprentryentity.oprprofessiona", "=", professionaL1));
        return q;
    }

    public static void pushDailyAndSave(Map<Object, List<Object>> idEntryIdMap, IFormView iFormView) {
        List targetBillObjs;
        PushArgs pushArgs = new PushArgs();
        pushArgs.setTargetEntityNumber("sfc_dailyplan");
        pushArgs.setHasRight(true);
        pushArgs.setRuleId("1521013806971493376");
        pushArgs.setBuildConvReport(true);
        ArrayList<ListSelectedRow> needPushRows = new ArrayList<ListSelectedRow>(16);
        pushArgs.setSourceEntityNumber("sfc_mromanuftech");
        for (Map.Entry<Object, List<Object>> m : idEntryIdMap.entrySet()) {
            List<Object> value = m.getValue();
            for (Object entryid : value) {
                ListSelectedRow srcBill = new ListSelectedRow(m.getKey());
                srcBill.setEntryEntityKey("oprentryentity");
                srcBill.setEntryPrimaryKeyValue(entryid);
                needPushRows.add(srcBill);
            }
        }
        pushArgs.setSelectedRows(needPushRows);
        ConvertOperationResult result = ConvertServiceHelper.push((PushArgs)pushArgs);
        if (result.isSuccess() && !result.getCachePageIds().isEmpty()) {
            MainEntityType targetMainType = EntityMetadataCache.getDataEntityType((String)"sfc_dailyplan");
            targetBillObjs = result.loadTargetDataObjects(BusinessDataReader::loadRefence, targetMainType);
            for (DynamicObject targetBillObj : targetBillObjs) {
                DynamicObjectCollection oprentryentity = targetBillObj.getDynamicObjectCollection("oprentryentity");
                targetBillObj.set("taskname", ((DynamicObject)oprentryentity.get(0)).get("workcardtitle"));
                DynamicObject dailyexptype = (DynamicObject)((DynamicObject)oprentryentity.get(0)).get("dailyexptype");
                DynamicObject dailyexptypeNew = MydailyPlanUtils.getDailyexptype(dailyexptype);
                if (dailyexptypeNew == null) {
                    targetBillObj.set("tasksrctype", (Object)"A");
                } else if ("A".equals(dailyexptypeNew.getString("type"))) {
                    targetBillObj.set("tasksrctype", (Object)"B");
                } else if ("B".equals(dailyexptypeNew.getString("type"))) {
                    targetBillObj.set("tasksrctype", (Object)"C");
                }
                MydailyPlanUtils.setPlanAndUser(targetBillObj);
            }
            String[] numbers = CodeRuleServiceHelper.getBatchNumber((String)"sfc_dailyplan", (DynamicObject)((DynamicObject)targetBillObjs.get(0)), (String)MydailyPlanUtils.getCurrentUserOrgId().toString(), (int)targetBillObjs.size());
            for (int i = 0; i < targetBillObjs.size(); ++i) {
                DynamicObject targetBillObj = (DynamicObject)targetBillObjs.get(i);
                if (numbers == null || numbers.length < i + 1 || numbers[i] == null) {
                    targetBillObj.set("billno", (Object)targetBillObj.getPkValue().toString());
                    continue;
                }
                targetBillObj.set("billno", (Object)numbers[i]);
            }
        } else {
            throw new KDBizException(new ErrorCode("StockAutoGenerateStock", MydailyPlanUtils.getErrByRes(result)), new Object[0]);
        }
        SaveServiceHelper.save((DynamicObject[])targetBillObjs.toArray(new DynamicObject[0]));
        iFormView.showSuccessNotification(ResManager.loadKDString((String)"\u64cd\u4f5c\u6210\u529f\u3002", (String)"MydailyPlanUtils_29", (String)"mmc-sfc-common", (Object[])new Object[0]));
    }

    public static String getErrByRes(ConvertOperationResult pushResult) {
        StringBuilder errMessage = new StringBuilder().append(pushResult.getMessage());
        for (SourceBillReport billReport : pushResult.getBillReports()) {
            if (billReport.isFullSuccess()) continue;
            errMessage.append(',');
            errMessage.append(billReport.getFailMessage());
        }
        return errMessage.toString();
    }

    private static DynamicObject getDailyexptype(DynamicObject dailyexptype) {
        if (dailyexptype != null) {
            return BusinessDataServiceHelper.loadSingleFromCache((Object)dailyexptype.getPkValue(), (String)"mpdm_dailyexptypedef", (String)"type");
        }
        return null;
    }

    public static void setPlanAndUser(DynamicObject targetBillObj) {
        Date now = TimeServiceHelper.now();
        DynamicObject currentUser = MydailyPlanUtils.getCurrentUser();
        DynamicObjectCollection planentryentity = targetBillObj.getDynamicObjectCollection("planentryentity");
        DynamicObject planentry = planentryentity.addNew();
        planentry.set("planstarttime", (Object)now);
        planentry.set("planendtime", (Object)MydailyPlanUtils.getEndOfDay(now));
        DynamicObjectCollection allocsubentryentity = planentry.getDynamicObjectCollection("allocsubentryentity");
        DynamicObject allocsubentry = allocsubentryentity.addNew();
        MydailyPlanUtils.setUserInfo(allocsubentry, currentUser);
        MydailyPlanUtils.updatePlanTimeAndUser(targetBillObj);
    }

    public static Date getEndOfDay(Date date) {
        LocalDateTime localDateTime = LocalDateTime.ofInstant(Instant.ofEpochMilli(date.getTime()), ZoneId.systemDefault());
        LocalDateTime endOfDay = localDateTime.with(LocalTime.MAX);
        return Date.from(endOfDay.atZone(ZoneId.systemDefault()).toInstant());
    }

    public static QFilter getUserTaskQFilter(DynamicObject currentUser) {
        QFilter q = new QFilter("planentryentity.allocsubentryentity.userincharge", "=", currentUser.getPkValue());
        QFilter sq = new QFilter("planentryentity.allocsubentryentity.handoveruser", "=", currentUser.getPkValue());
        sq.and("planentryentity.allocsubentryentity.jobsrctype", "in", (Object)new String[]{"A", "C", "D", "E", "F", ""});
        return q.or(sq);
    }

    public static Set<String> isTaskBegin(String tasksrctype) {
        DynamicObject currentUser = MydailyPlanUtils.getCurrentUser();
        QFilter userTaskQFilter = MydailyPlanUtils.getUserTaskQFilter(currentUser);
        QFilter taskQFilter = new QFilter("taskstatus", "=", (Object)"B");
        taskQFilter.and("org", "=", (Object)MydailyPlanUtils.getCurrentUserOrgId());
        String filterStr = "";
        if ("C".equals(tasksrctype)) {
            filterStr = "B";
        }
        QFilter sq = new QFilter("tasksrctype", "in", (Object)new String[]{"A", filterStr, ""});
        DynamicObject[] load = BusinessDataServiceHelper.load((String)"sfc_dailyplan", (String)"taskname,person,reportbegintime,reportendtime", (QFilter[])new QFilter[]{userTaskQFilter, taskQFilter, sq});
        HashSet<String> taskNameSet = new HashSet<String>(16);
        for (DynamicObject daily : load) {
            if (!MydailyPlanUtils.isBeginWork(daily, currentUser)) continue;
            taskNameSet.add(daily.getString("taskname"));
        }
        return taskNameSet;
    }

    private static List<DynamicObject> getBeginTaskList(String[] tasksrctypes) {
        DynamicObject currentUser = MydailyPlanUtils.getCurrentUser();
        QFilter userTaskQFilter = MydailyPlanUtils.getUserTaskQFilter(currentUser);
        QFilter taskQFilter = new QFilter("taskstatus", "=", (Object)"B");
        taskQFilter.and("org", "=", (Object)MydailyPlanUtils.getCurrentUserOrgId());
        QFilter sq = new QFilter("tasksrctype", "in", (Object)tasksrctypes);
        DynamicObject[] load = BusinessDataServiceHelper.load((String)"sfc_dailyplan", (String)MydailyPlanUtils.getFinishStr(), (QFilter[])new QFilter[]{userTaskQFilter, taskQFilter, sq});
        ArrayList<DynamicObject> dailyplanList = new ArrayList<DynamicObject>();
        for (DynamicObject daily : load) {
            if (!MydailyPlanUtils.isBeginWork(daily, currentUser)) continue;
            dailyplanList.add(daily);
        }
        return dailyplanList;
    }

    public static String getFinishStr() {
        return "billtype,taskname,taskstatus,status,orderno,srcbillid,srcbillentryid,workcardtitle,processgroup,status,profession,finishlog,reportbegintime,reportendtime,actualhour,person,workhourunit,finishworktime,checkworktime,recheckworktime,finishworkuser,checkworkuser,recheckworkuser,isreported,mulcheckuser";
    }

    public static Long getCurrentUserOrgId() {
        RequestContext requestContext = RequestContext.get();
        long orgId = requestContext.getOrgId();
        return orgId;
    }

    public static boolean isCheckUser() {
        DynamicObject currentUser = MydailyPlanUtils.getCurrentUser();
        List<Long> checkuserIdList = MydailyPlanUtils.getCheckuserIdList(new QFilter("id", "=", currentUser.getPkValue()));
        return !checkuserIdList.isEmpty();
    }

    public static List<Long> getCheckuserIdList(QFilter q) {
        DynamicObject[] manupersons = BusinessDataServiceHelper.load((String)"mpdm_manuperson", (String)"user", (QFilter[])new QFilter[]{q});
        ArrayList<Long> userIdList = new ArrayList<Long>(16);
        for (DynamicObject manuperson : manupersons) {
            DynamicObject user = manuperson.getDynamicObject("user");
            if (user == null) continue;
            userIdList.add((Long)user.getPkValue());
        }
        ArrayList<Long> checkuserIdList = new ArrayList<Long>(16);
        JSONObject res = (JSONObject)DispatchServiceHelper.invokeBizService((String)"mmc", (String)"fmm", (String)"AuthorizeinformService", (String)"isInspectors", (Object[])new Object[]{userIdList});
        if (res.get((Object)"successful").toString().equals("true")) {
            Map dataMap = (Map)res.get((Object)"data");
            for (Map.Entry m : dataMap.entrySet()) {
                if (!((Boolean)m.getValue()).booleanValue()) continue;
                checkuserIdList.add((Long)m.getKey());
            }
        }
        return checkuserIdList;
    }

    public static Set<Long> getCheckUserSet(DynamicObjectCollection mulcheckuser, Set<Long> set) {
        HashSet<Long> checkUserSet = new HashSet<Long>(16);
        for (DynamicObject user : mulcheckuser) {
            DynamicObject userDym = user.getDynamicObject("fbasedataid");
            checkUserSet.add((Long)userDym.getPkValue());
        }
        HashSet<Long> checkUserSetNew = new HashSet<Long>(16);
        for (Long checkUser : set) {
            if (checkUserSet.contains(checkUser)) continue;
            checkUserSetNew.add(checkUser);
        }
        return checkUserSetNew;
    }

    public static void deleteCheckUser(DynamicObjectCollection mulcheckuser, DynamicObject currentUser) {
        HashSet<DynamicObject> checkUser = new HashSet<DynamicObject>(16);
        for (DynamicObject user : mulcheckuser) {
            DynamicObject userDym = user.getDynamicObject("fbasedataid");
            if (!userDym.getPkValue().toString().equals(currentUser.getPkValue().toString())) continue;
            checkUser.add(user);
        }
        if (!checkUser.isEmpty()) {
            mulcheckuser.removeAll(checkUser);
        }
    }

    public static boolean isExistCheckUser(DynamicObjectCollection mulcheckuser, DynamicObject currentUser) {
        HashSet<DynamicObject> checkUser = new HashSet<DynamicObject>(16);
        for (DynamicObject user : mulcheckuser) {
            DynamicObject userDym = user.getDynamicObject("fbasedataid");
            if (!userDym.getPkValue().toString().equals(currentUser.getPkValue().toString())) continue;
            checkUser.add(user);
        }
        return !checkUser.isEmpty();
    }
}

