/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.sfc.common.utils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;

public class QueryOrderUtil {
    private static final Log logger = LogFactory.getLog(QueryOrderUtil.class);

    public static Map<Long, Map<String, Object>> getOrderByEntryId(Set<Long> orderEntryIds) {
        logger.info(String.format("\u901a\u8fc7\u5de5\u5355\u5206\u5f55id\u96c6\u5408\u83b7\u53d6\u5de5\u5355\u5206\u5f55\uff1a%1$s", orderEntryIds));
        HashMap<Long, Map<String, Object>> result = new HashMap<Long, Map<String, Object>>(128);
        QFilter filter = new QFilter("treeentryentity.id", "in", orderEntryIds);
        String selectFields = "id,billno,billstatus,treeentryentity.id,treeentryentity.seq,treeentryentity.materielmasterid,treeentryentity.baseunit,treeentryentity.bizstatus,treeentryentity.planstatus";
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"getOrderByEntryId", (String)"pom_mftorder", (String)selectFields, (QFilter[])new QFilter[]{filter}, (String)"");){
            while (dataSet.hasNext()) {
                HashMap<String, Object> map = new HashMap<String, Object>(16);
                Row next = dataSet.next();
                map.put("id", next.getLong("id"));
                map.put("billno", next.getString("billno"));
                map.put("billstatus", next.getString("billstatus"));
                map.put("treeentryentity.id", next.getLong("treeentryentity.id"));
                map.put("treeentryentity.materielmasterid", next.getLong("treeentryentity.materielmasterid"));
                map.put("treeentryentity.baseunit", next.getLong("treeentryentity.baseunit"));
                map.put("treeentryentity.seq", next.getInteger("treeentryentity.seq"));
                map.put("treeentryentity.bizstatus", next.getString("treeentryentity.bizstatus"));
                map.put("treeentryentity.planstatus", next.getString("treeentryentity.planstatus"));
                result.put(next.getLong("treeentryentity.id"), map);
            }
        }
        return result;
    }

    public static Map<Long, Map<String, Object>> getMroOrderByEntryId(Set<Long> orderEntryIds) {
        HashMap<Long, Map<String, Object>> result = new HashMap<Long, Map<String, Object>>(128);
        QFilter filter = new QFilter("treeentryentity.id", "in", orderEntryIds);
        String selectFields = "id,billno,billstatus,treeentryentity.id,treeentryentity.seq,treeentryentity.materielmasterid,treeentryentity.baseunit,treeentryentity.bizstatus,treeentryentity.planstatus";
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"getOrderByEntryId", (String)"pom_mroorder", (String)selectFields, (QFilter[])new QFilter[]{filter}, (String)"");){
            while (dataSet.hasNext()) {
                HashMap<String, Object> map = new HashMap<String, Object>(16);
                Row next = dataSet.next();
                map.put("id", next.getLong("id"));
                map.put("billno", next.getString("billno"));
                map.put("billstatus", next.getString("billstatus"));
                map.put("treeentryentity.id", next.getLong("treeentryentity.id"));
                map.put("treeentryentity.materielmasterid", next.getLong("treeentryentity.materielmasterid"));
                map.put("treeentryentity.baseunit", next.getLong("treeentryentity.baseunit"));
                map.put("treeentryentity.seq", next.getInteger("treeentryentity.seq"));
                map.put("treeentryentity.bizstatus", next.getString("treeentryentity.bizstatus"));
                map.put("treeentryentity.planstatus", next.getString("treeentryentity.planstatus"));
                result.put(next.getLong("treeentryentity.id"), map);
            }
        }
        return result;
    }

    public static Map<Long, Map<String, Object>> getManftechByEntryId(Set<Long> oprEntryIds) {
        HashMap<Long, Map<String, Object>> result = new HashMap<Long, Map<String, Object>>(128);
        QFilter filter = new QFilter("oprentryentity.id", "in", oprEntryIds);
        String selectFields = "billno,billstatus,mftentryseq,baseunit,material,oprentryentity.id,oprentryentity.headqty,oprentryentity.headunit,oprentryentity.operationqty,oprentryentity.oprunit,oprentryentity.oprqty,oprentryentity.oprtotalqualifiedqty,oprentryentity.oprinvalid,oprentryentity.oprparent,oprentryentity.oprno,oprentryentity.oprtotalreworkqty,oprentryentity.pushreworkreportqty,oprentryentity.oprtotaloutqty,oprentryentity.oprtotalreceiveqty,oprentryentity.actualstarttime,oprentryentity.actualcompletiontime,oprentryentity.oprstatus,oprentryentity.totaloproutorderbaseqty,oprentryentity.oprtotalreportbaseqty";
        HashSet<Long> unitIds = new HashSet<Long>(16);
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"getManftechByEntryId", (String)"sfc_manftech", (String)selectFields, (QFilter[])new QFilter[]{filter}, (String)"");){
            while (dataSet.hasNext()) {
                HashMap<String, Object> map = new HashMap<String, Object>(64);
                Row next = dataSet.next();
                map.put("billno", next.getString("billno"));
                map.put("billstatus", next.getString("billstatus"));
                map.put("baseunit", next.getLong("baseunit"));
                unitIds.add(next.getLong("baseunit"));
                map.put("mftentryseq", next.getLong("mftentryseq"));
                map.put("material", next.getLong("material"));
                map.put("oprentryentity.id", next.getLong("oprentryentity.id"));
                map.put("oprentryentity.headunit", next.getLong("oprentryentity.headunit"));
                unitIds.add(next.getLong("oprentryentity.headunit"));
                map.put("oprentryentity.oprunit", next.getLong("oprentryentity.oprunit"));
                unitIds.add(next.getLong("oprentryentity.oprunit"));
                map.put("oprentryentity.headqty", next.getBigDecimal("oprentryentity.headqty"));
                map.put("oprentryentity.operationqty", next.getBigDecimal("oprentryentity.operationqty"));
                map.put("oprentryentity.oprqty", next.getBigDecimal("oprentryentity.oprqty"));
                map.put("oprentryentity.oprtotalqualifiedqty", next.getBigDecimal("oprentryentity.oprtotalqualifiedqty"));
                map.put("oprentryentity.oprtotalreworkqty", next.getBigDecimal("oprentryentity.oprtotalreworkqty"));
                map.put("oprentryentity.pushreworkreportqty", next.getBigDecimal("oprentryentity.pushreworkreportqty"));
                map.put("oprentryentity.oprtotaloutqty", next.getBigDecimal("oprentryentity.oprtotaloutqty"));
                map.put("oprentryentity.oprtotalreceiveqty", next.getBigDecimal("oprentryentity.oprtotalreceiveqty"));
                map.put("oprentryentity.oprinvalid", next.getBoolean("oprentryentity.oprinvalid"));
                map.put("oprentryentity.oprparent", next.getString("oprentryentity.oprparent"));
                map.put("oprentryentity.oprstatus", next.getString("oprentryentity.oprstatus"));
                map.put("oprentryentity.oprno", next.getString("oprentryentity.oprno"));
                map.put("oprentryentity.actualstarttime", next.getDate("oprentryentity.actualstarttime"));
                map.put("oprentryentity.actualcompletiontime", next.getDate("oprentryentity.actualcompletiontime"));
                map.put("oprentryentity.totaloproutorderbaseqty", next.getBigDecimal("oprentryentity.totaloproutorderbaseqty"));
                map.put("oprentryentity.oprtotalreportbaseqty", next.getBigDecimal("oprentryentity.oprtotalreportbaseqty"));
                result.put(next.getLong("oprentryentity.id"), map);
            }
        }
        Map unit = BusinessDataServiceHelper.loadFromCache((String)"bd_measureunits", (String)"id,precision,precisionaccount", (QFilter[])new QFilter[]{new QFilter("id", "in", unitIds)});
        result.forEach((k, v) -> {
            DynamicObject baseUnitObj = (DynamicObject)unit.get(v.get("baseunit"));
            v.put("baseunit.precision", baseUnitObj.getInt("precision"));
            v.put("baseunit.precisionaccount", baseUnitObj.getString("precisionaccount"));
            DynamicObject headUnitObj = (DynamicObject)unit.get(v.get("oprentryentity.headunit"));
            v.put("oprentryentity.headunit.precision", headUnitObj.getInt("precision"));
            v.put("oprentryentity.headunit.precisionaccount", headUnitObj.getString("precisionaccount"));
            DynamicObject oprUnitObj = (DynamicObject)unit.get(v.get("oprentryentity.oprunit"));
            v.put("oprentryentity.oprunit.precision", oprUnitObj.getInt("precision"));
            v.put("oprentryentity.oprunit.precisionaccount", oprUnitObj.getString("precisionaccount"));
        });
        return result;
    }

    public static Map<Long, Map<String, Object>> getMroManftechByEntryId(Set<Long> oprEntryIds) {
        HashMap<Long, Map<String, Object>> result = new HashMap<Long, Map<String, Object>>(128);
        QFilter filter = new QFilter("oprentryentity.id", "in", oprEntryIds);
        HashSet<Long> unitIds = new HashSet<Long>(16);
        String selectFields = "billno,billstatus,mftentryseq,baseunit,material,oprentryentity.id,oprentryentity.headqty,oprentryentity.headunit,oprentryentity.operationqty,oprentryentity.oprunit,oprentryentity.oprqty,oprentryentity.oprtotalqualifiedqty,oprentryentity.oprinvalid,oprentryentity.oprparent,oprentryentity.oprno,oprentryentity.oprtotalreworkqty,oprentryentity.pushreworkreportqty,oprentryentity.oprtotaloutqty,oprentryentity.oprtotalreceiveqty";
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"getManftechByEntryId", (String)"sfc_mromanuftech", (String)selectFields, (QFilter[])new QFilter[]{filter}, (String)"");){
            while (dataSet.hasNext()) {
                HashMap<String, Object> map = new HashMap<String, Object>(64);
                Row next = dataSet.next();
                map.put("billno", next.getString("billno"));
                map.put("billstatus", next.getString("billstatus"));
                map.put("baseunit", next.getLong("baseunit"));
                unitIds.add(next.getLong("baseunit"));
                map.put("mftentryseq", next.getLong("mftentryseq"));
                map.put("material", next.getLong("material"));
                map.put("oprentryentity.id", next.getLong("oprentryentity.id"));
                map.put("oprentryentity.headunit", next.getLong("oprentryentity.headunit"));
                unitIds.add(next.getLong("oprentryentity.headunit"));
                map.put("oprentryentity.oprunit", next.getLong("oprentryentity.oprunit"));
                map.put("oprentryentity.headqty", next.getBigDecimal("oprentryentity.headqty"));
                map.put("oprentryentity.operationqty", next.getBigDecimal("oprentryentity.operationqty"));
                map.put("oprentryentity.oprqty", next.getBigDecimal("oprentryentity.oprqty"));
                map.put("oprentryentity.oprtotalqualifiedqty", next.getBigDecimal("oprentryentity.oprtotalqualifiedqty"));
                map.put("oprentryentity.oprtotalreworkqty", next.getBigDecimal("oprentryentity.oprtotalreworkqty"));
                map.put("oprentryentity.pushreworkreportqty", next.getBigDecimal("oprentryentity.pushreworkreportqty"));
                map.put("oprentryentity.oprtotaloutqty", next.getBigDecimal("oprentryentity.oprtotaloutqty"));
                map.put("oprentryentity.oprtotalreceiveqty", next.getBigDecimal("oprentryentity.oprtotalreceiveqty"));
                map.put("oprentryentity.oprinvalid", next.getBoolean("oprentryentity.oprinvalid"));
                map.put("oprentryentity.oprparent", next.getString("oprentryentity.oprparent"));
                map.put("oprentryentity.oprno", next.getString("oprentryentity.oprno"));
                result.put(next.getLong("oprentryentity.id"), map);
            }
        }
        Map unit = BusinessDataServiceHelper.loadFromCache((String)"bd_measureunits", (String)"id,precision,precisionaccount", (QFilter[])new QFilter[]{new QFilter("id", "in", unitIds)});
        result.forEach((k, v) -> {
            DynamicObject baseUnitObj = (DynamicObject)unit.get(v.get("baseunit"));
            v.put("baseunit.precision", baseUnitObj.getInt("precision"));
            v.put("baseunit.precisionaccount", baseUnitObj.getString("precisionaccount"));
            DynamicObject headUnitObj = (DynamicObject)unit.get(v.get("oprentryentity.headunit"));
            v.put("oprentryentity.headunit.precision", headUnitObj.getInt("precision"));
            v.put("oprentryentity.headunit.precisionaccount", headUnitObj.getString("precisionaccount"));
        });
        return result;
    }

    public static List<Map<String, Object>> getXmanuFetchByOprEntryId(Set<Long> oprEntryIds, String entity) {
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>(128);
        QFilter filter = new QFilter("billstatus", "!=", (Object)"C");
        filter.and(new QFilter("oprentryentity.oprentryid", "in", oprEntryIds));
        String selectFields = "id,billno,billstatus,oprentryentity.id,oprentryentity.oprentryid";
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"getXmanuFetchByOprEntryId", (String)entity, (String)selectFields, (QFilter[])new QFilter[]{filter}, (String)"");){
            while (dataSet.hasNext()) {
                HashMap<String, Object> map = new HashMap<String, Object>(16);
                Row next = dataSet.next();
                map.put("id", next.getLong("id"));
                map.put("billno", next.getString("billno"));
                map.put("billstatus", next.getString("billstatus"));
                map.put("oprentryentity.id", next.getLong("oprentryentity.id"));
                map.put("oprentryentity.oprentryid", next.getLong("oprentryentity.oprentryid"));
                result.add(map);
            }
        }
        return result;
    }

    public static Map<Object, Boolean> queryWorkCenter(DynamicObject entryObj, Map<Object, DynamicObject> workCenter) {
        HashMap<Object, Boolean> map = new HashMap<Object, Boolean>(16);
        DynamicObject dynamicObject = entryObj.getDynamicObject("oprworkcenter");
        if (dynamicObject != null) {
            DynamicObject object = workCenter.get(dynamicObject.getPkValue());
            DynamicObjectCollection processactivetable = object.getDynamicObjectCollection("processactivetable");
            for (int i = 0; i < processactivetable.size(); ++i) {
                DynamicObject entry = (DynamicObject)processactivetable.get(i);
                if (entry.getDynamicObject("processnumber") == null) continue;
                map.put(entry.getDynamicObject("processnumber").getLong("id"), "1".equals(entry.getString("processroutecontrol")));
            }
        }
        return map;
    }

    public static String selectProperties(String manuftechType) {
        StringBuilder strBuilder = new StringBuilder();
        strBuilder.append("id,");
        strBuilder.append("billstatus,");
        strBuilder.append("configuredcode,");
        strBuilder.append("tracknumber,");
        strBuilder.append("org").append(",");
        strBuilder.append("manufactureorderid").append(",");
        strBuilder.append("mftentryseq").append(",");
        strBuilder.append("productionworkshop").append(",");
        strBuilder.append("qty").append(',');
        strBuilder.append("processroute").append(',');
        strBuilder.append("planstarttime").append(',');
        strBuilder.append("planfinishtime").append(',');
        strBuilder.append("baseqty").append(',');
        strBuilder.append("billno").append(',');
        strBuilder.append("manufactureorderseq").append(',');
        strBuilder.append("transactiontype").append(',');
        strBuilder.append("baseunit").append(',');
        strBuilder.append("changestatus").append(',');
        strBuilder.append("billtype").append(',');
        strBuilder.append("accountingorg").append(',');
        if ("sfc_mromanuftech".equals(manuftechType)) {
            strBuilder.append("pageseq").append(',');
            strBuilder.append("materielmtc").append(',');
            strBuilder.append("mrtype").append(',');
            strBuilder.append("workcard").append(',');
            strBuilder.append("project").append(',');
            strBuilder.append("oprentryentity").append('.').append("oprpageseq").append(',');
            strBuilder.append("oprentryentity").append('.').append("oprremark").append(',');
            strBuilder.append("oprentryentity").append('.').append("oprprocessgroup").append(',');
            strBuilder.append("oprentryentity").append('.').append("oprprofessiona").append(',');
            strBuilder.append("oprentryentity").append('.').append("oprworkhours").append(',');
            strBuilder.append("oprentryentity").append('.').append("oprworkhourunit").append(',');
            strBuilder.append("oprentryentity").append('.').append("oprcustomhours").append(',');
            strBuilder.append("actsubentryentity").append('.').append("actactivity").append(',');
            strBuilder.append("actsubentryentity").append('.').append("actunit").append(',');
            strBuilder.append("actsubentryentity").append('.').append("actresources").append(',');
            strBuilder.append("actsubentryentity").append('.').append("actqty").append(',');
            strBuilder.append("actsubentryentity").append('.').append("actstandardformula").append(',');
            strBuilder.append("actsubentryentity").append('.').append("actminformula").append(',');
            strBuilder.append("actsubentryentity").append('.').append("actstandardformula1").append(',');
            strBuilder.append("actsubentryentity").append('.').append("actminformula1").append(',');
            strBuilder.append("actsubentryentity").append('.').append("biztype").append(',');
            strBuilder.append("actsubentryentity").append('.').append("processstage").append(',');
            strBuilder.append("actsubentryentity").append('.').append("sourceactid").append(',');
            strBuilder.append("actsubentryentity").append('.').append("actplantotalqty").append(',');
            strBuilder.append("groentryentity").append('.').append("groprocessgroup").append(',');
            strBuilder.append("groentryentity").append('.').append("grogroupstatus").append(',');
            strBuilder.append("groentryentity").append('.').append("gromodifier").append(',');
            strBuilder.append("groentryentity").append('.').append("gromodifytime").append(',');
        }
        strBuilder.append("proentryentity").append('.').append("seq").append(',');
        strBuilder.append("proentryentity").append('.').append("processreference").append(',');
        strBuilder.append("proentryentity").append('.').append("processoutputdesc").append(',');
        strBuilder.append("proentryentity").append('.').append("processinputdesc").append(',');
        strBuilder.append("proentryentity").append('.').append("processseqqty").append(',');
        strBuilder.append("proentryentity").append('.').append("processseq").append(',');
        strBuilder.append("proentryentity").append('.').append("processplanbegintime").append(',');
        strBuilder.append("proentryentity").append('.').append("processplanendtime").append(',');
        strBuilder.append("proentryentity").append('.').append("processplanouttime").append(',');
        strBuilder.append("proentryentity").append('.').append("processplanintime").append(',');
        strBuilder.append("proentryentity").append('.').append("processseqname").append(',');
        strBuilder.append("proentryentity").append('.').append("processseqtype").append(',');
        strBuilder.append("proentryentity").append('.').append("processrelation").append(',');
        strBuilder.append("proentryentity").append('.').append("processoutput").append(',');
        strBuilder.append("proentryentity").append('.').append("processinput").append(',');
        strBuilder.append("proentryentity").append('.').append("processremark").append(',');
        strBuilder.append("oprentryentity").append('.').append("oprplanbegintime").append(',');
        strBuilder.append("oprentryentity").append('.').append("oprplanfinishtime").append(',');
        strBuilder.append("oprentryentity").append('.').append("headqty").append(',');
        strBuilder.append("oprentryentity").append('.').append("headunit").append(',');
        strBuilder.append("oprentryentity").append('.').append("operationqty").append(',');
        strBuilder.append("oprentryentity").append('.').append("oprunit").append(',');
        strBuilder.append("oprentryentity").append('.').append("oprstandardqty").append(',');
        strBuilder.append("oprentryentity").append('.').append("oprqty").append(',');
        strBuilder.append("oprentryentity").append('.').append("oprproductionqty").append(',');
        strBuilder.append("oprentryentity").append('.').append("oprstatus").append(',');
        strBuilder.append("oprentryentity").append('.').append("oprinvalid").append(',');
        strBuilder.append("oprentryentity").append('.').append("oproperation").append(',');
        strBuilder.append("oprentryentity").append('.').append("oprno").append(',');
        strBuilder.append("oprentryentity").append('.').append("oprparent").append(',');
        strBuilder.append("oprentryentity").append('.').append("oprearliestbegintime").append(',');
        strBuilder.append("oprentryentity").append('.').append("oprlatestbegintime").append(',');
        strBuilder.append("oprentryentity").append('.').append("oprearliestfinishtime").append(',');
        strBuilder.append("oprentryentity").append('.').append("oprlatestfinishtime").append(',');
        strBuilder.append("oprentryentity").append('.').append("actsubentryentity").append(',');
        strBuilder.append("oprentryentity").append('.').append("oprtotalqualifiedqty").append(',');
        strBuilder.append("oprentryentity").append('.').append("oprtotalreceiveqty").append(',');
        strBuilder.append("oprentryentity").append('.').append("upperqty").append(',');
        strBuilder.append("oprentryentity").append('.').append("floorqty").append(',');
        strBuilder.append("oprentryentity").append('.').append("upperratio").append(',');
        strBuilder.append("oprentryentity").append('.').append("floorratio").append(',');
        strBuilder.append("oprentryentity").append('.').append("oprorg").append(',');
        strBuilder.append("oprentryentity").append('.').append("oprworkcenter").append(',');
        strBuilder.append("oprentryentity").append('.').append("oprworkshop").append(',');
        strBuilder.append("oprentryentity").append('.').append("oprdescription").append(',');
        strBuilder.append("oprentryentity").append('.').append("oprctrlstrategy").append(',');
        strBuilder.append("oprentryentity").append('.').append("machiningtype").append(',');
        strBuilder.append("oprentryentity").append('.').append("oprtotalsplitqty").append(',');
        strBuilder.append("oprentryentity").append('.').append("oprsourcetype").append(',');
        strBuilder.append("oprentryentity").append('.').append("oprsourceentryid").append(',');
        strBuilder.append("oprentryentity").append('.').append("workstation").append(',');
        strBuilder.append("oprentryentity").append('.').append("supplier").append(',');
        strBuilder.append("oprentryentity").append('.').append("purchasegroup").append(',');
        strBuilder.append("oprentryentity").append('.').append("purchaser").append(',');
        strBuilder.append("oprentryentity").append('.').append("purchaseorg").append(',');
        strBuilder.append("oprentryentity").append('.').append("storagepoint").append(',');
        strBuilder.append("oprentryentity").append('.').append("collaborative").append(',');
        strBuilder.append("oprentryentity").append('.').append("inspectiontype").append(',');
        strBuilder.append("oprentryentity").append('.').append("firstinspection").append(',');
        strBuilder.append("oprentryentity").append('.').append("firstinspectioncontrol").append(',');
        strBuilder.append("oprentryentity").append('.').append("beginworkbf").append(',');
        strBuilder.append("oprentryentity").append('.').append("ismilestoneprocess").append(',');
        strBuilder.append("oprentryentity").append('.').append("actualstarttime").append(',');
        strBuilder.append("oprentryentity").append('.').append("actualcompletiontime").append(',');
        strBuilder.append("oprentryentity").append('.').append("seq").append(',');
        strBuilder.append("oprentryentity").append('.').append("basebatchqty").append(',');
        strBuilder.append("oprentryentity").append('.').append("opraccountingorg").append(',');
        strBuilder.append("oprentryentity").append('.').append("opriscrossesacctorg").append(',');
        strBuilder.append("actsubentryentity").append('.').append("actplanbegintime").append(',');
        strBuilder.append("actsubentryentity").append('.').append("actplanfinishtime").append(',');
        strBuilder.append("actsubentryentity").append('.').append("actunit").append(',');
        strBuilder.append("actsubentryentity").append('.').append("actactivity").append(',');
        strBuilder.append("actsubentryentity").append('.').append("actresources").append(',');
        strBuilder.append("actsubentryentity").append('.').append("actqty").append(',');
        strBuilder.append("actsubentryentity").append('.').append("actstandardformula").append(',');
        strBuilder.append("actsubentryentity").append('.').append("actstandardformula1").append(',');
        strBuilder.append("actsubentryentity").append('.').append("biztype").append(',');
        strBuilder.append("actsubentryentity").append('.').append("processstage").append(',');
        strBuilder.append("actsubentryentity").append('.').append("actplantotalqty").append(',');
        strBuilder.append("actsubentryentity");
        return strBuilder.toString();
    }
}

