/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.sfc.common.utils;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.MobileBillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.DcBinder;
import kd.bos.dataentity.serialization.DcJsonSerializer;
import kd.bos.dataentity.serialization.DynamicObjectSerializationBinder;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.FieldProp;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.plugin.FormViewPluginProxy;
import kd.bos.list.IListView;
import kd.bos.list.IMobileListView;
import kd.bos.list.events.BeforeShowBillFormEvent;
import kd.bos.list.plugin.ListViewPluginProxy;
import kd.bos.mservice.sysparam.SystemParamService;
import kd.bos.mvc.SessionManager;
import kd.bos.orm.query.QFilter;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public class SFCUtils {
    public static final String DATEFORMAT = "yyyy-MM-dd";
    public static final String DATETIMEFORMAT = "yyyy-MM-dd HH:mm:ss";
    public static final String TIMEFORMAT = "HH:mm:ss";
    public static final long DAYTIME = 86400000L;
    public static final long HOURTIME = 3600000L;
    public static final long MINUTETIME = 60000L;
    public static final long SECONDTIME = 1000L;
    public static final String OP_RECEIVE = "receive";
    public static final String OP_ACCEPT = "accept";
    public static final String OP_DENY = "deny";
    public static final String OP_FORWARD = "forward";
    public static final String VAR_FORWARDTO = "forwardTo";
    public static final String COL_HANDOVERSTATUS = "handoverstatus";
    public static final String COL_BILLSTATUS = "billstatus";
    public static final String COL_AUDITOR = "auditor";
    public static final String COL_AUDITDATE = "auditdate";
    public static final String COL_INDUSTRY = "industry";
    public static final String COL_BILLNO = "billno";
    public static final String COL_ISCONTENTTRYUPD = "iscontentryupd";
    public static final String COL_ISSPNTCENTRYUPD = "isspntcentryupd";
    public static final String COL_FORWARDTO = "forwardto";
    public static final String COL_RECEIVEDBY = "receivedby";
    public static final String COL_HANDOVERPERSON = "handoverperson";
    public static final String COL_HOPERSMOBILE = "hopersmobile";
    public static final String COL_ENTRY = "entry";
    public static final String COL_ENTRYDAILYPLANID = "entrydailyplanid";
    public static final String COL_ENTRYDAILYPLANENTRYID = "entrydailyplanentryid";
    public static final SystemParamService sps = (SystemParamService)ServiceFactory.getService(SystemParamService.class);

    public static String timeFormat(long time, String format) {
        long h;
        long mod;
        boolean formatS;
        if (StringUtils.isEmpty((CharSequence)format)) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        long newTime = time;
        String formatStr = format;
        String transStr = formatStr.toUpperCase().trim();
        boolean formatD = transStr.indexOf(68) >= 0;
        boolean formatH = transStr.indexOf(72) >= 0;
        boolean formatM = transStr.indexOf(77) >= 0;
        boolean bl = formatS = transStr.indexOf(83) >= 0;
        if (formatD && newTime >= 86400000L) {
            mod = newTime % 86400000L;
            h = (newTime -= mod) / 86400000L;
            sb.append(h);
            newTime = mod;
            sb.append(ResManager.loadKDString((String)"\u5929", (String)"SFCUtils_4", (String)"mmc-sfc-common", (Object[])new Object[0]));
        }
        if (formatH && newTime >= 3600000L) {
            mod = newTime % 3600000L;
            h = (newTime -= mod) / 3600000L;
            sb.append(h);
            newTime = mod;
            sb.append(ResManager.loadKDString((String)"\u5c0f\u65f6", (String)"SFCUtils_1", (String)"mmc-sfc-common", (Object[])new Object[0]));
        }
        if (formatM && newTime >= 60000L) {
            mod = newTime % 60000L;
            long m = (newTime -= mod) / 60000L;
            sb.append(m);
            newTime = mod;
            sb.append(ResManager.loadKDString((String)"\u5206\u949f", (String)"SFCUtils_2", (String)"mmc-sfc-common", (Object[])new Object[0]));
        }
        if (formatS && newTime >= 1000L) {
            mod = newTime % 1000L;
            long s = (newTime -= mod) / 1000L;
            sb.append(s);
            newTime = mod;
            sb.append(ResManager.loadKDString((String)"\u79d2", (String)"SFCUtils_3", (String)"mmc-sfc-common", (Object[])new Object[0]));
        }
        return sb.toString();
    }

    public static boolean isEmptyMap(Map map) {
        return map == null || map.isEmpty();
    }

    public static boolean isEmptySet(Set set) {
        return set == null || set.isEmpty();
    }

    public static String getOperateOptionVariableValue(OperateOption oo, String varKey) {
        if (oo == null || StringUtils.isEmpty((CharSequence)varKey)) {
            return null;
        }
        return oo.containsVariable(varKey) ? oo.getVariableValue(varKey) : null;
    }

    public static boolean isEmptyList(List list) {
        return list == null || list.size() == 0;
    }

    public static Object getMapValue(Map map, Object key) {
        if (SFCUtils.isEmptyMap(map)) {
            return null;
        }
        if (key == null) {
            return null;
        }
        if (StringUtils.isEmpty((CharSequence)key.toString())) {
            return null;
        }
        if (map.containsKey(key.toString())) {
            return map.get(key.toString());
        }
        if (map.containsKey(key)) {
            return map.get(key);
        }
        return null;
    }

    public static String getMapStringValue(Map map, Object key) {
        Object objValue = SFCUtils.getMapValue(map, key);
        return objValue == null ? null : objValue.toString();
    }

    public static DynamicObject getMapDynamicObjectValue(Map map, Object key) {
        Object objValue = SFCUtils.getMapValue(map, key);
        return objValue instanceof DynamicObject ? (DynamicObject)objValue : null;
    }

    public static Date getMapDateValue(Map map, Object key) {
        Object objValue = SFCUtils.getMapValue(map, key);
        return objValue instanceof Date ? (Date)objValue : null;
    }

    public static long getMapLongValue(Map map, Object key) {
        Object objValue = SFCUtils.getMapValue(map, key);
        return objValue == null ? 0L : (objValue instanceof Long ? (Long)objValue : (objValue instanceof Integer ? (long)((Integer)objValue).intValue() : 0L));
    }

    public static Date formatStringToDate(String formatDateString, String format) throws ParseException {
        if (StringUtils.isEmpty((CharSequence)formatDateString) || StringUtils.isEmpty((CharSequence)format)) {
            return null;
        }
        SimpleDateFormat sdf = new SimpleDateFormat(format);
        return sdf.parse(formatDateString);
    }

    public static Date formatDateStringToDate(String formatDateString) throws ParseException {
        return SFCUtils.formatStringToDate(formatDateString, DATEFORMAT);
    }

    public static Date formatDateTimeStringToDate(String formatDateString) throws ParseException {
        return SFCUtils.formatStringToDate(formatDateString, DATETIMEFORMAT);
    }

    public static Date formatTimeStringToDate(String formatDateString) throws ParseException {
        return SFCUtils.formatStringToDate(formatDateString, TIMEFORMAT);
    }

    public static String dateToFormatString(Date date, String format) {
        if (date == null || StringUtils.isEmpty((CharSequence)format)) {
            return null;
        }
        SimpleDateFormat sdf = new SimpleDateFormat(format);
        return sdf.format(date);
    }

    public static String dateToFormatDateString(Date date) {
        return SFCUtils.dateToFormatString(date, DATEFORMAT);
    }

    public static String dateToFormatTimeString(Date date) {
        return SFCUtils.dateToFormatString(date, TIMEFORMAT);
    }

    public static String dateToFormatDateTimeString(Date date) {
        return SFCUtils.dateToFormatString(date, DATETIMEFORMAT);
    }

    public static void setMustInput(IFormView fv, boolean isMustInput, String ... propNames) {
        if (fv == null || ArrayUtils.isEmpty((Object[])propNames)) {
            return;
        }
        IDataModel dm = fv.getModel();
        for (String propName : propNames) {
            FieldProp fpProp;
            FieldEdit feControl = (FieldEdit)fv.getControl(propName);
            feControl.setMustInput(isMustInput);
            IDataEntityProperty idepProp = dm.getProperty(propName);
            BasedataProp bpProp = idepProp instanceof BasedataProp ? (BasedataProp)idepProp : null;
            FieldProp fieldProp = fpProp = idepProp instanceof FieldProp ? (FieldProp)idepProp : null;
            if (bpProp != null) {
                bpProp.setMustInput(isMustInput);
            }
            if (fpProp == null) continue;
            fpProp.setMustInput(isMustInput);
        }
    }

    public static Set getMapSetValue(Map map, Object key) {
        Object objValue = SFCUtils.getMapValue(map, key);
        return objValue instanceof Set ? (Set)objValue : null;
    }

    public static Map getMapMapValue(Map map, Object key) {
        Object objValue = SFCUtils.getMapValue(map, key);
        return objValue instanceof Map ? (Map)objValue : null;
    }

    public static long getDynamicObjectLongPK(DynamicObject doTmp) {
        if (doTmp == null) {
            return 0L;
        }
        Object objDOTmpPK = doTmp.getPkValue();
        return objDOTmpPK == null ? 0L : (objDOTmpPK instanceof Long ? (Long)objDOTmpPK : (objDOTmpPK instanceof Integer ? (long)((Integer)objDOTmpPK).intValue() : 0L));
    }

    public static String getDynamicObjectStringPK(DynamicObject doTmp) {
        if (doTmp == null) {
            return "";
        }
        Object objDOTmpPK = doTmp.getPkValue();
        String lDOTmpPK = objDOTmpPK == null ? "" : (objDOTmpPK instanceof String ? (String)objDOTmpPK : "");
        return lDOTmpPK;
    }

    public static boolean getMapBooleanValue(Map map, Object key) {
        Object objValue = SFCUtils.getMapValue(map, key);
        return objValue == null ? false : (objValue instanceof Boolean ? (Boolean)objValue : Boolean.parseBoolean(objValue.toString()));
    }

    public static List getMapListValue(Map map, Object key) {
        Object objValue = SFCUtils.getMapValue(map, key);
        return objValue == null ? null : (objValue instanceof List ? (List)objValue : null);
    }

    public static void saveFormViewData(IFormView fv) {
        IPageCache pcParent;
        IFormView fvParent;
        String parentPageID;
        IDataModel dm;
        BillOperationStatus bos;
        if (fv == null) {
            return;
        }
        FormShowParameter fsp = fv.getFormShowParameter();
        BillShowParameter bsp = fsp instanceof BillShowParameter ? (BillShowParameter)fsp : null;
        BillOperationStatus billOperationStatus = bos = bsp == null ? null : bsp.getBillStatus();
        if (bos != null && bos == BillOperationStatus.ADDNEW) {
            fsp.setStatus(OperationStatus.EDIT);
            bsp.setBillStatus(BillOperationStatus.EDIT);
            fv.cacheFormShowParameter();
        }
        if ((dm = fv.getModel()) == null) {
            return;
        }
        DynamicObject doSave = dm.getDataEntity(true);
        SaveServiceHelper.update((DynamicObject)doSave);
        if (fsp != null && StringUtils.isNotEmpty((CharSequence)(parentPageID = fsp.getParentPageId())) && (fvParent = fv.getViewNoPlugin(parentPageID)) instanceof IListView && (pcParent = fvParent.getPageCache()) != null) {
            pcParent.put("listdatachanged", "1");
        }
        dm.setDataChanged(false);
    }

    public static Object getDataModelValue(IDataModel dmTmp, String key, int rowIndex) {
        if (StringUtils.isEmpty((CharSequence)key)) {
            return null;
        }
        return rowIndex >= 0 ? dmTmp.getValue(key, rowIndex) : dmTmp.getValue(key);
    }

    public static String getDataModelStringValue(IDataModel dmTmp, String key, int rowIndex) {
        Object objValue = SFCUtils.getDataModelValue(dmTmp, key, rowIndex);
        return objValue == null ? null : objValue.toString();
    }

    public static Date getDataModelDateValue(IDataModel dmTmp, String key, int rowIndex) {
        Object objValue = SFCUtils.getDataModelValue(dmTmp, key, rowIndex);
        return objValue instanceof Date ? (Date)objValue : null;
    }

    public static long getDataModelLongValue(IDataModel dmTmp, String key, int rowIndex) {
        Object objValue = SFCUtils.getDataModelValue(dmTmp, key, rowIndex);
        return objValue == null ? 0L : (objValue instanceof Long ? (Long)objValue : (objValue instanceof Integer ? (long)((Integer)objValue).intValue() : 0L));
    }

    public static DynamicObject getDataModelDynamicObjectValue(IDataModel dmTmp, String key, int rowIndex) {
        Object objValue = SFCUtils.getDataModelValue(dmTmp, key, rowIndex);
        return objValue == null ? null : (objValue instanceof DynamicObject ? (DynamicObject)objValue : null);
    }

    public static DynamicObjectCollection getDataModelDynamicObjectCollectionValue(IDataModel dmTmp, String key, int rowIndex) {
        Object objValue = SFCUtils.getDataModelValue(dmTmp, key, rowIndex);
        return objValue == null ? null : (objValue instanceof DynamicObjectCollection ? (DynamicObjectCollection)objValue : null);
    }

    public static String IntTimeToString(int timeInt) {
        int minutes;
        int hours;
        StringBuilder sb = new StringBuilder();
        int minutesSeconds = 60;
        int hourSeconds = 3600;
        int hourRemainder = timeInt % 3600;
        int n = timeInt < 3600 ? 0 : (hours = hourRemainder == 0 ? timeInt / 3600 : (timeInt - hourRemainder) / 3600);
        if (hours < 10) {
            sb.append('0').append(hours);
        } else {
            sb.append(hours);
        }
        sb.append(':');
        int minutesRemainder = hourRemainder % 60;
        int n2 = timeInt < 60 ? 0 : (minutes = minutesRemainder == 0 ? hourRemainder / 60 : (hourRemainder - minutesRemainder) / 60);
        if (minutes < 10) {
            sb.append('0').append(minutes);
        } else {
            sb.append(minutes);
        }
        sb.append(':');
        if (minutesRemainder < 10) {
            sb.append('0').append(minutesRemainder);
        } else {
            sb.append(minutesRemainder);
        }
        return sb.toString();
    }

    public static String DynamicObjectToJSON(DynamicObject doTmp) {
        if (doTmp == null) {
            return null;
        }
        DynamicObjectSerializationBinder dosb = new DynamicObjectSerializationBinder(doTmp.getDynamicObjectType());
        dosb.setOnlyDbProperty(false);
        dosb.setSerializeDefaultValue(true);
        DcJsonSerializer dcjs = new DcJsonSerializer((DcBinder)dosb);
        return dcjs.serializeToString((Object)doTmp, null);
    }

    public static DynamicObject JSONToDynamicObject(String json, String entityName) {
        if (StringUtils.isEmpty((CharSequence)json)) {
            return null;
        }
        MainEntityType met = EntityMetadataCache.getDataEntityType((String)entityName);
        DynamicObject doTmp = (DynamicObject)met.createInstance();
        DynamicObjectSerializationBinder dosb = new DynamicObjectSerializationBinder((DynamicObjectType)met);
        DcJsonSerializer dcjs = new DcJsonSerializer((DcBinder)dosb);
        doTmp = (DynamicObject)dcjs.deserializeFromString(json, (Object)doTmp);
        return doTmp;
    }

    public static FormShowParameter createShowParameter(String formID, ShowType st, OperationStatus os, long id, Map cp, CloseCallBack ccb, IFormView fv) {
        if (StringUtils.isEmpty((CharSequence)formID) || fv == null) {
            return null;
        }
        Object fsp = null;
        MainEntityType met = EntityMetadataCache.getDataEntityType((String)formID);
        fsp = met instanceof BasedataEntityType ? (fv instanceof IMobileListView ? new MobileBillShowParameter() : new BaseShowParameter()) : (met instanceof BillEntityType ? (fv instanceof IMobileListView ? new MobileBillShowParameter() : new BillShowParameter()) : new FormShowParameter());
        fsp.setFormId(formID);
        ShowType stFinal = st;
        if (stFinal == null) {
            if (fv instanceof IMobileListView) {
                stFinal = ShowType.Floating;
            } else if (fv instanceof IListView) {
                if (SFCUtils.checkWindowOfModel((FormShowParameter)fsp)) {
                    stFinal = ShowType.NewBrowserPage;
                } else if (SFCUtils.parentPageIsModel(fv)) {
                    stFinal = ShowType.Modal;
                } else {
                    stFinal = fv.getFormShowParameter().getFormConfig().getShowType();
                    fsp.getOpenStyle().setTargetKey("tabap");
                }
            } else {
                stFinal = ShowType.Modal;
                Object isOpenNewTab = fv.getFormShowParameter().getCustomParam("isOpenNewTab");
                if (isOpenNewTab != null && ((Boolean)isOpenNewTab).booleanValue()) {
                    stFinal = ShowType.MainNewTabPage;
                    fsp.getOpenStyle().setTargetKey("tabap");
                }
            }
        }
        fsp.getOpenStyle().setShowType(stFinal);
        if (id > 0L && fsp instanceof BillShowParameter) {
            ((BillShowParameter)fsp).setPkId((Object)id);
        }
        fsp.setParentFormId(fv.getFormShowParameter().getParentFormId());
        if (os != null) {
            fsp.setStatus(os);
        }
        if (!SFCUtils.isEmptyMap(cp)) {
            fsp.setCustomParams(cp);
        }
        if (ccb == null) {
            List selectedMainOrgIds;
            IListView lv = fv instanceof IListView ? (IListView)fv : null;
            List list = selectedMainOrgIds = lv == null ? null : lv.getSelectedMainOrgIds();
            if (selectedMainOrgIds != null && selectedMainOrgIds.size() == 1) {
                fsp.setCustomParam("SELECT_ORG_ID", (Object)((Long)selectedMainOrgIds.get(0)).toString());
            }
            CloseCallBack closeCallBack = new CloseCallBack("kd.bos.form.operate.New", "listoperation");
            fsp.setCloseCallBack(closeCallBack);
        } else {
            fsp.setCloseCallBack(ccb);
        }
        FormViewPluginProxy fvpp = (FormViewPluginProxy)fv.getService(FormViewPluginProxy.class);
        if (fvpp instanceof ListViewPluginProxy && fsp instanceof BillShowParameter) {
            BeforeShowBillFormEvent bsbfe = new BeforeShowBillFormEvent((Object)fv, (BillShowParameter)fsp);
            ((ListViewPluginProxy)fvpp).fireBeforeShowBill(bsbfe);
            if (bsbfe.isCancel()) {
                return null;
            }
        }
        fsp.setHasRight(true);
        return fsp;
    }

    public static boolean parentPageIsModel(IFormView fv) {
        FormShowParameter fsp;
        boolean isModel = false;
        FormShowParameter formShowParameter = fsp = fv == null ? null : fv.getFormShowParameter();
        while (fsp != null) {
            if (fsp.getOpenStyle().getShowType().compareTo((Enum)ShowType.Modal) == 0) {
                isModel = true;
                break;
            }
            fsp = fsp.getParentPageId() == null ? null : SessionManager.getCurrent().getFormShowParameter(fsp.getParentPageId());
        }
        return isModel;
    }

    public static boolean checkWindowOfModel(FormShowParameter fsp) {
        boolean isOpen;
        if (fsp == null) {
            return false;
        }
        boolean isNewTab = false;
        Object isOpenObj = sps.loadPublicParameterFromCache("newtabwithbrowser");
        boolean bl = isOpen = Objects.nonNull(isOpenObj) && Boolean.parseBoolean(isOpenObj.toString());
        if (isOpen) {
            String appID = fsp.getAppId();
            Map map = (Map)DispatchServiceHelper.invokeBOSService((String)(appID == null ? "bos" : appID), (String)"FormService", (String)"createConfig", (Object[])new Object[]{fsp});
            isNewTab = map != null && (ObjectUtils.isEmpty(map.get("width")) || "100%".equals(map.get("width")));
        }
        return isNewTab;
    }

    public static DynamicObject getUserFullTimeOrg(long userID) {
        DynamicObjectCollection docUser = QueryServiceHelper.query((String)"bos_user", (String)"id,entryentity.dpt,entryentity.ispartjob,entryentity.dpt.name,entryentity.dpt.number,name", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)userID)});
        if (docUser.isEmpty()) {
            return null;
        }
        DynamicObject doFullTimeOrg = null;
        for (DynamicObject doUser : docUser) {
            boolean isPartTime = doUser.getBoolean("entryentity.ispartjob");
            if (isPartTime) continue;
            Object objOrg = doUser.get("entryentity.dpt");
            Long lOrgPK = objOrg instanceof Long ? (Long)objOrg : 0L;
            DynamicObject dynamicObject = doFullTimeOrg = objOrg instanceof DynamicObject ? (DynamicObject)objOrg : null;
            if (doFullTimeOrg == null && lOrgPK > 0L) {
                doFullTimeOrg = BusinessDataServiceHelper.loadSingleFromCache((Object)lOrgPK, (String)"bos_org", (String)"number,name");
            }
            if (doFullTimeOrg == null) continue;
            break;
        }
        return doFullTimeOrg;
    }
}

