/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.sfc.mservice;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import kd.bd.mpdm.business.manuftech.OprUnitHelper;
import kd.bd.mpdm.common.manuftech.utils.SFCCustFormulaFuntions;
import kd.bd.mpdm.common.mftorder.utils.OrderOpUtils;
import kd.bos.data.BusinessDataReader;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.IDataEntityBase;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.runtime.ConvertOperationResult;
import kd.bos.entity.botp.runtime.PushArgs;
import kd.bos.entity.botp.runtime.SourceBillReport;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.extplugin.PluginProxy;
import kd.bos.formula.platform.api.IFormulaFunctions;
import kd.bos.formula.platform.engine.FormulaEngine;
import kd.bos.formula.platform.engine.RunFormulaException;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.botp.ConvertServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.mmc.sfc.common.utils.QueryOrderUtil;
import kd.mmc.sfc.mservice.api.ManuftechAutoPushProcessReportBillService;
import kd.mmc.sfc.mservice.ext.ManuftechAutoPushProgressReportStatusExt;
import kd.mmc.sfc.mservice.ext.impl.ManuftechAutoPushProgressReportStatusExtImpl;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ManuftechAutoPushProcessReportBillServiceImpl
implements ManuftechAutoPushProcessReportBillService {
    private static final Log logger = LogFactory.getLog(ManuftechAutoPushProcessReportBillServiceImpl.class);

    public List<String> autoPushAndSubmit(DynamicObject[] dataArray, Object pkValue, String qualityStatus, BigDecimal qty) {
        ArrayList<String> result = new ArrayList<String>();
        for (int i = 0; i < dataArray.length; ++i) {
            SourceBillReport billReport2;
            DynamicObject obj = dataArray[i];
            obj = BusinessDataServiceHelper.loadSingle((Object)obj.getPkValue(), (String)"sfc_manftech");
            DynamicObjectCollection billentry = obj.getDynamicObjectCollection("oprentryentity");
            PushArgs pushArgs = new PushArgs();
            pushArgs.setSourceEntityNumber("sfc_manftech");
            pushArgs.setTargetEntityNumber("sfc_processreportbill");
            pushArgs.setHasRight(true);
            pushArgs.setAppId("sfc");
            pushArgs.setRuleId("1013129419369576448");
            pushArgs.setBuildConvReport(true);
            int size = billentry.size();
            ArrayList<ListSelectedRow> selectedRows = new ArrayList<ListSelectedRow>(size);
            for (int j = 0; j < size; ++j) {
                ListSelectedRow srcBill = new ListSelectedRow(obj.getPkValue());
                srcBill.setEntryEntityKey("oprentryentity");
                srcBill.setEntryPrimaryKeyValue(((DynamicObject)billentry.get(j)).getPkValue());
                selectedRows.add(srcBill);
                pushArgs.setSelectedRows(selectedRows);
            }
            ConvertOperationResult pushResult = ConvertServiceHelper.push((PushArgs)pushArgs);
            if (!pushResult.isSuccess()) {
                StringBuilder errMessage = new StringBuilder().append(pushResult.getMessage());
                for (SourceBillReport billReport2 : pushResult.getBillReports()) {
                    if (billReport2.isSuccess()) continue;
                    errMessage.append(billReport2.getFailMessage());
                }
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u4e0b\u63a8\u5931\u8d25\uff1a%s", (String)"ManuftechAutoPushProcessReportBillServiceImpl_6", (String)"mmc-sfc-mservice", (Object[])new Object[0]), errMessage));
            }
            MainEntityType targetMainType = EntityMetadataCache.getDataEntityType((String)"sfc_processreportbill");
            List targetBillObjs = pushResult.loadTargetDataObjects(BusinessDataReader::loadRefence, targetMainType);
            billReport2 = targetBillObjs.iterator();
            while (billReport2.hasNext()) {
                DynamicObject dynamicObject = (DynamicObject)billReport2.next();
                DynamicObjectCollection targetBillEntryCol = dynamicObject.getDynamicObjectCollection("sumentry");
                for (DynamicObject targetBillEntry : targetBillEntryCol) {
                    targetBillEntry.set("completqty", (Object)qty);
                    targetBillEntry.set("manuinbillentryid", pkValue);
                    DynamicObjectCollection dynamicObjectCollection = targetBillEntry.getDynamicObjectCollection("repsubentryentity");
                    for (DynamicObject object : dynamicObjectCollection) {
                        Object formula = this.runFormula(object);
                        if (!(formula instanceof BigDecimal)) continue;
                        object.set("repactualqty", formula);
                    }
                    if ("A".equals(qualityStatus) || "B".equals(qualityStatus)) {
                        targetBillEntry.set("qualifyqty", (Object)qty);
                        continue;
                    }
                    if (!"D".equals(qualityStatus)) continue;
                    targetBillEntry.set("qualifyqty", (Object)0);
                    targetBillEntry.set("workwasteqty", (Object)0);
                    targetBillEntry.set("reworkqty", (Object)0);
                    targetBillEntry.set("scrapqty", (Object)qty);
                }
            }
            OperateOption saveOption = this.createOperateOption();
            OperationResult saveResult = SaveServiceHelper.saveOperate((String)"sfc_processreportbill", (DynamicObject[])targetBillObjs.toArray(new DynamicObject[targetBillObjs.size()]), (OperateOption)saveOption);
            if (!saveResult.isSuccess()) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\uff1a%s", (String)"ManuftechAutoPushProcessReportBillServiceImpl_1", (String)"mmc-sfc-mservice", (Object[])new Object[0]), OrderOpUtils.getErrDetail((OperationResult)saveResult)));
            }
            OperationResult submitResult = this.operate("submit", "sfc_processreportbill", saveResult.getSuccessPkIds().toArray());
            if (!submitResult.isSuccess()) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u63d0\u4ea4\u5931\u8d25\uff1a%s", (String)"ManuftechAutoPushProcessReportBillServiceImpl_2", (String)"mmc-sfc-mservice", (Object[])new Object[0]), OrderOpUtils.getErrDetail((OperationResult)submitResult)));
            }
            OperationResult auditResult = this.operate("audit", "sfc_processreportbill", saveResult.getSuccessPkIds().toArray());
            if (auditResult.isSuccess()) continue;
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5ba1\u6838\u5931\u8d25\uff1a%s", (String)"ManuftechAutoPushProcessReportBillServiceImpl_3", (String)"mmc-sfc-mservice", (Object[])new Object[0]), OrderOpUtils.getErrDetail((OperationResult)auditResult)));
        }
        return result;
    }

    private OperationResult operate(String opKey, String entity, Object[] ids) {
        OperateOption operateOption = this.createOperateOption();
        OperationResult result = OperationServiceHelper.executeOperate((String)opKey, (String)entity, (Object[])ids, (OperateOption)operateOption);
        return result;
    }

    private OperateOption createOperateOption() {
        OperateOption operateOption = OperateOption.create();
        operateOption.setVariableValue("ignorewarn", String.valueOf(true));
        operateOption.setVariableValue("ignoreinteraction", String.valueOf(true));
        operateOption.setVariableValue("strictvalidation", String.valueOf(false));
        operateOption.setVariableValue("ishasright", String.valueOf(true));
        operateOption.setVariableValue("ignoreValidation", String.valueOf(true));
        operateOption.setVariableValue("WF", "false");
        return operateOption;
    }

    private Object runFormula(DynamicObject repentry) {
        Object result = null;
        DynamicObject actstandardformula = repentry.getDynamicObject("actstandardformula");
        if (actstandardformula != null) {
            String formulaStr = actstandardformula.getString("formula");
            if (StringUtils.isBlank((CharSequence)formulaStr)) {
                return null;
            }
            HashMap<String, DynamicObject> varValues = new HashMap<String, DynamicObject>();
            DynamicObjectCollection repentrys = new DynamicObjectCollection();
            DynamicObject sumentry = (DynamicObject)OrmUtils.clone((IDataEntityBase)((DynamicObject)repentry.getParent()), (boolean)false, (boolean)true);
            repentrys.add((Object)((DynamicObject)OrmUtils.clone((IDataEntityBase)repentry, (boolean)false, (boolean)true)));
            sumentry.set("repsubentryentity", (Object)repentrys);
            DynamicObject cloneProcessReport = (DynamicObject)OrmUtils.clone((IDataEntityBase)((IDataEntityBase)((DynamicObject)repentry.getParent()).getParent()), (boolean)false, (boolean)true);
            DynamicObjectCollection dynamicObjectCollection = cloneProcessReport.getDynamicObjectCollection("sumentry");
            dynamicObjectCollection.clear();
            dynamicObjectCollection.add((Object)sumentry);
            varValues.put("sfc_processreportbill", cloneProcessReport);
            try {
                FormulaEngine.registerFunctions((IFormulaFunctions)new SFCCustFormulaFuntions());
                result = FormulaEngine.runFormula((String)formulaStr, varValues);
            }
            catch (RunFormulaException exp) {
                logger.error((Object)String.format("\u516c\u5f0f\u8ba1\u7b97\u65f6\u51fa\u73b0\u5f02\u5e38 - \u53c2\u65701 %s  \u53c2\u65702 %s ", formulaStr, ((Object)varValues).toString()), (Throwable)exp);
            }
        }
        return result;
    }

    public void autoPushAndSubmit(List<Map<String, Object>> data) throws KDBizException {
        Set oprEntryIds = data.stream().filter(x -> x.get("oprentryid") != null).map(x -> (Long)x.get("oprentryid")).collect(Collectors.toSet());
        Map manftechByEntryId = QueryOrderUtil.getManftechByEntryId(oprEntryIds);
        ArrayList<DynamicObject> report = new ArrayList<DynamicObject>(10);
        String num = "";
        HashMap<Long, Map<String, Object>> entryMapping = new HashMap<Long, Map<String, Object>>();
        StringJoiner stringJoiner = new StringJoiner("\n");
        for (int i = 0; i < data.size(); ++i) {
            Map<String, Object> map = data.get(i);
            num = String.valueOf(map.get("num"));
            ArrayList<ListSelectedRow> selectedRows = new ArrayList<ListSelectedRow>(10);
            PushArgs pushArgs = new PushArgs();
            pushArgs.setSourceEntityNumber("sfc_manftech");
            pushArgs.setHasRight(true);
            pushArgs.setAppId("sfc");
            if (BigDecimal.ZERO.compareTo((BigDecimal)map.get("baseqty")) >= 0) continue;
            pushArgs.setTargetEntityNumber("sfc_processreportbill");
            pushArgs.setRuleId("961510294473985024");
            ListSelectedRow srcBill = new ListSelectedRow(map.get("techid"));
            srcBill.setEntryEntityKey("oprentryentity");
            srcBill.setEntryPrimaryKeyValue(map.get("oprentryid"));
            selectedRows.add(srcBill);
            pushArgs.setSelectedRows(selectedRows);
            pushArgs.setBuildConvReport(true);
            ConvertOperationResult pushResult = ConvertServiceHelper.push((PushArgs)pushArgs);
            if (!pushResult.isSuccess()) {
                StringBuilder errMessage = new StringBuilder();
                for (SourceBillReport billReport : pushResult.getBillReports()) {
                    if (billReport.isSuccess()) continue;
                    errMessage.append(billReport.getFailMessage());
                }
                stringJoiner.add(String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\u59d4\u5916\u63a5\u6536\u5355\uff08%1$s\uff09\u7b2c%2$s\u884c\u5206\u5f55\u751f\u6210\u5de5\u5e8f\u6c47\u62a5\u5931\u8d25\uff0c%3$s", (String)"ManuftechAutoPushProcessReportBillServiceImpl_5", (String)"mmc-sfc-mservice", (Object[])new Object[0]), map.get("billno"), map.get("seq"), errMessage));
            }
            if (!"sfc_processreportbill".equals(pushArgs.getTargetEntityNumber())) continue;
            MainEntityType targetMainType = EntityMetadataCache.getDataEntityType((String)"sfc_processreportbill");
            List targetBillObjs = pushResult.loadTargetDataObjects(BusinessDataReader::loadRefence, targetMainType);
            for (DynamicObject dynamicObject : targetBillObjs) {
                DynamicObjectCollection targetBillEntryCol = dynamicObject.getDynamicObjectCollection("sumentry");
                for (DynamicObject targetBillEntry : targetBillEntryCol) {
                    BigDecimal baseQty;
                    BigDecimal oprtotalreportbaseqty;
                    HashMap<String, Object> tempt = new HashMap<String, Object>();
                    Map oprEntryMap = (Map)manftechByEntryId.get(targetBillEntry.getLong("oprentryid"));
                    BigDecimal totaloproutorderbaseqty = (BigDecimal)oprEntryMap.get("oprentryentity.totaloproutorderbaseqty");
                    BigDecimal subtract = totaloproutorderbaseqty.subtract(oprtotalreportbaseqty = (BigDecimal)oprEntryMap.get("oprentryentity.oprtotalreportbaseqty"));
                    BigDecimal result = subtract.compareTo(baseQty = (BigDecimal)map.get("baseqty")) > 0 ? baseQty : subtract;
                    targetBillEntry.set("completbaseqty", (Object)result);
                    targetBillEntry.set("qualifybaseqty", (Object)result);
                    targetBillEntry.set("completqty", (Object)OprUnitHelper.getOprQty((Map)oprEntryMap, (BigDecimal)result));
                    targetBillEntry.set("qualifyqty", (Object)OprUnitHelper.getOprQty((Map)oprEntryMap, (BigDecimal)result));
                    targetBillEntry.set("manuinbillentryid", (Object)map.get("entryid").toString());
                    targetBillEntry.set("autosrcbilltype", (Object)"im_mdc_omcmplinbil_opm");
                    targetBillEntry.set("processid", (Object)map.get("billid").toString());
                    targetBillEntry.set("processentryid", (Object)map.get("entryid").toString());
                    tempt.put("billno", map.get("billno"));
                    tempt.put("seq", map.get("seq"));
                    tempt.put("reportbillno", dynamicObject.getString("billno"));
                    entryMapping.put((Long)dynamicObject.getPkValue(), tempt);
                    DynamicObjectCollection dynamicObjectCollection = targetBillEntry.getDynamicObjectCollection("repsubentryentity");
                    for (DynamicObject object : dynamicObjectCollection) {
                        Object formula = this.runFormula(object);
                        if (!(formula instanceof BigDecimal)) continue;
                        logger.info((Object)("\u516c\u5f0f\u8ba1\u7b97\u7684\u7ed3\u679c" + ((BigDecimal)formula).toEngineeringString()));
                        object.set("repactualqty", formula);
                    }
                }
            }
            report.addAll(targetBillObjs);
        }
        ManuftechAutoPushProgressReportStatusExtImpl defaultPlugin = new ManuftechAutoPushProgressReportStatusExtImpl();
        PluginProxy statusExt = PluginProxy.create((Object)defaultPlugin, ManuftechAutoPushProgressReportStatusExt.class, (String)"OPM_MANUFTECH_AUTOPUSHPROGRESSREPORTSTATUS_EXT", null);
        List strings = statusExt.callReplaceIfPresent(p -> p.setStatus());
        AtomicReference<String> status = new AtomicReference<String>("C");
        strings.forEach(t -> status.set((String)t));
        OperationResult operationResult = null;
        if (!report.isEmpty()) {
            operationResult = this.auditReport(status.get(), report, stringJoiner, entryMapping);
        }
        int successNum = operationResult == null ? 0 : operationResult.getSuccessPkIds().size();
        StringBuilder stringBuilder = new StringBuilder();
        if (data.size() == successNum) {
            return;
        }
        if (StringUtils.isNotEmpty((CharSequence)num)) {
            int tempt = Integer.parseInt(num) - successNum;
            stringBuilder.append(String.format(ResManager.loadKDString((String)"\u5171%1$s\u6761\u5355\u636e\uff0c\u6279\u91cf\u751f\u6210\u6c47\u62a5\u5355\u6210\u529f%2$s\u6761\uff0c\u5931\u8d25%3$s\u6761\u3002", (String)"ManuftechAutoPushProcessReportBillServiceImpl_7", (String)"mmc-sfc-mservice", (Object[])new Object[0]), num, successNum, tempt));
            stringBuilder.append("\n");
        }
        if (stringJoiner.length() != 0) {
            stringBuilder.append(stringJoiner);
            throw new KDBizException(stringJoiner.toString());
        }
    }

    private OperationResult auditReport(String s, List<DynamicObject> report, StringJoiner stringJoiner, Map<Long, Map<String, Object>> entryMapping) {
        String errDetail;
        String msg;
        OperateOption saveOption = this.createOperateOption();
        OperationResult operationResult = null;
        if (ObjectUtils.isEmpty(report)) {
            return operationResult;
        }
        if ("A".compareTo(s) <= 0 && !(operationResult = SaveServiceHelper.saveOperate((String)"sfc_processreportbill", (DynamicObject[])report.toArray(new DynamicObject[report.size()]), (OperateOption)saveOption)).isSuccess()) {
            String msg2 = ResManager.loadKDString((String)"\u4fdd\u5b58", (String)"ManuftechAutoPushProcessReportBillServiceImpl_8", (String)"mmc-sfc-mservice", (Object[])new Object[0]);
            String errDetail2 = this.getErrDetail(null, operationResult, entryMapping, msg2);
            stringJoiner.add(errDetail2);
        }
        Map<Long, String> reportMapping = this.createReportMapping(report);
        if ("B".compareTo(s) <= 0) {
            if (operationResult == null || operationResult.getSuccessPkIds().isEmpty()) {
                return operationResult;
            }
            if (!(operationResult = this.operate("submit", "sfc_processreportbill", operationResult.getSuccessPkIds().toArray())).isSuccess()) {
                msg = ResManager.loadKDString((String)"\u63d0\u4ea4", (String)"ManuftechAutoPushProcessReportBillServiceImpl_9", (String)"mmc-sfc-mservice", (Object[])new Object[0]);
                errDetail = this.getErrDetail(reportMapping, operationResult, entryMapping, msg);
                stringJoiner.add(errDetail);
            }
        }
        if ("C".compareTo(s) <= 0) {
            if (operationResult == null || operationResult.getSuccessPkIds().isEmpty()) {
                return operationResult;
            }
            if (!(operationResult = this.operate("audit", "sfc_processreportbill", operationResult.getSuccessPkIds().toArray())).isSuccess()) {
                msg = ResManager.loadKDString((String)"\u5ba1\u6838", (String)"ManuftechAutoPushProcessReportBillServiceImpl_10", (String)"mmc-sfc-mservice", (Object[])new Object[0]);
                errDetail = this.getErrDetail(reportMapping, operationResult, entryMapping, msg);
                stringJoiner.add(errDetail);
            }
        }
        return operationResult;
    }

    private Map<Long, String> createReportMapping(List<DynamicObject> report) {
        HashMap<Long, String> res = new HashMap<Long, String>(16);
        for (DynamicObject dynamicObject : report) {
            Long pkValue = (Long)dynamicObject.getPkValue();
            res.put(pkValue, dynamicObject.getString("billno"));
        }
        return res;
    }

    private String getErrDetail(Map<Long, String> reportMapping, OperationResult optResult, Map<Long, Map<String, Object>> entryMapping, String msg) {
        StringJoiner stringJoiner = new StringJoiner("\n");
        String msg1 = ResManager.loadKDString((String)"\u4fdd\u5b58", (String)"ManuftechAutoPushProcessReportBillServiceImpl_8", (String)"mmc-sfc-mservice", (Object[])new Object[0]);
        String temptMsg = "";
        for (IOperateInfo errInfo : optResult.getAllErrorOrValidateInfo()) {
            Object pkValue = errInfo.getPkValue();
            if (!entryMapping.containsKey(pkValue)) continue;
            Map<String, Object> tempt = entryMapping.get(pkValue);
            if (msg1.equals(msg)) {
                temptMsg = String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\u59d4\u5916\u63a5\u6536\u5355\uff08%1$s\uff09\u7b2c%2$s\u884c\u5206\u5f55\u751f\u6210\u5de5\u5e8f\u6c47\u62a5\u4fdd\u5b58\u5931\u8d25\uff0c%3$s", (String)"ManuftechAutoPushProcessReportBillServiceImpl_11", (String)"mmc-sfc-mservice", (Object[])new Object[0]), tempt.get("billno"), tempt.get("seq"), errInfo.toString());
            } else {
                String s = reportMapping.get(pkValue);
                temptMsg = String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\u59d4\u5916\u63a5\u6536\u5355\uff08%1$s\uff09\u7b2c%2$s\u884c\u5206\u5f55\uff0c%3$s", (String)"ManuftechAutoPushProcessReportBillServiceImpl_12", (String)"mmc-sfc-mservice", (Object[])new Object[0]), tempt.get("billno"), tempt.get("seq"), errInfo.toString());
            }
            stringJoiner.add(temptMsg);
        }
        return stringJoiner.toString();
    }
}

