/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.sfc.mservice;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bd.mpdm.common.manuftech.utils.ManuftechCreateBillUtil;
import kd.bd.mpdm.common.mftorder.entity.OrderManuftechTypeInfo;
import kd.bd.mpdm.common.mftorder.enums.PrecisionAccountEnum;
import kd.bd.mpdm.common.mftorder.utils.OrderOpUtils;
import kd.bd.mpdm.common.utils.AuxQtyAndUnitHelper;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.coderule.api.CodeRuleInfo;
import kd.bos.context.RequestContext;
import kd.bos.data.BusinessDataReader;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.runtime.ConvertOperationResult;
import kd.bos.entity.botp.runtime.PushArgs;
import kd.bos.entity.botp.runtime.SourceBillReport;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.extplugin.PluginProxy;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.UnitConvertHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;
import kd.bos.servicehelper.botp.ConvertMetaServiceHelper;
import kd.bos.servicehelper.botp.ConvertServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.mmc.sfc.common.manuftech.utils.CheckManuOrderUtil;
import kd.mmc.sfc.common.utils.OperationResultUtils;
import kd.mmc.sfc.common.utils.QueryOrderUtil;
import kd.mmc.sfc.mservice.api.MftOrderTechnicsCreateBillService;
import kd.mmc.sfc.mservice.ext.MftInBillAuditAutoPushPurOrderSelectPropertiesExt;
import kd.mmc.sfc.mservice.ext.impl.MftInBillAuditAutoPushPurOrderSelectPropertiesExtImpl;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MftOrderTechnicsCreateBillServiceImpl
implements MftOrderTechnicsCreateBillService {
    private static final Log logger = LogFactory.getLog(MftOrderTechnicsCreateBillServiceImpl.class);
    private static final String CHECK_TASK_STATUS = "checkTaskStatus";
    private static final String CHECK_BIZ_STATUS = "checkBizStatus";

    private void createMftOrderTechnicsBill(DynamicObject orderObj, List<DynamicObject> data, List<DynamicObject> delete, DynamicObject[] load, Map<String, CodeRuleInfo> codeRuleInfoMap) {
        OperationResult deleteResult;
        List<Object> collect;
        ArrayList<DynamicObject> updateList = new ArrayList<DynamicObject>(10);
        ArrayList<DynamicObject> saveList = new ArrayList<DynamicObject>(10);
        ArrayList<Object> deleteList = new ArrayList<Object>(10);
        ArrayList<DynamicObject> unSubmitList = new ArrayList<DynamicObject>(10);
        ArrayList<DynamicObject> unAuditList = new ArrayList<DynamicObject>(10);
        String manuftechType = new OrderManuftechTypeInfo(orderObj.getDataEntityType().getName()).getTarname();
        HashMap<Object, DynamicObject> cardDynamicObjectMap = new HashMap(256);
        if ("sfc_mromanuftech".equals(manuftechType)) {
            Set cardIds = data.stream().filter(x -> x.getDynamicObject("workcard") != null).map(x -> x.getDynamicObject("workcard").getLong("id")).collect(Collectors.toSet());
            cardDynamicObjectMap = BusinessDataServiceHelper.loadFromCache((String)"mpdm_mrocardroute", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)cardIds)});
        }
        for (DynamicObject orderEntryObj : data) {
            for (int i = 0; i < load.length; ++i) {
                Object pkValue;
                DynamicObject manftech = load[i];
                Object object = pkValue = manftech == null || manftech.getDynamicObject("mftentryseq") == null ? null : manftech.getDynamicObject("mftentryseq").getPkValue();
                if (manftech != null && orderEntryObj != null && Objects.equals(orderEntryObj.getPkValue(), pkValue)) {
                    Boolean mroflag = Boolean.FALSE;
                    Boolean flag = Boolean.FALSE;
                    if ("sfc_mromanuftech".equals(manuftechType)) {
                        DynamicObject orderWorkcard = orderEntryObj.getDynamicObject("workcard");
                        DynamicObject manftechWorkcard = manftech.getDynamicObject("workcard");
                        if (orderWorkcard != null && manftechWorkcard != null && orderWorkcard.getPkValue().equals(manftechWorkcard.getPkValue()) || orderWorkcard == null && manftechWorkcard == null) {
                            mroflag = Boolean.TRUE;
                        }
                    } else {
                        DynamicObject mftProcessroute = orderEntryObj.getDynamicObject("processroute");
                        DynamicObject manftechProcessroute = manftech.getDynamicObject("processroute");
                        if (mftProcessroute != null && manftechProcessroute != null && mftProcessroute.getPkValue().equals(manftechProcessroute.getPkValue()) || mftProcessroute == null && manftechProcessroute == null) {
                            flag = Boolean.TRUE;
                        }
                    }
                    if (flag.booleanValue() || mroflag.booleanValue()) {
                        this.updateMftFetch(manftech, orderEntryObj, cardDynamicObjectMap, manuftechType);
                        updateList.add(manftech);
                        continue;
                    }
                    if ("A".equals(manftech.getString("billstatus"))) {
                        deleteList.add(manftech);
                    } else if ("B".equals(manftech.getString("billstatus"))) {
                        unSubmitList.add(manftech);
                    } else if ("C".equals(manftech.getString("billstatus"))) {
                        unAuditList.add(manftech);
                    }
                    saveList.add(orderEntryObj);
                    continue;
                }
                saveList.add(orderEntryObj);
            }
            if (load.length != 0) continue;
            saveList.add(orderEntryObj);
        }
        deleteList.addAll(delete);
        if (CollectionUtils.isNotEmpty(unAuditList)) {
            collect = unAuditList.stream().map(DataEntityBase::getPkValue).collect(Collectors.toList());
            OperationResult unaudit = this.operate("unaudit", manuftechType, collect.toArray(new Object[collect.size()]));
            if (!unaudit.isSuccess()) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u53cd\u5ba1\u6838\u5931\u8d25\uff1a%s", (String)"MftOrderTechnicsCreateBillServiceImpl_21", (String)"mmc-sfc-mservice", (Object[])new Object[0]), OrderOpUtils.getErrDetail((OperationResult)unaudit)));
            }
            deleteList.addAll(unAuditList);
        }
        if (CollectionUtils.isNotEmpty(unSubmitList)) {
            collect = unSubmitList.stream().map(DataEntityBase::getPkValue).collect(Collectors.toList());
            OperationResult unsubmit = this.operate("unsubmit", manuftechType, collect.toArray(new Object[collect.size()]));
            if (!unsubmit.isSuccess()) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u64a4\u9500\u5931\u8d25\uff1a%s", (String)"MftOrderTechnicsCreateBillServiceImpl_22", (String)"mmc-sfc-mservice", (Object[])new Object[0]), OrderOpUtils.getErrDetail((OperationResult)unsubmit)));
            }
            deleteList.addAll(unSubmitList);
        }
        if (CollectionUtils.isNotEmpty(deleteList) && !(deleteResult = this.operate("delete", manuftechType, (collect = deleteList.stream().map(DataEntityBase::getPkValue).collect(Collectors.toList())).toArray(new Object[collect.size()]))).isSuccess()) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5220\u9664\u5931\u8d25\uff1a%s", (String)"MftOrderTechnicsCreateBillServiceImpl_23", (String)"mmc-sfc-mservice", (Object[])new Object[0]), OrderOpUtils.getErrDetail((OperationResult)deleteResult)));
        }
        if (CollectionUtils.isNotEmpty(updateList)) {
            SaveServiceHelper.save((DynamicObject[])updateList.toArray(new DynamicObject[updateList.size()]));
        }
        List objects = updateList.stream().map(n -> n.getDynamicObject("mftentryseq").getPkValue()).collect(Collectors.toList());
        List<DynamicObject> collect2 = saveList.stream().filter(p -> !objects.contains(p.getPkValue())).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(collect2)) {
            OperationResult saveResult;
            List<DynamicObject> list = this.autoPush(orderObj, collect2, codeRuleInfoMap);
            logger.info((Object)("\u4e0b\u63a8\u751f\u6210\u5de5\u5e8f\u8ba1\u5212\u7684\u6761\u6570" + list.size()));
            if (CollectionUtils.isNotEmpty(list) && !(saveResult = this.operate("save", manuftechType, list.toArray(new DynamicObject[list.size()]))).isSuccess()) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\uff1a%s", (String)"MftOrderTechnicsCreateBillServiceImpl_0", (String)"mmc-sfc-mservice", (Object[])new Object[0]), OrderOpUtils.getErrDetail((OperationResult)saveResult)));
            }
        }
    }

    private void createCardOprEntryData(DynamicObject orderTechnicsObj, DynamicObject orderEntryObj, Map<Object, DynamicObject> workcarddetailMap) {
        DynamicObject workcarddetail = workcarddetailMap.get(orderTechnicsObj.getDynamicObject("workcard").getPkValue());
        if (null != workcarddetail) {
            for (int i = 0; i < workcarddetail.getDynamicObjectCollection("processentry").size(); ++i) {
                DynamicObject entryObj = (DynamicObject)workcarddetail.getDynamicObjectCollection("processentry").get(i);
                if (!orderEntryObj.getString("pageseq").equals(entryObj.getString("pageseq1"))) continue;
                DynamicObject newEntryObj = orderTechnicsObj.getDynamicObjectCollection("oprentryentity").addNew();
                ManuftechCreateBillUtil.setCardOprEntryEntityValue((DynamicObject)orderTechnicsObj, (DynamicObject)entryObj, (DynamicObject)orderEntryObj, (DynamicObject)newEntryObj);
                newEntryObj.set("oprproductionqty", (Object)orderTechnicsObj.getBigDecimal("qty"));
                newEntryObj.set("oprworkhourunit", workcarddetail.get("workunit"));
                newEntryObj.set("seq", (Object)(i + 1));
                ManuftechCreateBillUtil.setActSubEntryEntityValue((DynamicObject)entryObj, (DynamicObject)orderEntryObj, (DynamicObject)newEntryObj, (String)"sfc_mromanuftech");
            }
            orderTechnicsObj.getDynamicObjectCollection("groentryentity").removeAll((Collection)orderTechnicsObj.getDynamicObjectCollection("groentryentity"));
            ManuftechCreateBillUtil.setGroEntryEntityValue((DynamicObject)orderTechnicsObj, (Date)new Date(), (long)RequestContext.get().getCurrUserId());
        }
    }

    public ErrorCode createMftOrderTechnicsBill(DynamicObject[] orders, String operation) {
        String manuftechType = "sfc_manftech";
        if (orders.length > 0) {
            manuftechType = new OrderManuftechTypeInfo(orders[0].getDataEntityType().getName()).getTarname();
        }
        ErrorCode ec = null;
        long startTime = System.currentTimeMillis();
        Set orderIds = Arrays.stream(orders).map(x -> x.getString("id")).collect(Collectors.toSet());
        DynamicObject[] load = null;
        HashMap<String, CodeRuleInfo> codeRuleInfoMap = new HashMap(16);
        if ("audit".equals(operation)) {
            load = BusinessDataServiceHelper.load((String)manuftechType, (String)QueryOrderUtil.selectProperties((String)manuftechType), (QFilter[])new QFilter[]{new QFilter("manufactureorderid", "in", orderIds)});
            codeRuleInfoMap = this.getCodeRuleInfo(orders, manuftechType);
        }
        for (int i = 0; i < orders.length; ++i) {
            DynamicObject orderObj = orders[i];
            if ("audit".equals(operation)) {
                if (orderObj.getDynamicObject("transactiontype") != null && !orderObj.getDynamicObject("transactiontype").getBoolean("isprocedure")) {
                    logger.info((Object)(orderObj.getString("billno") + ":\u751f\u4ea7\u5de5\u5355\u7684\u751f\u4ea7\u4e8b\u52a1\u7c7b\u578b\u6ca1\u6709\u542f\u7528\u5de5\u5e8f\u7ba1\u7406\uff0c\u4e0d\u751f\u6210\u5de5\u5e8f\u8ba1\u5212------------------------"));
                    return new ErrorCode("MftOrderTechnicsCreateBillUtil.createMftOrderTechnicsBill", String.format(ResManager.loadKDString((String)"%s\uff1a\u751f\u4ea7\u5de5\u5355\u7684\u751f\u4ea7\u4e8b\u52a1\u7c7b\u578b\u6ca1\u6709\u542f\u7528\u5de5\u5e8f\u7ba1\u7406\uff0c\u4e0d\u751f\u6210\u5de5\u5e8f\u8ba1\u5212------------------------", (String)"MftOrderTechnicsCreateBillServiceImpl_24", (String)"mmc-sfc-mservice", (Object[])new Object[0]), orderObj.getString("billno")));
                }
                DynamicObjectCollection orderEntrysCol = orderObj.getDynamicObjectCollection("treeentryentity");
                if (orderEntrysCol == null || orderEntrysCol.size() == 0) {
                    logger.info((Object)(orderObj.getString("billno") + ":\u751f\u4ea7\u5de5\u5355\u6ca1\u6709\u5206\u5f55\uff0c\u4e0d\u751f\u6210\u5de5\u5e8f\u8ba1\u5212------------------------"));
                    return new ErrorCode("MftOrderTechnicsCreateBillUtil.createMftOrderTechnicsBill", String.format(ResManager.loadKDString((String)"%s\uff1a\u751f\u4ea7\u5de5\u5355\u6ca1\u6709\u5206\u5f55\uff0c\u4e0d\u751f\u6210\u5de5\u5e8f\u8ba1\u5212------------------------", (String)"MftOrderTechnicsCreateBillServiceImpl_25", (String)"mmc-sfc-mservice", (Object[])new Object[0]), orderObj.getString("billno")));
                }
                List<DynamicObject> list = this.readDelOrderEntryIds(orderObj, orderObj.getDynamicObjectCollection("treeentryentity"), load);
                ArrayList data = new ArrayList();
                for (int j = 0; j < orderEntrysCol.size(); ++j) {
                    DynamicObject entryObj = (DynamicObject)orderEntrysCol.get(j);
                    if (!"C".equals(entryObj.getString("producttype"))) continue;
                    data.add(entryObj);
                }
                if (data.size() == 0) {
                    logger.info((Object)(orderObj.getString("billno") + ":\u4e0d\u5b58\u5728\u5f55\u5165\u4e86\u5de5\u827a\u8def\u7ebf\u7684\u5206\u5f55------------------------"));
                    logger.info((Object)(orderObj.getString("billno") + ":\u751f\u6210\u5de5\u5e8f\u8ba1\u5212\u5b8c\u6210-----------------------"));
                    return new ErrorCode("MftOrderTechnicsCreateBillUtil.createMftOrderTechnicsBill", String.format(ResManager.loadKDString((String)"%s\uff1a\u751f\u6210\u5de5\u5e8f\u8ba1\u5212\u5b8c\u6210-----------------------", (String)"MftOrderTechnicsCreateBillServiceImpl_26", (String)"mmc-sfc-mservice", (Object[])new Object[0]), orderObj.getString("billno")));
                }
                this.createMftOrderTechnicsBill(orderObj, data, list, load, codeRuleInfoMap);
                continue;
            }
            if (!"delete".equals(operation)) continue;
            DynamicObjectCollection orderentrys = orderObj.getDynamicObjectCollection("treeentryentity");
            ArrayList<Object> ids = new ArrayList<Object>();
            for (DynamicObject orderentry : orderentrys) {
                ids.add(orderentry.getPkValue());
            }
            QFilter filter = new QFilter("mftentryseq", "in", ids);
            QFilter filter1 = new QFilter("billstatus", "=", (Object)"C");
            boolean isExist = QueryServiceHelper.exists((String)manuftechType, (QFilter[])new QFilter[]{filter, filter1});
            if (isExist) {
                ec = new ErrorCode("billstatus", String.format(ResManager.loadKDString((String)"\u751f\u4ea7\u5de5\u5355\uff08%s\uff09\u4e0b\u6e38\u5b58\u5728\u5df2\u5ba1\u6838\u7684\u5de5\u5e8f\u8ba1\u5212\u3002", (String)"MftOrderTechnicsCreateBillServiceImpl_11", (String)"mmc-sfc-mservice", (Object[])new Object[0]), orderObj.getString("billno")));
                continue;
            }
            this.deleteMftOrderTechnicsBill(orderObj);
            logger.info((Object)(orderObj.getString("billno") + ":\u5de5\u5355\u5bf9\u5e94\u5de5\u5e8f\u8ba1\u5212\u5220\u9664\u5b8c\u6210------------------------"));
        }
        long endTime = System.currentTimeMillis() - startTime;
        logger.info((Object)("\u751f\u6210\u5de5\u5e8f\u8ba1\u5212\u5b8c\u6210------------------------\u82b1\u8d39\u65f6\u95f4:" + endTime));
        return ec;
    }

    private List<DynamicObject> autoPush(DynamicObject data, List<DynamicObject> entrys, Map<String, CodeRuleInfo> codeRuleInfoMap) {
        String manuftechType = new OrderManuftechTypeInfo(data.getDataEntityType().getName()).getTarname();
        PushArgs pushArgs = new PushArgs();
        pushArgs.setSourceEntityNumber("pom_mftorder");
        pushArgs.setTargetEntityNumber("sfc_manftech");
        pushArgs.setHasRight(true);
        pushArgs.setAppId("sfc");
        pushArgs.setRuleId("1194189216398234624");
        pushArgs.setBuildConvReport(true);
        if ("sfc_mromanuftech".equals(manuftechType)) {
            pushArgs.setTargetEntityNumber("sfc_mromanuftech");
            String sourceEntityNumber = data.getDataEntityType().getName();
            Object ruleid = "1384081348129703936";
            if ("pom_mrosupportcrad".equals(sourceEntityNumber) || "pom_mrosupplementarywork".equals(sourceEntityNumber) || "pom_mropartcard".equals(sourceEntityNumber) || "pom_mronrc".equals(sourceEntityNumber)) {
                ruleid = "1434774074868921344";
            }
            pushArgs.setSourceEntityNumber("pom_mroorder");
            pushArgs.setRuleId((String)ruleid);
        }
        ArrayList<Object> selectedRows = new ArrayList<Object>(entrys.size());
        for (DynamicObject entry : entrys) {
            ListSelectedRow srcBill = new ListSelectedRow(data.getPkValue());
            srcBill.setEntryEntityKey("treeentryentity");
            srcBill.setEntryPrimaryKeyValue(entry.getPkValue());
            selectedRows.add(srcBill);
        }
        pushArgs.setSelectedRows(selectedRows);
        ConvertOperationResult pushResult = ConvertServiceHelper.push((PushArgs)pushArgs);
        if (!pushResult.isSuccess()) {
            StringBuilder errMessage = new StringBuilder();
            for (SourceBillReport billReport : pushResult.getBillReports()) {
                if (billReport.isSuccess()) continue;
                errMessage.append(billReport.getFailMessage());
                if (!ResManager.loadKDString((String)"\u65e0\u5339\u914d\u89c4\u5219", (String)"MftOrderTechnicsCreateBillServiceImpl_9", (String)"mmc-sfc-mservice", (Object[])new Object[0]).equals(billReport.getFailMessage())) continue;
                errMessage.append(ResManager.loadKDString((String)"\u6216\u539f\u59cb\u8f6c\u6362\u89c4\u5219\u88ab\u7981\u7528", (String)"MftOrderTechnicsCreateBillServiceImpl_10", (String)"mmc-sfc-mservice", (Object[])new Object[0]));
            }
            if (errMessage.length() < 1) {
                errMessage.append(pushResult.getMessage());
            }
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u4e0b\u63a8\u5931\u8d25\uff1a%s", (String)"MftOrderTechnicsCreateBillServiceImpl_5", (String)"mmc-sfc-mservice", (Object[])new Object[0]), errMessage));
        }
        MainEntityType targetMainType = EntityMetadataCache.getDataEntityType((String)manuftechType);
        List targetBillObjs = pushResult.loadTargetDataObjects(BusinessDataReader::loadRefence, targetMainType);
        DynamicObject org = data.getDynamicObject("org");
        CodeRuleInfo codeRuleInfo = codeRuleInfoMap.get(org.getPkValue().toString());
        List numbers = new ArrayList(10);
        if (codeRuleInfo != null) {
            numbers = CodeRuleServiceHelper.getNumbers((String)manuftechType, (List)targetBillObjs);
        }
        for (int i = 0; i < targetBillObjs.size(); ++i) {
            Object orderEntryId = ((DynamicObject)targetBillObjs.get(i)).getDynamicObject("mftentryseq").getPkValue();
            if (!StringUtils.isBlank((CharSequence)((DynamicObject)targetBillObjs.get(i)).getString("billno"))) continue;
            if (codeRuleInfo == null) {
                ((DynamicObject)targetBillObjs.get(i)).set("billno", (Object)("mt_" + orderEntryId));
                continue;
            }
            ((DynamicObject)targetBillObjs.get(i)).set("billno", numbers.get(i));
        }
        return targetBillObjs;
    }

    private OperationResult operate(String opKey, String manuftechType, DynamicObject[] dataEntities) {
        OperateOption operateOption = this.createOperateOption(manuftechType);
        OperationResult result = OperationServiceHelper.executeOperate((String)opKey, (String)manuftechType, (DynamicObject[])dataEntities, (OperateOption)operateOption);
        return result;
    }

    private OperationResult operate(String opKey, String manuftechType, Object[] ids) {
        OperateOption operateOption = this.createOperateOption(manuftechType);
        OperationResult result = OperationServiceHelper.executeOperate((String)opKey, (String)manuftechType, (Object[])ids, (OperateOption)operateOption);
        return result;
    }

    private OperateOption createOperateOption(String manuftechType) {
        OperateOption operateOption = OperationResultUtils.createOperateOption();
        if (manuftechType.equals("sfc_mromanuftech")) {
            operateOption.setVariableValue("orderBillType", "pom_mroorder");
            operateOption.setVariableValue("stockBillType", "pom_mrostock");
        } else {
            operateOption.setVariableValue("orderBillType", "pom_mftorder");
            operateOption.setVariableValue("stockBillType", "pom_mftstock");
        }
        return operateOption;
    }

    public List<String> updateMftOrderTechnicsBill(DynamicObject orderObj, DynamicObject orderEntryObj) {
        this.clearMftOrderTechnicsBill(orderObj);
        HashSet status = Sets.newHashSet((Object[])new String[]{"A", "B", "C", "D"});
        ArrayList<String> result = new ArrayList<String>();
        QFilter filter = new QFilter("mftentryseq", "=", orderEntryObj.getPkValue());
        DynamicObject manftech = BusinessDataServiceHelper.loadSingle((String)"sfc_manftech", (String)QueryOrderUtil.selectProperties((String)"sfc_manftech"), (QFilter[])new QFilter[]{filter});
        if (manftech != null) {
            DynamicObjectCollection col = manftech.getDynamicObjectCollection("oprentryentity");
            manftech.set("qty", (Object)orderEntryObj.getBigDecimal("qty"));
            manftech.set("baseqty", (Object)orderEntryObj.getBigDecimal("baseqty"));
            manftech.set("planstarttime", orderEntryObj.get("planbegintime"));
            manftech.set("planfinishtime", orderEntryObj.get("planendtime"));
            for (int j = 0; j < col.size(); ++j) {
                BigDecimal bigDecimal = orderEntryObj.getBigDecimal("qty");
                DynamicObject srcObj = (DynamicObject)col.get(j);
                srcObj.set("oprproductionqty", (Object)bigDecimal);
                ManuftechCreateBillUtil.recalculateEntryQty((DynamicObject)srcObj, (DynamicObject)orderEntryObj);
                DynamicObjectCollection collection = srcObj.getDynamicObjectCollection("actsubentryentity");
                if (srcObj.getBoolean("oprinvalid") || StringUtils.equals((CharSequence)"F", (CharSequence)srcObj.getString("oprstatus")) || StringUtils.equals((CharSequence)"G", (CharSequence)srcObj.getString("oprstatus"))) continue;
                if (status.contains(srcObj.getString("oprstatus"))) {
                    srcObj.set("oprplanbegintime", orderEntryObj.get("planbegintime"));
                    srcObj.set("oprearliestbegintime", orderEntryObj.get("planbegintime"));
                    srcObj.set("oprlatestbegintime", orderEntryObj.get("planbegintime"));
                    for (DynamicObject object : collection) {
                        object.set("actplanbegintime", orderEntryObj.get("planbegintime"));
                    }
                }
                srcObj.set("oprplanfinishtime", orderEntryObj.get("planendtime"));
                srcObj.set("oprearliestfinishtime", orderEntryObj.get("planendtime"));
                srcObj.set("oprlatestfinishtime", orderEntryObj.get("planendtime"));
                for (DynamicObject object : collection) {
                    object.set("actplanfinishtime", orderEntryObj.get("planendtime"));
                }
            }
            DynamicObjectCollection proentryentity = manftech.getDynamicObjectCollection("proentryentity");
            for (int j = 0; j < proentryentity.size(); ++j) {
                this.updateProentry(manftech, proentryentity, j);
            }
            SaveServiceHelper.update((DynamicObject)manftech);
        }
        return result;
    }

    private void deleteMftOrderTechnicsBill(DynamicObject orderObj) {
        String manuftechType = new OrderManuftechTypeInfo(orderObj.getDataEntityType().getName()).getTarname();
        DynamicObjectCollection orderentrys = orderObj.getDynamicObjectCollection("treeentryentity");
        ArrayList<Object> ids = new ArrayList<Object>();
        for (DynamicObject orderentry : orderentrys) {
            ids.add(orderentry.getPkValue());
        }
        QFilter filter = new QFilter("mftentryseq", "in", ids);
        QFilter filter1 = new QFilter("billstatus", "!=", (Object)"C");
        DeleteServiceHelper.delete((String)manuftechType, (QFilter[])new QFilter[]{filter, filter1});
    }

    private void clearMftOrderTechnicsBill(DynamicObject orderObj) {
        DynamicObjectCollection mftEntrys = orderObj.getDynamicObjectCollection("treeentryentity");
        ArrayList<Object> mftEntrysid = new ArrayList<Object>(mftEntrys.size());
        for (DynamicObject dynamicObject : mftEntrys) {
            mftEntrysid.add(dynamicObject.getPkValue());
        }
        DynamicObjectCollection orderentrys = orderObj.getDynamicObjectCollection("treeentryentity");
        ArrayList<Object> ids = new ArrayList<Object>();
        for (DynamicObject orderentry : orderentrys) {
            ids.add(orderentry.getPkValue());
        }
        QFilter filter = new QFilter("mftentryseq", "in", ids);
        QFilter filter1 = new QFilter("billstatus", "!=", (Object)"C");
        QFilter filter2 = new QFilter("mftentryseq", "not in", mftEntrysid);
        DeleteServiceHelper.delete((String)"sfc_manftech", (QFilter[])new QFilter[]{filter, filter1, filter2});
    }

    private List<DynamicObject> readDelOrderEntryIds(DynamicObject order, DynamicObjectCollection orderEntrys, DynamicObject[] load) {
        HashSet<Object> existsOrderEntryIds = new HashSet<Object>(16);
        for (DynamicObject orderEntry : orderEntrys) {
            existsOrderEntryIds.add(orderEntry.getPkValue());
        }
        ArrayList<DynamicObject> deleteList = new ArrayList<DynamicObject>(load.length);
        for (int i = 0; i < load.length; ++i) {
            DynamicObject stockEntry = load[i];
            if (!stockEntry.getString("manufactureorderid").equals(order.getPkValue().toString())) continue;
            if (stockEntry.getDynamicObject("mftentryseq") == null) {
                deleteList.add(stockEntry);
                continue;
            }
            Long orderEntityId = stockEntry.getDynamicObject("mftentryseq").getLong("id");
            if (existsOrderEntryIds.contains(orderEntityId) || "C".equals(stockEntry.getString("billstatus"))) continue;
            deleteList.add(stockEntry);
        }
        return deleteList;
    }

    private void updateProentry(DynamicObject manftech, DynamicObjectCollection proentryentity, int j) {
        DynamicObject srcObj = (DynamicObject)proentryentity.get(j);
        DynamicObjectCollection oprentryentity = manftech.getDynamicObjectCollection("oprentryentity");
        BigDecimal qty = BigDecimal.ZERO;
        Date begintime = null;
        Date endtime = null;
        for (DynamicObject obj : oprentryentity) {
            if (!srcObj.getString("processseq").equals(obj.getString("oprparent"))) continue;
            if (qty.compareTo(obj.getBigDecimal("oprqty")) < 0) {
                qty = obj.getBigDecimal("oprqty");
            }
            if (begintime == null || begintime.compareTo(obj.getDate("oprplanbegintime")) > 0) {
                begintime = obj.getDate("oprplanbegintime");
            }
            if (endtime != null && endtime.compareTo(obj.getDate("oprplanfinishtime")) >= 0) continue;
            endtime = obj.getDate("oprplanfinishtime");
        }
        srcObj.set("processseqqty", (Object)qty);
        srcObj.set("processplanbegintime", begintime);
        srcObj.set("processplanendtime", endtime);
    }

    public List<String> checkMftOrderTechnicsBill(DynamicObject orderObj) {
        DynamicObject[] manftechs;
        ArrayList<String> errors = new ArrayList<String>();
        HashSet status = Sets.newHashSet((Object[])new String[]{"A", "B", "C", "D", "E"});
        DynamicObjectCollection dynamicObjects = orderObj.getDynamicObjectCollection("treeentryentity");
        ArrayList<Object> entryPk = new ArrayList<Object>(dynamicObjects.size());
        for (DynamicObject obj : dynamicObjects) {
            entryPk.add(obj.getPkValue());
        }
        QFilter filter = new QFilter("mftentryseq", "in", entryPk);
        for (DynamicObject manftech : manftechs = BusinessDataServiceHelper.load((String)"sfc_manftech", (String)QueryOrderUtil.selectProperties((String)"sfc_manftech"), (QFilter[])new QFilter[]{filter})) {
            DynamicObjectCollection oprentrys = manftech.getDynamicObjectCollection("oprentryentity");
            for (DynamicObject oprentry : oprentrys) {
                if (status.contains(oprentry.getString("oprstatus")) && !oprentry.getBoolean("oprinvalid")) continue;
                if (oprentry.getBoolean("oprinvalid")) {
                    errors.add(String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\u5df2\u4f5c\u5e9f\uff0c\u66f4\u65b0\u5931\u8d25\uff08\u5de5\u5e8f\u8ba1\u5212\uff1a%1$s\uff1b\u5de5\u5e8f\u5e8f\u5217\uff1a%2$s\uff1b\u5de5\u5e8f\u53f7\uff1a%3$s\uff09\u3002", (String)"MftOrderTechnicsCreateBillServiceImpl_27", (String)"mmc-sfc-mservice", (Object[])new Object[0]), manftech.getString("billno"), oprentry.getString("oprparent"), oprentry.getString("oprno")));
                    continue;
                }
                if ("F".equals(oprentry.getString("oprstatus"))) {
                    errors.add(String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\u72b6\u6001\u4e3a\u201c\u5b8c\u5de5\u201d\uff0c\u66f4\u65b0\u5931\u8d25\uff08\u5de5\u5e8f\u8ba1\u5212\uff1a%1$s\uff1b\u5de5\u5e8f\u5e8f\u5217\uff1a%2$s\uff1b\u5de5\u5e8f\u53f7\uff1a%3$s\uff09\u3002", (String)"MftOrderTechnicsCreateBillServiceImpl_28", (String)"mmc-sfc-mservice", (Object[])new Object[0]), manftech.getString("billno"), oprentry.getString("oprparent"), oprentry.getString("oprno")));
                    continue;
                }
                if (!"G".equals(oprentry.getString("oprstatus"))) continue;
                errors.add(String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\u72b6\u6001\u4e3a\u201c\u5173\u95ed\u201d\uff0c\u66f4\u65b0\u5931\u8d25\uff08\u5de5\u5e8f\u8ba1\u5212\uff1a%1$s\uff1b\u5de5\u5e8f\u5e8f\u5217\uff1a%2$s\uff1b\u5de5\u5e8f\u53f7\uff1a%3$s\uff09\u3002", (String)"MftOrderTechnicsCreateBillServiceImpl_29", (String)"mmc-sfc-mservice", (Object[])new Object[0]), manftech.getString("billno"), oprentry.getString("oprparent"), oprentry.getString("oprno")));
            }
            if (errors.size() == oprentrys.size()) continue;
            errors = new ArrayList();
        }
        return errors;
    }

    public String checkManftechBill(DynamicObject obj) {
        boolean isExist;
        QFilter filter1;
        String error = null;
        DynamicObjectCollection orderentrys = obj.getDynamicObjectCollection("treeentryentity");
        List ids = orderentrys.stream().map(DataEntityBase::getPkValue).collect(Collectors.toList());
        QFilter filter = new QFilter("mftentryseq", "in", ids);
        DynamicObject[] manuftechs = BusinessDataServiceHelper.load((String)"sfc_manftech", (String)"id", (QFilter[])new QFilter[]{filter, filter1 = new QFilter("billstatus", "=", (Object)"C")});
        if ((manuftechs == null || manuftechs.length <= 0 || !obj.getDynamicObject("transactiontype").getBoolean("isaudittechnis")) && (isExist = ORM.create().exists("sfc_manftech", new QFilter[]{filter, filter1}))) {
            error = String.format(ResManager.loadKDString((String)"\u751f\u4ea7\u5de5\u5355\uff08%s\uff09\u4e0b\u6e38\u5b58\u5728\u5df2\u5ba1\u6838\u7684\u5de5\u5e8f\u8ba1\u5212\u3002", (String)"MftOrderTechnicsCreateBillServiceImpl_11", (String)"mmc-sfc-mservice", (Object[])new Object[0]), obj.getString("billno"));
        }
        return error;
    }

    public void audittechnis(QFilter technisqfilter) {
        if (technisqfilter == null) {
            return;
        }
        String manftechName = "sfc_manftech";
        HashSet<Object> poIds = new HashSet<Object>(16);
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"MftOrderTechnicsCreateBillUtil.audittechnis", (String)manftechName, (String)"id", (QFilter[])new QFilter[]{technisqfilter}, (String)"");){
            while (ds.hasNext()) {
                Row row = ds.next();
                Object poid = row.get("id");
                poIds.add(poid);
            }
        }
        if (poIds.isEmpty()) {
            return;
        }
        OperateOption operateOption = OperateOption.create();
        operateOption.setVariableValue("ishasright", "true");
        operateOption.setVariableValue("ignorewarn", "true");
        operateOption.setVariableValue("ignoreinteraction", "true");
        OperationResult submit = OperationServiceHelper.executeOperate((String)"submit", (String)manftechName, (Object[])poIds.toArray(), (OperateOption)operateOption);
        OperationResult audit = OperationServiceHelper.executeOperate((String)"audit", (String)manftechName, (Object[])poIds.toArray(), (OperateOption)operateOption);
    }

    public List<String> autoDoRelease(DynamicObject technicsBill) {
        DynamicObjectCollection entryCol = technicsBill.getDynamicObjectCollection("oprentryentity");
        ArrayList<String> errors = new ArrayList<String>();
        if (!"C".equals(technicsBill.getString("billstatus"))) {
            errors.add(String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\u8ba1\u5212\uff08%s\uff09\u672a\u5ba1\u6838\u3002", (String)"MftOrderTechnicsCreateBillServiceImpl_13", (String)"mmc-sfc-mservice", (Object[])new Object[0]), technicsBill.get("billno")));
            return errors;
        }
        boolean isPush = BFTrackerServiceHelper.isPush((String)"sfc_manftech", (Long)NumberUtils.toLong((String)technicsBill.getPkValue().toString()));
        if (isPush) {
            errors.add(ResManager.loadKDString((String)"\u5de5\u5e8f\u8ba1\u5212\u5b58\u5728\u4e0b\u6e38\u5355\u636e\u3002", (String)"MftOrderTechnicsCreateBillServiceImpl_30", (String)"mmc-sfc-mservice", (Object[])new Object[0]));
            return errors;
        }
        DynamicObject obj = technicsBill.getDynamicObject("mftentryseq");
        HashSet orderEntryIds = Sets.newHashSet((Object[])new Long[]{obj.getLong("id")});
        Map orderByEntryId = new HashMap(128);
        String orderType = new OrderManuftechTypeInfo(technicsBill.getDataEntityType().getName()).getTarname();
        String techBillEntity = "sfc_manftech";
        if (null != technicsBill && "pom_mroorder".equals(orderType)) {
            orderByEntryId = QueryOrderUtil.getMroOrderByEntryId((Set)orderEntryIds);
            techBillEntity = "sfc_mromanuftech";
        } else {
            orderByEntryId = QueryOrderUtil.getOrderByEntryId((Set)orderEntryIds);
        }
        StringBuffer error = CheckManuOrderUtil.checkManuOrderEntryStatus((String)CHECK_TASK_STATUS, (String)technicsBill.getString("billno"), (String)ResManager.loadKDString((String)"\u6267\u884c\u81f3\u4e0b\u8fbe", (String)"MftOrderTechnicsCreateBillServiceImpl_12", (String)"mmc-sfc-mservice", (Object[])new Object[0]), (Map)((Map)orderByEntryId.get(obj.getLong("id"))), (String)ResManager.loadKDString((String)"\u751f\u4ea7", (String)"MftOrderTechnicsCreateBillServiceImpl_31", (String)"mmc-sfc-mservice", (Object[])new Object[0]));
        if (error.length() > 0) {
            errors.add(error.toString());
            return errors;
        }
        StringBuffer error1 = CheckManuOrderUtil.checkManuOrderEntryStatus((String)CHECK_BIZ_STATUS, (String)technicsBill.getString("billno"), (String)ResManager.loadKDString((String)"\u6267\u884c\u81f3\u4e0b\u8fbe", (String)"MftOrderTechnicsCreateBillServiceImpl_12", (String)"mmc-sfc-mservice", (Object[])new Object[0]), (Map)((Map)orderByEntryId.get(obj.getLong("id"))), (String)ResManager.loadKDString((String)"\u751f\u4ea7", (String)"MftOrderTechnicsCreateBillServiceImpl_31", (String)"mmc-sfc-mservice", (Object[])new Object[0]));
        if (error1.length() > 0) {
            errors.add(error1.toString());
            return errors;
        }
        HashSet status1 = Sets.newHashSet((Object[])new String[]{"A", "B", "C"});
        HashSet<Long> entryKeys = new HashSet<Long>(entryCol.size());
        for (int j = 0; j < entryCol.size(); ++j) {
            if (((DynamicObject)entryCol.get(j)).getBoolean("oprinvalid")) continue;
            entryKeys.add(((DynamicObject)entryCol.get(j)).getLong("id"));
            String oldStatus = ((DynamicObject)entryCol.get(j)).getString("oprstatus");
            if (status1.contains(oldStatus)) continue;
            errors.add(String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\u72b6\u6001\u4e0d\u6ee1\u8db3\u201c\u521b\u5efa\u201d\u3001\u201c\u8ba1\u5212\u5de5\u201d\u6216\u8005\u201c\u8ba1\u5212\u786e\u8ba4\u201d\uff08\u5de5\u5e8f\u8ba1\u5212\uff1a%1$s\uff1b\u5de5\u5e8f\u5e8f\u5217\uff1a%2$s\uff1b\u5de5\u5e8f\u53f7\uff1a%3$s\uff09\u3002", (String)"MftOrderTechnicsCreateBillServiceImpl_15", (String)"mmc-sfc-mservice", (Object[])new Object[0]), technicsBill.get("billno"), ((DynamicObject)entryCol.get(j)).get("oprparent"), ((DynamicObject)entryCol.get(j)).get("oprno")));
        }
        OperateOption operateOption = OperateOption.create();
        operateOption.setVariableValue("ignorewarn", String.valueOf(true));
        operateOption.setVariableValue("ignoreinteraction", String.valueOf(true));
        operateOption.setVariableValue("strictvalidation", String.valueOf(true));
        operateOption.setVariableValue("ignoreValidation", String.valueOf(true));
        operateOption.setVariableValue("WF", "false");
        operateOption.setVariableValue("operateOption", JSON.toJSONString(entryKeys));
        OperationResult result = OperationServiceHelper.executeOperate((String)"donothing_release", (String)techBillEntity, (Object[])new Object[]{technicsBill.getPkValue()}, (OperateOption)operateOption);
        if (!result.isSuccess()) {
            errors.add(OrderOpUtils.getErrDetail((OperationResult)result));
        }
        return errors;
    }

    public List<String> autoDoUnRelease(DynamicObject technicsBill) {
        DynamicObjectCollection entryCol = technicsBill.getDynamicObjectCollection("oprentryentity");
        DynamicObject obj = technicsBill.getDynamicObject("mftentryseq");
        ArrayList<String> errors = new ArrayList<String>();
        if (!"C".equals(technicsBill.getString("billstatus"))) {
            errors.add(String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\u8ba1\u5212\uff08%s\uff09\u672a\u5ba1\u6838\u3002", (String)"MftOrderTechnicsCreateBillServiceImpl_13", (String)"mmc-sfc-mservice", (Object[])new Object[0]), technicsBill.get("billno")));
            return errors;
        }
        boolean isPush = BFTrackerServiceHelper.isPush((String)"sfc_manftech", (Long)NumberUtils.toLong((String)technicsBill.getPkValue().toString()));
        if (isPush) {
            errors.add(ResManager.loadKDString((String)"\u5de5\u5e8f\u8ba1\u5212\u5b58\u5728\u4e0b\u6e38\u5355\u636e\u3002", (String)"MftOrderTechnicsCreateBillServiceImpl_30", (String)"mmc-sfc-mservice", (Object[])new Object[0]));
            return errors;
        }
        HashSet orderEntryIds = Sets.newHashSet((Object[])new Object[]{obj.getPkValue()});
        Set ids = orderEntryIds.stream().map(x -> Long.valueOf(x.toString())).collect(Collectors.toSet());
        String orderType = new OrderManuftechTypeInfo(technicsBill.getDataEntityType().getName()).getTarname();
        Map orderByEntryId = null != technicsBill && "pom_mroorder".equals(orderType) ? QueryOrderUtil.getMroOrderByEntryId(ids) : QueryOrderUtil.getOrderByEntryId(ids);
        HashSet status1 = Sets.newHashSet((Object[])new String[]{"D", "E", "F", "G"});
        StringBuffer error = CheckManuOrderUtil.checkManuOrderEntryStatus((String)CHECK_TASK_STATUS, (String)technicsBill.getString("billno"), (String)"", (Map)((Map)orderByEntryId.get(obj.getLong("id"))), (String)ResManager.loadKDString((String)"\u751f\u4ea7", (String)"MftOrderTechnicsCreateBillServiceImpl_31", (String)"mmc-sfc-mservice", (Object[])new Object[0]));
        if (error.length() > 0) {
            errors.add(error.toString());
            return errors;
        }
        HashSet<Long> entryKeys = new HashSet<Long>(entryCol.size());
        for (int j = 0; j < entryCol.size(); ++j) {
            entryKeys.add(((DynamicObject)entryCol.get(j)).getLong("id"));
            if (((DynamicObject)entryCol.get(j)).getBoolean("oprinvalid")) {
                errors.add(String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\u5df2\u4f5c\u5e9f\uff08\u5de5\u5e8f\u8ba1\u5212\uff1a%1$s\uff1b\u5de5\u5e8f\u5e8f\u5217\uff1a%2$s\uff1b\u5de5\u5e8f\u53f7\uff1a%3$s\uff09\u3002", (String)"MftOrderTechnicsCreateBillServiceImpl_14", (String)"mmc-sfc-mservice", (Object[])new Object[0]), technicsBill.get("billno"), ((DynamicObject)entryCol.get(j)).get("oprparent"), ((DynamicObject)entryCol.get(j)).get("oprno")));
                continue;
            }
            String oldStatus = ((DynamicObject)entryCol.get(j)).getString("oprstatus");
            if (status1.contains(oldStatus)) continue;
            errors.add(String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\u72b6\u6001\u4e0d\u6ee1\u8db3\u201c\u5f00\u5de5\u201d\u3001\u201c\u5b8c\u5de5\u201d\u6216\u8005\u201c\u5173\u95ed\u201d\uff08\u5de5\u5e8f\u8ba1\u5212\uff1a%1$s\uff1b\u5de5\u5e8f\u5e8f\u5217\uff1a%2$s\uff1b\u5de5\u5e8f\u53f7\uff1a%3$s\uff09\u3002", (String)"MftOrderTechnicsCreateBillServiceImpl_16", (String)"mmc-sfc-mservice", (Object[])new Object[0]), technicsBill.get("billno"), ((DynamicObject)entryCol.get(j)).get("oprparent"), ((DynamicObject)entryCol.get(j)).get("oprno")));
        }
        OperateOption operateOption = OperateOption.create();
        operateOption.setVariableValue("ignorewarn", String.valueOf(true));
        operateOption.setVariableValue("ignoreinteraction", String.valueOf(true));
        operateOption.setVariableValue("strictvalidation", String.valueOf(true));
        operateOption.setVariableValue("ignoreValidation", String.valueOf(true));
        operateOption.setVariableValue("WF", "false");
        operateOption.setVariableValue("operateOption", JSON.toJSONString(entryKeys));
        OperationResult result = OperationServiceHelper.executeOperate((String)"donothing_unconfirm", (String)"sfc_manftech", (Object[])new Object[]{technicsBill.getPkValue()}, (OperateOption)operateOption);
        if (!result.isSuccess()) {
            errors.add(OrderOpUtils.getErrDetail((OperationResult)result));
        }
        return errors;
    }

    public List<String> autoDoUnReleaseVal(DynamicObject technicsBill) {
        DynamicObjectCollection entryCol = technicsBill.getDynamicObjectCollection("oprentryentity");
        DynamicObject obj = technicsBill.getDynamicObject("mftentryseq");
        ArrayList<String> errors = new ArrayList<String>();
        boolean isPush = BFTrackerServiceHelper.isPush((String)"sfc_manftech", (Long)NumberUtils.toLong((String)technicsBill.getPkValue().toString()));
        if (isPush) {
            errors.add(ResManager.loadKDString((String)"\u5de5\u5e8f\u8ba1\u5212\u5b58\u5728\u4e0b\u6e38\u5355\u636e\u3002", (String)"MftOrderTechnicsCreateBillServiceImpl_30", (String)"mmc-sfc-mservice", (Object[])new Object[0]));
            return errors;
        }
        HashSet orderEntryIds = Sets.newHashSet((Object[])new Long[]{obj.getLong("id")});
        Map orderByEntryId = new HashMap(128);
        orderByEntryId = null != technicsBill && "sfc_mromanuftech".equals(technicsBill.getDataEntityType().getName()) ? QueryOrderUtil.getMroOrderByEntryId((Set)orderEntryIds) : QueryOrderUtil.getOrderByEntryId((Set)orderEntryIds);
        HashSet status1 = Sets.newHashSet((Object[])new String[]{"D", "E", "F", "G"});
        StringBuffer error = CheckManuOrderUtil.checkManuOrderEntryStatus((String)CHECK_TASK_STATUS, (String)technicsBill.getString("billno"), (String)"", (Map)((Map)orderByEntryId.get(obj.getLong("id"))), (String)ResManager.loadKDString((String)"\u751f\u4ea7", (String)"MftOrderTechnicsCreateBillServiceImpl_31", (String)"mmc-sfc-mservice", (Object[])new Object[0]));
        if (error.length() > 0) {
            errors.add(error.toString());
            return errors;
        }
        for (int j = 0; j < entryCol.size(); ++j) {
            if (((DynamicObject)entryCol.get(j)).getBoolean("oprinvalid")) {
                errors.add(String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\u5df2\u4f5c\u5e9f\uff08\u5de5\u5e8f\u8ba1\u5212\uff1a%1$s\uff1b\u5de5\u5e8f\u5e8f\u5217\uff1a%2$s\uff1b\u5de5\u5e8f\u53f7\uff1a%3$s\uff09\u3002", (String)"MftOrderTechnicsCreateBillServiceImpl_14", (String)"mmc-sfc-mservice", (Object[])new Object[0]), technicsBill.get("billno"), ((DynamicObject)entryCol.get(j)).get("oprparent"), ((DynamicObject)entryCol.get(j)).get("oprno")));
                continue;
            }
            String oldStatus = ((DynamicObject)entryCol.get(j)).getString("oprstatus");
            if (status1.contains(oldStatus)) continue;
            errors.add(String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\u72b6\u6001\u4e0d\u6ee1\u8db3\u201c\u5f00\u5de5\u201d\u3001\u201c\u5b8c\u5de5\u201d\u6216\u8005\u201c\u5173\u95ed\u201d\uff08\u5de5\u5e8f\u8ba1\u5212\uff1a%1$s\uff1b\u5de5\u5e8f\u5e8f\u5217\uff1a%2$s\uff1b\u5de5\u5e8f\u53f7\uff1a%3$s\uff09\u3002", (String)"MftOrderTechnicsCreateBillServiceImpl_16", (String)"mmc-sfc-mservice", (Object[])new Object[0]), technicsBill.get("billno"), ((DynamicObject)entryCol.get(j)).get("oprparent"), ((DynamicObject)entryCol.get(j)).get("oprno")));
        }
        return errors;
    }

    public void autoDoUnReleaseOp(DynamicObject technicsBill) {
        DynamicObject transaction;
        boolean saveTechnicsFlag = false;
        DynamicObject obj = technicsBill.getDynamicObject("mftentryseq");
        HashSet orderEntryIds = Sets.newHashSet((Object[])new Object[]{obj.getPkValue()});
        String orderType = new OrderManuftechTypeInfo(technicsBill.getDataEntityType().getName()).getTarname();
        Date date = new Date();
        long userId = RequestContext.get().getCurrUserId();
        if (null != technicsBill && null != (transaction = technicsBill.getDynamicObject("transactiontype"))) {
            saveTechnicsFlag = transaction.getBoolean("isreleasetechnis");
        }
        if (saveTechnicsFlag) {
            DynamicObjectCollection entryCol = technicsBill.getDynamicObjectCollection("oprentryentity");
            for (int j = 0; j < entryCol.size(); ++j) {
                ((DynamicObject)entryCol.get(j)).set("oprstatus", (Object)"A");
                if (!"pom_mroorder".equals(orderType)) continue;
                ((DynamicObject)entryCol.get(j)).set("oprmodifytime", (Object)date);
                ((DynamicObject)entryCol.get(j)).set("oprmodifier", (Object)userId);
            }
        }
        technicsBill.set("modifier", (Object)userId);
        technicsBill.set("modifytime", (Object)date);
        SaveServiceHelper.saveOperate((String)technicsBill.getDataEntityType().getName(), (DynamicObject[])new DynamicObject[]{technicsBill}, (OperateOption)OperateOption.create());
        CheckManuOrderUtil.updateManuOrderEntryStatus2((String)orderType, (String)"", (String)"D", (String)"row_unrelease", (Set)orderEntryIds, (DynamicObject[])new DynamicObject[]{technicsBill});
    }

    public void createInnerTechnicsBill(DynamicObject[] orders, String operation) {
        ArrayList<Object> updateList = new ArrayList<Object>(10);
        ArrayList saveList = new ArrayList(10);
        String manuftechType = "sfc_manftech";
        Set orderIds = Arrays.stream(orders).map(x -> x.getString("id")).collect(Collectors.toSet());
        DynamicObject[] load = new DynamicObject[]{};
        HashMap<String, CodeRuleInfo> codeRuleInfoMap = new HashMap(16);
        if ("audit".equals(operation)) {
            load = BusinessDataServiceHelper.load((String)manuftechType, (String)QueryOrderUtil.selectProperties((String)manuftechType), (QFilter[])new QFilter[]{new QFilter("manufactureorderid", "in", orderIds)});
            codeRuleInfoMap = this.getCodeRuleInfo(orders, manuftechType);
        }
        HashSet<Long> oprEntryIds = new HashSet<Long>(16);
        for (int i = 0; i < orders.length; ++i) {
            DynamicObject orderObj = orders[i];
            DynamicObjectCollection orderEntrysCol = orderObj.getDynamicObjectCollection("treeentryentity");
            oprEntryIds.addAll(orderEntrysCol.stream().filter(x -> x.getLong("oprentryid") > 0L).map(x -> x.getLong("oprentryid")).collect(Collectors.toSet()));
        }
        Map<Long, Long> fetch = this.getMftFetch(oprEntryIds, manuftechType);
        for (int i = 0; i < orders.length; ++i) {
            OperationResult saveResult;
            Set<Long> collect;
            List<DynamicObject> autoPushInner;
            DynamicObject orderObj = orders[i];
            if (!"audit".equals(operation)) continue;
            if (orderObj.getDynamicObject("transactiontype") != null && !orderObj.getDynamicObject("transactiontype").getBoolean("isprocedure")) {
                logger.info((Object)(orderObj.getString("billno") + ":\u751f\u4ea7\u5de5\u5355\u7684\u751f\u4ea7\u4e8b\u52a1\u7c7b\u578b\u6ca1\u6709\u542f\u7528\u5de5\u5e8f\u7ba1\u7406\uff0c\u4e0d\u751f\u6210\u5de5\u5e8f\u8ba1\u5212------------------------"));
                return;
            }
            DynamicObjectCollection orderEntrysCol = orderObj.getDynamicObjectCollection("treeentryentity");
            if (orderEntrysCol == null || orderEntrysCol.size() == 0) {
                logger.info((Object)(orderObj.getString("billno") + ":\u751f\u4ea7\u5de5\u5355\u6ca1\u6709\u5206\u5f55\uff0c\u4e0d\u751f\u6210\u5de5\u5e8f\u8ba1\u5212------------------------"));
                return;
            }
            ArrayList<DynamicObject> data = new ArrayList<DynamicObject>();
            for (int j = 0; j < orderEntrysCol.size(); ++j) {
                DynamicObject entryObj = (DynamicObject)orderEntrysCol.get(j);
                if (!"C".equals(entryObj.getString("producttype"))) continue;
                data.add(entryObj);
            }
            if (data.size() == 0) {
                logger.info((Object)(orderObj.getString("billno") + ":\u4e0d\u5b58\u5728\u5f55\u5165\u4e86\u5de5\u827a\u8def\u7ebf\u7684\u5206\u5f55------------------------"));
                logger.info((Object)(orderObj.getString("billno") + ":\u751f\u6210\u5de5\u5e8f\u8ba1\u5212\u5b8c\u6210-----------------------"));
                return;
            }
            if (load.length == 0) {
                saveList.addAll(data);
            }
            HashMap<Object, DynamicObject> orderEntryMap = new HashMap<Object, DynamicObject>(16);
            for (DynamicObject object : data) {
                orderEntryMap.put(object.getPkValue(), object);
            }
            for (DynamicObject manuFetch : load) {
                if (manuFetch.getDynamicObject("mftentryseq") == null || !orderEntryMap.containsKey(manuFetch.getDynamicObject("mftentryseq").getPkValue())) continue;
                this.updateMftFetch(manuFetch, (DynamicObject)orderEntryMap.get(manuFetch.getDynamicObject("mftentryseq").getPkValue()), Collections.emptyMap(), manuftechType);
                updateList.add(manuFetch);
            }
            Set fetchOrderEntryIds = updateList.stream().filter(x -> x.getDynamicObject("mftentryseq") != null).map(x -> x.getDynamicObject("mftentryseq").getPkValue()).collect(Collectors.toSet());
            orderEntryMap.forEach((k, v) -> {
                if (!fetchOrderEntryIds.contains(k)) {
                    saveList.add(v);
                }
            });
            if (!CollectionUtils.isNotEmpty(saveList) || !CollectionUtils.isNotEmpty(autoPushInner = this.autoPushInner(orderObj, collect = saveList.stream().filter(x -> x.getLong("oprentryid") > 0L).map(x -> x.getLong("oprentryid")).collect(Collectors.toSet()), fetch, codeRuleInfoMap)) || (saveResult = this.operate("save", manuftechType, autoPushInner.toArray(new DynamicObject[autoPushInner.size()]))).isSuccess()) continue;
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\uff1a%s", (String)"MftOrderTechnicsCreateBillServiceImpl_0", (String)"mmc-sfc-mservice", (Object[])new Object[0]), OrderOpUtils.getErrDetail((OperationResult)saveResult)));
        }
        if (CollectionUtils.isNotEmpty(updateList)) {
            SaveServiceHelper.update((DynamicObject[])updateList.toArray(new DynamicObject[updateList.size()]));
        }
    }

    private List<DynamicObject> autoPushInner(DynamicObject order, Set<Long> oprEntryIds, Map<Long, Long> fetch, Map<String, CodeRuleInfo> codeRuleInfoMap) {
        PushArgs pushArgs = new PushArgs();
        pushArgs.setSourceEntityNumber("sfc_manftech");
        pushArgs.setTargetEntityNumber("sfc_manftech");
        pushArgs.setHasRight(true);
        pushArgs.setAppId("sfc");
        pushArgs.setRuleId("1480302996167351296");
        pushArgs.setBuildConvReport(true);
        ArrayList<Object> selectedRows = new ArrayList<Object>(10);
        for (Long entry : oprEntryIds) {
            ListSelectedRow srcBill = new ListSelectedRow((Object)fetch.get(entry));
            srcBill.setEntryEntityKey("oprentryentity");
            srcBill.setEntryPrimaryKeyValue((Object)entry);
            selectedRows.add(srcBill);
        }
        pushArgs.setSelectedRows(selectedRows);
        ConvertOperationResult pushResult = ConvertServiceHelper.push((PushArgs)pushArgs);
        if (!pushResult.isSuccess()) {
            StringBuilder errMessage = new StringBuilder();
            for (SourceBillReport billReport : pushResult.getBillReports()) {
                if (billReport.isSuccess()) continue;
                errMessage.append(billReport.getFailMessage());
                if (!ResManager.loadKDString((String)"\u65e0\u5339\u914d\u89c4\u5219", (String)"MftOrderTechnicsCreateBillServiceImpl_9", (String)"mmc-sfc-mservice", (Object[])new Object[0]).equals(billReport.getFailMessage())) continue;
                errMessage.append(ResManager.loadKDString((String)"\u6216\u539f\u59cb\u8f6c\u6362\u89c4\u5219\u88ab\u7981\u7528", (String)"MftOrderTechnicsCreateBillServiceImpl_10", (String)"mmc-sfc-mservice", (Object[])new Object[0]));
            }
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u4e0b\u63a8\u5931\u8d25\uff1a%s", (String)"MftOrderTechnicsCreateBillServiceImpl_5", (String)"mmc-sfc-mservice", (Object[])new Object[0]), errMessage));
        }
        MainEntityType targetMainType = EntityMetadataCache.getDataEntityType((String)"sfc_manftech");
        List targetBillObjs = pushResult.loadTargetDataObjects(BusinessDataReader::loadRefence, targetMainType);
        DynamicObject org = order.getDynamicObject("org");
        CodeRuleInfo codeRuleInfo = codeRuleInfoMap.get(org.getPkValue().toString());
        List numbers = new ArrayList(10);
        if (codeRuleInfo != null) {
            numbers = CodeRuleServiceHelper.getNumbers((String)"sfc_manftech", (List)targetBillObjs);
        }
        String sourceBillType = order.getDynamicObjectType().getName();
        String entryName = "treeentryentity";
        Long srcTableId = ConvertMetaServiceHelper.loadTableDefine((String)sourceBillType, (String)entryName).getTableId();
        for (int i = 0; i < targetBillObjs.size(); ++i) {
            Object orderEntryId = ((DynamicObject)targetBillObjs.get(i)).getDynamicObject("mftentryseq").getPkValue();
            if (StringUtils.isBlank((CharSequence)((DynamicObject)targetBillObjs.get(i)).getString("billno"))) {
                if (codeRuleInfo == null) {
                    ((DynamicObject)targetBillObjs.get(i)).set("billno", (Object)("mt_" + orderEntryId));
                } else {
                    ((DynamicObject)targetBillObjs.get(i)).set("billno", numbers.get(i));
                }
            }
            DynamicObjectCollection tagBillEntryList = ((DynamicObject)targetBillObjs.get(i)).getDynamicObjectCollection("oprentryentity");
            DynamicObjectCollection linkRows = (DynamicObjectCollection)((DynamicObject)targetBillObjs.get(i)).get("billhead_lk");
            linkRows.clear();
            if (linkRows.isEmpty()) {
                DynamicObject linkRow = linkRows.addNew();
                linkRow.set("billhead_lk_stableid", (Object)srcTableId);
                linkRow.set("billhead_lk_sbillid", order.getPkValue());
                linkRow.set("billhead_lk_sid", order.getPkValue());
            }
            for (DynamicObject tagEntry : tagBillEntryList) {
                DynamicObjectCollection tagLinkRows = (DynamicObjectCollection)tagEntry.get("oprentryentity_lk");
                tagLinkRows.clear();
                if (!tagLinkRows.isEmpty()) continue;
                DynamicObject linkeEntryRow = tagLinkRows.addNew();
                linkeEntryRow.set("oprentryentity_lk_stableid", (Object)srcTableId);
                linkeEntryRow.set("oprentryentity_lk_sbillid", order.getPkValue());
                linkeEntryRow.set("oprentryentity_lk_sid", orderEntryId);
            }
        }
        return targetBillObjs;
    }

    private Map<String, CodeRuleInfo> getCodeRuleInfo(DynamicObject[] orders, String manuftechType) {
        HashMap<String, CodeRuleInfo> codeRuleInfoMap = new HashMap<String, CodeRuleInfo>(16);
        HashSet<String> orgIds = new HashSet<String>(16);
        for (DynamicObject object : orders) {
            DynamicObject org = object.getDynamicObject("org");
            orgIds.add(org.getPkValue().toString());
        }
        ORM orm = ORM.create();
        DynamicObject orderStock = orm.newDynamicObject(manuftechType);
        for (String orgId : orgIds) {
            CodeRuleInfo codeRuleInfo = CodeRuleServiceHelper.getCodeRule((String)manuftechType, (DynamicObject)orderStock, (String)orgId);
            codeRuleInfoMap.put(orgId, codeRuleInfo);
        }
        return codeRuleInfoMap;
    }

    private Map<Long, Long> getMftFetch(Set<Long> oprEntryIds, String entity) {
        String algoKey = "queryMftOrder";
        String selectFields = "id,oprentryentity.id";
        HashMap<Long, Long> map = new HashMap<Long, Long>(256);
        QFilter qFilter = new QFilter("oprentryentity.id", "in", oprEntryIds);
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)algoKey, (String)entity, (String)selectFields, (QFilter[])new QFilter[]{qFilter}, (String)"");){
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                map.put(row.getLong("oprentryentity.id"), row.getLong("id"));
            }
        }
        return map;
    }

    private Map<Long, Long> getMftFetchEntryByOrderEntry(Set<Long> orderEntryIds, String entity) {
        String algoKey = "getMftFetchEntryByOrderEntry";
        String selectFields = "treeentryentity.id,treeentryentity.oprentryid";
        HashMap<Long, Long> map = new HashMap<Long, Long>(256);
        QFilter qFilter = new QFilter("treeentryentity.id", "in", orderEntryIds);
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)algoKey, (String)entity, (String)selectFields, (QFilter[])new QFilter[]{qFilter}, (String)"");){
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                if (row.getLong("treeentryentity.oprentryid") <= 0L) continue;
                map.put(row.getLong("treeentryentity.id"), row.getLong("treeentryentity.oprentryid"));
            }
        }
        return map;
    }

    private void updateMftFetch(DynamicObject manftech, DynamicObject orderEntryObj, Map<Object, DynamicObject> cardDynamicObjectMap, String manuftechType) {
        int j;
        manftech.set("baseqty", (Object)orderEntryObj.getBigDecimal("baseqty"));
        manftech.set("qty", (Object)orderEntryObj.getBigDecimal("qty"));
        manftech.set("planstarttime", orderEntryObj.get("planbegintime"));
        manftech.set("planfinishtime", orderEntryObj.get("planendtime"));
        manftech.set("productionworkshop", orderEntryObj.get("producedept"));
        manftech.set("configuredcode", orderEntryObj.get("configuredcode"));
        manftech.set("tracknumber", orderEntryObj.get("tracknumber"));
        DynamicObjectCollection proentryentity = manftech.getDynamicObjectCollection("proentryentity");
        for (int j2 = 0; j2 < proentryentity.size(); ++j2) {
            DynamicObject srcObj = (DynamicObject)proentryentity.get(j2);
            srcObj.set("processplanbegintime", orderEntryObj.get("planbegintime"));
            srcObj.set("processplanendtime", orderEntryObj.get("planendtime"));
        }
        if ("sfc_mromanuftech".equals(manuftechType)) {
            manftech.set("project", orderEntryObj.get("project"));
            if (!orderEntryObj.getString("pageseq").equals(manftech.getString("pageseq"))) {
                manftech.getDynamicObjectCollection("oprentryentity").removeAll((Collection)manftech.getDynamicObjectCollection("oprentryentity"));
                this.createCardOprEntryData(manftech, orderEntryObj, cardDynamicObjectMap);
            }
            manftech.set("pageseq", orderEntryObj.get("pageseq"));
        }
        DynamicObjectCollection col = manftech.getDynamicObjectCollection("oprentryentity");
        for (j = 0; j < col.size(); ++j) {
            BigDecimal bigDecimal = orderEntryObj.getBigDecimal("qty");
            DynamicObject srcObj = (DynamicObject)col.get(j);
            if (!"sfc_mromanuftech".equals(manuftechType)) {
                ManuftechCreateBillUtil.recalculateEntryQty((DynamicObject)srcObj, (DynamicObject)orderEntryObj);
            }
            srcObj.set("oprproductionqty", (Object)bigDecimal);
            srcObj.set("oprplanbegintime", orderEntryObj.get("planbegintime"));
            srcObj.set("oprplanfinishtime", orderEntryObj.get("planendtime"));
            srcObj.set("oprearliestbegintime", orderEntryObj.get("planbegintime"));
            srcObj.set("oprlatestbegintime", orderEntryObj.get("planbegintime"));
            srcObj.set("oprearliestfinishtime", orderEntryObj.get("planendtime"));
            srcObj.set("oprlatestfinishtime", orderEntryObj.get("planendtime"));
            DynamicObjectCollection collection = srcObj.getDynamicObjectCollection("actsubentryentity");
            for (DynamicObject object : collection) {
                object.set("actplanbegintime", orderEntryObj.get("planbegintime"));
                object.set("actplanfinishtime", orderEntryObj.get("planendtime"));
            }
        }
        for (j = 0; j < proentryentity.size(); ++j) {
            this.updateProentry(manftech, proentryentity, j);
        }
    }

    public void createOmPurOrderBill(Map<Long, BigDecimal> data) {
        PushArgs pushArgs = new PushArgs();
        pushArgs.setSourceEntityNumber("sfc_manftech");
        pushArgs.setTargetEntityNumber("pm_om_purorderbill");
        pushArgs.setHasRight(true);
        pushArgs.setAppId("pm");
        pushArgs.setRuleId("1429047695619680256");
        pushArgs.setBuildConvReport(true);
        ArrayList selectedRows = new ArrayList(10);
        HashSet<Long> ids = new HashSet<Long>(16);
        data.forEach((k, v) -> {
            if (BigDecimal.ZERO.compareTo((BigDecimal)v) <= 0) {
                ids.add((Long)k);
            }
        });
        Map<Long, Long> orderEntry = this.getMftFetchEntryByOrderEntry(ids, "pom_mftorder");
        if (CollectionUtils.isEmpty(orderEntry.values())) {
            return;
        }
        HashMap param = new HashMap(16);
        data.forEach((k, v) -> orderEntry.forEach((k1, v1) -> {
            if (Objects.equals(k, k1)) {
                param.put(v1, v);
            }
        }));
        Map<Long, Long> mftFetch = this.getMftFetch(Sets.newHashSet(orderEntry.values()), "sfc_manftech");
        mftFetch.forEach((k, v) -> {
            ListSelectedRow srcBill = new ListSelectedRow(v);
            srcBill.setEntryEntityKey("oprentryentity");
            srcBill.setEntryPrimaryKeyValue(k);
            selectedRows.add(srcBill);
        });
        pushArgs.setSelectedRows(selectedRows);
        ConvertOperationResult pushResult = ConvertServiceHelper.push((PushArgs)pushArgs);
        if (!pushResult.isSuccess()) {
            StringBuilder errMessage = new StringBuilder();
            for (SourceBillReport billReport : pushResult.getBillReports()) {
                if (billReport.isSuccess()) continue;
                errMessage.append(billReport.getFailMessage());
                if (!ResManager.loadKDString((String)"\u65e0\u5339\u914d\u89c4\u5219", (String)"MftOrderTechnicsCreateBillServiceImpl_9", (String)"mmc-sfc-mservice", (Object[])new Object[0]).equals(billReport.getFailMessage())) continue;
                errMessage.append(ResManager.loadKDString((String)"\u6216\u539f\u59cb\u8f6c\u6362\u89c4\u5219\u88ab\u7981\u7528", (String)"MftOrderTechnicsCreateBillServiceImpl_10", (String)"mmc-sfc-mservice", (Object[])new Object[0]));
            }
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u4e0b\u63a8\u5931\u8d25\uff1a%s", (String)"MftOrderTechnicsCreateBillServiceImpl_5", (String)"mmc-sfc-mservice", (Object[])new Object[0]), errMessage));
        }
        MainEntityType targetMainType = EntityMetadataCache.getDataEntityType((String)"pm_om_purorderbill");
        List targetBillObjs = pushResult.loadTargetDataObjects(BusinessDataReader::loadRefence, targetMainType);
        if (CollectionUtils.isNotEmpty((Collection)targetBillObjs)) {
            for (DynamicObject object : targetBillObjs) {
                DynamicObjectCollection dynamicObjectCollection = object.getDynamicObjectCollection("billentry");
                for (DynamicObject obj : dynamicObjectCollection) {
                    obj.set("baseqty", param.get(obj.getLong("oprentryid")));
                    if (obj.getDynamicObject("unit") == null || obj.getDynamicObject("baseunit") == null || obj.getDynamicObject("materialmasterid") == null) continue;
                    BigDecimal qty = UnitConvertHelper.calculateNewQty((BigDecimal)((BigDecimal)param.get(obj.getLong("oprentryid"))), (Long)(obj.getDynamicObject("unit") == null ? null : Long.valueOf(obj.getDynamicObject("unit").getLong("id"))), (Long)(obj.getDynamicObject("baseunit") == null ? null : Long.valueOf(obj.getDynamicObject("baseunit").getLong("id"))), obj.getDynamicObject("materialmasterid") == null ? null : Long.valueOf(obj.getDynamicObject("materialmasterid").getLong("id")), (StringBuilder)new StringBuilder());
                    obj.set("qty", (Object)qty);
                    obj.set("auxqty", (Object)AuxQtyAndUnitHelper.changeUntAndQty((DynamicObject)obj, (DynamicObject)obj.getDynamicObject("materialmasterid"), (DynamicObject)obj.getDynamicObject("auxunit"), (String)"baseqty", (String)"baseunit", (String)"auxqty"));
                }
            }
            OperationResult saveResult = this.operate("save", "pm_om_purorderbill", targetBillObjs.toArray(new DynamicObject[targetBillObjs.size()]));
            if (!saveResult.isSuccess()) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\uff1a%s", (String)"MftOrderTechnicsCreateBillServiceImpl_0", (String)"mmc-sfc-mservice", (Object[])new Object[0]), OrderOpUtils.getErrDetail((OperationResult)saveResult)));
            }
        }
    }

    public void createOmPurOrderBill(Map<Long, List<Map<String, Object>>> res, Map<String, String> propertiesMapping) {
        PushArgs pushArgs = new PushArgs();
        pushArgs.setSourceEntityNumber("sfc_manftech");
        pushArgs.setTargetEntityNumber("pm_om_purorderbill");
        pushArgs.setHasRight(true);
        pushArgs.setAppId("pm");
        pushArgs.setRuleId("1429047695619680256");
        pushArgs.setBuildConvReport(true);
        ArrayList selectedRows = new ArrayList(10);
        HashSet<Long> ids = new HashSet<Long>(16);
        for (Map.Entry<Long, List<Map<String, Object>>> longListEntry : res.entrySet()) {
            List<Map<String, Object>> value = longListEntry.getValue();
            if (value == null || value.size() == 0) continue;
            BigDecimal tempt = BigDecimal.ZERO;
            for (Map<String, Object> map : value) {
                BigDecimal tempt1 = (BigDecimal)map.get("billentry.baseqty");
                tempt = tempt.add(tempt1);
            }
            if (BigDecimal.ZERO.compareTo(tempt) > 0) continue;
            ids.add(longListEntry.getKey());
        }
        Map<Long, Long> orderEntry = this.getMftFetchEntryByOrderEntry(ids, "pom_mftorder");
        if (CollectionUtils.isEmpty(orderEntry.values())) {
            return;
        }
        HashMap paramMap = new HashMap();
        res.forEach((k, v) -> orderEntry.forEach((k1, v1) -> {
            if (Objects.equals(k, k1)) {
                paramMap.put(v1, v);
            }
        }));
        Map<Long, Long> mftFetch = this.getMftFetch(Sets.newHashSet(orderEntry.values()), "sfc_manftech");
        mftFetch.forEach((k, v) -> {
            ListSelectedRow srcBill = new ListSelectedRow(v);
            srcBill.setEntryEntityKey("oprentryentity");
            srcBill.setEntryPrimaryKeyValue(k);
            selectedRows.add(srcBill);
        });
        pushArgs.setSelectedRows(selectedRows);
        ConvertOperationResult pushResult = ConvertServiceHelper.push((PushArgs)pushArgs);
        if (!pushResult.isSuccess()) {
            StringBuilder errMessage = new StringBuilder();
            for (SourceBillReport billReport : pushResult.getBillReports()) {
                if (billReport.isSuccess()) continue;
                errMessage.append(billReport.getFailMessage());
                if (!ResManager.loadKDString((String)"\u65e0\u5339\u914d\u89c4\u5219", (String)"MftOrderTechnicsCreateBillServiceImpl_9", (String)"mmc-sfc-mservice", (Object[])new Object[0]).equals(billReport.getFailMessage())) continue;
                errMessage.append(ResManager.loadKDString((String)"\u6216\u539f\u59cb\u8f6c\u6362\u89c4\u5219\u88ab\u7981\u7528", (String)"MftOrderTechnicsCreateBillServiceImpl_10", (String)"mmc-sfc-mservice", (Object[])new Object[0]));
            }
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u4e0b\u63a8\u5931\u8d25\uff1a%s", (String)"MftOrderTechnicsCreateBillServiceImpl_5", (String)"mmc-sfc-mservice", (Object[])new Object[0]), errMessage));
        }
        MainEntityType targetMainType = EntityMetadataCache.getDataEntityType((String)"pm_om_purorderbill");
        List list = pushResult.loadTargetDataObjects(BusinessDataReader::loadRefence, targetMainType);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            for (DynamicObject object : list) {
                DynamicObjectCollection dynamicObjectCollection = object.getDynamicObjectCollection("billentry");
                for (DynamicObject obj : dynamicObjectCollection) {
                    String value;
                    String property;
                    List mftmanbillentrys = (List)paramMap.get(obj.getLong("oprentryid"));
                    BigDecimal baseqty = BigDecimal.ZERO;
                    for (Map mftmanbillentry : mftmanbillentrys) {
                        BigDecimal tempt = mftmanbillentry.get("billentry.baseqty") == null ? BigDecimal.ZERO : (BigDecimal)mftmanbillentry.get("billentry.baseqty");
                        baseqty = baseqty.add(tempt);
                    }
                    obj.set("baseqty", (Object)baseqty);
                    if (obj.getDynamicObject("unit") != null && obj.getDynamicObject("baseunit") != null && obj.getDynamicObject("materialmasterid") != null) {
                        BigDecimal qty = UnitConvertHelper.calculateNewQty((BigDecimal)baseqty, (Long)(obj.getDynamicObject("unit") == null ? null : Long.valueOf(obj.getDynamicObject("unit").getLong("id"))), (Long)(obj.getDynamicObject("baseunit") == null ? null : Long.valueOf(obj.getDynamicObject("baseunit").getLong("id"))), obj.getDynamicObject("materialmasterid") == null ? null : Long.valueOf(obj.getDynamicObject("materialmasterid").getLong("id")), (StringBuilder)new StringBuilder());
                        obj.set("qty", (Object)qty);
                        obj.set("auxqty", (Object)BigDecimal.ZERO);
                        obj.set("auxqty", (Object)this.changeUntAndQty(obj, obj.getDynamicObject("materialmasterid"), obj.getDynamicObject("auxunit"), "baseqty", "baseunit", "auxqty"));
                    }
                    if (mftmanbillentrys.size() == 1) {
                        Set<Map.Entry<String, String>> entries = propertiesMapping.entrySet();
                        Map stringObjectMap = (Map)mftmanbillentrys.get(0);
                        for (Map.Entry<String, String> entry : entries) {
                            property = entry.getKey();
                            value = entry.getValue();
                            if (value.contains(".")) {
                                int i;
                                String[] split = value.split("\\.");
                                if (split.length <= 0 || !"billentry".equals(split[0]) || (i = value.indexOf(46)) == value.length() - 1) continue;
                                String strProperties = value.substring(i + 1, value.length());
                                obj.set(strProperties, stringObjectMap.get(property));
                                continue;
                            }
                            object.set(value, stringObjectMap.get(property));
                        }
                    }
                    if (mftmanbillentrys.size() <= 1) continue;
                    MftInBillAuditAutoPushPurOrderSelectPropertiesExtImpl mftInBillAuditAutoPushPurOrderSelectPropertiesExt = new MftInBillAuditAutoPushPurOrderSelectPropertiesExtImpl();
                    PluginProxy pom_mftmanuinbill_addproperties_ext = PluginProxy.create((Object)mftInBillAuditAutoPushPurOrderSelectPropertiesExt, MftInBillAuditAutoPushPurOrderSelectPropertiesExt.class, (String)"POM_MFTMANUINBILL_SELECTPROPERTIES_EXT", null);
                    for (Map.Entry<String, String> entryset : propertiesMapping.entrySet()) {
                        property = entryset.getKey();
                        value = entryset.getValue();
                        List objects = pom_mftmanuinbill_addproperties_ext.callReplaceIfPresent(t -> {
                            if (t != null) {
                                return t.selectProperties(property, mftmanbillentrys);
                            }
                            return null;
                        });
                        if (objects.size() < 1) continue;
                        if (value.contains(".")) {
                            int i;
                            String[] split = value.split("\\.");
                            if (split.length <= 0 || !"billentry".equals(split[0]) || (i = value.indexOf(46)) == value.length() - 1) continue;
                            String strProperties = value.substring(i + 1, value.length());
                            obj.set(strProperties, objects.get(0));
                            continue;
                        }
                        object.set(value, objects.get(0));
                    }
                }
            }
            OperationResult saveResult = this.operate("save", "pm_om_purorderbill", list.toArray(new DynamicObject[list.size()]));
            if (!saveResult.isSuccess()) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\uff1a%s", (String)"MftOrderTechnicsCreateBillServiceImpl_0", (String)"mmc-sfc-mservice", (Object[])new Object[0]), OrderOpUtils.getErrDetail((OperationResult)saveResult)));
            }
        }
    }

    public BigDecimal changeUntAndQty(DynamicObject entry, DynamicObject material, DynamicObject auxptyUnit, String baseQtyFiledName, String baseUnitFiledName, String qtyUnit2ndFiledName) {
        BigDecimal qtyUnit2nd = null;
        if (null != material) {
            String unitConvertDir;
            boolean isConvert;
            StringBuilder spBuilder = new StringBuilder();
            if (!material.containsProperty("auxptyunit")) {
                spBuilder.append("auxptyunit");
            }
            if (!material.containsProperty("unitconvertdir")) {
                if (spBuilder.length() > 0) {
                    spBuilder.append(",");
                }
                spBuilder.append("unitconvertdir");
            }
            if (spBuilder.length() > 0) {
                material = BusinessDataServiceHelper.loadSingleFromCache((Object)material.getPkValue(), (String)"bd_material", (String)spBuilder.toString());
            }
            boolean bl = isConvert = "A".equals(unitConvertDir = material.getString("unitconvertdir")) || "C".equals(unitConvertDir);
            if (isConvert) {
                BigDecimal baseQty = entry.getBigDecimal(baseQtyFiledName);
                DynamicObject baseUnit = entry.getDynamicObject(baseUnitFiledName);
                if (BigDecimal.ZERO.compareTo(baseQty) == 0) {
                    entry.set(qtyUnit2ndFiledName, (Object)BigDecimal.ZERO);
                    return BigDecimal.ZERO;
                }
                qtyUnit2nd = this.getDesQtyConv(material, baseUnit, baseQty, auxptyUnit);
                entry.set(qtyUnit2ndFiledName, (Object)qtyUnit2nd);
            }
        }
        return qtyUnit2nd;
    }

    public BigDecimal getDesQtyConv(DynamicObject material, DynamicObject srcUnit, BigDecimal srcQty, DynamicObject desUnit) {
        if (material != null && srcUnit != null && desUnit != null && srcQty != null && srcQty.compareTo(BigDecimal.ZERO) != 0) {
            if (srcUnit.getPkValue().equals(desUnit.getPkValue())) {
                return srcQty;
            }
            DynamicObject muConv = BaseDataServiceHelper.getMUConv((Long)((Long)material.getPkValue()), (Long)((Long)srcUnit.getPkValue()), (Long)((Long)desUnit.getPkValue()));
            if (muConv != null && muConv.getInt("numerator") != 0) {
                int precision = desUnit.getInt("precision");
                String precisionAccount = desUnit.getString("precisionaccount");
                if (StringUtils.isNotEmpty((CharSequence)precisionAccount)) {
                    return srcQty.multiply(new BigDecimal(muConv.getInt("numerator"))).divide(new BigDecimal(muConv.getInt("denominator")), precision, PrecisionAccountEnum.getEnumByVal((int)Integer.parseInt(precisionAccount)));
                }
            }
        }
        return BigDecimal.ZERO;
    }
}

