/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.sfc.mservice;

import com.alibaba.fastjson.JSON;
import java.math.BigDecimal;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;

public class MroManufTechQueryServiceImpl {
    DistributeSessionlessCache rediscache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("mmc-sfc-MroManufTechQueryServiceImpl");

    public Map<String, Map<String, Object>> queryMroManufTechData(Map<String, Object> queryMap) {
        if (queryMap == null) {
            return Collections.emptyMap();
        }
        Set entryIDSet = null;
        int cacheTimeLong = 1200;
        if (queryMap.get("entryIDSet") != null) {
            entryIDSet = (HashSet)queryMap.get("entryIDSet");
        }
        if (entryIDSet == null || entryIDSet.isEmpty()) {
            return Collections.emptyMap();
        }
        if (queryMap.get("cacheTimeLong") != null) {
            cacheTimeLong = Integer.parseInt(queryMap.get("cacheTimeLong").toString());
        }
        if (cacheTimeLong > 3600 || cacheTimeLong < 0) {
            cacheTimeLong = 1200;
        }
        HashMap<String, Map<String, Object>> returnMap = new HashMap<String, Map<String, Object>>(entryIDSet.size());
        HashSet queryEntryIDSet = new HashSet(entryIDSet.size());
        for (Object entryID : entryIDSet) {
            String keyString = String.valueOf(entryID);
            String cacheString = null;
            if (cacheTimeLong > 0 && (cacheString = this.getRedisCacheValue(keyString)) != null) {
                returnMap.put(keyString, (Map<String, Object>)JSON.parseObject((String)cacheString, Map.class));
            }
            if (cacheString != null) continue;
            queryEntryIDSet.add(entryID);
        }
        if (!queryEntryIDSet.isEmpty()) {
            String dataName;
            String dataNumber;
            DynamicObject dataObj;
            Long dataID;
            Map returnDataMap;
            HashSet<Long> workcardIdSet = new HashSet<Long>(16);
            HashSet<Long> oprprocessgroupIdSet = new HashSet<Long>(16);
            HashSet<Long> oprprofessionaIdSet = new HashSet<Long>(16);
            HashSet<Long> oprtaskIdSet = new HashSet<Long>(16);
            HashSet<Long> areaIdSet = new HashSet<Long>(16);
            QFilter qFilter = new QFilter("oprentryentity.id", "in", queryEntryIDSet);
            String selectFields = "id,mftentryseq.id mftentryseqid ,mftentryseq.headbillno as headbillno,mftentryseq.area area,workcard workcardid,oprentryentity.id oprentryentityid,oprentryentity.oprprocessgroup oprprocessgroupid,oprentryentity.oprprofessiona oprprofessionaid ,oprentryentity.oprworkhours oprworkhours ,oprentryentity.oprtask oprtaskid ";
            DataSet ds = QueryServiceHelper.queryDataSet((String)"mmc-MroManufTechQueryServiceImpl-queryMroManufTechData", (String)"sfc_mromanuftech", (String)selectFields, (QFilter[])new QFilter[]{qFilter}, (String)"");
            Iterator iterator = null;
            try {
                for (Row row : ds) {
                    Long MroManufTechEntryID = row.getLong("oprentryentityid");
                    Long mftentryseqid = row.getLong("mftentryseqid");
                    Long workcardid = row.getLong("workcardid");
                    Long oprprocessgroupid = row.getLong("oprprocessgroupid");
                    Long oprprofessionaid = row.getLong("oprprofessionaid");
                    Long oprtaskid = row.getLong("oprtaskid");
                    BigDecimal oprworkhours = row.getBigDecimal("oprworkhours");
                    if (oprworkhours != null) {
                        oprworkhours = oprworkhours.stripTrailingZeros();
                    }
                    Long areaid = row.getLong("area");
                    String headbillno = row.getString("headbillno");
                    if (workcardid != null && !workcardid.equals(0L) && workcardid != 0L) {
                        workcardIdSet.add(workcardid);
                    }
                    if (oprprocessgroupid != null && !oprprocessgroupid.equals(0L) && oprprocessgroupid != 0L) {
                        oprprocessgroupIdSet.add(oprprocessgroupid);
                    }
                    if (oprprofessionaid != null && !oprprofessionaid.equals(0L) && oprprofessionaid != 0L) {
                        oprprofessionaIdSet.add(oprprofessionaid);
                    }
                    if (oprtaskid != null && !oprtaskid.equals(0L) && oprtaskid != 0L) {
                        oprtaskIdSet.add(oprtaskid);
                    }
                    if (areaid != null && !areaid.equals(0L) && areaid != 0L) {
                        areaIdSet.add(areaid);
                    }
                    String fkeyString = String.valueOf(MroManufTechEntryID);
                    HashMap<String, Object> dataMap = new HashMap<String, Object>(16);
                    dataMap.put("headbillno", headbillno);
                    dataMap.put("headbillid", row.getLong("id"));
                    dataMap.put("areaid", areaid);
                    dataMap.put("areanumber", "");
                    dataMap.put("areaname", "");
                    dataMap.put("oprworkhours", oprworkhours);
                    dataMap.put("oprtaskid", oprtaskid);
                    dataMap.put("oprtasknumber", "");
                    dataMap.put("oprtaskname", "");
                    dataMap.put("oprprofessionaid", oprprofessionaid);
                    dataMap.put("oprprofessionanumber", "");
                    dataMap.put("oprprofessionaname", "");
                    dataMap.put("workcardid", workcardid);
                    dataMap.put("workcardnumber", "");
                    dataMap.put("workcardname", "");
                    dataMap.put("oprprocessgroupid", oprprocessgroupid);
                    dataMap.put("oprprocessgroupnumber", "");
                    dataMap.put("oprprocessgroupname", "");
                    dataMap.put("mftentryseqid", mftentryseqid);
                    returnMap.put(fkeyString, dataMap);
                }
            }
            catch (Throwable throwable) {
                iterator = throwable;
                throw throwable;
            }
            finally {
                if (ds != null) {
                    if (iterator != null) {
                        try {
                            ds.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)((Object)iterator)).addSuppressed(throwable);
                        }
                    } else {
                        ds.close();
                    }
                }
            }
            if (!workcardIdSet.isEmpty()) {
                Map<Object, DynamicObject> workCardMap = this.queryWorkCardDynamicObject(workcardIdSet);
                for (Map.Entry maps : returnMap.entrySet()) {
                    returnDataMap = (Map)maps.getValue();
                    dataID = returnDataMap.get("workcardid") == null ? 0L : Long.parseLong(returnDataMap.get("workcardid").toString());
                    dataObj = workCardMap.containsKey(dataID) ? workCardMap.get(dataID) : null;
                    dataNumber = dataObj == null ? "" : dataObj.getString("number");
                    dataName = dataObj == null ? "" : dataObj.getString("name");
                    returnDataMap.put("workcardnumber", dataNumber);
                    returnDataMap.put("workcardname", dataName);
                }
            }
            if (!areaIdSet.isEmpty()) {
                Map<Object, DynamicObject> areaMap = this.queryWorkAreaDynamicObject(areaIdSet);
                for (Map.Entry maps : returnMap.entrySet()) {
                    returnDataMap = (Map)maps.getValue();
                    dataID = returnDataMap.get("areaid") == null ? 0L : Long.parseLong(returnDataMap.get("areaid").toString());
                    dataObj = areaMap.containsKey(dataID) ? areaMap.get(dataID) : null;
                    dataNumber = dataObj == null ? "" : dataObj.getString("number");
                    dataName = dataObj == null ? "" : dataObj.getString("name");
                    returnDataMap.put("areanumber", dataNumber);
                    returnDataMap.put("areaname", dataName);
                }
            }
            if (!oprtaskIdSet.isEmpty()) {
                Map<Object, DynamicObject> taskMap = this.queryTaskDynamicObject(oprtaskIdSet);
                for (Map.Entry maps : returnMap.entrySet()) {
                    returnDataMap = (Map)maps.getValue();
                    dataID = returnDataMap.get("oprtaskid") == null ? 0L : Long.parseLong(returnDataMap.get("oprtaskid").toString());
                    dataObj = taskMap.containsKey(dataID) ? taskMap.get(dataID) : null;
                    dataNumber = dataObj == null ? "" : dataObj.getString("number");
                    dataName = dataObj == null ? "" : dataObj.getString("name");
                    returnDataMap.put("oprtasknumber", dataNumber);
                    returnDataMap.put("oprtaskname", dataName);
                }
            }
            if (!oprprofessionaIdSet.isEmpty()) {
                Map<Object, DynamicObject> professionaMap = this.queryProfessionaDynamicObject(oprprofessionaIdSet);
                for (Map.Entry maps : returnMap.entrySet()) {
                    returnDataMap = (Map)maps.getValue();
                    dataID = returnDataMap.get("oprprofessionaid") == null ? 0L : Long.parseLong(returnDataMap.get("oprprofessionaid").toString());
                    dataObj = professionaMap.containsKey(dataID) ? professionaMap.get(dataID) : null;
                    dataNumber = dataObj == null ? "" : dataObj.getString("number");
                    dataName = dataObj == null ? "" : dataObj.getString("name");
                    returnDataMap.put("oprprofessionanumber", dataNumber);
                    returnDataMap.put("oprprofessionaname", dataName);
                }
            }
            if (!oprprocessgroupIdSet.isEmpty()) {
                Map<Object, DynamicObject> processGroupMap = this.queryProcessGroupDynamicObject(oprprocessgroupIdSet);
                for (Map.Entry maps : returnMap.entrySet()) {
                    returnDataMap = (Map)maps.getValue();
                    dataID = returnDataMap.get("oprprocessgroupid") == null ? 0L : Long.parseLong(returnDataMap.get("oprprocessgroupid").toString());
                    dataObj = processGroupMap.containsKey(dataID) ? processGroupMap.get(dataID) : null;
                    dataNumber = dataObj == null ? "" : dataObj.getString("number");
                    dataName = dataObj == null ? "" : dataObj.getString("name");
                    returnDataMap.put("oprprocessgroupnumber", dataNumber);
                    returnDataMap.put("oprprocessgroupname", dataName);
                }
            }
            if (this.rediscache != null) {
                for (Map.Entry maps : returnMap.entrySet()) {
                    if (!queryEntryIDSet.contains(Long.parseLong((String)maps.getKey()))) continue;
                    this.setRedisCacheValue((String)maps.getKey(), JSON.toJSONString(maps.getValue()), cacheTimeLong);
                }
            }
        }
        return returnMap;
    }

    private void setRedisCacheValue(String entryIDs, String jsonString, int cacheTimeLong) {
        if (this.rediscache != null) {
            this.rediscache.put(entryIDs, (Object)jsonString, cacheTimeLong);
        }
    }

    private String getRedisCacheValue(String keyString) {
        if (this.rediscache != null && this.rediscache.contains(keyString)) {
            return (String)this.rediscache.get(keyString);
        }
        return null;
    }

    private Map<Object, DynamicObject> queryWorkCardDynamicObject(Set<Long> workcardIdSet) {
        QFilter qFilter = new QFilter("id", "in", workcardIdSet);
        return BusinessDataServiceHelper.loadFromCache((String)"mpdm_mrocardroute", (String)"number,name", (QFilter[])new QFilter[]{qFilter});
    }

    private Map<Object, DynamicObject> queryProcessGroupDynamicObject(Set<Long> oprprocessgroupIdSet) {
        QFilter qFilter = new QFilter("id", "in", oprprocessgroupIdSet);
        return BusinessDataServiceHelper.loadFromCache((String)"mpdm_processgroup", (String)"number,name", (QFilter[])new QFilter[]{qFilter});
    }

    private Map<Object, DynamicObject> queryProfessionaDynamicObject(Set<Long> oprprofessionaIdSet) {
        QFilter qFilter = new QFilter("id", "in", oprprofessionaIdSet);
        return BusinessDataServiceHelper.loadFromCache((String)"mpdm_professiona", (String)"number,name", (QFilter[])new QFilter[]{qFilter});
    }

    private Map<Object, DynamicObject> queryTaskDynamicObject(Set<Long> oprtaskIdSet) {
        QFilter qFilter = new QFilter("id", "in", oprtaskIdSet);
        return BusinessDataServiceHelper.loadFromCache((String)"pmts_task", (String)"number,name", (QFilter[])new QFilter[]{qFilter});
    }

    private Map<Object, DynamicObject> queryWorkAreaDynamicObject(Set<Long> areaIdSet) {
        QFilter qFilter = new QFilter("id", "in", areaIdSet);
        return BusinessDataServiceHelper.loadFromCache((String)"mpdm_area", (String)"number,name", (QFilter[])new QFilter[]{qFilter});
    }
}

