/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.sfc.mservice;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.mmc.sfc.common.manuftech.utils.MroManuftechUtil;
import kd.mmc.sfc.mservice.api.MroManuftechAuditSaveService;

public class MroManuftechAuditSaveServiceImpl
implements MroManuftechAuditSaveService {
    private static final Log logger = LogFactory.getLog(MroManuftechAuditSaveServiceImpl.class);

    public String saveAuditMroManuftech(DynamicObject[] manuftechBills, String option) {
        StringBuilder errorInfo = new StringBuilder();
        if (manuftechBills == null || manuftechBills.length < 1) {
            return "";
        }
        HashMap<Long, DynamicObject> progroupMap = new HashMap<Long, DynamicObject>(16);
        HashMap<Long, DynamicObject> professionaMap = new HashMap<Long, DynamicObject>(16);
        this.queryOprDate(manuftechBills, progroupMap, professionaMap);
        DynamicObject user = BusinessDataServiceHelper.loadSingleFromCache((Object)RequestContext.get().getCurrUserId(), (String)"bos_user", (String)"id");
        ArrayList<DynamicObject> updateManuftechBills = new ArrayList<DynamicObject>(10);
        for (DynamicObject manuftechBill : manuftechBills) {
            if (!this.valMroManuftech(manuftechBill, errorInfo).booleanValue()) continue;
            Boolean flag = Boolean.FALSE;
            DynamicObjectCollection groentryentityCol = manuftechBill.getDynamicObjectCollection("groentryentity");
            Set processGroupIdList = groentryentityCol.stream().filter(x -> x.getDynamicObject("groprocessgroup") != null).map(x -> x.getDynamicObject("groprocessgroup").getLong("id")).collect(Collectors.toSet());
            DynamicObjectCollection oprentryentityCol = manuftechBill.getDynamicObjectCollection("oprentryentity");
            for (int i = 0; i < oprentryentityCol.size(); ++i) {
                DynamicObject oprprofessiona;
                DynamicObject oprentryentity = (DynamicObject)oprentryentityCol.get(i);
                Long id = oprentryentity.getLong("id");
                if (!id.equals(0L) || !"save".equals(option)) continue;
                oprentryentity.set("oprstatus", (Object)"D");
                DynamicObject oprprocessgroup = oprentryentity.getDynamicObject("oprprocessgroup");
                if (null != oprprocessgroup) {
                    if (progroupMap.containsKey(oprprocessgroup.getLong("id"))) {
                        oprprocessgroup = (DynamicObject)progroupMap.get(oprprocessgroup.getLong("id"));
                        oprentryentity.set("oprprocessgroup", (Object)oprprocessgroup);
                    }
                    if (processGroupIdList.contains(oprprocessgroup.getLong("id"))) {
                        for (DynamicObject groentryentity : groentryentityCol) {
                            DynamicObject groprocessgroup = groentryentity.getDynamicObject("groprocessgroup");
                            Long groprocessgroupId = null == groprocessgroup ? 0L : groprocessgroup.getLong("id");
                            if (!groprocessgroupId.equals(oprprocessgroup.getLong("id")) || !groentryentity.getString("grogroupstatus").equals("C")) continue;
                            groentryentity.set("grogroupstatus", (Object)"B");
                            break;
                        }
                    } else {
                        DynamicObject newEntryObj = groentryentityCol.addNew();
                        newEntryObj.set("groprocessgroup", (Object)oprprocessgroup);
                        newEntryObj.set("grogroupstatus", (Object)"A");
                        newEntryObj.set("gromodifier", (Object)user);
                        newEntryObj.set("gromodifytime", (Object)new Date());
                        processGroupIdList.add(oprprocessgroup.getLong("id"));
                    }
                }
                if (null != (oprprofessiona = oprentryentity.getDynamicObject("oprprofessiona")) && professionaMap.containsKey(oprprofessiona.getLong("id"))) {
                    oprentryentity.set("oprprofessiona", professionaMap.get(oprprofessiona.getLong("id")));
                }
                flag = Boolean.TRUE;
            }
            if (flag.booleanValue()) {
                MroManuftechUtil.oprentryentitySort((DynamicObjectCollection)oprentryentityCol);
                MroManuftechUtil.groentryentitySort((DynamicObjectCollection)groentryentityCol);
            }
            updateManuftechBills.add(manuftechBill);
        }
        if (updateManuftechBills.size() > 0) {
            SaveServiceHelper.save((DynamicObject[])updateManuftechBills.toArray(new DynamicObject[updateManuftechBills.size()]));
        }
        return errorInfo.toString();
    }

    private Boolean valMroManuftech(DynamicObject manuftechBill, StringBuilder errorInfo) {
        DynamicObject mftentry;
        String pstatus;
        Boolean flag = Boolean.TRUE;
        DynamicObject project = manuftechBill.getDynamicObject("project");
        if (null != project && null != project.getDynamicObject("prjstate") && !"PASS_S".equals(pstatus = project.getDynamicObject("prjstate").getString("number")) && !"ONGOING_S".equals(pstatus)) {
            errorInfo.append(String.format(ResManager.loadKDString((String)"%1$s\u9879\u76ee\u72b6\u6001\u4e0d\u4e3a\u201c\u901a\u8fc7\u201d\u3001\u201c\u8fdb\u884c\u4e2d\u201d\u3002", (String)"MroManuftechAuditSaveServiceImpl_0", (String)"mmc-sfc-mservice", (Object[])new Object[0]), manuftechBill.get("billno")));
            flag = Boolean.FALSE;
        }
        if (null != (mftentry = manuftechBill.getDynamicObject("mftentryseq"))) {
            String planstatus;
            String bizstatus = mftentry.getString("bizstatus");
            if (!"A".equals(bizstatus)) {
                errorInfo.append(String.format(ResManager.loadKDString((String)"%1$s\u68c0\u4fee\u5de5\u5355\u4e1a\u52a1\u72b6\u6001\u4e0d\u4e3a\u201c\u6b63\u5e38\u201d\u3002", (String)"MroManuftechAuditSaveServiceImpl_1", (String)"mmc-sfc-mservice", (Object[])new Object[0]), manuftechBill.get("billno")));
                flag = Boolean.FALSE;
            }
            if (!"C".equals(planstatus = mftentry.getString("planstatus"))) {
                errorInfo.append(String.format(ResManager.loadKDString((String)"%1$s\u68c0\u4fee\u5de5\u5355\u8ba1\u5212\u72b6\u6001\u4e0d\u4e3a\u201c\u4e0b\u8fbe\u201d\u3002", (String)"MroManuftechAuditSaveServiceImpl_2", (String)"mmc-sfc-mservice", (Object[])new Object[0]), manuftechBill.get("billno")));
                flag = Boolean.FALSE;
            }
        }
        return flag;
    }

    private void queryOprDate(DynamicObject[] manuftechBills, Map<Long, DynamicObject> progroupMap, Map<Long, DynamicObject> professionaMap) {
        DynamicObject[] professionas;
        DynamicObject[] progroups;
        HashSet<Long> oprprocessgroupIdSet = new HashSet<Long>(16);
        HashSet<Long> oprprofessionaIdSet = new HashSet<Long>(16);
        for (DynamicObject manuftechBill : manuftechBills) {
            DynamicObjectCollection oprentryentityCol = manuftechBill.getDynamicObjectCollection("oprentryentity");
            for (DynamicObject opr : oprentryentityCol) {
                Long id = opr.getLong("id");
                if (!id.equals(0L)) continue;
                DynamicObject oprprocessgroup = opr.getDynamicObject("oprprocessgroup");
                DynamicObject oprprofessiona = opr.getDynamicObject("oprprofessiona");
                if (null != oprprocessgroup) {
                    oprprocessgroupIdSet.add(oprprocessgroup.getLong("id"));
                }
                if (null == oprprofessiona) continue;
                oprprofessionaIdSet.add(oprprofessiona.getLong("id"));
            }
        }
        for (DynamicObject progroup : progroups = BusinessDataServiceHelper.load((String)"mpdm_progroup", (String)"id,defaultworksort", (QFilter[])new QFilter[]{new QFilter("id", "in", oprprocessgroupIdSet)})) {
            progroupMap.put(progroup.getLong("id"), progroup);
        }
        for (DynamicObject professiona : professionas = BusinessDataServiceHelper.load((String)"mpdm_professiona", (String)"id,seqnum", (QFilter[])new QFilter[]{new QFilter("id", "in", oprprofessionaIdSet)})) {
            professionaMap.put(professiona.getLong("id"), professiona);
        }
    }
}

