/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.sfc.mservice;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.mmc.sfc.mservice.api.MroReportProjectHourCountService;

public class MroReportProjectHourCountServiceImpl
implements MroReportProjectHourCountService {
    public Map<Long, Map<Long, BigDecimal>> queryMroProjectHourData(List<Long> projectIds, Boolean isNrcJob, String hourType) {
        HashMap<Long, Map<Long, BigDecimal>> returnMap = new HashMap<Long, Map<Long, BigDecimal>>(16);
        if (null != projectIds && projectIds.size() > 0) {
            try (DataSet ds = this.queryDateSetByProject(projectIds, hourType, null);){
                this.countQuerydata(ds, returnMap, isNrcJob, hourType);
            }
        }
        return returnMap;
    }

    public Map<Long, BigDecimal> queryMroProjectSkillHourData(List<Long> projectIds, Boolean isSkill, String hourType) {
        HashMap<Long, BigDecimal> returnMap = new HashMap<Long, BigDecimal>(16);
        if (null != projectIds && projectIds.size() > 0) {
            try (DataSet ds = this.queryDateSetByProject(projectIds, hourType, isSkill);){
                this.countSkillQuerydata(ds, returnMap, hourType);
            }
        }
        return returnMap;
    }

    private DataSet queryDateSetByProject(List<Long> projectIds, String hourType, Boolean isSkill) {
        if ("3".equals(hourType)) {
            QFilter qFilter = new QFilter("project", "in", projectIds);
            qFilter.and(new QFilter("billstatus", "=", (Object)"C"));
            if (null != isSkill) {
                qFilter.and(new QFilter("oprentryentity.oprprofessiona.isskill", "=", (Object)isSkill));
            }
            qFilter.and(new QFilter("oprentryentity.oprstatus", "not in", (Object)new String[]{"I", "K"}));
            String selectFields = "id,project,manufactureorderid orderid,oprentryentity.oprworkhours oprworkhours";
            return QueryServiceHelper.queryDataSet((String)"MroReportProjectHourCount-querymromanuftech", (String)"sfc_mromanuftech", (String)selectFields, (QFilter[])new QFilter[]{qFilter}, (String)"");
        }
        QFilter qFilter = new QFilter("sumentry.project", "in", projectIds);
        if (null != isSkill) {
            qFilter.and(new QFilter("sumentry.childreportentity.personnelindustry.isskill", "=", (Object)isSkill));
        }
        qFilter.and(new QFilter("srctype", "!=", (Object)""));
        qFilter.and(new QFilter("billstatus", "=", (Object)"C"));
        String selectFields = "id,sumentry.project project,sumentry.manufactureid orderid,sumentry.childreportentity.actconsumedhours actconsumedhours,sumentry.childreportentity.activehours activehours";
        return QueryServiceHelper.queryDataSet((String)"MroReportProjectHourCount-queryprocessreportbill", (String)"sfc_processreportbill", (String)selectFields, (QFilter[])new QFilter[]{qFilter}, (String)"");
    }

    private void countQuerydata(DataSet ds, Map<Long, Map<Long, BigDecimal>> returnMap, Boolean isNrcJob, String hourType) {
        HashSet<Long> mroOrderIdSet = new HashSet<Long>(16);
        for (Row row : ds.copy()) {
            Long mroOrderId = row.getLong("orderid");
            if (mroOrderId == null || mroOrderId.equals(0L)) continue;
            mroOrderIdSet.add(mroOrderId);
        }
        Map<Long, Long> orderTypeMap = this.queryMroOrderType(mroOrderIdSet);
        for (Row row : ds) {
            Map<Long, BigDecimal> dataMap;
            Long projectId = row.getLong("project");
            Long mroOrderId = row.getLong("orderid");
            BigDecimal hour = this.getCountHour(hourType, row);
            Boolean flag = orderTypeMap.containsKey(mroOrderId) && orderTypeMap.get(mroOrderId).equals(1549847746037460992L);
            flag = isNrcJob != false ? flag : flag == false;
            if (!flag.booleanValue()) continue;
            if (returnMap.containsKey(projectId)) {
                dataMap = returnMap.get(projectId);
                if (dataMap.containsKey(mroOrderId)) {
                    dataMap.put(mroOrderId, dataMap.get(mroOrderId).add(hour));
                    continue;
                }
                dataMap.put(mroOrderId, hour);
                continue;
            }
            dataMap = new HashMap<Long, BigDecimal>(16);
            dataMap.put(mroOrderId, hour);
            returnMap.put(projectId, dataMap);
        }
    }

    private void countSkillQuerydata(DataSet ds, Map<Long, BigDecimal> returnMap, String hourType) {
        for (Row row : ds) {
            Long projectId = row.getLong("project");
            BigDecimal hour = this.getCountHour(hourType, row);
            if (returnMap.containsKey(projectId)) {
                returnMap.put(projectId, returnMap.get(projectId).add(hour));
                continue;
            }
            returnMap.put(projectId, hour);
        }
    }

    private BigDecimal getCountHour(String hourType, Row row) {
        BigDecimal hour = BigDecimal.ZERO;
        if ("3".equals(hourType)) {
            hour = row.getBigDecimal("oprworkhours");
        } else {
            BigDecimal actconsumedhours = row.getBigDecimal("actconsumedhours");
            BigDecimal activehours = row.getBigDecimal("activehours");
            hour = "1".equals(hourType) ? actconsumedhours : activehours;
        }
        return null == hour ? BigDecimal.ZERO : hour;
    }

    private Map<Long, Long> queryMroOrderType(Set<Long> mroOrderIdSet) {
        HashMap<Long, Long> orderTypeMap = new HashMap<Long, Long>(16);
        if (null != mroOrderIdSet && mroOrderIdSet.size() > 0) {
            QFilter qFilter1 = new QFilter("id", "in", mroOrderIdSet);
            try (DataSet typeDS = QueryServiceHelper.queryDataSet((String)"MroReportProjectHourCount-querymroorder", (String)"pom_mroorder", (String)"id,mroordertypeid", (QFilter[])new QFilter[]{qFilter1}, (String)"");){
                for (Row row : typeDS) {
                    orderTypeMap.put(row.getLong("id"), row.getLong("mroordertypeid"));
                }
            }
        }
        return orderTypeMap;
    }
}

