/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.sfc.mservice;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bd.mpdm.common.manuftech.utils.ManuftechCreateBillUtil;
import kd.bd.mpdm.common.mftorder.utils.OrderOpUtils;
import kd.bos.coderule.api.CodeRuleInfo;
import kd.bos.data.BusinessDataReader;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.runtime.ConvertOperationResult;
import kd.bos.entity.botp.runtime.PushArgs;
import kd.bos.entity.botp.runtime.SourceBillReport;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.id.ID;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.botp.ConvertServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.mmc.sfc.common.utils.OperationResultUtils;
import org.apache.commons.lang3.StringUtils;

public class XManuftechChangeServiceImpl {
    public void manuftechChange(List<DynamicObject> modifiedManuftchs, String changeReason) {
        DynamicObject[] xFinalObj;
        Map<Long, DynamicObject> originIdModifyObj = modifiedManuftchs.stream().collect(Collectors.toMap(x -> x.getLong("id"), r -> r));
        List<DynamicObject> xManuftechs = this.autoPush(originIdModifyObj.keySet());
        this.setNecessaryInfo(xManuftechs, changeReason);
        this.recognizeAndReplace(xManuftechs, originIdModifyObj);
        OperateOption operateOption = OperationResultUtils.createOperateOption();
        operateOption.setVariableValue("isFromChangeService", "true");
        OperationResult submitResult = OperationServiceHelper.executeOperate((String)"submit", (String)"sfc_xmanftech", (DynamicObject[])xManuftechs.toArray(new DynamicObject[xManuftechs.size()]), (OperateOption)operateOption);
        if (!submitResult.isSuccess()) {
            throw new KDBizException(OrderOpUtils.getErrDetail((OperationResult)submitResult));
        }
        List ids = xManuftechs.stream().map(DataEntityBase::getPkValue).collect(Collectors.toList());
        QFilter qFilter = new QFilter("id", "in", ids);
        for (DynamicObject x2 : xFinalObj = BusinessDataServiceHelper.load((String)"sfc_xmanftech", (String)"id,billstatus", (QFilter[])new QFilter[]{qFilter})) {
            x2.set("billstatus", (Object)"C");
        }
        SaveServiceHelper.save((DynamicObject[])xFinalObj);
    }

    private void recognizeAndReplace(List<DynamicObject> xManuftechs, Map<Long, DynamicObject> modifiedManuftchs) {
        for (DynamicObject xManuftch : xManuftechs) {
            Object mPro2;
            DynamicObjectCollection xProEntryEntity = xManuftch.getDynamicObjectCollection("proentryentity");
            DynamicObjectCollection xOprEntryEntity = xManuftch.getDynamicObjectCollection("oprentryentity");
            long proManIds = ((DynamicObject)xProEntryEntity.get(0)).getDynamicObject("promanftechid").getLong("id");
            Map<Long, DynamicObject> xProEntryProIdXObj = xProEntryEntity.stream().collect(Collectors.toMap(x -> x.getLong("proentryid"), r -> r));
            Map<Long, DynamicObject> xOprEntryOprIdXObj = xOprEntryEntity.stream().collect(Collectors.toMap(x -> x.getDynamicObject("oprentryid").getLong("id"), r -> r));
            DynamicObject modifiedManuftch = modifiedManuftchs.get(proManIds);
            if (modifiedManuftch == null) continue;
            DynamicObjectCollection mProEntryEntity = modifiedManuftch.getDynamicObjectCollection("proentryentity");
            DynamicObjectCollection mOprEntryEntity = modifiedManuftch.getDynamicObjectCollection("oprentryentity");
            Set mOprAllEntryIds = mOprEntryEntity.stream().map(x -> {
                if (x.getLong("id") == 0L) {
                    x.set("id", (Object)ID.genLongId());
                }
                return x.getLong("id");
            }).collect(Collectors.toSet());
            int xProSeq = xProEntryEntity.size();
            for (Object mPro2 : mProEntryEntity) {
                if (xProEntryProIdXObj.containsKey(mPro2.getLong("id"))) {
                    ManuftechCreateBillUtil.setProEntryEntityValue((DynamicObject)mPro2, (DynamicObject)xProEntryProIdXObj.get(mPro2.getLong("id")));
                    continue;
                }
                DynamicObject xProNew = xProEntryEntity.addNew();
                xProNew.set("id", (Object)ID.genLongId());
                xProNew.set("seq", (Object)(++xProSeq));
                xProNew.set("prochangetype", (Object)"A");
                ManuftechCreateBillUtil.setProEntryEntityValue((DynamicObject)mPro2, (DynamicObject)xProNew);
            }
            int seq = xOprEntryEntity.size();
            mPro2 = mOprEntryEntity.iterator();
            while (mPro2.hasNext()) {
                DynamicObject mOpr = (DynamicObject)mPro2.next();
                if (xOprEntryOprIdXObj.containsKey(mOpr.getLong("id"))) {
                    DynamicObject xOpr = xOprEntryOprIdXObj.get(mOpr.getLong("id"));
                    ManuftechCreateBillUtil.setOprEntryValue((DynamicObject)mOpr, (DynamicObject)xOpr);
                    DynamicObjectCollection mActs = mOpr.getDynamicObjectCollection("actsubentryentity");
                    DynamicObjectCollection dynamicObjectCollection = xOpr.getDynamicObjectCollection("actsubentryentity");
                    dynamicObjectCollection.removeAll((Collection)dynamicObjectCollection);
                    for (DynamicObject mAct : mActs) {
                        ManuftechCreateBillUtil.setActSubEntryEntityValue((DynamicObject)mAct, (DynamicObject)dynamicObjectCollection.addNew());
                    }
                    continue;
                }
                DynamicObject xOprNew = xOprEntryEntity.addNew();
                this.initNewOprEntryEntity(xManuftch, xOprNew, mOpr.getString("oprparent"));
                xOprNew.set("id", (Object)ID.genLongId());
                xOprNew.set("seq", (Object)(++seq));
                xOprNew.set("oprchangetype", (Object)"A");
                ManuftechCreateBillUtil.setOprEntryValue((DynamicObject)mOpr, (DynamicObject)xOprNew);
                DynamicObjectCollection mSubEntryCol = mOpr.getDynamicObjectCollection("actsubentryentity");
                for (DynamicObject mAct : mSubEntryCol) {
                    ManuftechCreateBillUtil.setActSubEntryEntityValue((DynamicObject)mAct, (DynamicObject)xOprNew.getDynamicObjectCollection("actsubentryentity").addNew());
                }
            }
            Set<Long> delIds = xOprEntryOprIdXObj.keySet().stream().filter(k -> !mOprAllEntryIds.contains(k)).collect(Collectors.toSet());
            delIds.forEach(id -> ((DynamicObject)xOprEntryOprIdXObj.get(id)).set("oprchangetype", (Object)"C"));
        }
    }

    private void initNewOprEntryEntity(DynamicObject xManuFtechObj, DynamicObject xManuFtechOprEntryNewObj, String parentno) {
        DynamicObject manFtechId;
        DynamicObjectCollection xProEntryEntity = xManuFtechObj.getDynamicObjectCollection("proentryentity");
        xManuFtechOprEntryNewObj.set("oprparent", (Object)parentno);
        xManuFtechOprEntryNewObj.set("oprproductionqty", xManuFtechObj.get("qty"));
        xManuFtechOprEntryNewObj.set("oprplanbegintime", xManuFtechObj.get("planstarttime"));
        xManuFtechOprEntryNewObj.set("oprplanfinishtime", xManuFtechObj.get("planfinishtime"));
        xManuFtechOprEntryNewObj.set("oprstandardqty", xManuFtechObj.get("baseqty"));
        xManuFtechOprEntryNewObj.set("oprqty", xManuFtechObj.get("baseqty"));
        BigDecimal upperRatio = xManuFtechOprEntryNewObj.getBigDecimal("upperratio");
        BigDecimal divide = upperRatio.divide(new BigDecimal("100"));
        xManuFtechOprEntryNewObj.set("upperqty", (Object)divide.add(BigDecimal.ONE).multiply(xManuFtechObj.getBigDecimal("baseqty")));
        BigDecimal floorRatio = xManuFtechOprEntryNewObj.getBigDecimal("floorratio");
        BigDecimal divide1 = floorRatio.divide(new BigDecimal("100"));
        xManuFtechOprEntryNewObj.set("floorqty", (Object)BigDecimal.ONE.subtract(divide1).multiply(xManuFtechObj.getBigDecimal("baseqty")));
        if (xManuFtechObj.get("mftentryseq") != null) {
            xManuFtechOprEntryNewObj.set("headunit", ((DynamicObject)xManuFtechObj.get("baseunit")).getPkValue());
            xManuFtechOprEntryNewObj.set("overlapunit", ((DynamicObject)xManuFtechObj.get("mftentryseq")).getDynamicObject("unit").getPkValue());
            xManuFtechOprEntryNewObj.set("oprunit", ((DynamicObject)xManuFtechObj.get("baseunit")).getPkValue());
            xManuFtechOprEntryNewObj.set("settlementunit", ((DynamicObject)xManuFtechObj.get("mftentryseq")).getDynamicObject("unit").getPkValue());
        }
        if ((manFtechId = (DynamicObject)((DynamicObject)xProEntryEntity.get(0)).get("promanftechid")) != null) {
            xManuFtechOprEntryNewObj.set("oprproductionqty", manFtechId.get("qty"));
            xManuFtechOprEntryNewObj.set("oprplanbegintime", manFtechId.get("planstarttime"));
            xManuFtechOprEntryNewObj.set("oprplanfinishtime", manFtechId.get("planfinishtime"));
            xManuFtechOprEntryNewObj.set("oprstandardqty", (Object)manFtechId.getBigDecimal("baseqty"));
            xManuFtechOprEntryNewObj.set("oprqty", (Object)manFtechId.getBigDecimal("baseqty"));
            BigDecimal xupperRatio = (BigDecimal)xManuFtechOprEntryNewObj.get("upperratio");
            BigDecimal xdivide = xupperRatio.divide(new BigDecimal("100"));
            xManuFtechOprEntryNewObj.set("upperqty", (Object)xdivide.add(BigDecimal.ONE).multiply(manFtechId.getBigDecimal("baseqty")));
            BigDecimal xfloorRatio = (BigDecimal)xManuFtechOprEntryNewObj.get("floorratio");
            BigDecimal xdivide1 = xfloorRatio.divide(new BigDecimal("100"));
            xManuFtechOprEntryNewObj.set("floorqty", (Object)BigDecimal.ONE.subtract(xdivide1).multiply(manFtechId.getBigDecimal("baseqty")));
        }
        xManuFtechOprEntryNewObj.set("oprmanftechid", (Object)manFtechId);
        DynamicObject proOrderEntryId = (DynamicObject)((DynamicObject)xProEntryEntity.get(0)).get("proorderentryid");
        xManuFtechOprEntryNewObj.set("oprorderentryid", (Object)proOrderEntryId);
        if (proOrderEntryId != null) {
            DynamicObject dynamicObject = proOrderEntryId.getDynamicObject("processroute");
            if (dynamicObject != null) {
                DynamicObject object = BusinessDataServiceHelper.loadSingleFromCache((Object)dynamicObject.getPkValue(), (String)"pdm_route", (String)"unit");
                xManuFtechOprEntryNewObj.set("headunit", (Object)(object != null && object.getDynamicObject("unit") != null ? object.getDynamicObject("unit") : proOrderEntryId.getDynamicObject("baseunit")));
            } else {
                xManuFtechOprEntryNewObj.set("headunit", (Object)proOrderEntryId.getDynamicObject("baseunit"));
            }
            xManuFtechOprEntryNewObj.set("oprunit", (Object)proOrderEntryId.getDynamicObject("baseunit"));
            xManuFtechOprEntryNewObj.set("overlapunit", (Object)proOrderEntryId.getDynamicObject("unit"));
            xManuFtechOprEntryNewObj.set("settlementunit", (Object)proOrderEntryId.getDynamicObject("unit"));
        }
    }

    private void setNecessaryInfo(List<DynamicObject> objs, String reason) {
        if (CollectionUtils.isNotEmpty(objs)) {
            List numbers = new ArrayList(10);
            CodeRuleInfo codeRuleInfo = CodeRuleServiceHelper.getCodeRule((String)"sfc_xmanftech", (DynamicObject)objs.get(0), null);
            if (codeRuleInfo != null) {
                numbers = CodeRuleServiceHelper.getNumbers((String)"sfc_xmanftech", objs);
            }
            for (int i = 0; i < objs.size(); ++i) {
                objs.get(i).set("reason", (Object)reason);
                if (!StringUtils.isBlank((CharSequence)objs.get(i).getString("billno"))) continue;
                if (codeRuleInfo == null) {
                    objs.get(i).set("billno", (Object)("xmt_" + objs.get(i).getPkValue()));
                    continue;
                }
                objs.get(i).set("billno", numbers.get(i));
            }
        }
    }

    private List<DynamicObject> autoPush(Set<Long> ids) {
        PushArgs pushArgs = new PushArgs();
        pushArgs.setSourceEntityNumber("sfc_manftech");
        pushArgs.setTargetEntityNumber("sfc_xmanftech");
        pushArgs.setHasRight(true);
        pushArgs.setAppId("sfc");
        pushArgs.setRuleId("1539706472160592896");
        pushArgs.setBuildConvReport(true);
        ArrayList selectedRows = new ArrayList(ids.size());
        ids.forEach(id -> selectedRows.add(new ListSelectedRow(id)));
        pushArgs.setSelectedRows(selectedRows);
        ConvertOperationResult pushResult = ConvertServiceHelper.push((PushArgs)pushArgs);
        if (!pushResult.isSuccess()) {
            StringBuilder errMessage = new StringBuilder();
            for (SourceBillReport billReport : pushResult.getBillReports()) {
                if (billReport.isSuccess()) continue;
                errMessage.append(billReport.getFailMessage());
            }
            if (errMessage.length() < 1) {
                errMessage.append(pushResult.getMessage());
            }
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\u8ba1\u5212\u4e0b\u63a8\u5de5\u5e8f\u8ba1\u5212\u53d8\u66f4\u5355\u5931\u8d25:%s", (String)"XManuftechChangeServiceImpl_0", (String)"mmc-sfc-mservice", (Object[])new Object[0]), errMessage));
        }
        MainEntityType targetMainType = EntityMetadataCache.getDataEntityType((String)"sfc_xmanftech");
        List targetBillObjs = pushResult.loadTargetDataObjects(BusinessDataReader::loadRefence, targetMainType);
        return targetBillObjs;
    }
}

