/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.sfc.mservice.upgrade;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.mmc.sfc.mservice.upgrade.utils.BaseQytUtils;
import org.apache.commons.collections4.CollectionUtils;

public class GxBaseQtyUpgradeServiceImpl
implements IUpgradeService {
    private static Log logger = LogFactory.getLog(GxBaseQtyUpgradeServiceImpl.class);

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        DBRoute scmRoute = new DBRoute("scm");
        String sql = "select a.fbaseunit,a.fmaterialid,b.foprunitid,c.foperationqty,c.fheadunitid,c.fheadqty,b.fprocessentryid,b.foprtotalinqty,b.foprtotaloutqty,c.fpushreportqty,b.foprtotalreportqty,b.foprtotalqualifiedqty,c.foprtotalreceiveqty,b.foprtotalwasteqty,b.foprtotalmaterialqty,c.foprtotaljunkqty,b.foprrepairedqty,c.foprtotalreworkqty,c.fpushreworkreportqty,c.freworkreportqty from t_pom_mftorderentry_m a inner join t_pom_manftechentry b on a.fid = b.fid inner join t_pom_manftechentry_e c on b.fprocessentryid = c.fprocessentryid;";
        try (DataSet srcEntryId = DB.queryDataSet((String)this.getClass().getName(), (DBRoute)scmRoute, (String)sql);){
            HashMap<Long, Map> resultMap = new HashMap<Long, Map>(256);
            while (srcEntryId.hasNext()) {
                Row row = srcEntryId.next();
                HashMap<String, Number> map = new HashMap<String, Number>(64);
                map.put("fbaseunit", row.getLong("fbaseunit"));
                map.put("fmaterialid", row.getLong("fmaterialid"));
                map.put("foprunitid", row.getLong("foprunitid"));
                map.put("foperationqty", row.getBigDecimal("foperationqty"));
                map.put("fheadunitid", row.getLong("fheadunitid"));
                map.put("fheadqty", row.getBigDecimal("fheadqty"));
                map.put("fprocessentryid", row.getLong("fprocessentryid"));
                map.put("foprtotalinqty", row.getBigDecimal("foprtotalinqty"));
                map.put("foprtotaloutqty", row.getBigDecimal("foprtotaloutqty"));
                map.put("fpushreportqty", row.getBigDecimal("fpushreportqty"));
                map.put("foprtotalreportqty", row.getBigDecimal("foprtotalreportqty"));
                map.put("foprtotalqualifiedqty", row.getBigDecimal("foprtotalqualifiedqty"));
                map.put("foprtotalreceiveqty", row.getBigDecimal("foprtotalreceiveqty"));
                map.put("foprtotalwasteqty", row.getBigDecimal("foprtotalwasteqty"));
                map.put("foprtotalmaterialqty", row.getBigDecimal("foprtotalmaterialqty"));
                map.put("foprtotaljunkqty", row.getBigDecimal("foprtotaljunkqty"));
                map.put("foprrepairedqty", row.getBigDecimal("foprrepairedqty"));
                map.put("foprtotalreworkqty", row.getBigDecimal("foprtotalreworkqty"));
                map.put("fpushreworkreportqty", row.getBigDecimal("fpushreworkreportqty"));
                map.put("freworkreportqty", row.getBigDecimal("freworkreportqty"));
                resultMap.put(row.getLong("fprocessentryid"), map);
            }
            String updateInvTypeSql = "update t_pom_manftechentry_e set foprtotalinbaseqty  = ?,foprtotaloutbaseqty = ?,fpushreportbaseqty  = ?, foprtotalreportbaseqty  = ?,foprtotalqualifiedbaseqty =?, foprtotalreceivebaseqty =?, foprtotalwastebaseqty =?, foprtotalmaterialbaseqty =?, foprtotaljunkbaseqty =?, foprrepairedbaseqty =?, foprtotalreworkbaseqty =?, fpushreworkreportbaseqty = ?,freworkreportbaseqty = ? where fprocessentryid = ?";
            ArrayList paramsList = new ArrayList(10);
            resultMap.forEach((k, v) -> {
                BigDecimal oprTotalInQty = BaseQytUtils.getBaseQty(v, (BigDecimal)v.get("foprtotalinqty"));
                BigDecimal oprTotalOutQty = BaseQytUtils.getBaseQty(v, (BigDecimal)v.get("foprtotaloutqty"));
                BigDecimal pushReportQty = BaseQytUtils.getBaseQty(v, (BigDecimal)v.get("fpushreportqty"));
                BigDecimal oprTotalReportQty = BaseQytUtils.getBaseQty(v, (BigDecimal)v.get("foprtotalreportqty"));
                BigDecimal oprTotalQualifiedQty = BaseQytUtils.getBaseQty(v, (BigDecimal)v.get("foprtotalqualifiedqty"));
                BigDecimal oprTotalReceiveQty = BaseQytUtils.getBaseQty(v, (BigDecimal)v.get("foprtotalreceiveqty"));
                BigDecimal oprTotalWasteQty = BaseQytUtils.getBaseQty(v, (BigDecimal)v.get("foprtotalwasteqty"));
                BigDecimal oprTotalMaterialQty = BaseQytUtils.getBaseQty(v, (BigDecimal)v.get("foprtotalmaterialqty"));
                BigDecimal oprTotalJunkQty = BaseQytUtils.getBaseQty(v, (BigDecimal)v.get("foprtotaljunkqty"));
                BigDecimal oprRepairedQty = BaseQytUtils.getBaseQty(v, (BigDecimal)v.get("foprrepairedqty"));
                BigDecimal oprTotalReworkQty = BaseQytUtils.getBaseQty(v, (BigDecimal)v.get("foprtotalreworkqty"));
                BigDecimal pushReworkReportQty = BaseQytUtils.getBaseQty(v, (BigDecimal)v.get("fpushreworkreportqty"));
                BigDecimal ReworkReportQty = BaseQytUtils.getBaseQty(v, (BigDecimal)v.get("freworkreportqty"));
                paramsList.add(new Object[]{oprTotalInQty, oprTotalOutQty, pushReportQty, oprTotalReportQty, oprTotalQualifiedQty, oprTotalReceiveQty, oprTotalWasteQty, oprTotalMaterialQty, oprTotalJunkQty, oprRepairedQty, oprTotalReworkQty, pushReworkReportQty, ReworkReportQty, k});
            });
            if (CollectionUtils.isNotEmpty(paramsList)) {
                List partition = Lists.partition(paramsList, (int)1000);
                for (List objects : partition) {
                    BaseQytUtils.batchUpdate(scmRoute, objects, updateInvTypeSql);
                }
            }
        }
        result.setSuccess(true);
        return result;
    }
}

