/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.sfc.mservice.upgrade;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.bos.servicehelper.UnitConvertHelper;
import kd.mmc.sfc.mservice.upgrade.entity.SubinStorageEntity;
import kd.mmc.sfc.mservice.upgrade.utils.BaseQytUtils;
import org.apache.commons.collections4.CollectionUtils;

public class QtyUpgradeServiceImpl
implements IUpgradeService {
    private static Log logger = LogFactory.getLog(QtyUpgradeServiceImpl.class);

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        DBRoute scmRoute = new DBRoute("scm");
        String sql = "select a.fdetailid,b.fmanufactureentryid,b.foprentryid,b.fqualifyqty,b.freceiveqty,b.fworkwasteqty,b.fscrapqty,b.frepairqty,b.fcheckreworkqty,a.fmanufacturenun from t_sfc_subinstorage a inner join t_sfc_processrptent b on a.fentryid = b.fentryid where a.fmatertype='C'";
        try (DataSet srcEntryId = DB.queryDataSet((String)this.getClass().getName(), (DBRoute)scmRoute, (String)sql);){
            HashSet<Long> orderEntryIds = new HashSet<Long>(16);
            HashSet<Long> oprEntryIds = new HashSet<Long>(16);
            ArrayList<SubinStorageEntity> detailIds = new ArrayList<SubinStorageEntity>(10);
            while (srcEntryId.hasNext()) {
                Row row = srcEntryId.next();
                orderEntryIds.add(row.getLong("fmanufactureentryid"));
                oprEntryIds.add(row.getLong("foprentryid"));
                SubinStorageEntity subinStorageEntity = new SubinStorageEntity();
                subinStorageEntity.setDetailId(row.getLong("fdetailid"));
                subinStorageEntity.setManufactureEntryId(row.getString("fmanufactureentryid"));
                subinStorageEntity.setOprEntryId(row.getString("foprentryid"));
                subinStorageEntity.setBigDecimal1(row.getBigDecimal("fqualifyqty").add(row.getBigDecimal("freceiveqty")));
                subinStorageEntity.setBigDecimal2(row.getBigDecimal("fworkwasteqty").add(row.getBigDecimal("fscrapqty")));
                subinStorageEntity.setBigDecimal3(row.getBigDecimal("frepairqty").add(row.getBigDecimal("fcheckreworkqty")));
                subinStorageEntity.setManuFactuRenun(row.getString("fmanufacturenun"));
                detailIds.add(subinStorageEntity);
            }
            result.setLog(String.format(ResManager.loadKDString((String)"\u9700\u8981update\u6570\u636e\u7684size%d", (String)"QtyUpgradeServiceImpl_0", (String)"mmc-sfc-mservice", (Object[])new Object[0]), detailIds.size()));
            Map<String, Map<String, Object>> ratio = this.getRatio(scmRoute, new ArrayList<Long>(oprEntryIds));
            Map<String, Map<String, Long>> unitId = this.getUnitId(scmRoute, new ArrayList<Long>(orderEntryIds));
            String updateInvTypeSql = "update t_sfc_subinstorage set fqualifyqty  = ?,fscrapqty = ?,fbadqualifyqty  = ?,fconformityqty = ?,fdiscardqty  = ?,fbadconformityqty = ? where fdetailid = ?";
            ArrayList paramsList = new ArrayList(10);
            detailIds.forEach(x -> {
                BigDecimal decimal = BigDecimal.ZERO;
                BigDecimal decimal1 = BigDecimal.ZERO;
                BigDecimal decimal2 = BigDecimal.ZERO;
                BigDecimal decimal3 = BigDecimal.ZERO;
                BigDecimal decimal4 = BigDecimal.ZERO;
                BigDecimal decimal5 = BigDecimal.ZERO;
                for (Map.Entry entry : ratio.entrySet()) {
                    if (!x.getOprEntryId().equals(entry.getKey())) continue;
                    decimal = BaseQytUtils.getBaseQty((Map)entry.getValue(), x.getBigDecimal1());
                    decimal1 = BaseQytUtils.getBaseQty((Map)entry.getValue(), x.getBigDecimal2());
                    decimal2 = BaseQytUtils.getBaseQty((Map)entry.getValue(), x.getBigDecimal3());
                    break;
                }
                for (Map.Entry entry : unitId.entrySet()) {
                    if (!x.getManufactureEntryId().equals(entry.getKey())) continue;
                    decimal3 = this.getQty((Map)entry.getValue(), decimal);
                    decimal4 = this.getQty((Map)entry.getValue(), decimal1);
                    decimal5 = this.getQty((Map)entry.getValue(), decimal2);
                    break;
                }
                paramsList.add(new Object[]{decimal, decimal1, decimal2, decimal3, decimal4, decimal5, x.getDetailId()});
            });
            result.setLog(String.format(ResManager.loadKDString((String)"\u7ec4\u88c5SQL\u53c2\u6570\u7684size%d", (String)"QtyUpgradeServiceImpl_1", (String)"mmc-sfc-mservice", (Object[])new Object[0]), paramsList.size()));
            if (CollectionUtils.isNotEmpty(paramsList)) {
                List partition = Lists.partition(paramsList, (int)1000);
                result.setLog(String.format(ResManager.loadKDString((String)"\u7ec4\u88c5SQL\u53c2\u6570\u5207\u5272\u540e\u7684size%d", (String)"QtyUpgradeServiceImpl_2", (String)"mmc-sfc-mservice", (Object[])new Object[0]), partition.size()));
                for (List objects : partition) {
                    BaseQytUtils.batchUpdate(scmRoute, objects, updateInvTypeSql);
                }
            }
        }
        result.setSuccess(true);
        return result;
    }

    private Map<String, Map<String, Object>> getRatio(DBRoute scmRoute, List<Long> ids) {
        HashMap<String, Map<String, Object>> map = new HashMap<String, Map<String, Object>>(256);
        if (CollectionUtils.isEmpty(ids)) {
            return map;
        }
        Object[] params = new Object[ids.size()];
        StringBuilder sqlBuilder = new StringBuilder();
        sqlBuilder.append("(");
        for (int i = 0; i < ids.size(); ++i) {
            sqlBuilder.append("?,");
            params[i] = ids.get(i);
        }
        sqlBuilder.deleteCharAt(sqlBuilder.lastIndexOf(","));
        sqlBuilder.append(")");
        String sql = "select fbaseunit, fmaterialid,b.fprocessentryid,c.fheadqty,c.fheadunitid,c.foperationqty, b.foprunitid from t_pom_mftorderentry_m a left join t_pom_manftechentry b on a.fid = b.fid left join t_pom_manftechentry_e c on b.fprocessentryid = c.fprocessentryid where c.fprocessentryid in";
        try (DataSet resources = DB.queryDataSet((String)"getRatio", (DBRoute)scmRoute, (String)(sql + sqlBuilder), (Object[])params);){
            while (resources.hasNext()) {
                Row row = resources.next();
                HashMap<String, Object> map1 = new HashMap<String, Object>(16);
                map1.put("fprocessentryid", row.getString("fprocessentryid"));
                map1.put("fbaseunit", row.getLong("fbaseunit"));
                map1.put("fmaterialid", row.getLong("fmaterialid"));
                map1.put("foprunitid", row.getLong("foprunitid"));
                map1.put("fheadunitid", row.getLong("fheadunitid"));
                map1.put("fheadqty", row.getBigDecimal("fheadqty"));
                map1.put("foperationqty", row.getBigDecimal("foperationqty"));
                map.put(row.getString("fprocessentryid"), map1);
            }
        }
        return map;
    }

    private Map<String, Map<String, Long>> getUnitId(DBRoute scmRoute, List<Long> entryIds) {
        HashMap<String, Map<String, Long>> map = new HashMap<String, Map<String, Long>>(256);
        if (CollectionUtils.isEmpty(entryIds)) {
            return map;
        }
        Object[] params = new Object[entryIds.size()];
        StringBuilder sqlBuilder = new StringBuilder();
        sqlBuilder.append("(");
        for (int i = 0; i < entryIds.size(); ++i) {
            sqlBuilder.append("?,");
            params[i] = entryIds.get(i);
        }
        sqlBuilder.deleteCharAt(sqlBuilder.lastIndexOf(","));
        sqlBuilder.append(")");
        String sql = "select fentryid, funit, fbaseunit, fmaterielmasterid from t_pom_mftorderentry where fentryid in ";
        try (DataSet resources = DB.queryDataSet((String)"getUnitId", (DBRoute)scmRoute, (String)(sql + sqlBuilder), (Object[])params);){
            while (resources.hasNext()) {
                Row row = resources.next();
                HashMap<String, Long> map1 = new HashMap<String, Long>(16);
                map1.put("fentryid", row.getLong("fentryid"));
                map1.put("funit", row.getLong("funit"));
                map1.put("fbaseunit", row.getLong("fbaseunit"));
                map1.put("fmaterielmasterid", row.getLong("fmaterielmasterid"));
                map.put(row.getString("fentryid"), map1);
            }
        }
        return map;
    }

    private BigDecimal getQty(Map<String, Long> object, BigDecimal qty) {
        BigDecimal bigDecimal;
        try {
            bigDecimal = UnitConvertHelper.calculateNewQty((BigDecimal)qty, (Long)object.get("funit"), (Long)object.get("fbaseunit"), (Long)object.get("fmaterielmasterid"), (StringBuilder)new StringBuilder());
        }
        catch (Throwable throwable) {
            return BigDecimal.ZERO;
        }
        return bigDecimal;
    }
}

