/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.sfc.mservice.upgrade;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.mmc.sfc.mservice.upgrade.utils.BaseQytUtils;
import org.apache.commons.collections4.CollectionUtils;

public class ReportBaseQtyUpgradeServiceImpl
implements IUpgradeService {
    private static Log logger = LogFactory.getLog(ReportBaseQtyUpgradeServiceImpl.class);

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        DBRoute scmRoute = new DBRoute("scm");
        String sql = "select a.fentryid,a.fcompletqty,a.fqualifyqty,a.freceiveqty,a.fworkwasteqty,a.fscrapqty,a.fjunkqty,a.frepairqty,a.fcheckreworkqty,c.fheadqty,c.fheadunitid,c.foperationqty,b.foprunitid,d.fmaterielmasterid,d.fbaseunit from t_sfc_processrptent a inner join t_pom_manftechentry b on a.foprentryid = CONCAT(b.fprocessentryid,'') inner join t_pom_manftechentry_e c on b.fprocessentryid = c.fprocessentryid inner join t_pom_mftorderentry d on a.fmanufactureentryid = d.fentryid;";
        try (DataSet srcEntryId = DB.queryDataSet((String)this.getClass().getName(), (DBRoute)scmRoute, (String)sql);){
            HashMap<Long, Map> resultMap = new HashMap<Long, Map>(256);
            while (srcEntryId.hasNext()) {
                Row row = srcEntryId.next();
                HashMap<String, Number> map = new HashMap<String, Number>(32);
                map.put("fbaseunit", row.getLong("fbaseunit"));
                map.put("fmaterialid", row.getLong("fmaterielmasterid"));
                map.put("foprunitid", row.getLong("foprunitid"));
                map.put("foperationqty", row.getBigDecimal("foperationqty"));
                map.put("fheadunitid", row.getLong("fheadunitid"));
                map.put("fheadqty", row.getBigDecimal("fheadqty"));
                map.put("fentryid", row.getLong("fentryid"));
                map.put("fcompletqty", row.getBigDecimal("fcompletqty"));
                map.put("fqualifyqty", row.getBigDecimal("fqualifyqty"));
                map.put("freceiveqty", row.getBigDecimal("freceiveqty"));
                map.put("fworkwasteqty", row.getBigDecimal("fworkwasteqty"));
                map.put("fscrapqty", row.getBigDecimal("fscrapqty"));
                map.put("fjunkqty", row.getBigDecimal("fjunkqty"));
                map.put("frepairqty", row.getBigDecimal("frepairqty"));
                map.put("fcheckreworkqty", row.getBigDecimal("fcheckreworkqty"));
                resultMap.put(row.getLong("fentryid"), map);
            }
            String updateInvTypeSql = "update t_sfc_processrptent set fcompletbaseqty  = ?,fqualifybaseqty = ?,freceivebaseqty  = ?,fworkwastebaseqty = ?,fscrapbaseqty  = ?,fjunkbaseqty = ? ,frepairbaseqty = ?,fcheckreworkbaseqty = ? where fentryid = ?";
            ArrayList paramsList = new ArrayList(10);
            resultMap.forEach((k, v) -> {
                BigDecimal completQty = BaseQytUtils.getBaseQty(v, (BigDecimal)v.get("fcompletqty"));
                BigDecimal qualifyQty = BaseQytUtils.getBaseQty(v, (BigDecimal)v.get("fqualifyqty"));
                BigDecimal receiveQty = BaseQytUtils.getBaseQty(v, (BigDecimal)v.get("freceiveqty"));
                BigDecimal workWasteQty = BaseQytUtils.getBaseQty(v, (BigDecimal)v.get("fworkwasteqty"));
                BigDecimal scrapQty = BaseQytUtils.getBaseQty(v, (BigDecimal)v.get("fscrapqty"));
                BigDecimal junkQty = BaseQytUtils.getBaseQty(v, (BigDecimal)v.get("fjunkqty"));
                BigDecimal repairQty = BaseQytUtils.getBaseQty(v, (BigDecimal)v.get("frepairqty"));
                BigDecimal checkReworkQty = BaseQytUtils.getBaseQty(v, (BigDecimal)v.get("fcheckreworkqty"));
                paramsList.add(new Object[]{completQty, qualifyQty, receiveQty, workWasteQty, scrapQty, junkQty, repairQty, checkReworkQty, k});
            });
            if (CollectionUtils.isNotEmpty(paramsList)) {
                List partition = Lists.partition(paramsList, (int)1000);
                for (List objects : partition) {
                    BaseQytUtils.batchUpdate(scmRoute, objects, updateInvTypeSql);
                }
            }
        }
        result.setSuccess(true);
        return result;
    }
}

