/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.sfc.mservice.upgrade;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.bos.thread.ThreadLifeCycleManager;
import kd.bos.threads.ThreadPools;
import org.apache.commons.collections4.CollectionUtils;

public class ResourcesUpgradeServiceImpl
implements IUpgradeService {
    private static Log logger = LogFactory.getLog(ResourcesUpgradeServiceImpl.class);

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        DBRoute scmRoute = new DBRoute("scm");
        try (DataSet srcEntryId = DB.queryDataSet((String)this.getClass().getName(), (DBRoute)scmRoute, (String)"select fsrcentryid from t_pom_manftrepsubentry where frepresources = 0 and fsrcentryid is not null and fsrcentryid <>' '");){
            Row row;
            ArrayList<Long> ids = new ArrayList<Long>(10);
            while (srcEntryId.hasNext()) {
                row = srcEntryId.next();
                ids.add(row.getLong("fsrcentryid"));
            }
            if (CollectionUtils.isEmpty(ids)) {
                logger.info("select fsrcentryid from t_pom_manftrepsubentry is empty.");
                row = null;
                return row;
            }
            StringBuilder sqlBuilder = new StringBuilder();
            sqlBuilder.append("(");
            Object[] params = new Object[ids.size()];
            for (int i = 0; i < ids.size(); ++i) {
                sqlBuilder.append("?,");
                params[i] = ids.get(i);
            }
            sqlBuilder.deleteCharAt(sqlBuilder.lastIndexOf(","));
            sqlBuilder.append(")");
            String updateInvTypeSql = "update t_pom_manftrepsubentry set frepresources  = ? where fsrcentryid = ?";
            ArrayList<Object[]> paramsList = new ArrayList<Object[]>(10);
            DataSet resources = DB.queryDataSet((String)this.getClass().getName(), (DBRoute)scmRoute, (String)("SELECT FDetailID,frepresources FROM t_sfc_subreportactivity where frepresources <> 0 and frepresources is not null and FDetailID in" + sqlBuilder), (Object[])params);
            Object object = null;
            try {
                while (resources.hasNext()) {
                    Row row2 = resources.next();
                    Long id = row2.getLong("FDetailID");
                    Long resourcesId = row2.getLong("frepresources");
                    if (!ids.contains(id)) continue;
                    paramsList.add(new Object[]{resourcesId, id.toString()});
                }
            }
            catch (Throwable row2) {
                object = row2;
                throw row2;
            }
            finally {
                if (resources != null) {
                    if (object != null) {
                        try {
                            resources.close();
                        }
                        catch (Throwable row2) {
                            ((Throwable)object).addSuppressed(row2);
                        }
                    } else {
                        resources.close();
                    }
                }
            }
            if (CollectionUtils.isNotEmpty(paramsList)) {
                List partition = Lists.partition(paramsList, (int)1000);
                for (List objects : partition) {
                    this.batchUpdate(scmRoute, objects, updateInvTypeSql);
                }
            }
        }
        result.setSuccess(true);
        result.setLog("data update successfully.");
        return result;
    }

    private void batchUpdate(DBRoute scmRoute, List<Object[]> objects, String updateInvTypeSql) {
        ThreadPools.executeOnceIncludeRequestContext((String)"ResourcesUpgradeServiceImpl", (Runnable)ThreadLifeCycleManager.wrapRunnable(() -> DB.executeBatch((DBRoute)scmRoute, (String)updateInvTypeSql, (List)objects)));
    }
}

