/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.sfc.mservice.upgrade;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.bos.thread.ThreadLifeCycleManager;
import kd.bos.threads.ThreadPools;
import kd.mmc.sfc.mservice.upgrade.utils.BaseQytUtils;
import org.apache.commons.collections4.CollectionUtils;

public class SplitManuftechUpgradeServiceImpl
implements IUpgradeService {
    private static Log logger = LogFactory.getLog(SplitManuftechUpgradeServiceImpl.class);

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        DBRoute scmRoute = new DBRoute("scm");
        try (DataSet srcEntryId = DB.queryDataSet((String)this.getClass().getName(), (DBRoute)scmRoute, (String)"select a.forderentryid,b.fsplitbaseqty from t_pom_splitlog a left join t_pom_splitentry b on a.fid = b.fid where a.forderstatus = 'C'");){
            Row row;
            HashMap<Long, Object> map = new HashMap<Long, Object>(16);
            HashSet<Long> mftorderEntryIds = new HashSet<Long>(16);
            while (srcEntryId.hasNext()) {
                row = srcEntryId.next();
                long orderentryid = row.getLong("forderentryid");
                Object tempQty = null == map.get(orderentryid) ? BigDecimal.ZERO : (BigDecimal)map.get(orderentryid);
                tempQty = ((BigDecimal)tempQty).add(row.getBigDecimal("fsplitbaseqty"));
                map.put(orderentryid, tempQty);
                mftorderEntryIds.add(orderentryid);
            }
            if (CollectionUtils.isEmpty(mftorderEntryIds)) {
                logger.info("select forderentryid from t_pom_splitlog is empty.");
                row = null;
                return row;
            }
            HashMap<Long, Map> resultMap = new HashMap<Long, Map>(256);
            StringBuilder msb = new StringBuilder();
            int index = 0;
            for (Long mftorderEntryId : mftorderEntryIds) {
                if (++index == mftorderEntryIds.size()) {
                    msb.append(mftorderEntryId);
                    continue;
                }
                msb.append(mftorderEntryId);
                msb.append(",");
            }
            String sql = "select a.fmftentryseq,a.fbaseunit,a.fmaterialid,b.foprunitid,c.foperationqty,c.fheadunitid,c.fheadqty,b.fprocessentryid from t_pom_mftorderentry_m a inner join t_pom_manftechentry b on a.fid = b.fid inner join t_pom_manftechentry_e c on b.fprocessentryid = c.fprocessentryid where a.fmftentryseq in (" + msb + ");";
            try (DataSet oprEntryInfo = DB.queryDataSet((String)this.getClass().getName(), (DBRoute)scmRoute, (String)sql);){
                while (oprEntryInfo.hasNext()) {
                    Row row2 = oprEntryInfo.next();
                    HashMap<String, Number> oprMap = new HashMap<String, Number>(32);
                    oprMap.put("fbaseunit", row2.getLong("fbaseunit"));
                    oprMap.put("fmaterialid", row2.getLong("fmaterialid"));
                    oprMap.put("foprunitid", row2.getLong("foprunitid"));
                    oprMap.put("foperationqty", row2.getBigDecimal("foperationqty"));
                    oprMap.put("fheadunitid", row2.getLong("fheadunitid"));
                    oprMap.put("fheadqty", row2.getBigDecimal("fheadqty"));
                    BigDecimal splitBaseQty = map.containsKey(row2.getLong("fmftentryseq")) ? (BigDecimal)map.get(row2.getLong("fmftentryseq")) : BigDecimal.ZERO;
                    oprMap.put("splitBaseQty", splitBaseQty);
                    resultMap.put(row2.getLong("fprocessentryid"), oprMap);
                }
            }
            String updateInvTypeSql = "update t_pom_manftechentry set ftotalsplitqty = ?,foprtotalsplitbaseqty = ? where fprocessentryid  = ?";
            ArrayList paramsList = new ArrayList(10);
            resultMap.forEach((k, v) -> {
                BigDecimal oprSplitBaseQty = (BigDecimal)v.get("splitBaseQty");
                BigDecimal oprSplitQty = BaseQytUtils.getOprQty(v, oprSplitBaseQty);
                paramsList.add(new Object[]{oprSplitQty, oprSplitBaseQty, k});
            });
            if (CollectionUtils.isNotEmpty(paramsList)) {
                List partition = Lists.partition(paramsList, (int)1000);
                for (List objects : partition) {
                    this.batchUpdate(scmRoute, objects, updateInvTypeSql);
                }
            }
        }
        result.setSuccess(true);
        result.setLog("data update successfully.");
        return result;
    }

    private void batchUpdate(DBRoute scmRoute, List<Object[]> objects, String updateInvTypeSql) {
        ThreadPools.executeOnceIncludeRequestContext((String)"SplitManuftechUpgradeServiceImpl", (Runnable)ThreadLifeCycleManager.wrapRunnable(() -> DB.executeBatch((DBRoute)scmRoute, (String)updateInvTypeSql, (List)objects)));
    }
}

